# Generated by Django 3.2.11 on 2022-02-23 18:42

import uuid

import _socket
import django.contrib.sites.managers
import django.core.validators
import django.db.models.deletion
import django_audit_fields.fields.hostname_modification_field
import django_audit_fields.fields.userfield
import django_audit_fields.fields.uuid_auto_field
import django_audit_fields.models.audit_model_mixin
import django_revision.revision_field
import edc_model.models.fields.other_charfield
import edc_model.validators.date
import edc_protocol.validators
import edc_utils.date
import edc_visit_tracking.managers
import simple_history.models
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):
    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("sites", "0002_alter_domain_unique"),
        ("effect_subject", "0006_auto_20220215_1649"),
    ]

    operations = [
        migrations.AlterField(
            model_name="historicalmentalstatus",
            name="modified_rankin_score",
            field=models.CharField(
                choices=[
                    ("0", "[0] No symptoms"),
                    (
                        "1",
                        "[1] No significant disability. Able to carry out usual activities, despite some symptoms.",
                    ),
                    (
                        "2",
                        "[2] Slight disability. Able to look after own affairs without assistance, but unable to carry out all previous activities.",
                    ),
                    (
                        "3",
                        "[3] Moderate disability. Requires some help, but able to walk unassisted.",
                    ),
                    (
                        "4",
                        "[4] Moderately severe disability. Unable to attend to own bodily needs without assistance, and unable to walk unassisted.",
                    ),
                    (
                        "5",
                        "[5] Severe disability. Requires constant nursing care and attention, bedridden, incontinent.",
                    ),
                    ("6", "[6] Dead"),
                    ("not_done", "Not done"),
                ],
                max_length=15,
                verbose_name="Modified Rankin Score",
            ),
        ),
        migrations.AlterField(
            model_name="mentalstatus",
            name="modified_rankin_score",
            field=models.CharField(
                choices=[
                    ("0", "[0] No symptoms"),
                    (
                        "1",
                        "[1] No significant disability. Able to carry out usual activities, despite some symptoms.",
                    ),
                    (
                        "2",
                        "[2] Slight disability. Able to look after own affairs without assistance, but unable to carry out all previous activities.",
                    ),
                    (
                        "3",
                        "[3] Moderate disability. Requires some help, but able to walk unassisted.",
                    ),
                    (
                        "4",
                        "[4] Moderately severe disability. Unable to attend to own bodily needs without assistance, and unable to walk unassisted.",
                    ),
                    (
                        "5",
                        "[5] Severe disability. Requires constant nursing care and attention, bedridden, incontinent.",
                    ),
                    ("6", "[6] Dead"),
                    ("not_done", "Not done"),
                ],
                max_length=15,
                verbose_name="Modified Rankin Score",
            ),
        ),
        migrations.CreateModel(
            name="Microbiology",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "sputum_afb_performed",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="Was sputum AFB done?",
                        max_length=5,
                        verbose_name="AFB microscopy performed?",
                    ),
                ),
                (
                    "sputum_afb_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[
                            edc_protocol.validators.date_not_before_study_start,
                            edc_model.validators.date.date_not_future,
                        ],
                    ),
                ),
                (
                    "sputum_afb_result",
                    models.CharField(
                        choices=[
                            ("POS", "Positive"),
                            ("NEG", "Negative"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=10,
                        verbose_name="AFB results",
                    ),
                ),
                (
                    "sputum_culture_performed",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        max_length=15,
                        verbose_name="Culture performed?",
                    ),
                ),
                (
                    "sputum_culture_taken_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[
                            edc_protocol.validators.date_not_before_study_start,
                            edc_model.validators.date.date_not_future,
                        ],
                    ),
                ),
                (
                    "sputum_culture_result",
                    models.CharField(
                        choices=[
                            ("POS", "MTB Positive"),
                            ("NEG", "MTB Negative"),
                            ("IND", "Contaminated/indeterminate"),
                        ],
                        default="N/A",
                        max_length=10,
                        verbose_name="Culture results",
                    ),
                ),
                (
                    "sputum_culture_pos_description",
                    models.CharField(
                        blank=True,
                        max_length=50,
                        null=True,
                        verbose_name="If Culture is positive, please specify:",
                    ),
                ),
                (
                    "sputum_genexpert_performed",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        max_length=15,
                        verbose_name="Sputum Gene-Xpert performed?",
                    ),
                ),
                (
                    "sputum_genexpert_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[
                            edc_protocol.validators.date_not_before_study_start,
                            edc_model.validators.date.date_not_future,
                        ],
                        verbose_name="Date sputum Gene-Xpert taken",
                    ),
                ),
                (
                    "sputum_genexpert_result",
                    models.CharField(
                        choices=[
                            (
                                "mtb_detected_rif_resistance_detected",
                                "MTB DETECTED & Rif Resistance DETECTED",
                            ),
                            (
                                "mtb_detected_rif_resistance_not_detected",
                                "MTB DETECTED & Rif Resistance NOT detected",
                            ),
                            (
                                "mtb_detected_rif_resistance_indeterminate",
                                "MTB DETECTED & Rif Resistance INDETERMINATE",
                            ),
                            ("mtb_not_detected", "MTB NOT detected"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=45,
                        verbose_name="Sputum Gene-Xpert results",
                    ),
                ),
                (
                    "urinary_lam_performed",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Urinary LAM performed?",
                    ),
                ),
                (
                    "urinary_lam_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[
                            edc_protocol.validators.date_not_before_study_start,
                            edc_model.validators.date.date_not_future,
                        ],
                    ),
                ),
                (
                    "urinary_lam_result",
                    models.CharField(
                        choices=[
                            ("POS", "Positive"),
                            ("NEG", "Negative"),
                            ("N/A", "Not applicable"),
                        ],
                        max_length=25,
                        verbose_name="Urinary LAM result",
                    ),
                ),
                (
                    "urinary_lam_result_grade",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("1", "1+ (low)"),
                            ("2", "2+"),
                            ("3", "3+"),
                            ("4", "4+"),
                            ("5", "5+ (high)"),
                            ("unknown", "Unknown"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="If Urinary LAM is positive, grade",
                    ),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default="COMPLETE",
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "comment",
                    models.TextField(
                        blank=True, null=True, verbose_name="Any additional comment"
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="effect_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "Microbiology",
                "verbose_name_plural": "Microbiology",
                "ordering": ("-modified", "-created"),
                "get_latest_by": "modified",
                "abstract": False,
                "default_permissions": ("add", "change", "delete", "view", "export", "import"),
            },
            managers=[
                ("on_site", django.contrib.sites.managers.CurrentSiteManager()),
                ("objects", edc_visit_tracking.managers.CrfModelManager()),
            ],
        ),
        migrations.CreateModel(
            name="LpCsf",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                (
                    "bios_crag",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        help_text="Gaborone and Blantyre only",
                        max_length=5,
                        verbose_name="Biosynex Semi-quantitative CrAg performed?",
                    ),
                ),
                (
                    "crag_control_result",
                    models.CharField(
                        choices=[
                            ("POS", "Positive"),
                            ("NEG", "Negative"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        help_text="Gaborone and Blantyre only",
                        max_length=5,
                        verbose_name="Control result",
                    ),
                ),
                (
                    "crag_t1_result",
                    models.CharField(
                        choices=[
                            ("POS", "Positive"),
                            ("NEG", "Negative"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        help_text="Gaborone and Blantyre only",
                        max_length=5,
                        verbose_name="T1 result",
                    ),
                ),
                (
                    "crag_t2_result",
                    models.CharField(
                        choices=[
                            ("POS", "Positive"),
                            ("NEG", "Negative"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        help_text="Gaborone and Blantyre only",
                        max_length=5,
                        verbose_name="T2 result",
                    ),
                ),
                (
                    "csf_assay_datetime",
                    models.DateTimeField(
                        blank=True,
                        null=True,
                        validators=[edc_model.validators.date.datetime_not_future],
                        verbose_name="CSF Result Report Date and Time",
                    ),
                ),
                (
                    "csf_culture",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("awaiting_results", "Awaiting results"),
                            ("not_done", "Not done"),
                        ],
                        default="awaiting_results",
                        help_text="Complete after getting the results.",
                        max_length=18,
                        verbose_name="Other organism (non-Cryptococcus)",
                    ),
                ),
                (
                    "other_csf_culture",
                    models.CharField(
                        blank=True,
                        max_length=75,
                        null=True,
                        verbose_name="If YES, specify organism:",
                    ),
                ),
                (
                    "csf_wbc_cell_count",
                    models.IntegerField(
                        blank=True,
                        help_text="acceptable units are mm<sup>3</sup>",
                        null=True,
                        validators=[django.core.validators.MinValueValidator(0)],
                        verbose_name="Total CSF WBC cell count:",
                    ),
                ),
                (
                    "differential_lymphocyte_count",
                    models.IntegerField(
                        blank=True,
                        help_text="acceptable units are mm<sup>3</sup> or %",
                        null=True,
                        validators=[django.core.validators.MinValueValidator(0)],
                        verbose_name="Differential lymphocyte cell count:",
                    ),
                ),
                (
                    "differential_lymphocyte_unit",
                    models.CharField(
                        blank=True,
                        choices=[("mm3", "mm<sup>3</sup>"), ("%", "%")],
                        max_length=6,
                        null=True,
                    ),
                ),
                (
                    "differential_neutrophil_count",
                    models.IntegerField(
                        blank=True,
                        help_text="acceptable units are mm<sup>3</sup> or %",
                        null=True,
                        validators=[django.core.validators.MinValueValidator(0)],
                        verbose_name="Differential neutrophil cell count:",
                    ),
                ),
                (
                    "differential_neutrophil_unit",
                    models.CharField(
                        blank=True,
                        choices=[("mm3", "mm<sup>3</sup>"), ("%", "%")],
                        max_length=6,
                        null=True,
                    ),
                ),
                (
                    "india_ink",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("POS", "Positive"),
                            ("NEG", "Negative"),
                            ("IND", "Indeterminate"),
                        ],
                        max_length=15,
                        null=True,
                    ),
                ),
                (
                    "csf_glucose",
                    models.DecimalField(
                        blank=True,
                        decimal_places=1,
                        help_text="Units in mmol/L or mg/dL",
                        max_digits=3,
                        null=True,
                        verbose_name="CSF glucose:",
                    ),
                ),
                (
                    "csf_glucose_units",
                    models.CharField(
                        blank=True,
                        choices=[("mg/dL", "mg/dL"), ("mmol/L", "mmol/L (millimoles/L)")],
                        max_length=6,
                        null=True,
                        verbose_name="CSF glucose units:",
                    ),
                ),
                (
                    "csf_protein",
                    models.DecimalField(
                        blank=True,
                        decimal_places=2,
                        help_text="Units in g/L",
                        max_digits=4,
                        null=True,
                        verbose_name="CSF protein:",
                    ),
                ),
                (
                    "csf_cr_ag",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("POS", "Positive"),
                            ("NEG", "Negative"),
                            ("IND", "Indeterminate"),
                        ],
                        max_length=15,
                        null=True,
                        verbose_name="CSF CrAg:",
                    ),
                ),
                (
                    "csf_cr_ag_lfa",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        max_length=5,
                        verbose_name="CSF CrAg done by IMMY CrAg LFA:",
                    ),
                ),
                (
                    "qc_assay_datetime",
                    models.DateTimeField(
                        blank=True,
                        null=True,
                        validators=[edc_model.validators.date.datetime_not_future],
                        verbose_name="QC Result Report Date and Time",
                    ),
                ),
                (
                    "quantitative_culture",
                    models.IntegerField(
                        blank=True,
                        help_text="Units CFU/ml",
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(100000000),
                        ],
                    ),
                ),
                (
                    "lp_datetime",
                    models.DateTimeField(
                        validators=[edc_model.validators.date.datetime_not_future],
                        verbose_name="LP Date and Time",
                    ),
                ),
                (
                    "reason_for_lp",
                    models.CharField(
                        choices=[
                            ("scheduled_per_protocol", "Scheduled per protocol"),
                            ("therapeutic_lp", "Therapeutic LP"),
                            ("clincal_deterioration", "Clinical deterioration"),
                        ],
                        max_length=50,
                        verbose_name="Reason for LP",
                    ),
                ),
                (
                    "opening_pressure",
                    models.IntegerField(
                        help_text="Units cm of H<sub>2</sub>O",
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(99),
                        ],
                    ),
                ),
                (
                    "closing_pressure",
                    models.IntegerField(
                        blank=True,
                        help_text="Units cm of H<sub>2</sub>O",
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(99),
                        ],
                    ),
                ),
                (
                    "csf_amount_removed",
                    models.IntegerField(
                        blank=True,
                        help_text="Units ml",
                        null=True,
                        validators=[django.core.validators.MinValueValidator(1)],
                        verbose_name="CSF amount removed ",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default="COMPLETE",
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "csf_requisition",
                    models.ForeignKey(
                        blank=True,
                        help_text="Start typing the requisition identifier or select one from this visit",
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="csfrequisition",
                        to="effect_subject.subjectrequisition",
                        verbose_name="CSF Requisition",
                    ),
                ),
                (
                    "qc_requisition",
                    models.ForeignKey(
                        blank=True,
                        help_text="Start typing the requisition identifier or select one from this visit",
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="qcrequisition",
                        to="effect_subject.subjectrequisition",
                        verbose_name="QC Requisition",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="effect_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "Lumbar Puncture/CSF",
                "verbose_name_plural": "Lumbar Puncture/CSF",
                "ordering": ("-modified", "-created"),
                "get_latest_by": "modified",
                "abstract": False,
                "default_permissions": ("add", "change", "delete", "view", "export", "import"),
            },
            managers=[
                ("on_site", django.contrib.sites.managers.CurrentSiteManager()),
                ("objects", edc_visit_tracking.managers.CrfModelManager()),
            ],
        ),
        migrations.CreateModel(
            name="HistoricalMicrobiology",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "sputum_afb_performed",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="Was sputum AFB done?",
                        max_length=5,
                        verbose_name="AFB microscopy performed?",
                    ),
                ),
                (
                    "sputum_afb_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[
                            edc_protocol.validators.date_not_before_study_start,
                            edc_model.validators.date.date_not_future,
                        ],
                    ),
                ),
                (
                    "sputum_afb_result",
                    models.CharField(
                        choices=[
                            ("POS", "Positive"),
                            ("NEG", "Negative"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=10,
                        verbose_name="AFB results",
                    ),
                ),
                (
                    "sputum_culture_performed",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        max_length=15,
                        verbose_name="Culture performed?",
                    ),
                ),
                (
                    "sputum_culture_taken_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[
                            edc_protocol.validators.date_not_before_study_start,
                            edc_model.validators.date.date_not_future,
                        ],
                    ),
                ),
                (
                    "sputum_culture_result",
                    models.CharField(
                        choices=[
                            ("POS", "MTB Positive"),
                            ("NEG", "MTB Negative"),
                            ("IND", "Contaminated/indeterminate"),
                        ],
                        default="N/A",
                        max_length=10,
                        verbose_name="Culture results",
                    ),
                ),
                (
                    "sputum_culture_pos_description",
                    models.CharField(
                        blank=True,
                        max_length=50,
                        null=True,
                        verbose_name="If Culture is positive, please specify:",
                    ),
                ),
                (
                    "sputum_genexpert_performed",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        max_length=15,
                        verbose_name="Sputum Gene-Xpert performed?",
                    ),
                ),
                (
                    "sputum_genexpert_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[
                            edc_protocol.validators.date_not_before_study_start,
                            edc_model.validators.date.date_not_future,
                        ],
                        verbose_name="Date sputum Gene-Xpert taken",
                    ),
                ),
                (
                    "sputum_genexpert_result",
                    models.CharField(
                        choices=[
                            (
                                "mtb_detected_rif_resistance_detected",
                                "MTB DETECTED & Rif Resistance DETECTED",
                            ),
                            (
                                "mtb_detected_rif_resistance_not_detected",
                                "MTB DETECTED & Rif Resistance NOT detected",
                            ),
                            (
                                "mtb_detected_rif_resistance_indeterminate",
                                "MTB DETECTED & Rif Resistance INDETERMINATE",
                            ),
                            ("mtb_not_detected", "MTB NOT detected"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=45,
                        verbose_name="Sputum Gene-Xpert results",
                    ),
                ),
                (
                    "urinary_lam_performed",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Urinary LAM performed?",
                    ),
                ),
                (
                    "urinary_lam_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[
                            edc_protocol.validators.date_not_before_study_start,
                            edc_model.validators.date.date_not_future,
                        ],
                    ),
                ),
                (
                    "urinary_lam_result",
                    models.CharField(
                        choices=[
                            ("POS", "Positive"),
                            ("NEG", "Negative"),
                            ("N/A", "Not applicable"),
                        ],
                        max_length=25,
                        verbose_name="Urinary LAM result",
                    ),
                ),
                (
                    "urinary_lam_result_grade",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("1", "1+ (low)"),
                            ("2", "2+"),
                            ("3", "3+"),
                            ("4", "4+"),
                            ("5", "5+ (high)"),
                            ("unknown", "Unknown"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="If Urinary LAM is positive, grade",
                    ),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False
                    ),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default="COMPLETE",
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "comment",
                    models.TextField(
                        blank=True, null=True, verbose_name="Any additional comment"
                    ),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="effect_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Microbiology",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalLpCsf",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                (
                    "bios_crag",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        help_text="Gaborone and Blantyre only",
                        max_length=5,
                        verbose_name="Biosynex Semi-quantitative CrAg performed?",
                    ),
                ),
                (
                    "crag_control_result",
                    models.CharField(
                        choices=[
                            ("POS", "Positive"),
                            ("NEG", "Negative"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        help_text="Gaborone and Blantyre only",
                        max_length=5,
                        verbose_name="Control result",
                    ),
                ),
                (
                    "crag_t1_result",
                    models.CharField(
                        choices=[
                            ("POS", "Positive"),
                            ("NEG", "Negative"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        help_text="Gaborone and Blantyre only",
                        max_length=5,
                        verbose_name="T1 result",
                    ),
                ),
                (
                    "crag_t2_result",
                    models.CharField(
                        choices=[
                            ("POS", "Positive"),
                            ("NEG", "Negative"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        help_text="Gaborone and Blantyre only",
                        max_length=5,
                        verbose_name="T2 result",
                    ),
                ),
                (
                    "csf_assay_datetime",
                    models.DateTimeField(
                        blank=True,
                        null=True,
                        validators=[edc_model.validators.date.datetime_not_future],
                        verbose_name="CSF Result Report Date and Time",
                    ),
                ),
                (
                    "csf_culture",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("awaiting_results", "Awaiting results"),
                            ("not_done", "Not done"),
                        ],
                        default="awaiting_results",
                        help_text="Complete after getting the results.",
                        max_length=18,
                        verbose_name="Other organism (non-Cryptococcus)",
                    ),
                ),
                (
                    "other_csf_culture",
                    models.CharField(
                        blank=True,
                        max_length=75,
                        null=True,
                        verbose_name="If YES, specify organism:",
                    ),
                ),
                (
                    "csf_wbc_cell_count",
                    models.IntegerField(
                        blank=True,
                        help_text="acceptable units are mm<sup>3</sup>",
                        null=True,
                        validators=[django.core.validators.MinValueValidator(0)],
                        verbose_name="Total CSF WBC cell count:",
                    ),
                ),
                (
                    "differential_lymphocyte_count",
                    models.IntegerField(
                        blank=True,
                        help_text="acceptable units are mm<sup>3</sup> or %",
                        null=True,
                        validators=[django.core.validators.MinValueValidator(0)],
                        verbose_name="Differential lymphocyte cell count:",
                    ),
                ),
                (
                    "differential_lymphocyte_unit",
                    models.CharField(
                        blank=True,
                        choices=[("mm3", "mm<sup>3</sup>"), ("%", "%")],
                        max_length=6,
                        null=True,
                    ),
                ),
                (
                    "differential_neutrophil_count",
                    models.IntegerField(
                        blank=True,
                        help_text="acceptable units are mm<sup>3</sup> or %",
                        null=True,
                        validators=[django.core.validators.MinValueValidator(0)],
                        verbose_name="Differential neutrophil cell count:",
                    ),
                ),
                (
                    "differential_neutrophil_unit",
                    models.CharField(
                        blank=True,
                        choices=[("mm3", "mm<sup>3</sup>"), ("%", "%")],
                        max_length=6,
                        null=True,
                    ),
                ),
                (
                    "india_ink",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("POS", "Positive"),
                            ("NEG", "Negative"),
                            ("IND", "Indeterminate"),
                        ],
                        max_length=15,
                        null=True,
                    ),
                ),
                (
                    "csf_glucose",
                    models.DecimalField(
                        blank=True,
                        decimal_places=1,
                        help_text="Units in mmol/L or mg/dL",
                        max_digits=3,
                        null=True,
                        verbose_name="CSF glucose:",
                    ),
                ),
                (
                    "csf_glucose_units",
                    models.CharField(
                        blank=True,
                        choices=[("mg/dL", "mg/dL"), ("mmol/L", "mmol/L (millimoles/L)")],
                        max_length=6,
                        null=True,
                        verbose_name="CSF glucose units:",
                    ),
                ),
                (
                    "csf_protein",
                    models.DecimalField(
                        blank=True,
                        decimal_places=2,
                        help_text="Units in g/L",
                        max_digits=4,
                        null=True,
                        verbose_name="CSF protein:",
                    ),
                ),
                (
                    "csf_cr_ag",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("POS", "Positive"),
                            ("NEG", "Negative"),
                            ("IND", "Indeterminate"),
                        ],
                        max_length=15,
                        null=True,
                        verbose_name="CSF CrAg:",
                    ),
                ),
                (
                    "csf_cr_ag_lfa",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        max_length=5,
                        verbose_name="CSF CrAg done by IMMY CrAg LFA:",
                    ),
                ),
                (
                    "qc_assay_datetime",
                    models.DateTimeField(
                        blank=True,
                        null=True,
                        validators=[edc_model.validators.date.datetime_not_future],
                        verbose_name="QC Result Report Date and Time",
                    ),
                ),
                (
                    "quantitative_culture",
                    models.IntegerField(
                        blank=True,
                        help_text="Units CFU/ml",
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(100000000),
                        ],
                    ),
                ),
                (
                    "lp_datetime",
                    models.DateTimeField(
                        validators=[edc_model.validators.date.datetime_not_future],
                        verbose_name="LP Date and Time",
                    ),
                ),
                (
                    "reason_for_lp",
                    models.CharField(
                        choices=[
                            ("scheduled_per_protocol", "Scheduled per protocol"),
                            ("therapeutic_lp", "Therapeutic LP"),
                            ("clincal_deterioration", "Clinical deterioration"),
                        ],
                        max_length=50,
                        verbose_name="Reason for LP",
                    ),
                ),
                (
                    "opening_pressure",
                    models.IntegerField(
                        help_text="Units cm of H<sub>2</sub>O",
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(99),
                        ],
                    ),
                ),
                (
                    "closing_pressure",
                    models.IntegerField(
                        blank=True,
                        help_text="Units cm of H<sub>2</sub>O",
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(99),
                        ],
                    ),
                ),
                (
                    "csf_amount_removed",
                    models.IntegerField(
                        blank=True,
                        help_text="Units ml",
                        null=True,
                        validators=[django.core.validators.MinValueValidator(1)],
                        verbose_name="CSF amount removed ",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False
                    ),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default="COMPLETE",
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "csf_requisition",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        help_text="Start typing the requisition identifier or select one from this visit",
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="effect_subject.subjectrequisition",
                        verbose_name="CSF Requisition",
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "qc_requisition",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        help_text="Start typing the requisition identifier or select one from this visit",
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="effect_subject.subjectrequisition",
                        verbose_name="QC Requisition",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="effect_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Lumbar Puncture/CSF",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalHistopathology",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "tissue_biopsy_taken",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=5,
                        verbose_name="Was a tissue biopsy taken",
                    ),
                ),
                (
                    "tissue_biopsy_result",
                    models.CharField(
                        choices=[
                            ("N/A", "Not applicable"),
                            ("no_growth", "No growth"),
                            ("POS", "Positive"),
                        ],
                        default="N/A",
                        max_length=10,
                        verbose_name="If YES, results",
                    ),
                ),
                (
                    "tissue_biopsy_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[
                            edc_protocol.validators.date_not_before_study_start,
                            edc_model.validators.date.date_not_future,
                        ],
                    ),
                ),
                (
                    "tissue_biopsy_day_taken",
                    models.IntegerField(
                        blank=True,
                        null=True,
                        validators=[django.core.validators.MinValueValidator(1)],
                        verbose_name="If POSITIVE, `study day` positive tissue biospy sample taken",
                    ),
                ),
                (
                    "tissue_biopsy_organism",
                    models.CharField(
                        choices=[
                            ("N/A", "Not applicable"),
                            ("cryptococcus_neoformans", "Cryptococcus neoformans"),
                            ("mycobacterium_tuberculosis", "Mycobacterium Tuberculosis"),
                            ("OTHER", "Other"),
                        ],
                        default="N/A",
                        max_length=50,
                        verbose_name="If growth POSITIVE, organism",
                    ),
                ),
                (
                    "tissue_biopsy_organism_other",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=50,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "tissue_biopsy_report",
                    models.TextField(
                        blank=True, null=True, verbose_name="Histopathoplogy report"
                    ),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False
                    ),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default="COMPLETE",
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "comment",
                    models.TextField(
                        blank=True, null=True, verbose_name="Any additional comment"
                    ),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="effect_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Histopathy",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalBloodCulture",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "blood_culture_performed",
                    models.CharField(choices=[("Yes", "Yes"), ("No", "No")], max_length=5),
                ),
                (
                    "blood_culture_taken_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[
                            edc_protocol.validators.date_not_before_study_start,
                            edc_model.validators.date.date_not_future,
                        ],
                    ),
                ),
                (
                    "blood_culture_result",
                    models.CharField(
                        choices=[
                            ("N/A", "Not applicable"),
                            ("no_growth", "No growth"),
                            ("POS", "Positive"),
                        ],
                        default="N/A",
                        max_length=10,
                        verbose_name="Blood culture results, if completed",
                    ),
                ),
                (
                    "blood_culture_day_taken",
                    models.IntegerField(
                        blank=True,
                        null=True,
                        validators=[django.core.validators.MinValueValidator(1)],
                        verbose_name="If positive, study day positive blood sample taken",
                    ),
                ),
                (
                    "blood_culture_organism_text",
                    models.TextField(
                        blank=True, null=True, verbose_name="If growth positive, organism"
                    ),
                ),
                (
                    "blood_culture_organism",
                    models.CharField(
                        choices=[
                            ("N/A", "Not applicable"),
                            ("cryptococcus_neoformans", "Cryptococcus neoformans"),
                            ("bacteria", "Bacteria"),
                            ("bacteria_and_cryptococcus", "Bacteria and Cryptococcus"),
                            ("OTHER", "Other"),
                        ],
                        default="N/A",
                        max_length=50,
                        verbose_name="If growth positive, organism",
                    ),
                ),
                (
                    "blood_culture_organism_other",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=50,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "blood_culture_bacteria",
                    models.CharField(
                        choices=[
                            ("N/A", "Not applicable"),
                            ("e_coli", "E.coli"),
                            ("klebsiella_sp", "Klebsiella spp."),
                            ("streptococcus_pneumoniae", "Streptococcus pneumoniae"),
                            ("staphylococus_aureus", "(Sensitive) Staphylococus aureus"),
                            ("mrsa", "MRSA"),
                            ("OTHER", "Other"),
                        ],
                        default="N/A",
                        max_length=50,
                        verbose_name="If bacteria identified, select type",
                    ),
                ),
                (
                    "blood_culture_bacteria_other",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=100,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False
                    ),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default="COMPLETE",
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "comment",
                    models.TextField(
                        blank=True, null=True, verbose_name="Any additional comment"
                    ),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="effect_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Blood culture",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalAdherence",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False
                    ),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default="COMPLETE",
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="effect_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Adherence",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="Histopathology",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "tissue_biopsy_taken",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=5,
                        verbose_name="Was a tissue biopsy taken",
                    ),
                ),
                (
                    "tissue_biopsy_result",
                    models.CharField(
                        choices=[
                            ("N/A", "Not applicable"),
                            ("no_growth", "No growth"),
                            ("POS", "Positive"),
                        ],
                        default="N/A",
                        max_length=10,
                        verbose_name="If YES, results",
                    ),
                ),
                (
                    "tissue_biopsy_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[
                            edc_protocol.validators.date_not_before_study_start,
                            edc_model.validators.date.date_not_future,
                        ],
                    ),
                ),
                (
                    "tissue_biopsy_day_taken",
                    models.IntegerField(
                        blank=True,
                        null=True,
                        validators=[django.core.validators.MinValueValidator(1)],
                        verbose_name="If POSITIVE, `study day` positive tissue biospy sample taken",
                    ),
                ),
                (
                    "tissue_biopsy_organism",
                    models.CharField(
                        choices=[
                            ("N/A", "Not applicable"),
                            ("cryptococcus_neoformans", "Cryptococcus neoformans"),
                            ("mycobacterium_tuberculosis", "Mycobacterium Tuberculosis"),
                            ("OTHER", "Other"),
                        ],
                        default="N/A",
                        max_length=50,
                        verbose_name="If growth POSITIVE, organism",
                    ),
                ),
                (
                    "tissue_biopsy_organism_other",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=50,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "tissue_biopsy_report",
                    models.TextField(
                        blank=True, null=True, verbose_name="Histopathoplogy report"
                    ),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default="COMPLETE",
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "comment",
                    models.TextField(
                        blank=True, null=True, verbose_name="Any additional comment"
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="effect_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "Histopathy",
                "verbose_name_plural": "Histopathy",
                "ordering": ("-modified", "-created"),
                "get_latest_by": "modified",
                "abstract": False,
                "default_permissions": ("add", "change", "delete", "view", "export", "import"),
            },
            managers=[
                ("on_site", django.contrib.sites.managers.CurrentSiteManager()),
                ("objects", edc_visit_tracking.managers.CrfModelManager()),
            ],
        ),
        migrations.CreateModel(
            name="BloodCulture",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "blood_culture_performed",
                    models.CharField(choices=[("Yes", "Yes"), ("No", "No")], max_length=5),
                ),
                (
                    "blood_culture_taken_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[
                            edc_protocol.validators.date_not_before_study_start,
                            edc_model.validators.date.date_not_future,
                        ],
                    ),
                ),
                (
                    "blood_culture_result",
                    models.CharField(
                        choices=[
                            ("N/A", "Not applicable"),
                            ("no_growth", "No growth"),
                            ("POS", "Positive"),
                        ],
                        default="N/A",
                        max_length=10,
                        verbose_name="Blood culture results, if completed",
                    ),
                ),
                (
                    "blood_culture_day_taken",
                    models.IntegerField(
                        blank=True,
                        null=True,
                        validators=[django.core.validators.MinValueValidator(1)],
                        verbose_name="If positive, study day positive blood sample taken",
                    ),
                ),
                (
                    "blood_culture_organism_text",
                    models.TextField(
                        blank=True, null=True, verbose_name="If growth positive, organism"
                    ),
                ),
                (
                    "blood_culture_organism",
                    models.CharField(
                        choices=[
                            ("N/A", "Not applicable"),
                            ("cryptococcus_neoformans", "Cryptococcus neoformans"),
                            ("bacteria", "Bacteria"),
                            ("bacteria_and_cryptococcus", "Bacteria and Cryptococcus"),
                            ("OTHER", "Other"),
                        ],
                        default="N/A",
                        max_length=50,
                        verbose_name="If growth positive, organism",
                    ),
                ),
                (
                    "blood_culture_organism_other",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=50,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "blood_culture_bacteria",
                    models.CharField(
                        choices=[
                            ("N/A", "Not applicable"),
                            ("e_coli", "E.coli"),
                            ("klebsiella_sp", "Klebsiella spp."),
                            ("streptococcus_pneumoniae", "Streptococcus pneumoniae"),
                            ("staphylococus_aureus", "(Sensitive) Staphylococus aureus"),
                            ("mrsa", "MRSA"),
                            ("OTHER", "Other"),
                        ],
                        default="N/A",
                        max_length=50,
                        verbose_name="If bacteria identified, select type",
                    ),
                ),
                (
                    "blood_culture_bacteria_other",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=100,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default="COMPLETE",
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "comment",
                    models.TextField(
                        blank=True, null=True, verbose_name="Any additional comment"
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="effect_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "Blood culture",
                "verbose_name_plural": "Blood culture",
                "ordering": ("-modified", "-created"),
                "get_latest_by": "modified",
                "abstract": False,
                "default_permissions": ("add", "change", "delete", "view", "export", "import"),
            },
            managers=[
                ("on_site", django.contrib.sites.managers.CurrentSiteManager()),
                ("objects", edc_visit_tracking.managers.CrfModelManager()),
            ],
        ),
        migrations.CreateModel(
            name="Adherence",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default="COMPLETE",
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="effect_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "Adherence",
                "verbose_name_plural": "Adherence",
                "ordering": ("-modified", "-created"),
                "get_latest_by": "modified",
                "abstract": False,
                "default_permissions": ("add", "change", "delete", "view", "export", "import"),
            },
            managers=[
                ("on_site", django.contrib.sites.managers.CurrentSiteManager()),
                ("objects", edc_visit_tracking.managers.CrfModelManager()),
            ],
        ),
        migrations.AddIndex(
            model_name="microbiology",
            index=models.Index(
                fields=["subject_visit", "site", "id"], name="effect_subj_subject_2917cc_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="lpcsf",
            index=models.Index(
                fields=["subject_visit", "site", "id"], name="effect_subj_subject_b9f353_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="histopathology",
            index=models.Index(
                fields=["subject_visit", "site", "id"], name="effect_subj_subject_511a8a_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="bloodculture",
            index=models.Index(
                fields=["subject_visit", "site", "id"], name="effect_subj_subject_404a7c_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="adherence",
            index=models.Index(
                fields=["subject_visit", "site", "id"], name="effect_subj_subject_d79350_idx"
            ),
        ),
    ]
