# mypy-boto3-logs

Type annotations for
[boto3.CloudWatchLogs 1.11.4](https://boto3.amazonaws.com/v1/documentation/api/1.11.4/reference/services/logs.html#CloudWatchLogs) service
compatible with [mypy](https://github.com/python/mypy), [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/) and other tools.

More information can be found [here](https://vemel.github.io/mypy_boto3/).

- [mypy-boto3-logs](#mypy-boto3-logs)
  - [How to use](#how-to-use)
    - [Type checking](#type-checking)
    - [Code auto-complete](#code-auto-complete)
  - [How it works](#how-it-works)

## How to use

### Type checking

Make sure you have [mypy](https://github.com/python/mypy) installed and activated in your IDE.

Install `boto3-stubs` for `CloudWatchLogs` service.

```bash
python -m pip install boto3-stubs[mypy-boto3-logs]
```

Use `boto3` with `mypy_boto3` in your project and enjoy type checking and auto-complete.

```python
import boto3

from mypy_boto3 import logs
# alternative import if you do not want to install mypy_boto3 package
# import mypy_boto3_logs as logs

# Use this client as usual, now mypy can check if your code is valid.
# Check if your IDE supports function overloads,
# you probably do not need explicit type annotations
# client = boto3.client("logs")
client: logs.CloudWatchLogsClient = boto3.client("logs")

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: logs.CloudWatchLogsClient = session.client("logs")


# Paginators need type annotation on creation
describe_destinations_paginator: logs.DescribeDestinationsPaginator = client.get_paginator("describe_destinations")
describe_export_tasks_paginator: logs.DescribeExportTasksPaginator = client.get_paginator("describe_export_tasks")
describe_log_groups_paginator: logs.DescribeLogGroupsPaginator = client.get_paginator("describe_log_groups")
describe_log_streams_paginator: logs.DescribeLogStreamsPaginator = client.get_paginator("describe_log_streams")
describe_metric_filters_paginator: logs.DescribeMetricFiltersPaginator = client.get_paginator("describe_metric_filters")
describe_queries_paginator: logs.DescribeQueriesPaginator = client.get_paginator("describe_queries")
describe_resource_policies_paginator: logs.DescribeResourcePoliciesPaginator = client.get_paginator("describe_resource_policies")
describe_subscription_filters_paginator: logs.DescribeSubscriptionFiltersPaginator = client.get_paginator("describe_subscription_filters")
filter_log_events_paginator: logs.FilterLogEventsPaginator = client.get_paginator("filter_log_events")
```

## How it works

Fully automated [builder](https://github.com/vemel/mypy_boto3) carefully generates
type annotations for each service, patiently waiting for `boto3` updates. It delivers
a drop-in type annotations for you and makes sure that:

- All available `boto3` services are covered.
- Each public class and method of every `boto3` service gets valid type annotations
  extracted from the documentation (blame `botocore` docs if types are incorrect).
- Type annotations include up-to-date documentation.
- Link to documentation is provided for every method.
- Code is processed by [black](https://github.com/psf/black) for readability.