import json
import os

from rostran.core.settings import RULES_DIR

TF_RULES_DIR = os.path.join(RULES_DIR, "terraform")
TF_ALI_RULES_DIR = os.path.join(TF_RULES_DIR, "alicloud")
ROS_RULES_DIR = os.path.join(RULES_DIR, "ros")
ROS_RESOURCE_RULES_DIR = os.path.join(ROS_RULES_DIR, "resource")
CF_RULES_DIR = os.path.join(RULES_DIR, "cloudformation")
CF_RESOURCE_RULES_DIR = os.path.join(CF_RULES_DIR, "resource")

TF_ALI_ROS_PROD_MAPPINGS = {
    "alidns": "DNS",
    "alikafka": "KAFKA",
    "db": "RDS",
    "log": "SLS",
    "market": "MarketPlace",
    "api_gateway": "ApiGateway",
}

TF_ALI_ROS_PROP_MAPPINGS = {
    "*": {
        "availability_zone": "ZoneId",
        "data_disks": "DiskMappings",
        "security_group": "SecurityGroupIds",
        "vswitch_id": "VSwitchId",
        "vswitch_name": "VSwitchName",
        "userdata": "UserData",
    },
    "alicloud_instance": {
        "key_name": "KeyPairName",
        "allocate_public_ip": "AllocatePublicIP",
        "data_disks.*.name": "DiskName",
    },
    "alicloud_actiontrail_trail": {
        "event_rw": "EventRW",
    },
    "alicloud_alidns_record": {"rr": "RR"},
    "alicloud_api_gateway_api": {
        "constant_parameters": "ConstParameters",
        "name": "ApiName",
        "request_parameters.*.in": "Location",
        "request_parameters.*.name": "ApiParameterName",
        "request_parameters.*.type": "ParameterType",
        "system_parameters.*.in": "Location",
        "system_parameters.*.name": "ParameterName",
        "system_parameters.*.name_service": "ServiceParameterName",
        "fc_service_config": "FunctionComputeConfig",
        "request_config": "RequestConfig",
    },
    "alicloud_api_gateway_app": {
        "name": "AppName",
    },
    "alicloud_slb_acl": {"entry_list": "AclEntries"},
}

current_dir = os.path.dirname(os.path.abspath(__file__))
with open(os.path.join(current_dir, 'tf_ali_ros_generate_mappings.json'), 'r') as f:
    tf_ali_ros_generate_mappings = json.load(f)

TF_ALI_ROS_GENERATE_MAPPINGS = tf_ali_ros_generate_mappings or {
    # "alicloud_ack_one_cluster": "",
    # "alicloud_actiontrail_global_events_storage_region": "",
    # "alicloud_actiontrail_history_delivery_job": "",
    "alicloud_actiontrail_trail": "ALIYUN::ACTIONTRAIL::Trail",
    "alicloud_adb_account": "ALIYUN::ADB::Account",
    # "alicloud_adb_backup_policy": "",
    # "alicloud_adb_connection": "",
    "alicloud_adb_db_cluster": "ALIYUN::ADB::DBCluster",
    "alicloud_adb_db_cluster_lake_version": "ALIYUN::ADBLake::DBCluster",
    # "alicloud_adb_group": "",
    # "alicloud_adb_lake_account": "",
    "alicloud_alb_acl": "ALIYUN::ALB::Acl",
    # "alicloud_alb_acl_entry_attachment": "",
    "alicloud_alb_ascript": "ALIYUN::ALB::AScript",
    "alicloud_alb_health_check_template": "ALIYUN::ALB::HealthCheckTemplate",
    "alicloud_alb_listener": "ALIYUN::ALB::Listener",
    "alicloud_alb_listener_acl_attachment": "ALIYUN::ALB::AclAssociation",
    "alicloud_alb_listener_additional_certificate_attachment": "ALIYUN::ALB::AdditionalCertificateAssociation",
    "alicloud_alb_load_balancer": "ALIYUN::ALB::LoadBalancer",
    # "alicloud_alb_load_balancer_common_bandwidth_package_attachment": "",
    "alicloud_alb_load_balancer_security_group_attachment": "ALIYUN::ALB::SecurityGroupAttachment",
    "alicloud_alb_rule": "ALIYUN::ALB::Rule",
    "alicloud_alb_security_policy": "ALIYUN::ALB::SecurityPolicy",
    "alicloud_alb_server_group": "ALIYUN::ALB::ServerGroup",
    # "alicloud_alidns_access_strategy": "",
    # "alicloud_alidns_address_pool": "",
    # "alicloud_alidns_custom_line": "",
    "alicloud_alidns_domain": "ALIYUN::DNS::Domain",
    "alicloud_alidns_domain_group": "ALIYUN::DNS::DomainGroup",
    # "alicloud_alidns_gtm_instance": "",
    # "alicloud_alidns_instance": "",
    # "alicloud_alidns_monitor_config": "",
    "alicloud_alidns_record": "ALIYUN::DNS::DomainRecord",
    # "alicloud_aligreen_audit_callback": "",
    # "alicloud_aligreen_biz_type": "",
    # "alicloud_aligreen_callback": "",
    # "alicloud_aligreen_image_lib": "",
    # "alicloud_aligreen_keyword_lib": "",
    # "alicloud_aligreen_oss_stock_task": "",
    "alicloud_alikafka_consumer_group": "ALIYUN::KAFKA::ConsumerGroup",
    "alicloud_alikafka_instance": "ALIYUN::KAFKA::Instance",
    # "alicloud_alikafka_instance_allowed_ip_attachment": "",
    # "alicloud_alikafka_sasl_acl": "",
    "alicloud_alikafka_sasl_user": "ALIYUN::KAFKA::SaslUser",
    "alicloud_alikafka_topic": "ALIYUN::KAFKA::Topic",
    "alicloud_amqp_binding": "ALIYUN::AMQP::Binding",
    "alicloud_amqp_exchange": "ALIYUN::AMQP::Exchange",
    "alicloud_amqp_instance": "ALIYUN::AMQP::Instance",
    "alicloud_amqp_queue": "ALIYUN::AMQP::Queue",
    # "alicloud_amqp_static_account": "",
    "alicloud_amqp_virtual_host": "ALIYUN::AMQP::VirtualHost",
    # "alicloud_api_gateway_access_control_list": "",
    # "alicloud_api_gateway_acl_entry_attachment": "",
    "alicloud_api_gateway_api": "ALIYUN::ApiGateway::Api",
    "alicloud_api_gateway_app": "ALIYUN::ApiGateway::App",
    "alicloud_api_gateway_app_attachment": "ALIYUN::ApiGateway::Authorization",
    # "alicloud_api_gateway_backend": "",
    "alicloud_api_gateway_group": "ALIYUN::ApiGateway::Group",
    "alicloud_api_gateway_instance": "ALIYUN::ApiGateway::Instance",
    # "alicloud_api_gateway_instance_acl_attachment": "",
    "alicloud_api_gateway_log_config": "ALIYUN::ApiGateway::LogConfig",
    # "alicloud_api_gateway_model": "",
    "alicloud_api_gateway_plugin": "ALIYUN::ApiGateway::Plugin",
    # "alicloud_api_gateway_plugin_attachment": "",
    "alicloud_api_gateway_vpc_access": "ALIYUN::ApiGateway::VpcAccessConfig",
    "alicloud_arms_addon_release": "ALIYUN::ARMS::AddonRelease",
    "alicloud_arms_alert_contact": "ALIYUN::ARMS::AlertContact",
    "alicloud_arms_alert_contact_group": "ALIYUN::ARMS::AlertContactGroup",
    # "alicloud_arms_dispatch_rule": "",
    # "alicloud_arms_env_custom_job": "",
    "alicloud_arms_env_feature": "ALIYUN::ARMS::EnvironmentFeature",
    # "alicloud_arms_env_pod_monitor": "",
    # "alicloud_arms_env_service_monitor": "",
    "alicloud_arms_environment": "ALIYUN::ARMS::Environment",
    # "alicloud_arms_grafana_workspace": "",
    # "alicloud_arms_integration_exporter": "",
    "alicloud_arms_prometheus": "ALIYUN::ARMS::ManagedPrometheus",
    # "alicloud_arms_prometheus_alert_rule": "",
    # "alicloud_arms_prometheus_monitoring": "",
    # "alicloud_arms_remote_write": "",
    # "alicloud_arms_synthetic_task": "",
    "alicloud_auto_provisioning_group": "ALIYUN::ECS::AutoProvisioningGroup",
    "alicloud_bastionhost_host": "ALIYUN::BastionHost::Host",
    # "alicloud_bastionhost_host_account": "",
    # "alicloud_bastionhost_host_account_share_key_attachment": "",
    # "alicloud_bastionhost_host_account_user_attachment": "",
    # "alicloud_bastionhost_host_account_user_group_attachment": "",
    # "alicloud_bastionhost_host_attachment": "",
    # "alicloud_bastionhost_host_group": "",
    # "alicloud_bastionhost_host_group_account_user_attachment": "",
    # "alicloud_bastionhost_host_group_account_user_group_attachment": "",
    # "alicloud_bastionhost_host_share_key": "",
    "alicloud_bastionhost_instance": "ALIYUN::BastionHost::Instance",
    # "alicloud_bastionhost_user": "",
    # "alicloud_bastionhost_user_attachment": "",
    # "alicloud_bastionhost_user_group": "",
    # "alicloud_bp_studio_application": "",
    # "alicloud_brain_industrial_pid_loop": "",
    # "alicloud_brain_industrial_pid_organization": "",
    # "alicloud_brain_industrial_pid_project": "",
    # "alicloud_cassandra_backup_plan": "",
    # "alicloud_cassandra_cluster": "",
    # "alicloud_cassandra_data_center": "",
    "alicloud_cddc_dedicated_host": "ALIYUN::CDDC::DedicatedHost",
    # "alicloud_cddc_dedicated_host_account": "",
    "alicloud_cddc_dedicated_host_group": "ALIYUN::CDDC::DedicatedHostGroup",
    # "alicloud_cddc_dedicated_propre_host": "",
    "alicloud_cdn_domain": "ALIYUN::CDN::Domain",
    "alicloud_cdn_domain_config": "ALIYUN::CDN::DomainConfig",
    "alicloud_cdn_domain_new": "ALIYUN::CDN::Domain",
    # "alicloud_cdn_fc_trigger": "",
    # "alicloud_cdn_real_time_log_delivery": "",
    "alicloud_cen_bandwidth_limit": "ALIYUN::CEN::CenBandwidthLimit",
    "alicloud_cen_bandwidth_package": "ALIYUN::CEN::CenBandwidthPackage",
    "alicloud_cen_bandwidth_package_attachment": "ALIYUN::CEN::CenBandwidthPackageAssociation",
    "alicloud_cen_child_instance_route_entry_to_attachment": "ALIYUN::CEN::ChildInstanceRouteEntryToAttachment",
    "alicloud_cen_flowlog": "ALIYUN::VPC::FlowLog",
    "alicloud_cen_instance": "ALIYUN::CEN::CenInstance",
    "alicloud_cen_instance_attachment": "ALIYUN::CEN::CenInstanceAttachment",
    "alicloud_cen_instance_grant": "ALIYUN::VPC::GrantInstanceToCen",
    # "alicloud_cen_inter_region_traffic_qos_policy": "",
    # "alicloud_cen_inter_region_traffic_qos_queue": "",
    # "alicloud_cen_private_zone": "",
    "alicloud_cen_route_entry": "ALIYUN::CEN::RouteEntry",
    "alicloud_cen_route_map": "ALIYUN::CEN::CenRouteMap",
    "alicloud_cen_route_service": "ALIYUN::CEN::CenRouteService",
    # "alicloud_cen_traffic_marking_policy": "",
    # "alicloud_cen_transit_route_table_aggregation": "",
    "alicloud_cen_transit_router": "ALIYUN::CEN::TransitRouter",
    # "alicloud_cen_transit_router_cidr": "",
    # "alicloud_cen_transit_router_ecr_attachment": "",
    # "alicloud_cen_transit_router_grant_attachment": "",
    # "alicloud_cen_transit_router_multicast_domain": "",
    # "alicloud_cen_transit_router_multicast_domain_association": "",
    # "alicloud_cen_transit_router_multicast_domain_member": "",
    # "alicloud_cen_transit_router_multicast_domain_peer_member": "",
    # "alicloud_cen_transit_router_multicast_domain_source": "",
    "alicloud_cen_transit_router_peer_attachment": "ALIYUN::CEN::TransitRouterPeerAttachment",
    # "alicloud_cen_transit_router_prefix_list_association": "",
    "alicloud_cen_transit_router_route_entry": "ALIYUN::CEN::TransitRouterRouteEntry",
    "alicloud_cen_transit_router_route_table": "ALIYUN::CEN::TransitRouterRouteTable",
    "alicloud_cen_transit_router_route_table_association": "ALIYUN::CEN::TransitRouterRouteTableAssociation",
    "alicloud_cen_transit_router_route_table_propagation": "ALIYUN::CEN::TransitRouterRouteTablePropagation",
    "alicloud_cen_transit_router_vbr_attachment": "ALIYUN::CEN::TransitRouterVbrAttachment",
    "alicloud_cen_transit_router_vpc_attachment": "ALIYUN::CEN::TransitRouterVpcAttachment",
    "alicloud_cen_transit_router_vpn_attachment": "ALIYUN::CEN::TransitRouterVpnAttachment",
    "alicloud_cen_vbr_health_check": "ALIYUN::CEN::CenVbrHealthCheck",
    # "alicloud_chatbot_publish_task": "",
    # "alicloud_click_house_account": "",
    # "alicloud_click_house_backup_policy": "",
    "alicloud_click_house_db_cluster": "ALIYUN::ClickHouse::DBCluster",
    "alicloud_cloud_connect_network": "ALIYUN::SAG::CloudConnectNetwork",
    # "alicloud_cloud_connect_network_attachment": "",
    "alicloud_cloud_connect_network_grant": "ALIYUN::SAG::GrantCcnToCen",
    "alicloud_cloud_firewall_address_book": "ALIYUN::CLOUDFW::AddressBook",
    "alicloud_cloud_firewall_control_policy": "ALIYUN::CLOUDFW::ControlPolicy",
    # "alicloud_cloud_firewall_control_policy_order": "",
    # "alicloud_cloud_firewall_instance": "",
    # "alicloud_cloud_firewall_instance_member": "",
    # "alicloud_cloud_firewall_nat_firewall": "",
    "alicloud_cloud_firewall_nat_firewall_control_policy": "ALIYUN::CLOUDFW::NatFirewallControlPolicy",
    # "alicloud_cloud_firewall_vpc_cen_tr_firewall": "",
    # "alicloud_cloud_firewall_vpc_firewall": "",
    # "alicloud_cloud_firewall_vpc_firewall_cen": "",
    "alicloud_cloud_firewall_vpc_firewall_control_policy": "ALIYUN::CLOUDFW::VpcFirewallControlPolicy",
    # "alicloud_cloud_monitor_service_basic_public": "",
    # "alicloud_cloud_monitor_service_enterprise_public": "",
    # "alicloud_cloud_monitor_service_group_monitoring_agent_process": "",
    # "alicloud_cloud_monitor_service_hybrid_double_write": "",
    # "alicloud_cloud_monitor_service_monitoring_agent_process": "",
    "alicloud_cloud_sso_access_assignment": "ALIYUN::CloudSSO::AccessAssignment",
    "alicloud_cloud_sso_access_configuration": "ALIYUN::CloudSSO::AccessConfiguration",
    "alicloud_cloud_sso_access_configuration_provisioning": "ALIYUN::CloudSSO::AccessConfigurationProvision",
    "alicloud_cloud_sso_directory": "ALIYUN::CloudSSO::Directory",
    "alicloud_cloud_sso_group": "ALIYUN::CloudSSO::Group",
    "alicloud_cloud_sso_scim_server_credential": "ALIYUN::CloudSSO::SCIMServerCredential",
    "alicloud_cloud_sso_user": "ALIYUN::CloudSSO::User",
    "alicloud_cloud_sso_user_attachment": "ALIYUN::CloudSSO::UserToGroupAddition",
    # "alicloud_cloud_storage_gateway_express_sync": "",
    # "alicloud_cloud_storage_gateway_express_sync_share_attachment": "",
    # "alicloud_cloud_storage_gateway_gateway": "",
    # "alicloud_cloud_storage_gateway_gateway_block_volume": "",
    # "alicloud_cloud_storage_gateway_gateway_cache_disk": "",
    # "alicloud_cloud_storage_gateway_gateway_file_share": "",
    # "alicloud_cloud_storage_gateway_gateway_logging": "",
    # "alicloud_cloud_storage_gateway_gateway_smb_user": "",
    "alicloud_cloud_storage_gateway_storage_bundle": "ALIYUN::CloudStorageGateway::StorageBundle",
    # "alicloud_cloudauth_face_config": "",
    # "alicloud_cms_alarm": "",
    "alicloud_cms_alarm_contact": "ALIYUN::CMS::Contact",
    "alicloud_cms_alarm_contact_group": "ALIYUN::CMS::ContactGroup",
    "alicloud_cms_dynamic_tag_group": "ALIYUN::CMS::DynamicTagGroup",
    "alicloud_cms_event_rule": "ALIYUN::CMS::EventRule",
    "alicloud_cms_group_metric_rule": "ALIYUN::CMS::GroupMetricRule",
    # "alicloud_cms_hybrid_monitor_fc_task": "",
    # "alicloud_cms_hybrid_monitor_sls_task": "",
    # "alicloud_cms_metric_rule_black_list": "",
    "alicloud_cms_metric_rule_template": "ALIYUN::CMS::MetricRuleTemplate",
    "alicloud_cms_monitor_group": "ALIYUN::CMS::MonitorGroup",
    "alicloud_cms_monitor_group_instances": "ALIYUN::CMS::MonitorGroupInstances",
    "alicloud_cms_namespace": "ALIYUN::CMS::Namespace",
    "alicloud_cms_site_monitor": "ALIYUN::CMS::SiteMonitor",
    "alicloud_cms_sls_group": "ALIYUN::CMS::SlsGroup",
    "alicloud_common_bandwidth_package": "ALIYUN::VPC::CommonBandwidthPackage",
    "alicloud_common_bandwidth_package_attachment": "ALIYUN::VPC::CommonBandwidthPackageIp",
    "alicloud_compute_nest_service_instance": "ALIYUN::ComputeNest::ServiceInstance",
    "alicloud_config_aggregate_compliance_pack": "ALIYUN::Config::AggregateCompliancePack",
    # "alicloud_config_aggregate_config_rule": "",
    # "alicloud_config_aggregate_delivery": "",
    "alicloud_config_aggregator": "ALIYUN::Config::Aggregator",
    "alicloud_config_compliance_pack": "ALIYUN::Config::CompliancePack",
    # "alicloud_config_configuration_recorder": "",
    # "alicloud_config_delivery": "",
    "alicloud_config_delivery_channel": "ALIYUN::Config::DeliveryChannel",
    # "alicloud_config_remediation": "",
    "alicloud_config_rule": "ALIYUN::Config::Rule",
    # "alicloud_cr_chain": "",
    # "alicloud_cr_chart_namespace": "",
    # "alicloud_cr_chart_repository": "",
    "alicloud_cr_ee_instance": "ALIYUN::CR::Instance",
    "alicloud_cr_ee_namespace": "ALIYUN::CR::Namespace",
    "alicloud_cr_ee_repo": "ALIYUN::CR::Repository",
    # "alicloud_cr_ee_sync_rule": "",
    "alicloud_cr_endpoint_acl_policy": "ALIYUN::CR::InstanceEndpointAclPolicy",
    "alicloud_cr_namespace": "ALIYUN::CR::Namespace",
    "alicloud_cr_repo": "ALIYUN::CR::Repository",
    "alicloud_cr_vpc_endpoint_linked_vpc": "ALIYUN::CR::InstanceVpcEndpointLinkedVpc",
    # "alicloud_cs_application": "",
    # "alicloud_cs_autoscaling_config": "",
    "alicloud_cs_edge_kubernetes": "ALIYUN::CS::ManagedEdgeKubernetesCluster",
    "alicloud_cs_kubernetes": "ALIYUN::CS::KubernetesCluster",
    "alicloud_cs_kubernetes_addon": "ALIYUN::CS::ClusterAddons",
    # "alicloud_cs_kubernetes_autoscaler": "",
    "alicloud_cs_kubernetes_node_pool": "ALIYUN::CS::ClusterNodePool",
    # "alicloud_cs_kubernetes_permissions": "",
    "alicloud_cs_managed_kubernetes": "ALIYUN::CS::ManagedKubernetesCluster",
    "alicloud_cs_serverless_kubernetes": "ALIYUN::CS::ServerlessKubernetesCluster",
    # "alicloud_cs_swarm": "",
    # "alicloud_das_switch_das_pro": "",
    # "alicloud_data_works_folder": "",
    "alicloud_data_works_project": "ALIYUN::DataWorks::Project",
    # "alicloud_database_gateway_gateway": "",
    "alicloud_datahub_project": "ALIYUN::DATAHUB::Project",
    # "alicloud_datahub_subscription": "",
    "alicloud_datahub_topic": "ALIYUN::DATAHUB::Topic",
    "alicloud_db_account_privilege": "ALIYUN::RDS::AccountPrivilege",
    # "alicloud_db_backup_policy": "",
    "alicloud_db_connection": "ALIYUN::RDS::Connection",
    "alicloud_db_database": "ALIYUN::RDS::Database",
    "alicloud_db_instance": "ALIYUN::RDS::DBInstance",
    # "alicloud_db_read_write_splitting_connection": "",
    "alicloud_db_readonly_instance": "ALIYUN::RDS::ReadOnlyDBInstance",
    # "alicloud_dbfs_auto_snap_shot_policy": "",
    # "alicloud_dbfs_instance": "",
    # "alicloud_dbfs_instance_attachment": "",
    # "alicloud_dbfs_service_linked_role": "",
    # "alicloud_dbfs_snapshot": "",
    # "alicloud_dbs_backup_plan": "",
    "alicloud_dcdn_domain": "ALIYUN::DCDN::Domain",
    # "alicloud_dcdn_domain_config": "",
    # "alicloud_dcdn_er": "",
    # "alicloud_dcdn_ipa_domain": "",
    # "alicloud_dcdn_kv": "",
    # "alicloud_dcdn_kv_namespace": "",
    # "alicloud_dcdn_waf_domain": "",
    # "alicloud_dcdn_waf_policy": "",
    # "alicloud_dcdn_waf_policy_domain_attachment": "",
    # "alicloud_dcdn_waf_rule": "",
    # "alicloud_ddos_basic_defense_threshold": "",
    # "alicloud_ddos_basic_threshold": "",
    # "alicloud_ddos_bgp_policy": "",
    "alicloud_ddosbgp_instance": "ALIYUN::DDoS::OriginInstance",
    # "alicloud_ddosbgp_ip": "",
    # "alicloud_ddoscoo_domain_resource": "",
    "alicloud_ddoscoo_instance": "ALIYUN::DDoSPro::ProInstance",
    "alicloud_ddoscoo_port": "ALIYUN::DDoSPro::Port",
    "alicloud_ddoscoo_scheduler_rule": "ALIYUN::DDoSPro::SchedulerRule",
    "alicloud_dfs_access_group": "ALIYUN::DFS::AccessGroup",
    "alicloud_dfs_access_rule": "ALIYUN::DFS::AccessRule",
    "alicloud_dfs_file_system": "ALIYUN::DFS::FileSystem",
    "alicloud_dfs_mount_point": "ALIYUN::DFS::MountPoint",
    # "alicloud_dfs_vsc_mount_point": "",
    "alicloud_direct_mail_domain": "ALIYUN::DirectMail::Domain",
    # "alicloud_direct_mail_mail_address": "",
    # "alicloud_direct_mail_receivers": "",
    # "alicloud_direct_mail_tag": "",
    # "alicloud_dms_enterprise_authority_template": "",
    "alicloud_dms_enterprise_instance": "ALIYUN::DMS::Instance",
    # "alicloud_dms_enterprise_logic_database": "",
    # "alicloud_dms_enterprise_proxy": "",
    # "alicloud_dms_enterprise_proxy_access": "",
    "alicloud_dms_enterprise_user": "ALIYUN::DMS::User",
    # "alicloud_dns": "",
    # "alicloud_dns_domain_attachment": "",
    "alicloud_dns_group": "ALIYUN::DNS::DomainGroup",
    "alicloud_dns_record": "ALIYUN::DNS::DomainRecord",
    "alicloud_drds_instance": "ALIYUN::DRDS::DrdsInstance",
    "alicloud_drds_polardbx_instance": "ALIYUN::PolarDBX::DBInstance",
    # "alicloud_dts_consumer_channel": "",
    "alicloud_dts_instance": "ALIYUN::DTS::Instance",
    # "alicloud_dts_job_monitor_rule": "",
    # "alicloud_dts_migration_instance": "",
    "alicloud_dts_migration_job": "ALIYUN::DTS::MigrationJob",
    # "alicloud_dts_subscription_job": "",
    # "alicloud_dts_synchronization_instance": "",
    "alicloud_dts_synchronization_job": "ALIYUN::DTS::SynchronizationJob",
    "alicloud_eais_instance": "ALIYUN::EAIS::Instance",
    # "alicloud_ebs_dedicated_block_storage_cluster": "",
    "alicloud_ebs_disk_replica_group": "ALIYUN::EBS::DiskReplicaGroup",
    "alicloud_ebs_disk_replica_pair": "ALIYUN::EBS::DiskReplicaPair",
    # "alicloud_ebs_enterprise_snapshot_policy": "",
    # "alicloud_ebs_enterprise_snapshot_policy_attachment": "",
    # "alicloud_ebs_replica_group_drill": "",
    # "alicloud_ebs_replica_pair_drill": "",
    # "alicloud_ebs_solution_instance": "",
    # "alicloud_ecd_ad_connector_directory": "",
    # "alicloud_ecd_ad_connector_office_site": "",
    "alicloud_ecd_bundle": "ALIYUN::ECD::Bundle",
    # "alicloud_ecd_command": "",
    # "alicloud_ecd_custom_property": "",
    "alicloud_ecd_desktop": "ALIYUN::ECD::Desktops",
    # "alicloud_ecd_image": "",
    # "alicloud_ecd_nas_file_system": "",
    "alicloud_ecd_network_package": "ALIYUN::ECD::NetworkPackage",
    # "alicloud_ecd_policy_group": "",
    # "alicloud_ecd_ram_directory": "",
    "alicloud_ecd_simple_office_site": "ALIYUN::ECD::SimpleOfficeSite",
    # "alicloud_ecd_snapshot": "",
    # "alicloud_ecd_user": "",
    "alicloud_eci_container_group": "ALIYUN::ECI::ContainerGroup",
    "alicloud_eci_image_cache": "ALIYUN::ECI::ImageCache",
    # "alicloud_eci_virtual_node": "",
    "alicloud_ecp_instance": "ALIYUN::CloudPhone::InstanceGroup",
    "alicloud_ecp_key_pair": "ALIYUN::CloudPhone::KeyPair",
    "alicloud_ecs_activation": "ALIYUN::ECS::Activation",
    "alicloud_ecs_auto_snapshot_policy": "ALIYUN::ECS::AutoSnapshotPolicy",
    # "alicloud_ecs_auto_snapshot_policy_attachment": "",
    "alicloud_ecs_capacity_reservation": "ALIYUN::ECS::CapacityReservation",
    "alicloud_ecs_command": "ALIYUN::ECS::Command",
    "alicloud_ecs_dedicated_host": "ALIYUN::ECS::DedicatedHost",
    # "alicloud_ecs_dedicated_host_cluster": "",
    "alicloud_ecs_deployment_set": "ALIYUN::ECS::DeploymentSet",
    "alicloud_ecs_disk": "ALIYUN::ECS::Disk",
    "alicloud_ecs_disk_attachment": "ALIYUN::ECS::DiskAttachment",
    "alicloud_ecs_elasticity_assurance": "ALIYUN::ECS::ElasticityAssurance",
    "alicloud_ecs_hpc_cluster": "ALIYUN::ECS::HpcCluster",
    "alicloud_ecs_image_component": "ALIYUN::ECS::ImageComponent",
    "alicloud_ecs_image_pipeline": "ALIYUN::ECS::ImagePipeline",
    "alicloud_ecs_instance_set": "ALIYUN::ECS::InstanceGroup",
    "alicloud_ecs_invocation": "ALIYUN::ECS::Invocation",
    "alicloud_ecs_key_pair": "ALIYUN::ECS::SSHKeyPair",
    "alicloud_ecs_key_pair_attachment": "ALIYUN::ECS::SSHKeyPairAttachment",
    "alicloud_ecs_launch_template": "ALIYUN::ECS::LaunchTemplate",
    "alicloud_ecs_network_interface": "ALIYUN::ECS::NetworkInterface",
    "alicloud_ecs_network_interface_attachment": "ALIYUN::ECS::NetworkInterfaceAttachment",
    "alicloud_ecs_network_interface_permission": "ALIYUN::ECS::NetworkInterfacePermission",
    "alicloud_ecs_prefix_list": "ALIYUN::ECS::PrefixList",
    # "alicloud_ecs_session_manager_status": "",
    "alicloud_ecs_snapshot": "ALIYUN::ECS::Snapshot",
    "alicloud_ecs_snapshot_group": "ALIYUN::ECS::SnapshotGroup",
    # "alicloud_ecs_storage_capacity_unit": "",
    "alicloud_edas_application": "ALIYUN::EDAS::Application",
    # "alicloud_edas_application_package_attachment": "",
    # "alicloud_edas_application_scale": "",
    "alicloud_edas_cluster": "ALIYUN::EDAS::Cluster",
    "alicloud_edas_deploy_group": "ALIYUN::EDAS::DeployGroup",
    # "alicloud_edas_instance_cluster_attachment": "",
    "alicloud_edas_k8s_application": "ALIYUN::EDAS::K8sApplication",
    "alicloud_edas_k8s_cluster": "ALIYUN::EDAS::K8sCluster",
    "alicloud_edas_k8s_slb_attachment": "ALIYUN::EDAS::K8sSlbBinding",
    "alicloud_edas_namespace": "ALIYUN::EDAS::UserDefineRegion",
    # "alicloud_edas_slb_attachment": "",
    # "alicloud_eflo_subnet": "",
    # "alicloud_eflo_vpd": "",
    "alicloud_ehpc_cluster": "ALIYUN::EHPC::Cluster",
    # "alicloud_ehpc_job_template": "",
    "alicloud_eip_address": "ALIYUN::VPC::EIP",
    "alicloud_eip_association": "ALIYUN::VPC::EIPAssociation",
    "alicloud_eip_segment_address": "ALIYUN::VPC::EIPSegment",
    "alicloud_eipanycast_anycast_eip_address": "ALIYUN::VPC::AnycastEIP",
    "alicloud_eipanycast_anycast_eip_address_attachment": "ALIYUN::VPC::AnycastEIPAssociation",
    "alicloud_elasticsearch_instance": "ALIYUN::ElasticSearch::Instance",
    "alicloud_emr_cluster": "ALIYUN::EMR::Cluster",
    "alicloud_emrv2_cluster": "ALIYUN::EMR::Cluster2",
    "alicloud_ens_disk": "ALIYUN::ENS::Disk",
    "alicloud_ens_disk_instance_attachment": "ALIYUN::ENS::DiskInstanceAttachment",
    # "alicloud_ens_eip": "",
    # "alicloud_ens_eip_instance_attachment": "",
    "alicloud_ens_image": "ALIYUN::ENS::Image",
    "alicloud_ens_instance": "ALIYUN::ENS::Instance",
    "alicloud_ens_instance_security_group_attachment": "ALIYUN::ENS::InstanceSecurityGroupAttachment",
    "alicloud_ens_key_pair": "ALIYUN::ENS::KeyPair",
    # "alicloud_ens_load_balancer": "",
    # "alicloud_ens_nat_gateway": "",
    "alicloud_ens_network": "ALIYUN::ENS::Network",
    "alicloud_ens_security_group": "ALIYUN::ENS::SecurityGroup",
    "alicloud_ens_snapshot": "ALIYUN::ENS::Snapshot",
    "alicloud_ens_vswitch": "ALIYUN::ENS::VSwitch",
    "alicloud_ess_alarm": "ALIYUN::ESS::AlarmTask",
    "alicloud_ess_alb_server_group_attachment": "ALIYUN::ESS::ServerGroupAttachment",
    # "alicloud_ess_attachment": "",
    "alicloud_ess_eci_scaling_configuration": "ALIYUN::ESS::EciScalingConfiguration",
    "alicloud_ess_lifecycle_hook": (
        "alicloud_ess_lifecyclehook",
        "ALIYUN::ESS::LifecycleHook",
    ),
    # "alicloud_ess_notification": "",
    "alicloud_ess_scaling_configuration": "ALIYUN::ESS::ScalingConfiguration",
    "alicloud_ess_scaling_group": "ALIYUN::ESS::ScalingGroup",
    "alicloud_ess_scaling_rule": "ALIYUN::ESS::ScalingRule",
    # "alicloud_ess_scalinggroup_vserver_groups": "",
    "alicloud_ess_scheduled_task": "ALIYUN::ESS::ScheduledTask",
    "alicloud_ess_server_group_attachment": "ALIYUN::ESS::ServerGroupAttachment",
    # "alicloud_ess_suspend_process": "",
    # "alicloud_event_bridge_api_destination": "",
    # "alicloud_event_bridge_connection": "",
    # "alicloud_event_bridge_event_bus": "",
    # "alicloud_event_bridge_event_source": "",
    "alicloud_event_bridge_rule": "ALIYUN::EventBridge::Rule",
    # "alicloud_event_bridge_service_linked_role": "",
    # "alicloud_express_connect_grant_rule_to_cen": "",
    # "alicloud_express_connect_physical_connection": "",
    # "alicloud_express_connect_router_express_connect_router": "",
    # "alicloud_express_connect_router_interface": "",
    # "alicloud_express_connect_router_tr_association": "",
    # "alicloud_express_connect_router_vbr_child_instance": "",
    # "alicloud_express_connect_router_vpc_association": "",
    # "alicloud_express_connect_traffic_qos": "",
    # "alicloud_express_connect_traffic_qos_association": "",
    # "alicloud_express_connect_traffic_qos_queue": "",
    # "alicloud_express_connect_traffic_qos_rule": "",
    # "alicloud_express_connect_vbr_pconn_association": "",
    "alicloud_express_connect_virtual_border_router": "ALIYUN::VPC::VirtualBorderRouter",
    # "alicloud_express_connect_virtual_physical_connection": "",
    "alicloud_fc_alias": "ALIYUN::FC::Alias",
    "alicloud_fc_custom_domain": "ALIYUN::FC::CustomDomain",
    "alicloud_fc_function": "ALIYUN::FC::Function",
    # "alicloud_fc_function_async_invoke_config": "",
    # "alicloud_fc_layer_version": "",
    "alicloud_fc_service": "ALIYUN::FC::Service",
    "alicloud_fc_trigger": "ALIYUN::FC::Trigger",
    "alicloud_fcv2_function": "ALIYUN::FC::Function",
    "alicloud_fcv3_alias": "ALIYUN::FC::Alias",
    # "alicloud_fcv3_async_invoke_config": "",
    # "alicloud_fcv3_concurrency_config": "",
    # "alicloud_fcv3_custom_domain": "",
    "alicloud_fcv3_function": "ALIYUN::FC3::Function",
    # "alicloud_fcv3_function_version": "",
    # "alicloud_fcv3_layer_version": "",
    # "alicloud_fcv3_provision_config": "",
    "alicloud_fcv3_trigger": "ALIYUN::FC3::Trigger",
    # "alicloud_fcv3_vpc_binding": "",
    # "alicloud_fnf_execution": "",
    "alicloud_fnf_flow": "ALIYUN::FNF::Flow",
    "alicloud_fnf_schedule": "ALIYUN::FNF::Schedule",
    "alicloud_forward_entry": "ALIYUN::ECS::ForwardEntry",
    "alicloud_ga_accelerator": "ALIYUN::GA::Accelerator",
    # "alicloud_ga_accelerator_spare_ip_attachment": "",
    # "alicloud_ga_access_log": "",
    "alicloud_ga_acl": "ALIYUN::GA::Acl",
    # "alicloud_ga_acl_attachment": "",
    # "alicloud_ga_acl_entry_attachment": "",
    # "alicloud_ga_additional_certificate": "",
    "alicloud_ga_bandwidth_package": "ALIYUN::GA::BandwidthPackage",
    "alicloud_ga_bandwidth_package_attachment": "ALIYUN::GA::BandwidthPackageAcceleratorAddition",
    "alicloud_ga_basic_accelerate_ip": "ALIYUN::GA::BasicAccelerateIp",
    # "alicloud_ga_basic_accelerate_ip_endpoint_relation": "",
    "alicloud_ga_basic_accelerator": "ALIYUN::GA::BasicAccelerator",
    "alicloud_ga_basic_endpoint": "ALIYUN::GA::BasicEndpoint",
    "alicloud_ga_basic_endpoint_group": "ALIYUN::GA::BasicEndpointGroup",
    "alicloud_ga_basic_ip_set": "ALIYUN::GA::BasicIpSet",
    # "alicloud_ga_custom_routing_endpoint": "",
    # "alicloud_ga_custom_routing_endpoint_group": "",
    # "alicloud_ga_custom_routing_endpoint_group_destination": "",
    # "alicloud_ga_custom_routing_endpoint_traffic_policy": "",
    "alicloud_ga_domain": "ALIYUN::GA::Domain",
    "alicloud_ga_endpoint_group": "ALIYUN::GA::EndpointGroup",
    "alicloud_ga_forwarding_rule": "ALIYUN::GA::ForwardingRules",
    "alicloud_ga_ip_set": "ALIYUN::GA::IpSets",
    "alicloud_ga_listener": "ALIYUN::GA::Listener",
    # "alicloud_governance_account": "",
    # "alicloud_governance_baseline": "",
    "alicloud_gpdb_account": "ALIYUN::GPDB::Account",
    # "alicloud_gpdb_backup_policy": "",
    # "alicloud_gpdb_connection": "",
    # "alicloud_gpdb_db_group": "",
    # "alicloud_gpdb_db_instance_ip_array": "",
    # "alicloud_gpdb_db_instance_plan": "",
    "alicloud_gpdb_elastic_instance": "ALIYUN::GPDB::ElasticDBInstance",
    # "alicloud_gpdb_external_data_service": "",
    # "alicloud_gpdb_hadoop_data_source": "",
    "alicloud_gpdb_instance": "ALIYUN::GPDB::DBInstance",
    # "alicloud_gpdb_jdbc_data_source": "",
    # "alicloud_gpdb_remote_adb_data_source": "",
    # "alicloud_gpdb_streaming_data_service": "",
    # "alicloud_gpdb_streaming_data_source": "",
    # "alicloud_gpdb_streaming_job": "",
    # "alicloud_graph_database_db_instance": "",
    # "alicloud_havip": "",
    "alicloud_havip_attachment": "ALIYUN::VPC::HaVipAssociation",
    # "alicloud_hbase_instance": "",
    "alicloud_hbr_ecs_backup_client": "ALIYUN::HBR::BackupClients",
    # "alicloud_hbr_ecs_backup_plan": "",
    # "alicloud_hbr_hana_backup_client": "",
    # "alicloud_hbr_hana_backup_plan": "",
    # "alicloud_hbr_hana_instance": "",
    # "alicloud_hbr_nas_backup_plan": "",
    # "alicloud_hbr_oss_backup_plan": "",
    # "alicloud_hbr_ots_backup_plan": "",
    # "alicloud_hbr_policy": "",
    # "alicloud_hbr_policy_binding": "",
    # "alicloud_hbr_replication_vault": "",
    "alicloud_hbr_restore_job": "ALIYUN::HBR::RestoreJob",
    # "alicloud_hbr_server_backup_plan": "",
    "alicloud_hbr_vault": "ALIYUN::HBR::Vault",
    "alicloud_hologram_instance": "ALIYUN::Hologram::Instance",
    "alicloud_image": "ALIYUN::ECS::CustomImage",
    "alicloud_image_copy": "ALIYUN::ECS::CopyImage",
    # "alicloud_image_export": "",
    # "alicloud_image_import": "",
    "alicloud_image_share_permission": "ALIYUN::ECS::ImageSharePermission",
    "alicloud_imm_project": "ALIYUN::IMM::Project",
    # "alicloud_imp_app_template": "",
    # "alicloud_ims_oidc_provider": "",
    "alicloud_instance": "ALIYUN::ECS::Instance",
    "alicloud_iot_device_group": "ALIYUN::IOT::DeviceGroup",
    "alicloud_kms_alias": "ALIYUN::KMS::Alias",
    # "alicloud_kms_application_access_point": "",
    # "alicloud_kms_ciphertext": "",
    # "alicloud_kms_client_key": "",
    "alicloud_kms_instance": "ALIYUN::KMS::Instance",
    "alicloud_kms_key": "ALIYUN::KMS::Key",
    # "alicloud_kms_key_version": "",
    "alicloud_kms_network_rule": "ALIYUN::KMS::NetworkRule",
    "alicloud_kms_policy": "ALIYUN::KMS::Policy",
    "alicloud_kms_secret": "ALIYUN::KMS::Secret",
    "alicloud_kvstore_account": "ALIYUN::REDIS::Account",
    "alicloud_kvstore_audit_log_config": "ALIYUN::REDIS::AuditLogConfig",
    # "alicloud_kvstore_backup_policy": "",
    "alicloud_kvstore_connection": "ALIYUN::REDIS::Connection",
    "alicloud_kvstore_instance": "ALIYUN::REDIS::Instance",
    "alicloud_lindorm_instance": "ALIYUN::Lindorm::Instance",
    "alicloud_log_alert": "ALIYUN::SLS::Alert",
    # "alicloud_log_alert_resource": "",
    "alicloud_log_audit": "ALIYUN::SLS::Audit",
    "alicloud_log_dashboard": "ALIYUN::SLS::Dashboard",
    "alicloud_log_etl": "ALIYUN::SLS::Etl",
    # "alicloud_log_ingestion": "",
    "alicloud_log_machine_group": "ALIYUN::SLS::MachineGroup",
    "alicloud_log_oss_export": "ALIYUN::SLS::OssExport",
    # "alicloud_log_oss_shipper": "",
    "alicloud_log_project": "ALIYUN::SLS::Project",
    # "alicloud_log_record": "",
    # "alicloud_log_resource": "",
    "alicloud_log_store": "ALIYUN::SLS::Logstore",
    "alicloud_log_store_index": "ALIYUN::SLS::Index",
    # "alicloud_logtail_attachment": "",
    "alicloud_logtail_config": "ALIYUN::SLS::LogtailConfig",
    # "alicloud_manager_account": "",
    # "alicloud_manager_control_policy": "",
    # "alicloud_manager_control_policy_attachment": "",
    # "alicloud_manager_delegated_administrator": "",
    # "alicloud_manager_directory": "",
    # "alicloud_manager_folder": "",
    # "alicloud_manager_group": "",
    # "alicloud_manager_handshake": "",
    # "alicloud_manager_policy": "",
    # "alicloud_manager_policy_attachment": "",
    # "alicloud_manager_policy_version": "",
    # "alicloud_manager_role": "",
    # "alicloud_manager_saved_query": "",
    # "alicloud_manager_service_linked_role": "",
    # "alicloud_manager_share": "",
    # "alicloud_manager_shared_resource": "",
    # "alicloud_manager_shared_target": "",
    "alicloud_market_order": "ALIYUN::MarketPlace::Order",
    "alicloud_maxcompute_project": "ALIYUN::MaxCompute::Project",
    "alicloud_message_service_queue": "ALIYUN::MNS::Queue",
    "alicloud_message_service_subscription": "ALIYUN::MNS::Subscription",
    "alicloud_message_service_topic": "ALIYUN::MNS::Topic",
    # "alicloud_mhub_app": "",
    # "alicloud_mhub_product": "",
    "alicloud_mns_queue": "ALIYUN::MNS::Queue",
    "alicloud_mns_topic": "ALIYUN::MNS::Topic",
    "alicloud_mns_topic_subscription": "ALIYUN::MNS::Subscription",
    # "alicloud_mongodb_account": "",
    # "alicloud_mongodb_audit_policy": "",
    "alicloud_mongodb_instance": "ALIYUN::MONGODB::Instance",
    # "alicloud_mongodb_serverless_instance": "",
    "alicloud_mongodb_sharding_instance": "ALIYUN::MONGODB::ShardingInstance",
    # "alicloud_mongodb_sharding_network_private_address": "",
    # "alicloud_mongodb_sharding_network_public_address": "",
    # "alicloud_msc_sub_contact": "",
    # "alicloud_msc_sub_subscription": "",
    # "alicloud_msc_sub_webhook": "",
    "alicloud_mse_cluster": "ALIYUN::MSE::Cluster",
    "alicloud_mse_engine_namespace": "ALIYUN::MSE::EngineNamespace",
    "alicloud_mse_gateway": "ALIYUN::MSE::Gateway",
    # "alicloud_mse_znode": "",
    "alicloud_nas_access_group": "ALIYUN::NAS::AccessGroup",
    # "alicloud_nas_access_point": "",
    "alicloud_nas_access_rule": "ALIYUN::NAS::AccessRule",
    # "alicloud_nas_auto_snapshot_policy": "",
    "alicloud_nas_data_flow": "ALIYUN::NAS::DataFlow",
    "alicloud_nas_file_system": "ALIYUN::NAS::FileSystem",
    "alicloud_nas_fileset": "ALIYUN::NAS::Fileset",
    # "alicloud_nas_lifecycle_policy": "",
    "alicloud_nas_mount_target": "ALIYUN::NAS::MountTarget",
    # "alicloud_nas_recycle_bin": "",
    # "alicloud_nas_smb_acl_attachment": "",
    # "alicloud_nas_snapshot": "",
    "alicloud_nat_gateway": "ALIYUN::VPC::NatGateway",
    "alicloud_network_acl": "ALIYUN::VPC::NetworkAcl",
    "alicloud_network_acl_attachment": "ALIYUN::VPC::NetworkAclAssociation",
    # "alicloud_network_acl_entries": "",
    "alicloud_nlb_listener": "ALIYUN::NLB::Listener",
    # "alicloud_nlb_listener_additional_certificate_attachment": "",
    "alicloud_nlb_load_balancer": "ALIYUN::NLB::LoadBalancer",
    "alicloud_nlb_load_balancer_security_group_attachment": "ALIYUN::NLB::SecurityGroupAttachment",
    # "alicloud_nlb_loadbalancer_common_bandwidth_package_attachment": "",
    "alicloud_nlb_security_policy": "ALIYUN::NLB::SecurityPolicy",
    "alicloud_nlb_server_group": "ALIYUN::NLB::ServerGroup",
    # "alicloud_nlb_server_group_server_attachment": "",
    # "alicloud_ocean_base_instance": "",
    "alicloud_ons_group": "ALIYUN::ROCKETMQ::Group",
    "alicloud_ons_instance": "ALIYUN::ROCKETMQ::Instance",
    "alicloud_ons_topic": "ALIYUN::ROCKETMQ::Topic",
    # "alicloud_oos_application": "",
    # "alicloud_oos_application_group": "",
    "alicloud_oos_default_patch_baseline": "ALIYUN::OOS::DefaultPatchBaseline",
    "alicloud_oos_execution": "ALIYUN::OOS::Execution",
    "alicloud_oos_parameter": "ALIYUN::OOS::Parameter",
    "alicloud_oos_patch_baseline": "ALIYUN::OOS::PatchBaseline",
    "alicloud_oos_secret_parameter": "ALIYUN::OOS::SecretParameter",
    # "alicloud_oos_service_setting": "",
    "alicloud_oos_state_configuration": "ALIYUN::OOS::StateConfiguration",
    "alicloud_oos_template": "ALIYUN::OOS::Template",
    # "alicloud_open_search_app_group": "",
    # "alicloud_oss_account_public_access_block": "",
    "alicloud_oss_bucket": "ALIYUN::OSS::Bucket",
    # "alicloud_oss_bucket_access_monitor": "",  # No Need
    # "alicloud_oss_bucket_acl": "",  # No Need
    # "alicloud_oss_bucket_cors": "",  # No Need
    # "alicloud_oss_bucket_data_redundancy_transition": "",  # No Need
    # "alicloud_oss_bucket_https_config": "",  # No Need
    # "alicloud_oss_bucket_logging": "",  # No Need
    # "alicloud_oss_bucket_meta_query": "",  # No Need
    # "alicloud_oss_bucket_object": "",
    # "alicloud_oss_bucket_policy": "",  # No Need
    # "alicloud_oss_bucket_public_access_block": "",  # No Need
    # "alicloud_oss_bucket_referer": "",  # No Need
    # "alicloud_oss_bucket_replication": "",  # No Need
    # "alicloud_oss_bucket_request_payment": "",  # No Need
    # "alicloud_oss_bucket_server_side_encryption": "",  # No Need
    # "alicloud_oss_bucket_transfer_acceleration": "",  # No Need
    # "alicloud_oss_bucket_user_defined_log_fields": "",  # No Need
    # "alicloud_oss_bucket_versioning": "",  # No Need
    "alicloud_ots_instance": "ALIYUN::OTS::Instance",
    # "alicloud_ots_instance_attachment": "",
    "alicloud_ots_search_index": "ALIYUN::OTS::SearchIndex",
    # "alicloud_ots_secondary_index": "",
    "alicloud_ots_table": "ALIYUN::OTS::Table",
    # "alicloud_ots_tunnel": "",
    "alicloud_polardb_account": "ALIYUN::POLARDB::Account",
    "alicloud_polardb_account_privilege": "ALIYUN::POLARDB::AccountPrivilege",
    # "alicloud_polardb_backup_policy": "",
    "alicloud_polardb_cluster": "ALIYUN::POLARDB::DBCluster",
    # "alicloud_polardb_cluster_endpoint": "",
    "alicloud_polardb_database": "ALIYUN::POLARDB::DBInstance",
    "alicloud_polardb_endpoint": "ALIYUN::POLARDB::DBClusterEndpoint",
    "alicloud_polardb_endpoint_address": "ALIYUN::POLARDB::DBClusterEndpointAddress",
    "alicloud_polardb_global_database_network": "ALIYUN::POLARDB::GlobalDatabaseNetwork",
    "alicloud_polardb_parameter_group": "ALIYUN::POLARDB::ParameterGroup",
    # "alicloud_polardb_primary_endpoint": "",
    "alicloud_privatelink_vpc_endpoint": "ALIYUN::PrivateLink::VpcEndpoint",
    # "alicloud_privatelink_vpc_endpoint_connection": "",
    "alicloud_privatelink_vpc_endpoint_service": "ALIYUN::PrivateLink::VpcEndpointService",
    # "alicloud_privatelink_vpc_endpoint_service_resource": "",
    # "alicloud_privatelink_vpc_endpoint_service_user": "",
    # "alicloud_privatelink_vpc_endpoint_zone": "",
    # "alicloud_pvtz_endpoint": "",
    "alicloud_pvtz_rule": "ALIYUN::PVTZ::Rule",
    # "alicloud_pvtz_rule_attachment": "",
    "alicloud_pvtz_user_vpc_authorization": "ALIYUN::PVTZ::UserVpcAuthorization",
    "alicloud_pvtz_zone": "ALIYUN::PVTZ::Zone",
    # "alicloud_pvtz_zone_attachment": "",
    "alicloud_pvtz_zone_record": "ALIYUN::PVTZ::ZoneRecord",
    # "alicloud_quick_bi_user": "",
    # "alicloud_quotas_quota_alarm": "",
    # "alicloud_quotas_quota_application": "",
    # "alicloud_quotas_template_applications": "",
    # "alicloud_quotas_template_quota": "",
    # "alicloud_quotas_template_service": "",
    "alicloud_ram_access_key": "ALIYUN::RAM::AccessKey",
    "alicloud_ram_account_alias": "ALIYUN::RAM::RamAccountAlias",
    # "alicloud_ram_account_password_policy": "",
    "alicloud_ram_group": "ALIYUN::RAM::Group",
    # "alicloud_ram_group_membership": "",
    # "alicloud_ram_group_policy_attachment": "",
    "alicloud_ram_login_profile": "ALIYUN::RAM::LoginProfile",
    "alicloud_ram_policy": "ALIYUN::RAM::ManagedPolicy",
    "alicloud_ram_role": "ALIYUN::RAM::Role",
    "alicloud_ram_role_attachment": "ALIYUN::ECS::RamRoleAttachment",
    "alicloud_ram_role_policy_attachment": "ALIYUN::RAM::AttachPolicyToRole",
    "alicloud_ram_saml_provider": "ALIYUN::RAM::SAMLProvider",
    "alicloud_ram_security_preference": "ALIYUN::RAM::SecurityPreference",
    "alicloud_ram_user": "ALIYUN::RAM::User",
    "alicloud_ram_user_policy_attachment": "ALIYUN::RAM::AttachPolicyToUser",
    # "alicloud_rdc_organization": "",
    "alicloud_rds_account": "ALIYUN::RDS::Account",
    # "alicloud_rds_backup": "",
    # "alicloud_rds_clone_db_instance": "",
    # "alicloud_rds_db_instance_endpoint": "",
    # "alicloud_rds_db_instance_endpoint_address": "",
    # "alicloud_rds_db_node": "",
    # "alicloud_rds_db_proxy": "",
    # "alicloud_rds_ddr_instance": "",
    # "alicloud_rds_instance_cross_backup_policy": "",
    "alicloud_rds_parameter_group": "ALIYUN::RDS::DBInstanceParameterGroup",
    # "alicloud_rds_service_linked_role": "",
    # "alicloud_rds_upgrade_db_instance": "",
    # "alicloud_realtime_compute_vvp_instance": "",
    "alicloud_redis_tair_instance": "ALIYUN::REDIS::Instance",
    # "alicloud_reserved_instance": "",
    "alicloud_resource_manager_account": "ALIYUN::ResourceManager::Account",
    "alicloud_resource_manager_control_policy": "ALIYUN::ResourceManager::ControlPolicy",
    "alicloud_resource_manager_control_policy_attachment": "ALIYUN::ResourceManager::ControlPolicyAttachment",
    "alicloud_resource_manager_folder": "ALIYUN::ResourceManager::Folder",
    "alicloud_resource_manager_handshake": "ALIYUN::ResourceManager::Handshake",
    "alicloud_resource_manager_policy_attachment": "ALIYUN::ResourceManager::PolicyAttachment",
    "alicloud_resource_manager_resource_directory": "ALIYUN::ResourceManager::ResourceDirectory",
    "alicloud_resource_manager_resource_group": "ALIYUN::ResourceManager::ResourceGroup",
    "alicloud_resource_manager_resource_share": "ALIYUN::ResourceManager::ResourceShare",
    "alicloud_rocketmq_consumer_group": "ALIYUN::ROCKETMQ5::ConsumerGroup",
    "alicloud_rocketmq_instance": "ALIYUN::ROCKETMQ5::Instance",
    "alicloud_rocketmq_topic": "ALIYUN::ROCKETMQ5::Topic",
    # "alicloud_ros_change_set": "",  # No Need
    "alicloud_ros_stack": "ALIYUN::ROS::Stack",
    "alicloud_ros_stack_group": "ALIYUN::ROS::StackGroup",
    "alicloud_ros_stack_instance": "ALIYUN::ROS::StackInstances",
    # "alicloud_ros_template": "",  # No Need
    "alicloud_ros_template_scratch": "ALIYUN::ROS::TemplateScratch",
    "alicloud_route_entry": "ALIYUN::ECS::Route",
    "alicloud_route_table": "ALIYUN::VPC::RouteTable",
    "alicloud_route_table_attachment": "ALIYUN::VPC::RouteTableAssociation",
    "alicloud_router_interface": "ALIYUN::VPC::RouterInterface",
    "alicloud_router_interface_connection": "ALIYUN::VPC::PeeringRouterInterfaceConnection",
    "alicloud_sae_application": "ALIYUN::SAE::Application",
    # "alicloud_sae_application_scaling_rule": "",
    "alicloud_sae_config_map": "ALIYUN::SAE::ConfigMap",
    # "alicloud_sae_grey_tag_route": "",
    "alicloud_sae_ingress": "ALIYUN::SAE::Ingress",
    # "alicloud_sae_load_balancer_internet": "",
    # "alicloud_sae_load_balancer_intranet": "",
    "alicloud_sae_namespace": "ALIYUN::SAE::Namespace",
    "alicloud_sag_acl": "ALIYUN::SAG::ACL",
    "alicloud_sag_acl_rule": "ALIYUN::SAG::ACLRule",
    # "alicloud_sag_client_user": "",
    # "alicloud_sag_dnat_entry": "",
    "alicloud_sag_qos": "ALIYUN::SAG::Qos",
    "alicloud_sag_qos_car": "ALIYUN::SAG::QosCar",
    "alicloud_sag_qos_policy": "ALIYUN::SAG::QosPolicy",
    # "alicloud_sag_snat_entry": "",
    # "alicloud_scdn_domain": "",
    # "alicloud_scdn_domain_config": "",
    # "alicloud_schedulerx_namespace": "",
    # "alicloud_sddp_config": "",
    # "alicloud_sddp_data_limit": "",
    # "alicloud_sddp_instance": "",
    # "alicloud_sddp_rule": "",
    # "alicloud_security_center_group": "",
    # "alicloud_security_center_service_linked_role": "",
    "alicloud_security_group": "ALIYUN::ECS::SecurityGroup",
    "alicloud_security_group_rule": "ALIYUN::ECS::SecurityGroupIngress",
    # "alicloud_selectdb_db_cluster": "",
    # "alicloud_selectdb_db_instance": "",
    # "alicloud_service_catalog_portfolio": "",
    # "alicloud_service_catalog_principal_portfolio_association": "",
    # "alicloud_service_catalog_product": "",
    # "alicloud_service_catalog_product_portfolio_association": "",
    # "alicloud_service_catalog_product_version": "",
    # "alicloud_service_catalog_provisioned_product": "",
    # "alicloud_service_mesh_extension_provider": "",
    # "alicloud_service_mesh_service_mesh": "",
    # "alicloud_service_mesh_user_permission": "",
    # "alicloud_simple_application_server_custom_image": "",
    # "alicloud_simple_application_server_firewall_rule": "",
    "alicloud_simple_application_server_instance": "ALIYUN::SWAS::Instance",
    # "alicloud_simple_application_server_snapshot": "",
    "alicloud_slb_acl": "ALIYUN::SLB::AccessControl",
    # "alicloud_slb_acl_entry_attachment": "",
    "alicloud_slb_attachment": "ALIYUN::SLB::BackendServerAttachment",
    "alicloud_slb_backend_server": "ALIYUN::SLB::BackendServerAttachment",
    "alicloud_slb_ca_certificate": "ALIYUN::SLB::Certificate",
    "alicloud_slb_domain_extension": "ALIYUN::SLB::DomainExtension",
    "alicloud_slb_listener": "ALIYUN::SLB::Listener",
    "alicloud_slb_load_balancer": "ALIYUN::SLB::LoadBalancer",
    "alicloud_slb_master_slave_server_group": "ALIYUN::SLB::MasterSlaveServerGroup",
    "alicloud_slb_rule": "ALIYUN::SLB::Rule",
    "alicloud_slb_server_certificate": "ALIYUN::SLB::Certificate",
    "alicloud_slb_server_group": "ALIYUN::SLB::VServerGroup",
    "alicloud_slb_server_group_server_attachment": "ALIYUN::SLB::BackendServerToVServerGroupAddition",
    "alicloud_slb_tls_cipher_policy": "ALIYUN::SLB::TLSPolicy",
    "alicloud_sls_alert": "ALIYUN::SLS::Alert",
    # "alicloud_sls_scheduled_sql": "",
    # "alicloud_smartag_flow_log": "",
    # "alicloud_sms_short_url": "",
    "alicloud_snat_entry": "ALIYUN::ECS::SNatEntry",
    "alicloud_ssl_certificates_service_certificate": "ALIYUN::CAS::Certificate",
    "alicloud_ssl_vpn_client_cert": "ALIYUN::VPC::SslVpnClientCert",
    "alicloud_ssl_vpn_server": "ALIYUN::VPC::SslVpnServer",
    # "alicloud_tag_meta_tag": "",
    # "alicloud_tag_policy": "",
    # "alicloud_tag_policy_attachment": "",
    "alicloud_threat_detection_anti_brute_force_rule": "ALIYUN::ThreatDetection::AntiBruteForceRule",
    # "alicloud_threat_detection_backup_policy": "",
    # "alicloud_threat_detection_baseline_strategy": "",
    # "alicloud_threat_detection_client_file_protect": "",
    # "alicloud_threat_detection_client_user_define_rule": "",
    # "alicloud_threat_detection_file_upload_limit": "",
    # "alicloud_threat_detection_honey_pot": "",
    # "alicloud_threat_detection_honeypot_node": "",
    # "alicloud_threat_detection_honeypot_preset": "",
    # "alicloud_threat_detection_honeypot_probe": "",
    # "alicloud_threat_detection_image_event_operation": "",
    "alicloud_threat_detection_instance": "ALIYUN::ThreatDetection::Instance",
    # "alicloud_threat_detection_malicious_file_whitelist_config": "",
    # "alicloud_threat_detection_oss_scan_config": "",
    # "alicloud_threat_detection_sas_trail": "",
    # "alicloud_threat_detection_vul_whitelist": "",
    # "alicloud_threat_detection_web_lock_config": "",
    "alicloud_tsdb_instance": "ALIYUN::TSDB::HiTSDBInstance",
    # "alicloud_video_surveillance_system_group": "",
    # "alicloud_vod_domain": "",
    "alicloud_vod_editing_project": "ALIYUN::VOD::EditingProject",
    "alicloud_vpc": "ALIYUN::ECS::VPC",
    "alicloud_vpc_bgp_group": "ALIYUN::VPC::BgpGroup",
    "alicloud_vpc_bgp_network": "ALIYUN::VPC::BgpNetwork",
    "alicloud_vpc_bgp_peer": "ALIYUN::VPC::BgpPeer",
    "alicloud_vpc_dhcp_options_set": "ALIYUN::VPC::DhcpOptionsSet",
    "alicloud_vpc_dhcp_options_set_attachment": "ALIYUN::VPC::DhcpOptionsSetAttachment",
    "alicloud_vpc_flow_log": "ALIYUN::VPC::FlowLog",
    # "alicloud_vpc_gateway_endpoint": "",
    # "alicloud_vpc_gateway_endpoint_route_table_attachment": "",
    # "alicloud_vpc_gateway_route_table_attachment": "",
    "alicloud_vpc_ha_vip": "ALIYUN::VPC::HaVip",
    # "alicloud_vpc_ipv4_cidr_block": "",
    "alicloud_vpc_ipv4_gateway": "ALIYUN::VPC::Ipv4Gateway",
    # "alicloud_vpc_ipv6_address": "",
    # "alicloud_vpc_ipv6_egress_rule": "",
    "alicloud_vpc_ipv6_gateway": "ALIYUN::VPC::Ipv6Gateway",
    "alicloud_vpc_ipv6_internet_bandwidth": "ALIYUN::VPC::Ipv6InternetBandwidth",
    "alicloud_vpc_nat_ip": "ALIYUN::VPC::NatIp",
    "alicloud_vpc_nat_ip_cidr": "ALIYUN::VPC::NatIpCidr",
    "alicloud_vpc_network_acl_attachment": "ALIYUN::VPC::NetworkAclAssociation",
    "alicloud_vpc_peer_connection": "ALIYUN::VPC::VpcPeerConnection",
    # "alicloud_vpc_peer_connection_accepter": "",
    "alicloud_vpc_prefix_list": "ALIYUN::VPC::PrefixList",
    # "alicloud_vpc_public_ip_address_pool": "",
    # "alicloud_vpc_public_ip_address_pool_cidr_block": "",
    "alicloud_vpc_traffic_mirror_filter": "ALIYUN::VPC::TrafficMirrorFilter",
    # "alicloud_vpc_traffic_mirror_filter_egress_rule": "",
    # "alicloud_vpc_traffic_mirror_filter_ingress_rule": "",
    "alicloud_vpc_traffic_mirror_session": "ALIYUN::VPC::TrafficMirrorSession",
    # "alicloud_vpc_vbr_ha": "",
    "alicloud_vpc_vswitch_cidr_reservation": "ALIYUN::VPC::VSwitchCidrReservation",
    "alicloud_vpn_connection": "ALIYUN::VPC::VpnConnection",
    "alicloud_vpn_customer_gateway": "ALIYUN::VPC::CustomerGateway",
    "alicloud_vpn_gateway": "ALIYUN::VPC::VpnGateway",
    # "alicloud_vpn_gateway_vco_route": "",
    "alicloud_vpn_gateway_vpn_attachment": "ALIYUN::VPC::VpnAttachment",
    "alicloud_vpn_ipsec_server": "ALIYUN::VPC::IpsecServer",
    "alicloud_vpn_pbr_route_entry": "ALIYUN::VPC::VpnPbrRouteEntry",
    "alicloud_vpn_route_entry": "ALIYUN::VPC::VpnRouteEntry",
    "alicloud_vswitch": "ALIYUN::ECS::VSwitch",
    # "alicloud_waf_certificate": "",
    "alicloud_waf_domain": "ALIYUN::WAF::Domain",
    "alicloud_waf_instance": "ALIYUN::WAF::Instance",
    # "alicloud_waf_protection_module": "",
    # "alicloud_wafv3_defense_template": "",
    # "alicloud_wafv3_domain": "",
    "alicloud_wafv3_instance": "ALIYUN::WAF3::Instance",
    # "alicloud_yundun_dbaudit_instance": "",
}

CF_ROS_PROD_MAPPINGS = {
    "ACMPCA": "CAS",
    # "APS": "",
    # "AccessAnalyzer": "",
    # "AmazonMQ": "",
    # "Amplify": "",
    # "AmplifyUIBuilder": "",
    "ApiGateway": "ApiGateway",
    "ApiGatewayV2": "ApiGateway",
    # "AppConfig": "",
    # "AppFlow": "",
    # "AppIntegrations": "",
    # "AppMesh": "",
    # "AppRunner": "",
    # "AppStream": "",
    # "AppSync": "",
    # "ApplicationAutoScaling": "",
    # "ApplicationInsights": "",
    # "Athena": "",
    # "AuditManager": "",
    "AutoScaling": "ESS",
    # "AutoScalingPlans": "",
    # "Backup": "",
    # "BackupGateway": "",
    # "Batch": "",
    # "BillingConductor": "",
    # "Budgets": "",
    # "CE": "",
    # "CUR": "",
    # "Cassandra": "",
    # "CertificateManager": "",
    # "Chatbot": "",
    # "CleanRooms": "",
    # "Cloud9": "",
    "CloudFormation": "ROS",
    "CloudFront": "CDN",
    "CloudTrail": "ACTIONTRAIL",
    "CloudWatch": "CMS",
    # "CodeArtifact": "",
    # "CodeBuild": "",
    # "CodeCommit": "",
    # "CodeDeploy": "",
    # "CodeGuruProfiler": "",
    # "CodeGuruReviewer": "",
    # "CodePipeline": "",
    # "CodeStar": "",
    # "CodeStarConnections": "",
    # "CodeStarNotifications": "",
    # "Cognito": "",
    # "Comprehend": "",
    "Config": "Config",
    # "Connect": "",
    # "ConnectCampaigns": "",
    # "ControlTower": "",
    # "CustomerProfiles": "",
    # "DAX": "",
    # "DLM": "",
    # "DMS": "",
    # "DataBrew": "",
    # "DataPipeline": "",
    # "DataSync": "",
    # "Detective": "",
    # "DevOpsGuru": "",
    # "DirectoryService": "",
    # "DocDB": "",
    # "DocDBElastic": "",
    "DynamoDB": "OTS",
    "EC2": "ECS",
    "ECR": "CR",
    "ECS": "CS",
    "EFS": "NAS",
    "EKS": "CS",
    "EMR": "EMR",
    # "EMRContainers": "",
    # "EMRServerless": "",
    "ElastiCache": "REDIS",
    # "ElasticBeanstalk": "",
    "ElasticLoadBalancing": "SLB",
    "ElasticLoadBalancingV2": "SLB",
    "Elasticsearch": "ElasticSearch",
    # "EntityResolution": "",
    # "EventSchemas": "",
    "Events": "EventBridge",
    # "Evidently": "",
    # "FIS": "",
    # "FMS": "",
    # "FSx": "",
    # "FinSpace": "",
    # "Forecast": "",
    # "FraudDetector": "",
    # "GameLift": "",
    "GlobalAccelerator": "GA",
    # "Glue": "",
    # "Grafana": "",
    # "Greengrass": "",
    # "GreengrassV2": "",
    # "GroundStation": "",
    # "GuardDuty": "",
    # "HealthImaging": "",
    # "HealthLake": "",
    "IAM": "RAM",
    # "IVS": "",
    # "IVSChat": "",
    # "IdentityStore": "",
    # "ImageBuilder": "",
    # "Inspector": "",
    # "InspectorV2": "",
    # "InternetMonitor": "",
    "IoT": "IOT",
    # "IoT1Click": "",
    # "IoTAnalytics": "",
    # "IoTCoreDeviceAdvisor": "",
    # "IoTEvents": "",
    # "IoTFleetHub": "",
    # "IoTFleetWise": "",
    # "IoTSiteWise": "",
    # "IoTThingsGraph": "",
    # "IoTTwinMaker": "",
    # "IoTWireless": "",
    "KMS": "KMS",
    # "KafkaConnect": "",
    # "Kendra": "",
    # "KendraRanking": "",
    # "Kinesis": "",
    # "KinesisAnalytics": "",
    # "KinesisAnalyticsV2": "",
    # "KinesisFirehose": "",
    # "KinesisVideo": "",
    # "LakeFormation": "",
    "Lambda": "FC",
    # "Lex": "",
    # "LicenseManager": "",
    # "Lightsail": "",
    # "Location": "",
    # "Logs": "",
    # "LookoutEquipment": "",
    # "LookoutMetrics": "",
    # "LookoutVision": "",
    # "M2": "",
    # "MSK": "",
    # "MWAA": "",
    # "Macie": "",
    # "ManagedBlockchain": "",
    # "MediaConnect": "",
    # "MediaConvert": "",
    # "MediaLive": "",
    # "MediaPackage": "",
    # "MediaPackageV2": "",
    # "MediaStore": "",
    # "MediaTailor": "",
    # "MemoryDB": "",
    # "Neptune": "",
    # "NetworkFirewall": "",
    # "NetworkManager": "",
    # "NimbleStudio": "",
    # "OSIS": "",
    # "Oam": "",
    # "Omics": "",
    # "OpenSearchServerless": "",
    # "OpenSearchService": "",
    # "OpsWorks": "",
    # "OpsWorksCM": "",
    "Organizations": "ResourceManager",
    # "PCAConnectorAD": "",
    # "Panorama": "",
    # "Personalize": "",
    # "Pinpoint": "",
    # "PinpointEmail": "",
    # "Pipes": "",
    # "Proton": "",
    # "QLDB": "",
    # "QuickSight": "",
    # "RAM": "",
    "RDS": "RDS",
    # "RUM": "",
    # "Redshift": "",
    # "RedshiftServerless": "",
    # "RefactorSpaces": "",
    # "Rekognition": "",
    # "ResilienceHub": "",
    # "ResourceExplorer2": "",
    "ResourceGroups": "ResourceManager",
    # "RoboMaker": "",
    # "RolesAnywhere": "",
    # "Route53": "",
    # "Route53RecoveryControl": "",
    # "Route53RecoveryReadiness": "",
    # "Route53Resolver": "",
    "S3": "OSS",
    # "S3ObjectLambda": "",
    # "S3Outposts": "",
    # "SDB": "",
    "SES": "DirectMail",
    "SNS": "",
    "SQS": "",
    # "SSM": "",
    # "SSMContacts": "",
    # "SSMIncidents": "",
    # "SSO": "",
    # "SageMaker": "",
    # "Scheduler": "",
    # "SecretsManager": "",
    # "SecurityHub": "",
    # "ServiceCatalog": "",
    # "ServiceCatalogAppRegistry": "",
    # "ServiceDiscovery": "",
    # "Shield": "",
    # "Signer": "",
    # "SimSpaceWeaver": "",
    # "StepFunctions": "",
    # "SupportApp": "",
    # "Synthetics": "",
    # "SystemsManagerSAP": "",
    # "Timestream": "",
    # "Transfer": "",
    # "VerifiedPermissions": "",
    # "VoiceID": "",
    # "VpcLattice": "",
    "WAF": "WAF",
    # "WAFRegional": "",
    # "WAFv2": "",
    # "Wisdom": "",
    # "WorkSpaces": "",
    # "WorkSpacesWeb": "",
    # "XRay": ""
}

CF_ROS_PROP_MAPPINGS = {
    "*": {
        "AvailabilityZone": "ZoneId",
    },
    "AWS::EC2::Instance": {"BlockDeviceMappings": "DiskMappings"},
}

CF_ROS_GENERATE_MAPPINGS = {
    "AWS::ACMPCA::Certificate": "ALIYUN::CAS::Certificate",
    # "AWS::ACMPCA::CertificateAuthority": "",
    # "AWS::ACMPCA::CertificateAuthorityActivation": "",
    # "AWS::ACMPCA::Permission": "",
    # "AWS::APS::RuleGroupsNamespace": "",
    # "AWS::APS::Workspace": "",
    # "AWS::AccessAnalyzer::Analyzer": "",
    # "AWS::AmazonMQ::Broker": "",
    # "AWS::AmazonMQ::Configuration": "",
    # "AWS::AmazonMQ::ConfigurationAssociation": "",
    # "AWS::Amplify::App": "",
    # "AWS::Amplify::Branch": "",
    # "AWS::Amplify::Domain": "",
    # "AWS::AmplifyUIBuilder::Component": "",
    # "AWS::AmplifyUIBuilder::Form": "",
    # "AWS::AmplifyUIBuilder::Theme": "",
    # "AWS::ApiGateway::Account": "",
    # "AWS::ApiGateway::ApiKey": "",
    # "AWS::ApiGateway::Authorizer": "",
    # "AWS::ApiGateway::BasePathMapping": "",
    # "AWS::ApiGateway::ClientCertificate": "",
    "AWS::ApiGateway::Deployment": "ALIYUN::ApiGateway::Deployment",
    # "AWS::ApiGateway::DocumentationPart": "",
    # "AWS::ApiGateway::DocumentationVersion": "",
    # "AWS::ApiGateway::DomainName": "",
    # "AWS::ApiGateway::GatewayResponse": "",
    # "AWS::ApiGateway::Method": "",
    # "AWS::ApiGateway::Model": "",
    # "AWS::ApiGateway::RequestValidator": "",
    # "AWS::ApiGateway::Resource": "",
    # "AWS::ApiGateway::RestApi": "",
    # "AWS::ApiGateway::Stage": "",
    # "AWS::ApiGateway::UsagePlan": "",
    # "AWS::ApiGateway::UsagePlanKey": "",
    # "AWS::ApiGateway::VpcLink": "",
    "AWS::ApiGatewayV2::Api": "ALIYUN::ApiGateway::Api",
    # "AWS::ApiGatewayV2::ApiGatewayManagedOverrides": "",
    # "AWS::ApiGatewayV2::ApiMapping": "",
    # "AWS::ApiGatewayV2::Authorizer": "",
    "AWS::ApiGatewayV2::Deployment": "ALIYUN::ApiGateway::Deployment",
    # "AWS::ApiGatewayV2::DomainName": "",
    # "AWS::ApiGatewayV2::Integration": "",
    # "AWS::ApiGatewayV2::IntegrationResponse": "",
    # "AWS::ApiGatewayV2::Model": "",
    # "AWS::ApiGatewayV2::Route": "",
    # "AWS::ApiGatewayV2::RouteResponse": "",
    # "AWS::ApiGatewayV2::Stage": "",
    # "AWS::ApiGatewayV2::VpcLink": "",
    # "AWS::AppConfig::Application": "",
    # "AWS::AppConfig::ConfigurationProfile": "",
    # "AWS::AppConfig::Deployment": "",
    # "AWS::AppConfig::DeploymentStrategy": "",
    # "AWS::AppConfig::Environment": "",
    # "AWS::AppConfig::Extension": "",
    # "AWS::AppConfig::ExtensionAssociation": "",
    # "AWS::AppConfig::HostedConfigurationVersion": "",
    # "AWS::AppFlow::Connector": "",
    # "AWS::AppFlow::ConnectorProfile": "",
    # "AWS::AppFlow::Flow": "",
    # "AWS::AppIntegrations::DataIntegration": "",
    # "AWS::AppIntegrations::EventIntegration": "",
    # "AWS::AppMesh::GatewayRoute": "",
    # "AWS::AppMesh::Mesh": "",
    # "AWS::AppMesh::Route": "",
    # "AWS::AppMesh::VirtualGateway": "",
    # "AWS::AppMesh::VirtualNode": "",
    # "AWS::AppMesh::VirtualRouter": "",
    # "AWS::AppMesh::VirtualService": "",
    # "AWS::AppRunner::AutoScalingConfiguration": "",
    # "AWS::AppRunner::ObservabilityConfiguration": "",
    # "AWS::AppRunner::Service": "",
    # "AWS::AppRunner::VpcConnector": "",
    # "AWS::AppRunner::VpcIngressConnection": "",
    # "AWS::AppStream::AppBlock": "",
    # "AWS::AppStream::AppBlockBuilder": "",
    # "AWS::AppStream::Application": "",
    # "AWS::AppStream::ApplicationEntitlementAssociation": "",
    # "AWS::AppStream::ApplicationFleetAssociation": "",
    # "AWS::AppStream::DirectoryConfig": "",
    # "AWS::AppStream::Entitlement": "",
    # "AWS::AppStream::Fleet": "",
    # "AWS::AppStream::ImageBuilder": "",
    # "AWS::AppStream::Stack": "",
    # "AWS::AppStream::StackFleetAssociation": "",
    # "AWS::AppStream::StackUserAssociation": "",
    # "AWS::AppStream::User": "",
    # "AWS::AppSync::ApiCache": "",
    # "AWS::AppSync::ApiKey": "",
    # "AWS::AppSync::DataSource": "",
    # "AWS::AppSync::DomainName": "",
    # "AWS::AppSync::DomainNameApiAssociation": "",
    # "AWS::AppSync::FunctionConfiguration": "",
    # "AWS::AppSync::GraphQLApi": "",
    # "AWS::AppSync::GraphQLSchema": "",
    # "AWS::AppSync::Resolver": "",
    # "AWS::AppSync::SourceApiAssociation": "",
    # "AWS::ApplicationAutoScaling::ScalableTarget": "",
    # "AWS::ApplicationAutoScaling::ScalingPolicy": "",
    # "AWS::ApplicationInsights::Application": "",
    # "AWS::Athena::CapacityReservation": "",
    # "AWS::Athena::DataCatalog": "",
    # "AWS::Athena::NamedQuery": "",
    # "AWS::Athena::PreparedStatement": "",
    # "AWS::Athena::WorkGroup": "",
    # "AWS::AuditManager::Assessment": "",
    "AWS::AutoScaling::AutoScalingGroup": "ALIYUN::ESS::ScalingGroup",
    "AWS::AutoScaling::LaunchConfiguration": "ALIYUN::ESS::ScalingConfiguration",
    "AWS::AutoScaling::LifecycleHook": "ALIYUN::ESS::LifecycleHook",
    "AWS::AutoScaling::ScalingPolicy": "ALIYUN::ESS::ScalingRule",
    # "AWS::AutoScaling::ScheduledAction": "",
    # "AWS::AutoScaling::WarmPool": "",
    # "AWS::AutoScalingPlans::ScalingPlan": "",
    # "AWS::Backup::BackupPlan": "",
    # "AWS::Backup::BackupSelection": "",
    # "AWS::Backup::BackupVault": "",
    # "AWS::Backup::Framework": "",
    # "AWS::Backup::ReportPlan": "",
    # "AWS::BackupGateway::Hypervisor": "",
    # "AWS::Batch::ComputeEnvironment": "",
    # "AWS::Batch::JobDefinition": "",
    # "AWS::Batch::JobQueue": "",
    # "AWS::Batch::SchedulingPolicy": "",
    # "AWS::BillingConductor::BillingGroup": "",
    # "AWS::BillingConductor::CustomLineItem": "",
    # "AWS::BillingConductor::PricingPlan": "",
    # "AWS::BillingConductor::PricingRule": "",
    # "AWS::Budgets::Budget": "",
    # "AWS::Budgets::BudgetsAction": "",
    # "AWS::CE::AnomalyMonitor": "",
    # "AWS::CE::AnomalySubscription": "",
    # "AWS::CE::CostCategory": "",
    # "AWS::CUR::ReportDefinition": "",
    # "AWS::Cassandra::Keyspace": "",
    # "AWS::Cassandra::Table": "",
    # "AWS::CertificateManager::Account": "",
    # "AWS::CertificateManager::Certificate": "",
    # "AWS::Chatbot::MicrosoftTeamsChannelConfiguration": "",
    # "AWS::Chatbot::SlackChannelConfiguration": "",
    # "AWS::CleanRooms::AnalysisTemplate": "",
    # "AWS::CleanRooms::Collaboration": "",
    # "AWS::CleanRooms::ConfiguredTable": "",
    # "AWS::CleanRooms::ConfiguredTableAssociation": "",
    # "AWS::CleanRooms::Membership": "",
    # "AWS::Cloud9::EnvironmentEC2": "",
    "AWS::CloudFormation::CustomResource": "ALIYUN::ROS::CustomResource",
    # "AWS::CloudFormation::HookDefaultVersion": "",
    # "AWS::CloudFormation::HookTypeConfig": "",
    # "AWS::CloudFormation::HookVersion": "",
    # "AWS::CloudFormation::Macro": "",
    # "AWS::CloudFormation::ModuleDefaultVersion": "",
    # "AWS::CloudFormation::ModuleVersion": "",
    # "AWS::CloudFormation::PublicTypeVersion": "",
    # "AWS::CloudFormation::Publisher": "",
    # "AWS::CloudFormation::ResourceDefaultVersion": "",
    # "AWS::CloudFormation::ResourceVersion": "",
    "AWS::CloudFormation::Stack": "ALIYUN::ROS::Stack",
    # "AWS::CloudFormation::StackSet": "",
    # "AWS::CloudFormation::TypeActivation": "",
    "AWS::CloudFormation::WaitCondition": "ALIYUN::ROS::WaitCondition",
    "AWS::CloudFormation::WaitConditionHandle": "ALIYUN::ROS::WaitConditionHandle",
    # "AWS::CloudFront::CachePolicy": "",
    # "AWS::CloudFront::CloudFrontOriginAccessIdentity": "",
    # "AWS::CloudFront::ContinuousDeploymentPolicy": "",
    # "AWS::CloudFront::Distribution": "",
    # "AWS::CloudFront::Function": "",
    # "AWS::CloudFront::KeyGroup": "",
    # "AWS::CloudFront::MonitoringSubscription": "",
    # "AWS::CloudFront::OriginAccessControl": "",
    # "AWS::CloudFront::OriginRequestPolicy": "",
    # "AWS::CloudFront::PublicKey": "",
    # "AWS::CloudFront::RealtimeLogConfig": "",
    # "AWS::CloudFront::ResponseHeadersPolicy": "",
    # "AWS::CloudFront::StreamingDistribution": "",
    # "AWS::CloudTrail::Channel": "",
    # "AWS::CloudTrail::EventDataStore": "",
    # "AWS::CloudTrail::ResourcePolicy": "",
    "AWS::CloudTrail::Trail": "ALIYUN::ACTIONTRAIL::Trail",
    # "AWS::CloudWatch::Alarm": "",
    # "AWS::CloudWatch::AnomalyDetector": "",
    # "AWS::CloudWatch::CompositeAlarm": "",
    # "AWS::CloudWatch::Dashboard": "",
    # "AWS::CloudWatch::InsightRule": "",
    # "AWS::CloudWatch::MetricStream": "",
    # "AWS::CodeArtifact::Domain": "",
    # "AWS::CodeArtifact::Repository": "",
    # "AWS::CodeBuild::Project": "",
    # "AWS::CodeBuild::ReportGroup": "",
    # "AWS::CodeBuild::SourceCredential": "",
    # "AWS::CodeCommit::Repository": "",
    # "AWS::CodeDeploy::Application": "",
    # "AWS::CodeDeploy::DeploymentConfig": "",
    # "AWS::CodeDeploy::DeploymentGroup": "",
    # "AWS::CodeGuruProfiler::ProfilingGroup": "",
    # "AWS::CodeGuruReviewer::RepositoryAssociation": "",
    # "AWS::CodePipeline::CustomActionType": "",
    # "AWS::CodePipeline::Pipeline": "",
    # "AWS::CodePipeline::Webhook": "",
    # "AWS::CodeStar::GitHubRepository": "",
    # "AWS::CodeStarConnections::Connection": "",
    # "AWS::CodeStarNotifications::NotificationRule": "",
    # "AWS::Cognito::IdentityPool": "",
    # "AWS::Cognito::IdentityPoolPrincipalTag": "",
    # "AWS::Cognito::IdentityPoolRoleAttachment": "",
    # "AWS::Cognito::LogDeliveryConfiguration": "",
    # "AWS::Cognito::UserPool": "",
    # "AWS::Cognito::UserPoolClient": "",
    # "AWS::Cognito::UserPoolDomain": "",
    # "AWS::Cognito::UserPoolGroup": "",
    # "AWS::Cognito::UserPoolIdentityProvider": "",
    # "AWS::Cognito::UserPoolResourceServer": "",
    # "AWS::Cognito::UserPoolRiskConfigurationAttachment": "",
    # "AWS::Cognito::UserPoolUICustomizationAttachment": "",
    # "AWS::Cognito::UserPoolUser": "",
    # "AWS::Cognito::UserPoolUserToGroupAttachment": "",
    # "AWS::Comprehend::DocumentClassifier": "",
    # "AWS::Comprehend::Flywheel": "",
    # "AWS::Config::AggregationAuthorization": "",
    # "AWS::Config::ConfigRule": "",
    # "AWS::Config::ConfigurationAggregator": "",
    # "AWS::Config::ConfigurationRecorder": "",
    # "AWS::Config::ConformancePack": "",
    "AWS::Config::DeliveryChannel": "ALIYUN::Config::DeliveryChannel",
    # "AWS::Config::OrganizationConfigRule": "",
    # "AWS::Config::OrganizationConformancePack": "",
    # "AWS::Config::RemediationConfiguration": "",
    # "AWS::Config::StoredQuery": "",
    # "AWS::Connect::ApprovedOrigin": "",
    # "AWS::Connect::ContactFlow": "",
    # "AWS::Connect::ContactFlowModule": "",
    # "AWS::Connect::EvaluationForm": "",
    # "AWS::Connect::HoursOfOperation": "",
    # "AWS::Connect::Instance": "",
    # "AWS::Connect::InstanceStorageConfig": "",
    # "AWS::Connect::IntegrationAssociation": "",
    # "AWS::Connect::PhoneNumber": "",
    # "AWS::Connect::Prompt": "",
    # "AWS::Connect::Queue": "",
    # "AWS::Connect::QuickConnect": "",
    # "AWS::Connect::RoutingProfile": "",
    # "AWS::Connect::Rule": "",
    # "AWS::Connect::SecurityKey": "",
    # "AWS::Connect::SecurityProfile": "",
    # "AWS::Connect::TaskTemplate": "",
    # "AWS::Connect::TrafficDistributionGroup": "",
    # "AWS::Connect::User": "",
    # "AWS::Connect::UserHierarchyGroup": "",
    # "AWS::Connect::View": "",
    # "AWS::Connect::ViewVersion": "",
    # "AWS::ConnectCampaigns::Campaign": "",
    # "AWS::ControlTower::EnabledControl": "",
    # "AWS::CustomerProfiles::CalculatedAttributeDefinition": "",
    # "AWS::CustomerProfiles::Domain": "",
    # "AWS::CustomerProfiles::EventStream": "",
    # "AWS::CustomerProfiles::Integration": "",
    # "AWS::CustomerProfiles::ObjectType": "",
    # "AWS::DAX::Cluster": "",
    # "AWS::DAX::ParameterGroup": "",
    # "AWS::DAX::SubnetGroup": "",
    # "AWS::DLM::LifecyclePolicy": "",
    # "AWS::DMS::Certificate": "",
    # "AWS::DMS::Endpoint": "",
    # "AWS::DMS::EventSubscription": "",
    # "AWS::DMS::ReplicationConfig": "",
    # "AWS::DMS::ReplicationInstance": "",
    # "AWS::DMS::ReplicationSubnetGroup": "",
    # "AWS::DMS::ReplicationTask": "",
    # "AWS::DataBrew::Dataset": "",
    # "AWS::DataBrew::Job": "",
    # "AWS::DataBrew::Project": "",
    # "AWS::DataBrew::Recipe": "",
    # "AWS::DataBrew::Ruleset": "",
    # "AWS::DataBrew::Schedule": "",
    # "AWS::DataPipeline::Pipeline": "",
    # "AWS::DataSync::Agent": "",
    # "AWS::DataSync::LocationAzureBlob": "",
    # "AWS::DataSync::LocationEFS": "",
    # "AWS::DataSync::LocationFSxLustre": "",
    # "AWS::DataSync::LocationFSxONTAP": "",
    # "AWS::DataSync::LocationFSxOpenZFS": "",
    # "AWS::DataSync::LocationFSxWindows": "",
    # "AWS::DataSync::LocationHDFS": "",
    # "AWS::DataSync::LocationNFS": "",
    # "AWS::DataSync::LocationObjectStorage": "",
    # "AWS::DataSync::LocationS3": "",
    # "AWS::DataSync::LocationSMB": "",
    # "AWS::DataSync::StorageSystem": "",
    # "AWS::DataSync::Task": "",
    # "AWS::Detective::Graph": "",
    # "AWS::Detective::MemberInvitation": "",
    # "AWS::Detective::OrganizationAdmin": "",
    # "AWS::DevOpsGuru::LogAnomalyDetectionIntegration": "",
    # "AWS::DevOpsGuru::NotificationChannel": "",
    # "AWS::DevOpsGuru::ResourceCollection": "",
    # "AWS::DirectoryService::MicrosoftAD": "",
    # "AWS::DirectoryService::SimpleAD": "",
    # "AWS::DocDB::DBCluster": "",
    # "AWS::DocDB::DBClusterParameterGroup": "",
    # "AWS::DocDB::DBInstance": "",
    # "AWS::DocDB::DBSubnetGroup": "",
    # "AWS::DocDBElastic::Cluster": "",
    # "AWS::DynamoDB::GlobalTable": "",
    "AWS::DynamoDB::Table": "ALIYUN::OTS::Table",
    # "AWS::EC2::CapacityReservation": "",
    # "AWS::EC2::CapacityReservationFleet": "",
    # "AWS::EC2::CarrierGateway": "",
    # "AWS::EC2::ClientVpnAuthorizationRule": "",
    # "AWS::EC2::ClientVpnEndpoint": "",
    # "AWS::EC2::ClientVpnRoute": "",
    # "AWS::EC2::ClientVpnTargetNetworkAssociation": "",
    # "AWS::EC2::CustomerGateway": "",
    # "AWS::EC2::DHCPOptions": "",
    # "AWS::EC2::EC2Fleet": "",
    "AWS::EC2::EIP": "ALIYUN::VPC::EIP",
    "AWS::EC2::EIPAssociation": "ALIYUN::VPC::EIPAssociation",
    # "AWS::EC2::EgressOnlyInternetGateway": "",
    # "AWS::EC2::EnclaveCertificateIamRoleAssociation": "",
    # "AWS::EC2::FlowLog": "",
    # "AWS::EC2::GatewayRouteTableAssociation": "",
    # "AWS::EC2::Host": "",
    # "AWS::EC2::IPAM": "",
    # "AWS::EC2::IPAMAllocation": "",
    # "AWS::EC2::IPAMPool": "",
    # "AWS::EC2::IPAMPoolCidr": "",
    # "AWS::EC2::IPAMResourceDiscovery": "",
    # "AWS::EC2::IPAMResourceDiscoveryAssociation": "",
    # "AWS::EC2::IPAMScope": "",
    "AWS::EC2::Instance": "ALIYUN::ECS::Instance",
    # "AWS::EC2::InstanceConnectEndpoint": "",
    "AWS::EC2::InternetGateway": "ALIYUN::VPC::NatGateway",
    "AWS::EC2::KeyPair": "ALIYUN::ECS::SSHKeyPair",
    "AWS::EC2::LaunchTemplate": "ALIYUN::ECS::LaunchTemplate",
    # "AWS::EC2::LocalGatewayRoute": "",
    # "AWS::EC2::LocalGatewayRouteTable": "",
    # "AWS::EC2::LocalGatewayRouteTableVPCAssociation": "",
    # "AWS::EC2::LocalGatewayRouteTableVirtualInterfaceGroupAssociation": "",
    "AWS::EC2::NatGateway": "ALIYUN::VPC::NatGateway",
    "AWS::EC2::NetworkAcl": "ALIYUN::VPC::NetworkAcl",
    # "AWS::EC2::NetworkAclEntry": "",
    # "AWS::EC2::NetworkInsightsAccessScope": "",
    # "AWS::EC2::NetworkInsightsAccessScopeAnalysis": "",
    # "AWS::EC2::NetworkInsightsAnalysis": "",
    # "AWS::EC2::NetworkInsightsPath": "",
    "AWS::EC2::NetworkInterface": "ALIYUN::ECS::NetworkInterface",
    "AWS::EC2::NetworkInterfaceAttachment": "ALIYUN::ECS::NetworkInterfaceAttachment",
    "AWS::EC2::NetworkInterfacePermission": "ALIYUN::ECS::NetworkInterfacePermission",
    # "AWS::EC2::NetworkPerformanceMetricSubscription": "",
    # "AWS::EC2::PlacementGroup": "",
    "AWS::EC2::PrefixList": "ALIYUN::ECS::PrefixList",
    "AWS::EC2::Route": "ALIYUN::ECS::Route",
    "AWS::EC2::RouteTable": "ALIYUN::VPC::RouteTable",
    "AWS::EC2::SecurityGroup": "ALIYUN::ECS::SecurityGroup",
    "AWS::EC2::SecurityGroupEgress": "ALIYUN::ECS::SecurityGroupEgress",
    "AWS::EC2::SecurityGroupIngress": "ALIYUN::ECS::SecurityGroupIngress",
    # "AWS::EC2::SpotFleet": "",
    "AWS::EC2::Subnet": "ALIYUN::ECS::VSwitch",
    # "AWS::EC2::SubnetCidrBlock": "",
    # "AWS::EC2::SubnetNetworkAclAssociation": "",
    "AWS::EC2::SubnetRouteTableAssociation": "ALIYUN::VPC::RouteTableAssociation",
    # "AWS::EC2::TrafficMirrorFilter": "",
    # "AWS::EC2::TrafficMirrorFilterRule": "",
    # "AWS::EC2::TrafficMirrorSession": "",
    # "AWS::EC2::TrafficMirrorTarget": "",
    # "AWS::EC2::TransitGateway": "",
    # "AWS::EC2::TransitGatewayAttachment": "",
    # "AWS::EC2::TransitGatewayConnect": "",
    # "AWS::EC2::TransitGatewayMulticastDomain": "",
    # "AWS::EC2::TransitGatewayMulticastDomainAssociation": "",
    # "AWS::EC2::TransitGatewayMulticastGroupMember": "",
    # "AWS::EC2::TransitGatewayMulticastGroupSource": "",
    # "AWS::EC2::TransitGatewayPeeringAttachment": "",
    # "AWS::EC2::TransitGatewayRoute": "",
    # "AWS::EC2::TransitGatewayRouteTable": "",
    # "AWS::EC2::TransitGatewayRouteTableAssociation": "",
    # "AWS::EC2::TransitGatewayRouteTablePropagation": "",
    # "AWS::EC2::TransitGatewayVpcAttachment": "",
    "AWS::EC2::VPC": "ALIYUN::ECS::VPC",
    # "AWS::EC2::VPCCidrBlock": "",
    # "AWS::EC2::VPCDHCPOptionsAssociation": "",
    # "AWS::EC2::VPCEndpoint": "",
    # "AWS::EC2::VPCEndpointConnectionNotification": "",
    # "AWS::EC2::VPCEndpointService": "",
    # "AWS::EC2::VPCEndpointServicePermissions": "",
    # "AWS::EC2::VPCGatewayAttachment": "",
    # "AWS::EC2::VPCPeeringConnection": "",
    # "AWS::EC2::VPNConnection": "",
    # "AWS::EC2::VPNConnectionRoute": "",
    "AWS::EC2::VPNGateway": "ALIYUN::VPC::VpnGateway",
    # "AWS::EC2::VPNGatewayRoutePropagation": "",
    # "AWS::EC2::VerifiedAccessEndpoint": "",
    # "AWS::EC2::VerifiedAccessGroup": "",
    # "AWS::EC2::VerifiedAccessInstance": "",
    # "AWS::EC2::VerifiedAccessTrustProvider": "",
    "AWS::EC2::Volume": "ALIYUN::ECS::Disk",
    "AWS::EC2::VolumeAttachment": "ALIYUN::ECS::DiskAttachment",
    # "AWS::ECR::PublicRepository": "",
    # "AWS::ECR::PullThroughCacheRule": "",
    # "AWS::ECR::RegistryPolicy": "",
    # "AWS::ECR::ReplicationConfiguration": "",
    "AWS::ECR::Repository": "ALIYUN::CR::Repository",
    # "AWS::ECS::CapacityProvider": "",
    # "AWS::ECS::Cluster": "",
    # "AWS::ECS::ClusterCapacityProviderAssociations": "",
    # "AWS::ECS::PrimaryTaskSet": "",
    # "AWS::ECS::Service": "",
    # "AWS::ECS::TaskDefinition": "",
    # "AWS::ECS::TaskSet": "",
    # "AWS::EFS::AccessPoint": "",
    "AWS::EFS::FileSystem": "ALIYUN::NAS::FileSystem",
    "AWS::EFS::MountTarget": "ALIYUN::NAS::MountTarget",
    # "AWS::EKS::Addon": "",
    # "AWS::EKS::Cluster": "",
    # "AWS::EKS::FargateProfile": "",
    # "AWS::EKS::IdentityProviderConfig": "",
    # "AWS::EKS::Nodegroup": "",
    "AWS::EMR::Cluster": "ALIYUN::EMR::Cluster",
    # "AWS::EMR::InstanceFleetConfig": "",
    # "AWS::EMR::InstanceGroupConfig": "",
    # "AWS::EMR::SecurityConfiguration": "",
    # "AWS::EMR::Step": "",
    # "AWS::EMR::Studio": "",
    # "AWS::EMR::StudioSessionMapping": "",
    # "AWS::EMR::WALWorkspace": "",
    # "AWS::EMRContainers::VirtualCluster": "",
    # "AWS::EMRServerless::Application": "",
    # "AWS::ElastiCache::CacheCluster": "",
    # "AWS::ElastiCache::GlobalReplicationGroup": "",
    # "AWS::ElastiCache::ParameterGroup": "",
    # "AWS::ElastiCache::ReplicationGroup": "",
    # "AWS::ElastiCache::SecurityGroup": "",
    # "AWS::ElastiCache::SecurityGroupIngress": "",
    # "AWS::ElastiCache::SubnetGroup": "",
    # "AWS::ElastiCache::User": "",
    # "AWS::ElastiCache::UserGroup": "",
    # "AWS::ElasticBeanstalk::Application": "",
    # "AWS::ElasticBeanstalk::ApplicationVersion": "",
    # "AWS::ElasticBeanstalk::ConfigurationTemplate": "",
    # "AWS::ElasticBeanstalk::Environment": "",
    "AWS::ElasticLoadBalancing::LoadBalancer": "ALIYUN::SLB::LoadBalancer",
    "AWS::ElasticLoadBalancingV2::Listener": "ALIYUN::SLB::Listener",
    "AWS::ElasticLoadBalancingV2::ListenerCertificate": "ALIYUN::SLB::Certificate",
    "AWS::ElasticLoadBalancingV2::ListenerRule": "ALIYUN::SLB::Rule",
    "AWS::ElasticLoadBalancingV2::LoadBalancer": "ALIYUN::SLB::LoadBalancer",
    # "AWS::ElasticLoadBalancingV2::TargetGroup": "",
    # "AWS::Elasticsearch::Domain": "",
    # "AWS::EntityResolution::IdMappingWorkflow": "",
    # "AWS::EntityResolution::MatchingWorkflow": "",
    # "AWS::EntityResolution::SchemaMapping": "",
    # "AWS::EventSchemas::Discoverer": "",
    # "AWS::EventSchemas::Registry": "",
    # "AWS::EventSchemas::RegistryPolicy": "",
    # "AWS::EventSchemas::Schema": "",
    # "AWS::Events::ApiDestination": "",
    # "AWS::Events::Archive": "",
    # "AWS::Events::Connection": "",
    # "AWS::Events::Endpoint": "",
    # "AWS::Events::EventBus": "",
    # "AWS::Events::EventBusPolicy": "",
    "AWS::Events::Rule": "ALIYUN::EventBridge::Rule",
    # "AWS::Evidently::Experiment": "",
    # "AWS::Evidently::Feature": "",
    # "AWS::Evidently::Launch": "",
    # "AWS::Evidently::Project": "",
    # "AWS::Evidently::Segment": "",
    # "AWS::FIS::ExperimentTemplate": "",
    # "AWS::FMS::NotificationChannel": "",
    # "AWS::FMS::Policy": "",
    # "AWS::FMS::ResourceSet": "",
    # "AWS::FSx::DataRepositoryAssociation": "",
    # "AWS::FSx::FileSystem": "",
    # "AWS::FSx::Snapshot": "",
    # "AWS::FSx::StorageVirtualMachine": "",
    # "AWS::FSx::Volume": "",
    # "AWS::FinSpace::Environment": "",
    # "AWS::Forecast::Dataset": "",
    # "AWS::Forecast::DatasetGroup": "",
    # "AWS::FraudDetector::Detector": "",
    # "AWS::FraudDetector::EntityType": "",
    # "AWS::FraudDetector::EventType": "",
    # "AWS::FraudDetector::Label": "",
    # "AWS::FraudDetector::List": "",
    # "AWS::FraudDetector::Outcome": "",
    # "AWS::FraudDetector::Variable": "",
    # "AWS::GameLift::Alias": "",
    # "AWS::GameLift::Build": "",
    # "AWS::GameLift::Fleet": "",
    # "AWS::GameLift::GameServerGroup": "",
    # "AWS::GameLift::GameSessionQueue": "",
    # "AWS::GameLift::Location": "",
    # "AWS::GameLift::MatchmakingConfiguration": "",
    # "AWS::GameLift::MatchmakingRuleSet": "",
    # "AWS::GameLift::Script": "",
    "AWS::GlobalAccelerator::Accelerator": "ALIYUN::GA::Accelerator",
    "AWS::GlobalAccelerator::EndpointGroup": "ALIYUN::GA::EndpointGroup",
    "AWS::GlobalAccelerator::Listener": "ALIYUN::GA::Listener",
    # "AWS::Glue::Classifier": "",
    # "AWS::Glue::Connection": "",
    # "AWS::Glue::Crawler": "",
    # "AWS::Glue::DataCatalogEncryptionSettings": "",
    # "AWS::Glue::DataQualityRuleset": "",
    # "AWS::Glue::Database": "",
    # "AWS::Glue::DevEndpoint": "",
    # "AWS::Glue::Job": "",
    # "AWS::Glue::MLTransform": "",
    # "AWS::Glue::Partition": "",
    # "AWS::Glue::Registry": "",
    # "AWS::Glue::Schema": "",
    # "AWS::Glue::SchemaVersion": "",
    # "AWS::Glue::SchemaVersionMetadata": "",
    # "AWS::Glue::SecurityConfiguration": "",
    # "AWS::Glue::Table": "",
    # "AWS::Glue::Trigger": "",
    # "AWS::Glue::Workflow": "",
    # "AWS::Grafana::Workspace": "",
    # "AWS::Greengrass::ConnectorDefinition": "",
    # "AWS::Greengrass::ConnectorDefinitionVersion": "",
    # "AWS::Greengrass::CoreDefinition": "",
    # "AWS::Greengrass::CoreDefinitionVersion": "",
    # "AWS::Greengrass::DeviceDefinition": "",
    # "AWS::Greengrass::DeviceDefinitionVersion": "",
    # "AWS::Greengrass::FunctionDefinition": "",
    # "AWS::Greengrass::FunctionDefinitionVersion": "",
    # "AWS::Greengrass::Group": "",
    # "AWS::Greengrass::GroupVersion": "",
    # "AWS::Greengrass::LoggerDefinition": "",
    # "AWS::Greengrass::LoggerDefinitionVersion": "",
    # "AWS::Greengrass::ResourceDefinition": "",
    # "AWS::Greengrass::ResourceDefinitionVersion": "",
    # "AWS::Greengrass::SubscriptionDefinition": "",
    # "AWS::Greengrass::SubscriptionDefinitionVersion": "",
    # "AWS::GreengrassV2::ComponentVersion": "",
    # "AWS::GreengrassV2::Deployment": "",
    # "AWS::GroundStation::Config": "",
    # "AWS::GroundStation::DataflowEndpointGroup": "",
    # "AWS::GroundStation::MissionProfile": "",
    # "AWS::GuardDuty::Detector": "",
    # "AWS::GuardDuty::Filter": "",
    # "AWS::GuardDuty::IPSet": "",
    # "AWS::GuardDuty::Master": "",
    # "AWS::GuardDuty::Member": "",
    # "AWS::GuardDuty::ThreatIntelSet": "",
    # "AWS::HealthImaging::Datastore": "",
    # "AWS::HealthLake::FHIRDatastore": "",
    "AWS::IAM::AccessKey": "ALIYUN::RAM::AccessKey",
    "AWS::IAM::Group": "ALIYUN::RAM::Group",
    # "AWS::IAM::GroupPolicy": "",
    # "AWS::IAM::InstanceProfile": "",
    "AWS::IAM::ManagedPolicy": "ALIYUN::RAM::ManagedPolicy",
    # "AWS::IAM::OIDCProvider": "",
    "AWS::IAM::Policy": "ALIYUN::RAM::ManagedPolicy",
    "AWS::IAM::Role": "ALIYUN::RAM::Role",
    # "AWS::IAM::RolePolicy": "",
    "AWS::IAM::SAMLProvider": "ALIYUN::RAM::SAMLProvider",
    # "AWS::IAM::ServerCertificate": "",
    # "AWS::IAM::ServiceLinkedRole": "",
    "AWS::IAM::User": "ALIYUN::RAM::User",
    # "AWS::IAM::UserPolicy": "",
    "AWS::IAM::UserToGroupAddition": "ALIYUN::RAM::UserToGroupAddition",
    # "AWS::IAM::VirtualMFADevice": "",
    # "AWS::IVS::Channel": "",
    # "AWS::IVS::PlaybackKeyPair": "",
    # "AWS::IVS::RecordingConfiguration": "",
    # "AWS::IVS::StreamKey": "",
    # "AWS::IVSChat::LoggingConfiguration": "",
    # "AWS::IVSChat::Room": "",
    # "AWS::IdentityStore::Group": "",
    # "AWS::IdentityStore::GroupMembership": "",
    # "AWS::ImageBuilder::Component": "",
    # "AWS::ImageBuilder::ContainerRecipe": "",
    # "AWS::ImageBuilder::DistributionConfiguration": "",
    # "AWS::ImageBuilder::Image": "",
    # "AWS::ImageBuilder::ImagePipeline": "",
    # "AWS::ImageBuilder::ImageRecipe": "",
    # "AWS::ImageBuilder::InfrastructureConfiguration": "",
    # "AWS::ImageBuilder::LifecyclePolicy": "",
    # "AWS::Inspector::AssessmentTarget": "",
    # "AWS::Inspector::AssessmentTemplate": "",
    # "AWS::Inspector::ResourceGroup": "",
    # "AWS::InspectorV2::Filter": "",
    # "AWS::InternetMonitor::Monitor": "",
    # "AWS::IoT1Click::Device": "",
    # "AWS::IoT1Click::Placement": "",
    # "AWS::IoT1Click::Project": "",
    # "AWS::IoT::AccountAuditConfiguration": "",
    # "AWS::IoT::Authorizer": "",
    # "AWS::IoT::BillingGroup": "",
    # "AWS::IoT::CACertificate": "",
    # "AWS::IoT::Certificate": "",
    # "AWS::IoT::CustomMetric": "",
    # "AWS::IoT::Dimension": "",
    # "AWS::IoT::DomainConfiguration": "",
    # "AWS::IoT::FleetMetric": "",
    # "AWS::IoT::JobTemplate": "",
    # "AWS::IoT::Logging": "",
    # "AWS::IoT::MitigationAction": "",
    # "AWS::IoT::Policy": "",
    # "AWS::IoT::PolicyPrincipalAttachment": "",
    # "AWS::IoT::ProvisioningTemplate": "",
    # "AWS::IoT::ResourceSpecificLogging": "",
    # "AWS::IoT::RoleAlias": "",
    # "AWS::IoT::ScheduledAudit": "",
    # "AWS::IoT::SecurityProfile": "",
    # "AWS::IoT::SoftwarePackage": "",
    # "AWS::IoT::SoftwarePackageVersion": "",
    # "AWS::IoT::Thing": "",
    # "AWS::IoT::ThingGroup": "",
    # "AWS::IoT::ThingPrincipalAttachment": "",
    # "AWS::IoT::ThingType": "",
    # "AWS::IoT::TopicRule": "",
    # "AWS::IoT::TopicRuleDestination": "",
    # "AWS::IoTAnalytics::Channel": "",
    # "AWS::IoTAnalytics::Dataset": "",
    # "AWS::IoTAnalytics::Datastore": "",
    # "AWS::IoTAnalytics::Pipeline": "",
    # "AWS::IoTCoreDeviceAdvisor::SuiteDefinition": "",
    # "AWS::IoTEvents::AlarmModel": "",
    # "AWS::IoTEvents::DetectorModel": "",
    # "AWS::IoTEvents::Input": "",
    # "AWS::IoTFleetHub::Application": "",
    # "AWS::IoTFleetWise::Campaign": "",
    # "AWS::IoTFleetWise::DecoderManifest": "",
    # "AWS::IoTFleetWise::Fleet": "",
    # "AWS::IoTFleetWise::ModelManifest": "",
    # "AWS::IoTFleetWise::SignalCatalog": "",
    # "AWS::IoTFleetWise::Vehicle": "",
    # "AWS::IoTSiteWise::AccessPolicy": "",
    # "AWS::IoTSiteWise::Asset": "",
    # "AWS::IoTSiteWise::AssetModel": "",
    # "AWS::IoTSiteWise::Dashboard": "",
    # "AWS::IoTSiteWise::Gateway": "",
    # "AWS::IoTSiteWise::Portal": "",
    # "AWS::IoTSiteWise::Project": "",
    # "AWS::IoTThingsGraph::FlowTemplate": "",
    # "AWS::IoTTwinMaker::ComponentType": "",
    # "AWS::IoTTwinMaker::Entity": "",
    # "AWS::IoTTwinMaker::Scene": "",
    # "AWS::IoTTwinMaker::SyncJob": "",
    # "AWS::IoTTwinMaker::Workspace": "",
    # "AWS::IoTWireless::Destination": "",
    # "AWS::IoTWireless::DeviceProfile": "",
    # "AWS::IoTWireless::FuotaTask": "",
    # "AWS::IoTWireless::MulticastGroup": "",
    # "AWS::IoTWireless::NetworkAnalyzerConfiguration": "",
    # "AWS::IoTWireless::PartnerAccount": "",
    # "AWS::IoTWireless::ServiceProfile": "",
    # "AWS::IoTWireless::TaskDefinition": "",
    # "AWS::IoTWireless::WirelessDevice": "",
    # "AWS::IoTWireless::WirelessDeviceImportTask": "",
    # "AWS::IoTWireless::WirelessGateway": "",
    "AWS::KMS::Alias": "ALIYUN::KMS::Alias",
    "AWS::KMS::Key": "ALIYUN::KMS::Key",
    # "AWS::KMS::ReplicaKey": "",
    # "AWS::KafkaConnect::Connector": "",
    # "AWS::Kendra::DataSource": "",
    # "AWS::Kendra::Faq": "",
    # "AWS::Kendra::Index": "",
    # "AWS::KendraRanking::ExecutionPlan": "",
    # "AWS::Kinesis::Stream": "",
    # "AWS::Kinesis::StreamConsumer": "",
    # "AWS::KinesisAnalytics::Application": "",
    # "AWS::KinesisAnalytics::ApplicationOutput": "",
    # "AWS::KinesisAnalytics::ApplicationReferenceDataSource": "",
    # "AWS::KinesisAnalyticsV2::Application": "",
    # "AWS::KinesisAnalyticsV2::ApplicationCloudWatchLoggingOption": "",
    # "AWS::KinesisAnalyticsV2::ApplicationOutput": "",
    # "AWS::KinesisAnalyticsV2::ApplicationReferenceDataSource": "",
    # "AWS::KinesisFirehose::DeliveryStream": "",
    # "AWS::KinesisVideo::SignalingChannel": "",
    # "AWS::KinesisVideo::Stream": "",
    # "AWS::LakeFormation::DataCellsFilter": "",
    # "AWS::LakeFormation::DataLakeSettings": "",
    # "AWS::LakeFormation::Permissions": "",
    # "AWS::LakeFormation::PrincipalPermissions": "",
    # "AWS::LakeFormation::Resource": "",
    # "AWS::LakeFormation::Tag": "",
    # "AWS::LakeFormation::TagAssociation": "",
    "AWS::Lambda::Alias": "ALIYUN::FC::Alias",
    # "AWS::Lambda::CodeSigningConfig": "",
    # "AWS::Lambda::EventInvokeConfig": "",
    # "AWS::Lambda::EventSourceMapping": "",
    "AWS::Lambda::Function": "ALIYUN::FC::Function",
    # "AWS::Lambda::LayerVersion": "",
    # "AWS::Lambda::LayerVersionPermission": "",
    # "AWS::Lambda::Permission": "",
    # "AWS::Lambda::Url": "",
    "AWS::Lambda::Version": "ALIYUN::FC::Version",
    # "AWS::Lex::Bot": "",
    # "AWS::Lex::BotAlias": "",
    # "AWS::Lex::BotVersion": "",
    # "AWS::Lex::ResourcePolicy": "",
    # "AWS::LicenseManager::Grant": "",
    # "AWS::LicenseManager::License": "",
    # "AWS::Lightsail::Alarm": "",
    # "AWS::Lightsail::Bucket": "",
    # "AWS::Lightsail::Certificate": "",
    # "AWS::Lightsail::Container": "",
    # "AWS::Lightsail::Database": "",
    # "AWS::Lightsail::Disk": "",
    # "AWS::Lightsail::Distribution": "",
    # "AWS::Lightsail::Instance": "",
    # "AWS::Lightsail::LoadBalancer": "",
    # "AWS::Lightsail::LoadBalancerTlsCertificate": "",
    # "AWS::Lightsail::StaticIp": "",
    # "AWS::Location::GeofenceCollection": "",
    # "AWS::Location::Map": "",
    # "AWS::Location::PlaceIndex": "",
    # "AWS::Location::RouteCalculator": "",
    # "AWS::Location::Tracker": "",
    # "AWS::Location::TrackerConsumer": "",
    # "AWS::Logs::AccountPolicy": "",
    # "AWS::Logs::Destination": "",
    # "AWS::Logs::LogGroup": "",
    # "AWS::Logs::LogStream": "",
    # "AWS::Logs::MetricFilter": "",
    # "AWS::Logs::QueryDefinition": "",
    # "AWS::Logs::ResourcePolicy": "",
    # "AWS::Logs::SubscriptionFilter": "",
    # "AWS::LookoutEquipment::InferenceScheduler": "",
    # "AWS::LookoutMetrics::Alert": "",
    # "AWS::LookoutMetrics::AnomalyDetector": "",
    # "AWS::LookoutVision::Project": "",
    # "AWS::M2::Application": "",
    # "AWS::M2::Environment": "",
    # "AWS::MSK::BatchScramSecret": "",
    # "AWS::MSK::Cluster": "",
    # "AWS::MSK::ClusterPolicy": "",
    # "AWS::MSK::Configuration": "",
    # "AWS::MSK::Replicator": "",
    # "AWS::MSK::ServerlessCluster": "",
    # "AWS::MSK::VpcConnection": "",
    # "AWS::MWAA::Environment": "",
    # "AWS::Macie::AllowList": "",
    # "AWS::Macie::CustomDataIdentifier": "",
    # "AWS::Macie::FindingsFilter": "",
    # "AWS::Macie::Session": "",
    # "AWS::ManagedBlockchain::Accessor": "",
    # "AWS::ManagedBlockchain::Member": "",
    # "AWS::ManagedBlockchain::Node": "",
    # "AWS::MediaConnect::Bridge": "",
    # "AWS::MediaConnect::BridgeOutput": "",
    # "AWS::MediaConnect::BridgeSource": "",
    # "AWS::MediaConnect::Flow": "",
    # "AWS::MediaConnect::FlowEntitlement": "",
    # "AWS::MediaConnect::FlowOutput": "",
    # "AWS::MediaConnect::FlowSource": "",
    # "AWS::MediaConnect::FlowVpcInterface": "",
    # "AWS::MediaConnect::Gateway": "",
    # "AWS::MediaConvert::JobTemplate": "",
    # "AWS::MediaConvert::Preset": "",
    # "AWS::MediaConvert::Queue": "",
    # "AWS::MediaLive::Channel": "",
    # "AWS::MediaLive::Input": "",
    # "AWS::MediaLive::InputSecurityGroup": "",
    # "AWS::MediaLive::Multiplex": "",
    # "AWS::MediaLive::Multiplexprogram": "",
    # "AWS::MediaPackage::Asset": "",
    # "AWS::MediaPackage::Channel": "",
    # "AWS::MediaPackage::OriginEndpoint": "",
    # "AWS::MediaPackage::PackagingConfiguration": "",
    # "AWS::MediaPackage::PackagingGroup": "",
    # "AWS::MediaPackageV2::Channel": "",
    # "AWS::MediaPackageV2::ChannelGroup": "",
    # "AWS::MediaPackageV2::ChannelPolicy": "",
    # "AWS::MediaPackageV2::OriginEndpoint": "",
    # "AWS::MediaPackageV2::OriginEndpointPolicy": "",
    # "AWS::MediaStore::Container": "",
    # "AWS::MediaTailor::Channel": "",
    # "AWS::MediaTailor::ChannelPolicy": "",
    # "AWS::MediaTailor::LiveSource": "",
    # "AWS::MediaTailor::PlaybackConfiguration": "",
    # "AWS::MediaTailor::SourceLocation": "",
    # "AWS::MediaTailor::VodSource": "",
    # "AWS::MemoryDB::ACL": "",
    # "AWS::MemoryDB::Cluster": "",
    # "AWS::MemoryDB::ParameterGroup": "",
    # "AWS::MemoryDB::SubnetGroup": "",
    # "AWS::MemoryDB::User": "",
    # "AWS::Neptune::DBCluster": "",
    # "AWS::Neptune::DBClusterParameterGroup": "",
    # "AWS::Neptune::DBInstance": "",
    # "AWS::Neptune::DBParameterGroup": "",
    # "AWS::Neptune::DBSubnetGroup": "",
    # "AWS::NetworkFirewall::Firewall": "",
    # "AWS::NetworkFirewall::FirewallPolicy": "",
    # "AWS::NetworkFirewall::LoggingConfiguration": "",
    # "AWS::NetworkFirewall::RuleGroup": "",
    # "AWS::NetworkManager::ConnectAttachment": "",
    # "AWS::NetworkManager::ConnectPeer": "",
    # "AWS::NetworkManager::CoreNetwork": "",
    # "AWS::NetworkManager::CustomerGatewayAssociation": "",
    # "AWS::NetworkManager::Device": "",
    # "AWS::NetworkManager::GlobalNetwork": "",
    # "AWS::NetworkManager::Link": "",
    # "AWS::NetworkManager::LinkAssociation": "",
    # "AWS::NetworkManager::Site": "",
    # "AWS::NetworkManager::SiteToSiteVpnAttachment": "",
    # "AWS::NetworkManager::TransitGatewayPeering": "",
    # "AWS::NetworkManager::TransitGatewayRegistration": "",
    # "AWS::NetworkManager::TransitGatewayRouteTableAttachment": "",
    # "AWS::NetworkManager::VpcAttachment": "",
    # "AWS::NimbleStudio::LaunchProfile": "",
    # "AWS::NimbleStudio::StreamingImage": "",
    # "AWS::NimbleStudio::Studio": "",
    # "AWS::NimbleStudio::StudioComponent": "",
    # "AWS::OSIS::Pipeline": "",
    # "AWS::Oam::Link": "",
    # "AWS::Oam::Sink": "",
    # "AWS::Omics::AnnotationStore": "",
    # "AWS::Omics::ReferenceStore": "",
    # "AWS::Omics::RunGroup": "",
    # "AWS::Omics::SequenceStore": "",
    # "AWS::Omics::VariantStore": "",
    # "AWS::Omics::Workflow": "",
    # "AWS::OpenSearchServerless::AccessPolicy": "",
    # "AWS::OpenSearchServerless::Collection": "",
    # "AWS::OpenSearchServerless::LifecyclePolicy": "",
    # "AWS::OpenSearchServerless::SecurityConfig": "",
    # "AWS::OpenSearchServerless::SecurityPolicy": "",
    # "AWS::OpenSearchServerless::VpcEndpoint": "",
    # "AWS::OpenSearchService::Domain": "",
    # "AWS::OpsWorks::App": "",
    # "AWS::OpsWorks::ElasticLoadBalancerAttachment": "",
    # "AWS::OpsWorks::Instance": "",
    # "AWS::OpsWorks::Layer": "",
    # "AWS::OpsWorks::Stack": "",
    # "AWS::OpsWorks::UserProfile": "",
    # "AWS::OpsWorks::Volume": "",
    # "AWS::OpsWorksCM::Server": "",
    "AWS::Organizations::Account": "ALIYUN::ResourceManager::Account",
    # "AWS::Organizations::Organization": "",
    # "AWS::Organizations::OrganizationalUnit": "",
    # "AWS::Organizations::Policy": "",
    # "AWS::Organizations::ResourcePolicy": "",
    # "AWS::PCAConnectorAD::Connector": "",
    # "AWS::PCAConnectorAD::DirectoryRegistration": "",
    # "AWS::PCAConnectorAD::ServicePrincipalName": "",
    # "AWS::PCAConnectorAD::Template": "",
    # "AWS::PCAConnectorAD::TemplateGroupAccessControlEntry": "",
    # "AWS::Panorama::ApplicationInstance": "",
    # "AWS::Panorama::Package": "",
    # "AWS::Panorama::PackageVersion": "",
    # "AWS::Personalize::Dataset": "",
    # "AWS::Personalize::DatasetGroup": "",
    # "AWS::Personalize::Schema": "",
    # "AWS::Personalize::Solution": "",
    # "AWS::Pinpoint::ADMChannel": "",
    # "AWS::Pinpoint::APNSChannel": "",
    # "AWS::Pinpoint::APNSSandboxChannel": "",
    # "AWS::Pinpoint::APNSVoipChannel": "",
    # "AWS::Pinpoint::APNSVoipSandboxChannel": "",
    # "AWS::Pinpoint::App": "",
    # "AWS::Pinpoint::ApplicationSettings": "",
    # "AWS::Pinpoint::BaiduChannel": "",
    # "AWS::Pinpoint::Campaign": "",
    # "AWS::Pinpoint::EmailChannel": "",
    # "AWS::Pinpoint::EmailTemplate": "",
    # "AWS::Pinpoint::EventStream": "",
    # "AWS::Pinpoint::GCMChannel": "",
    # "AWS::Pinpoint::InAppTemplate": "",
    # "AWS::Pinpoint::PushTemplate": "",
    # "AWS::Pinpoint::SMSChannel": "",
    # "AWS::Pinpoint::Segment": "",
    # "AWS::Pinpoint::SmsTemplate": "",
    # "AWS::Pinpoint::VoiceChannel": "",
    # "AWS::PinpointEmail::ConfigurationSet": "",
    # "AWS::PinpointEmail::ConfigurationSetEventDestination": "",
    # "AWS::PinpointEmail::DedicatedIpPool": "",
    # "AWS::PinpointEmail::Identity": "",
    # "AWS::Pipes::Pipe": "",
    # "AWS::Proton::EnvironmentAccountConnection": "",
    # "AWS::Proton::EnvironmentTemplate": "",
    # "AWS::Proton::ServiceTemplate": "",
    # "AWS::QLDB::Ledger": "",
    # "AWS::QLDB::Stream": "",
    # "AWS::QuickSight::Analysis": "",
    # "AWS::QuickSight::Dashboard": "",
    # "AWS::QuickSight::DataSet": "",
    # "AWS::QuickSight::DataSource": "",
    # "AWS::QuickSight::RefreshSchedule": "",
    # "AWS::QuickSight::Template": "",
    # "AWS::QuickSight::Theme": "",
    # "AWS::QuickSight::Topic": "",
    # "AWS::QuickSight::VPCConnection": "",
    # "AWS::RAM::Permission": "",
    # "AWS::RAM::ResourceShare": "",
    # "AWS::RDS::CustomDBEngineVersion": "",
    # "AWS::RDS::DBCluster": "",
    # "AWS::RDS::DBClusterParameterGroup": "",
    "AWS::RDS::DBInstance": "ALIYUN::RDS::DBInstance",
    # "AWS::RDS::DBParameterGroup": "",
    # "AWS::RDS::DBProxy": "",
    # "AWS::RDS::DBProxyEndpoint": "",
    # "AWS::RDS::DBProxyTargetGroup": "",
    # "AWS::RDS::DBSecurityGroup": "",
    # "AWS::RDS::DBSecurityGroupIngress": "",
    # "AWS::RDS::DBSubnetGroup": "",
    # "AWS::RDS::EventSubscription": "",
    # "AWS::RDS::GlobalCluster": "",
    # "AWS::RDS::OptionGroup": "",
    # "AWS::RUM::AppMonitor": "",
    # "AWS::Redshift::Cluster": "",
    # "AWS::Redshift::ClusterParameterGroup": "",
    # "AWS::Redshift::ClusterSecurityGroup": "",
    # "AWS::Redshift::ClusterSecurityGroupIngress": "",
    # "AWS::Redshift::ClusterSubnetGroup": "",
    # "AWS::Redshift::EndpointAccess": "",
    # "AWS::Redshift::EndpointAuthorization": "",
    # "AWS::Redshift::EventSubscription": "",
    # "AWS::Redshift::ScheduledAction": "",
    # "AWS::RedshiftServerless::Namespace": "",
    # "AWS::RedshiftServerless::Workgroup": "",
    # "AWS::RefactorSpaces::Application": "",
    # "AWS::RefactorSpaces::Environment": "",
    # "AWS::RefactorSpaces::Route": "",
    # "AWS::RefactorSpaces::Service": "",
    # "AWS::Rekognition::Collection": "",
    # "AWS::Rekognition::Project": "",
    # "AWS::Rekognition::StreamProcessor": "",
    # "AWS::ResilienceHub::App": "",
    # "AWS::ResilienceHub::ResiliencyPolicy": "",
    # "AWS::ResourceExplorer2::DefaultViewAssociation": "",
    # "AWS::ResourceExplorer2::Index": "",
    # "AWS::ResourceExplorer2::View": "",
    # "AWS::ResourceGroups::Group": "",
    # "AWS::RoboMaker::Fleet": "",
    # "AWS::RoboMaker::Robot": "",
    # "AWS::RoboMaker::RobotApplication": "",
    # "AWS::RoboMaker::RobotApplicationVersion": "",
    # "AWS::RoboMaker::SimulationApplication": "",
    # "AWS::RoboMaker::SimulationApplicationVersion": "",
    # "AWS::RolesAnywhere::CRL": "",
    # "AWS::RolesAnywhere::Profile": "",
    # "AWS::RolesAnywhere::TrustAnchor": "",
    # "AWS::Route53::CidrCollection": "",
    # "AWS::Route53::DNSSEC": "",
    # "AWS::Route53::HealthCheck": "",
    # "AWS::Route53::HostedZone": "",
    # "AWS::Route53::KeySigningKey": "",
    # "AWS::Route53::RecordSet": "",
    # "AWS::Route53::RecordSetGroup": "",
    # "AWS::Route53RecoveryControl::Cluster": "",
    # "AWS::Route53RecoveryControl::ControlPanel": "",
    # "AWS::Route53RecoveryControl::RoutingControl": "",
    # "AWS::Route53RecoveryControl::SafetyRule": "",
    # "AWS::Route53RecoveryReadiness::Cell": "",
    # "AWS::Route53RecoveryReadiness::ReadinessCheck": "",
    # "AWS::Route53RecoveryReadiness::RecoveryGroup": "",
    # "AWS::Route53RecoveryReadiness::ResourceSet": "",
    # "AWS::Route53Resolver::FirewallDomainList": "",
    # "AWS::Route53Resolver::FirewallRuleGroup": "",
    # "AWS::Route53Resolver::FirewallRuleGroupAssociation": "",
    # "AWS::Route53Resolver::OutpostResolver": "",
    # "AWS::Route53Resolver::ResolverConfig": "",
    # "AWS::Route53Resolver::ResolverDNSSECConfig": "",
    # "AWS::Route53Resolver::ResolverEndpoint": "",
    # "AWS::Route53Resolver::ResolverQueryLoggingConfig": "",
    # "AWS::Route53Resolver::ResolverQueryLoggingConfigAssociation": "",
    # "AWS::Route53Resolver::ResolverRule": "",
    # "AWS::Route53Resolver::ResolverRuleAssociation": "",
    # "AWS::S3::AccessPoint": "",
    "AWS::S3::Bucket": "ALIYUN::OSS::Bucket",
    # "AWS::S3::BucketPolicy": "",
    # "AWS::S3::MultiRegionAccessPoint": "",
    # "AWS::S3::MultiRegionAccessPointPolicy": "",
    # "AWS::S3::StorageLens": "",
    # "AWS::S3::StorageLensGroup": "",
    # "AWS::S3ObjectLambda::AccessPoint": "",
    # "AWS::S3ObjectLambda::AccessPointPolicy": "",
    # "AWS::S3Outposts::AccessPoint": "",
    # "AWS::S3Outposts::Bucket": "",
    # "AWS::S3Outposts::BucketPolicy": "",
    # "AWS::S3Outposts::Endpoint": "",
    # "AWS::SDB::Domain": "",
    # "AWS::SES::ConfigurationSet": "",
    # "AWS::SES::ConfigurationSetEventDestination": "",
    # "AWS::SES::ContactList": "",
    # "AWS::SES::DedicatedIpPool": "",
    # "AWS::SES::EmailIdentity": "",
    # "AWS::SES::ReceiptFilter": "",
    # "AWS::SES::ReceiptRule": "",
    # "AWS::SES::ReceiptRuleSet": "",
    # "AWS::SES::Template": "",
    # "AWS::SES::VdmAttributes": "",
    # "AWS::SNS::Subscription": "",
    # "AWS::SNS::Topic": "",
    # "AWS::SNS::TopicInlinePolicy": "",
    # "AWS::SNS::TopicPolicy": "",
    # "AWS::SQS::Queue": "",
    # "AWS::SQS::QueueInlinePolicy": "",
    # "AWS::SQS::QueuePolicy": "",
    # "AWS::SSM::Association": "",
    # "AWS::SSM::Document": "",
    # "AWS::SSM::MaintenanceWindow": "",
    # "AWS::SSM::MaintenanceWindowTarget": "",
    # "AWS::SSM::MaintenanceWindowTask": "",
    # "AWS::SSM::Parameter": "",
    # "AWS::SSM::PatchBaseline": "",
    # "AWS::SSM::ResourceDataSync": "",
    # "AWS::SSM::ResourcePolicy": "",
    # "AWS::SSMContacts::Contact": "",
    # "AWS::SSMContacts::ContactChannel": "",
    # "AWS::SSMContacts::Plan": "",
    # "AWS::SSMContacts::Rotation": "",
    # "AWS::SSMIncidents::ReplicationSet": "",
    # "AWS::SSMIncidents::ResponsePlan": "",
    # "AWS::SSO::Assignment": "",
    # "AWS::SSO::InstanceAccessControlAttributeConfiguration": "",
    # "AWS::SSO::PermissionSet": "",
    # "AWS::SageMaker::App": "",
    # "AWS::SageMaker::AppImageConfig": "",
    # "AWS::SageMaker::CodeRepository": "",
    # "AWS::SageMaker::DataQualityJobDefinition": "",
    # "AWS::SageMaker::Device": "",
    # "AWS::SageMaker::DeviceFleet": "",
    # "AWS::SageMaker::Domain": "",
    # "AWS::SageMaker::Endpoint": "",
    # "AWS::SageMaker::EndpointConfig": "",
    # "AWS::SageMaker::FeatureGroup": "",
    # "AWS::SageMaker::Image": "",
    # "AWS::SageMaker::ImageVersion": "",
    # "AWS::SageMaker::InferenceExperiment": "",
    # "AWS::SageMaker::Model": "",
    # "AWS::SageMaker::ModelBiasJobDefinition": "",
    # "AWS::SageMaker::ModelCard": "",
    # "AWS::SageMaker::ModelExplainabilityJobDefinition": "",
    # "AWS::SageMaker::ModelPackage": "",
    # "AWS::SageMaker::ModelPackageGroup": "",
    # "AWS::SageMaker::ModelQualityJobDefinition": "",
    # "AWS::SageMaker::MonitoringSchedule": "",
    # "AWS::SageMaker::NotebookInstance": "",
    # "AWS::SageMaker::NotebookInstanceLifecycleConfig": "",
    # "AWS::SageMaker::Pipeline": "",
    # "AWS::SageMaker::Project": "",
    # "AWS::SageMaker::Space": "",
    # "AWS::SageMaker::UserProfile": "",
    # "AWS::SageMaker::Workteam": "",
    # "AWS::Scheduler::Schedule": "",
    # "AWS::Scheduler::ScheduleGroup": "",
    # "AWS::SecretsManager::ResourcePolicy": "",
    # "AWS::SecretsManager::RotationSchedule": "",
    # "AWS::SecretsManager::Secret": "",
    # "AWS::SecretsManager::SecretTargetAttachment": "",
    # "AWS::SecurityHub::AutomationRule": "",
    # "AWS::SecurityHub::Hub": "",
    # "AWS::SecurityHub::Standard": "",
    # "AWS::ServiceCatalog::AcceptedPortfolioShare": "",
    # "AWS::ServiceCatalog::CloudFormationProduct": "",
    # "AWS::ServiceCatalog::CloudFormationProvisionedProduct": "",
    # "AWS::ServiceCatalog::LaunchNotificationConstraint": "",
    # "AWS::ServiceCatalog::LaunchRoleConstraint": "",
    # "AWS::ServiceCatalog::LaunchTemplateConstraint": "",
    # "AWS::ServiceCatalog::Portfolio": "",
    # "AWS::ServiceCatalog::PortfolioPrincipalAssociation": "",
    # "AWS::ServiceCatalog::PortfolioProductAssociation": "",
    # "AWS::ServiceCatalog::PortfolioShare": "",
    # "AWS::ServiceCatalog::ResourceUpdateConstraint": "",
    # "AWS::ServiceCatalog::ServiceAction": "",
    # "AWS::ServiceCatalog::ServiceActionAssociation": "",
    # "AWS::ServiceCatalog::StackSetConstraint": "",
    # "AWS::ServiceCatalog::TagOption": "",
    # "AWS::ServiceCatalog::TagOptionAssociation": "",
    # "AWS::ServiceCatalogAppRegistry::Application": "",
    # "AWS::ServiceCatalogAppRegistry::AttributeGroup": "",
    # "AWS::ServiceCatalogAppRegistry::AttributeGroupAssociation": "",
    # "AWS::ServiceCatalogAppRegistry::ResourceAssociation": "",
    # "AWS::ServiceDiscovery::HttpNamespace": "",
    # "AWS::ServiceDiscovery::Instance": "",
    # "AWS::ServiceDiscovery::PrivateDnsNamespace": "",
    # "AWS::ServiceDiscovery::PublicDnsNamespace": "",
    # "AWS::ServiceDiscovery::Service": "",
    # "AWS::Shield::DRTAccess": "",
    # "AWS::Shield::ProactiveEngagement": "",
    # "AWS::Shield::Protection": "",
    # "AWS::Shield::ProtectionGroup": "",
    # "AWS::Signer::ProfilePermission": "",
    # "AWS::Signer::SigningProfile": "",
    # "AWS::SimSpaceWeaver::Simulation": "",
    # "AWS::StepFunctions::Activity": "",
    # "AWS::StepFunctions::StateMachine": "",
    # "AWS::StepFunctions::StateMachineAlias": "",
    # "AWS::StepFunctions::StateMachineVersion": "",
    # "AWS::SupportApp::AccountAlias": "",
    # "AWS::SupportApp::SlackChannelConfiguration": "",
    # "AWS::SupportApp::SlackWorkspaceConfiguration": "",
    # "AWS::Synthetics::Canary": "",
    # "AWS::Synthetics::Group": "",
    # "AWS::SystemsManagerSAP::Application": "",
    # "AWS::Timestream::Database": "",
    # "AWS::Timestream::ScheduledQuery": "",
    # "AWS::Timestream::Table": "",
    # "AWS::Transfer::Agreement": "",
    # "AWS::Transfer::Certificate": "",
    # "AWS::Transfer::Connector": "",
    # "AWS::Transfer::Profile": "",
    # "AWS::Transfer::Server": "",
    # "AWS::Transfer::User": "",
    # "AWS::Transfer::Workflow": "",
    # "AWS::VerifiedPermissions::IdentitySource": "",
    # "AWS::VerifiedPermissions::Policy": "",
    # "AWS::VerifiedPermissions::PolicyStore": "",
    # "AWS::VerifiedPermissions::PolicyTemplate": "",
    # "AWS::VoiceID::Domain": "",
    # "AWS::VpcLattice::AccessLogSubscription": "",
    # "AWS::VpcLattice::AuthPolicy": "",
    # "AWS::VpcLattice::Listener": "",
    # "AWS::VpcLattice::ResourcePolicy": "",
    # "AWS::VpcLattice::Rule": "",
    # "AWS::VpcLattice::Service": "",
    # "AWS::VpcLattice::ServiceNetwork": "",
    # "AWS::VpcLattice::ServiceNetworkServiceAssociation": "",
    # "AWS::VpcLattice::ServiceNetworkVpcAssociation": "",
    # "AWS::VpcLattice::TargetGroup": "",
    # "AWS::WAF::ByteMatchSet": "",
    # "AWS::WAF::IPSet": "",
    # "AWS::WAF::Rule": "",
    # "AWS::WAF::SizeConstraintSet": "",
    # "AWS::WAF::SqlInjectionMatchSet": "",
    # "AWS::WAF::WebACL": "",
    # "AWS::WAF::XssMatchSet": "",
    # "AWS::WAFRegional::ByteMatchSet": "",
    # "AWS::WAFRegional::GeoMatchSet": "",
    # "AWS::WAFRegional::IPSet": "",
    # "AWS::WAFRegional::RateBasedRule": "",
    # "AWS::WAFRegional::RegexPatternSet": "",
    # "AWS::WAFRegional::Rule": "",
    # "AWS::WAFRegional::SizeConstraintSet": "",
    # "AWS::WAFRegional::SqlInjectionMatchSet": "",
    # "AWS::WAFRegional::WebACL": "",
    # "AWS::WAFRegional::WebACLAssociation": "",
    # "AWS::WAFRegional::XssMatchSet": "",
    # "AWS::WAFv2::IPSet": "",
    # "AWS::WAFv2::LoggingConfiguration": "",
    # "AWS::WAFv2::RegexPatternSet": "",
    # "AWS::WAFv2::RuleGroup": "",
    # "AWS::WAFv2::WebACL": "",
    # "AWS::WAFv2::WebACLAssociation": "",
    # "AWS::Wisdom::Assistant": "",
    # "AWS::Wisdom::AssistantAssociation": "",
    # "AWS::Wisdom::KnowledgeBase": "",
    # "AWS::WorkSpaces::ConnectionAlias": "",
    # "AWS::WorkSpaces::Workspace": "",
    # "AWS::WorkSpacesWeb::BrowserSettings": "",
    # "AWS::WorkSpacesWeb::IdentityProvider": "",
    # "AWS::WorkSpacesWeb::IpAccessSettings": "",
    # "AWS::WorkSpacesWeb::NetworkSettings": "",
    # "AWS::WorkSpacesWeb::Portal": "",
    # "AWS::WorkSpacesWeb::TrustStore": "",
    # "AWS::WorkSpacesWeb::UserAccessLoggingSettings": "",
    # "AWS::WorkSpacesWeb::UserSettings": "",
    # "AWS::XRay::Group": "",
    # "AWS::XRay::ResourcePolicy": "",
    # "AWS::XRay::SamplingRule": "",
}

TF_ALI_DEPRECATED_PROPERTIES = {
    "alicloud_vswitch": [
        "name",
        "availability_zone"
    ]
}
