# Juno Agent

[![License: AGPL-3.0](https://img.shields.io/badge/License-AGPL%20v3-blue.svg)](https://www.gnu.org/licenses/agpl-3.0)
[![Python 3.8+](https://img.shields.io/badge/python-3.8+-blue.svg)](https://www.python.org/downloads/)
[![Textual TUI](https://img.shields.io/badge/TUI-Textual-green.svg)](https://textual.textualize.io/)

> **The Switzerland of AI Coding Tools**  
> *Your AI assistant, your choice of brain*

An advanced AI-powered coding assistant featuring a sophisticated Terminal User Interface (TUI) with support for 50+ AI models from 8 major providers. Built with Textual framework for a desktop-class terminal experience.

## 🚀 Why Juno Agent?

| Feature | GitHub Copilot | Cursor | Windsurf | Claude Code | **Juno Agent** |
|---------|---------------|--------|----------|-------------|----------------|
| **Universal AI Tool Setup** | ❌ Manual | ❌ Manual | ❌ Manual | ❌ Manual | ✅ **26+ Tools** |
| **System Prompt Control** | ❌ None | ❌ Basic | ❌ Basic | ❌ Basic | ✅ **7-Level Priority** |
| **Version-Specific Context** | ❌ Training data | ❌ Training data | ❌ Training data | ❌ Training data | ✅ **Live Docs** |
| **Multi-Provider Support** | ❌ OpenAI only | ✅ Limited | ✅ Limited | ❌ Anthropic only | ✅ **50+ Models** |
| **Terminal-Native TUI** | ❌ Basic CLI | ❌ Editor only | ❌ Editor only | ✅ Good | ✅ **Advanced** |
| **Cost Transparency** | ❌ Hidden | ❌ Hidden | ❌ Hidden | ❌ Hidden | ✅ **Real-time** |
| **Local Models** | ❌ No | ❌ No | ❌ No | ❌ No | ✅ **Full Support** |
| **Vendor Lock-in** | ❌ Yes | ❌ Editor | ❌ Editor | ❌ Yes | ✅ **None** |

## ✨ Key Features

### 🌟 **UNIQUE: Universal AI Tool Configuration Hub** 
**The killer feature no other tool offers**: Juno Agent configures ALL your AI coding tools to work smarter with one command.

- **One Setup, 26+ Tools**: Single `/setup` command configures Cursor, Claude Code, Windsurf, VS Code, GitHub Copilot, and 21+ other AI tools
- **Version-Specific Context**: Automatically fetches current documentation for your exact dependency versions  
- **Smart Configuration**: Creates appropriate config files (CLAUDE.md, .cursorrules, .windsurfrules, AGENTS.md) for each tool
- **External Context System**: Establishes `external_context/` symlinks so every AI tool accesses current documentation
- **MCP Server Installation**: Automatically configures VibeContext MCP server across all supported tools
- **Local-First Privacy**: Documentation cached locally at `~/.ASKBUDI/{project}/`, never sent to AI providers

**Example**: Instead of AI suggesting React 16 patterns for your React 18.3.1 project, every AI tool now knows your exact versions and current best practices.

### 🧠 **REVOLUTIONARY: Complete System Prompt Control**
**Unprecedented AI behavior customization**: Take full control over how AI models behave and respond.

- **Hierarchical Override System**: 7-level priority chain from global defaults to project-specific customizations
- **Model-Specific Prompts**: Different prompts for different models (GPT-5, Claude-4, coding subagents)
- **Real-time Prompt Switching**: Change AI behavior without restarting or losing context
- **Template Variables**: Dynamic prompts with project context, reasoning levels, and environment info
- **Override Locations**: Local project (`.askbudi/`), global user (`~/.ASKBUDI/`), and repository-level overrides
- **Subagent Specialization**: Dedicated prompts for coding subagents vs. main conversation agents

**Example**: Use a creative prompt for brainstorming, switch to a strict coding prompt for implementation, then use a review-focused prompt for code analysis—all in the same conversation.

### 🧠 **Unprecedented Model Flexibility**
- **8 Major Providers**: OpenAI, Anthropic, xAI, Google, Groq, OpenRouter, Ollama, TogetherAI  
- **50+ AI Models**: GPT-5, Claude-4, Grok 4 Code, Gemini 2.5 Pro, DeepSeek R1, and more
- **Local Models**: Full Ollama integration for privacy-first development
- **Instant Switching**: Change models mid-conversation based on task requirements
- **Cost Optimization**: Real-time cost tracking and provider comparison

### 🎨 **Professional Terminal User Interface**
- **Rich TUI**: Built on Textual framework with desktop-class experience
- **Welcome Dashboard**: Project status, git info, API keys, model configuration
- **Interactive Model Selection**: Browse 50+ models with capability indicators (👁️ vision, 🔧 function calling)
- **Real-time Tool Visualization**: Watch AI use tools with hierarchical display
- **Conversation Management**: Session persistence with SQLite backend

### ⚡ **Advanced Chat Interface**
- **Hybrid Message Display**: Beautiful Rich markdown with text selection capabilities
- **Multiline Input**: Natural editing with Ctrl+J for new lines
- **Smart Autocomplete**: Context-aware command suggestions with Tab completion
- **Tool Call Tracking**: Real-time visualization of AI tool usage
- **History Navigation**: Full session management and conversation browsing

### 🔧 **Intelligent Project Integration**
- **Multi-Language Scanning**: Python, JavaScript/TypeScript, Rust, Go, Java detection
- **Dependency Analysis**: Parse requirements.txt, package.json, Cargo.toml, go.mod
- **Framework Recognition**: Identify pytest, React, Express, Django, Flask, and more
- **Git Integration**: Repository status, branch information, change tracking
- **MCP Server Setup**: Automatic installation and configuration for multiple AI tools

### 💰 **Revolutionary Cost Transparency**
- **Real-time Tracking**: Monitor token usage and costs per query
- **Provider Comparison**: Compare costs across different AI providers
- **Budget Management**: Set spending limits and receive alerts
- **Cost Optimization**: Intelligent model recommendations based on budget

### 🛡️ **Privacy & Security First**
- **Local-First Architecture**: Sensitive data never leaves your machine
- **Hybrid Deployment**: Choose between local models and cloud providers
- **Zero Data Retention**: Your conversations stay on your device
- **Enterprise Ready**: AGPL-3.0 with commercial licensing available

## 📦 Installation

```bash
# Install from PyPI (recommended)
pip install juno-agent

# Or install in development mode
git clone https://github.com/AskDevAI/juno-agent.git
cd juno-agent
pip install -e .

# With development dependencies
pip install -e ".[dev]"
```

## 🚀 Quick Start

### 1. Launch the TUI Interface

```bash
# Start Juno Agent (fancy TUI interface)
juno-agent

# Backward compatibility alias
juno-cli
```

### 2. Welcome Experience

Upon first launch, you'll see a professional welcome screen showing:
- Current working directory and git status
- API key configuration status  
- Selected AI model and provider
- Project health and dependency scan results

### 3. Interactive Setup

Run the guided setup wizard:
```bash
/setup
```

This will walk you through:
- API key configuration for multiple providers
- Editor selection (VS Code, Cursor, Windsurf, etc.)
- MCP server installation and configuration
- Project rules file creation (CLAUDE.md, .cursorrules, etc.)

### 4. Model Selection

Access the interactive model browser:
```bash
/model
```

Browse and select from 50+ models with:
- Capability indicators (👁️ vision, 🔧 function calling)
- Token limits displayed in human-readable format (128K, 2M)
- Real-time cost information
- Provider switching without losing context

## 🎯 Usage Guide

### Core Commands

| Command | Description | Example |
|---------|-------------|---------|
| `/setup` | Run guided configuration wizard | Complete API and editor setup |
| `/model` | Interactive model selection menu | Browse 50+ models by provider |
| `/cost` | View real-time usage and cost tracking | Monitor token usage and spending |
| `/new-chat` | Start fresh conversation (with optional summary) | Clear context, optionally summarize |
| `/compact` | Intelligent conversation compression | Optimize token usage automatically |
| `/history` | Browse conversation sessions | Load previous conversations |
| `/scan` | Analyze project dependencies and structure | Detect frameworks and dependencies |
| `/help` | Complete command reference | Full documentation |

### Key Bindings

- **Enter**: Submit message
- **Ctrl+J**: New line in multiline input
- **Ctrl+N**: Start new conversation
- **F1**: Show conversation history
- **F2/F3**: Copy message content
- **Escape**: Cancel current action
- **Tab**: Autocomplete commands

### Model Providers & Capabilities

#### 🤖 **OpenAI Family**
- **GPT-5**: Latest flagship model
- **GPT-4.1 Code**: Specialized for programming
- **GPT-4o**: Optimized for speed and cost
- **O3/O4 Series**: Advanced reasoning models

#### 🧠 **Anthropic Claude**
- **Claude-4**: Next-generation model
- **Opus 4.1**: Premium capabilities
- **Sonnet 4**: Balanced performance

#### 🔬 **xAI (Grok)**
- **Grok 4**: Advanced reasoning
- **Grok 4 Code**: Programming specialist
- **Grok 3 Family**: Cost-effective options

#### 🌐 **Google Gemini**
- **Gemini 2.5 Pro**: 2M token context
- **Gemini 2.5 Flash**: Fast responses

#### 🚀 **Others**
- **Groq**: Ultra-fast inference (Kimi K2, DeepSeek R1, Llama 3.3)
- **OpenRouter**: Free tier models including DeepSeek R1
- **Ollama**: Local models (Llama, CodeLlama, DeepSeek)
- **TogetherAI**: Cost-effective cloud models

## ⚙️ Configuration

### API Key Management

Juno Agent supports multiple providers simultaneously:

```bash
# Set OpenAI API key
export OPENAI_API_KEY="your-key-here"

# Set Anthropic API key  
export ANTHROPIC_API_KEY="your-key-here"

# Set Google AI key
export GOOGLE_AI_API_KEY="your-key-here"

# Configure through TUI
/setup
```

### 🎯 **System Prompt Customization**

**Take complete control over AI behavior** with Juno Agent's advanced system prompt management system.

#### **Priority Chain (Highest to Lowest)**

Juno Agent uses a sophisticated 7-level priority system for loading system prompts:

1. **Local Project Override** (`./.askbudi/prompts/model_slug.md`) - Highest priority
2. **Global User Override** (`~/.ASKBUDI/prompts/model_slug.md`) - User-wide settings
3. **Repository Override** (`./prompts/overrides/model_slug.md`) - Team-shared prompts  
4. **Model Direct Prompt** (`juno_config.system_prompt`) - Inline definition
5. **Model File Reference** (`juno_config.system_prompt_file`) - File path reference
6. **Prompt Garden Reference** (`juno_config.system_prompt_ref`) - Built-in prompt library
7. **Default Prompts** - `default_agent` or `coding_subagent` fallbacks

#### **Quick Start Examples**

```bash
# Create a project-specific prompt (highest priority)
mkdir -p .askbudi/prompts
echo "You are a senior Python expert focused on clean, maintainable code." > .askbudi/prompts/gpt-5-minimal.md

# Create a global user prompt (second priority)
mkdir -p ~/.ASKBUDI/prompts  
echo "You are my personal coding assistant. Be concise and direct." > ~/.ASKBUDI/prompts/gpt-5-minimal.md

# Create a team-shared prompt (third priority)
mkdir -p prompts/overrides
echo "Follow our team's coding standards and include comprehensive tests." > prompts/overrides/gpt-5-minimal.md
```

#### **Template Variables**

Use dynamic variables in your prompts for context-aware AI behavior:

```markdown
# Custom Development Assistant

You are an expert ${REASONING_EFFORT} assistant for ${PROJECT_CONTEXT}.

## Environment
- Working directory: ${WORKING_DIRECTORY}
- Platform: ${PLATFORM}
- Date: ${CURRENT_DATE}

## Project Context
${PROJECT_CONTEXT}

Be ${REASONING_EFFORT} in your responses and focus on ${PROJECT_CONTEXT} best practices.
```

#### **Model-Specific Prompts**

Customize prompts for different models and use cases:

```bash
# GPT-5 for creative brainstorming
echo "Be creative and explore multiple solutions." > .askbudi/prompts/gpt-5-high.md

# Claude-4 for code review  
echo "Focus on code quality, security, and maintainability." > .askbudi/prompts/claude-opus-4-1.md

# Coding subagents for implementation
echo "You are a focused implementation specialist." > .askbudi/prompts/coding-subagent.md
```

#### **Advanced Usage**

**File References**: Point to external prompt files
```json
{
  "juno_config": {
    "system_prompt_file": "prompts/custom/senior-architect.md"
  }
}
```

**Prompt Garden**: Use built-in prompt library
```json
{
  "juno_config": {
    "system_prompt_ref": "gpt5_agent"
  }
}
```

**Direct Inline**: Embed prompts directly in model configuration
```json
{
  "juno_config": {
    "system_prompt": "You are a TypeScript expert specializing in React applications."
  }
}
```

### Model Configuration

Models are automatically discovered and configured. Access the interactive model selection:
- Browse by provider
- Filter by capabilities (vision, function calling)
- Compare costs and token limits
- Switch models mid-conversation

### Project-Specific Settings

Juno Agent creates intelligent configuration files for your AI tools:
- **CLAUDE.md**: Claude Code configuration
- **.cursorrules**: Cursor IDE rules
- **.windsurfrules**: Windsurf configuration
- **MCP servers**: Automatic installation and setup

## 🎨 Advanced Features

### External Context System

Revolutionary automatic documentation fetching:
- **Version-Specific Docs**: Fetches documentation for exact dependency versions
- **Local Caching**: Documentation stored locally for privacy
- **MCP Integration**: VibeContext MCP server with enhanced tools
- **Automatic Updates**: Keeps documentation current with your dependencies

### Conversation Persistence

Sophisticated session management:
- **SQLite Backend**: Reliable conversation storage
- **Session Isolation**: Per-project conversation contexts
- **History Navigation**: Browse and resume previous conversations
- **Smart Compression**: Automatic context optimization

### Tool Visualization

Real-time AI tool usage display:
- **Hierarchical View**: See tool calls and subagent operations
- **Timing Information**: Track tool execution performance
- **Expandable Details**: Toggle between compact and detailed views
- **Debug Integration**: Comprehensive logging for troubleshooting

### Cost Management

Industry-first cost transparency:
- **Real-time Tracking**: Monitor token usage per query
- **Provider Comparison**: See costs across different models
- **Budget Alerts**: Set spending limits with notifications
- **Optimization Suggestions**: AI-powered cost reduction recommendations

## 🏢 Use Cases

### Individual Developers
- **Multi-Provider Flexibility**: Switch between models based on task requirements
- **Cost Optimization**: Use free tier models for simple tasks, premium for complex work
- **Privacy Control**: Local models for sensitive projects, cloud for performance
- **Terminal Workflow**: Rich TUI without leaving your preferred environment

### Development Teams  
- **Standardized Setup**: One command configures all team members' AI tools
- **Consistent Rules**: Shared configuration files ensure uniform AI behavior
- **Cost Transparency**: Team-wide usage tracking and budget management
- **Provider Flexibility**: No vendor lock-in, switch based on project needs

### Enterprise Organizations
- **Local Deployment**: Run entirely on-premises with Ollama integration
- **Compliance Ready**: AGPL-3.0 with commercial licensing available
- **Audit Logging**: Comprehensive usage tracking and reporting
- **Security First**: Zero data retention, local-first architecture

## 🎯 Competitive Advantages

### 1. **Universal AI Tool Configuration (UNIQUE MARKET POSITION)**
**The only tool that makes ALL AI coding tools smarter with one command:**
- **26+ AI Tools Configured**: Cursor, Claude Code, Windsurf, VS Code, GitHub Copilot, and 21+ others
- **Version-Specific Documentation**: Every AI tool gets current docs for your exact dependency versions
- **Smart Config Generation**: Automatically creates CLAUDE.md, .cursorrules, .windsurfrules, AGENTS.md
- **MCP Server Installation**: Configures VibeContext MCP server across all supported tools
- **No Manual Setup**: What takes hours of manual configuration happens in minutes automatically

**Market Impact**: While competitors fight for your exclusive attention, Juno Agent makes ALL your existing AI tools work better together.

### 2. **Revolutionary AI Behavior Control (INDUSTRY FIRST)**
**Complete system prompt customization** - no other tool offers this level of AI behavior control:
- **7-Level Priority System**: From global defaults to project-specific customizations
- **Model-Specific Prompts**: Different behaviors for different models and tasks
- **Real-time Switching**: Change AI personality without losing conversation context
- **Template Variables**: Dynamic prompts with project context and environment info
- **Subagent Specialization**: Dedicated prompts for coding vs. conversation agents

### 3. **True Model Freedom**
Unlike tools that lock you into single providers (GitHub Copilot → OpenAI, Claude Code → Anthropic), Juno Agent supports 50+ models from 8 providers. Switch instantly based on:
- **Task Requirements**: Use Grok 4 Code for programming, GPT-5 for analysis
- **Cost Optimization**: Mix free tier models with premium options
- **Privacy Needs**: Local models for sensitive work, cloud for performance

### 4. **Terminal Excellence**
While competitors focus on IDE integration, Juno Agent delivers a desktop-class terminal experience:
- **Rich TUI Interface**: Professional welcome screens, interactive menus, real-time visualizations
- **Native Terminal Workflow**: No context switching between tools
- **Advanced Features**: Session management, tool visualization, cost tracking

### 5. **Radical Cost Transparency**
Industry-first real-time cost tracking:
- **Per-Query Costs**: Know exactly what each interaction costs
- **Provider Comparison**: See cost differences between models in real-time
- **Budget Management**: Set limits, receive alerts, optimize spending
- **No Hidden Fees**: Transparent, usage-based pricing

### 6. **External Context Innovation**
Revolutionary documentation integration:
- **Automatic Fetching**: Get current docs for your exact dependency versions
- **Local Privacy**: Documentation cached on your machine
- **Version-Specific**: No more outdated AI suggestions based on training data
- **MCP Integration**: Most comprehensive documentation access available

## 📈 Roadmap

### Short-term (Next 3 months)
- [ ] Plugin ecosystem for custom model providers
- [ ] Team collaboration features and shared contexts
- [ ] Enhanced project templates and scaffolding
- [ ] Advanced debugging and performance profiling

### Medium-term (6 months)
- [ ] Cloud synchronization for conversations across devices  
- [ ] Advanced analytics and usage optimization
- [ ] Enterprise user management and audit logging
- [ ] Custom model fine-tuning integration

### Long-term (12+ months)
- [ ] Full IDE plugin ecosystem (VS Code, JetBrains, Vim)
- [ ] AI-powered documentation generation from codebases
- [ ] Cross-project intelligence and learning
- [ ] Advanced compliance and security certifications

## 🤝 Contributing

We welcome contributions! Juno Agent is open source under AGPL-3.0.

```bash
# Fork the repository
git clone https://github.com/AskDevAI/juno-agent.git
cd juno-agent

# Install development dependencies
pip install -e ".[dev]"

# Run tests
pytest

# Run linting
ruff check .
black .

# Type checking
mypy juno_agent/
```

### Development Setup

- **Framework**: Textual for TUI, FastAPI for any API components
- **Testing**: pytest with textual-dev for TUI testing
- **Code Quality**: Black, Ruff, MyPy for consistent code style
- **Architecture**: Modular design with handlers, widgets, and callbacks

## 📄 License

Juno Agent is released under the **AGPL-3.0 License**. This ensures the software remains open source while allowing:

- **Free Use**: Personal and internal business use
- **Commercial Support**: Enterprise licensing available
- **Community Contributions**: Open source development model
- **Transparency**: All improvements must be shared back to the community

For commercial licensing or enterprise support, please contact us at support@askbudi.ai.

## 🆘 Support

- **Documentation**: Complete guides at [docs.askbudi.ai](https://docs.askbudi.ai)
- **Issues**: Report bugs on [GitHub Issues](https://github.com/AskDevAI/juno-agent/issues)
- **Discussions**: Community support on [GitHub Discussions](https://github.com/AskDevAI/juno-agent/discussions)
- **Enterprise**: Commercial support at support@askbudi.ai

## 🌟 Why Choose Juno Agent?

In a market dominated by vendor-specific solutions, Juno Agent offers something revolutionary:

> **"Your AI assistant, your choice of brain"**
> 
> **"The only tool that makes ALL your AI tools work smarter"**

- ✅ **Universal Configuration Hub**: One setup configures 26+ AI tools automatically
- ✅ **Version-Specific Context**: Every AI tool gets current documentation, not outdated training data
- ✅ **No Vendor Lock-in**: Support for 50+ models from 8 providers
- ✅ **Terminal Excellence**: Desktop-class TUI experience
- ✅ **Cost Transparency**: Real-time tracking and optimization  
- ✅ **Privacy First**: Local models and zero data retention
- ✅ **Open Source**: AGPL-3.0 with commercial options
- ✅ **Professional Grade**: Enterprise-ready architecture

---

*Built with ❤️ for developers who value choice, transparency, and terminal excellence.*