# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetHubResult',
    'AwaitableGetHubResult',
    'get_hub',
    'get_hub_output',
]

@pulumi.output_type
class GetHubResult:
    """
    A collection of values returned by getHub.
    """
    def __init__(__self__, connector_id=None, created_at=None, description=None, id=None, is_available=None, is_default=None, last_synced_at=None, name=None, org_id=None, project_id=None, repo_branch=None, repo_name=None, tags=None, total_experiments=None, total_faults=None, updated_at=None):
        if connector_id and not isinstance(connector_id, str):
            raise TypeError("Expected argument 'connector_id' to be a str")
        pulumi.set(__self__, "connector_id", connector_id)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_available and not isinstance(is_available, bool):
            raise TypeError("Expected argument 'is_available' to be a bool")
        pulumi.set(__self__, "is_available", is_available)
        if is_default and not isinstance(is_default, bool):
            raise TypeError("Expected argument 'is_default' to be a bool")
        pulumi.set(__self__, "is_default", is_default)
        if last_synced_at and not isinstance(last_synced_at, str):
            raise TypeError("Expected argument 'last_synced_at' to be a str")
        pulumi.set(__self__, "last_synced_at", last_synced_at)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if org_id and not isinstance(org_id, str):
            raise TypeError("Expected argument 'org_id' to be a str")
        pulumi.set(__self__, "org_id", org_id)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if repo_branch and not isinstance(repo_branch, str):
            raise TypeError("Expected argument 'repo_branch' to be a str")
        pulumi.set(__self__, "repo_branch", repo_branch)
        if repo_name and not isinstance(repo_name, str):
            raise TypeError("Expected argument 'repo_name' to be a str")
        pulumi.set(__self__, "repo_name", repo_name)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if total_experiments and not isinstance(total_experiments, int):
            raise TypeError("Expected argument 'total_experiments' to be a int")
        pulumi.set(__self__, "total_experiments", total_experiments)
        if total_faults and not isinstance(total_faults, int):
            raise TypeError("Expected argument 'total_faults' to be a int")
        pulumi.set(__self__, "total_faults", total_faults)
        if updated_at and not isinstance(updated_at, str):
            raise TypeError("Expected argument 'updated_at' to be a str")
        pulumi.set(__self__, "updated_at", updated_at)

    @_builtins.property
    @pulumi.getter(name="connectorId")
    def connector_id(self) -> _builtins.str:
        """
        ID of the Git connector
        """
        return pulumi.get(self, "connector_id")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        Creation timestamp
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Description of the chaos hub
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isAvailable")
    def is_available(self) -> _builtins.bool:
        """
        Whether the chaos hub is available
        """
        return pulumi.get(self, "is_available")

    @_builtins.property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> _builtins.bool:
        """
        Whether this is the default chaos hub
        """
        return pulumi.get(self, "is_default")

    @_builtins.property
    @pulumi.getter(name="lastSyncedAt")
    def last_synced_at(self) -> _builtins.str:
        """
        Timestamp of the last sync
        """
        return pulumi.get(self, "last_synced_at")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the chaos hub
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[_builtins.str]:
        """
        The organization ID of the chaos hub
        """
        return pulumi.get(self, "org_id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[_builtins.str]:
        """
        The project ID of the chaos hub
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="repoBranch")
    def repo_branch(self) -> _builtins.str:
        """
        Git repository branch
        """
        return pulumi.get(self, "repo_branch")

    @_builtins.property
    @pulumi.getter(name="repoName")
    def repo_name(self) -> _builtins.str:
        """
        Name of the Git repository
        """
        return pulumi.get(self, "repo_name")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Sequence[_builtins.str]:
        """
        Tags associated with the chaos hub
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="totalExperiments")
    def total_experiments(self) -> _builtins.int:
        """
        Total number of experiments in the hub
        """
        return pulumi.get(self, "total_experiments")

    @_builtins.property
    @pulumi.getter(name="totalFaults")
    def total_faults(self) -> _builtins.int:
        """
        Total number of faults in the hub
        """
        return pulumi.get(self, "total_faults")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> _builtins.str:
        """
        Last update timestamp
        """
        return pulumi.get(self, "updated_at")


class AwaitableGetHubResult(GetHubResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetHubResult(
            connector_id=self.connector_id,
            created_at=self.created_at,
            description=self.description,
            id=self.id,
            is_available=self.is_available,
            is_default=self.is_default,
            last_synced_at=self.last_synced_at,
            name=self.name,
            org_id=self.org_id,
            project_id=self.project_id,
            repo_branch=self.repo_branch,
            repo_name=self.repo_name,
            tags=self.tags,
            total_experiments=self.total_experiments,
            total_faults=self.total_faults,
            updated_at=self.updated_at)


def get_hub(name: Optional[_builtins.str] = None,
            org_id: Optional[_builtins.str] = None,
            project_id: Optional[_builtins.str] = None,
            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetHubResult:
    """
    Data source for retrieving a Harness Chaos Hub

    ## Example Usage

    ```python
    import pulumi
    import pulumi_harness as harness

    example = harness.chaos.get_hub(name="<name>",
        org_id="<org_id>",
        project_id="<project_id>")
    ```


    :param _builtins.str name: Name of the chaos hub
    :param _builtins.str org_id: The organization ID of the chaos hub
    :param _builtins.str project_id: The project ID of the chaos hub
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['orgId'] = org_id
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('harness:chaos/getHub:getHub', __args__, opts=opts, typ=GetHubResult).value

    return AwaitableGetHubResult(
        connector_id=pulumi.get(__ret__, 'connector_id'),
        created_at=pulumi.get(__ret__, 'created_at'),
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        is_available=pulumi.get(__ret__, 'is_available'),
        is_default=pulumi.get(__ret__, 'is_default'),
        last_synced_at=pulumi.get(__ret__, 'last_synced_at'),
        name=pulumi.get(__ret__, 'name'),
        org_id=pulumi.get(__ret__, 'org_id'),
        project_id=pulumi.get(__ret__, 'project_id'),
        repo_branch=pulumi.get(__ret__, 'repo_branch'),
        repo_name=pulumi.get(__ret__, 'repo_name'),
        tags=pulumi.get(__ret__, 'tags'),
        total_experiments=pulumi.get(__ret__, 'total_experiments'),
        total_faults=pulumi.get(__ret__, 'total_faults'),
        updated_at=pulumi.get(__ret__, 'updated_at'))
def get_hub_output(name: Optional[pulumi.Input[_builtins.str]] = None,
                   org_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                   project_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetHubResult]:
    """
    Data source for retrieving a Harness Chaos Hub

    ## Example Usage

    ```python
    import pulumi
    import pulumi_harness as harness

    example = harness.chaos.get_hub(name="<name>",
        org_id="<org_id>",
        project_id="<project_id>")
    ```


    :param _builtins.str name: Name of the chaos hub
    :param _builtins.str org_id: The organization ID of the chaos hub
    :param _builtins.str project_id: The project ID of the chaos hub
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['orgId'] = org_id
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('harness:chaos/getHub:getHub', __args__, opts=opts, typ=GetHubResult)
    return __ret__.apply(lambda __response__: GetHubResult(
        connector_id=pulumi.get(__response__, 'connector_id'),
        created_at=pulumi.get(__response__, 'created_at'),
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        is_available=pulumi.get(__response__, 'is_available'),
        is_default=pulumi.get(__response__, 'is_default'),
        last_synced_at=pulumi.get(__response__, 'last_synced_at'),
        name=pulumi.get(__response__, 'name'),
        org_id=pulumi.get(__response__, 'org_id'),
        project_id=pulumi.get(__response__, 'project_id'),
        repo_branch=pulumi.get(__response__, 'repo_branch'),
        repo_name=pulumi.get(__response__, 'repo_name'),
        tags=pulumi.get(__response__, 'tags'),
        total_experiments=pulumi.get(__response__, 'total_experiments'),
        total_faults=pulumi.get(__response__, 'total_faults'),
        updated_at=pulumi.get(__response__, 'updated_at')))
