# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetSecurityGovernanceConditionResult',
    'AwaitableGetSecurityGovernanceConditionResult',
    'get_security_governance_condition',
    'get_security_governance_condition_output',
]

@pulumi.output_type
class GetSecurityGovernanceConditionResult:
    """
    A collection of values returned by getSecurityGovernanceCondition.
    """
    def __init__(__self__, description=None, fault_specs=None, id=None, infra_type=None, k8s_specs=None, machine_specs=None, name=None, org_id=None, project_id=None, tags=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if fault_specs and not isinstance(fault_specs, list):
            raise TypeError("Expected argument 'fault_specs' to be a list")
        pulumi.set(__self__, "fault_specs", fault_specs)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if infra_type and not isinstance(infra_type, str):
            raise TypeError("Expected argument 'infra_type' to be a str")
        pulumi.set(__self__, "infra_type", infra_type)
        if k8s_specs and not isinstance(k8s_specs, list):
            raise TypeError("Expected argument 'k8s_specs' to be a list")
        pulumi.set(__self__, "k8s_specs", k8s_specs)
        if machine_specs and not isinstance(machine_specs, list):
            raise TypeError("Expected argument 'machine_specs' to be a list")
        pulumi.set(__self__, "machine_specs", machine_specs)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if org_id and not isinstance(org_id, str):
            raise TypeError("Expected argument 'org_id' to be a str")
        pulumi.set(__self__, "org_id", org_id)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the security governance condition
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="faultSpecs")
    def fault_specs(self) -> Sequence['outputs.GetSecurityGovernanceConditionFaultSpecResult']:
        """
        Fault specification for the condition
        """
        return pulumi.get(self, "fault_specs")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the security governance condition. Either `id` or `name` must be specified.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="infraType")
    def infra_type(self) -> _builtins.str:
        """
        The infrastructure type (KubernetesV2, Linux, Windows)
        """
        return pulumi.get(self, "infra_type")

    @_builtins.property
    @pulumi.getter(name="k8sSpecs")
    def k8s_specs(self) -> Sequence['outputs.GetSecurityGovernanceConditionK8sSpecResult']:
        """
        Kubernetes specific configuration
        """
        return pulumi.get(self, "k8s_specs")

    @_builtins.property
    @pulumi.getter(name="machineSpecs")
    def machine_specs(self) -> Sequence['outputs.GetSecurityGovernanceConditionMachineSpecResult']:
        """
        Machine specific configuration
        """
        return pulumi.get(self, "machine_specs")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the security governance condition. Either `id` or `name` must be specified.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[_builtins.str]:
        """
        The organization ID of the security governance condition
        """
        return pulumi.get(self, "org_id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[_builtins.str]:
        """
        The project ID of the security governance condition
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Sequence[_builtins.str]:
        """
        Tags associated with the condition
        """
        return pulumi.get(self, "tags")


class AwaitableGetSecurityGovernanceConditionResult(GetSecurityGovernanceConditionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSecurityGovernanceConditionResult(
            description=self.description,
            fault_specs=self.fault_specs,
            id=self.id,
            infra_type=self.infra_type,
            k8s_specs=self.k8s_specs,
            machine_specs=self.machine_specs,
            name=self.name,
            org_id=self.org_id,
            project_id=self.project_id,
            tags=self.tags)


def get_security_governance_condition(id: Optional[_builtins.str] = None,
                                      name: Optional[_builtins.str] = None,
                                      org_id: Optional[_builtins.str] = None,
                                      project_id: Optional[_builtins.str] = None,
                                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSecurityGovernanceConditionResult:
    """
    Data source for retrieving a Harness Chaos Security Governance Condition

    ## Example Usage

    ```python
    import pulumi
    import pulumi_harness as harness

    # Example of looking up a security governance condition by name
    by_name = harness.chaos.get_security_governance_condition(org_id=org_id,
        project_id=project_id,
        name="k8s-security-condition")
    # Example of looking up a security governance condition by ID
    by_id = harness.chaos.get_security_governance_condition(org_id=org_id,
        project_id=project_id,
        id="<condition_id>")
    pulumi.export("securityGovernanceConditionByName", by_name)
    pulumi.export("securityGovernanceConditionById", by_id)
    ```


    :param _builtins.str id: The ID of the security governance condition. Either `id` or `name` must be specified.
    :param _builtins.str name: The name of the security governance condition. Either `id` or `name` must be specified.
    :param _builtins.str org_id: The organization ID of the security governance condition
    :param _builtins.str project_id: The project ID of the security governance condition
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    __args__['orgId'] = org_id
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('harness:chaos/getSecurityGovernanceCondition:getSecurityGovernanceCondition', __args__, opts=opts, typ=GetSecurityGovernanceConditionResult).value

    return AwaitableGetSecurityGovernanceConditionResult(
        description=pulumi.get(__ret__, 'description'),
        fault_specs=pulumi.get(__ret__, 'fault_specs'),
        id=pulumi.get(__ret__, 'id'),
        infra_type=pulumi.get(__ret__, 'infra_type'),
        k8s_specs=pulumi.get(__ret__, 'k8s_specs'),
        machine_specs=pulumi.get(__ret__, 'machine_specs'),
        name=pulumi.get(__ret__, 'name'),
        org_id=pulumi.get(__ret__, 'org_id'),
        project_id=pulumi.get(__ret__, 'project_id'),
        tags=pulumi.get(__ret__, 'tags'))
def get_security_governance_condition_output(id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                             name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                             org_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                             project_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSecurityGovernanceConditionResult]:
    """
    Data source for retrieving a Harness Chaos Security Governance Condition

    ## Example Usage

    ```python
    import pulumi
    import pulumi_harness as harness

    # Example of looking up a security governance condition by name
    by_name = harness.chaos.get_security_governance_condition(org_id=org_id,
        project_id=project_id,
        name="k8s-security-condition")
    # Example of looking up a security governance condition by ID
    by_id = harness.chaos.get_security_governance_condition(org_id=org_id,
        project_id=project_id,
        id="<condition_id>")
    pulumi.export("securityGovernanceConditionByName", by_name)
    pulumi.export("securityGovernanceConditionById", by_id)
    ```


    :param _builtins.str id: The ID of the security governance condition. Either `id` or `name` must be specified.
    :param _builtins.str name: The name of the security governance condition. Either `id` or `name` must be specified.
    :param _builtins.str org_id: The organization ID of the security governance condition
    :param _builtins.str project_id: The project ID of the security governance condition
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    __args__['orgId'] = org_id
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('harness:chaos/getSecurityGovernanceCondition:getSecurityGovernanceCondition', __args__, opts=opts, typ=GetSecurityGovernanceConditionResult)
    return __ret__.apply(lambda __response__: GetSecurityGovernanceConditionResult(
        description=pulumi.get(__response__, 'description'),
        fault_specs=pulumi.get(__response__, 'fault_specs'),
        id=pulumi.get(__response__, 'id'),
        infra_type=pulumi.get(__response__, 'infra_type'),
        k8s_specs=pulumi.get(__response__, 'k8s_specs'),
        machine_specs=pulumi.get(__response__, 'machine_specs'),
        name=pulumi.get(__response__, 'name'),
        org_id=pulumi.get(__response__, 'org_id'),
        project_id=pulumi.get(__response__, 'project_id'),
        tags=pulumi.get(__response__, 'tags')))
