# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetGitConnectorResult',
    'AwaitableGetGitConnectorResult',
    'get_git_connector',
    'get_git_connector_output',
]

@pulumi.output_type
class GetGitConnectorResult:
    """
    A collection of values returned by getGitConnector.
    """
    def __init__(__self__, branch=None, commit_details=None, created_at=None, delegate_selectors=None, generate_webhook_url=None, id=None, name=None, password_secret_id=None, ssh_setting_id=None, url=None, url_type=None, username=None, webhook_url=None):
        if branch and not isinstance(branch, str):
            raise TypeError("Expected argument 'branch' to be a str")
        pulumi.set(__self__, "branch", branch)
        if commit_details and not isinstance(commit_details, list):
            raise TypeError("Expected argument 'commit_details' to be a list")
        pulumi.set(__self__, "commit_details", commit_details)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if delegate_selectors and not isinstance(delegate_selectors, list):
            raise TypeError("Expected argument 'delegate_selectors' to be a list")
        pulumi.set(__self__, "delegate_selectors", delegate_selectors)
        if generate_webhook_url and not isinstance(generate_webhook_url, bool):
            raise TypeError("Expected argument 'generate_webhook_url' to be a bool")
        pulumi.set(__self__, "generate_webhook_url", generate_webhook_url)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if password_secret_id and not isinstance(password_secret_id, str):
            raise TypeError("Expected argument 'password_secret_id' to be a str")
        pulumi.set(__self__, "password_secret_id", password_secret_id)
        if ssh_setting_id and not isinstance(ssh_setting_id, str):
            raise TypeError("Expected argument 'ssh_setting_id' to be a str")
        pulumi.set(__self__, "ssh_setting_id", ssh_setting_id)
        if url and not isinstance(url, str):
            raise TypeError("Expected argument 'url' to be a str")
        pulumi.set(__self__, "url", url)
        if url_type and not isinstance(url_type, str):
            raise TypeError("Expected argument 'url_type' to be a str")
        pulumi.set(__self__, "url_type", url_type)
        if username and not isinstance(username, str):
            raise TypeError("Expected argument 'username' to be a str")
        pulumi.set(__self__, "username", username)
        if webhook_url and not isinstance(webhook_url, str):
            raise TypeError("Expected argument 'webhook_url' to be a str")
        pulumi.set(__self__, "webhook_url", webhook_url)

    @_builtins.property
    @pulumi.getter
    def branch(self) -> _builtins.str:
        """
        The branch of the git connector to use.
        """
        return pulumi.get(self, "branch")

    @_builtins.property
    @pulumi.getter(name="commitDetails")
    def commit_details(self) -> Sequence['outputs.GetGitConnectorCommitDetailResult']:
        """
        Custom details to use when making commits using this git connector.
        """
        return pulumi.get(self, "commit_details")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        The time the git connector was created.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="delegateSelectors")
    def delegate_selectors(self) -> Sequence[_builtins.str]:
        """
        Delegate selectors to apply to this git connector.
        """
        return pulumi.get(self, "delegate_selectors")

    @_builtins.property
    @pulumi.getter(name="generateWebhookUrl")
    def generate_webhook_url(self) -> _builtins.bool:
        """
        Boolean indicating whether or not to generate a webhook url.
        """
        return pulumi.get(self, "generate_webhook_url")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        Id of the git connector.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The name of the git connector.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="passwordSecretId")
    def password_secret_id(self) -> _builtins.str:
        """
        The id of the secret for connecting to the git repository.
        """
        return pulumi.get(self, "password_secret_id")

    @_builtins.property
    @pulumi.getter(name="sshSettingId")
    def ssh_setting_id(self) -> _builtins.str:
        """
        The id of the SSH secret to use.
        """
        return pulumi.get(self, "ssh_setting_id")

    @_builtins.property
    @pulumi.getter
    def url(self) -> _builtins.str:
        """
        The URL of the git repository or account/organization.
        """
        return pulumi.get(self, "url")

    @_builtins.property
    @pulumi.getter(name="urlType")
    def url_type(self) -> _builtins.str:
        """
        The type of git url being used. Options are `ACCOUNT`, and `REPO`.
        """
        return pulumi.get(self, "url_type")

    @_builtins.property
    @pulumi.getter
    def username(self) -> _builtins.str:
        """
        The name of the user used to connect to the git repository.
        """
        return pulumi.get(self, "username")

    @_builtins.property
    @pulumi.getter(name="webhookUrl")
    def webhook_url(self) -> _builtins.str:
        """
        The generated webhook url.
        """
        return pulumi.get(self, "webhook_url")


class AwaitableGetGitConnectorResult(GetGitConnectorResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetGitConnectorResult(
            branch=self.branch,
            commit_details=self.commit_details,
            created_at=self.created_at,
            delegate_selectors=self.delegate_selectors,
            generate_webhook_url=self.generate_webhook_url,
            id=self.id,
            name=self.name,
            password_secret_id=self.password_secret_id,
            ssh_setting_id=self.ssh_setting_id,
            url=self.url,
            url_type=self.url_type,
            username=self.username,
            webhook_url=self.webhook_url)


def get_git_connector(id: Optional[_builtins.str] = None,
                      name: Optional[_builtins.str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetGitConnectorResult:
    """
    Data source for retrieving a Harness application


    :param _builtins.str id: Id of the git connector.
    :param _builtins.str name: The name of the git connector.
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('harness:index/getGitConnector:getGitConnector', __args__, opts=opts, typ=GetGitConnectorResult).value

    return AwaitableGetGitConnectorResult(
        branch=pulumi.get(__ret__, 'branch'),
        commit_details=pulumi.get(__ret__, 'commit_details'),
        created_at=pulumi.get(__ret__, 'created_at'),
        delegate_selectors=pulumi.get(__ret__, 'delegate_selectors'),
        generate_webhook_url=pulumi.get(__ret__, 'generate_webhook_url'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        password_secret_id=pulumi.get(__ret__, 'password_secret_id'),
        ssh_setting_id=pulumi.get(__ret__, 'ssh_setting_id'),
        url=pulumi.get(__ret__, 'url'),
        url_type=pulumi.get(__ret__, 'url_type'),
        username=pulumi.get(__ret__, 'username'),
        webhook_url=pulumi.get(__ret__, 'webhook_url'))
def get_git_connector_output(id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetGitConnectorResult]:
    """
    Data source for retrieving a Harness application


    :param _builtins.str id: Id of the git connector.
    :param _builtins.str name: The name of the git connector.
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('harness:index/getGitConnector:getGitConnector', __args__, opts=opts, typ=GetGitConnectorResult)
    return __ret__.apply(lambda __response__: GetGitConnectorResult(
        branch=pulumi.get(__response__, 'branch'),
        commit_details=pulumi.get(__response__, 'commit_details'),
        created_at=pulumi.get(__response__, 'created_at'),
        delegate_selectors=pulumi.get(__response__, 'delegate_selectors'),
        generate_webhook_url=pulumi.get(__response__, 'generate_webhook_url'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        password_secret_id=pulumi.get(__response__, 'password_secret_id'),
        ssh_setting_id=pulumi.get(__response__, 'ssh_setting_id'),
        url=pulumi.get(__response__, 'url'),
        url_type=pulumi.get(__response__, 'url_type'),
        username=pulumi.get(__response__, 'username'),
        webhook_url=pulumi.get(__response__, 'webhook_url')))
