# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetCurrentUserResult',
    'AwaitableGetCurrentUserResult',
    'get_current_user',
    'get_current_user_output',
]

@pulumi.output_type
class GetCurrentUserResult:
    """
    A collection of values returned by getCurrentUser.
    """
    def __init__(__self__, admin=None, billing_frequency=None, default_account_id=None, edition=None, email=None, email_verified=None, id=None, intent=None, is_two_factor_auth_enabled=None, locked=None, name=None, signup_action=None, token=None, uuid=None):
        if admin and not isinstance(admin, bool):
            raise TypeError("Expected argument 'admin' to be a bool")
        pulumi.set(__self__, "admin", admin)
        if billing_frequency and not isinstance(billing_frequency, str):
            raise TypeError("Expected argument 'billing_frequency' to be a str")
        pulumi.set(__self__, "billing_frequency", billing_frequency)
        if default_account_id and not isinstance(default_account_id, str):
            raise TypeError("Expected argument 'default_account_id' to be a str")
        pulumi.set(__self__, "default_account_id", default_account_id)
        if edition and not isinstance(edition, str):
            raise TypeError("Expected argument 'edition' to be a str")
        pulumi.set(__self__, "edition", edition)
        if email and not isinstance(email, str):
            raise TypeError("Expected argument 'email' to be a str")
        pulumi.set(__self__, "email", email)
        if email_verified and not isinstance(email_verified, bool):
            raise TypeError("Expected argument 'email_verified' to be a bool")
        pulumi.set(__self__, "email_verified", email_verified)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if intent and not isinstance(intent, str):
            raise TypeError("Expected argument 'intent' to be a str")
        pulumi.set(__self__, "intent", intent)
        if is_two_factor_auth_enabled and not isinstance(is_two_factor_auth_enabled, bool):
            raise TypeError("Expected argument 'is_two_factor_auth_enabled' to be a bool")
        pulumi.set(__self__, "is_two_factor_auth_enabled", is_two_factor_auth_enabled)
        if locked and not isinstance(locked, bool):
            raise TypeError("Expected argument 'locked' to be a bool")
        pulumi.set(__self__, "locked", locked)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if signup_action and not isinstance(signup_action, str):
            raise TypeError("Expected argument 'signup_action' to be a str")
        pulumi.set(__self__, "signup_action", signup_action)
        if token and not isinstance(token, str):
            raise TypeError("Expected argument 'token' to be a str")
        pulumi.set(__self__, "token", token)
        if uuid and not isinstance(uuid, str):
            raise TypeError("Expected argument 'uuid' to be a str")
        pulumi.set(__self__, "uuid", uuid)

    @_builtins.property
    @pulumi.getter
    def admin(self) -> _builtins.bool:
        """
        Whether the user is an administrator.
        """
        return pulumi.get(self, "admin")

    @_builtins.property
    @pulumi.getter(name="billingFrequency")
    def billing_frequency(self) -> _builtins.str:
        """
        Billing frequency of the user.
        """
        return pulumi.get(self, "billing_frequency")

    @_builtins.property
    @pulumi.getter(name="defaultAccountId")
    def default_account_id(self) -> _builtins.str:
        """
        Default account ID of the user.
        """
        return pulumi.get(self, "default_account_id")

    @_builtins.property
    @pulumi.getter
    def edition(self) -> _builtins.str:
        """
        Edition of the platform being used.
        """
        return pulumi.get(self, "edition")

    @_builtins.property
    @pulumi.getter
    def email(self) -> _builtins.str:
        """
        Email address of the user.
        """
        return pulumi.get(self, "email")

    @_builtins.property
    @pulumi.getter(name="emailVerified")
    def email_verified(self) -> _builtins.bool:
        """
        Whether the user's email address has been verified.
        """
        return pulumi.get(self, "email_verified")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def intent(self) -> _builtins.str:
        """
        Intent of the user.
        """
        return pulumi.get(self, "intent")

    @_builtins.property
    @pulumi.getter(name="isTwoFactorAuthEnabled")
    def is_two_factor_auth_enabled(self) -> _builtins.bool:
        """
        Whether 2FA is enabled for the user.
        """
        return pulumi.get(self, "is_two_factor_auth_enabled")

    @_builtins.property
    @pulumi.getter
    def locked(self) -> _builtins.bool:
        """
        Whether or not the user account is locked.
        """
        return pulumi.get(self, "locked")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the user.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="signupAction")
    def signup_action(self) -> _builtins.str:
        """
        Signup action of the user.
        """
        return pulumi.get(self, "signup_action")

    @_builtins.property
    @pulumi.getter
    def token(self) -> _builtins.str:
        """
        Token used to authenticate the user.
        """
        return pulumi.get(self, "token")

    @_builtins.property
    @pulumi.getter
    def uuid(self) -> _builtins.str:
        """
        Unique identifier of the user.
        """
        return pulumi.get(self, "uuid")


class AwaitableGetCurrentUserResult(GetCurrentUserResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCurrentUserResult(
            admin=self.admin,
            billing_frequency=self.billing_frequency,
            default_account_id=self.default_account_id,
            edition=self.edition,
            email=self.email,
            email_verified=self.email_verified,
            id=self.id,
            intent=self.intent,
            is_two_factor_auth_enabled=self.is_two_factor_auth_enabled,
            locked=self.locked,
            name=self.name,
            signup_action=self.signup_action,
            token=self.token,
            uuid=self.uuid)


def get_current_user(opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCurrentUserResult:
    """
    Data source for retrieving the current user based on the API key.
    """
    __args__ = dict()
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('harness:platform/getCurrentUser:getCurrentUser', __args__, opts=opts, typ=GetCurrentUserResult).value

    return AwaitableGetCurrentUserResult(
        admin=pulumi.get(__ret__, 'admin'),
        billing_frequency=pulumi.get(__ret__, 'billing_frequency'),
        default_account_id=pulumi.get(__ret__, 'default_account_id'),
        edition=pulumi.get(__ret__, 'edition'),
        email=pulumi.get(__ret__, 'email'),
        email_verified=pulumi.get(__ret__, 'email_verified'),
        id=pulumi.get(__ret__, 'id'),
        intent=pulumi.get(__ret__, 'intent'),
        is_two_factor_auth_enabled=pulumi.get(__ret__, 'is_two_factor_auth_enabled'),
        locked=pulumi.get(__ret__, 'locked'),
        name=pulumi.get(__ret__, 'name'),
        signup_action=pulumi.get(__ret__, 'signup_action'),
        token=pulumi.get(__ret__, 'token'),
        uuid=pulumi.get(__ret__, 'uuid'))
def get_current_user_output(opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCurrentUserResult]:
    """
    Data source for retrieving the current user based on the API key.
    """
    __args__ = dict()
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('harness:platform/getCurrentUser:getCurrentUser', __args__, opts=opts, typ=GetCurrentUserResult)
    return __ret__.apply(lambda __response__: GetCurrentUserResult(
        admin=pulumi.get(__response__, 'admin'),
        billing_frequency=pulumi.get(__response__, 'billing_frequency'),
        default_account_id=pulumi.get(__response__, 'default_account_id'),
        edition=pulumi.get(__response__, 'edition'),
        email=pulumi.get(__response__, 'email'),
        email_verified=pulumi.get(__response__, 'email_verified'),
        id=pulumi.get(__response__, 'id'),
        intent=pulumi.get(__response__, 'intent'),
        is_two_factor_auth_enabled=pulumi.get(__response__, 'is_two_factor_auth_enabled'),
        locked=pulumi.get(__response__, 'locked'),
        name=pulumi.get(__response__, 'name'),
        signup_action=pulumi.get(__response__, 'signup_action'),
        token=pulumi.get(__response__, 'token'),
        uuid=pulumi.get(__response__, 'uuid')))
