# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetPolicySetResult',
    'AwaitableGetPolicySetResult',
    'get_policy_set',
    'get_policy_set_output',
]

@pulumi.output_type
class GetPolicySetResult:
    """
    A collection of values returned by getPolicySet.
    """
    def __init__(__self__, action=None, description=None, enabled=None, id=None, identifier=None, name=None, org_id=None, policies=None, project_id=None, tags=None, type=None):
        if action and not isinstance(action, str):
            raise TypeError("Expected argument 'action' to be a str")
        pulumi.set(__self__, "action", action)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if enabled and not isinstance(enabled, bool):
            raise TypeError("Expected argument 'enabled' to be a bool")
        pulumi.set(__self__, "enabled", enabled)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if identifier and not isinstance(identifier, str):
            raise TypeError("Expected argument 'identifier' to be a str")
        pulumi.set(__self__, "identifier", identifier)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if org_id and not isinstance(org_id, str):
            raise TypeError("Expected argument 'org_id' to be a str")
        pulumi.set(__self__, "org_id", org_id)
        if policies and not isinstance(policies, list):
            raise TypeError("Expected argument 'policies' to be a list")
        pulumi.set(__self__, "policies", policies)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def action(self) -> _builtins.str:
        """
        Action code for the policyset.
        """
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Description of the resource.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[_builtins.bool]:
        """
        Enabled for the policyset.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def identifier(self) -> _builtins.str:
        """
        Unique identifier of the resource.
        """
        return pulumi.get(self, "identifier")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Name of the resource.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[_builtins.str]:
        """
        Unique identifier of the organization.
        """
        return pulumi.get(self, "org_id")

    @_builtins.property
    @pulumi.getter
    def policies(self) -> Optional[Sequence['outputs.GetPolicySetPolicyResult']]:
        """
        List of policy identifiers / severity for the policyset.
        """
        return pulumi.get(self, "policies")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[_builtins.str]:
        """
        Unique identifier of the project.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Sequence[_builtins.str]:
        """
        Tags to associate with the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Type of the policyset.
        """
        return pulumi.get(self, "type")


class AwaitableGetPolicySetResult(GetPolicySetResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPolicySetResult(
            action=self.action,
            description=self.description,
            enabled=self.enabled,
            id=self.id,
            identifier=self.identifier,
            name=self.name,
            org_id=self.org_id,
            policies=self.policies,
            project_id=self.project_id,
            tags=self.tags,
            type=self.type)


def get_policy_set(action: Optional[_builtins.str] = None,
                   enabled: Optional[_builtins.bool] = None,
                   identifier: Optional[_builtins.str] = None,
                   name: Optional[_builtins.str] = None,
                   org_id: Optional[_builtins.str] = None,
                   policies: Optional[Sequence[Union['GetPolicySetPolicyArgs', 'GetPolicySetPolicyArgsDict']]] = None,
                   project_id: Optional[_builtins.str] = None,
                   type: Optional[_builtins.str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPolicySetResult:
    """
    Data source for retrieving a Harness policyset.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_harness as harness

    test = harness.platform.get_policy_set(identifier="harness_platform_policyset.test.identifier",
        name="harness_platform_policyset.test.name",
        action="onrun",
        type="pipeline",
        enabled=True,
        policies=[{
            "identifier": "always_run",
            "severity": "warning",
        }])
    ```


    :param _builtins.str action: Action code for the policyset.
    :param _builtins.bool enabled: Enabled for the policyset.
    :param _builtins.str identifier: Unique identifier of the resource.
    :param _builtins.str name: Name of the resource.
    :param _builtins.str org_id: Unique identifier of the organization.
    :param Sequence[Union['GetPolicySetPolicyArgs', 'GetPolicySetPolicyArgsDict']] policies: List of policy identifiers / severity for the policyset.
    :param _builtins.str project_id: Unique identifier of the project.
    :param _builtins.str type: Type of the policyset.
    """
    __args__ = dict()
    __args__['action'] = action
    __args__['enabled'] = enabled
    __args__['identifier'] = identifier
    __args__['name'] = name
    __args__['orgId'] = org_id
    __args__['policies'] = policies
    __args__['projectId'] = project_id
    __args__['type'] = type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('harness:platform/getPolicySet:getPolicySet', __args__, opts=opts, typ=GetPolicySetResult).value

    return AwaitableGetPolicySetResult(
        action=pulumi.get(__ret__, 'action'),
        description=pulumi.get(__ret__, 'description'),
        enabled=pulumi.get(__ret__, 'enabled'),
        id=pulumi.get(__ret__, 'id'),
        identifier=pulumi.get(__ret__, 'identifier'),
        name=pulumi.get(__ret__, 'name'),
        org_id=pulumi.get(__ret__, 'org_id'),
        policies=pulumi.get(__ret__, 'policies'),
        project_id=pulumi.get(__ret__, 'project_id'),
        tags=pulumi.get(__ret__, 'tags'),
        type=pulumi.get(__ret__, 'type'))
def get_policy_set_output(action: Optional[pulumi.Input[_builtins.str]] = None,
                          enabled: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                          identifier: Optional[pulumi.Input[_builtins.str]] = None,
                          name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                          org_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                          policies: Optional[pulumi.Input[Optional[Sequence[Union['GetPolicySetPolicyArgs', 'GetPolicySetPolicyArgsDict']]]]] = None,
                          project_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                          type: Optional[pulumi.Input[_builtins.str]] = None,
                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPolicySetResult]:
    """
    Data source for retrieving a Harness policyset.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_harness as harness

    test = harness.platform.get_policy_set(identifier="harness_platform_policyset.test.identifier",
        name="harness_platform_policyset.test.name",
        action="onrun",
        type="pipeline",
        enabled=True,
        policies=[{
            "identifier": "always_run",
            "severity": "warning",
        }])
    ```


    :param _builtins.str action: Action code for the policyset.
    :param _builtins.bool enabled: Enabled for the policyset.
    :param _builtins.str identifier: Unique identifier of the resource.
    :param _builtins.str name: Name of the resource.
    :param _builtins.str org_id: Unique identifier of the organization.
    :param Sequence[Union['GetPolicySetPolicyArgs', 'GetPolicySetPolicyArgsDict']] policies: List of policy identifiers / severity for the policyset.
    :param _builtins.str project_id: Unique identifier of the project.
    :param _builtins.str type: Type of the policyset.
    """
    __args__ = dict()
    __args__['action'] = action
    __args__['enabled'] = enabled
    __args__['identifier'] = identifier
    __args__['name'] = name
    __args__['orgId'] = org_id
    __args__['policies'] = policies
    __args__['projectId'] = project_id
    __args__['type'] = type
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('harness:platform/getPolicySet:getPolicySet', __args__, opts=opts, typ=GetPolicySetResult)
    return __ret__.apply(lambda __response__: GetPolicySetResult(
        action=pulumi.get(__response__, 'action'),
        description=pulumi.get(__response__, 'description'),
        enabled=pulumi.get(__response__, 'enabled'),
        id=pulumi.get(__response__, 'id'),
        identifier=pulumi.get(__response__, 'identifier'),
        name=pulumi.get(__response__, 'name'),
        org_id=pulumi.get(__response__, 'org_id'),
        policies=pulumi.get(__response__, 'policies'),
        project_id=pulumi.get(__response__, 'project_id'),
        tags=pulumi.get(__response__, 'tags'),
        type=pulumi.get(__response__, 'type')))
