# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetResourceGroupResult',
    'AwaitableGetResourceGroupResult',
    'get_resource_group',
    'get_resource_group_output',
]

@pulumi.output_type
class GetResourceGroupResult:
    """
    A collection of values returned by getResourceGroup.
    """
    def __init__(__self__, account_id=None, allowed_scope_levels=None, color=None, description=None, id=None, identifier=None, included_scopes=None, name=None, org_id=None, project_id=None, resource_filters=None, tags=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if allowed_scope_levels and not isinstance(allowed_scope_levels, list):
            raise TypeError("Expected argument 'allowed_scope_levels' to be a list")
        pulumi.set(__self__, "allowed_scope_levels", allowed_scope_levels)
        if color and not isinstance(color, str):
            raise TypeError("Expected argument 'color' to be a str")
        pulumi.set(__self__, "color", color)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if identifier and not isinstance(identifier, str):
            raise TypeError("Expected argument 'identifier' to be a str")
        pulumi.set(__self__, "identifier", identifier)
        if included_scopes and not isinstance(included_scopes, list):
            raise TypeError("Expected argument 'included_scopes' to be a list")
        pulumi.set(__self__, "included_scopes", included_scopes)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if org_id and not isinstance(org_id, str):
            raise TypeError("Expected argument 'org_id' to be a str")
        pulumi.set(__self__, "org_id", org_id)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if resource_filters and not isinstance(resource_filters, list):
            raise TypeError("Expected argument 'resource_filters' to be a list")
        pulumi.set(__self__, "resource_filters", resource_filters)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> _builtins.str:
        """
        Account Identifier of the account
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter(name="allowedScopeLevels")
    def allowed_scope_levels(self) -> Sequence[_builtins.str]:
        """
        The scope levels at which this resource group can be used
        """
        return pulumi.get(self, "allowed_scope_levels")

    @_builtins.property
    @pulumi.getter
    def color(self) -> _builtins.str:
        """
        Color of the environment.
        """
        return pulumi.get(self, "color")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Description of the resource.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def identifier(self) -> _builtins.str:
        """
        Unique identifier of the resource.
        """
        return pulumi.get(self, "identifier")

    @_builtins.property
    @pulumi.getter(name="includedScopes")
    def included_scopes(self) -> Sequence['outputs.GetResourceGroupIncludedScopeResult']:
        """
        Included scopes
        """
        return pulumi.get(self, "included_scopes")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Name of the resource.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[_builtins.str]:
        """
        Unique identifier of the organization.
        """
        return pulumi.get(self, "org_id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[_builtins.str]:
        """
        Unique identifier of the project.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="resourceFilters")
    def resource_filters(self) -> Sequence['outputs.GetResourceGroupResourceFilterResult']:
        """
        Contains resource filter for a resource group
        """
        return pulumi.get(self, "resource_filters")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Sequence[_builtins.str]:
        """
        Tags to associate with the resource.
        """
        return pulumi.get(self, "tags")


class AwaitableGetResourceGroupResult(GetResourceGroupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetResourceGroupResult(
            account_id=self.account_id,
            allowed_scope_levels=self.allowed_scope_levels,
            color=self.color,
            description=self.description,
            id=self.id,
            identifier=self.identifier,
            included_scopes=self.included_scopes,
            name=self.name,
            org_id=self.org_id,
            project_id=self.project_id,
            resource_filters=self.resource_filters,
            tags=self.tags)


def get_resource_group(identifier: Optional[_builtins.str] = None,
                       name: Optional[_builtins.str] = None,
                       org_id: Optional[_builtins.str] = None,
                       project_id: Optional[_builtins.str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetResourceGroupResult:
    """
    DataSource for looking up resource group in harness.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_harness as harness

    test = harness.platform.get_resource_group(identifier="identifier")
    ```


    :param _builtins.str identifier: Unique identifier of the resource.
    :param _builtins.str name: Name of the resource.
    :param _builtins.str org_id: Unique identifier of the organization.
    :param _builtins.str project_id: Unique identifier of the project.
    """
    __args__ = dict()
    __args__['identifier'] = identifier
    __args__['name'] = name
    __args__['orgId'] = org_id
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('harness:platform/getResourceGroup:getResourceGroup', __args__, opts=opts, typ=GetResourceGroupResult).value

    return AwaitableGetResourceGroupResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        allowed_scope_levels=pulumi.get(__ret__, 'allowed_scope_levels'),
        color=pulumi.get(__ret__, 'color'),
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        identifier=pulumi.get(__ret__, 'identifier'),
        included_scopes=pulumi.get(__ret__, 'included_scopes'),
        name=pulumi.get(__ret__, 'name'),
        org_id=pulumi.get(__ret__, 'org_id'),
        project_id=pulumi.get(__ret__, 'project_id'),
        resource_filters=pulumi.get(__ret__, 'resource_filters'),
        tags=pulumi.get(__ret__, 'tags'))
def get_resource_group_output(identifier: Optional[pulumi.Input[_builtins.str]] = None,
                              name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              org_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              project_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetResourceGroupResult]:
    """
    DataSource for looking up resource group in harness.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_harness as harness

    test = harness.platform.get_resource_group(identifier="identifier")
    ```


    :param _builtins.str identifier: Unique identifier of the resource.
    :param _builtins.str name: Name of the resource.
    :param _builtins.str org_id: Unique identifier of the organization.
    :param _builtins.str project_id: Unique identifier of the project.
    """
    __args__ = dict()
    __args__['identifier'] = identifier
    __args__['name'] = name
    __args__['orgId'] = org_id
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('harness:platform/getResourceGroup:getResourceGroup', __args__, opts=opts, typ=GetResourceGroupResult)
    return __ret__.apply(lambda __response__: GetResourceGroupResult(
        account_id=pulumi.get(__response__, 'account_id'),
        allowed_scope_levels=pulumi.get(__response__, 'allowed_scope_levels'),
        color=pulumi.get(__response__, 'color'),
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        identifier=pulumi.get(__response__, 'identifier'),
        included_scopes=pulumi.get(__response__, 'included_scopes'),
        name=pulumi.get(__response__, 'name'),
        org_id=pulumi.get(__response__, 'org_id'),
        project_id=pulumi.get(__response__, 'project_id'),
        resource_filters=pulumi.get(__response__, 'resource_filters'),
        tags=pulumi.get(__response__, 'tags')))
