# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetWorkspaceResult',
    'AwaitableGetWorkspaceResult',
    'get_workspace',
    'get_workspace_output',
]

@pulumi.output_type
class GetWorkspaceResult:
    """
    A collection of values returned by getWorkspace.
    """
    def __init__(__self__, connectors=None, cost_estimation_enabled=None, default_pipelines=None, description=None, environment_variables=None, id=None, identifier=None, name=None, org_id=None, project_id=None, provider_connector=None, provisioner_type=None, provisioner_version=None, repository=None, repository_branch=None, repository_commit=None, repository_connector=None, repository_path=None, repository_sha=None, tags=None, terraform_variable_files=None, terraform_variables=None, variable_sets=None):
        if connectors and not isinstance(connectors, list):
            raise TypeError("Expected argument 'connectors' to be a list")
        pulumi.set(__self__, "connectors", connectors)
        if cost_estimation_enabled and not isinstance(cost_estimation_enabled, bool):
            raise TypeError("Expected argument 'cost_estimation_enabled' to be a bool")
        pulumi.set(__self__, "cost_estimation_enabled", cost_estimation_enabled)
        if default_pipelines and not isinstance(default_pipelines, dict):
            raise TypeError("Expected argument 'default_pipelines' to be a dict")
        pulumi.set(__self__, "default_pipelines", default_pipelines)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if environment_variables and not isinstance(environment_variables, list):
            raise TypeError("Expected argument 'environment_variables' to be a list")
        pulumi.set(__self__, "environment_variables", environment_variables)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if identifier and not isinstance(identifier, str):
            raise TypeError("Expected argument 'identifier' to be a str")
        pulumi.set(__self__, "identifier", identifier)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if org_id and not isinstance(org_id, str):
            raise TypeError("Expected argument 'org_id' to be a str")
        pulumi.set(__self__, "org_id", org_id)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if provider_connector and not isinstance(provider_connector, str):
            raise TypeError("Expected argument 'provider_connector' to be a str")
        pulumi.set(__self__, "provider_connector", provider_connector)
        if provisioner_type and not isinstance(provisioner_type, str):
            raise TypeError("Expected argument 'provisioner_type' to be a str")
        pulumi.set(__self__, "provisioner_type", provisioner_type)
        if provisioner_version and not isinstance(provisioner_version, str):
            raise TypeError("Expected argument 'provisioner_version' to be a str")
        pulumi.set(__self__, "provisioner_version", provisioner_version)
        if repository and not isinstance(repository, str):
            raise TypeError("Expected argument 'repository' to be a str")
        pulumi.set(__self__, "repository", repository)
        if repository_branch and not isinstance(repository_branch, str):
            raise TypeError("Expected argument 'repository_branch' to be a str")
        pulumi.set(__self__, "repository_branch", repository_branch)
        if repository_commit and not isinstance(repository_commit, str):
            raise TypeError("Expected argument 'repository_commit' to be a str")
        pulumi.set(__self__, "repository_commit", repository_commit)
        if repository_connector and not isinstance(repository_connector, str):
            raise TypeError("Expected argument 'repository_connector' to be a str")
        pulumi.set(__self__, "repository_connector", repository_connector)
        if repository_path and not isinstance(repository_path, str):
            raise TypeError("Expected argument 'repository_path' to be a str")
        pulumi.set(__self__, "repository_path", repository_path)
        if repository_sha and not isinstance(repository_sha, str):
            raise TypeError("Expected argument 'repository_sha' to be a str")
        pulumi.set(__self__, "repository_sha", repository_sha)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if terraform_variable_files and not isinstance(terraform_variable_files, list):
            raise TypeError("Expected argument 'terraform_variable_files' to be a list")
        pulumi.set(__self__, "terraform_variable_files", terraform_variable_files)
        if terraform_variables and not isinstance(terraform_variables, list):
            raise TypeError("Expected argument 'terraform_variables' to be a list")
        pulumi.set(__self__, "terraform_variables", terraform_variables)
        if variable_sets and not isinstance(variable_sets, list):
            raise TypeError("Expected argument 'variable_sets' to be a list")
        pulumi.set(__self__, "variable_sets", variable_sets)

    @_builtins.property
    @pulumi.getter
    def connectors(self) -> Optional[Sequence['outputs.GetWorkspaceConnectorResult']]:
        """
        Provider connectors configured on the Workspace. Only one connector of a type is supported
        """
        return pulumi.get(self, "connectors")

    @_builtins.property
    @pulumi.getter(name="costEstimationEnabled")
    def cost_estimation_enabled(self) -> _builtins.bool:
        """
        If enabled cost estimation operations will be performed in this workspace
        """
        return pulumi.get(self, "cost_estimation_enabled")

    @_builtins.property
    @pulumi.getter(name="defaultPipelines")
    def default_pipelines(self) -> Mapping[str, _builtins.str]:
        """
        Default pipelines associated with this workspace
        """
        return pulumi.get(self, "default_pipelines")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Description of the Workspace
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> Sequence['outputs.GetWorkspaceEnvironmentVariableResult']:
        """
        Environment variables configured on the workspace
        """
        return pulumi.get(self, "environment_variables")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def identifier(self) -> _builtins.str:
        """
        Identifier of the Workspace
        """
        return pulumi.get(self, "identifier")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the Workspace
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> _builtins.str:
        """
        Organization Identifier
        """
        return pulumi.get(self, "org_id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.str:
        """
        Project Identifier
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="providerConnector")
    def provider_connector(self) -> _builtins.str:
        """
        Provider Connector is the reference to the connector for the infrastructure provider
        """
        return pulumi.get(self, "provider_connector")

    @_builtins.property
    @pulumi.getter(name="provisionerType")
    def provisioner_type(self) -> _builtins.str:
        """
        Provisioner type defines the provisioning tool to use.
        """
        return pulumi.get(self, "provisioner_type")

    @_builtins.property
    @pulumi.getter(name="provisionerVersion")
    def provisioner_version(self) -> _builtins.str:
        """
        Provisioner Version defines the tool version to use
        """
        return pulumi.get(self, "provisioner_version")

    @_builtins.property
    @pulumi.getter
    def repository(self) -> _builtins.str:
        """
        Repository is the name of the repository to use
        """
        return pulumi.get(self, "repository")

    @_builtins.property
    @pulumi.getter(name="repositoryBranch")
    def repository_branch(self) -> _builtins.str:
        """
        Repository Branch in which the code should be accessed
        """
        return pulumi.get(self, "repository_branch")

    @_builtins.property
    @pulumi.getter(name="repositoryCommit")
    def repository_commit(self) -> _builtins.str:
        """
        Repository Tag in which the code should be accessed
        """
        return pulumi.get(self, "repository_commit")

    @_builtins.property
    @pulumi.getter(name="repositoryConnector")
    def repository_connector(self) -> _builtins.str:
        """
        Repository Connector is the reference to the connector to use for this code
        """
        return pulumi.get(self, "repository_connector")

    @_builtins.property
    @pulumi.getter(name="repositoryPath")
    def repository_path(self) -> _builtins.str:
        """
        Repository Path is the path in which the infra code resides
        """
        return pulumi.get(self, "repository_path")

    @_builtins.property
    @pulumi.getter(name="repositorySha")
    def repository_sha(self) -> _builtins.str:
        """
        Repository Commit SHA in which the code should be accessed
        """
        return pulumi.get(self, "repository_sha")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[Sequence[_builtins.str]]:
        """
        Tags to associate with the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="terraformVariableFiles")
    def terraform_variable_files(self) -> Sequence['outputs.GetWorkspaceTerraformVariableFileResult']:
        return pulumi.get(self, "terraform_variable_files")

    @_builtins.property
    @pulumi.getter(name="terraformVariables")
    def terraform_variables(self) -> Sequence['outputs.GetWorkspaceTerraformVariableResult']:
        return pulumi.get(self, "terraform_variables")

    @_builtins.property
    @pulumi.getter(name="variableSets")
    def variable_sets(self) -> Sequence[_builtins.str]:
        """
        Variable sets to use.
        """
        return pulumi.get(self, "variable_sets")


class AwaitableGetWorkspaceResult(GetWorkspaceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetWorkspaceResult(
            connectors=self.connectors,
            cost_estimation_enabled=self.cost_estimation_enabled,
            default_pipelines=self.default_pipelines,
            description=self.description,
            environment_variables=self.environment_variables,
            id=self.id,
            identifier=self.identifier,
            name=self.name,
            org_id=self.org_id,
            project_id=self.project_id,
            provider_connector=self.provider_connector,
            provisioner_type=self.provisioner_type,
            provisioner_version=self.provisioner_version,
            repository=self.repository,
            repository_branch=self.repository_branch,
            repository_commit=self.repository_commit,
            repository_connector=self.repository_connector,
            repository_path=self.repository_path,
            repository_sha=self.repository_sha,
            tags=self.tags,
            terraform_variable_files=self.terraform_variable_files,
            terraform_variables=self.terraform_variables,
            variable_sets=self.variable_sets)


def get_workspace(connectors: Optional[Sequence[Union['GetWorkspaceConnectorArgs', 'GetWorkspaceConnectorArgsDict']]] = None,
                  description: Optional[_builtins.str] = None,
                  environment_variables: Optional[Sequence[Union['GetWorkspaceEnvironmentVariableArgs', 'GetWorkspaceEnvironmentVariableArgsDict']]] = None,
                  identifier: Optional[_builtins.str] = None,
                  org_id: Optional[_builtins.str] = None,
                  project_id: Optional[_builtins.str] = None,
                  repository_branch: Optional[_builtins.str] = None,
                  repository_commit: Optional[_builtins.str] = None,
                  repository_sha: Optional[_builtins.str] = None,
                  tags: Optional[Sequence[_builtins.str]] = None,
                  terraform_variable_files: Optional[Sequence[Union['GetWorkspaceTerraformVariableFileArgs', 'GetWorkspaceTerraformVariableFileArgsDict']]] = None,
                  terraform_variables: Optional[Sequence[Union['GetWorkspaceTerraformVariableArgs', 'GetWorkspaceTerraformVariableArgsDict']]] = None,
                  variable_sets: Optional[Sequence[_builtins.str]] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetWorkspaceResult:
    """
    Data source for retrieving workspaces.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_harness as harness

    test = harness.platform.get_workspace(identifier="identifier",
        org_id="org_id",
        project_id="project_id")
    ```


    :param Sequence[Union['GetWorkspaceConnectorArgs', 'GetWorkspaceConnectorArgsDict']] connectors: Provider connectors configured on the Workspace. Only one connector of a type is supported
    :param _builtins.str description: Description of the Workspace
    :param Sequence[Union['GetWorkspaceEnvironmentVariableArgs', 'GetWorkspaceEnvironmentVariableArgsDict']] environment_variables: Environment variables configured on the workspace
    :param _builtins.str identifier: Identifier of the Workspace
    :param _builtins.str org_id: Organization Identifier
    :param _builtins.str project_id: Project Identifier
    :param _builtins.str repository_branch: Repository Branch in which the code should be accessed
    :param _builtins.str repository_commit: Repository Tag in which the code should be accessed
    :param _builtins.str repository_sha: Repository Commit SHA in which the code should be accessed
    :param Sequence[_builtins.str] tags: Tags to associate with the resource.
    :param Sequence[_builtins.str] variable_sets: Variable sets to use.
    """
    __args__ = dict()
    __args__['connectors'] = connectors
    __args__['description'] = description
    __args__['environmentVariables'] = environment_variables
    __args__['identifier'] = identifier
    __args__['orgId'] = org_id
    __args__['projectId'] = project_id
    __args__['repositoryBranch'] = repository_branch
    __args__['repositoryCommit'] = repository_commit
    __args__['repositorySha'] = repository_sha
    __args__['tags'] = tags
    __args__['terraformVariableFiles'] = terraform_variable_files
    __args__['terraformVariables'] = terraform_variables
    __args__['variableSets'] = variable_sets
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('harness:platform/getWorkspace:getWorkspace', __args__, opts=opts, typ=GetWorkspaceResult).value

    return AwaitableGetWorkspaceResult(
        connectors=pulumi.get(__ret__, 'connectors'),
        cost_estimation_enabled=pulumi.get(__ret__, 'cost_estimation_enabled'),
        default_pipelines=pulumi.get(__ret__, 'default_pipelines'),
        description=pulumi.get(__ret__, 'description'),
        environment_variables=pulumi.get(__ret__, 'environment_variables'),
        id=pulumi.get(__ret__, 'id'),
        identifier=pulumi.get(__ret__, 'identifier'),
        name=pulumi.get(__ret__, 'name'),
        org_id=pulumi.get(__ret__, 'org_id'),
        project_id=pulumi.get(__ret__, 'project_id'),
        provider_connector=pulumi.get(__ret__, 'provider_connector'),
        provisioner_type=pulumi.get(__ret__, 'provisioner_type'),
        provisioner_version=pulumi.get(__ret__, 'provisioner_version'),
        repository=pulumi.get(__ret__, 'repository'),
        repository_branch=pulumi.get(__ret__, 'repository_branch'),
        repository_commit=pulumi.get(__ret__, 'repository_commit'),
        repository_connector=pulumi.get(__ret__, 'repository_connector'),
        repository_path=pulumi.get(__ret__, 'repository_path'),
        repository_sha=pulumi.get(__ret__, 'repository_sha'),
        tags=pulumi.get(__ret__, 'tags'),
        terraform_variable_files=pulumi.get(__ret__, 'terraform_variable_files'),
        terraform_variables=pulumi.get(__ret__, 'terraform_variables'),
        variable_sets=pulumi.get(__ret__, 'variable_sets'))
def get_workspace_output(connectors: Optional[pulumi.Input[Optional[Sequence[Union['GetWorkspaceConnectorArgs', 'GetWorkspaceConnectorArgsDict']]]]] = None,
                         description: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         environment_variables: Optional[pulumi.Input[Optional[Sequence[Union['GetWorkspaceEnvironmentVariableArgs', 'GetWorkspaceEnvironmentVariableArgsDict']]]]] = None,
                         identifier: Optional[pulumi.Input[_builtins.str]] = None,
                         org_id: Optional[pulumi.Input[_builtins.str]] = None,
                         project_id: Optional[pulumi.Input[_builtins.str]] = None,
                         repository_branch: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         repository_commit: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         repository_sha: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         tags: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                         terraform_variable_files: Optional[pulumi.Input[Optional[Sequence[Union['GetWorkspaceTerraformVariableFileArgs', 'GetWorkspaceTerraformVariableFileArgsDict']]]]] = None,
                         terraform_variables: Optional[pulumi.Input[Optional[Sequence[Union['GetWorkspaceTerraformVariableArgs', 'GetWorkspaceTerraformVariableArgsDict']]]]] = None,
                         variable_sets: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetWorkspaceResult]:
    """
    Data source for retrieving workspaces.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_harness as harness

    test = harness.platform.get_workspace(identifier="identifier",
        org_id="org_id",
        project_id="project_id")
    ```


    :param Sequence[Union['GetWorkspaceConnectorArgs', 'GetWorkspaceConnectorArgsDict']] connectors: Provider connectors configured on the Workspace. Only one connector of a type is supported
    :param _builtins.str description: Description of the Workspace
    :param Sequence[Union['GetWorkspaceEnvironmentVariableArgs', 'GetWorkspaceEnvironmentVariableArgsDict']] environment_variables: Environment variables configured on the workspace
    :param _builtins.str identifier: Identifier of the Workspace
    :param _builtins.str org_id: Organization Identifier
    :param _builtins.str project_id: Project Identifier
    :param _builtins.str repository_branch: Repository Branch in which the code should be accessed
    :param _builtins.str repository_commit: Repository Tag in which the code should be accessed
    :param _builtins.str repository_sha: Repository Commit SHA in which the code should be accessed
    :param Sequence[_builtins.str] tags: Tags to associate with the resource.
    :param Sequence[_builtins.str] variable_sets: Variable sets to use.
    """
    __args__ = dict()
    __args__['connectors'] = connectors
    __args__['description'] = description
    __args__['environmentVariables'] = environment_variables
    __args__['identifier'] = identifier
    __args__['orgId'] = org_id
    __args__['projectId'] = project_id
    __args__['repositoryBranch'] = repository_branch
    __args__['repositoryCommit'] = repository_commit
    __args__['repositorySha'] = repository_sha
    __args__['tags'] = tags
    __args__['terraformVariableFiles'] = terraform_variable_files
    __args__['terraformVariables'] = terraform_variables
    __args__['variableSets'] = variable_sets
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('harness:platform/getWorkspace:getWorkspace', __args__, opts=opts, typ=GetWorkspaceResult)
    return __ret__.apply(lambda __response__: GetWorkspaceResult(
        connectors=pulumi.get(__response__, 'connectors'),
        cost_estimation_enabled=pulumi.get(__response__, 'cost_estimation_enabled'),
        default_pipelines=pulumi.get(__response__, 'default_pipelines'),
        description=pulumi.get(__response__, 'description'),
        environment_variables=pulumi.get(__response__, 'environment_variables'),
        id=pulumi.get(__response__, 'id'),
        identifier=pulumi.get(__response__, 'identifier'),
        name=pulumi.get(__response__, 'name'),
        org_id=pulumi.get(__response__, 'org_id'),
        project_id=pulumi.get(__response__, 'project_id'),
        provider_connector=pulumi.get(__response__, 'provider_connector'),
        provisioner_type=pulumi.get(__response__, 'provisioner_type'),
        provisioner_version=pulumi.get(__response__, 'provisioner_version'),
        repository=pulumi.get(__response__, 'repository'),
        repository_branch=pulumi.get(__response__, 'repository_branch'),
        repository_commit=pulumi.get(__response__, 'repository_commit'),
        repository_connector=pulumi.get(__response__, 'repository_connector'),
        repository_path=pulumi.get(__response__, 'repository_path'),
        repository_sha=pulumi.get(__response__, 'repository_sha'),
        tags=pulumi.get(__response__, 'tags'),
        terraform_variable_files=pulumi.get(__response__, 'terraform_variable_files'),
        terraform_variables=pulumi.get(__response__, 'terraform_variables'),
        variable_sets=pulumi.get(__response__, 'variable_sets')))
