# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['TokenArgs', 'Token']

@pulumi.input_type
class TokenArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[_builtins.str],
                 apikey_id: pulumi.Input[_builtins.str],
                 apikey_type: pulumi.Input[_builtins.str],
                 identifier: pulumi.Input[_builtins.str],
                 parent_id: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 email: Optional[pulumi.Input[_builtins.str]] = None,
                 encoded_password: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 scheduled_expire_time: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None,
                 valid: Optional[pulumi.Input[_builtins.bool]] = None,
                 valid_from: Optional[pulumi.Input[_builtins.int]] = None,
                 valid_to: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a Token resource.
        :param pulumi.Input[_builtins.str] account_id: Account Identifier for the Entity
        :param pulumi.Input[_builtins.str] apikey_id: Identifier of the API Key
        :param pulumi.Input[_builtins.str] apikey_type: Type of the API Key
        :param pulumi.Input[_builtins.str] identifier: Unique identifier of the resource.
        :param pulumi.Input[_builtins.str] parent_id: Parent Entity Identifier of the API Key
        :param pulumi.Input[_builtins.str] description: Description of the resource.
        :param pulumi.Input[_builtins.str] email: Email Id of the user who created the Token
        :param pulumi.Input[_builtins.str] encoded_password: Encoded password of the Token
        :param pulumi.Input[_builtins.str] name: Name of the resource.
        :param pulumi.Input[_builtins.str] org_id: Unique identifier of the organization.
        :param pulumi.Input[_builtins.str] project_id: Unique identifier of the project.
        :param pulumi.Input[_builtins.int] scheduled_expire_time: Scheduled expiry time in milliseconds
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags to associate with the resource.
        :param pulumi.Input[_builtins.str] username: Name of the user who created the Token
        :param pulumi.Input[_builtins.bool] valid: Boolean value to indicate if Token is valid or not.
        :param pulumi.Input[_builtins.int] valid_from: This is the time from which the Token is valid. The time is in milliseconds
        :param pulumi.Input[_builtins.int] valid_to: This is the time till which the Token is valid. The time is in milliseconds
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "apikey_id", apikey_id)
        pulumi.set(__self__, "apikey_type", apikey_type)
        pulumi.set(__self__, "identifier", identifier)
        pulumi.set(__self__, "parent_id", parent_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if encoded_password is not None:
            pulumi.set(__self__, "encoded_password", encoded_password)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if scheduled_expire_time is not None:
            pulumi.set(__self__, "scheduled_expire_time", scheduled_expire_time)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if username is not None:
            pulumi.set(__self__, "username", username)
        if valid is not None:
            pulumi.set(__self__, "valid", valid)
        if valid_from is not None:
            pulumi.set(__self__, "valid_from", valid_from)
        if valid_to is not None:
            pulumi.set(__self__, "valid_to", valid_to)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[_builtins.str]:
        """
        Account Identifier for the Entity
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter(name="apikeyId")
    def apikey_id(self) -> pulumi.Input[_builtins.str]:
        """
        Identifier of the API Key
        """
        return pulumi.get(self, "apikey_id")

    @apikey_id.setter
    def apikey_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "apikey_id", value)

    @_builtins.property
    @pulumi.getter(name="apikeyType")
    def apikey_type(self) -> pulumi.Input[_builtins.str]:
        """
        Type of the API Key
        """
        return pulumi.get(self, "apikey_type")

    @apikey_type.setter
    def apikey_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "apikey_type", value)

    @_builtins.property
    @pulumi.getter
    def identifier(self) -> pulumi.Input[_builtins.str]:
        """
        Unique identifier of the resource.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "identifier", value)

    @_builtins.property
    @pulumi.getter(name="parentId")
    def parent_id(self) -> pulumi.Input[_builtins.str]:
        """
        Parent Entity Identifier of the API Key
        """
        return pulumi.get(self, "parent_id")

    @parent_id.setter
    def parent_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "parent_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Email Id of the user who created the Token
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "email", value)

    @_builtins.property
    @pulumi.getter(name="encodedPassword")
    def encoded_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Encoded password of the Token
        """
        return pulumi.get(self, "encoded_password")

    @encoded_password.setter
    def encoded_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "encoded_password", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique identifier of the organization.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "org_id", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique identifier of the project.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="scheduledExpireTime")
    def scheduled_expire_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Scheduled expiry time in milliseconds
        """
        return pulumi.get(self, "scheduled_expire_time")

    @scheduled_expire_time.setter
    def scheduled_expire_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "scheduled_expire_time", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Tags to associate with the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the user who created the Token
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "username", value)

    @_builtins.property
    @pulumi.getter
    def valid(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean value to indicate if Token is valid or not.
        """
        return pulumi.get(self, "valid")

    @valid.setter
    def valid(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "valid", value)

    @_builtins.property
    @pulumi.getter(name="validFrom")
    def valid_from(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        This is the time from which the Token is valid. The time is in milliseconds
        """
        return pulumi.get(self, "valid_from")

    @valid_from.setter
    def valid_from(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "valid_from", value)

    @_builtins.property
    @pulumi.getter(name="validTo")
    def valid_to(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        This is the time till which the Token is valid. The time is in milliseconds
        """
        return pulumi.get(self, "valid_to")

    @valid_to.setter
    def valid_to(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "valid_to", value)


@pulumi.input_type
class _TokenState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 apikey_id: Optional[pulumi.Input[_builtins.str]] = None,
                 apikey_type: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 email: Optional[pulumi.Input[_builtins.str]] = None,
                 encoded_password: Optional[pulumi.Input[_builtins.str]] = None,
                 identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 parent_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 scheduled_expire_time: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None,
                 valid: Optional[pulumi.Input[_builtins.bool]] = None,
                 valid_from: Optional[pulumi.Input[_builtins.int]] = None,
                 valid_to: Optional[pulumi.Input[_builtins.int]] = None,
                 value: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Token resources.
        :param pulumi.Input[_builtins.str] account_id: Account Identifier for the Entity
        :param pulumi.Input[_builtins.str] apikey_id: Identifier of the API Key
        :param pulumi.Input[_builtins.str] apikey_type: Type of the API Key
        :param pulumi.Input[_builtins.str] description: Description of the resource.
        :param pulumi.Input[_builtins.str] email: Email Id of the user who created the Token
        :param pulumi.Input[_builtins.str] encoded_password: Encoded password of the Token
        :param pulumi.Input[_builtins.str] identifier: Unique identifier of the resource.
        :param pulumi.Input[_builtins.str] name: Name of the resource.
        :param pulumi.Input[_builtins.str] org_id: Unique identifier of the organization.
        :param pulumi.Input[_builtins.str] parent_id: Parent Entity Identifier of the API Key
        :param pulumi.Input[_builtins.str] project_id: Unique identifier of the project.
        :param pulumi.Input[_builtins.int] scheduled_expire_time: Scheduled expiry time in milliseconds
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags to associate with the resource.
        :param pulumi.Input[_builtins.str] username: Name of the user who created the Token
        :param pulumi.Input[_builtins.bool] valid: Boolean value to indicate if Token is valid or not.
        :param pulumi.Input[_builtins.int] valid_from: This is the time from which the Token is valid. The time is in milliseconds
        :param pulumi.Input[_builtins.int] valid_to: This is the time till which the Token is valid. The time is in milliseconds
        :param pulumi.Input[_builtins.str] value: Value of the Token
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if apikey_id is not None:
            pulumi.set(__self__, "apikey_id", apikey_id)
        if apikey_type is not None:
            pulumi.set(__self__, "apikey_type", apikey_type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if encoded_password is not None:
            pulumi.set(__self__, "encoded_password", encoded_password)
        if identifier is not None:
            pulumi.set(__self__, "identifier", identifier)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)
        if parent_id is not None:
            pulumi.set(__self__, "parent_id", parent_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if scheduled_expire_time is not None:
            pulumi.set(__self__, "scheduled_expire_time", scheduled_expire_time)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if username is not None:
            pulumi.set(__self__, "username", username)
        if valid is not None:
            pulumi.set(__self__, "valid", valid)
        if valid_from is not None:
            pulumi.set(__self__, "valid_from", valid_from)
        if valid_to is not None:
            pulumi.set(__self__, "valid_to", valid_to)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Account Identifier for the Entity
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter(name="apikeyId")
    def apikey_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier of the API Key
        """
        return pulumi.get(self, "apikey_id")

    @apikey_id.setter
    def apikey_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "apikey_id", value)

    @_builtins.property
    @pulumi.getter(name="apikeyType")
    def apikey_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of the API Key
        """
        return pulumi.get(self, "apikey_type")

    @apikey_type.setter
    def apikey_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "apikey_type", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Email Id of the user who created the Token
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "email", value)

    @_builtins.property
    @pulumi.getter(name="encodedPassword")
    def encoded_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Encoded password of the Token
        """
        return pulumi.get(self, "encoded_password")

    @encoded_password.setter
    def encoded_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "encoded_password", value)

    @_builtins.property
    @pulumi.getter
    def identifier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique identifier of the resource.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "identifier", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique identifier of the organization.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "org_id", value)

    @_builtins.property
    @pulumi.getter(name="parentId")
    def parent_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Parent Entity Identifier of the API Key
        """
        return pulumi.get(self, "parent_id")

    @parent_id.setter
    def parent_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "parent_id", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique identifier of the project.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="scheduledExpireTime")
    def scheduled_expire_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Scheduled expiry time in milliseconds
        """
        return pulumi.get(self, "scheduled_expire_time")

    @scheduled_expire_time.setter
    def scheduled_expire_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "scheduled_expire_time", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Tags to associate with the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the user who created the Token
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "username", value)

    @_builtins.property
    @pulumi.getter
    def valid(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean value to indicate if Token is valid or not.
        """
        return pulumi.get(self, "valid")

    @valid.setter
    def valid(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "valid", value)

    @_builtins.property
    @pulumi.getter(name="validFrom")
    def valid_from(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        This is the time from which the Token is valid. The time is in milliseconds
        """
        return pulumi.get(self, "valid_from")

    @valid_from.setter
    def valid_from(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "valid_from", value)

    @_builtins.property
    @pulumi.getter(name="validTo")
    def valid_to(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        This is the time till which the Token is valid. The time is in milliseconds
        """
        return pulumi.get(self, "valid_to")

    @valid_to.setter
    def valid_to(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "valid_to", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Value of the Token
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "value", value)


@pulumi.type_token("harness:platform/token:Token")
class Token(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 apikey_id: Optional[pulumi.Input[_builtins.str]] = None,
                 apikey_type: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 email: Optional[pulumi.Input[_builtins.str]] = None,
                 encoded_password: Optional[pulumi.Input[_builtins.str]] = None,
                 identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 parent_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 scheduled_expire_time: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None,
                 valid: Optional[pulumi.Input[_builtins.bool]] = None,
                 valid_from: Optional[pulumi.Input[_builtins.int]] = None,
                 valid_to: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Resource for creating tokens.

        ## Import

        The `pulumi import` command can be used, for example:

        Import account level token

        ```sh
        $ pulumi import harness:platform/token:Token harness_platform_token <parent_id>/<apikey_id>/<apikey_type>/<token_id>
        ```

        Import org level token

        ```sh
        $ pulumi import harness:platform/token:Token harness_platform_token <org_id>/<parent_id>/<apikey_id>/<apikey_type>/<token_id>
        ```

        Import project level token

        ```sh
        $ pulumi import harness:platform/token:Token harness_platform_token <org_id>/<project_id>/<parent_id>/<apikey_id>/<apikey_type>/<token_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: Account Identifier for the Entity
        :param pulumi.Input[_builtins.str] apikey_id: Identifier of the API Key
        :param pulumi.Input[_builtins.str] apikey_type: Type of the API Key
        :param pulumi.Input[_builtins.str] description: Description of the resource.
        :param pulumi.Input[_builtins.str] email: Email Id of the user who created the Token
        :param pulumi.Input[_builtins.str] encoded_password: Encoded password of the Token
        :param pulumi.Input[_builtins.str] identifier: Unique identifier of the resource.
        :param pulumi.Input[_builtins.str] name: Name of the resource.
        :param pulumi.Input[_builtins.str] org_id: Unique identifier of the organization.
        :param pulumi.Input[_builtins.str] parent_id: Parent Entity Identifier of the API Key
        :param pulumi.Input[_builtins.str] project_id: Unique identifier of the project.
        :param pulumi.Input[_builtins.int] scheduled_expire_time: Scheduled expiry time in milliseconds
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags to associate with the resource.
        :param pulumi.Input[_builtins.str] username: Name of the user who created the Token
        :param pulumi.Input[_builtins.bool] valid: Boolean value to indicate if Token is valid or not.
        :param pulumi.Input[_builtins.int] valid_from: This is the time from which the Token is valid. The time is in milliseconds
        :param pulumi.Input[_builtins.int] valid_to: This is the time till which the Token is valid. The time is in milliseconds
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TokenArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for creating tokens.

        ## Import

        The `pulumi import` command can be used, for example:

        Import account level token

        ```sh
        $ pulumi import harness:platform/token:Token harness_platform_token <parent_id>/<apikey_id>/<apikey_type>/<token_id>
        ```

        Import org level token

        ```sh
        $ pulumi import harness:platform/token:Token harness_platform_token <org_id>/<parent_id>/<apikey_id>/<apikey_type>/<token_id>
        ```

        Import project level token

        ```sh
        $ pulumi import harness:platform/token:Token harness_platform_token <org_id>/<project_id>/<parent_id>/<apikey_id>/<apikey_type>/<token_id>
        ```

        :param str resource_name: The name of the resource.
        :param TokenArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TokenArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 apikey_id: Optional[pulumi.Input[_builtins.str]] = None,
                 apikey_type: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 email: Optional[pulumi.Input[_builtins.str]] = None,
                 encoded_password: Optional[pulumi.Input[_builtins.str]] = None,
                 identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 parent_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 scheduled_expire_time: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None,
                 valid: Optional[pulumi.Input[_builtins.bool]] = None,
                 valid_from: Optional[pulumi.Input[_builtins.int]] = None,
                 valid_to: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TokenArgs.__new__(TokenArgs)

            if account_id is None and not opts.urn:
                raise TypeError("Missing required property 'account_id'")
            __props__.__dict__["account_id"] = account_id
            if apikey_id is None and not opts.urn:
                raise TypeError("Missing required property 'apikey_id'")
            __props__.__dict__["apikey_id"] = apikey_id
            if apikey_type is None and not opts.urn:
                raise TypeError("Missing required property 'apikey_type'")
            __props__.__dict__["apikey_type"] = apikey_type
            __props__.__dict__["description"] = description
            __props__.__dict__["email"] = email
            __props__.__dict__["encoded_password"] = encoded_password
            if identifier is None and not opts.urn:
                raise TypeError("Missing required property 'identifier'")
            __props__.__dict__["identifier"] = identifier
            __props__.__dict__["name"] = name
            __props__.__dict__["org_id"] = org_id
            if parent_id is None and not opts.urn:
                raise TypeError("Missing required property 'parent_id'")
            __props__.__dict__["parent_id"] = parent_id
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["scheduled_expire_time"] = scheduled_expire_time
            __props__.__dict__["tags"] = tags
            __props__.__dict__["username"] = username
            __props__.__dict__["valid"] = valid
            __props__.__dict__["valid_from"] = valid_from
            __props__.__dict__["valid_to"] = valid_to
            __props__.__dict__["value"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["value"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Token, __self__).__init__(
            'harness:platform/token:Token',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[_builtins.str]] = None,
            apikey_id: Optional[pulumi.Input[_builtins.str]] = None,
            apikey_type: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            email: Optional[pulumi.Input[_builtins.str]] = None,
            encoded_password: Optional[pulumi.Input[_builtins.str]] = None,
            identifier: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            org_id: Optional[pulumi.Input[_builtins.str]] = None,
            parent_id: Optional[pulumi.Input[_builtins.str]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            scheduled_expire_time: Optional[pulumi.Input[_builtins.int]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            username: Optional[pulumi.Input[_builtins.str]] = None,
            valid: Optional[pulumi.Input[_builtins.bool]] = None,
            valid_from: Optional[pulumi.Input[_builtins.int]] = None,
            valid_to: Optional[pulumi.Input[_builtins.int]] = None,
            value: Optional[pulumi.Input[_builtins.str]] = None) -> 'Token':
        """
        Get an existing Token resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: Account Identifier for the Entity
        :param pulumi.Input[_builtins.str] apikey_id: Identifier of the API Key
        :param pulumi.Input[_builtins.str] apikey_type: Type of the API Key
        :param pulumi.Input[_builtins.str] description: Description of the resource.
        :param pulumi.Input[_builtins.str] email: Email Id of the user who created the Token
        :param pulumi.Input[_builtins.str] encoded_password: Encoded password of the Token
        :param pulumi.Input[_builtins.str] identifier: Unique identifier of the resource.
        :param pulumi.Input[_builtins.str] name: Name of the resource.
        :param pulumi.Input[_builtins.str] org_id: Unique identifier of the organization.
        :param pulumi.Input[_builtins.str] parent_id: Parent Entity Identifier of the API Key
        :param pulumi.Input[_builtins.str] project_id: Unique identifier of the project.
        :param pulumi.Input[_builtins.int] scheduled_expire_time: Scheduled expiry time in milliseconds
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags to associate with the resource.
        :param pulumi.Input[_builtins.str] username: Name of the user who created the Token
        :param pulumi.Input[_builtins.bool] valid: Boolean value to indicate if Token is valid or not.
        :param pulumi.Input[_builtins.int] valid_from: This is the time from which the Token is valid. The time is in milliseconds
        :param pulumi.Input[_builtins.int] valid_to: This is the time till which the Token is valid. The time is in milliseconds
        :param pulumi.Input[_builtins.str] value: Value of the Token
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TokenState.__new__(_TokenState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["apikey_id"] = apikey_id
        __props__.__dict__["apikey_type"] = apikey_type
        __props__.__dict__["description"] = description
        __props__.__dict__["email"] = email
        __props__.__dict__["encoded_password"] = encoded_password
        __props__.__dict__["identifier"] = identifier
        __props__.__dict__["name"] = name
        __props__.__dict__["org_id"] = org_id
        __props__.__dict__["parent_id"] = parent_id
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["scheduled_expire_time"] = scheduled_expire_time
        __props__.__dict__["tags"] = tags
        __props__.__dict__["username"] = username
        __props__.__dict__["valid"] = valid
        __props__.__dict__["valid_from"] = valid_from
        __props__.__dict__["valid_to"] = valid_to
        __props__.__dict__["value"] = value
        return Token(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[_builtins.str]:
        """
        Account Identifier for the Entity
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter(name="apikeyId")
    def apikey_id(self) -> pulumi.Output[_builtins.str]:
        """
        Identifier of the API Key
        """
        return pulumi.get(self, "apikey_id")

    @_builtins.property
    @pulumi.getter(name="apikeyType")
    def apikey_type(self) -> pulumi.Output[_builtins.str]:
        """
        Type of the API Key
        """
        return pulumi.get(self, "apikey_type")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Description of the resource.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def email(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Email Id of the user who created the Token
        """
        return pulumi.get(self, "email")

    @_builtins.property
    @pulumi.getter(name="encodedPassword")
    def encoded_password(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Encoded password of the Token
        """
        return pulumi.get(self, "encoded_password")

    @_builtins.property
    @pulumi.getter
    def identifier(self) -> pulumi.Output[_builtins.str]:
        """
        Unique identifier of the resource.
        """
        return pulumi.get(self, "identifier")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the resource.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Unique identifier of the organization.
        """
        return pulumi.get(self, "org_id")

    @_builtins.property
    @pulumi.getter(name="parentId")
    def parent_id(self) -> pulumi.Output[_builtins.str]:
        """
        Parent Entity Identifier of the API Key
        """
        return pulumi.get(self, "parent_id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Unique identifier of the project.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="scheduledExpireTime")
    def scheduled_expire_time(self) -> pulumi.Output[_builtins.int]:
        """
        Scheduled expiry time in milliseconds
        """
        return pulumi.get(self, "scheduled_expire_time")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Tags to associate with the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def username(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Name of the user who created the Token
        """
        return pulumi.get(self, "username")

    @_builtins.property
    @pulumi.getter
    def valid(self) -> pulumi.Output[_builtins.bool]:
        """
        Boolean value to indicate if Token is valid or not.
        """
        return pulumi.get(self, "valid")

    @_builtins.property
    @pulumi.getter(name="validFrom")
    def valid_from(self) -> pulumi.Output[_builtins.int]:
        """
        This is the time from which the Token is valid. The time is in milliseconds
        """
        return pulumi.get(self, "valid_from")

    @_builtins.property
    @pulumi.getter(name="validTo")
    def valid_to(self) -> pulumi.Output[_builtins.int]:
        """
        This is the time till which the Token is valid. The time is in milliseconds
        """
        return pulumi.get(self, "valid_to")

    @_builtins.property
    @pulumi.getter
    def value(self) -> pulumi.Output[_builtins.str]:
        """
        Value of the Token
        """
        return pulumi.get(self, "value")

