# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['WorkspaceArgs', 'Workspace']

@pulumi.input_type
class WorkspaceArgs:
    def __init__(__self__, *,
                 cost_estimation_enabled: pulumi.Input[_builtins.bool],
                 identifier: pulumi.Input[_builtins.str],
                 org_id: pulumi.Input[_builtins.str],
                 project_id: pulumi.Input[_builtins.str],
                 provisioner_type: pulumi.Input[_builtins.str],
                 provisioner_version: pulumi.Input[_builtins.str],
                 repository: pulumi.Input[_builtins.str],
                 repository_connector: pulumi.Input[_builtins.str],
                 repository_path: pulumi.Input[_builtins.str],
                 connectors: Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceConnectorArgs']]]] = None,
                 default_pipelines: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 environment_variables: Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceEnvironmentVariableArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 provider_connector: Optional[pulumi.Input[_builtins.str]] = None,
                 repository_branch: Optional[pulumi.Input[_builtins.str]] = None,
                 repository_commit: Optional[pulumi.Input[_builtins.str]] = None,
                 repository_sha: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 terraform_variable_files: Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceTerraformVariableFileArgs']]]] = None,
                 terraform_variables: Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceTerraformVariableArgs']]]] = None,
                 variable_sets: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a Workspace resource.
        :param pulumi.Input[_builtins.bool] cost_estimation_enabled: Cost estimation enabled determines if cost estimation operations are performed.
        :param pulumi.Input[_builtins.str] identifier: Unique identifier of the resource.
        :param pulumi.Input[_builtins.str] org_id: Unique identifier of the organization.
        :param pulumi.Input[_builtins.str] project_id: Unique identifier of the project.
        :param pulumi.Input[_builtins.str] repository: Repository is the name of the repository to fetch the code from.
        :param pulumi.Input[_builtins.str] repository_connector: Repository connector is the reference to the connector used to fetch the code.
        :param pulumi.Input[_builtins.str] repository_path: Repository path is the path in which the code resides.
        :param pulumi.Input[Sequence[pulumi.Input['WorkspaceConnectorArgs']]] connectors: Provider connectors configured on the Workspace. Only one connector of a type is supported
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] default_pipelines: Default pipelines associated with this workspace
        :param pulumi.Input[_builtins.str] description: Description of the resource.
        :param pulumi.Input[Sequence[pulumi.Input['WorkspaceEnvironmentVariableArgs']]] environment_variables: Environment variables configured on the workspace
        :param pulumi.Input[_builtins.str] name: Name of the resource.
        :param pulumi.Input[_builtins.str] provider_connector: Provider connector is the reference to the connector for the infrastructure provider
        :param pulumi.Input[_builtins.str] repository_branch: Repository branch is the name of the branch to fetch the code from. This cannot be set if repository commit or sha is set.
        :param pulumi.Input[_builtins.str] repository_commit: Repository commit is tag to fetch the code from. This cannot be set if repository branch or sha is set.
        :param pulumi.Input[_builtins.str] repository_sha: Repository commit is commit SHA to fetch the code from. This cannot be set if repository branch or commit is set.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags to associate with the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] variable_sets: Variable sets to use.
        """
        pulumi.set(__self__, "cost_estimation_enabled", cost_estimation_enabled)
        pulumi.set(__self__, "identifier", identifier)
        pulumi.set(__self__, "org_id", org_id)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "provisioner_type", provisioner_type)
        pulumi.set(__self__, "provisioner_version", provisioner_version)
        pulumi.set(__self__, "repository", repository)
        pulumi.set(__self__, "repository_connector", repository_connector)
        pulumi.set(__self__, "repository_path", repository_path)
        if connectors is not None:
            pulumi.set(__self__, "connectors", connectors)
        if default_pipelines is not None:
            pulumi.set(__self__, "default_pipelines", default_pipelines)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if environment_variables is not None:
            pulumi.set(__self__, "environment_variables", environment_variables)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if provider_connector is not None:
            pulumi.set(__self__, "provider_connector", provider_connector)
        if repository_branch is not None:
            pulumi.set(__self__, "repository_branch", repository_branch)
        if repository_commit is not None:
            pulumi.set(__self__, "repository_commit", repository_commit)
        if repository_sha is not None:
            pulumi.set(__self__, "repository_sha", repository_sha)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if terraform_variable_files is not None:
            pulumi.set(__self__, "terraform_variable_files", terraform_variable_files)
        if terraform_variables is not None:
            pulumi.set(__self__, "terraform_variables", terraform_variables)
        if variable_sets is not None:
            pulumi.set(__self__, "variable_sets", variable_sets)

    @_builtins.property
    @pulumi.getter(name="costEstimationEnabled")
    def cost_estimation_enabled(self) -> pulumi.Input[_builtins.bool]:
        """
        Cost estimation enabled determines if cost estimation operations are performed.
        """
        return pulumi.get(self, "cost_estimation_enabled")

    @cost_estimation_enabled.setter
    def cost_estimation_enabled(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "cost_estimation_enabled", value)

    @_builtins.property
    @pulumi.getter
    def identifier(self) -> pulumi.Input[_builtins.str]:
        """
        Unique identifier of the resource.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "identifier", value)

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Input[_builtins.str]:
        """
        Unique identifier of the organization.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "org_id", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[_builtins.str]:
        """
        Unique identifier of the project.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="provisionerType")
    def provisioner_type(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "provisioner_type")

    @provisioner_type.setter
    def provisioner_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "provisioner_type", value)

    @_builtins.property
    @pulumi.getter(name="provisionerVersion")
    def provisioner_version(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "provisioner_version")

    @provisioner_version.setter
    def provisioner_version(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "provisioner_version", value)

    @_builtins.property
    @pulumi.getter
    def repository(self) -> pulumi.Input[_builtins.str]:
        """
        Repository is the name of the repository to fetch the code from.
        """
        return pulumi.get(self, "repository")

    @repository.setter
    def repository(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "repository", value)

    @_builtins.property
    @pulumi.getter(name="repositoryConnector")
    def repository_connector(self) -> pulumi.Input[_builtins.str]:
        """
        Repository connector is the reference to the connector used to fetch the code.
        """
        return pulumi.get(self, "repository_connector")

    @repository_connector.setter
    def repository_connector(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "repository_connector", value)

    @_builtins.property
    @pulumi.getter(name="repositoryPath")
    def repository_path(self) -> pulumi.Input[_builtins.str]:
        """
        Repository path is the path in which the code resides.
        """
        return pulumi.get(self, "repository_path")

    @repository_path.setter
    def repository_path(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "repository_path", value)

    @_builtins.property
    @pulumi.getter
    def connectors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceConnectorArgs']]]]:
        """
        Provider connectors configured on the Workspace. Only one connector of a type is supported
        """
        return pulumi.get(self, "connectors")

    @connectors.setter
    def connectors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceConnectorArgs']]]]):
        pulumi.set(self, "connectors", value)

    @_builtins.property
    @pulumi.getter(name="defaultPipelines")
    def default_pipelines(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Default pipelines associated with this workspace
        """
        return pulumi.get(self, "default_pipelines")

    @default_pipelines.setter
    def default_pipelines(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "default_pipelines", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceEnvironmentVariableArgs']]]]:
        """
        Environment variables configured on the workspace
        """
        return pulumi.get(self, "environment_variables")

    @environment_variables.setter
    def environment_variables(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceEnvironmentVariableArgs']]]]):
        pulumi.set(self, "environment_variables", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="providerConnector")
    def provider_connector(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Provider connector is the reference to the connector for the infrastructure provider
        """
        return pulumi.get(self, "provider_connector")

    @provider_connector.setter
    def provider_connector(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "provider_connector", value)

    @_builtins.property
    @pulumi.getter(name="repositoryBranch")
    def repository_branch(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Repository branch is the name of the branch to fetch the code from. This cannot be set if repository commit or sha is set.
        """
        return pulumi.get(self, "repository_branch")

    @repository_branch.setter
    def repository_branch(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "repository_branch", value)

    @_builtins.property
    @pulumi.getter(name="repositoryCommit")
    def repository_commit(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Repository commit is tag to fetch the code from. This cannot be set if repository branch or sha is set.
        """
        return pulumi.get(self, "repository_commit")

    @repository_commit.setter
    def repository_commit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "repository_commit", value)

    @_builtins.property
    @pulumi.getter(name="repositorySha")
    def repository_sha(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Repository commit is commit SHA to fetch the code from. This cannot be set if repository branch or commit is set.
        """
        return pulumi.get(self, "repository_sha")

    @repository_sha.setter
    def repository_sha(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "repository_sha", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Tags to associate with the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="terraformVariableFiles")
    def terraform_variable_files(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceTerraformVariableFileArgs']]]]:
        return pulumi.get(self, "terraform_variable_files")

    @terraform_variable_files.setter
    def terraform_variable_files(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceTerraformVariableFileArgs']]]]):
        pulumi.set(self, "terraform_variable_files", value)

    @_builtins.property
    @pulumi.getter(name="terraformVariables")
    def terraform_variables(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceTerraformVariableArgs']]]]:
        return pulumi.get(self, "terraform_variables")

    @terraform_variables.setter
    def terraform_variables(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceTerraformVariableArgs']]]]):
        pulumi.set(self, "terraform_variables", value)

    @_builtins.property
    @pulumi.getter(name="variableSets")
    def variable_sets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Variable sets to use.
        """
        return pulumi.get(self, "variable_sets")

    @variable_sets.setter
    def variable_sets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "variable_sets", value)


@pulumi.input_type
class _WorkspaceState:
    def __init__(__self__, *,
                 connectors: Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceConnectorArgs']]]] = None,
                 cost_estimation_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 default_pipelines: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 environment_variables: Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceEnvironmentVariableArgs']]]] = None,
                 identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 provider_connector: Optional[pulumi.Input[_builtins.str]] = None,
                 provisioner_type: Optional[pulumi.Input[_builtins.str]] = None,
                 provisioner_version: Optional[pulumi.Input[_builtins.str]] = None,
                 repository: Optional[pulumi.Input[_builtins.str]] = None,
                 repository_branch: Optional[pulumi.Input[_builtins.str]] = None,
                 repository_commit: Optional[pulumi.Input[_builtins.str]] = None,
                 repository_connector: Optional[pulumi.Input[_builtins.str]] = None,
                 repository_path: Optional[pulumi.Input[_builtins.str]] = None,
                 repository_sha: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 terraform_variable_files: Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceTerraformVariableFileArgs']]]] = None,
                 terraform_variables: Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceTerraformVariableArgs']]]] = None,
                 variable_sets: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering Workspace resources.
        :param pulumi.Input[Sequence[pulumi.Input['WorkspaceConnectorArgs']]] connectors: Provider connectors configured on the Workspace. Only one connector of a type is supported
        :param pulumi.Input[_builtins.bool] cost_estimation_enabled: Cost estimation enabled determines if cost estimation operations are performed.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] default_pipelines: Default pipelines associated with this workspace
        :param pulumi.Input[_builtins.str] description: Description of the resource.
        :param pulumi.Input[Sequence[pulumi.Input['WorkspaceEnvironmentVariableArgs']]] environment_variables: Environment variables configured on the workspace
        :param pulumi.Input[_builtins.str] identifier: Unique identifier of the resource.
        :param pulumi.Input[_builtins.str] name: Name of the resource.
        :param pulumi.Input[_builtins.str] org_id: Unique identifier of the organization.
        :param pulumi.Input[_builtins.str] project_id: Unique identifier of the project.
        :param pulumi.Input[_builtins.str] provider_connector: Provider connector is the reference to the connector for the infrastructure provider
        :param pulumi.Input[_builtins.str] repository: Repository is the name of the repository to fetch the code from.
        :param pulumi.Input[_builtins.str] repository_branch: Repository branch is the name of the branch to fetch the code from. This cannot be set if repository commit or sha is set.
        :param pulumi.Input[_builtins.str] repository_commit: Repository commit is tag to fetch the code from. This cannot be set if repository branch or sha is set.
        :param pulumi.Input[_builtins.str] repository_connector: Repository connector is the reference to the connector used to fetch the code.
        :param pulumi.Input[_builtins.str] repository_path: Repository path is the path in which the code resides.
        :param pulumi.Input[_builtins.str] repository_sha: Repository commit is commit SHA to fetch the code from. This cannot be set if repository branch or commit is set.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags to associate with the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] variable_sets: Variable sets to use.
        """
        if connectors is not None:
            pulumi.set(__self__, "connectors", connectors)
        if cost_estimation_enabled is not None:
            pulumi.set(__self__, "cost_estimation_enabled", cost_estimation_enabled)
        if default_pipelines is not None:
            pulumi.set(__self__, "default_pipelines", default_pipelines)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if environment_variables is not None:
            pulumi.set(__self__, "environment_variables", environment_variables)
        if identifier is not None:
            pulumi.set(__self__, "identifier", identifier)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if provider_connector is not None:
            pulumi.set(__self__, "provider_connector", provider_connector)
        if provisioner_type is not None:
            pulumi.set(__self__, "provisioner_type", provisioner_type)
        if provisioner_version is not None:
            pulumi.set(__self__, "provisioner_version", provisioner_version)
        if repository is not None:
            pulumi.set(__self__, "repository", repository)
        if repository_branch is not None:
            pulumi.set(__self__, "repository_branch", repository_branch)
        if repository_commit is not None:
            pulumi.set(__self__, "repository_commit", repository_commit)
        if repository_connector is not None:
            pulumi.set(__self__, "repository_connector", repository_connector)
        if repository_path is not None:
            pulumi.set(__self__, "repository_path", repository_path)
        if repository_sha is not None:
            pulumi.set(__self__, "repository_sha", repository_sha)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if terraform_variable_files is not None:
            pulumi.set(__self__, "terraform_variable_files", terraform_variable_files)
        if terraform_variables is not None:
            pulumi.set(__self__, "terraform_variables", terraform_variables)
        if variable_sets is not None:
            pulumi.set(__self__, "variable_sets", variable_sets)

    @_builtins.property
    @pulumi.getter
    def connectors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceConnectorArgs']]]]:
        """
        Provider connectors configured on the Workspace. Only one connector of a type is supported
        """
        return pulumi.get(self, "connectors")

    @connectors.setter
    def connectors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceConnectorArgs']]]]):
        pulumi.set(self, "connectors", value)

    @_builtins.property
    @pulumi.getter(name="costEstimationEnabled")
    def cost_estimation_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Cost estimation enabled determines if cost estimation operations are performed.
        """
        return pulumi.get(self, "cost_estimation_enabled")

    @cost_estimation_enabled.setter
    def cost_estimation_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "cost_estimation_enabled", value)

    @_builtins.property
    @pulumi.getter(name="defaultPipelines")
    def default_pipelines(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Default pipelines associated with this workspace
        """
        return pulumi.get(self, "default_pipelines")

    @default_pipelines.setter
    def default_pipelines(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "default_pipelines", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceEnvironmentVariableArgs']]]]:
        """
        Environment variables configured on the workspace
        """
        return pulumi.get(self, "environment_variables")

    @environment_variables.setter
    def environment_variables(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceEnvironmentVariableArgs']]]]):
        pulumi.set(self, "environment_variables", value)

    @_builtins.property
    @pulumi.getter
    def identifier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique identifier of the resource.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "identifier", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique identifier of the organization.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "org_id", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique identifier of the project.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="providerConnector")
    def provider_connector(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Provider connector is the reference to the connector for the infrastructure provider
        """
        return pulumi.get(self, "provider_connector")

    @provider_connector.setter
    def provider_connector(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "provider_connector", value)

    @_builtins.property
    @pulumi.getter(name="provisionerType")
    def provisioner_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "provisioner_type")

    @provisioner_type.setter
    def provisioner_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "provisioner_type", value)

    @_builtins.property
    @pulumi.getter(name="provisionerVersion")
    def provisioner_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "provisioner_version")

    @provisioner_version.setter
    def provisioner_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "provisioner_version", value)

    @_builtins.property
    @pulumi.getter
    def repository(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Repository is the name of the repository to fetch the code from.
        """
        return pulumi.get(self, "repository")

    @repository.setter
    def repository(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "repository", value)

    @_builtins.property
    @pulumi.getter(name="repositoryBranch")
    def repository_branch(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Repository branch is the name of the branch to fetch the code from. This cannot be set if repository commit or sha is set.
        """
        return pulumi.get(self, "repository_branch")

    @repository_branch.setter
    def repository_branch(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "repository_branch", value)

    @_builtins.property
    @pulumi.getter(name="repositoryCommit")
    def repository_commit(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Repository commit is tag to fetch the code from. This cannot be set if repository branch or sha is set.
        """
        return pulumi.get(self, "repository_commit")

    @repository_commit.setter
    def repository_commit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "repository_commit", value)

    @_builtins.property
    @pulumi.getter(name="repositoryConnector")
    def repository_connector(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Repository connector is the reference to the connector used to fetch the code.
        """
        return pulumi.get(self, "repository_connector")

    @repository_connector.setter
    def repository_connector(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "repository_connector", value)

    @_builtins.property
    @pulumi.getter(name="repositoryPath")
    def repository_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Repository path is the path in which the code resides.
        """
        return pulumi.get(self, "repository_path")

    @repository_path.setter
    def repository_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "repository_path", value)

    @_builtins.property
    @pulumi.getter(name="repositorySha")
    def repository_sha(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Repository commit is commit SHA to fetch the code from. This cannot be set if repository branch or commit is set.
        """
        return pulumi.get(self, "repository_sha")

    @repository_sha.setter
    def repository_sha(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "repository_sha", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Tags to associate with the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="terraformVariableFiles")
    def terraform_variable_files(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceTerraformVariableFileArgs']]]]:
        return pulumi.get(self, "terraform_variable_files")

    @terraform_variable_files.setter
    def terraform_variable_files(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceTerraformVariableFileArgs']]]]):
        pulumi.set(self, "terraform_variable_files", value)

    @_builtins.property
    @pulumi.getter(name="terraformVariables")
    def terraform_variables(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceTerraformVariableArgs']]]]:
        return pulumi.get(self, "terraform_variables")

    @terraform_variables.setter
    def terraform_variables(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceTerraformVariableArgs']]]]):
        pulumi.set(self, "terraform_variables", value)

    @_builtins.property
    @pulumi.getter(name="variableSets")
    def variable_sets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Variable sets to use.
        """
        return pulumi.get(self, "variable_sets")

    @variable_sets.setter
    def variable_sets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "variable_sets", value)


@pulumi.type_token("harness:platform/workspace:Workspace")
class Workspace(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 connectors: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkspaceConnectorArgs', 'WorkspaceConnectorArgsDict']]]]] = None,
                 cost_estimation_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 default_pipelines: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 environment_variables: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkspaceEnvironmentVariableArgs', 'WorkspaceEnvironmentVariableArgsDict']]]]] = None,
                 identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 provider_connector: Optional[pulumi.Input[_builtins.str]] = None,
                 provisioner_type: Optional[pulumi.Input[_builtins.str]] = None,
                 provisioner_version: Optional[pulumi.Input[_builtins.str]] = None,
                 repository: Optional[pulumi.Input[_builtins.str]] = None,
                 repository_branch: Optional[pulumi.Input[_builtins.str]] = None,
                 repository_commit: Optional[pulumi.Input[_builtins.str]] = None,
                 repository_connector: Optional[pulumi.Input[_builtins.str]] = None,
                 repository_path: Optional[pulumi.Input[_builtins.str]] = None,
                 repository_sha: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 terraform_variable_files: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkspaceTerraformVariableFileArgs', 'WorkspaceTerraformVariableFileArgsDict']]]]] = None,
                 terraform_variables: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkspaceTerraformVariableArgs', 'WorkspaceTerraformVariableArgsDict']]]]] = None,
                 variable_sets: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Resource for managing Workspaces

        ## Example Usage

        ```python
        import pulumi
        import pulumi_harness as harness

        example = harness.platform.Workspace("example",
            name="example",
            identifier="example",
            org_id=test_harness_platform_organization["id"],
            project_id=test_harness_platform_project["id"],
            provisioner_type="terraform",
            provisioner_version="1.5.6",
            repository="https://github.com/org/repo",
            repository_branch="main",
            repository_path="tf/aws/basic",
            cost_estimation_enabled=True,
            provider_connector=test["id"],
            repository_connector=test["id"],
            tags=[
                "tag1",
                "tag2",
            ],
            terraform_variables=[
                {
                    "key": "key1",
                    "value": "val1",
                    "value_type": "string",
                },
                {
                    "key": "key2",
                    "value": "val2",
                    "value_type": "string",
                },
            ],
            environment_variables=[
                {
                    "key": "key1",
                    "value": "val1",
                    "value_type": "string",
                },
                {
                    "key": "key2",
                    "value": "val2",
                    "value_type": "string",
                },
            ],
            terraform_variable_files=[
                {
                    "repository": "https://github.com/org/repo",
                    "repository_branch": "main",
                    "repository_path": "tf/gcp/basic",
                    "repository_connector": test["id"],
                },
                {
                    "repository": "https://github.com/org/repo",
                    "repository_commit": "v1.0.0",
                    "repository_path": "tf/aws/basic",
                    "repository_connector": test["id"],
                },
                {
                    "repository": "https://github.com/org/repo",
                    "repository_sha": "349d90bb9c90f4a3482981c259080de31609e6f6",
                    "repository_path": "tf/aws/basic",
                    "repository_connector": test["id"],
                },
            ],
            variable_sets=[test_harness_platform_infra_variable_set["id"]],
            default_pipelines={
                "destroy": "destroy_pipeline_id",
                "drift": "drift_pipeline_id",
                "plan": "plan_pipeline_id",
                "apply": "apply_pipeline_id",
            })
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import harness:platform/workspace:Workspace example <org_id>/<project_id>/<workspace_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WorkspaceConnectorArgs', 'WorkspaceConnectorArgsDict']]]] connectors: Provider connectors configured on the Workspace. Only one connector of a type is supported
        :param pulumi.Input[_builtins.bool] cost_estimation_enabled: Cost estimation enabled determines if cost estimation operations are performed.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] default_pipelines: Default pipelines associated with this workspace
        :param pulumi.Input[_builtins.str] description: Description of the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WorkspaceEnvironmentVariableArgs', 'WorkspaceEnvironmentVariableArgsDict']]]] environment_variables: Environment variables configured on the workspace
        :param pulumi.Input[_builtins.str] identifier: Unique identifier of the resource.
        :param pulumi.Input[_builtins.str] name: Name of the resource.
        :param pulumi.Input[_builtins.str] org_id: Unique identifier of the organization.
        :param pulumi.Input[_builtins.str] project_id: Unique identifier of the project.
        :param pulumi.Input[_builtins.str] provider_connector: Provider connector is the reference to the connector for the infrastructure provider
        :param pulumi.Input[_builtins.str] repository: Repository is the name of the repository to fetch the code from.
        :param pulumi.Input[_builtins.str] repository_branch: Repository branch is the name of the branch to fetch the code from. This cannot be set if repository commit or sha is set.
        :param pulumi.Input[_builtins.str] repository_commit: Repository commit is tag to fetch the code from. This cannot be set if repository branch or sha is set.
        :param pulumi.Input[_builtins.str] repository_connector: Repository connector is the reference to the connector used to fetch the code.
        :param pulumi.Input[_builtins.str] repository_path: Repository path is the path in which the code resides.
        :param pulumi.Input[_builtins.str] repository_sha: Repository commit is commit SHA to fetch the code from. This cannot be set if repository branch or commit is set.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags to associate with the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] variable_sets: Variable sets to use.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WorkspaceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing Workspaces

        ## Example Usage

        ```python
        import pulumi
        import pulumi_harness as harness

        example = harness.platform.Workspace("example",
            name="example",
            identifier="example",
            org_id=test_harness_platform_organization["id"],
            project_id=test_harness_platform_project["id"],
            provisioner_type="terraform",
            provisioner_version="1.5.6",
            repository="https://github.com/org/repo",
            repository_branch="main",
            repository_path="tf/aws/basic",
            cost_estimation_enabled=True,
            provider_connector=test["id"],
            repository_connector=test["id"],
            tags=[
                "tag1",
                "tag2",
            ],
            terraform_variables=[
                {
                    "key": "key1",
                    "value": "val1",
                    "value_type": "string",
                },
                {
                    "key": "key2",
                    "value": "val2",
                    "value_type": "string",
                },
            ],
            environment_variables=[
                {
                    "key": "key1",
                    "value": "val1",
                    "value_type": "string",
                },
                {
                    "key": "key2",
                    "value": "val2",
                    "value_type": "string",
                },
            ],
            terraform_variable_files=[
                {
                    "repository": "https://github.com/org/repo",
                    "repository_branch": "main",
                    "repository_path": "tf/gcp/basic",
                    "repository_connector": test["id"],
                },
                {
                    "repository": "https://github.com/org/repo",
                    "repository_commit": "v1.0.0",
                    "repository_path": "tf/aws/basic",
                    "repository_connector": test["id"],
                },
                {
                    "repository": "https://github.com/org/repo",
                    "repository_sha": "349d90bb9c90f4a3482981c259080de31609e6f6",
                    "repository_path": "tf/aws/basic",
                    "repository_connector": test["id"],
                },
            ],
            variable_sets=[test_harness_platform_infra_variable_set["id"]],
            default_pipelines={
                "destroy": "destroy_pipeline_id",
                "drift": "drift_pipeline_id",
                "plan": "plan_pipeline_id",
                "apply": "apply_pipeline_id",
            })
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import harness:platform/workspace:Workspace example <org_id>/<project_id>/<workspace_id>
        ```

        :param str resource_name: The name of the resource.
        :param WorkspaceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WorkspaceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 connectors: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkspaceConnectorArgs', 'WorkspaceConnectorArgsDict']]]]] = None,
                 cost_estimation_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 default_pipelines: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 environment_variables: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkspaceEnvironmentVariableArgs', 'WorkspaceEnvironmentVariableArgsDict']]]]] = None,
                 identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 provider_connector: Optional[pulumi.Input[_builtins.str]] = None,
                 provisioner_type: Optional[pulumi.Input[_builtins.str]] = None,
                 provisioner_version: Optional[pulumi.Input[_builtins.str]] = None,
                 repository: Optional[pulumi.Input[_builtins.str]] = None,
                 repository_branch: Optional[pulumi.Input[_builtins.str]] = None,
                 repository_commit: Optional[pulumi.Input[_builtins.str]] = None,
                 repository_connector: Optional[pulumi.Input[_builtins.str]] = None,
                 repository_path: Optional[pulumi.Input[_builtins.str]] = None,
                 repository_sha: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 terraform_variable_files: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkspaceTerraformVariableFileArgs', 'WorkspaceTerraformVariableFileArgsDict']]]]] = None,
                 terraform_variables: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkspaceTerraformVariableArgs', 'WorkspaceTerraformVariableArgsDict']]]]] = None,
                 variable_sets: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WorkspaceArgs.__new__(WorkspaceArgs)

            __props__.__dict__["connectors"] = connectors
            if cost_estimation_enabled is None and not opts.urn:
                raise TypeError("Missing required property 'cost_estimation_enabled'")
            __props__.__dict__["cost_estimation_enabled"] = cost_estimation_enabled
            __props__.__dict__["default_pipelines"] = default_pipelines
            __props__.__dict__["description"] = description
            __props__.__dict__["environment_variables"] = environment_variables
            if identifier is None and not opts.urn:
                raise TypeError("Missing required property 'identifier'")
            __props__.__dict__["identifier"] = identifier
            __props__.__dict__["name"] = name
            if org_id is None and not opts.urn:
                raise TypeError("Missing required property 'org_id'")
            __props__.__dict__["org_id"] = org_id
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["provider_connector"] = provider_connector
            if provisioner_type is None and not opts.urn:
                raise TypeError("Missing required property 'provisioner_type'")
            __props__.__dict__["provisioner_type"] = provisioner_type
            if provisioner_version is None and not opts.urn:
                raise TypeError("Missing required property 'provisioner_version'")
            __props__.__dict__["provisioner_version"] = provisioner_version
            if repository is None and not opts.urn:
                raise TypeError("Missing required property 'repository'")
            __props__.__dict__["repository"] = repository
            __props__.__dict__["repository_branch"] = repository_branch
            __props__.__dict__["repository_commit"] = repository_commit
            if repository_connector is None and not opts.urn:
                raise TypeError("Missing required property 'repository_connector'")
            __props__.__dict__["repository_connector"] = repository_connector
            if repository_path is None and not opts.urn:
                raise TypeError("Missing required property 'repository_path'")
            __props__.__dict__["repository_path"] = repository_path
            __props__.__dict__["repository_sha"] = repository_sha
            __props__.__dict__["tags"] = tags
            __props__.__dict__["terraform_variable_files"] = terraform_variable_files
            __props__.__dict__["terraform_variables"] = terraform_variables
            __props__.__dict__["variable_sets"] = variable_sets
        super(Workspace, __self__).__init__(
            'harness:platform/workspace:Workspace',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            connectors: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkspaceConnectorArgs', 'WorkspaceConnectorArgsDict']]]]] = None,
            cost_estimation_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            default_pipelines: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            environment_variables: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkspaceEnvironmentVariableArgs', 'WorkspaceEnvironmentVariableArgsDict']]]]] = None,
            identifier: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            org_id: Optional[pulumi.Input[_builtins.str]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            provider_connector: Optional[pulumi.Input[_builtins.str]] = None,
            provisioner_type: Optional[pulumi.Input[_builtins.str]] = None,
            provisioner_version: Optional[pulumi.Input[_builtins.str]] = None,
            repository: Optional[pulumi.Input[_builtins.str]] = None,
            repository_branch: Optional[pulumi.Input[_builtins.str]] = None,
            repository_commit: Optional[pulumi.Input[_builtins.str]] = None,
            repository_connector: Optional[pulumi.Input[_builtins.str]] = None,
            repository_path: Optional[pulumi.Input[_builtins.str]] = None,
            repository_sha: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            terraform_variable_files: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkspaceTerraformVariableFileArgs', 'WorkspaceTerraformVariableFileArgsDict']]]]] = None,
            terraform_variables: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkspaceTerraformVariableArgs', 'WorkspaceTerraformVariableArgsDict']]]]] = None,
            variable_sets: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'Workspace':
        """
        Get an existing Workspace resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WorkspaceConnectorArgs', 'WorkspaceConnectorArgsDict']]]] connectors: Provider connectors configured on the Workspace. Only one connector of a type is supported
        :param pulumi.Input[_builtins.bool] cost_estimation_enabled: Cost estimation enabled determines if cost estimation operations are performed.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] default_pipelines: Default pipelines associated with this workspace
        :param pulumi.Input[_builtins.str] description: Description of the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WorkspaceEnvironmentVariableArgs', 'WorkspaceEnvironmentVariableArgsDict']]]] environment_variables: Environment variables configured on the workspace
        :param pulumi.Input[_builtins.str] identifier: Unique identifier of the resource.
        :param pulumi.Input[_builtins.str] name: Name of the resource.
        :param pulumi.Input[_builtins.str] org_id: Unique identifier of the organization.
        :param pulumi.Input[_builtins.str] project_id: Unique identifier of the project.
        :param pulumi.Input[_builtins.str] provider_connector: Provider connector is the reference to the connector for the infrastructure provider
        :param pulumi.Input[_builtins.str] repository: Repository is the name of the repository to fetch the code from.
        :param pulumi.Input[_builtins.str] repository_branch: Repository branch is the name of the branch to fetch the code from. This cannot be set if repository commit or sha is set.
        :param pulumi.Input[_builtins.str] repository_commit: Repository commit is tag to fetch the code from. This cannot be set if repository branch or sha is set.
        :param pulumi.Input[_builtins.str] repository_connector: Repository connector is the reference to the connector used to fetch the code.
        :param pulumi.Input[_builtins.str] repository_path: Repository path is the path in which the code resides.
        :param pulumi.Input[_builtins.str] repository_sha: Repository commit is commit SHA to fetch the code from. This cannot be set if repository branch or commit is set.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags to associate with the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] variable_sets: Variable sets to use.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WorkspaceState.__new__(_WorkspaceState)

        __props__.__dict__["connectors"] = connectors
        __props__.__dict__["cost_estimation_enabled"] = cost_estimation_enabled
        __props__.__dict__["default_pipelines"] = default_pipelines
        __props__.__dict__["description"] = description
        __props__.__dict__["environment_variables"] = environment_variables
        __props__.__dict__["identifier"] = identifier
        __props__.__dict__["name"] = name
        __props__.__dict__["org_id"] = org_id
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["provider_connector"] = provider_connector
        __props__.__dict__["provisioner_type"] = provisioner_type
        __props__.__dict__["provisioner_version"] = provisioner_version
        __props__.__dict__["repository"] = repository
        __props__.__dict__["repository_branch"] = repository_branch
        __props__.__dict__["repository_commit"] = repository_commit
        __props__.__dict__["repository_connector"] = repository_connector
        __props__.__dict__["repository_path"] = repository_path
        __props__.__dict__["repository_sha"] = repository_sha
        __props__.__dict__["tags"] = tags
        __props__.__dict__["terraform_variable_files"] = terraform_variable_files
        __props__.__dict__["terraform_variables"] = terraform_variables
        __props__.__dict__["variable_sets"] = variable_sets
        return Workspace(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def connectors(self) -> pulumi.Output[Optional[Sequence['outputs.WorkspaceConnector']]]:
        """
        Provider connectors configured on the Workspace. Only one connector of a type is supported
        """
        return pulumi.get(self, "connectors")

    @_builtins.property
    @pulumi.getter(name="costEstimationEnabled")
    def cost_estimation_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Cost estimation enabled determines if cost estimation operations are performed.
        """
        return pulumi.get(self, "cost_estimation_enabled")

    @_builtins.property
    @pulumi.getter(name="defaultPipelines")
    def default_pipelines(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Default pipelines associated with this workspace
        """
        return pulumi.get(self, "default_pipelines")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Description of the resource.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> pulumi.Output[Optional[Sequence['outputs.WorkspaceEnvironmentVariable']]]:
        """
        Environment variables configured on the workspace
        """
        return pulumi.get(self, "environment_variables")

    @_builtins.property
    @pulumi.getter
    def identifier(self) -> pulumi.Output[_builtins.str]:
        """
        Unique identifier of the resource.
        """
        return pulumi.get(self, "identifier")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the resource.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Output[_builtins.str]:
        """
        Unique identifier of the organization.
        """
        return pulumi.get(self, "org_id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.str]:
        """
        Unique identifier of the project.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="providerConnector")
    def provider_connector(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Provider connector is the reference to the connector for the infrastructure provider
        """
        return pulumi.get(self, "provider_connector")

    @_builtins.property
    @pulumi.getter(name="provisionerType")
    def provisioner_type(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "provisioner_type")

    @_builtins.property
    @pulumi.getter(name="provisionerVersion")
    def provisioner_version(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "provisioner_version")

    @_builtins.property
    @pulumi.getter
    def repository(self) -> pulumi.Output[_builtins.str]:
        """
        Repository is the name of the repository to fetch the code from.
        """
        return pulumi.get(self, "repository")

    @_builtins.property
    @pulumi.getter(name="repositoryBranch")
    def repository_branch(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Repository branch is the name of the branch to fetch the code from. This cannot be set if repository commit or sha is set.
        """
        return pulumi.get(self, "repository_branch")

    @_builtins.property
    @pulumi.getter(name="repositoryCommit")
    def repository_commit(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Repository commit is tag to fetch the code from. This cannot be set if repository branch or sha is set.
        """
        return pulumi.get(self, "repository_commit")

    @_builtins.property
    @pulumi.getter(name="repositoryConnector")
    def repository_connector(self) -> pulumi.Output[_builtins.str]:
        """
        Repository connector is the reference to the connector used to fetch the code.
        """
        return pulumi.get(self, "repository_connector")

    @_builtins.property
    @pulumi.getter(name="repositoryPath")
    def repository_path(self) -> pulumi.Output[_builtins.str]:
        """
        Repository path is the path in which the code resides.
        """
        return pulumi.get(self, "repository_path")

    @_builtins.property
    @pulumi.getter(name="repositorySha")
    def repository_sha(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Repository commit is commit SHA to fetch the code from. This cannot be set if repository branch or commit is set.
        """
        return pulumi.get(self, "repository_sha")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Tags to associate with the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="terraformVariableFiles")
    def terraform_variable_files(self) -> pulumi.Output[Optional[Sequence['outputs.WorkspaceTerraformVariableFile']]]:
        return pulumi.get(self, "terraform_variable_files")

    @_builtins.property
    @pulumi.getter(name="terraformVariables")
    def terraform_variables(self) -> pulumi.Output[Optional[Sequence['outputs.WorkspaceTerraformVariable']]]:
        return pulumi.get(self, "terraform_variables")

    @_builtins.property
    @pulumi.getter(name="variableSets")
    def variable_sets(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Variable sets to use.
        """
        return pulumi.get(self, "variable_sets")

