"""
AgenticlyPay - Python library for processing agentic payments via Stripe.

Supports ACP (Agentic Commerce Protocol), AP2 (Agent Payments Protocol), and x402 protocols.
"""

__version__ = "0.4.0"
__author__ = "AgenticlyPay"
__email__ = "support@agenticlypay.com"

from agenticlypay.client import AgenticlyPayClient, AgenticlyPayError
from agenticlypay.connect import ConnectManager
from agenticlypay.payments import PaymentProcessor

__all__ = [
    "AgenticlyPayClient",
    "AgenticlyPayError",
    "ConnectManager",
    "PaymentProcessor",
]

