import os
from dotenv import load_dotenv
load_dotenv()

hex_color_dict = {
    "red": "FF0000",
    "green": "00FF00",
    "blue": "0000FF",
    "yellow": "FFFF00",
    "purple": "800080",
    "cyan": "00FFFF",
    "magenta": "FF00FF",
    "lime": "00FF00",
    "pink": "FFC0CB",
    "teal": "008080",
    "lavender": "E6E6FA",
    "brown": "A52A2A",
    "beige": "F5F5DC",
    "maroon": "800000",
    "mint": "98FF98",
    "olive": "808000",
    "coral": "FF7F50",
    "navy": "000080",
    "grey": "808080",
    "white": "FFFFFF",
    "black": "000000",
    "orange": "FFA500",
    "indigo": "4B0082",
    "violet": "EE82EE",
    "gold": "FFD700",
    "silver": "C0C0C0",
    "rose": "FF007F",
    "emerald": "50C878",
    "ruby": "E0115F",
    "sapphire": "0F52BA",
    "amber": "FFBF00",
    "crimson": "DC143C",
    "darkgreen": "006400",
    "darkblue": "00008B",
    "darkred": "8B0000",
    "lightgreen": "90EE90",
    "lightblue": "ADD8E6",
    "lightyellow": "FFFFE0",
    "lightpink": "FFB6C1",
    "darkpurple": "800080",
    "lightpurple": "D8BFD8",
    "turquoise": "40E0D0",
    "tan": "D2B48C",
    "lightgrey": "D3D3D3",
    "darkgrey": "A9A9A9",
    "ivory": "FFFFF0",
    "khaki": "F0E68C",
    "lavenderblush": "FFF0F5",
    "lightcoral": "F08080",
    "salmon": "FA8072",
    "darksalmon": "E9967A",
    "lightsalmon": "FFA07A",
    "darkorange": "FF8C00",
    "linen": "FAF0E6",
    "peachpuff": "FFDAB9",
    "seashell": "FFF5EE",
    "snow": "FFFAFA",
    "wheat": "F5DEB3",
    "mistyrose": "FFE4E1",
    "azure": "F0FFFF",
    "aliceblue": "F0F8FF",
    "honeydew": "F0FFF0",
    "mintcream": "F5FFFA"
}


all_forex_pairs = {
'United States/Canada': 'USD/CAD',
'Japan/Euro': 'JPY/EUR',
'Denmark/Canada': 'DKK/CAD',
'Czech Republic/Japan': 'CZK/JPY',
'Euro/China': 'EUR/CNH',
'China/Singapore': 'CNY/SGD',
'Norway/United States': 'NOK/USD',
'Denmark/Mexico': 'DKK/MXN',
'Switzerland/South Africa': 'CHF/ZAR',
'Brazil/Japan': 'BRL/JPY',
'New Zealand/Indonesia': 'NZD/IDR',
'Bermuda/Canada': 'BMD/CAD',
'Silver/Turkey': 'XAG/TRY',
'Australia/South Africa': 'AUD/ZAR',
'Switzerland/Poland': 'CHF/PLN',
'Hong Kong/India': 'HKD/INR',
'Australia/New Zealand': 'AUD/NZD',
'South Africa/United Kingdom': 'ZAR/GBP',
'Malaysia/Australia': 'MYR/AUD',
'India/Taiwan': 'INR/TWD',
'South Korea/Switzerland': 'KRW/CHF',
'New Zealand/Switzerland': 'NZD/CHF',
'Israel/Japan': 'ILS/JPY',
'United States/South Africa': 'USD/ZAR',
'Hungary/Denmark': 'HUF/DKK',
'United States/China': 'USD/CNY',
'British Pound/Canada': 'GBP/CAD',
'Gold/Turkey': 'XAU/TRY',
'Mexican Peso/United States': 'MXN/USD',
'Hong Kong/Thailand': 'HKD/THB',
'Japanese Yen/British Pound': 'JPY/GBP',
'Euro/Singapore': 'EUR/SGD',
'Chilean Peso/British Pound': 'CLP/GBP',
'Colombian Peso/Mexican Peso': 'COP/MXN',
'Colombian Peso/United States': 'COP/USD',
'Brazilian Real/Mexican Peso': 'BRL/MXN',
'New Zealand/Czech Republic': 'NZD/CZK',
'South Korean Won/Australia': 'KRW/AUD',
'New Zealand/Hong Kong': 'NZD/HKD',
'British Pound/Costa Rican Colón': 'GBP/CRC',
'Turkish Lira/United States': 'TRY/USD',
'Silver/Russian Ruble': 'XAG/RUB',
'Silver/Euro': 'XAG/EUR',
'Australian Dollar/Poland': 'AUD/PLN',
'Australian Dollar/China': 'AUD/CNH',
'Euro/Australian Dollar': 'EUR/AUD',
'Japanese Yen/Taiwan': 'JPY/TWD',
'South African Rand/Thailand': 'ZAR/THB',
'New Zealand/Thailand': 'NZD/THB',
'British Pound/Indonesian Rupiah': 'GBP/IDR',
'Australian Dollar/Denmark': 'AUD/DKK',
'Silver/South African Rand': 'XAG/ZAR',
'Silver/Chinese Yuan': 'XAG/CNY',
'Australian Dollar/Hungary': 'AUD/HUF',
'Bulgarian Lev/Chinese Yuan': 'BGN/CNY',
'Singapore Dollar/British Pound': 'SGD/GBP',
'Hong Kong Dollar/Switzerland': 'HKD/CHF',
'Malaysian Ringgit/Singapore Dollar': 'MYR/SGD',
'Silver/United States Dollar': 'XAG/USD',
'United States Dollar/Taiwan Dollar': 'USD/TWD',
'Swedish Krona/Danish Krone': 'SEK/DKK',
'Bermuda/British Pound': 'BMD/GBP',
'British Pound/Euro': 'GBP/EUR',
'Moroccan Dirham/Australian Dollar': 'MAD/AUD',
'Israeli Shekel/Norwegian Krone': 'ILS/NOK',
'British Pound/Singapore Dollar': 'GBP/SGD',
'Singapore Dollar/South African Rand': 'SGD/ZAR',
'Indian Rupee/Singapore Dollar': 'INR/SGD',
'Japanese Yen/Indonesian Rupiah': 'JPY/IDR',
'Japanese Yen/Polish Złoty': 'JPY/PLN',
'British Pound/Danish Krone': 'GBP/DKK',
'Polish Złoty/Hungarian Forint': 'PLN/HUF',
'Turkish Lira/South African Rand': 'TRY/ZAR',
'South African Rand/Egyptian Pound': 'ZAR/EGP',
'Gold/South Korean Won': 'XAU/KRW',
'Egyptian Pound/Japanese Yen': 'EGP/JPY',
'South African Rand/Indian Rupee': 'ZAR/INR',
'Australian Dollar/Indian Rupee': 'AUD/INR',
'Gold/Mexican Peso': 'XAU/MXN',
'Japanese Yen/Canadian Dollar': 'JPY/CAD',
'Gold/British Pound': 'XAU/GBP',
'Danish Krone/Polish Złoty': 'DKK/PLN',
'South African Rand/Singapore Dollar': 'ZAR/SGD',
'Chinese Yuan/Swiss Franc': 'CNY/CHF',
'Chilean Peso/Australian Dollar': 'CLP/AUD',
'Japanese Yen/Indian Rupee': 'JPY/INR',
'Swiss Franc/Hong Kong Dollar': 'CHF/HKD',
'Hong Kong Dollar/Argentine Peso': 'HKD/ARS',
'Swiss Franc/Singapore Dollar': 'CHF/SGD',
'Czech Koruna/United States Dollar': 'CZK/USD',
'Chinese Yuan/South African Rand': 'CNY/ZAR',
'New Zealand/Euro': 'NZD/EUR',
'Australian Dollar/Swedish Krona': 'AUD/SEK',
'Swedish Krona/Polish Złoty': 'SEK/PLN',
'New Zealand/Indian Rupee': 'NZD/INR',
'South African Rand/Swiss Franc': 'ZAR/CHF',
'Indian Rupee/Swedish Krona': 'INR/SEK',
'Polish Złoty/British Pound': 'PLN/GBP',
'Danish Krone/Pakistani Rupee': 'DKK/PKR',
'Swedish Krona/British Pound': 'SEK/GBP',
'Canadian Dollar/Swiss Franc': 'CAD/CHF',
'New Zealand/Polish Złoty': 'NZD/PLN',
'South Korean Won/United States Dollar': 'KRW/USD',
'United States Dollar/Hong Kong Dollar': 'USD/HKD',
'Danish Krone/Thai Baht': 'DKK/THB',
'Gold/Thai Baht': 'XAU/THB',
'Philippine Peso/Danish Krone': 'PHP/DKK',
'Russian Ruble/Swiss Franc': 'RUB/CHF',
'Indian Rupee/Euro': 'INR/EUR',
'Argentine Peso/Euro': 'ARS/EUR',
'Polish Złoty/Czech Koruna': 'PLN/CZK',
'Norwegian Krone/Swedish Krona': 'NOK/SEK',
'Malaysian Ringgit/Swiss Franc': 'MYR/CHF',
'Canadian Dollar/United Arab Emirates Dirham': 'CAD/AED',
'Danish Krone/Swiss Franc': 'DKK/CHF',
'Silver/South Korean Won': 'XAG/KRW',
'Japanese Yen/Thai Baht': 'JPY/THB',
'Silver/Brazilian Real': 'XAG/BRL',
'Swiss Franc/Japanese Yen': 'CHF/JPY',
'Singapore Dollar/Indian Rupee': 'SGD/INR',
'Argentine Peso/Hong Kong Dollar': 'ARS/HKD',
'United States Dollar/Swedish Krona': 'USD/SEK',
'Cayman Islands Dollar/Canadian Dollar': 'KYD/CAD',
'British Pound/New Zealand Dollar': 'GBP/NZD',
'Taiwan Dollar/Danish Krone': 'TWD/DKK',
'Taiwan Dollar/Thai Baht': 'TWD/THB',
'Australian Dollar/Czech Koruna': 'AUD/CZK',
'Swiss Franc/United States Dollar': 'CHF/USD',
'United States Dollar/Danish Krone': 'USD/DKK',
'South African Rand/Philippine Peso': 'ZAR/PHP',
'Euro/Swiss Franc': 'EUR/CHF',
'United States Dollar/Icelandic Króna': 'USD/ISK',
'South African Rand/Botswana Pula': 'ZAR/BWP',
'Australian Dollar/Euro': 'AUD/EUR',
'Japanese Yen/Norwegian Krone': 'JPY/NOK',
'Swiss Franc/Romanian Leu': 'CHF/RON',
'Euro/British Pound': 'EUR/GBP',
'South Korean Won/Singapore Dollar': 'KRW/SGD',
'Peruvian Sol/Canadian Dollar': 'PEN/CAD',
'New Zealand Dollar/Japanese Yen': 'NZD/JPY',
'Malaysian Ringgit/South African Rand': 'MYR/ZAR',
'Swedish Krona/South African Rand': 'SEK/ZAR',
'Cypriot Pound/South African Rand': 'CYP/ZAR',
'Turkish Lira/Japanese Yen': 'TRY/JPY',
'British Pound/Israeli Shekel': 'GBP/ILS',
'South African Rand/New Zealand Dollar': 'ZAR/NZD',
'Turkish Lira/Polish Złoty': 'TRY/PLN',
'South African Rand/United States Dollar': 'ZAR/USD',
'Nigerian Naira/Japanese Yen': 'NGN/JPY',
'Silver/Hong Kong Dollar': 'XAG/HKD',
'Hong Kong Dollar/New Zealand Dollar': 'HKD/NZD',
'Swiss Franc/Swedish Krona': 'CHF/SEK',
'Japanese Yen/Australian Dollar': 'JPY/AUD',
'British Pound/Honduran Lempira': 'GBP/HNL',
'Singapore Dollar/Danish Krone': 'SGD/DKK',
'Malaysian Ringgit/Canadian Dollar': 'MYR/CAD',
'Czech Koruna/Canadian Dollar': 'CZK/CAD',
'Gold/Chinese Yuan': 'XAU/CNY',
'Gold/Canadian Dollar': 'XAU/CAD',
'Australian Dollar/British Pound': 'AUD/GBP',
'Swedish Krona/Swiss Franc': 'SEK/CHF',
'Australian Dollar/Hong Kong Dollar': 'AUD/HKD',
'South Korean Won/British Pound': 'KRW/GBP',
'Taiwan Dollar/Australian Dollar': 'TWD/AUD',
'Taiwan Dollar/Canadian Dollar': 'TWD/CAD',
'Malaysian Ringgit/Indonesian Rupiah': 'MYR/IDR',
'South Korean Won/Hong Kong Dollar': 'KRW/HKD',
'Taiwan Dollar/South African Rand': 'TWD/ZAR',
'New Zealand Dollar/Swedish Krona': 'NZD/SEK',
'Australian Dollar/Moroccan Dirham': 'AUD/MAD',
'New Zealand Dollar/United States Dollar': 'NZD/USD',
'Taiwan Dollar/Swedish Krona': 'TWD/SEK',
'United States Dollar/Indian Rupee': 'USD/INR',
'Norwegian Krone/Danish Krone': 'NOK/DKK',
'Czech Koruna/Mexican Peso': 'CZK/MXN',
'Thai Baht/Indonesian Rupiah': 'THB/IDR',
'United States Dollar/Egyptian Pound': 'USD/EGP',
'Canadian Dollar/Turkish Lira': 'CAD/TRY',
'Indonesian Rupiah/South Korean Won': 'IDR/KRW',
'South African Rand/Swedish Krona': 'ZAR/SEK',
'Israeli Shekel/Swiss Franc': 'ILS/CHF',
'British Pound/Icelandic Króna': 'GBP/ISK',
'Indian Rupee/Thai Baht': 'INR/THB',
'Danish Krone/Czech Koruna': 'DKK/CZK',
'Euro/Mexican Peso': 'EUR/MXN',
'Silver/Swiss Franc': 'XAG/GBP',
'Silver/Australian Dollar': 'XAG/AUD',
'Thai Baht/Taiwan Dollar': 'THB/TWD',
'South Korean Won/Canadian Dollar': 'KRW/CAD',
'New Zealand Dollar/Danish Krone': 'NZD/DKK',
'British Pound/Hungarian Forint': 'GBP/HUF',
'Chinese Yuan/United States Dollar': 'CNH/USD',
'Switzerland/Thailand': 'CHF/THB',
'Australia/South Korea': 'AUD/KRW',
'Czech Republic/Eurozone': 'CZK/EUR',
'Switzerland/Taiwan': 'CHF/TWD',
'Denmark/United Kingdom': 'DKK/GBP',
'Gold/Eurozone': 'XAU/EUR',
'Thai Baht/New Zealand Dollar': 'THB/NZD',
'Japanese Yen/Czech Koruna': 'JPY/CZK',
'Canadian Dollar/Hong Kong Dollar': 'CAD/HKD',
'British Pound/Norwegian Krone': 'GBP/NOK',
'South African Rand/Australian Dollar': 'ZAR/AUD',
'South African Rand/Czech Koruna': 'ZAR/CZK',
'South African Rand/Pakistani Rupee': 'ZAR/PKR',
'British Pound/Czech Koruna': 'GBP/CZK',
'Chinese Yuan/Japanese Yen': 'CNH/JPY',
'United States Dollar/Thai Baht': 'USD/THB',
'Danish Krone/New Zealand Dollar': 'DKK/NZD',
'British Pound/United States Dollar': 'GBP/USD',
'New Taiwan Dollar/Indonesian Rupiah': 'TWD/IDR',
'Singapore Dollar/Mexican Peso': 'SGD/MXN',
'Silver Ounce/Indian Rupee': 'XAG/INR',
'Norwegian Krone/British Pound': 'NOK/GBP',
'Canadian Dollar/Indonesian Rupiah': 'CAD/IDR',
'Argentine Peso/South African Rand': 'ARS/ZAR',
'Singapore Dollar/New Zealand Dollar': 'SGD/NZD',
'Brazilian Real/Argentine Peso': 'BRL/ARS',
'Malaysian Ringgit/Hong Kong Dollar': 'MYR/HKD',
'Gold/Hong Kong Dollar': 'XAU/HKD',
'Norwegian Krone/Eurozone': 'NOK/EUR',
'United States Dollar/Chinese Yuan': 'USD/CNH',
'Singapore Dollar/Swedish Krona': 'SGD/SEK',
'New Zealand Dollar/South African Rand': 'NZD/ZAR',
'Hong Kong Dollar/Canadian Dollar': 'HKD/CAD',
'Swedish Krona/Czech Koruna': 'SEK/CZK',
'Danish Krone/United States Dollar': 'DKK/USD',
'Eastern Caribbean Dollar/British Pound': 'XCD/GBP',
'Australian Dollar/Turkish Lira': 'AUD/TRY',
'Hong Kong Dollar/Australian Dollar': 'HKD/AUD',
'Danish Krone/Eurozone': 'DKK/EUR',
'Canadian Dollar/Israeli New Shekel': 'CAD/ILS',
'Japanese Yen/New Zealand Dollar': 'JPY/NZD',
'Hong Kong Dollar/Danish Krone': 'HKD/DKK',
'Swiss Franc/Indonesian Rupiah': 'CHF/IDR',
'Mexican Peso/Singapore Dollar': 'MXN/SGD',
'British Pound/South African Rand': 'GBP/ZAR',
'Canadian Dollar/Czech Koruna': 'CAD/CZK',
'United States Dollar/Norwegian Krone': 'USD/NOK',
'Japanese Yen/Israeli New Shekel': 'JPY/ILS',
'Gold/United States Dollar': 'XAU/USD',
'New Zealand Dollar/Canadian Dollar': 'NZD/CAD',
'Argentine Peso/Swiss Franc': 'ARS/CHF',
'Canadian Dollar/Japanese Yen': 'CAD/JPY',
'South African Rand/Cypriot Pound': 'ZAR/CYP',
'Indonesian Rupiah/British Pound': 'IDR/GBP',
'British Pound/South Korean Won': 'GBP/KRW',
'Indonesian Rupiah/South African Rand': 'IDR/ZAR',
'South African Rand/Japanese Yen': 'ZAR/JPY',
'Romanian Leu/United States Dollar': 'RON/USD',
'Hong Kong Dollar/New Taiwan Dollar': 'HKD/TWD',
'South African Rand/Canadian Dollar': 'ZAR/CAD',
'Hungarian Forint/Polish Zloty': 'HUF/PLN',
'New Taiwan Dollar/Singapore Dollar': 'TWD/SGD',
'Euro/Philippine Peso': 'EUR/PHP',
'Gold/Australian Dollar': 'XAU/AUD',
'Euro/Norwegian Krone': 'EUR/NOK',
'Hong Kong Dollar/Singapore Dollar': 'HKD/SGD',
'Singapore Dollar/Norwegian Krone': 'SGD/NOK',
'South Korean Won/South African Rand': 'KRW/ZAR',
'United States Dollar/Australian Dollar': 'USD/AUD',
'Swiss Franc/Hungarian Forint': 'CHF/HUF',
'Bulgarian Lev/Canadian Dollar': 'BGN/CAD',
'Singapore Dollar/Australian Dollar': 'SGD/AUD',
'Euro/Turkish Lira': 'EUR/TRY',
'Canadian Dollar/Norwegian Krone': 'CAD/NOK',
'Canadian Dollar/New Zealand Dollar': 'CAD/NZD',
'South African Rand/Norwegian Krone': 'ZAR/NOK',
'Chilean Peso/Swiss Franc': 'CLP/CHF',
'South Korean Won/Brazilian Real': 'KRW/BRL',
'Thai Baht/South Korean Won': 'THB/KRW',
'Mexican Peso/Australian Dollar': 'MXN/AUD',
'Silver Ounce/Canadian Dollar': 'XAG/CAD',
'British Pound/Chinese Yuan': 'GBP/CNH',
'Norwegian Krone/Indian Rupee': 'NOK/INR',
'Canadian Dollar/Indonesian Rupiah': 'CAD/IDR',
'Argentine Peso/South African Rand': 'ARS/ZAR',
'Singapore Dollar/New Zealand Dollar': 'SGD/NZD',
'Brazilian Real/Argentine Peso': 'BRL/ARS',
'Malaysian Ringgit/Hong Kong Dollar': 'MYR/HKD',
'Gold/Hong Kong Dollar': 'XAU/HKD',
'Norwegian Krone/Eurozone': 'NOK/EUR',
'United States Dollar/Chinese Yuan': 'USD/CNH',
'Singapore Dollar/Swedish Krona': 'SGD/SEK',
'New Zealand Dollar/South African Rand': 'NZD/ZAR',
'Hong Kong Dollar/Canadian Dollar': 'HKD/CAD',
'Swedish Krona/Czech Koruna': 'SEK/CZK',
'Danish Krone/United States Dollar': 'DKK/USD',
'Eastern Caribbean Dollar/British Pound': 'XCD/GBP',
'Australian Dollar/Turkish Lira': 'AUD/TRY',
'Hong Kong Dollar/Australian Dollar': 'HKD/AUD',
'Danish Krone/Eurozone': 'DKK/EUR',
'Canadian Dollar/Israeli New Shekel': 'CAD/ILS',
'Japanese Yen/New Zealand Dollar': 'JPY/NZD',
'Hong Kong Dollar/Danish Krone': 'HKD/DKK',
'Swiss Franc/Indonesian Rupiah': 'CHF/IDR',
'Mexican Peso/Singapore Dollar': 'MXN/SGD',
'British Pound/South African Rand': 'GBP/ZAR',
'Canadian Dollar/Czech Koruna': 'CAD/CZK',
'United States Dollar/Norwegian Krone': 'USD/NOK',
'Japanese Yen/Israeli New Shekel': 'JPY/ILS',
'Gold/United States Dollar': 'XAU/USD',
'New Zealand Dollar/Canadian Dollar': 'NZD/CAD',
'Argentine Peso/Swiss Franc': 'ARS/CHF',
'Canadian Dollar/Japanese Yen': 'CAD/JPY',
'South African Rand/Cypriot Pound': 'ZAR/CYP',
'Indonesian Rupiah/British Pound': 'IDR/GBP',
'British Pound/South Korean Won': 'GBP/KRW',
'Indonesian Rupiah/South African Rand': 'IDR/ZAR',
'South African Rand/Japanese Yen': 'ZAR/JPY',
'Romanian Leu/United States Dollar': 'RON/USD',
'Hong Kong Dollar/New Taiwan Dollar': 'HKD/TWD',
'South African Rand/Canadian Dollar': 'ZAR/CAD',
'Hungarian Forint/Polish Zloty': 'HUF/PLN',
'New Taiwan Dollar/Singapore Dollar': 'TWD/SGD',
'Euro/Philippine Peso': 'EUR/PHP',
'Gold/Australian Dollar': 'XAU/AUD',
'Euro/Norwegian Krone': 'EUR/NOK',
'Hong Kong Dollar/Singapore Dollar': 'HKD/SGD',
'Singapore Dollar/Norwegian Krone': 'SGD/NOK',
'South Korean Won/South African Rand': 'KRW/ZAR',
'United States Dollar/Australian Dollar': 'USD/AUD',
'Swiss Franc/Hungarian Forint': 'CHF/HUF',
'Bulgarian Lev/Canadian Dollar': 'BGN/CAD',
'Singapore Dollar/Australian Dollar': 'SGD/AUD',
'Euro/Turkish Lira': 'EUR/TRY',
'Canadian Dollar/Norwegian Krone': 'CAD/NOK',
'Canadian Dollar/New Zealand Dollar': 'CAD/NZD',
'South African Rand/Norwegian Krone': 'ZAR/NOK',
'Chilean Peso/Swiss Franc': 'CLP/CHF',
'South Korean Won/Brazilian Real': 'KRW/BRL',
'Thai Baht/South Korean Won': 'THB/KRW',
'Mexican Peso/Australian Dollar': 'MXN/AUD',
'Silver Ounce/Canadian Dollar': 'XAG/CAD',
'British Pound/Chinese Yuan': 'GBP/CNH',
'Norwegian Krone/Indian Rupee': 'NOK/INR',
'Canadian Dollar/Indonesian Rupiah': 'CAD/IDR',
'Argentine Peso/South African Rand': 'ARS/ZAR',
'Singapore Dollar/New Zealand Dollar': 'SGD/NZD',
'Brazilian Real/Argentine Peso': 'BRL/ARS',
'Malaysian Ringgit/Hong Kong Dollar': 'MYR/HKD',
'Gold/Hong Kong Dollar': 'XAU/HKD',
'Norwegian Krone/Eurozone': 'NOK/EUR',
'United States Dollar/Chinese Yuan': 'USD/CNH',
'Singapore Dollar/Swedish Krona': 'SGD/SEK',
'New Zealand Dollar/South African Rand': 'NZD/ZAR',
'Hong Kong Dollar/Canadian Dollar': 'HKD/CAD',
'Swedish Krona/Czech Koruna': 'SEK/CZK',
'Danish Krone/United States Dollar': 'DKK/USD',
'Eastern Caribbean Dollar/British Pound': 'XCD/GBP',
'Australian Dollar/Turkish Lira': 'AUD/TRY',
'Hong Kong Dollar/Australian Dollar': 'HKD/AUD',
'Danish Krone/Eurozone': 'DKK/EUR',
'Canadian Dollar/Israeli New Shekel': 'CAD/ILS',
'Japanese Yen/New Zealand Dollar': 'JPY/NZD',
'Hong Kong Dollar/Danish Krone': 'HKD/DKK',
'Swiss Franc/Indonesian Rupiah': 'CHF/IDR',
'Mexican Peso/Singapore Dollar': 'MXN/SGD',
'British Pound/South African Rand': 'GBP/ZAR',
'Canadian Dollar/Czech Koruna': 'CAD/CZK',
'United States Dollar/Norwegian Krone': 'USD/NOK',
'Japanese Yen/Israeli New Shekel': 'JPY/ILS',
'Gold/United States Dollar': 'XAU/USD',
'New Zealand Dollar/Canadian Dollar': 'NZD/CAD',
'Argentine Peso/Swiss Franc': 'ARS/CHF',
'Canadian Dollar/Japanese Yen': 'CAD/JPY',
'South African Rand/Cypriot Pound': 'ZAR/CYP',
'Indonesian Rupiah/British Pound': 'IDR/GBP',
'British Pound/South Korean Won': 'GBP/KRW',
'Indonesian Rupiah/South African Rand': 'IDR/ZAR',
'South African Rand/Japanese Yen': 'ZAR/JPY',
'Romanian Leu/United States Dollar': 'RON/USD',
'Hong Kong Dollar/New Taiwan Dollar': 'HKD/TWD',
'South African Rand/Canadian Dollar': 'ZAR/CAD',
'Hungarian Forint/Polish Zloty': 'HUF/PLN',
'New Taiwan Dollar/Singapore Dollar': 'TWD/SGD',
'Euro/Philippine Peso': 'EUR/PHP',
'Gold/Australian Dollar': 'XAU/AUD',
'Euro/Norwegian Krone': 'EUR/NOK',
'Hong Kong Dollar/Singapore Dollar': 'HKD/SGD',
'Singapore Dollar/Norwegian Krone': 'SGD/NOK',
'South Korean Won/South African Rand': 'KRW/ZAR',
    'Indian Rupee/Swiss Franc': 'INR/CHF',
    'Swiss Franc/Australian Dollar': 'CHF/AUD',
    'Danish Krone/Swedish Krona': 'DKK/SEK',
    'United Arab Emirates Dirham/South African Rand': 'AED/ZAR',
    'New Taiwan Dollar/New Zealand Dollar': 'TWD/NZD',
    'Singapore Dollar/Argentine Peso': 'SGD/ARS',
    'Australian Dollar/Swiss Franc': 'AUD/CHF',
    'Swedish Krona/Israeli New Shekel': 'SEK/ILS',
    'Gold (XAU)/Argentine Peso': 'XAU/ARS',
    'Euro/Danish Krone': 'EUR/DKK',
    'Peruvian Sol/British Pound Sterling': 'PEN/GBP',
    'Singapore Dollar/Turkish Lira': 'SGD/TRY',
    'New Taiwan Dollar/Chinese Yuan': 'TWD/CNY',
    'British Pound Sterling/Chilean Peso': 'GBP/CLP',
    'Argentine Peso/Singapore Dollar': 'ARS/SGD',
    'Nigerian Naira/South African Rand': 'NGN/ZAR',
    'Czech Koruna/Swiss Franc': 'CZK/CHF',
    'Euro/Canadian Dollar': 'EUR/CAD',
    'Euro/Polish Złoty': 'EUR/PLN',
    'Nigerian Naira/British Pound Sterling': 'NGN/GBP',
    'Singapore Dollar/Hong Kong Dollar': 'SGD/HKD',
    'Danish Krone/Indian Rupee': 'DKK/INR',
    'Singapore Dollar/Euro': 'SGD/EUR',
    'Canadian Dollar/South Korean Won': 'CAD/KRW',
    'Australian Dollar/United States Dollar': 'AUD/USD',
    'Mexican Peso/Japanese Yen': 'MXN/JPY',
    'Brazilian Real/Swiss Franc': 'BRL/CHF',
    'Danish Krone/Hungarian Forint': 'DKK/HUF',
    'Chinese Yuan/United States Dollar': 'CNY/USD',
    'South African Rand/Euro': 'ZAR/EUR',
    'Euro/Czech Koruna': 'EUR/CZK',
    'Canadian Dollar/Australian Dollar': 'CAD/AUD',
    'Canadian Dollar/Kuwaiti Dinar': 'CAD/KWD',
    'New Zealand Dollar/Mexican Peso': 'NZD/MXN',
    'Nicaraguan Córdoba/British Pound Sterling': 'NIO/GBP',
    'South Korean Won/Swedish Krona': 'KRW/SEK',
    'Danish Krone/Hong Kong Dollar': 'DKK/HKD',
    'Canadian Dollar/New Taiwan Dollar': 'CAD/TWD',
    'Norwegian Krone/Polish Złoty': 'NOK/PLN',
    'New Taiwan Dollar/Swiss Franc': 'TWD/CHF',
    'New Zealand Dollar/British Pound Sterling': 'NZD/GBP',
    'Canadian Dollar/Danish Krone': 'CAD/DKK',
    'Canadian Dollar/Thai Baht': 'CAD/THB',
    'CFP Franc/British Pound Sterling': 'XPF/GBP',
    'Australian Dollar/Singapore Dollar': 'AUD/SGD',
    'Indonesian Rupiah/Indian Rupee': 'IDR/INR',
    'Polish Złoty/Mexican Peso': 'PLN/MXN',
    'British Pound Sterling/Mexican Peso': 'GBP/MXN',
    'Thai Baht/Swiss Franc': 'THB/CHF',
    'Euro/New Taiwan Dollar': 'EUR/TWD',
    'Australian Dollar/Japanese Yen': 'AUD/JPY',
    'Danish Krone/Norwegian Krone': 'DKK/NOK',
    'South African Rand/Hong Kong Dollar': 'ZAR/HKD',
    'British Pound Sterling/Indian Rupee': 'GBP/INR',
    'Egyptian Pound/Euro': 'EGP/EUR',
    'Gold (XAU)/Indian Rupee': 'XAU/INR',
    'New Taiwan Dollar/Hong Kong Dollar': 'TWD/HKD',
    'Argentine Peso/Brazilian Real': 'ARS/BRL',
    'United States Dollar/Singapore Dollar': 'USD/SGD',
    'South Korean Won/Chinese Yuan': 'KRW/CNY',
    'Costa Rican Colón/British Pound Sterling': 'CRC/GBP',
    'Mexican Peso/South African Rand': 'MXN/ZAR',
    'Thai Baht/Hong Kong Dollar': 'THB/HKD',
    'British Pound Sterling/East Caribbean Dollar': 'GBP/XCD',
    'Gold (XAU)/Japanese Yen': 'XAU/JPY',
    'Canadian Dollar/Euro': 'CAD/EUR',
    'Pakistani Rupee/South African Rand': 'PKR/ZAR',
    'Mexican Peso/Polish Złoty': 'MXN/PLN',
    'Australian Dollar/Bulgarian Lev': 'AUD/BGN',
    'Indian Rupee/United States Dollar': 'INR/USD',
    'South African Rand/New Taiwan Dollar': 'ZAR/TWD',
    'New Zealand Dollar/Australian Dollar': 'NZD/AUD',
    'Argentine Peso/Australian Dollar': 'ARS/AUD',
    'Qatari Rial/South African Rand': 'QAR/ZAR',
    'Hungarian Forint/Canadian Dollar': 'HUF/CAD',
    'Mexican Peso/Canadian Dollar': 'MXN/CAD',
    'Swedish Krona/Australian Dollar': 'SEK/AUD',
    'South African Rand/Romanian Leu': 'ZAR/RON',
    'Malaysian Ringgit/Indian Rupee': 'MYR/INR',
    'Honduran Lempira/British Pound Sterling': 'HNL/GBP',
    'Polish Złoty/Japanese Yen': 'PLN/JPY',
    'United States Dollar/Euro': 'USD/EUR',
    'Singapore Dollar/Indonesian Rupiah': 'SGD/IDR',
    'Gold (XAU)/Saudi Riyal': 'XAU/SAR',
    'Israeli New Shekel/Australian Dollar': 'ILS/AUD',
    'Canadian Dollar/British Pound Sterling': 'CAD/GBP',
    'United States Dollar/British Pound Sterling': 'USD/GBP',
    'Thai Baht/Singapore Dollar': 'THB/SGD',
    'Indian Rupee/South Korean Won': 'INR/KRW',
    'Indian Rupee/New Zealand Dollar': 'INR/NZD',
    'Indian Rupee/Australian Dollar': 'INR/AUD',
    'British Pound Sterling/Bermudian Dollar': 'GBP/BMD',
    'Australian Dollar/Philippine Peso': 'AUD/PHP',
    'Hungarian Forint/South African Rand': 'HUF/ZAR',
    'United States Dollar/Philippine Peso': 'USD/PHP',
    'Swedish Krona/Norwegian Krone': 'SEK/NOK',
    'Chinese Yuan/British Pound Sterling': 'CNY/GBP',
    'Canadian Dollar/Hungarian Forint': 'CAD/HUF',
    'Icelandic Króna/Swiss Franc': 'ISK/CHF',
    'Bulgarian Lev/Australian Dollar': 'BGN/AUD',
    'Indian Rupee/Canadian Dollar': 'INR/CAD',
    'Euro/New Zealand Dollar': 'EUR/NZD',
    'Thai Baht/Canadian Dollar': 'THB/CAD',
    'Singapore Dollar/South Korean Won': 'SGD/KRW',
    'Swiss Franc/Euro': 'CHF/EUR',
    'Gold (XAU)/South African Rand': 'XAU/ZAR',
    'Australian Dollar/Chilean Peso': 'AUD/CLP',
    'Swiss Franc/Chilean Peso': 'CHF/CLP',
    'Vietnamese Đồng/Euro': 'VND/EUR',
    'Swiss Franc/Pakistani Rupee': 'CHF/PKR',
    'Swiss Franc/South Korean Won': 'CHF/KRW',
    'Argentine Peso/Japanese Yen': 'ARS/JPY',
    'Sri Lankan Rupee/South African Rand': 'LKR/ZAR',
    'Japanese Yen/South African Rand': 'JPY/ZAR',
    'Thai Baht/South African Rand': 'THB/ZAR',
    'Australian Dollar/Israeli New Shekel': 'AUD/ILS',
    'Swedish Krona/Euro': 'SEK/EUR',
    'South African Rand/Indonesian Rupiah': 'ZAR/IDR',
    'United States Dollar/Swiss Franc': 'USD/CHF',
    'Australian Dollar/Thai Baht': 'AUD/THB',
    'Euro/Argentine Peso': 'EUR/ARS',
    'South African Rand/Argentine Peso': 'ZAR/ARS',
    'Norwegian Krone/Swiss Franc': 'NOK/CHF',
    'New Taiwan Dollar/South Korean Won': 'TWD/KRW',
    'Singapore Dollar/Canadian Dollar': 'SGD/CAD',
    'Canadian Dollar/Singapore Dollar': 'CAD/SGD',
    'British Pound Sterling/Polish Złoty': 'GBP/PLN',
    'Vietnamese Đồng/Canadian Dollar': 'VND/CAD',
    'Canadian Dollar/Mexican Peso': 'CAD/MXN',
    'Polish Złoty/Swedish Krona': 'PLN/SEK',
    'British Pound Sterling/Argentine Peso': 'GBP/ARS',
    'Chinese Yuan/Canadian Dollar': 'CNY/CAD',
    'British Pound Sterling/Australian Dollar': 'GBP/AUD',
    'Thai Baht/Indian Rupee': 'THB/INR',
    'Swiss Franc/British Pound Sterling': 'CHF/GBP',
    'Singapore Dollar/United States Dollar': 'SGD/USD',
    'Japanese Yen/United States Dollar': 'JPY/USD',
    'Peruvian Sol/Argentine Peso': 'PEN/ARS',
    'United States Dollar/Polish Złoty': 'USD/PLN',
    'Australian Dollar/Norwegian Krone': 'AUD/NOK',
    'South African Rand/Nigerian Naira': 'ZAR/NGN',
    'Canadian Dollar/Swedish Krona': 'CAD/SEK',
    'Swiss Franc/Danish Krone': 'CHF/DKK',
    'Polish Złoty/Euro': 'PLN/EUR',
    'Czech Koruna/Swedish Krona': 'CZK/SEK',
    'Canadian Dollar/Polish Złoty': 'CAD/PLN',
    'United States Dollar/Czech Koruna': 'USD/CZK',
    'British Pound Sterling/Guatemalan Quetzal': 'GBP/GTQ',
    'Mexican Peso/Czech Koruna': 'MXN/CZK',
    'Chinese Yuan (Offshore)/Hong Kong Dollar': 'CNH/HKD',
    'Indonesian Rupiah/United States Dollar': 'IDR/USD',
    'United States Dollar/Mexican Peso': 'USD/MXN',
    'Malaysian Ringgit/New Taiwan Dollar': 'MYR/TWD',
    'Hungarian Forint/United States Dollar': 'HUF/USD',
    'Lithuanian Litas/Australian Dollar': 'LTL/AUD',
    'Euro/Indian Rupee': 'EUR/INR',
    'Turkish Lira/Singapore Dollar': 'TRY/SGD',
    'Swedish Krona/Japanese Yen': 'SEK/JPY',
    'Canadian Dollar/Bulgarian Lev': 'CAD/BGN',
    'New Taiwan Dollar/Indian Rupee': 'TWD/INR',
    'Japanese Yen/Argentine Peso': 'JPY/ARS',
    'United States Dollar/New Zealand Dollar': 'USD/NZD',
    'British Pound Sterling/Egyptian Pound': 'GBP/EGP',
    'Swiss Franc/Turkish Lira': 'CHF/TRY',
    'British Pound Sterling/Philippine Peso': 'GBP/PHP',
    'Colombian Peso/Argentine Peso': 'COP/ARS',
    'Hungarian Forint/Swiss Franc': 'HUF/CHF',
    'Hungarian Forint/Japanese Yen': 'HUF/JPY',
    'British Pound Sterling/Nicaraguan Córdoba': 'GBP/NIO',
    'Australian Dollar/New Taiwan Dollar': 'AUD/TWD',
    'Australian Dollar/Canadian Dollar': 'AUD/CAD',
    'Czech Koruna/Polish Złoty': 'CZK/PLN',
    'Mexican Peso/Euro': 'MXN/EUR',
    'Danish Krone/Australian Dollar': 'DKK/AUD',
    'Gold (XAU)/Brazilian Real': 'XAU/BRL',
    'British Pound Sterling/Japanese Yen': 'GBP/JPY',
    'United States Dollar/Japanese Yen': 'USD/JPY',
    'Thai Baht/Australian Dollar': 'THB/AUD',
    'Swiss Franc/Norwegian Krone': 'CHF/NOK',
    'Chinese Yuan/New Zealand Dollar': 'CNY/NZD',
    'Hong Kong Dollar/South Korean Won': 'HKD/KRW',
    'Guatemalan Quetzal/British Pound Sterling': 'GTQ/GBP',
    'New Zealand Dollar/Hungarian Forint': 'NZD/HUF',
    'Hong Kong Dollar/Indonesian Rupiah': 'HKD/IDR',
    'Tanzanian Shilling/South African Rand': 'TZS/ZAR',
    'British Pound Sterling / Turkish Lira': 'GBP/TRY',
    'Swiss Franc / Russian Ruble': 'CHF/RUB',
    'Polish Złoty / Danish Krone': 'PLN/DKK',
    'Australian Dollar / Argentine Peso': 'AUD/ARS',
    'Silver (XAG) / Japanese Yen': 'XAG/JPY',
    'Romanian Leu / Swiss Franc': 'RON/CHF',
    'British Pound Sterling / Hong Kong Dollar': 'GBP/HKD',
    'Mexican Peso / Hong Kong Dollar': 'MXN/HKD',
    'Thai Baht / United States Dollar': 'THB/USD',
    'Japanese Yen / Mexican Peso': 'JPY/MXN',
    'New Taiwan Dollar / United States Dollar': 'TWD/USD',
    'Canadian Dollar / United States Dollar': 'CAD/USD',
    'Danish Krone / Turkish Lira': 'DKK/TRY',
    'Romanian Leu / South African Rand': 'RON/ZAR',
    'British Pound Sterling / Nigerian Naira': 'GBP/NGN',
    'United States Dollar / Indonesian Rupiah': 'USD/IDR',
    'South African Rand / Turkish Lira': 'ZAR/TRY',
    'British Pound Sterling / Swiss Franc': 'GBP/CHF',
    'Turkish Lira / Swiss Franc': 'TRY/CHF',
    'British Pound Sterling / Peruvian Nuevo Sol': 'GBP/PEN',
    'Indonesian Rupiah / New Zealand Dollar': 'IDR/NZD',
    'Danish Krone / Japanese Yen': 'DKK/JPY',
    'Singapore Dollar / Swiss Franc': 'SGD/CHF',
    'Australian Dollar / Indonesian Rupiah': 'AUD/IDR',
    'Swiss Franc / Canadian Dollar': 'CHF/CAD',
    'Hong Kong Dollar / Swedish Krona': 'HKD/SEK',
    'Norwegian Krone / South African Rand': 'NOK/ZAR',
    'Malaysian Ringgit / New Zealand Dollar': 'MYR/NZD',
    'Turkish Lira / Danish Krone': 'TRY/DKK',
    'Indian Rupee / Hong Kong Dollar': 'INR/HKD',
    'Danish Krone / Russian Ruble': 'DKK/RUB',
    'Singapore Dollar / Japanese Yen': 'SGD/JPY',
    'Euro / Japanese Yen': 'EUR/JPY',
    'Norwegian Krone / Israeli New Shekel': 'NOK/ILS',
    'Danish Krone / Singapore Dollar': 'DKK/SGD',
    'Philippine Peso / United States Dollar': 'PHP/USD',
    'Australian Dollar / Mexican Peso': 'AUD/MXN',
    'South African Rand / Danish Krone': 'ZAR/DKK',
    'United States Dollar / Hungarian Forint': 'USD/HUF',
    'Canadian Dollar / Cayman Islands Dollar': 'CAD/KYD',
    'Euro / United States Dollar': 'EUR/USD',
    'Chinese Yuan / Hong Kong Dollar': 'CNY/HKD',
    'South Korean Won / New Zealand Dollar': 'KRW/NZD',
    'Silver (XAG) / Mexican Peso': 'XAG/MXN',
    'Danish Krone / New Taiwan Dollar': 'DKK/TWD',
    'Swedish Krona / United States Dollar': 'SEK/USD',
    'Canadian Dollar / Argentine Peso': 'CAD/ARS',
    'Euro / South African Rand': 'EUR/ZAR',
    'Philippine Peso / Japanese Yen': 'PHP/JPY',
    'Polish Złoty / Norwegian Krone': 'PLN/NOK',
    'New Zealand Dollar / Singapore Dollar': 'NZD/SGD',
    'Euro / Hong Kong Dollar': 'EUR/HKD',
    'Euro / Egyptian Pound': 'EUR/EGP',
    'Japanese Yen / Swedish Krona': 'JPY/SEK',
    'Hong Kong Dollar / Mexican Peso': 'HKD/MXN',
    'Brazilian Real / Australian Dollar': 'BRL/AUD',
    'United States Dollar / Turkish Lira': 'USD/TRY',
    'Indian Rupee / South African Rand': 'INR/ZAR',
    'South Korean Won / Euro': 'KRW/EUR',
    'Canadian Dollar / Russian Ruble': 'CAD/RUB',
    'Hong Kong Dollar / Japanese Yen': 'HKD/JPY',
    'Chinese Yuan / Indian Rupee': 'CNY/INR',
    'Israeli New Shekel / Swedish Krona': 'ILS/SEK',
    'Canadian Dollar / Indian Rupee': 'CAD/INR',
    'Mexican Peso / Danish Krone': 'MXN/DKK',
    'Canadian Dollar / Bermudian Dollar': 'CAD/BMD',
    'New Zealand Dollar / South Korean Won': 'NZD/KRW',
    'New Zealand Dollar / New Taiwan Dollar': 'NZD/TWD',
    'Hungarian Forint / Euro': 'HUF/EUR',
    'South African Rand / Hungarian Forint': 'ZAR/HUF',
    'Polish Złoty / United States Dollar': 'PLN/USD',
    'Danish Krone / Chinese Yuan': 'DKK/CNY',
    'Japanese Yen / Danish Krone': 'JPY/DKK',
    'South African Rand / South Korean Won': 'ZAR/KRW',
    'Egyptian Pound / United States Dollar': 'EGP/USD',
    'Euro / Hungarian Forint': 'EUR/HUF'}



crypto_currency_pairs = {
    'COVAL-USD': 'Circuits of Value to US Dollar',
    'BTT-USD': 'BitTorrent to US Dollar',
    'SEI-USD': 'SatoExchange to US Dollar',
    'CLV-USD': 'Clover Finance to US Dollar',
    'ALCX-USD': 'Alchemix to US Dollar',
    'AUCTION-USD': 'Bounce to US Dollar',
    'TRU-USD': 'TrueFi to US Dollar',
    'EOS-USD': 'EOS to US Dollar',
    'BNT-USD': 'Bancor to US Dollar',
    'SNT-USD': 'Status to US Dollar',
    'DASH-USD': 'Dash to US Dollar',
    'DNT-USD': 'district0x to US Dollar',
    'SPELL-USD': 'Spell to US Dollar',
    'LCX-USD': 'LCX to US Dollar',
    'SWFTC-USD': 'SwftCoin to US Dollar',
    'XRP-AUD': 'XRP to Australian Dollar',
    'INJ-USD': 'Injective Protocol to US Dollar',
    'REQ-USD': 'Request to US Dollar',
    'FIS-USD': 'Stafi to US Dollar',
    'ATOM-USD': 'Cosmos to US Dollar',
    'VET-USD': 'VeChain to US Dollar',
    'FORTH-USD': 'Ampleforth Governance Token to US Dollar',
    'SAND-USD': 'Sandbox to US Dollar',
    'OGN-USD': 'Origin Protocol to US Dollar',
    'JST-USD': 'JUST to US Dollar',
    'IOT-USD': 'IOTA to US Dollar',
    'AVAX-USD': 'Avalanche to US Dollar',
    'SOL-USD': 'Solana to US Dollar',
    'HBAR-USD': 'Hedera Hashgraph to US Dollar',
    'LTC-USD': 'Litecoin to US Dollar',
    'BCH-EUR': 'Bitcoin Cash to Euro',
    'CRO-USD': 'Crypto.com Coin to US Dollar',
    'UST-USD': 'TerraUSD to US Dollar',
    'ZIL-USD': 'Zilliqa to US Dollar',
    'ICX-USD': 'ICON to US Dollar',
    'XVG-USD': 'Verge to US Dollar',
    'BTC-USD': 'Bitcoin to US Dollar',
    'CGLD-USD': 'Celo to US Dollar',
    'TVK-USD': 'Theta Fuel to US Dollar',
    'COMP-USD': 'Compound to US Dollar',
    'LYM-USD': 'Lympo to US Dollar',
    'RAI-USD': 'Rai Reflex Index to US Dollar',
    'STX-USD': 'Stacks to US Dollar',
    'ACH-USD': 'Alchemy Pay to US Dollar',
    'ETH-AUD': 'Ethereum to Australian Dollar',
    'ENJ-USD': 'Enjin Coin to US Dollar',
    'FARM-USD': 'Harvest Finance to US Dollar',
    'IMX-USD': 'Immutable X to US Dollar',
    'MLN-USD': 'Enzyme to US Dollar',
    'BADGER-USD': 'Badger DAO to US Dollar',
    'DOT-USD': 'Polkadot to US Dollar',
    'LTC-EUR': 'Litecoin to Euro',
    'ADA-USD': 'Cardano to US Dollar',
    'XMR-USD': 'Monero to US Dollar',
    'UTK-USD': 'Utrust to US Dollar',
    'NKN-USD': 'NKN to US Dollar',
    'XRP-BTC': 'XRP to Bitcoin',
    'C98-USD': 'Coin98 to US Dollar',
    'NEAR-USD': 'NEAR Protocol to US Dollar',
    'CSM-USD': 'Cryptosol to US Dollar',
    'FTM-USD': 'Fantom to US Dollar',
    'CVX-USD': 'Convex Finance to US Dollar',
    'RLC-USD': 'iExec RLC to US Dollar',
    'SHIB-USD': 'Shiba Inu to US Dollar',
    'NEO-USD': 'NEO to US Dollar',
    '1INCH-USD': '1inch to US Dollar',
    'ARPA-USD': 'ARPA Chain to US Dollar',
    'XLM-USD': 'Stellar Lumens to US Dollar',
    'MKR-USD': 'Maker to US Dollar',
    'GNO-USD': 'Gnosis to US Dollar',
    'IOTX-USD': 'IoTeX to US Dollar',
    'KNC-USD': 'Kyber Network to US Dollar',
    'APE-USD': 'ApeCoin to US Dollar',
    'CTSI-USD': 'Cartesi to US Dollar',
    'ETH-BTC': 'Ethereum to Bitcoin',
    'GLM-USD': 'Golem to US Dollar',
    'LUNA-USD': 'Terra to US Dollar',
    'USDT-USD': 'Tether to US Dollar',
    'LTC-BTC': 'Litecoin to Bitcoin',
    'BOND-USD': 'BarnBridge to US Dollar',
    'RARI-USD': 'Rarible to US Dollar',
    'COTI-USD': 'COTI to US Dollar',
    'GRT-USD': 'The Graph to US Dollar',
    'STORJ-USD': 'Storj to US Dollar',
    'GUSD-USD': 'Gemini Dollar to US Dollar',
    'UNI-USD': 'Uniswap to US Dollar',
    'UMA-USD': 'UMA to US Dollar',
    'OCEAN-USD': 'Ocean Protocol to US Dollar',
    'FIL-USD': 'Filecoin to US Dollar',
    'BTC-GBP': 'Bitcoin to British Pound',
    'USDC-USD': 'USD Coin to US Dollar',
    'API3-USD': 'API3 to US Dollar',
    'QNT-USD': 'Quant to US Dollar',
    'ALGO-USD': 'Algorand to US Dollar',
    'DYDX-USD': 'dYdX to US Dollar',
    'BTC-EUR': 'Bitcoin to Euro',
    'SUSHI-USD': 'SushiSwap to US Dollar',
    'BCH-USD': 'Bitcoin Cash to US Dollar',
    'CRV-USD': 'Curve DAO Token to US Dollar',
    'RUNE-USD': 'THORChain to US Dollar',
    'ZEC-USD': 'Zcash to US Dollar',
    'XRP-USD': 'XRP to US Dollar',
    'PAX-USD': 'Paxos Standard to US Dollar',
    'ZRX-USD': '0x to US Dollar',
    'ETC-USD': 'Ethereum Classic to US Dollar',
    'AMP-USD': 'Amp to US Dollar',
    'SUKU-USD': 'SUKU to US Dollar',
    'MANA-USD': 'Decentraland to US Dollar',
    'BCH-GBP': 'Bitcoin Cash to British Pound',
    'AVT-USD': 'Aventus to US Dollar',
    'QTF-USD': 'Quickswap to US Dollar',
    'ALICE-USD': 'MyNeighborAlice to US Dollar',
    'PERP-USD': 'Perpetual Protocol to US Dollar',
    'ROSE-USD': 'Oasis Network to US Dollar',
    'FET-USD': 'Fetch.ai to US Dollar',
    'TRX-USD': 'TRON to US Dollar',
    'NCT-USD': 'PolySwarm to US Dollar',
    'OXT-USD': 'Orchid to US Dollar',
    'BTRST-USD': 'Bitrue Coin to US Dollar',
    'PNK-USD': 'Kleros to US Dollar',
    'GTC-USD': 'Gitcoin to US Dollar',
    'TRAC-USD': 'OriginTrail to US Dollar',
    'PLA-USD': 'PlayDapp to US Dollar',
    'ZEN-USD': 'Horizen to US Dollar',
    'DSH-USD': 'Dashcoin to US Dollar',
    'AXS-USD': 'Axie Infinity to US Dollar',
    'SRM-USD': 'Serum to US Dollar',
    'RNDR-USD': 'Render Token to US Dollar',
    'XTZ-USD': 'Tezos to US Dollar',
    'SC-USD': 'Siacoin to US Dollar',
    'OMG-USD': 'OMG Network to US Dollar',
    'PAXG-USD': 'Paxos Gold to US Dollar',
    'FX-USD': 'Function X to US Dollar',
    'LRC-USD': 'Loopring to US Dollar',
    'ANKR-USD': 'Ankr to US Dollar',
    'ETH-USD': 'Ethereum to US Dollar',
    'KSM-USD': 'Kusama to US Dollar',
    'TRB-USD': 'Tellor to US Dollar',
    'NANO-USD': 'Nano to US Dollar',
    'CVC-USD': 'Civic to US Dollar',
    'QRDO-USD': 'Qredo to US Dollar',
    'XYO-USD': 'XYO Network to US Dollar',
    'WBTC-USD': 'Wrapped Bitcoin to US Dollar',
    'DOGE-USD': 'Dogecoin to US Dollar',
    'FCL-USD': 'Fractal to US Dollar',
    'GALA-USD': 'Gala to US Dollar',
    'JASMY-USD': 'JasmyCoin to US Dollar',
    'KAVA-USD': 'Kava to US Dollar',
    'TIA-USD': 'Tia Token to US Dollar',
    'BOSON-USD': 'Boson Protocol to US Dollar',
    'ICP-USD': 'Internet Computer to US Dollar',
    'WAVES-USD': 'Waves to US Dollar',
    'LINK-USD': 'Chainlink to US Dollar',
    'BOBA-USD': 'Boba Network to US Dollar',
    'DYDX-EUR': 'dYdX to Euro',
    'QTUM-USD': 'Qtum to US Dollar',
    'YFI-USD': 'yearn.finance to US Dollar',
    'ELA-USD': 'Elastos to US Dollar',
    'CHZ-USD': 'Chiliz to US Dollar',
    'BAND-USD': 'Band Protocol to US Dollar',
    'MASK-USD': 'Mask Network to US Dollar',
    'NEXO-USD': 'Nexo to US Dollar',
    'SEI-EUR': 'SatoExchange to Euro',
    'XRD-USD': 'Radix to US Dollar',
    'KEEP-USD': 'Keep3rV1 to US Dollar',
    'EGLD-USD': 'Elrond to US Dollar',
    'LPT-USD': 'Livepeer to US Dollar',
    'FOX-USD': 'ShapeShift FOX Token to US Dollar',
    'NMR-USD': 'Numeraire to US Dollar',
    'SGB-USD': 'Digital Silver to US Dollar',
    'DUSK-USD': 'Dusk Network to US Dollar',
    'BTC-AUD': 'Bitcoin to Australian Dollar',
    'FLOW-USD': 'Flow to US Dollar',
    'SNX-USD': 'Synthetix to US Dollar',
    'SKL-USD': 'Skale Network to US Dollar',
    'DAI-USD': 'Dai to US Dollar',
    'GHST-USD': 'Aavegotchi to US Dollar',
    'MATIC-USD': 'Polygon to US Dollar',
    'ORN-USD': 'Orion Protocol to US Dollar',
    'GYEN-USD': 'Digital Yen to US Dollar',
    'AAVE-USD': 'Aave to US Dollar',
    'UOS-USD': 'Ultra to US Dollar',
    'TLOS-USD': 'Telos to US Dollar',
    'ASM-USD': 'Assemble Protocol (ASM) to US Dollar',
    'BAL-USD': 'Balancer (BAL) to US Dollar',
    'KRL-USD': 'Kryll (KRL) to US Dollar',
    'BAT-USD': 'Basic Attention Token (BAT) to US Dollar'}


CRYPTO_HOOKS = {
    "1INCH-USD": os.environ.get('1INCH_USD'),
    "AAVE-USD": os.environ.get('AAVE_USD'),
    "ACH-USD": os.environ.get('ACH_USD'),
    "ALGO-USD": os.environ.get('ALGO_USD'),
    "ANKR-USD": os.environ.get('ANKR_USD'),
    "ATOM-USD": os.environ.get('ATOM_USD'),
    "AVA-USD": os.environ.get('AVA_USD'),
    "BAL-USD": os.environ.get('BAL_USD'),
    "BAND-USD": os.environ.get('BAND_USD'),
    "BAT-USD": os.environ.get('BAT_USD'),
    "BCH-USD": os.environ.get('BCH_USD'),
    "BNB-USD": os.environ.get('BNB_USD'),
    "BTC-USD": os.environ.get('BTC_USD'),
    "CELO-USD": os.environ.get('CELO_USD'),
    "CHZ-USD": os.environ.get('CHZ_USD'),
    "CRO-USD": os.environ.get('CRO_USD'),
    "CRV-USD": os.environ.get('CRV_USD'),
    "DAI-USD": os.environ.get('DAI_USD'),
    "DASH-USD": os.environ.get('DASH_USD'),
    "DOGE-USD": os.environ.get('DOGE_USD'),
    "DOT-USD": os.environ.get('DOT_USD'),
    "ENJ-USD": os.environ.get('ENJ_USD'),
    "EOS-USD": os.environ.get('EOS_USD'),
    "ETC-USD": os.environ.get('ETC_USD'),
    "ETH-USD": os.environ.get('ETH_USD'),
    "FIL-USD": os.environ.get('FIL_USD'),
    "FLOW-USD": os.environ.get('FLOW_USD'),
    "GRT-USD": os.environ.get('GRT_USD'),
    "ICP-USD": os.environ.get('ICP_USD'),
    "KNC-USD": os.environ.get('KNC_USD'),
    "LINK-USD": os.environ.get('LINK_USD'),
    "LRC-USD": os.environ.get('LRC_USD'),
    "LTC-USD": os.environ.get('LTC_USD'),
    "MANA-USD": os.environ.get('MANA_USD'),
    "MATIC-USD": os.environ.get('MATIC_USD'),
    "MKR-USD": os.environ.get('MKR_USD'),
    "NANO-USD": os.environ.get('NANO_USD'),
    "OMG-USD": os.environ.get('OMG_USD'),
    "PAX-USD": os.environ.get('PAX_USD'),
    "QTUM-USD": os.environ.get('QTUM_USD'),
    "REN-USD": os.environ.get('REN_USD'),
    "SOL-USD": os.environ.get('SOL_USD'),
    "STMX-USD": os.environ.get('STMX_USD'),
    "STORJ-USD": os.environ.get('STORJ_USD'),
    "SUSHI-USD": os.environ.get('SUSHI_USD'),
    "TRX-USD": os.environ.get('TRX_USD'),
    "UNI-USD": os.environ.get('UNI_USD'),
    "USDC-USD": os.environ.get('USDC_USD'),
    "USDT-USD": os.environ.get('USDT_USD'),
    "VET-USD": os.environ.get('VET_USD'),
    "WAVES-USD": os.environ.get('WAVES_USD'),
    "XLM-USD": os.environ.get('XLM_USD'),
    "XMR-USD": os.environ.get('XMR_USD'),
    "XRP-USD": os.environ.get('XRP_USD'),
    "XTZ-USD": os.environ.get('XTZ_USD'),
    "YFI-USD": os.environ.get('YFI_USD'),
    "ZEC-USD": os.environ.get('ZEC_USD'),
    "ZEN-USD": os.environ.get('ZEN_USD'),
    "ZRX-USD": os.environ.get('ZRX_USD'),
}




market_sectors = {
    "basic_materials": [
        "MOS", "DNN", "CARR", "KGC", "CLF", "NEM", "TECK", "X",
        "BVN", "RIO", "SBSW", "FCX", "GOLD", "AG", "DOW", "CCJ",
        "PAAS", "MP", "TMC", "AA", "ALB", "HL", "BTU", "AEM", "VALE",
        "BTG", "DD"
    ],
    "communication_services": [
        "GSAT", "LUMN", "T", "ASTS", "VZ", "TMUS", "ZM", "VOD"
    ],
    "consumer_cyclical": [
        "LVS", "NFLX", "SIRI", "ROKU", "MCD", "TSLA", "QS", "RIVN",
        "WYNN", "NIO", "PENN", "AMC", "M", "GME", "XPEV", "PARA",
        "LI", "ONON", "HD", "MLCO", "LOW", "STLA", "FSR", "CMCSA",
        "CROX", "DIS", "CHPT", "WBD", "LEVI", "NKE", "MGM", "JWN",
        "HBI", "FFIE", "CMG", "DKNG", "AAP", "LCID", "FUBO", "VFC",
        "CZR", "SBUX", "F", "LEN", "GOEV", "LULU", "GT", "NKLA",
        "MANU", "PTON", "GM", "DISH"
    ],
    "consumer_defensive": [
        "KO", "KHC", "BYND", "WMT", "PG", "COTY", "TSN", "MO",
        "PEP", "KR", "TGT", "COST", "BUD", "GIS", "WBA"
    ],
    "utilities": [
        'NEE', 'PCG', 'DUK'
    ],
    "energy": [
        "RIG", "WMB", "COP", "DK", "ETRN", "SLB", "APA", "CVX",
        "KMI", "BP", "SU", "PAA", "HAL", "SWN", "XOM", "DVN",
        "PBR", "TELL", "MRO", "EPD", "SHEL", "EQT", "AR", "ET",
        "VLO", "OXY", "CVE"
    ],
    "real_estate": [
        "BMY", "TLRY", "SNDL", "ACB", "BTAI", "AMGN", "DNA", "AZN",
        "CLOV", "MRK", "PFE", "CRBU", "HUM", "CVS", "CGC", "BBIO",
        "AUPH", "LLY", "MRNA", "NVAX", "SGEN", "MDT", "ABBV", "ABT",
        "JNJ", "TEVA", "PACB", "ACRS", "UNH", "GILD", "VBIV", "HZNP",
        "ISEE", "UPS", "RTX", "ENVX", "GE", "CCL", "UAL",
        "ZIM", "HTZ", "NCLH", "PSNY", "B", "RCL", "AAL", "GNRC", "MMM",
        "CAT", "PLUG", "DAL", "SAVE", "JBLU", "IEP", "JOBY", "SPCE",
        "EOSE", "FDX", "BA", "FCEL", "LUV", "BEKE", "NLY", "SLG",
        "CIM", "ABR", "OPEN", "AGNC", "MPW", "CBL"
    ],
    "industrials": [
        "UPS", "RTX", "ENVX", "GE", "CCL", "UAL", "ZIM", "HTZ",
        "NCLH", "PSNY", "B", "RCL", "AAL", "GNRC", "MMM", "CAT",
        "PLUG", "DAL", "SAVE", "JBLU", "IEP", "JOBY", "SPCE",
        "EOSE", "FDX", "BA", "FCEL", "LUV"
    ],
    "financial_services": [
        "WFC", "C", "MARA", "UPST", "BCS", "BITF", "BAC", "V",
        "COF", "BBD", "PYPL", "HUT", "SOFI", "GS", "JPM", "AXP",
        "XP", "MA", "USB", "NU", "TFC", "SCHW", "TRUP", "ZION",
        "KEY", "DB", "BX", "NYCB", "PACW", "UBS", "ALLY", "MS",
        "FUTU"
    ],
    "technology": [
        "AMD", "AFRM", "ENPH", "STNE", "OSTK", "SPWR", "MU", "W",
        "PATH", "DOCN", "SE", "QCOM", "ON", "FSLR", "DM", "META",
        "ADBE", "NNDM", "MSFT", "NOK", "WDC", "APLD", "MMAT",
        "MELI", "EBAY", "INTC", "MQ", "NET", "SIMO", "DASH", "CRWD",
        "ETSY", "PANW", "MVIS", "ATVI", "RBLX", "ABNB", "ORCL",
        "RIOT", "EBIX", "BILI", "IQ", "GOOGL", "AI", "LRCX", "U",
        "RUN", "MULN", "PDD", "OKTA", "CPNG", "MSTR", "CRM", "TTD",
        "MRVL", "HOOD", "BABA", "UBER", "SPLK", "BMBL", "IBM", "JD",
        "SNOW", "MDB", "CSCO", "CVNA", "TWLO", "GENI", "SOUN",
        "GOOG", "DDOG", "PLTR", "FIS", "CLSK", "Z", "BIDU", "AAPL",
        "CHWY", "JMIA", "ZS", "TDOC", "AMAT", "AMZN", "HPQ", "BB",
        "LAZR", "FTCH", "IONQ", "NVDA", "SHOP", "MTCH", "LYFT",
        "TXN", "SNAP",
        "SMCI", "DOCU", "TSM", "COIN", "SQ", "PINS", "AVGO"
    ],

    "etfs": [
        'XLF', 'XLK', 'EWU', 'UUP', 'TNA', 'EWZ', 'DIA', 'UPRO', 'TMF', 'TQQQ', 
        'XOP', 'TZA', 'UCO', 'SMH', 'EWG', 'SOXS', 'HYG', 'IWM', 'IWN', 'XLP', 'SPXL', 
        'LQD', 'EFA', 'USO', 'EEM', 'SPXS', 'KWEB', 'KOLD', 'FXI', 'QQQ', 'XLV', 
        'SPXU', 'IEI', 'XRT', 'EMB', 'TIP', 'SPY', 'BITO', 'MSOS', 'SOXL', 'UNG', 
        'FNGS', 'ARKK', 'LABU', 'GLD', 'XLE', 'XHB', 'XBI', 'KRE', 'TBT', 'BOIL', 
        'TSLL', 'DPST', 'IEF', 'SQQQ', 'EWJ', 'TLT', 'SLV', 'JETS', 'XLI', 'IYR', 
        'XLU', 'XLY',

    ],

    "indexes": [ 
        'I:SPX', 'I:VIX', 'I:RUT', 'I:NDX', 'I:DJI'
    ]
}




basic_materials= ['LIN', 'BHP', 'RIO', 'SHW', 'VALE', 'SCCO', 'FCX', 'APD', 'ECL', 'TT', 'CRH', 'CARR', 'NUE', 'JCI', 'DOW', 'PPG', 'DD', 'CTVA', 'MLM', 'LYB', 'GOLD', 'NEM', 'VMC', 'NTR', 'PKX', 'AEM', 'WPM', 'MT', 'BLDR', 'IFF', 'FNV', 'CCJ', 'TECK', 'STLD', 'WLK', 'JHX', 'RS', 'CE', 'LII', 'MAS', 'AVTR', 'ALB', 'SUZ', 'CF', 'CSL', 'SQM', 'RPM', 'OC', 'CX', 'GFI', 'MOS', 'X', 'EMN', 'WMS', 'FBIN', 'CLF', 'TREX', 'TX', 'RGLD', 'SSD', 'GGB', 'FMC', 'UFPI', 'AXTA', 'EXP', 'AU', 'WFG', 'KGC', 'OLN', 'CMC', 'AAON', 'AZEK', 'AA', 'AMR', 'ESI', 'NEU', 'PAAS', 'BCC', 'AGI', 'SID', 'LPX', 'BCPC', 'CC', 'AWI', 'SUM', 'FUL', 'CBT', 'ASH', 'HUN', 'NXE', 'WDFC', 'KNF', 'KWR', 'HMY', 'SBSW', 'AVNT', 'SMG', 'GMS', 'HCC', 'BTU', 'MP', 'ARCH', 'MEOH', 'CEIX', 'SGML', 'IOSP', 'ARLP', 'UEC', 'SXT', 'CSTM', 'HL', 'OR', 'TFPM', 'EGO', 'MTRN', 'ROCK', 'PGTI', 'MTX', 'SSRM', 'TGLS', 'JBI', 'TROX', 'SCL', 'SLVM', 'DOOR', 'HBM', 'ERO', 'JELD', 'AG', 'NGVT', 'EQX', 'OEC', 'HWKN', 'GPRE', 'NRP', 'NG', 'APOG', 'GSM', 'CGAU', 'UUUU', 'FSM', 'METC', 'ALTM', 'IE', 'CENX', 'KOP', 'KALU', 'CDE', 'NX', 'MAG', 'ASTL', 'ASPN', 'SA', 'LAAC', 'SILV', 'TMST', 'SXC', 'LAC', 'ARLO', 'BIOX', 'CMP', 'WLKP', 'LEU', 'REX', 'MATV', 'UAN', 'ASIX', 'TILE', 'ZEUS', 'DRD', 'NFGC', 'HDSN', 'LXU', 'CLW', 'LWLG', 'PLL', 'GATO', 'TMC', 'TGB', 'MUX', 'AVD', 'ATLX', 'HNRG', 'RYAM', 'IPI', 'FF', 'TSE', 'PPTA', 'ABAT', 'ALTO', 'USAP', 'MTA', 'CMCL', 'ACNT', 'ORGN', 'PPIH', 'APT', 'USAU', 'MSB', 'NEXA', 'BVN']


technology = ['AWIN','LYT','SOPA', 'CYN','MMAT', 'WISA', 'PHUN', 'TWKS', 'AAPL', 'MSFT', 'NVDA', 'TSM', 'AVGO', 'ORCL', 'ASML', 'ADBE', 'CRM', 'AMD', 'ACN', 'CSCO', 'INTC', 'SAP', 'INTU', 'QCOM', 'TXN', 'NOW', 'IBM', 'UBER', 'AMAT', 'SONY', 'SHOP', 'PANW', 'LRCX', 'ADI', 'MU', 'FI', 'ANET', 'INFY', 'KLAC', 'SNPS', 'WDAY', 'CDNS', 'ARM', 'CRWD', 'SNOW', 'TEAM', 'APH', 'MRVL', 'ROP', 'DELL', 'NXPI', 'MSI', 'ADSK', 'FTNT', 'MCHP', 'SQ', 'TEL', 'DDOG', 'CTSH', 'FIS', 'PLTR', 'IT', 'ZS', 'TTD', 'ON', 'GFS', 'ANSS', 'FICO', 'HPQ', 'CDW', 'HUBS', 'MDB', 'MPWR', 'NET', 'KEYS', 'GLW', 'SPLK', 'FTV', 'GIB', 'BR', 'GRMN', 'HPE', 'VRSN', 'TDY', 'ZM', 'ERIC', 'PTC', 'FLT', 'NOK', 'ASX', 'SMCI', 'CHKP', 'IOT', 'NTAP', 'TYL', 'AKAM', 'EPAM', 'FSLR', 'STX', 'ENTG', 'DT', 'SWKS', 'JBL', 'WDC', 'TER', 'ENPH', 'LOGI', 'LDOS', 'SSNC', 'GEN', 'GDDY', 'APP', 'OKTA', 'BSY', 'NICE', 'U', 'ZBRA', 'AFRM', 'TRMB', 'PATH', 'MANH', 'AZPN', 'SRAD', 'DOCU', 'GRAB', 'JKHY', 'PAYC', 'JNPR', 'NTNX', 'PSTG', 'OTEX', 'ESTC', 'DBX', 'DOX', 'FFIV', 'FLEX', 'CDAY', 'HOOD', 'QRVO', 'PCOR', 'GLOB', 'GTLB', 'SNX', 'GWRE', 'CYBR', 'DUOL', 'LSCC', 'PCTY', 'MNDY', 'WEX', 'OLED', 'INFA', 'BILL', 'TOST', 'MSTR', 'AMKR', 'CACI', 'S', 'WIX', 'DSGX', 'RMBS', 'QLYS', 'CIEN', 'ONTO', 'MKSI', 'FRSH', 'CFLT', 'FN', 'ALTR', 'CGNX', 'KVYO', 'PSN', 'SPSC', 'SAIC', 'CCCS', 'SMAR', 'NXT', 'COHR', 'APPF', 'ARW', 'ZI', 'CNXC', 'DV', 'FOUR', 'LFUS', 'MTSI', 'NSIT', 'FIVN', 'NOVT', 'VNT', 'TENB', 'STNE', 'ST', 'LYFT', 'ALGM', 'DLO', 'WK', 'VRNS', 'EXLS', 'BRZE', 'AUR', 'PWSC', 'KD', 'CWAN', 'IPGP', 'ALIT', 'DXC', 'EEFT', 'HCP', 'TDC', 'BLKB', 'BMI', 'DAVA', 'SEDG', 'POWI', 'SQSP', 'WOLF', 'AVT', 'ASGN', 'CRUS', 'PAGS', 'ASAN', 'SYNA', 'NCNO', 'PEGA', 'SLAB', 'NVMI', 'ACLS', 'BOX', 'LPL', 'INST', 'VERX', 'BL', 'PYCR', 'LITE', 'RUN', 'NVEI', 'CLS', 'FROG', 'AYX', 'CVLT', 'DIOD', 'RELY', 'ACIW', 'YOU', 'RPD', 'ITRI', 'SPT', 'MQ', 'AI', 'TSEM', 'CAMT', 'DOCN', 'VSH', 'RNG', 'ALRM', 'VSAT', 'WNS', 'BDC', 'FORM', 'CRDO', 'LSPD', 'KLIC', 'SANM', 'PLXS', 'CALX', 'INTA', 'ENV', 'GBTG', 'ESE', 'FLYW', 'SITM', 'APPN', 'EVTC', 'QTWO', 'JAMF', 'ODD', 'NABL', 'RAMP', 'ALKT', 'PD', 'IONQ', 'AMBA', 'AVDX', 'SHLS', 'PRGS', 'FSLY', 'VIAV', 'PRFT', 'VYX', 'PI', 'PAY', 'ROG', 'SIMO', 'ARRY', 'EXTR', 'OSIS', 'SONO', 'PLUS', 'AGYS', 'BB', 'XRX', 'SWI', 'BMBL', 'EVCM', 'PLAB', 'MLNK', 'UPBD', 'PAYO', 'DQ', 'MXL', 'VRNT', 'CNXN', 'JKS', 'PRO', 'VECO', 'COHU', 'NATL', 'NTCT', 'CLBT', 'KN', 'CSGS', 'TTMI', 'NOVA', 'SPNS', 'GRND', 'AVPT', 'CSIQ', 'AMPL', 'VZIO', 'UCTT', 'VTEX', 'RUM', 'DCBO', 'CRSR', 'HLIT', 'CRCT', 'SATS', 'CTS', 'SMTC', 'STER', 'INDI', 'ADEA', 'ZUO', 'PDFS', 'ACMR', 'PAR', 'BASE', 'ENFN', 'ETWO', 'TASK', 'HIMX', 'SGH', 'MODN', 'ATEN', 'GDYN', 'TTEC', 'SCSC', 'BHE', 'SSYS', 'ICHR', 'ASTS', 'EVBG', 'DGII', 'OLO', 'GCT', 'PSFE', 'RPAY', 'BELFB', 'CRNC', 'EB', 'PGY', 'WEAV', 'PUBM', 'RDWR', 'AOSL', 'DMRC', 'DDD', 'MEI', 'IMXI', 'MTTR', 'YEXT', 'IIIV', 'SNPO', 'BIGC', 'AAOI', 'TIXT', 'SPWR', 'HCKT', 'LASR', 'APPS', 'ADTN', 'MITK', 'STEM', 'AEHR', 'ITRN', 'CEVA', 'LAW', 'GPRO', 'XPER', 'NNDM', 'MVIS', 'ALNT', 'NN', 'BKKT', 'CGNT', 'EGHT', 'UIS', 'VPG', 'CLFD', 'SKYT', 'FARO', 'NTGR', 'DSP', 'OSPN', 'AMSWA', 'VNET', 'CCSI', 'AVNW', 'DAKT', 'AUDC', 'MTLS', 'DOMO', 'BAND', 'GILT', 'IBEX', 'SSTI', 'LPSN', 'RMNI', 'ONTF', 'MAXN', 'KOPN', 'RDVT', 'EGAN', 'TCX', 'LTRX', 'LSAK', 'CMTL', 'INOD', 'IMMR', 'MIXT', 'ASUR', 'TRAK', 'VOXX', 'QUIK', 'AIP', 'MRAM', 'INVE', 'HEAR', 'ATOM', 'INTT', 'RELL', 'PSQH', 'WRAP', 'QBTS', 'TSAT', 'UEIC', 'DHX', 'SURG', 'KVHI', 'BEEM', 'SNCR', 'BTCM', 'XELA', 'STM', 'SMWB', 'WKME']

industrials = ['LUNR','RVSN','MNTS','GLLI','CISS', 'VSME', 'CAT', 'UNP', 'GE', 'UPS', 'BA', 'HON', 'BKNG', 'RTX', 'LMT', 'DE', 'ETN', 'ADP', 'ABNB', 'CNI', 'ITW', 'RELX', 'WM', 'CP', 'NOC', 'CSX', 'GD', 'TRI', 'FDX', 'MMM', 'CTAS', 'PH', 'TDG', 'EMR', 'RSG', 'NSC', 'PCAR', 'CPRT', 'PAYX', 'ODFL', 'GWW', 'LHX', 'WCN', 'FERG', 'AME', 'URI', 'FAST', 'OTIS', 'ROK', 'GPN', 'VRSK', 'CMI', 'RCL', 'IR', 'EFX', 'PWR', 'RYAAY', 'DAL', 'XYL', 'TCOM', 'HEI', 'SYM', 'HWM', 'WAB', 'EXPE', 'DOV', 'JBHT', 'CCL', 'VRT', 'HEI.A', 'VLTO', 'AXON', 'EXPD', 'LUV', 'HUBB', 'J', 'BAH', 'WSO', 'IEX', 'AER', 'TXT', 'SNA', 'POOL', 'SWK', 'UAL', 'NDSN', 'GGG', 'RTO', 'TRU', 'UHAL', 'ACM', 'GFL', 'LECO', 'RBA', 'AOS', 'PNR', 'BLD', 'SAIA', 'ZTO', 'TFII', 'ALLE', 'EME', 'CHRW', 'HII', 'XPO', 'ITT', 'AAL', 'NVT', 'TTC', 'RRX', 'STN', 'ESLT', 'CLH', 'KNX', 'AGCO', 'CNM', 'WCC', 'TTEK', 'RHI', 'ASR', 'CW', 'WWD', 'WSC', 'DLB', 'RBC', 'MIDD', 'ARMK', 'GNRC', 'NCLH', 'APG', 'KBR', 'FIX', 'BWXT', 'SITE', 'GXO', 'FCN', 'OSK', 'AYI', 'LSTR', 'CAE', 'WTS', 'AIT', 'MSA', 'FLR', 'HXL', 'CAR', 'TNET', 'ADT', 'MTZ', 'GTLS', 'BZ', 'ATKR', 'TKR', 'MSM', 'ATI', 'BECN', 'FLS', 'MLI', 'ESAB', 'MMYT', 'DRS', 'R', 'CWST', 'FTAI', 'MMS', 'ZWS', 'VMI', 'ALK', 'KEX', 'SPXC', 'EXPO', 'SRCL', 'AL', 'MOG.A', 'FSS', 'NSP', 'SNDR', 'FELE', 'GATX', 'JOBY', 'ATS', 'ENS', 'MDU', 'HRI', 'MATX', 'CPA', 'ACA', 'TEX', 'AEIS', 'MAN', 'BCO', 'AZUL', 'VRRM', 'GTES', 'AVAV', 'WIRE', 'DY', 'CRS', 'ERJ', 'CSWI', 'OMAB', 'HI', 'UNF', 'ENOV', 'CXT', 'CBZ', 'GFF', 'KAI', 'NPO', 'JBT', 'KFY', 'SPR', 'BE', 'BRC', 'TNL', 'ARCB', 'HUBG', 'HTZ', 'TRIP', 'VSTS', 'WOR', 'MGRC', 'HAYW', 'ABM', 'CAAP', 'RXO', 'WERN', 'REZI', 'RKLB', 'ICFI', 'STRL', 'ALG', 'KTOS', 'ENR', 'FA', 'MYRG', 'PLUG', 'ROAD', 'MWA', 'SBLK', 'AIR', 'GVA', 'SKYW', 'LZ', 'UPWK', 'TRN', 'GOGL', 'KMT', 'HURN', 'ENVX', 'HNI', 'MRCY', 'ATMU', 'HEES', 'PRIM', 'JBLU', 'SXI', 'NVEE', 'TNC', 'SAVE', 'ZIM', 'SABR', 'MRTN', 'HOLI', 'B', 'EPAC', 'IESC', 'CXW', 'ACHR', 'DAC', 'CTOS', 'ALGT', 'FWRD', 'GIC', 'BBU', 'DSGR', 'LNN', 'AZZ', 'SCS', 'GBX', 'ZIP', 'HLIO', 'GEO', 'XMTR', 'AMRC', 'PRG', 'CDRE', 'KFRC', 'VVX', 'NSSC', 'TGI', 'ULCC', 'HY', 'RYI', 'WNC', 'ATSG', 'CMCO', 'MATW', 'HTLD', 'THR', 'REVG', 'SP', 'BLDP', 'BXC', 'CVII', 'ERII', 'POWL', 'TH', 'VSEC', 'PRLB', 'NAT', 'EH', 'SPCE', 'GRC', 'NMM', 'MEG', 'KRNT', 'GOL', 'ASTE', 'VLRS', 'BV', 'SNCY', 'PBI', 'BBSI', 'GSL', 'CYRX', 'DCO', 'KELYA', 'CRAI', 'NVRI', 'HA', 'VVI', 'IIIN', 'NPWR', 'HAYN', 'GNK', 'CECO', 'EVLV', 'KAMN', 'DESP', 'ASC', 'DWAC', 'TITN', 'SWBI', 'KE', 'AGX', 'CVLG', 'ASLE', 'ACCO', 'CASS', 'ATRO', 'FCEL', 'MTW', 'FC', 'HSII', 'EBF', 'SMR', 'EGLE', 'CRESY', 'LIND', 'DXPE', 'FORR', 'TPC', 'RGP', 'TBI', 'LMB', 'BBCP', 'TRC', 'CMPO', 'PCT', 'AMPX', 'SHYF', 'DSKE', 'ALTG', 'FIP', 'PANL', 'DSX', 'AAN', 'PKOH', 'ALCC', 'CVEO', 'AMSC', 'SMHI', 'RLGT', 'NWPX', 'PKE', 'KODK', 'MEC', 'QUAD', 'MTRX', 'NL', 'WLDN', 'FSTR', 'MG', 'LXFR', 'RCMT', 'BLDE', 'DLHC', 'FREY', 'TWIN', 'KNOP', 'GHM', 'BLNK', 'TG', 'MNTX', 'ISSC', 'SPIR', 'SHIP', 'ARC', 'VTSI', 'BYRN', 'NSTB', 'PESI', 'BW', 'TORO', 'BGSF', 'ALTU', 'OMEX', 'PPSI', 'LTBR', 'RAIL', 'IDEX', 'GENC', 'GRIN', 'CYD']



energy=['XOM', 'CVX', 'SHEL', 'TTE', 'COP', 'PBR', 'PBR.A', 'BP', 'EQNR', 'CNQ', 'SLB', 'EOG', 'MPC', 'EPD', 'E', 'PSX', 'PXD', 'OXY', 'ET', 'VLO', 'HES', 'WMB', 'SU', 'OKE', 'TRP', 'LNG', 'MPLX', 'BKR', 'IMO', 'HAL', 'CVE', 'DVN', 'FANG', 'CQP', 'EC', 'WDS', 'TS', 'CTRA', 'PBA', 'TRGP', 'EQT', 'MRO', 'OVV', 'CHK', 'PR', 'APA', 'DINO', 'FTI', 'NOV', 'SWN', 'HESM', 'RRC', 'IEP', 'AR', 'WFRD', 'MTDR', 'CHRD', 'NE', 'YPF', 'UGP', 'CIVI', 'MUR', 'SUN', 'AM', 'ENLC', 'VNOM', 'CHX', 'DTM', 'PBF', 'KNTK', 'FRO', 'VAL', 'ETRN', 'VVV', 'NFG', 'RIG', 'SM', 'PTEN', 'MGY', 'NOG', 'STNG', 'CRC', 'STR', 'TDW', 'HP', 'WHD', 'CNX', 'CVI', 'KOS', 'ERF', 'LBRT', 'VIST', 'TRMD', 'BTE', 'INSW', 'CRK', 'NS', 'USAC', 'GPOR', 'CPE', 'SDRL', 'CRGY', 'TGS', 'PARR', 'OII', 'VET', 'TNK', 'GLNG', 'HPK', 'XPRO', 'DHT', 'LPG', 'TALO', 'AESI', 'KGS', 'DK', 'GEL', 'GLP', 'HLX', 'CLMT', 'WKC', 'DO', 'VTLE', 'ACDC', 'NVGS', 'NEXT', 'DNOW', 'CAPL', 'MRC', 'PUMP', 'SLCA', 'PDS', 'CLNE', 'VTOL', 'CLB', 'GRNT', 'TK', 'NGL', 'NBR', 'DRQ', 'SBOW', 'TNP', 'PBT', 'VTS', 'NOA', 'TTI', 'NR', 'OBE', 'BRY', 'SD', 'REPX', 'WTI', 'SGU', 'OIS', 'OSG', 'BOOM', 'AMPY', 'FET', 'VTNR', 'NGS', 'SMLP', 'GEOS', 'GTE', 'KLXE', 'AMTX', 'PHX', 'NINE', 'ICD', 'FLNG', 'EURN' ]


consumer_defensive = ['BRSH','WMT', 'PG', 'COST', 'KO', 'PEP', 'PM', 'UL', 'BUD', 'MDLZ', 'DEO', 'MO', 'CL', 'TGT', 'BTI', 'MNST', 'EL', 'STZ', 'KHC', 'KDP', 'ABEV', 'KVUE', 'KMB', 'HSY', 'SYY', 'ADM', 'GIS', 'KR', 'CCEP', 'DLTR', 'DG', 'BF.A', 'BF.B', 'CHD', 'WBA', 'TSN', 'CLX', 'MKC', 'HRL', 'LW', 'BG', 'CAG', 'TAP', 'CELH', 'SJM', 'ACI', 'EDU', 'CPB', 'USFD', 'PFGC', 'COTY', 'ELF', 'BJ', 'TAL', 'DAR', 'INGR', 'BRBR', 'PPC', 'POST', 'SFM', 'FLO', 'FIZZ', 'LANC', 'IPAR', 'OLLI', 'SAM', 'FRPT', 'SMPL', 'ASAI', 'LOPE', 'NWL', 'NOMD', 'JJSF', 'COUR', 'HELE', 'SPB', 'GO', 'CALM', 'CENT', 'LRN', 'TR', 'PRMW', 'DNUT', 'CCU', 'ATGE', 'UTZ', 'PSMT', 'THS', 'SOVO', 'CENTA', 'STRA', 'UDMY', 'MGPI', 'LAUR', 'AFYA', 'EPC', 'HIMS', 'ANDE', 'VGR', 'IMKTA', 'UVV', 'COCO', 'HLF', 'CHGG', 'FDP', 'JBSS', 'CHEF', 'AGRO', 'PRDO', 'KLG', 'HAIN', 'EWCZ', 'USNA', 'GOTU', 'NUS', 'UNFI', 'WEST', 'BRCC', 'BGS', 'SPTN', 'AVO', 'OTLY', 'STKL', 'VITL', 'ISPR', 'BYND', 'CVGW', 'TPB', 'UTI', 'SKIN', 'NGVC', 'NATR', 'LMNR', 'HFFG', 'BIG', 'APEI', 'LFVN', 'K', 'KOF', 'FMX', 'WMK']


consumer_cyclical = ['PRPL','QRTEA','VRM','WKHS','KNDI', 'OCTO', 'AMZN', 'TSLA', 'HD', 'TM', 'MCD', 'PDD', 'BABA', 'NKE', 'LOW', 'TJX', 'SBUX', 'MELI', 'STLA', 'MAR', 'CMG', 'LULU', 'ORLY', 'HMC', 'DHI', 'GM', 'F', 'HLT', 'ROST', 'LEN', 'AZO', 'LVS', 'YUM', 'JD', 'LI', 'CPNG', 'DKNG', 'MBLY', 'QSR', 'TSCO', 'APTV', 'ULTA', 'PHM', 'EBAY', 'ROL', 'SE', 'GPC', 'DRI', 'DECK', 'ONON', 'RIVN', 'BALL', 'MGA', 'BBY', 'AVY', 'YUMC', 'PKG', 'MGM', 'DPZ', 'AMCR', 'H', 'IP', 'WSM', 'NIO', 'LKQ', 'BURL', 'DKS', 'KMX', 'FND', 'CCK', 'HTHT', 'TOL', 'WRK', 'CASY', 'WYNN', 'XPEV', 'FIVE', 'PAG', 'SCI', 'VIPS', 'SKX', 'BBWI', 'CZR', 'CHDN', 'RL', 'CVNA', 'BIRK', 'ALV', 'TPX', 'ETSY', 'CHWY', 'TPR', 'PSO', 'LAD', 'MTN', 'NYT', 'MUSA', 'BWA', 'TXRH', 'GPK', 'LEA', 'GPS', 'WING', 'BERY', 'GNTX', 'LCID', 'PVH', 'LNW', 'MNSO', 'HAS', 'SN', 'HRB', 'WH', 'MHK', 'GLBE', 'WHR', 'VFC', 'CART', 'W', 'PLNT', 'MAT', 'LEVI', 'MTH', 'CROX', 'BC', 'BYD', 'THO', 'AN', 'CPRI', 'CHH', 'REYN', 'SON', 'BFAM', 'TMHC', 'GIL', 'SEE', 'IBP', 'DOOO', 'RRR', 'ALSN', 'IGT', 'M', 'RH', 'PII', 'BROS', 'ANF', 'KBH', 'CAVA', 'SLGN', 'HOG', 'COLM', 'ASO', 'GME', 'SIG', 'HGV', 'ABG', 'AEO', 'MDC', 'GOLF', 'WEN', 'YETI', 'QS', 'SKY', 'PSNY', 'GPI', 'GT', 'MLCO', 'AAP', 'MHO', 'URBN', 'UAA', 'PENN', 'RUSHA', 'UA', 'LEG', 'TPH', 'MOD', 'SEAS', 'KTB', 'VC', 'ADNT', 'SHOO', 'DFH', 'LCII', 'VAC', 'GEF', 'JWN', 'LGIH', 'KSS', 'CUK', 'SHAK', 'AIN', 'FOXF', 'SVV', 'CCS', 'FL', 'CRI', 'ZGN', 'MCW', 'CVCO', 'MODG', 'FTDR', 'CARG', 'DORM', 'OI', 'PZZA', 'GRBK', 'ACVA', 'BOOT', 'BLMN', 'PATK', 'DRVN', 'PTON', 'GTX', 'CWH', 'SIX', 'BKE', 'FUN', 'WGO', 'ROVR', 'DAN', 'ODP', 'MLKN', 'VSCO', 'MBC', 'BOWL', 'SAH', 'EAT', 'WLY', 'CAKE', 'VSTO', 'CBRL', 'EYE', 'THRM', 'LZB', 'KAR', 'OLPX', 'JACK', 'OXM', 'ARHS', 'AMWD', 'HBI', 'CNNE', 'GIII', 'XPEL', 'PHIN', 'OSW', 'SHCO', 'SBH', 'MSGE', 'MCRI', 'GES', 'SG', 'GOOS', 'LESL', 'FWRG', 'CARS', 'LAZR', 'PLYA', 'SCHL', 'BYON', 'GDEN', 'CAL', 'MBUU', 'RVLV', 'FIGS', 'HSAI', 'BZH', 'TRS', 'ARKO', 'AXL', 'NGMS', 'EVRI', 'MNRO', 'WOOF', 'IRBT', 'EVGO', 'ACEL', 'CHPT', 'PTLO', 'BLBD', 'HIBB', 'HZO', 'BJRI', 'ETD', 'SCVL', 'DIN', 'WWW', 'MYE', 'MED', 'FLWS', 'MOV', 'CURV', 'PLOW', 'RICK', 'CHUY', 'XPOF', 'LEGH', 'HVT', 'DENN', 'LQDT', 'BALY', 'DBI', 'SRI', 'ONEW', 'BWMX', 'WW', 'TAST', 'MLR', 'GAMB', 'SFIX', 'FNKO', 'MPX', 'LOVE', 'MCFT', 'ZUMZ', 'FSR', 'PBPB', 'CSV', 'GCI', 'JAKK', 'INVZ', 'JMIA', 'GCO', 'BBW', 'COOK', 'AGS', 'CPS', 'LOCO', 'LE', 'PLCE', 'HBB', 'ESCA', 'SNBR', 'HOFT', 'DXLG', 'INSE', 'CTRN', 'KFS', 'SGC', 'CLAR', 'CVGI', 'REAL', 'MPAA', 'STKS', 'RRGB', 'LCUT', 'DLTH', 'GRWG', 'BSET', 'BGFV', 'UFI', 'AOUT', 'WISH', 'WPRT', 'LL', 'TUP', 'SUP', 'LAZY', 'REE', 'KIRK', 'RACE', 'VFS', 'UCON', ]



utilities=['NEE', 'SO', 'DUK', 'NGG', 'SRE', 'PCG', 'AEP', 'D', 'CEG', 'EXC', 'XEL', 'ED', 'PEG', 'EIX', 'WEC', 'AWK', 'DTE', 'FE', 'ETR', 'FTS', 'ES', 'PPL', 'AEE', 'CNP', 'ATO', 'CMS', 'VST', 'BIP', 'LNT', 'AGR', 'EVRG', 'AES', 'NRG', 'NI', 'PNW', 'BEP', 'NFE', 'BEPC', 'CWEN', 'UGI', 'IDA', 'ELP', 'SWX', 'AQN', 'ORA', 'POR', 'NJR', 'ENIC', 'FLNC', 'BKH', 'ALE', 'OTTR', 'OGS', 'PNM', 'SR', 'AWR', 'CWT', 'AVA', 'RNW', 'MGEE', 'PAM', 'TAC', 'AY', 'ENLT', 'SJW', 'CPK', 'EE', 'HE', 'KEN', 'CEPU', 'MNTK', 'SPH', 'MSEX', 'AMPS', 'OPAL', 'UTL', 'GNE', 'YORW', 'CWCO', 'ARIS', 'GWRS', 'RGCO', 'SBS' ]


healthcare=['APTO', 'REVB', 'ARQT','GYRE','KTRA','RSLS','QYLD','RNAZ','SGMT','AVTX','ENSC', 'BIOL','CPHI','IKNA','FOXO','RDHL', 'AGEN', 'EVAX', 'LLY', 'UNH', 'NVO', 'JNJ', 'MRK', 'ABBV', 'NVS', 'AZN', 'TMO', 'ABT', 'DHR', 'AMGN', 'PFE', 'SNY', 'ISRG', 'SYK', 'MDT', 'ELV', 'VRTX', 'GILD', 'BMY', 'CVS', 'REGN', 'ZTS', 'CI', 'BSX', 'GSK', 'HCA', 'BDX', 'MCK', 'HUM', 'DXCM', 'TAK', 'IDXX', 'EW', 'COR', 'CNC', 'MRNA', 'HLN', 'ALC', 'IQV', 'A', 'BIIB', 'GEHC', 'VEEV', 'WST', 'RMD', 'CAH', 'MTD', 'ZBH', 'BNTX', 'ALNY', 'ARGX', 'ILMN', 'MOH', 'PHG', 'STE', 'ALGN', 'GMAB', 'ICLR', 'BAX', 'LH', 'COO', 'BMRN', 'WAT', 'HOLX', 'RPRX', 'BGNE', 'DGX', 'PODD', 'VTRS', 'INCY', 'RVTY', 'NBIX', 'TEVA', 'EXAS', 'KRTX', 'SNN', 'FMS', 'TFX', 'TECH', 'RDY', 'CRL', 'SRPT', 'UHS', 'LEGN', 'UTHR', 'QGEN', 'DVA', 'RGEN', 'PEN', 'BRKR', 'HSIC', 'BIO', 'CTLT', 'ROIV', 'CHE', 'MEDP', 'ATR', 'CYTK', 'THC', 'STVN', 'SWAV', 'IMGN', 'APLS', 'ACHC', 'ASND', 'GMED', 'XRAY', 'CERE', 'IONS', 'ELAN', 'JAZZ', 'NTRA', 'EXEL', 'EHC', 'BBIO', 'ITCI', 'ENSG', 'MASI', 'HQY', 'IMVT', 'PCVX', 'OPCH', 'TXG', 'INSP', 'DOCS', 'BLCO', 'CRSP', 'BPMC', 'QDEL', 'MDGL', 'ACAD', 'ALKS', 'NUVL', 'MMSI', 'HALO', 'PRGO', 'SHC', 'OGN', 'GKOS', 'NVST', 'HAE', 'SGRY', 'AXSM', 'INSM', 'ARWR', 'NEOG', 'FOLD', 'LNTH', 'RCM', 'RARE', 'EVH', 'BHVN', 'PGNY', 'IMCR', 'MLTX', 'AZTA', 'KRYS', 'AXNX', 'TDOC', 'CNMD', 'SEM', 'ITGR', 'IART', 'NARI', 'IRTC', 'AGL', 'OLK', 'RVMD', 'AMED', 'BHC', 'GH', 'XENE', 'PBH', 'HCM', 'AMN', 'DNA', 'LIVN', 'PDCO', 'CBAY', 'TMDX', 'LFST', 'FTRE', 'IBRX', 'PINC', 'ACLX', 'GLPG', 'TGTX', 'DNLI', 'AMPH', 'CERT', 'PRVA', 'SWTX', 'RCKT', 'RDNT', 'OSCR', 'NTLA', 'ZLAB', 'CRNX', 'RYTM', 'RXRX', 'CORT', 'IDYA', 'PRCT', 'IOVA', 'NMRA', 'ICUI', 'AMEH', 'PTCT', 'BEAM', 'SDGR', 'GPCR', 'VKTX', 'ARVN', 'SMMT', 'TWST', 'ATEC', 'ARDX', 'NEO', 'VCYT', 'CLDX', 'IRWD', 'SNDX', 'PACB', 'PRTA', 'HRMY', 'MRUS', 'DVAX', 'VCEL', 'AMAM', 'INMD', 'INBX', 'CPRX', 'TNDM', 'RXST', 'AMRX', 'ATRC', 'MRVI', 'MYGN', 'SAGE', 'STAA', 'ABCL', 'ALHC', 'OMCL', 'KROS', 'KYMR', 'PCRX', 'SUPN', 'VRNA', 'OMI', 'IRON', 'NHC', 'RLAY', 'NVCR', 'ADUS', 'USPH', 'PTGX', 'VIR', 'TLRY', 'MORF', 'WRBY', 'KNSA', 'UFPT', 'PHR', 'BCRX', 'AVDL', 'SANA', 'MOR', 'RCUS', 'SLNO', 'AGIO', 'AKRO', 'MIRM', 'LGND', 'XNCR', 'LMAT', 'DAWN', 'VRDN', 'DCPH', 'KURA', 'SRRK', 'ALPN', 'ANIP', 'AUPH', 'CTKB', 'ACCD', 'SAVA', 'AMLX', 'DH', 'GERN', 'TNGX', 'COLL', 'BKD', 'INVA', 'ETNB', 'PLRX', 'MDRX', 'EMBC', 'DYN', 'ZNTL', 'NRC', 'EYPT', 'MDXG', 'MNKD', 'IMTX', 'CABA', 'FNA', 'QTRX', 'ESTA', 'ARCT', 'VERA', 'MD', 'RNA', 'FLGT', 'VERV', 'RAPT', 'VREX', 'HSTM', 'LQDA', 'EXAI', 'CCRN', 'FDMT', 'TMCI', 'PRME', 'SIBN', 'SLP', 'ZYME', 'CALT', 'BLFS', 'EDIT', 'AORT', 'GRCL', 'TARS', 'ALXO', 'SLRN', 'KIDS', 'NVRO', 'TVTX', 'FUSN', 'HCAT', 'RGNX', 'ALEC', 'IGMS', 'MGNX', 'OLMA', 'ALT', 'CDNA', 'ANAB', 'EOLS', 'OSUR', 'EWTX', 'CVRX', 'MODV', 'IRMD', 'TYRA', 'SPRY', 'MRNS', 'CSTL', 'RVNC', 'PETQ', 'BCYC', 'BMEA', 'NVAX', 'CMPS', 'EHAB', 'SILK', 'REPL', 'OFIX', 'IMNM', 'CYH', 'LUNG', 'AVXL', 'WVE', 'TBPH', 'JANX', 'SRDX', 'NKTX', 'ZIMV', 'ELVN', 'CRBU', 'COGT', 'AIRS', 'PNTG', 'NRIX', 'KALV', 'FULC', 'PLSE', 'CGEM', 'THRD', 'PHAT', 'ORIC', 'CDMO', 'STTK', 'MGTX', 'ABUS', 'MRSN', 'SIGA', 'ITOS', 'BVS', 'NAUT', 'PRAX', 'EPIX', 'MLYS', 'RCEL', 'CGC', 'TERN', 'ZYXI', 'CCCC', 'DCGO', 'VYGR', 'HROW', 'CELC', 'LXRX', 'AXGN', 'ESPR', 'TCMD', 'ANIK', 'URGN', 'YMAB', 'AURA', 'HRTX', 'NNOX', 'TSHA', 'CBUS', 'GLUE', 'QURE', 'SPOK', 'RPTX', 'VMD', 'SENS', 'ATXS', 'LYRA', 'FENC', 'OPRX', 'VSTM', 'KMDA', 'QSI', 'SGHT', 'MASS', 'VRCA', 'OM', 'ANGO', 'XOMA', 'ENTA', 'STOK', 'OMER', 'LFMD', 'VNDA', 'ABOS', 'SCPH', 'ZVRA', 'AUGX', 'INMB', 'LFCR', 'EDAP', 'MACK', 'APLT', 'PROF', 'TELA', 'MNMD', 'SLDB', 'SYRS', 'MCRB', 'BLUE', 'VTGN', 'INGN', 'ATNM', 'CPSI', 'JYNT', 'XBIT', 'ABEO', 'ARMP', 'ANVS', 'CVM', 'MDWD', 'PLX', 'CRVS', 'RVPH', 'ELMD', 'JSPR', 'CSBR', 'LPTX', 'BTAI', 'SPRO', 'ACXP', 'CODX', 'MEIP', 'TXMD', 'TARO', 'GHRS', 'CLGN' ]


communication_services = ['FAZE','GOOG', 'GOOGL', 'META', 'NFLX', 'TMUS', 'CMCSA', 'DIS', 'VZ', 'T', 'NTES', 'AMX', 'CHTR', 'DASH', 'BIDU', 'SPOT', 'BCE', 'EA', 'CHT', 'SNAP', 'TTWO', 'TU', 'WBD', 'PINS', 'RCI', 'RBLX', 'VOD', 'LYV', 'SIRI', 'WMG', 'OMC', 'VIV', 'EDR', 'TME', 'FOXA', 'FWONK', 'NWS', 'TKO', 'NWSA', 'FOX', 'FWONA', 'TWLO', 'Z', 'IPG', 'ZG', 'ROKU', 'PARAA', 'LBRDK', 'LBRDA', 'MTCH', 'WPP', 'LSXMA', 'LSXMK', 'PARA', 'LBTYK', 'KT', 'NXST', 'FYBR', 'IRDM', 'BILI', 'MSGS', 'IQ', 'IAC', 'CCOI', 'USM', 'MANU', 'ATHM', 'LLYVA', 'TGNA', 'YELP', 'ZD', 'PLTK', 'IDCC', 'BATRA', 'LGF.A', 'BATRK', 'IAS', 'LGF.B', 'WB', 'GETY', 'YY', 'PLAY', 'TDS', 'CMPR', 'STGW', 'SSTK', 'CNK', 'LUMN', 'CRTO', 'VEON', 'PERI', 'MOMO', 'GENI', 'ATUS', 'SEAT', 'GOGO', 'TTGT', 'SPHR', 'OPRA', 'SHEN', 'FVRR', 'AMC', 'SBGI', 'GTN', 'DLX', 'HUYA', 'IDT', 'FUBO', 'AMCX', 'IMAX', 'MAX', 'SSP', 'THRY', 'QNST', 'ATEX', 'ATNI', 'BOC', 'RSVR', 'GRPN', 'EEX', 'EVER', 'NEXN', 'JFIN', 'SOHU', 'WOW', 'CDLX', 'OOMA', 'FNGR', 'TZOO', 'CXDO', 'BRAG', 'SKLZ', 'ZDGE', 'TEO', 'TIMB', 'SKM', 'TIGO', 'TKC' ]


financial_services = ['BRK.B', 'JPM', 'V', 'MA', 'BAC', 'WFC', 'HSBC', 'MS', 'RY', 'SPGI', 'AXP', 'GS', 'HDB', 'BLK', 'SCHW', 'TD', 'C', 'PGR', 'MMC', 'CB', 'BX', 'IBN', 'KKR', 'ICE', 'CME', 'MCO', 'BMO', 'PYPL', 'SAN', 'USB', 'BN', 'PNC', 'AON', 'BNS', 'APO', 'BBVA', 'ING', 'MET', 'AJG', 'TFC', 'COF', 'AFL', 'AIG', 'TRV', 'MSCI', 'CM', 'NU', 'BK', 'ALL', 'MFC', 'AMP', 'PRU', 'IBKR', 'LYG', 'ARES', 'BBD', 'COIN', 'NDAQ', 'SLF', 'PUK', 'ACGL', 'BCS', 'DFS', 'DB', 'WTW', 'HIG', 'RKT', 'TROW', 'NWG', 'FITB', 'STT', 'RJF', 'MTB', 'TW', 'OWL', 'BRO', 'FCNCA', 'PFG', 'MKL', 'WRB', 'HBAN', 'FDS', 'LPLA', 'ERIE', 'NTRS', 'RF', 'CINF', 'EG', 'BAM', 'L', 'SYF', 'KB', 'AEG', 'CFG', 'CRBG', 'SHG', 'BEN', 'XP', 'CG', 'KEY', 'TPG', 'BAP', 'MORN', 'ARCC', 'CNA', 'GL', 'EQH', 'BCH', 'RGA', 'RYAN', 'RNR', 'MKTX', 'EWBC', 'ALLY', 'AFG', 'UNM', 'BSAC', 'AIZ', 'KNSL', 'WBS', 'SEIC', 'JEF', 'ORI', 'IVZ', 'HLI', 'SOFI', 'FHN', 'PRI', 'VOYA', 'NYCB', 'FUTU', 'CMA', 'SF', 'WAL', 'CBSH', 'CFR', 'CACC', 'PNFP', 'ZION', 'FAF', 'EVR', 'RLI', 'SSB', 'PB', 'SIGI', 'OMF', 'HLNE', 'BPOP', 'OBDC', 'WTFC', 'FSK', 'ESNT', 'BOKF', 'OZK', 'SNV', 'COLB', 'VLY', 'FG', 'CADE', 'DNB', 'AMG', 'MARA', 'UBSI', 'FCFS', 'BXSL', 'ONB', 'FNB', 'HOMB', 'JHG', 'FRHC', 'AXS', 'LNC', 'ACT', 'GBCI', 'ESGR', 'WU', 'THG', 'AEL', 'RDN', 'PFSI', 'AGO', 'LAZ', 'SLM', 'COOP', 'FFIN', 'CRVL', 'JXN', 'HWC', 'UMBF', 'TFSL', 'MC', 'AB', 'MAIN', 'ABCB', 'STEP', 'UCBI', 'KMPR', 'APAM', 'SFBS', 'CNS', 'BGC', 'BHF', 'IBOC', 'WD', 'ASB', 'CATY', 'FIBK', 'NNI', 'VIRT', 'AX', 'TCBI', 'BANF', 'CNO', 'FHI', 'PIPR', 'GNW', 'UPST', 'BRP', 'FHB', 'INDB', 'GSHD', 'FBP', 'BOH', 'WSFS', 'RIOT', 'PPBI', 'HGTY', 'CBU', 'AUB', 'CVBF', 'HTGC', 'FULT', 'GBDC', 'PSEC', 'EBC', 'QFIN', 'NMIH', 'SFNC', 'PJT', 'SBCF', 'BKU', 'VCTR', 'AMK', 'HTH', 'FFBC', 'MCY', 'IBTX', 'TBBK', 'TOWN', 'FRME', 'PRK', 'NAVI', 'WAFD', 'CLBK', 'AGM', 'TSLX', 'SPNT', 'NBTB', 'LOB', 'FBK', 'MBIN', 'TFIN', 'RNST', 'DFIN', 'WSBC', 'CLSK', 'BANR', 'OFG', 'CUBI', 'ENVA', 'TRMK', 'EFSC', 'GCMG', 'GSBD', 'BFH', 'LKFN', 'HTLF', 'STC', 'NWBI', 'NTB', 'CHCO', 'FCF', 'PLMR', 'LU', 'WABC', 'FBNC', 'SYBT', 'HOPE', 'SNEX', 'CASH', 'NBHC', 'TCBK', 'BUSE', 'NMFC', 'PFS', 'SRCE', 'STBA', 'VBTX', 'TRUP', 'LMND', 'SASR', 'ECPG', 'NIC', 'PEBO', 'SAFT', 'NRDS', 'PFBC', 'BHLB', 'OBK', 'PX', 'OCFC', 'EIG', 'CSWC', 'DCOM', 'BY', 'RBCAA', 'BBDC', 'QCRH', 'PWP', 'LC', 'BRKL', 'GABC', 'BLX', 'PRAA', 'LBAI', 'MFIC', 'SBSI', 'LPRO', 'CIFR', 'CNOB', 'AMSF', 'BITF', 'FBMS', 'APLD', 'SLRC', 'EGBN', 'SII', 'PFC', 'PAX', 'WRLD', 'NOAH', 'AMTB', 'FMBH', 'CGBD', 'AMAL', 'TMP', 'TIPT', 'CTBI', 'BANC', 'PFLT', 'AMBC', 'HFWA', 'RILY', 'GSBC', 'OSBC', 'FCBC', 'CFB', 'AMRK', 'TRIN', 'HBT', 'CCAP', 'VINP', 'PRA', 'TIGR', 'MBWM', 'UWMC', 'CION', 'UVSP', 'IGIC', 'CRD.A', 'MCBS', 'HBNC', 'HTBK', 'BFST', 'FDUS', 'CCB', 'HAFC', 'MSBI', 'MCB', 'SMBC', 'TRST', 'NFBK', 'HONE', 'CATC', 'CAC', 'FFWM', 'KRNY', 'IBCP', 'UFCS', 'VEL', 'CPF', 'ATLC', 'LBC', 'WASH', 'EQBK', 'QD', 'FMNB', 'AMNB', 'HUT', 'PGC', 'UVE', 'THFF', 'CCBG', 'EZPW', 'WULF', 'SPFI', 'FFIC', 'HTBI', 'CCNE', 'AROW', 'SHBI', 'ACIC', 'ALRS', 'BHB', 'SMMF', 'OPY', 'BNRE', 'IREN', 'MOFG', 'GLRE', 'MPB', 'SMBK', 'CSTR', 'HIVE', 'TREE', 'GNTY', 'ACNB', 'MCBC', 'EBTC', 'BWB', 'RBB', 'WTBA', 'HBCP', 'BMRC', 'FISI', 'BRDG', 'CBNK', 'SUPV', 'CARE', 'SAR', 'NEWT', 'JRVR', 'SCM', 'FRST', 'BSRR', 'FBIZ', 'CZNC', 'FMAO', 'ORRF', 'SFST', 'WHF', 'FNLC', 'JMSB', 'FLIC', 'MVBF', 'MBI', 'WSBF', 'UNTY', 'FRBA', 'SBT', 'CIVB', 'BCML', 'PCB', 'RM', 'CVCY', 'HRTG', 'TSBK', 'SAMG', 'MFIN', 'INBK', 'CBAN', 'OCN', 'PKBK', 'EHTH', 'BCBP', 'HMST', 'HIPO', 'WNEB', 'ESSA', 'PVBC', 'ATLO', 'PTMN', 'LCNB', 'OPBK', 'OFS', 'ROOT', 'UBFO', 'BFIN', 'SRL', 'TBNK', 'ICMB', 'GGAL', 'BBAR', 'BUR', 'BCSF', 'BMA', 'TCPC', 'UBS', 'ITUB', 'CIB']



real_estate = ['AIRE', 'PLD', 'AMT', 'EQIX', 'PSA', 'WELL', 'CCI', 'SPG', 'O', 'DLR', 'CSGP', 'VICI', 'EXR', 'AVB', 'CBRE', 'SBAC', 'WY', 'EQR', 'ARE', 'INVH', 'IRM', 'VTR', 'BEKE', 'SUI', 'ESS', 'MAA', 'WPC', 'HST', 'ELS', 'AMH', 'KIM', 'UDR', 'GLPI', 'REG', 'REXR', 'PEAK', 'BXP', 'LAMR', 'CPT', 'CUBE', 'NLY', 'COLD', 'EGP', 'FRT', 'JLL', 'OHI', 'FSV', 'FR', 'STAG', 'BRX', 'AGNC', 'RHP', 'HR', 'STWD', 'ADC', 'TRNO', 'CIGI', 'AIRC', 'VNO', 'RITM', 'KRG', 'RYN', 'KRC', 'EPRT', 'PECO', 'HHH', 'PCH', 'APLE', 'BXMT', 'CUZ', 'IRT', 'PK', 'MAC', 'JOE', 'DBRG', 'SLG', 'SITC', 'SKT', 'CDP', 'ABR', 'HASI', 'IIPR', 'HIW', 'NHI', 'OPEN', 'DEI', 'OUT', 'FCPT', 'CWK', 'SHO', 'EXPI', 'MPW', 'UE', 'EQC', 'PEB', 'RLJ', 'ROIC', 'CMTG', 'RC', 'IVT', 'FOR', 'ARI', 'AKR', 'JBGS', 'KW', 'ESRT', 'SAFE', 'GTY', 'LADR', 'MMI', 'AAT', 'VRE', 'XHR', 'UNIT', 'ALEX', 'TWO', 'DEA', 'ELME', 'NTST', 'PMT', 'HPP', 'MFA', 'AIV', 'CIM', 'FBRT', 'AHH', 'UMH', 'PLYM', 'RDFN', 'ARR', 'BFS', 'KREF', 'PDM', 'EFC', 'RMR', 'NXRT', 'CSR', 'RWT', 'CBL', 'HOUS', 'NYMT', 'DX', 'INN', 'CHCT', 'GMRE', 'WSR', 'IRS', 'PKST', 'UHT', 'ACRE', 'FPI', 'SRG', 'CLDT', 'LAND', 'TRTX', 'LSEA', 'OLP', 'IVR', 'CTO', 'BRT', 'PSTL', 'GPMT', 'ONL', 'REFI', 'NREF', 'CIO', 'AFCG', 'OPAD', 'RMAX', 'STHO', 'AJX', 'MITT', 'ACR', 'CLPR', 'FTHM', 'LOAN']


etfs = ['INDA','ZSL', 'ZROZ', 'ZHDG', 'YXI', 'YLD', 'YINN', 'YCS', 'YANG', 'YALL', 'XYLG', 'XTN', 'XTL', 'XT', 'XSW', 'XSVM', 'XSOE', 'XSMO', 'XSLV', 'XSD', 'XRT', 'XRMI', 'XRLV', 'XPP', 'XPND', 'XPH', 'XOP', 'XNTK', 'XMVM', 'XMMO', 'XMLV', 'XMHQ', 'XME', 'XLY', 'XLV', 'XLU', 'XLRE', 'XLP', 'XLK', 'XLI', 'XLG', 'XLF', 'XLE', 'XLC', 'XLB', 'XITK', 'XHYT', 'XHYD', 'XHS', 'XHE', 'XHB', 'XES', 'XBI', 'XAR', 'WTV', 'WTRE', 'WTMF', 'WPS', 'WOOD', 'WIP', 'WGMI', 'WFH', 'WEBS', 'WEBL', 'WEAT', 'WDIV', 'WCLD', 'WCBR', 'WANT', 'VYMI', 'VYM', 'VXUS', 'VWOB', 'VWO', 'VV', 'VUG', 'VTWV', 'VTWO', 'VTWG', 'VTV', 'VTI', 'VTHR', 'VTC', 'VT', 'VSS', 'VSDA', 'VPU', 'VPN', 'VPL', 'VOX', 'VOT', 'VOOV', 'VOOG', 'VOO', 'VONV', 'VONG', 'VONE', 'VOE', 'VO', 'VNQI', 'VNQ', 'VNLA', 'VMBS', 'VLU', 'VIS', 'VIOV', 'VIOO', 'VIOG', 'VIGI', 'VIG', 'VICE', 'VHT', 'VGT', 'VGLT', 'VGK', 'VGIT', 'VEU', 'VERS', 'VEGI', 'VEA', 'VDE', 'VDC', 'VCR', 'VCLT', 'VCIT', 'VCAR', 'VBR', 'VBK', 'VB', 'VAW', 'VALQ', 'UYG', 'UXI', 'UWM', 'UTWY', 'UTSL', 'UTHY', 'UTEN', 'USXF', 'UST', 'USRT', 'USPX', 'USO', 'USMC', 'USL', 'USIG', 'USD', 'USCI', 'USAI', 'URTY', 'URTH', 'URNM', 'URNJ', 'URE', 'URA', 'UPW', 'UPV', 'UPRO', 'UPAR', 'UNG', 'UMDD', 'UGL', 'UGE', 'UGA', 'UDOW', 'UCYB', 'UCO', 'UCC', 'UBT', 'UBR', 'UBOT', 'TZA', 'TYO', 'TYLG', 'TWM', 'TWEB', 'TUR', 'TUA', 'TTT', 'TSLY', 'TSLS', 'TSLR', 'TSLQ', 'TSLL', 'TSL', 'TSDD', 'TQQQ', 'TPYP', 'TPOR', 'TOTL', 'TOLZ', 'TNA', 'TMV', 'TMF', 'TLT', 'TLH', 'TIP', 'TINY', 'TIME', 'THNQ', 'THLV', 'THD', 'THCX', 'TFLO', 'TFI', 'TECS', 'TECL', 'TECB', 'TDSC', 'TDIV', 'TCHI', 'TBT', 'TBIL', 'TBF', 'TARK', 'TAN', 'TAGS', 'SWAN', 'SVOL', 'SUSL', 'SUSB', 'SUSA', 'SSUS', 'SSO', 'SRVR', 'SRS', 'SRET', 'SQY', 'SQQQ', 'SPYX', 'SPYV', 'SPYG', 'SPYD', 'SPY', 'SPXU', 'SPXT', 'SPXS', 'SPXN', 'SPXL', 'SPXE', 'SPVU', 'SPVM', 'SPUU', 'SPTM', 'SPTL', 'SPSM', 'SPSB', 'SPRX', 'SPMO', 'SPMD', 'SPMB', 'SPLV', 'SPLG', 'SPHQ', 'SPHD', 'SPHB', 'SPGP', 'SPGM', 'SPFF', 'SPEU', 'SPEM', 'SPDW', 'SPDN', 'SPD', 'SPCX', 'SPC', 'SPBO', 'SOXX', 'SOXS', 'SOXQ', 'SOXL', 'SOCL', 'SNSR', 'SNPE', 'SMOG', 'SMN', 'SMLV', 'SMLF', 'SMH', 'SMDD', 'SLYV', 'SLYG', 'SLX', 'SLV', 'SLQD', 'SKYY', 'SKYU', 'SKF', 'SJB', 'SIZE', 'SIVR', 'SIMS', 'SILJ', 'SIL', 'SIJ', 'SHYG', 'SHV', 'SHE', 'SH', 'SGOL', 'SGDM', 'SGDJ', 'SFYX', 'SFYF', 'SFY', 'SEVN', 'SETH', 'SEF', 'SEA', 'SDY', 'SDVY', 'SDS', 'SDP', 'SDOW', 'SDOG', 'SDIV', 'SDEM', 'SCZ', 'SCO', 'SCJ', 'SCHY', 'SCHX', 'SCHV', 'SCHP', 'SCHO', 'SCHM', 'SCHK', 'SCHJ', 'SCHG', 'SCHF', 'SCHE', 'SCHD', 'SCHB', 'SCHA', 'SCC', 'SBIO', 'SBB', 'SARK', 'SAA', 'RZV', 'RZG', 'RYLG', 'RXL', 'RXI', 'RXD', 'RWX', 'RWR', 'RWO', 'RWM', 'RWL', 'RWK', 'RWJ', 'RUNN', 'RTH', 'RSPU', 'RSPT', 'RSPS', 'RSPR', 'RSPN', 'RSPM', 'RSPH', 'RSPG', 'RSPF', 'RSPD', 'RSPC', 'RSP', 'RPV', 'RPG', 'RPAR', 'ROM', 'RODM', 'ROBT', 'ROBO', 'RLY', 'RING', 'RINF', 'RINC', 'RIET', 'RFV', 'RFG', 'REZ', 'REW', 'RETL', 'REMX', 'REET', 'RDVY', 'RDVI', 'RDIV', 'RBLD', 'RAYS', 'RAAX', 'QYLG', 'QWLD', 'QUS', 'QTUM', 'QTEC', 'QRMI', 'QRFT', 'QQXT', 'QQQM', 'QQQJ', 'QQQE', 'QQQA', 'QQQ', 'QQH', 'QQEW', 'QMOM', 'QLD', 'QID', 'QGRO', 'QEMM', 'QEFA', 'QDPL', 'QDIV', 'QDF', 'QDEF', 'QCLN', 'QAI', 'QABA', 'PYZ', 'PYPY', 'PXJ', 'PXI', 'PXH', 'PXF', 'PXE', 'PWZ', 'PWV', 'PWB', 'PUTW', 'PULS', 'PUI', 'PTNQ', 'PTH', 'PTF', 'PTEC', 'PTBD', 'PST', 'PSR', 'PSQ', 'PSP', 'PSL', 'PSK', 'PSI', 'PSCT', 'PSCM', 'PSCI', 'PSCH', 'PSCF', 'PSCE', 'PSCC', 'PRN', 'PRF', 'PPH', 'PPA', 'PP', 'POWA', 'PNQI', 'PKW', 'PKB', 'PJP', 'PIZ', 'PIO', 'PINK', 'PIN', 'PILL', 'PIE', 'PHO', 'PHB', 'PGJ', 'PFXF', 'PFM', 'PFIX', 'PFI', 'PFFD', 'PFF', 'PEZ', 'PEY', 'PEO', 'PEJ', 'PDP', 'PDN', 'PDBC', 'PDBA', 'PCY', 'PBW', 'PBP', 'PBJ', 'PBE', 'PBD', 'PALC', 'OVT', 'OVLH', 'OUNZ', 'OOTO', 'ONLN', 'ONEY', 'ONEV', 'ONEQ', 'ONEO', 'OIH', 'OEF', 'ODDS', 'OBOR', 'OARK', 'OACP', 'NZAC', 'NXTG', 'NVDY', 'NVDU', 'NVDS', 'NVDL', 'NVDD', 'NVD', 'NUGT', 'NTSX', 'NLR', 'NFTY', 'NFRA', 'NFLY', 'NANR', 'NAN', 'NAIL', 'MZZ', 'MYY', 'MXI', 'MVV', 'MVPS', 'MVO', 'MSOX', 'MSOS', 'MSFU', 'MSFO', 'MSFD', 'MRNY', 'MOON', 'MOO', 'MNA', 'MMTM', 'MLPX', 'MLPA', 'MISL', 'MINT', 'MIDU', 'MGV', 'MGK', 'MGC', 'MEXX', 'METV', 'MDYV', 'MDYG', 'MDY', 'MDIV', 'MCHI', 'MBB', 'MAXI', 'MAKX', 'MAGS', 'LVHD', 'LTPZ', 'LTL', 'LRNZ', 'LRND', 'LRGF', 'LQDH', 'LQD', 'LOUP', 'LMBS', 'LIT', 'LGLV', 'LEMB', 'LEGR', 'LDEM', 'LCTU', 'LCTD', 'LABU', 'LABD', 'KXI', 'KWEB', 'KVLE', 'KURE', 'KTEC', 'KSTR', 'KSA', 'KROP', 'KRMA', 'KRE', 'KRBN', 'KORU', 'KOMP', 'KOLD', 'KOIN', 'KNCT', 'KMLM', 'KMET', 'KLXY', 'KLNE', 'KIE', 'KGRO', 'KGRN', 'KEUA', 'KEMX', 'KEMQ', 'KCE', 'KCCA', 'KBWY', 'KBWR', 'KBWP', 'KBWD', 'KBWB', 'KBE', 'KARS', 'JXI', 'JVAL', 'JUST', 'JSTC', 'JSML', 'JQUA', 'JPUS', 'JPST', 'JPSE', 'JPMO', 'JPIN', 'JPEM', 'JOET', 'JNUG', 'JNK', 'JMBS', 'JIRE', 'JHMM', 'JHML', 'JETS', 'JDST', 'JAAA', 'IYY', 'IYW', 'IYR', 'IYM', 'IYK', 'IYH', 'IYG', 'IYF', 'IYE', 'IYC', 'IXUS', 'IXP', 'IXN', 'IXJ', 'IXG', 'IXC', 'IWY', 'IWX', 'IWV', 'IWS', 'IWR', 'IWO', 'IWN', 'IWM', 'IWL', 'IWIN', 'IWFH', 'IWF', 'IWD', 'IWC', 'IWB', 'IVW', 'IVV', 'IVRS', 'IVOV', 'IVOO', 'IVOL', 'IVOG', 'IVLU', 'IVES', 'IVEG', 'IUSV', 'IUSG', 'IUSB', 'ITOT', 'ITEQ', 'ISTB', 'ISRA', 'IRBO', 'IQLT', 'IQDF', 'IPOS', 'IPO', 'IPKW', 'IPAY', 'IPAC', 'IOO', 'ION', 'INTF', 'INQQ', 'INFL', 'INDY', 'INCO', 'IMTM', 'IMCG', 'ILIT', 'ILF', 'ILCG', 'ILCB', 'IJT', 'IJS', 'IJR', 'IJK', 'IJJ', 'IJH', 'IHI', 'IHF', 'IHE', 'IHDG', 'IHAK', 'IGPT', 'IGOV', 'IGM', 'IGLB', 'IGF', 'IFV', 'IEZ', 'IEV', 'IEUR', 'IEMG', 'IEF', 'IDVO', 'IDUB', 'IDU', 'IDRV', 'IDNA', 'IDLV', 'IDHQ', 'IDGT', 'IDEV', 'IDAT', 'ICOP', 'ICLN', 'IBUY', 'IBRN', 'IBND', 'IBLC', 'IBBQ', 'IBB', 'IAT', 'IAK', 'IAI', 'HYZD', 'HYSA', 'HYS', 'HYLG', 'HYGH', 'HYG', 'HYEM', 'HYBB', 'HTEC', 'HRT', 'HOMZ', 'HJEN', 'HIBS', 'HIBL', 'HGER', 'HFND', 'HEZU', 'HEWJ', 'HEWG', 'HERO', 'HEQT', 'HEDJ', 'HDV', 'HDRO', 'HDGE', 'HDG', 'HDEF', 'HCOM', 'HAUZ', 'HARD', 'HAP', 'HAIL', 'HACK', 'GYLD', 'GXTG', 'GXG', 'GXC', 'GWX', 'GVLU', 'GVIP', 'GUSH', 'GURU', 'GUNR', 'GTEK', 'GSY', 'GSPY', 'GSLC', 'GSG', 'GRPM', 'GRN', 'GRID', 'GREK', 'GOEX', 'GOAU', 'GNR', 'GNOM', 'GMF', 'GMET', 'GLIN', 'GLDX', 'GLD', 'GK', 'GINN', 'GII', 'GIGB', 'GHYB', 'GGME', 'GGLS', 'GGLL', 'GFOF', 'GERM', 'GEM', 'GDXJ', 'GDX', 'GDVD', 'GDOC', 'GDEF', 'GCOR', 'GCC', 'GBLD', 'GBIL', 'GAMR', 'GAL', 'FYX', 'FYT', 'FYC', 'FXZ', 'FXY', 'FXU', 'FXR', 'FXP', 'FXO', 'FXL', 'FXI', 'FXH', 'FXG', 'FXF', 'FXE', 'FXD', 'FXB', 'FXA', 'FVD', 'FVAL', 'FV', 'FUTY', 'FUMB', 'FTXR', 'FTXO', 'FTXN', 'FTXL', 'FTXH', 'FTXG', 'FTSM', 'FTSL', 'FTRI', 'FTQI', 'FTLS', 'FTHI', 'FTGC', 'FTEC', 'FTC', 'FTA', 'FSZ', 'FSTA', 'FSMD', 'FSMB', 'FRI', 'FREL', 'FQAL', 'FPXI', 'FPX', 'FNY', 'FNX', 'FNK', 'FNGS', 'FNGG', 'FNDX', 'FNDE', 'FNDC', 'FNDB', 'FNDA', 'FNCL', 'FMET', 'FMAT', 'FM', 'FLRN', 'FLJP', 'FLJH', 'FLCH', 'FLBR', 'FLAX', 'FJP', 'FIXD', 'FIW', 'FIVG', 'FIVA', 'FITE', 'FINX', 'FILL', 'FIDU', 'FIDI', 'FID', 'FHLC', 'FGD', 'FFTY', 'FEZ', 'FEX', 'FEUZ', 'FEP', 'FENY', 'FEMS', 'FEM', 'FDVV', 'FDT', 'FDRR', 'FDNI', 'FDN', 'FDMO', 'FDLO', 'FDL', 'FDIS', 'FDIG', 'FDD', 'FCOM', 'FCG', 'FCA', 'FBZ', 'FBY', 'FBT', 'FBOT', 'FBND', 'FAZ', 'FAS', 'FAN', 'FALN', 'FAD', 'FAB', 'EZM', 'EZJ', 'EZA', 'EXI', 'EWZS', 'EWZ', 'EWY', 'EWX', 'EWW', 'EWV', 'EWU', 'EWT', 'EWS', 'EWQ', 'EWP', 'EWN', 'EWM', 'EWK', 'EWJ', 'EWI', 'EWH', 'EWG', 'EWD', 'EWC', 'EWA', 'EVX', 'EVAV', 'EUSA', 'EURL', 'EUO', 'EUM', 'EUFN', 'ESPO', 'ESGU', 'ESGE', 'ESGD', 'ERY', 'ERX', 'ERTH', 'EQWL', 'EQTY', 'EQL', 'EQAL', 'EPS', 'EPP', 'EPI', 'ENZL', 'ENRG', 'ENFR', 'EMXC', 'EMTY', 'EMQQ', 'EMLP', 'EMLC', 'EMFM', 'EMBD', 'EMB', 'ELD', 'EKG', 'EINC', 'EIDO', 'EFO', 'EFAX', 'EFAS', 'EFA', 'EETH', 'EES', 'EEMX', 'EEMS', 'EEM', 'EELV', 'EDZ', 'EDV', 'EDOW', 'EDOC', 'EDIV', 'EDC', 'ECOW', 'ECON', 'ECNS', 'ECLN', 'EBLU', 'EATV', 'EAGG', 'DYLG', 'DXJS', 'DXJ', 'DXD', 'DWM', 'DWAS', 'DVYE', 'DVY', 'DVOL', 'DUST', 'DUSL', 'DUHP', 'DUG', 'DTH', 'DTEC', 'DTD', 'DSTL', 'DSL', 'DSI', 'DRV', 'DRUP', 'DRN', 'DRIV', 'DRIP', 'DPST', 'DON', 'DOL', 'DNL', 'DMAT', 'DLS', 'DLN', 'DJP', 'DJD', 'DIVI', 'DIV', 'DISO', 'DIG', 'DIA', 'DHS', 'DGT', 'DGRW', 'DGRS', 'DGRO', 'DGIN', 'DFUV', 'DFUS', 'DFSV', 'DFSU', 'DFLV', 'DFJ', 'DFIV', 'DFIP', 'DFGR', 'DFEN', 'DFE', 'DFAX', 'DFAU', 'DFAT', 'DFAS', 'DFAR', 'DFAI', 'DFAC', 'DEW', 'DEUS', 'DESK', 'DES', 'DEM', 'DEEP', 'DDM', 'DBP', 'DBO', 'DBMF', 'DBJP', 'DBEU', 'DBEM', 'DBE', 'DBC', 'DBB', 'DAX', 'DAT', 'DAPP', 'CXSE', 'CWS', 'CWI', 'CWEB', 'CWB', 'CVY', 'CVSE', 'CVMC', 'CVLC', 'CVIE', 'CUT', 'CURE', 'CTEX', 'CTEC', 'CSD', 'CSB', 'CRUZ', 'CRPT', 'CRBN', 'CRAK', 'CR', 'CQQQ', 'CPER', 'COWS', 'CORN', 'COPX', 'CONY', 'CONL', 'COMT', 'COMB', 'COM', 'CNXT', 'CNBS', 'CN', 'CMDY', 'CLOU', 'CLIX', 'CLDL', 'CIBR', 'CHIX', 'CHIS', 'CHIR', 'CHIQ', 'CHIK', 'CHII', 'CHIH', 'CHIE', 'CHAU', 'CHAT', 'CGW', 'CGUS', 'CGGR', 'CGDV', 'CFO', 'CFA', 'CDL', 'CDC', 'CCRV', 'CCOR', 'CATH', 'CARZ', 'CANE', 'BZQ', 'BYOB', 'BWET', 'BUZZ', 'BUG', 'BTF', 'BTEK', 'BTAL', 'BSVO', 'BRZU', 'BRF', 'BOTZ', 'BOIL', 'BOAT', 'BNO', 'BNGE', 'BNDX', 'BNDD', 'BND', 'BLV', 'BLOK', 'BLCN', 'BKLC', 'BKF', 'BKCH', 'BJK', 'BIZD', 'BIV', 'BITS', 'BITQ', 'BITO', 'BITI', 'BIS', 'BIPC', 'BILS', 'BIBL', 'BIB', 'BFOR', 'BFIX', 'BFIT', 'BETZ', 'BDRY', 'BCIM', 'BCI', 'BCD', 'BBP', 'BBMC', 'BBH', 'BBC', 'BANX', 'BAB', 'AWAY', 'AVUV', 'AVUS', 'AVRE', 'AVLV', 'AVEM', 'AVDV', 'AVDE', 'ASHX', 'ASHR', 'ASA', 'ARKW', 'ARKK', 'ARKF', 'ARGT', 'AQWA', 'AOR', 'AOM', 'AOA', 'ANGL', 'ANEW', 'AMZY', 'AMZU', 'AMZD', 'AMZA', 'AMOM', 'AMLP', 'AMJ', 'AMDY', 'ALTY', 'ALTL', 'AIVL', 'AIVI', 'AIRR', 'AIEQ', 'AIA', 'AHOY', 'AGZ', 'AGQ', 'AGNG', 'AGG', 'ACWX', 'ACWI', 'ACES', 'AAXJ', 'AAPU', 'AAPD', 'AAPB', 'UVIX', 'VIXY', 'KLIP', 'BITX', 'XXXX', 'SPSK',]




stock_conditions_description_dictionary = { 
    'Corrected Consolidated Close (per listing market)':'Corrected Consolidated Close - per the Listing Market ("9"): This new modifier will be allowed to be used only by the Listing Market and may be used to adjust the consolidated last sale price. The Corrected Consolidated Close will be eligible to set the High, Low and Last for the consolidated statistics and will not update the participant records. Volume will always be reported as zero and will appear in Level 2 of the extended sale condition modifier field on the UTDF and CTS data feeds.',
    "Regular Sale": "A trade made without stated conditions is deemed regular way for settlement on the third business day following the transaction date.",
    "Acquisition": "A transaction made on the Exchange as a result of an Exchange acquisition.",
    "Average Price Trade": "A trade where the price reported is based upon an average of the prices for transactions in a security during all or any portion of the trading day.",
    "Automatic Execution": "A sale condition code that identifies a NYSE trade that has been automatically executed without the potential benefit of price improvement.",
    "Bunched Trade": "The combining of multiple odd-lot or round-lot orders for the same security so that they can all be executed at the same time. All affected clients must agree to the bunching before the order is submitted. Bunched trades may also be referred to as block trades.",
    "Bunched Sold Trade": "A bunched trade that is reported late.",
    "Cash Sale": "A transaction which requires delivery of securities and payment on the same day the trade takes place.",
    "Closing Prints": "The Participant Closing Price represents the last qualifying trade paid for a security by a Participant during the trading day.",
    "Cross Trade": "Indicates that the trade resulted from a Market Center’s crossing session.",
    "Derivatively Priced": "The transaction that constituted the trade-through was the execution of an order at a price that was not based, directly or indirectly, on the quoted price of the security at the time of execution, and for which the material terms were not reasonably determinable at the time the commitment to execute the order was made (REG NMS 611b7).",
    "Distribution": "Distribution stock refers to a large blocks of a security that are carefully sold into the market gradually in smaller blocks so as to inundate the market with sell orders for the security and driving down its price.",
    "Form T": "Identifies a trade that was executed outside of regular primary market hours and is reported as an extended hours trade.",
    "Extended Trading Hours (Sold Out of Sequence)": "Identifies a trade that takes place outside of regular market hours and is reported as an extended hours trade out of sequence and at a time different from the actual transaction time.",
    "Intermarket Sweep": "The transaction that constituted the trade-through was the execution of an order identified as an Intermarket Sweep Order.",
    "Market Center Official Close": "Indicates the ‘Official’ closing value as determined by a Market Center. This transaction report will contain the market center generated closing price.",
    "Market Center Official Open": "Indicates the ‘Official’ opening value as determined by a Market Center. This transaction report will contain the market center generated opening price.",
    "Market Center Opening Trade": "The trade that constituted the trade-through was a single priced opening transaction by the Market Center (REG NMS Rule 611b3).",
    "Market Center Reopening Trade": "The trade that constituted the trade-through was a single priced reopening transaction by the Market Center (REG NMS Rule 611b3).",
    "Market Center Closing Trade": "The transaction that constituted the trade-through was a single priced closing transaction by the Market Center (REG NMS Rule 611b3).",
    "Next Day": "A transaction that requires the delivery of securities on the first business day following the trade date.",
    "Price Variation Trade": "Indicates a regular market session trade transaction that carries a price that is significantly away from the prevailing consolidated or primary market value at the time of the transaction.",
    "Prior Reference Price": "A sale condition that identifies a trade based on a price at a prior point in time, i.e., more than 90 seconds prior to the time of the trade report. The execution time of the trade will be the time of the prior reference price.",
    "Rule 155 Trade (AMEX)": "A Seller’s Option transaction gives the seller the right to deliver the security at any time within a specific period, ranging from not less than two calendar days, to not more than sixty calendar days. A security offered “Seller’s Option” may command a lesser price than if offered “Regular Way”.",
    "Rule 127 NYSE": "To qualify as a NYSE Rule 127 the trade is executed outside the present quote and meets one or both of the following conditions: 1. has a volume of 10,000 shares or more and/or 2. has a dollar value of $200,000 or more.",
    "Opening Prints": "The trading day's first drawings of a symbol's candlestick charts.",
    "Stopped Stock (Regular Trade)": "A Seller’s Option transaction gives the seller the right to deliver the security at any time within a specific period, ranging from not less than two calendar days, to not more than sixty calendar days. A security offered “Seller’s Option” may command a lesser price than if offered “Regular Way”.",
    "Re-Opening Prints": "The transaction or group of transactions reported as a result of a single- priced re-opening event by the Market Center.",
    "Seller": "A Seller’s Option transaction gives the seller the right to deliver the security at any time within a specific period, ranging from not less than two calendar days, to not more than sixty calendar days. A security offered “Seller’s Option” may command a lesser price than if offered “Regular Way”.",
    "Sold Last": "Sold Last sale condition modifier is used when a trade prints in sequence but is reported late OR the trade is printed by Amex in conformance to the One or Two Point Rule. A Sold Last transaction should only impact the consolidated last sale price for an issue if the market center reporting the sold last transaction also reported the transaction setting the current last sale price.",
    "Sold (out of Sequence)": "Sold Out of Sequence is used when a trade is printed (reported) out of sequence and at a time different from the actual transaction time.",
    "Split Trade": "An execution in two markets when the specialist or Market Maker in the market first receiving the order agrees to execute a portion of it at whatever price is realized in another market to which the balance of the order is forwarded for execution.",
    "Stock Option Trade": "This is typically the stock portion of a delta neutral option trade executed by an option market maker.",
    "Yellow Flag Regular Trade": "Market Centers will have the ability to identify regular trades being reported during specific events as out of the ordinary by appending a new sale condition code Yellow Flag (“Y”) on each transaction reported to the UTP SIP. The new sale condition “.Y” will be eligible to update all market center and consolidated statistics. In certain instances, the UTP SIP will be required to append the .Y for the market center for trades reported as regular-way (Sale Condition @)",
    "Odd Lot Trade": "The Odd Lot Trade modifier will distinguish a trade resulting from a market center's execution in increments less than the defined round lot size.",
    "Corrected Consolidated Close (per listing market)": "A transaction executed by the Listing Market to establish the official Consolidated Last Price as indicated by the Listing Exchange.",
    "Held": "Trades received from a non-primary Participant during a primary market regulatory halt. These trades are held by the CTS Processor and are disseminated after the close of the primary market with an appropriate Held Trade Indicator code applicable to the trade.",
    "Trade Thru Exempt": "The Trade Through rule is a 20 year-old rule applied to NYSE-listed stocks that states that when a market receives an order, it cannot execute it at a price inferior to any found on another market. In modern electronic markets where trades are executed in milliseconds, this rule can prevent a broker’s ability to meet their “best execution” obligation--because speed provides certainty that the price that is advertised can be accessed.",
    "Correction": "Denotes a correction to the last indication or new indication. It will contain the corrected approximation of what that security's opening or reopening price range (Bid and Offer prices, no sizes) will be when trading resumes after a delayed opening or after a trading halt.",
    "Contingent Trade": "A Sale Condition code used to identify a transaction where the execution of the transaction is contingent upon some event.",
    "Qualified Contingent Trade ('QCT')": "A transaction consisting of two or more component orders executed as agent or principal where the execution of one component is contingent upon the execution of all other components at or near the same time and the price is determined by the relationship between the component orders and not the current market price for the security.",
    "Placeholder for 611 exempt": "Rule 611, which is the Trade Through Exemption of SEC Regulation NMS, is very lengthy to cover in detail. Parties interested in reading the rule in its entirely should type 'SEC Rule 611' into an internet search engine. This is the portion of the document that is pertinent to IB traders, in a nutshell: Typically the trades involved are a multi-component trade involving orders for a security and a related derivative, or, in the alternative, orders for related securities, that are executed at or near the same time. The SIA (Securities Industry Association) notes that the economics of a contingent trade are based on the relationship between the prices of the security and the related derivative or security, and that the execution of one order is contingent upon the execution of the other order.",
    "SSR in Effect": "Any stock that has dropped more than 10% intraday has SSR in effect for that day and the following."

}



option_conditions_dict = { 
    "Corrected Consolidated Close (per listing market)": os.environ.get('corrected_close'),
    "Regular Sale": os.environ.get('regular_sale'),
    "Acquisition": os.environ.get('acquisition'),
    "Average Price Trade": os.environ.get('average_price_trade'),
    "Automatic Execution": os.environ.get('automatic_execution'),
    "Bunched Trade": os.environ.get('bunched_trade'),
    "Bunched Sold Trade": os.environ.get('bunched_sold_trade'),
    "Cash Sale": os.environ.get('cash_sale'),
    "Closing Prints": os.environ.get('closing_prints'),
    "Cross Trade": os.environ.get('cross_trade'),
    "Derivatively Priced": os.environ.get('derivatively_priced'),
    "Distribution": os.environ.get('distribution'),
    "Form T": os.environ.get('form_t'),
    "Extended Trading Hours (Sold Out of Sequence)": os.environ.get('extended_trading_hours_sold_out_of_sequence'),
    "Intermarket Sweep": os.environ.get('intermarket_sweep'),
    "Market Center Official Close": os.environ.get('market_center_official_close'),
    "Market Center Official Open": os.environ.get('market_center_official_open'),
    "Market Center Opening Trade": os.environ.get('market_center_opening_trade'),
    "Market Center Reopening Trade": os.environ.get('market_center_reopening_trade'),
    "Market Center Closing Trade": os.environ.get('market_center_closing_trade'),
    "Next Day": os.environ.get('next_day'),
    "Price Variation Trade": os.environ.get('price_variation_trade'),
    "Prior Reference Price": os.environ.get('prior_reference_price'),
    "Rule 155 Trade (AMEX)": os.environ.get('rule_155_trade_amex'),
    "Rule 127 NYSE": os.environ.get('rule_127_nyse'),
    "Opening Prints": os.environ.get('opening_prints'),
    "Stopped Stock (Regular Trade)": os.environ.get('stopped_stock_regular_trade'),
    "Re-Opening Prints": os.environ.get('re_opening_prints'),
    "Seller": os.environ.get('seller'),
    "Sold Last": os.environ.get('sold_last'),
    "Sold (out of Sequence)": os.environ.get('sold_out_of_sequence'),
    "Split Trade": os.environ.get('split_trade'),
    "Stock Option Trade": os.environ.get('stock_option_trade'),
    "Yellow Flag Regular Trade": os.environ.get('yellow_flag_regular_trade'),
    "Odd Lot Trade": os.environ.get('odd_lot_trade'),
    "Corrected Consolidated Close (per listing market)": os.environ.get('corrected_consolidated_close_per_listing_market'),
    "Held": os.environ.get('held'),
    "Trade Thru Exempt": os.environ.get('trade_thru_exempt'),
    "Correction": os.environ.get('correction'),
    "Contingent Trade": os.environ.get('contingent_trade'),
    "Qualified Contingent Trade ('QCT')": os.environ.get('qualified_contingent_trade_qct'),
    "Placeholder for 611 exempt": os.environ.get('placeholder_for_611_exempt'),
    "SSR in Effect": os.environ.get('ssr_in_effect')
}