from asyncio import Lock
lock = Lock()
import numpy as np
import pandas as pd
from datetime import datetime
import asyncpg


async def batch_insert_dataframe(self, df, table_name, unique_columns, batch_size=250):
    async with lock:
        if not await self.table_exists(table_name):
            await self.create_table(df, table_name, unique_columns)

        # Debug: Print DataFrame columns before modifications
        #print("Initial DataFrame columns:", df.columns.tolist())
        
        df = df.copy()
        df.dropna(inplace=True)
        df['insertion_timestamp'] = pd.to_datetime([datetime.now() for _ in range(len(df))])


        # Debug: Print DataFrame columns after modifications
        #print("Modified DataFrame columns:", df.columns.tolist())
        
        records = df.to_records(index=False)
        data = list(records)


        async with self.pool.acquire() as connection:
            column_types = await connection.fetch(
                f"SELECT column_name, data_type FROM information_schema.columns WHERE table_name = '{table_name}'"
            )
            type_mapping = {col: next((item['data_type'] for item in column_types if item['column_name'] == col), None) for col in df.columns}

            async with connection.transaction():
                insert_query = f"""
                INSERT INTO {table_name} ({', '.join(f'"{col}"' for col in df.columns)}) 
                VALUES ({', '.join('$' + str(i) for i in range(1, len(df.columns) + 1))})
                ON CONFLICT ({unique_columns})
                DO UPDATE SET {', '.join(f'"{col}" = excluded."{col}"' for col in df.columns)}
                """
        
                batch_data = []
                for record in data:
                    new_record = []
                    for col, val in zip(df.columns, record):
                        if col == 'insertion_timestamp':
                            val = pd.Timestamp(val).to_pydatetime()
                                    
                        pg_type = type_mapping[col]

                        if val is None:
                            new_record.append(None)
                        elif pg_type == 'timestamp' and isinstance(val, np.datetime64):
                            new_record.append(pd.Timestamp(val).to_pydatetime().replace(tzinfo=None))

        
                        elif isinstance(val, datetime):
                            new_record.append(pd.Timestamp(val).to_pydatetime())
                        elif pg_type in ['timestamp', 'timestamp without time zone', 'timestamp with time zone'] and isinstance(val, np.datetime64):
                            new_record.append(pd.Timestamp(val).to_pydatetime().replace(tzinfo=None))  # Modified line
                        elif pg_type in ['double precision', 'real'] and not isinstance(val, str):
                            new_record.append(float(val))
                        elif isinstance(val, np.int64):  # Add this line to handle numpy.int64
                            new_record.append(int(val))
                        elif pg_type == 'integer' and not isinstance(val, int):
                            new_record.append(int(val))
                        else:
                            new_record.append(val)
                
                    batch_data.append(new_record)

                    if len(batch_data) == batch_size:
                        try:
                            
                            
                            await connection.executemany(insert_query, batch_data)
                            batch_data.clear()
                        except Exception as e:
                            print(f"An error occurred while inserting the record: {e}")
                            await connection.execute('ROLLBACK')
                            raise

                if batch_data:  # Don't forget the last batch
    
                    try:
            

                        await connection.executemany(insert_query, batch_data)
                    except Exception as e:
                        print(f"An error occurred while inserting the record: {e}")
                        await connection.execute('ROLLBACK')
                        raise
async def save_to_history(self, df, main_table_name, history_table_name):
    # Assume the DataFrame `df` contains the records to be archived
    if not await self.table_exists(history_table_name):
        await self.create_table(df, history_table_name, None)

    df['archived_at'] = datetime.now()  # Add an 'archived_at' timestamp
    await self.batch_insert_dataframe(df, history_table_name, None)
async def table_exists(self, table_name):
    query = f"SELECT EXISTS (SELECT FROM information_schema.tables WHERE table_name = '{table_name}');"

    async with self.pool.acquire() as conn:
        async with conn.transaction():
            exists = await conn.fetchval(query)
    return exists