# mypy-boto3-quicksight

[![PyPI - mypy-boto3-quicksight](https://img.shields.io/pypi/v/mypy-boto3-quicksight.svg?color=blue)](https://pypi.org/project/mypy-boto3-quicksight)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-quicksight.svg?color=blue)](https://pypi.org/project/mypy-boto3-quicksight)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

Type annotations for
[boto3.QuickSight 1.15.10](https://boto3.amazonaws.com/v1/documentation/api/1.15.10/reference/services/quicksight.html#QuickSight) service
compatible with
[VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright)
and other tools.

Generated by [mypy-boto3-buider 3.1.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

- [mypy-boto3-quicksight](#mypy-boto3-quicksight)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Waiters annotations](#waiters-annotations)
    - [Service Resource annotations](#service-resource-annotations)
    - [Other resources annotations](#other-resources-annotations)
    - [Collections annotations](#collections-annotations)
    - [Typed dictionations](#typed-dictionations)

## How to install

Install `boto3-stubs` for `QuickSight` service.

```bash
python -m pip install boto3-stubs[quicksight]
```

## Usage

### VSCode

- Install [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[quicksight]` in your environment: `python -m pip install 'boto3-stubs[quicksight]'`

Both type checking and auto-complete should work for `QuickSight` service.
No explicit type annotations required, write your `boto3` code as usual.

### PyCharm

- Install `boto-stubs[quicksight]` in your environment: `python -m pip install 'boto3-stubs[quicksight]'`

Both type checking and auto-complete should work for `QuickSight` service.
No explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed `boto3-stubs` submodules.

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything should work.

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[quicksight]` in your environment: `python -m pip install 'boto3-stubs[quicksight]'`
- Run `mypy` as usual

Type checking should work for `QuickSight` service.
No explicit type annotations required, write your `boto3` code as usual.

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[quicksight]` in your environment: `python -m pip install 'boto3-stubs[quicksight]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `QuickSight` service.
No explicit type annotations required, write your `boto3` code as usual.

## Explicit type annotations

### Client annotations

`QuickSightClient` provides annotations for `boto3.client("quicksight")`.

```python
import boto3

from mypy_boto3_quicksight import QuickSightClient

client: QuickSightClient = boto3.client("quicksight")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: QuickSightClient = session.client("quicksight")
```








### Typed dictionations

`mypy_boto3_quicksight.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python
from mypy_boto3_quicksight.type_defs import (
    AccountCustomizationTypeDef,
    AccountSettingsTypeDef,
    ActiveIAMPolicyAssignmentTypeDef,
    AdHocFilteringOptionTypeDef,
    AmazonElasticsearchParametersTypeDef,
    AnalysisErrorTypeDef,
    AnalysisSearchFilterTypeDef,
    AnalysisSourceEntityTypeDef,
    AnalysisSourceTemplateTypeDef,
    AnalysisSummaryTypeDef,
    AnalysisTypeDef,
    AthenaParametersTypeDef,
    AuroraParametersTypeDef,
    AuroraPostgreSqlParametersTypeDef,
    AwsIotAnalyticsParametersTypeDef,
    BorderStyleTypeDef,
    CalculatedColumnTypeDef,
    CancelIngestionResponseTypeDef,
    CastColumnTypeOperationTypeDef,
    ColumnGroupColumnSchemaTypeDef,
    ColumnGroupSchemaTypeDef,
    ColumnGroupTypeDef,
    ColumnSchemaTypeDef,
    ColumnTagTypeDef,
    CreateAccountCustomizationResponseTypeDef,
    CreateAnalysisResponseTypeDef,
    CreateColumnsOperationTypeDef,
    CreateDashboardResponseTypeDef,
    CreateDataSetResponseTypeDef,
    CreateDataSourceResponseTypeDef,
    CreateGroupMembershipResponseTypeDef,
    CreateGroupResponseTypeDef,
    CreateIAMPolicyAssignmentResponseTypeDef,
    CreateIngestionResponseTypeDef,
    CreateNamespaceResponseTypeDef,
    CreateTemplateAliasResponseTypeDef,
    CreateTemplateResponseTypeDef,
    CreateThemeAliasResponseTypeDef,
    CreateThemeResponseTypeDef,
    CredentialPairTypeDef,
    CustomSqlTypeDef,
    DashboardErrorTypeDef,
    DashboardPublishOptionsTypeDef,
    DashboardSearchFilterTypeDef,
    DashboardSourceEntityTypeDef,
    DashboardSourceTemplateTypeDef,
    DashboardSummaryTypeDef,
    DashboardTypeDef,
    DashboardVersionSummaryTypeDef,
    DashboardVersionTypeDef,
    DataColorPaletteTypeDef,
    DataSetConfigurationTypeDef,
    DataSetReferenceTypeDef,
    DataSetSchemaTypeDef,
    DataSetSummaryTypeDef,
    DataSetTypeDef,
    DataSourceCredentialsTypeDef,
    DataSourceErrorInfoTypeDef,
    DataSourceParametersTypeDef,
    DataSourceTypeDef,
    DateTimeParameterTypeDef,
    DecimalParameterTypeDef,
    DeleteAccountCustomizationResponseTypeDef,
    DeleteAnalysisResponseTypeDef,
    DeleteDashboardResponseTypeDef,
    DeleteDataSetResponseTypeDef,
    DeleteDataSourceResponseTypeDef,
    DeleteGroupMembershipResponseTypeDef,
    DeleteGroupResponseTypeDef,
    DeleteIAMPolicyAssignmentResponseTypeDef,
    DeleteNamespaceResponseTypeDef,
    DeleteTemplateAliasResponseTypeDef,
    DeleteTemplateResponseTypeDef,
    DeleteThemeAliasResponseTypeDef,
    DeleteThemeResponseTypeDef,
    DeleteUserByPrincipalIdResponseTypeDef,
    DeleteUserResponseTypeDef,
    DescribeAccountCustomizationResponseTypeDef,
    DescribeAccountSettingsResponseTypeDef,
    DescribeAnalysisPermissionsResponseTypeDef,
    DescribeAnalysisResponseTypeDef,
    DescribeDashboardPermissionsResponseTypeDef,
    DescribeDashboardResponseTypeDef,
    DescribeDataSetPermissionsResponseTypeDef,
    DescribeDataSetResponseTypeDef,
    DescribeDataSourcePermissionsResponseTypeDef,
    DescribeDataSourceResponseTypeDef,
    DescribeGroupResponseTypeDef,
    DescribeIAMPolicyAssignmentResponseTypeDef,
    DescribeIngestionResponseTypeDef,
    DescribeNamespaceResponseTypeDef,
    DescribeTemplateAliasResponseTypeDef,
    DescribeTemplatePermissionsResponseTypeDef,
    DescribeTemplateResponseTypeDef,
    DescribeThemeAliasResponseTypeDef,
    DescribeThemePermissionsResponseTypeDef,
    DescribeThemeResponseTypeDef,
    DescribeUserResponseTypeDef,
    ErrorInfoTypeDef,
    ExportToCSVOptionTypeDef,
    FilterOperationTypeDef,
    GeoSpatialColumnGroupTypeDef,
    GetDashboardEmbedUrlResponseTypeDef,
    GetSessionEmbedUrlResponseTypeDef,
    GroupMemberTypeDef,
    GroupTypeDef,
    GutterStyleTypeDef,
    IAMPolicyAssignmentSummaryTypeDef,
    IAMPolicyAssignmentTypeDef,
    IngestionTypeDef,
    InputColumnTypeDef,
    IntegerParameterTypeDef,
    JiraParametersTypeDef,
    JoinInstructionTypeDef,
    ListAnalysesResponseTypeDef,
    ListDashboardsResponseTypeDef,
    ListDashboardVersionsResponseTypeDef,
    ListDataSetsResponseTypeDef,
    ListDataSourcesResponseTypeDef,
    ListGroupMembershipsResponseTypeDef,
    ListGroupsResponseTypeDef,
    ListIAMPolicyAssignmentsForUserResponseTypeDef,
    ListIAMPolicyAssignmentsResponseTypeDef,
    ListIngestionsResponseTypeDef,
    ListNamespacesResponseTypeDef,
    ListTagsForResourceResponseTypeDef,
    ListTemplateAliasesResponseTypeDef,
    ListTemplatesResponseTypeDef,
    ListTemplateVersionsResponseTypeDef,
    ListThemeAliasesResponseTypeDef,
    ListThemesResponseTypeDef,
    ListThemeVersionsResponseTypeDef,
    ListUserGroupsResponseTypeDef,
    ListUsersResponseTypeDef,
    LogicalTableSourceTypeDef,
    LogicalTableTypeDef,
    ManifestFileLocationTypeDef,
    MarginStyleTypeDef,
    MariaDbParametersTypeDef,
    MySqlParametersTypeDef,
    NamespaceErrorTypeDef,
    NamespaceInfoV2TypeDef,
    OutputColumnTypeDef,
    ParametersTypeDef,
    PhysicalTableTypeDef,
    PostgreSqlParametersTypeDef,
    PrestoParametersTypeDef,
    ProjectOperationTypeDef,
    QueueInfoTypeDef,
    RdsParametersTypeDef,
    RedshiftParametersTypeDef,
    RegisterUserResponseTypeDef,
    RelationalTableTypeDef,
    RenameColumnOperationTypeDef,
    ResourcePermissionTypeDef,
    RestoreAnalysisResponseTypeDef,
    RowInfoTypeDef,
    RowLevelPermissionDataSetTypeDef,
    S3ParametersTypeDef,
    S3SourceTypeDef,
    SearchAnalysesResponseTypeDef,
    SearchDashboardsResponseTypeDef,
    ServiceNowParametersTypeDef,
    SheetControlsOptionTypeDef,
    SheetStyleTypeDef,
    SheetTypeDef,
    SnowflakeParametersTypeDef,
    SparkParametersTypeDef,
    SqlServerParametersTypeDef,
    SslPropertiesTypeDef,
    StringParameterTypeDef,
    TagColumnOperationTypeDef,
    TagResourceResponseTypeDef,
    TagTypeDef,
    TemplateAliasTypeDef,
    TemplateErrorTypeDef,
    TemplateSourceAnalysisTypeDef,
    TemplateSourceEntityTypeDef,
    TemplateSourceTemplateTypeDef,
    TemplateSummaryTypeDef,
    TemplateTypeDef,
    TemplateVersionSummaryTypeDef,
    TemplateVersionTypeDef,
    TeradataParametersTypeDef,
    ThemeAliasTypeDef,
    ThemeConfigurationTypeDef,
    ThemeErrorTypeDef,
    ThemeSummaryTypeDef,
    ThemeTypeDef,
    ThemeVersionSummaryTypeDef,
    ThemeVersionTypeDef,
    TileLayoutStyleTypeDef,
    TileStyleTypeDef,
    TransformOperationTypeDef,
    TwitterParametersTypeDef,
    UIColorPaletteTypeDef,
    UntagResourceResponseTypeDef,
    UpdateAccountCustomizationResponseTypeDef,
    UpdateAccountSettingsResponseTypeDef,
    UpdateAnalysisPermissionsResponseTypeDef,
    UpdateAnalysisResponseTypeDef,
    UpdateDashboardPermissionsResponseTypeDef,
    UpdateDashboardPublishedVersionResponseTypeDef,
    UpdateDashboardResponseTypeDef,
    UpdateDataSetPermissionsResponseTypeDef,
    UpdateDataSetResponseTypeDef,
    UpdateDataSourcePermissionsResponseTypeDef,
    UpdateDataSourceResponseTypeDef,
    UpdateGroupResponseTypeDef,
    UpdateIAMPolicyAssignmentResponseTypeDef,
    UpdateTemplateAliasResponseTypeDef,
    UpdateTemplatePermissionsResponseTypeDef,
    UpdateTemplateResponseTypeDef,
    UpdateThemeAliasResponseTypeDef,
    UpdateThemePermissionsResponseTypeDef,
    UpdateThemeResponseTypeDef,
    UpdateUserResponseTypeDef,
    UploadSettingsTypeDef,
    UserTypeDef,
    VpcConnectionPropertiesTypeDef,
)

def get_structure() -> AccountCustomizationTypeDef:
    return {
      ...
    }
```
