# Generated by Django 4.2.8 on 2024-02-16 05:58

import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import taggit.managers
import utilities.json


class Migration(migrations.Migration):

    dependencies = [
        ('netbox_bgp', '0030_netbox_bgp_comments'),
    ]

    operations = [
        migrations.CreateModel(
            name='CommunityList',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False)),
                ('created', models.DateTimeField(auto_now_add=True, null=True)),
                ('last_updated', models.DateTimeField(auto_now=True, null=True)),
                ('custom_field_data', models.JSONField(blank=True, default=dict, encoder=utilities.json.CustomFieldJSONEncoder)),
                ('name', models.CharField(max_length=100)),
                ('description', models.CharField(blank=True, max_length=200)),
                ('comments', models.TextField(blank=True)),
                ('tags', taggit.managers.TaggableManager(through='extras.TaggedItem', to='extras.Tag')),
            ],
            options={
                'verbose_name_plural': 'Community Lists',
                'unique_together': {('name', 'description')},
            },
        ),
        migrations.AlterField(
            model_name='community',
            name='value',
            field=models.CharField(max_length=64, validators=[django.core.validators.RegexValidator('[\\d\\.\\*]+:[\\d\\.\\*]+')]),
        ),
        migrations.CreateModel(
            name='CommunityListRule',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False)),
                ('created', models.DateTimeField(auto_now_add=True, null=True)),
                ('last_updated', models.DateTimeField(auto_now=True, null=True)),
                ('custom_field_data', models.JSONField(blank=True, default=dict, encoder=utilities.json.CustomFieldJSONEncoder)),
                ('action', models.CharField(max_length=30)),
                ('description', models.CharField(blank=True, max_length=200)),
                ('comments', models.TextField(blank=True)),
                ('community', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='+', to='netbox_bgp.community')),
                ('community_list', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='commlistrules', to='netbox_bgp.communitylist')),
                ('tags', taggit.managers.TaggableManager(through='extras.TaggedItem', to='extras.Tag')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.AddField(
            model_name='routingpolicyrule',
            name='match_community_list',
            field=models.ManyToManyField(blank=True, related_name='cmrules', to='netbox_bgp.communitylist'),
        ),
    ]
