#!/usr/bin/env python
# -*- coding: utf-8 -*-
# @Project      : AI.  @by PyCharm
# @File         : baidu_types
# @Time         : 2024/8/29 09:55
# @Author       : betterme
# @WeChat       : meutils
# @Software     : PyCharm
# @Description  : 

from meutils.pipe import *
from meutils.io.image import image_to_base64

TYPES = {
    "变清晰": "3",
    "去水印": "1",
    "提取线稿": "15",
    "智能抠图": "9",
    # "涂抹消除": "10",
    "涂抹消除": "8",

    "背景替换": "12",  # text: 大雪纷飞，落叶凋零的景象

    "AI扩图": "4",  # ext_ratio: 3:4
    "AI重绘": "6",  # # create_level=2
    "AI相似图": "7",  # create_level=5
    "风格转换": "14",  # style：miyazaki宫崎骏风 clay橡皮泥风  monet油画风
}


class BDAITPZSRequest(BaseModel):
    query: str = 'bdaitpzs百度AI图片助手bdaitpzs'

    picInfo: str = ''  # base64
    picInfo2: str = ''

    text: str = ''
    ext_ratio: str = ''
    expand_zoom: str = ''

    clid: str = ''  # 8201689134272253861
    front_display: str = '2'  # front_display 0
    create_level: str = '0'  # 3

    image_source: str = '1'

    """
    1 AI去水印 
    2 手动去水印
    3 变清晰
    """
    type: str = '1'
    style: str = ''

    original_url: str = ''
    thumb_url: str = ''

    is_first: bool = True

    def __init__(self, /, **data: Any):
        super().__init__(**data)
        if self.picInfo2.startswith('http'):  # mask： todo 放在结构体里
            self.picInfo2 = image_to_base64(self.picInfo2)


# 1:1
PICINFO2_RIGHT_BOTTOM = "data:image/png;base64,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"
if __name__ == '__main__':
    pprint(list(TYPES.keys()))
    print(PICINFO2_RIGHT_BOTTOM)
