# FastAPI Web example Application

This is a simple FastAPI web example application.

## Installation

1. Clone the repository:

   ```bash
   git clone https://github.com/dttctcs/fastapi-rtk.git
   ```

2. Change into the project directory:

   ```bash
   cd your-repo
   ```

3. Create a virtual environment:

   ```bash
   cd py
   python -m venv venv
   ```

4. Activate the virtual environment:

   - On macOS and Linux:

     ```bash
     source venv/bin/activate
     ```

   - On Windows:

     ```bash
     venv\Scripts\activate
     ```

5. Install the dependencies:

   ```bash
   pip install -r requirements.txt
   ```

6. Go to example folder:
   ```
   cd example
   pip install -r requirements.txt
   ```

## Usage

1. Start the FastAPI server:

   ```bash
   fastapi dev app/app.py or python run.py
   ```

2. Open your web browser and visit `http://localhost:8000` to access the application.

3. To open the open api docs, visit `http://localhost:8000/openapi/v1`.

## Contributing

Contributions are welcome! If you find any issues or have suggestions, please open an issue or submit a pull request.

## License

This project is licensed under the [MIT License](LICENSE).
