# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetTrailsResult',
    'AwaitableGetTrailsResult',
    'get_trails',
    'get_trails_output',
]

@pulumi.output_type
class GetTrailsResult:
    """
    A collection of values returned by getTrails.
    """
    def __init__(__self__, actiontrails=None, id=None, ids=None, include_organization_trail=None, include_shadow_trails=None, name_regex=None, names=None, output_file=None, status=None, trails=None):
        if actiontrails and not isinstance(actiontrails, list):
            raise TypeError("Expected argument 'actiontrails' to be a list")
        pulumi.set(__self__, "actiontrails", actiontrails)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if include_organization_trail and not isinstance(include_organization_trail, bool):
            raise TypeError("Expected argument 'include_organization_trail' to be a bool")
        pulumi.set(__self__, "include_organization_trail", include_organization_trail)
        if include_shadow_trails and not isinstance(include_shadow_trails, bool):
            raise TypeError("Expected argument 'include_shadow_trails' to be a bool")
        pulumi.set(__self__, "include_shadow_trails", include_shadow_trails)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if trails and not isinstance(trails, list):
            raise TypeError("Expected argument 'trails' to be a list")
        pulumi.set(__self__, "trails", trails)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'actiontrails' has been deprecated from version 1.95.0. Use 'trails' instead.""")
    def actiontrails(self) -> Sequence['outputs.GetTrailsActiontrailResult']:
        """
        Field `actiontrails` has been deprecated from version 1.95.0. Use `trails` instead."
        """
        return pulumi.get(self, "actiontrails")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        """
        A list of ActionTrail Trail ids. It is the same as trail name.
        """
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter(name="includeOrganizationTrail")
    def include_organization_trail(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "include_organization_trail")

    @_builtins.property
    @pulumi.getter(name="includeShadowTrails")
    def include_shadow_trails(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "include_shadow_trails")

    @_builtins.property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name_regex")

    @_builtins.property
    @pulumi.getter
    def names(self) -> Sequence[_builtins.str]:
        """
        A list of trail names.
        """
        return pulumi.get(self, "names")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        The status of the ActionTrail Trail.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def trails(self) -> Sequence['outputs.GetTrailsTrailResult']:
        """
        A list of ActionTrail Trails. Each element contains the following attributes:
        """
        return pulumi.get(self, "trails")


class AwaitableGetTrailsResult(GetTrailsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTrailsResult(
            actiontrails=self.actiontrails,
            id=self.id,
            ids=self.ids,
            include_organization_trail=self.include_organization_trail,
            include_shadow_trails=self.include_shadow_trails,
            name_regex=self.name_regex,
            names=self.names,
            output_file=self.output_file,
            status=self.status,
            trails=self.trails)


def get_trails(ids: Optional[Sequence[_builtins.str]] = None,
               include_organization_trail: Optional[_builtins.bool] = None,
               include_shadow_trails: Optional[_builtins.bool] = None,
               name_regex: Optional[_builtins.str] = None,
               output_file: Optional[_builtins.str] = None,
               status: Optional[_builtins.str] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTrailsResult:
    """
    This data source provides a list of ActionTrail Trails in an Alibaba Cloud account according to the specified filters.

    > **NOTE:** Available in 1.95.0+

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    default = alicloud.actiontrail.get_trails(name_regex="tf-testacc-actiontrail")
    pulumi.export("trailName", default.trails[0].id)
    ```


    :param Sequence[_builtins.str] ids: A list of ActionTrail Trail IDs. It is the same as trail name.
    :param _builtins.bool include_organization_trail: Whether to show organization tracking. Default to `false`.
    :param _builtins.bool include_shadow_trails: Whether to show shadow tracking. Default to `false`.
    :param _builtins.str name_regex: A regex string to filter results by trail name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str status: Filter the results by status of the ActionTrail Trail. Valid values: `Disable`, `Enable`, `Fresh`.
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['includeOrganizationTrail'] = include_organization_trail
    __args__['includeShadowTrails'] = include_shadow_trails
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['status'] = status
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:actiontrail/getTrails:getTrails', __args__, opts=opts, typ=GetTrailsResult).value

    return AwaitableGetTrailsResult(
        actiontrails=pulumi.get(__ret__, 'actiontrails'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        include_organization_trail=pulumi.get(__ret__, 'include_organization_trail'),
        include_shadow_trails=pulumi.get(__ret__, 'include_shadow_trails'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        names=pulumi.get(__ret__, 'names'),
        output_file=pulumi.get(__ret__, 'output_file'),
        status=pulumi.get(__ret__, 'status'),
        trails=pulumi.get(__ret__, 'trails'))
def get_trails_output(ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                      include_organization_trail: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                      include_shadow_trails: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                      name_regex: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                      output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                      status: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetTrailsResult]:
    """
    This data source provides a list of ActionTrail Trails in an Alibaba Cloud account according to the specified filters.

    > **NOTE:** Available in 1.95.0+

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    default = alicloud.actiontrail.get_trails(name_regex="tf-testacc-actiontrail")
    pulumi.export("trailName", default.trails[0].id)
    ```


    :param Sequence[_builtins.str] ids: A list of ActionTrail Trail IDs. It is the same as trail name.
    :param _builtins.bool include_organization_trail: Whether to show organization tracking. Default to `false`.
    :param _builtins.bool include_shadow_trails: Whether to show shadow tracking. Default to `false`.
    :param _builtins.str name_regex: A regex string to filter results by trail name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str status: Filter the results by status of the ActionTrail Trail. Valid values: `Disable`, `Enable`, `Fresh`.
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['includeOrganizationTrail'] = include_organization_trail
    __args__['includeShadowTrails'] = include_shadow_trails
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['status'] = status
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:actiontrail/getTrails:getTrails', __args__, opts=opts, typ=GetTrailsResult)
    return __ret__.apply(lambda __response__: GetTrailsResult(
        actiontrails=pulumi.get(__response__, 'actiontrails'),
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        include_organization_trail=pulumi.get(__response__, 'include_organization_trail'),
        include_shadow_trails=pulumi.get(__response__, 'include_shadow_trails'),
        name_regex=pulumi.get(__response__, 'name_regex'),
        names=pulumi.get(__response__, 'names'),
        output_file=pulumi.get(__response__, 'output_file'),
        status=pulumi.get(__response__, 'status'),
        trails=pulumi.get(__response__, 'trails')))
