# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['DBClusterLakeVersionArgs', 'DBClusterLakeVersion']

@pulumi.input_type
class DBClusterLakeVersionArgs:
    def __init__(__self__, *,
                 db_cluster_version: pulumi.Input[_builtins.str],
                 payment_type: pulumi.Input[_builtins.str],
                 vpc_id: pulumi.Input[_builtins.str],
                 vswitch_id: pulumi.Input[_builtins.str],
                 zone_id: pulumi.Input[_builtins.str],
                 backup_set_id: Optional[pulumi.Input[_builtins.str]] = None,
                 compute_resource: Optional[pulumi.Input[_builtins.str]] = None,
                 db_cluster_description: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_encryption: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_default_resource_group: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_ssl: Optional[pulumi.Input[_builtins.bool]] = None,
                 kms_id: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 product_form: Optional[pulumi.Input[_builtins.str]] = None,
                 product_version: Optional[pulumi.Input[_builtins.str]] = None,
                 reserved_node_count: Optional[pulumi.Input[_builtins.int]] = None,
                 reserved_node_size: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 restore_to_time: Optional[pulumi.Input[_builtins.str]] = None,
                 restore_type: Optional[pulumi.Input[_builtins.str]] = None,
                 secondary_vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 secondary_zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_ips: Optional[pulumi.Input[_builtins.str]] = None,
                 source_db_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_resource: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a DBClusterLakeVersion resource.
        :param pulumi.Input[_builtins.str] db_cluster_version: The version of the cluster. Valid values: `5.0`.
        :param pulumi.Input[_builtins.str] payment_type: The payment type of the resource. Valid values: `PayAsYouGo`, `Subscription`. **NOTE:** From version 1.245.0, `payment_type` can be set to `Subscription`.
        :param pulumi.Input[_builtins.str] vpc_id: The vpc ID of the resource.
        :param pulumi.Input[_builtins.str] vswitch_id: The ID of the vSwitch.
        :param pulumi.Input[_builtins.str] zone_id: The zone ID of the resource.
        :param pulumi.Input[_builtins.str] backup_set_id: The ID of the backup set that you want to use to restore data.
        :param pulumi.Input[_builtins.str] compute_resource: The computing resources of the cluster.
        :param pulumi.Input[_builtins.str] db_cluster_description: The description of the cluster.
        :param pulumi.Input[_builtins.bool] disk_encryption: Specifies whether to enable disk encryption. Valid values: `true`, `false`.
        :param pulumi.Input[_builtins.bool] enable_default_resource_group: Whether to enable default allocation of resources to user_default resource groups.
        :param pulumi.Input[_builtins.bool] enable_ssl: Specifies whether to enable SSL encryption. Valid values: `true`, `false`.
        :param pulumi.Input[_builtins.str] kms_id: The ID of the key that is used to encrypt disk data. `kms_id` is valid only when `disk_encryption` is set to `true`.
        :param pulumi.Input[_builtins.int] period: The subscription period of the subscription cluster. Valid values: `1` to `9`, `12`, `24`, `36`.
        :param pulumi.Input[_builtins.str] product_form: The product form of the cluster. Valid values:
               - `IntegrationForm`: Integrated.
               - `LegacyForm`: Data Lakehouse Edition.
        :param pulumi.Input[_builtins.str] product_version: The edition of the cluster. Valid values:
               - `BasicVersion`: Basic Edition.
               - `EnterpriseVersion`: Enterprise Edition.
               > **NOTE:** `product_version` must be specified only when `product_form` is set to `IntegrationForm`.
        :param pulumi.Input[_builtins.int] reserved_node_count: The number of reserved resource nodes.
        :param pulumi.Input[_builtins.str] reserved_node_size: The specifications of reserved resource nodes.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[_builtins.str] restore_to_time: The point in time to which you want to restore data from the backup set.
        :param pulumi.Input[_builtins.str] restore_type: The method that you want to use to restore data. Valid values:
        :param pulumi.Input[_builtins.str] secondary_vswitch_id: The ID of the secondary zone.
        :param pulumi.Input[_builtins.str] secondary_zone_id: The ID of the secondary vSwitch.
        :param pulumi.Input[_builtins.str] security_ips: The IP addresses in an IP address whitelist of a cluster. Separate multiple IP addresses with commas (,). You can add a maximum of 500 different IP addresses to a whitelist. The entries in the IP address whitelist must be in one of the following formats:
               - IP addresses, such as 10.23.XX.XX.
               - CIDR blocks, such as 10.23.xx.xx/24. In this example, 24 indicates that the prefix of each IP address in the IP whitelist is 24 bits in length. You can replace 24 with a value within the range of 1 to 32.
        :param pulumi.Input[_builtins.str] source_db_cluster_id: The ID of the source AnalyticDB for MySQL Data Warehouse Edition cluster.
        :param pulumi.Input[_builtins.str] storage_resource: The storage resources of the cluster.
        """
        pulumi.set(__self__, "db_cluster_version", db_cluster_version)
        pulumi.set(__self__, "payment_type", payment_type)
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "vswitch_id", vswitch_id)
        pulumi.set(__self__, "zone_id", zone_id)
        if backup_set_id is not None:
            pulumi.set(__self__, "backup_set_id", backup_set_id)
        if compute_resource is not None:
            pulumi.set(__self__, "compute_resource", compute_resource)
        if db_cluster_description is not None:
            pulumi.set(__self__, "db_cluster_description", db_cluster_description)
        if disk_encryption is not None:
            pulumi.set(__self__, "disk_encryption", disk_encryption)
        if enable_default_resource_group is not None:
            pulumi.set(__self__, "enable_default_resource_group", enable_default_resource_group)
        if enable_ssl is not None:
            pulumi.set(__self__, "enable_ssl", enable_ssl)
        if kms_id is not None:
            pulumi.set(__self__, "kms_id", kms_id)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if product_form is not None:
            pulumi.set(__self__, "product_form", product_form)
        if product_version is not None:
            pulumi.set(__self__, "product_version", product_version)
        if reserved_node_count is not None:
            pulumi.set(__self__, "reserved_node_count", reserved_node_count)
        if reserved_node_size is not None:
            pulumi.set(__self__, "reserved_node_size", reserved_node_size)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if restore_to_time is not None:
            pulumi.set(__self__, "restore_to_time", restore_to_time)
        if restore_type is not None:
            pulumi.set(__self__, "restore_type", restore_type)
        if secondary_vswitch_id is not None:
            pulumi.set(__self__, "secondary_vswitch_id", secondary_vswitch_id)
        if secondary_zone_id is not None:
            pulumi.set(__self__, "secondary_zone_id", secondary_zone_id)
        if security_ips is not None:
            pulumi.set(__self__, "security_ips", security_ips)
        if source_db_cluster_id is not None:
            pulumi.set(__self__, "source_db_cluster_id", source_db_cluster_id)
        if storage_resource is not None:
            pulumi.set(__self__, "storage_resource", storage_resource)

    @_builtins.property
    @pulumi.getter(name="dbClusterVersion")
    def db_cluster_version(self) -> pulumi.Input[_builtins.str]:
        """
        The version of the cluster. Valid values: `5.0`.
        """
        return pulumi.get(self, "db_cluster_version")

    @db_cluster_version.setter
    def db_cluster_version(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "db_cluster_version", value)

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> pulumi.Input[_builtins.str]:
        """
        The payment type of the resource. Valid values: `PayAsYouGo`, `Subscription`. **NOTE:** From version 1.245.0, `payment_type` can be set to `Subscription`.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "payment_type", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[_builtins.str]:
        """
        The vpc ID of the resource.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the vSwitch.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vswitch_id", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Input[_builtins.str]:
        """
        The zone ID of the resource.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "zone_id", value)

    @_builtins.property
    @pulumi.getter(name="backupSetId")
    def backup_set_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the backup set that you want to use to restore data.
        """
        return pulumi.get(self, "backup_set_id")

    @backup_set_id.setter
    def backup_set_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backup_set_id", value)

    @_builtins.property
    @pulumi.getter(name="computeResource")
    def compute_resource(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The computing resources of the cluster.
        """
        return pulumi.get(self, "compute_resource")

    @compute_resource.setter
    def compute_resource(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compute_resource", value)

    @_builtins.property
    @pulumi.getter(name="dbClusterDescription")
    def db_cluster_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the cluster.
        """
        return pulumi.get(self, "db_cluster_description")

    @db_cluster_description.setter
    def db_cluster_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_cluster_description", value)

    @_builtins.property
    @pulumi.getter(name="diskEncryption")
    def disk_encryption(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable disk encryption. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "disk_encryption")

    @disk_encryption.setter
    def disk_encryption(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disk_encryption", value)

    @_builtins.property
    @pulumi.getter(name="enableDefaultResourceGroup")
    def enable_default_resource_group(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable default allocation of resources to user_default resource groups.
        """
        return pulumi.get(self, "enable_default_resource_group")

    @enable_default_resource_group.setter
    def enable_default_resource_group(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_default_resource_group", value)

    @_builtins.property
    @pulumi.getter(name="enableSsl")
    def enable_ssl(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable SSL encryption. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "enable_ssl")

    @enable_ssl.setter
    def enable_ssl(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_ssl", value)

    @_builtins.property
    @pulumi.getter(name="kmsId")
    def kms_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the key that is used to encrypt disk data. `kms_id` is valid only when `disk_encryption` is set to `true`.
        """
        return pulumi.get(self, "kms_id")

    @kms_id.setter
    def kms_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kms_id", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The subscription period of the subscription cluster. Valid values: `1` to `9`, `12`, `24`, `36`.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="productForm")
    def product_form(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The product form of the cluster. Valid values:
        - `IntegrationForm`: Integrated.
        - `LegacyForm`: Data Lakehouse Edition.
        """
        return pulumi.get(self, "product_form")

    @product_form.setter
    def product_form(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "product_form", value)

    @_builtins.property
    @pulumi.getter(name="productVersion")
    def product_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The edition of the cluster. Valid values:
        - `BasicVersion`: Basic Edition.
        - `EnterpriseVersion`: Enterprise Edition.
        > **NOTE:** `product_version` must be specified only when `product_form` is set to `IntegrationForm`.
        """
        return pulumi.get(self, "product_version")

    @product_version.setter
    def product_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "product_version", value)

    @_builtins.property
    @pulumi.getter(name="reservedNodeCount")
    def reserved_node_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of reserved resource nodes.
        """
        return pulumi.get(self, "reserved_node_count")

    @reserved_node_count.setter
    def reserved_node_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "reserved_node_count", value)

    @_builtins.property
    @pulumi.getter(name="reservedNodeSize")
    def reserved_node_size(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The specifications of reserved resource nodes.
        """
        return pulumi.get(self, "reserved_node_size")

    @reserved_node_size.setter
    def reserved_node_size(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "reserved_node_size", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="restoreToTime")
    def restore_to_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The point in time to which you want to restore data from the backup set.
        """
        return pulumi.get(self, "restore_to_time")

    @restore_to_time.setter
    def restore_to_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "restore_to_time", value)

    @_builtins.property
    @pulumi.getter(name="restoreType")
    def restore_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The method that you want to use to restore data. Valid values:
        """
        return pulumi.get(self, "restore_type")

    @restore_type.setter
    def restore_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "restore_type", value)

    @_builtins.property
    @pulumi.getter(name="secondaryVswitchId")
    def secondary_vswitch_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the secondary zone.
        """
        return pulumi.get(self, "secondary_vswitch_id")

    @secondary_vswitch_id.setter
    def secondary_vswitch_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secondary_vswitch_id", value)

    @_builtins.property
    @pulumi.getter(name="secondaryZoneId")
    def secondary_zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the secondary vSwitch.
        """
        return pulumi.get(self, "secondary_zone_id")

    @secondary_zone_id.setter
    def secondary_zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secondary_zone_id", value)

    @_builtins.property
    @pulumi.getter(name="securityIps")
    def security_ips(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IP addresses in an IP address whitelist of a cluster. Separate multiple IP addresses with commas (,). You can add a maximum of 500 different IP addresses to a whitelist. The entries in the IP address whitelist must be in one of the following formats:
        - IP addresses, such as 10.23.XX.XX.
        - CIDR blocks, such as 10.23.xx.xx/24. In this example, 24 indicates that the prefix of each IP address in the IP whitelist is 24 bits in length. You can replace 24 with a value within the range of 1 to 32.
        """
        return pulumi.get(self, "security_ips")

    @security_ips.setter
    def security_ips(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_ips", value)

    @_builtins.property
    @pulumi.getter(name="sourceDbClusterId")
    def source_db_cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the source AnalyticDB for MySQL Data Warehouse Edition cluster.
        """
        return pulumi.get(self, "source_db_cluster_id")

    @source_db_cluster_id.setter
    def source_db_cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_db_cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="storageResource")
    def storage_resource(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The storage resources of the cluster.
        """
        return pulumi.get(self, "storage_resource")

    @storage_resource.setter
    def storage_resource(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_resource", value)


@pulumi.input_type
class _DBClusterLakeVersionState:
    def __init__(__self__, *,
                 backup_set_id: Optional[pulumi.Input[_builtins.str]] = None,
                 commodity_code: Optional[pulumi.Input[_builtins.str]] = None,
                 compute_resource: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_string: Optional[pulumi.Input[_builtins.str]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 db_cluster_description: Optional[pulumi.Input[_builtins.str]] = None,
                 db_cluster_version: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_encryption: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_default_resource_group: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_ssl: Optional[pulumi.Input[_builtins.bool]] = None,
                 engine: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_version: Optional[pulumi.Input[_builtins.str]] = None,
                 expire_time: Optional[pulumi.Input[_builtins.str]] = None,
                 expired: Optional[pulumi.Input[_builtins.bool]] = None,
                 kms_id: Optional[pulumi.Input[_builtins.str]] = None,
                 lock_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 lock_reason: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 port: Optional[pulumi.Input[_builtins.str]] = None,
                 product_form: Optional[pulumi.Input[_builtins.str]] = None,
                 product_version: Optional[pulumi.Input[_builtins.str]] = None,
                 reserved_node_count: Optional[pulumi.Input[_builtins.int]] = None,
                 reserved_node_size: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 restore_to_time: Optional[pulumi.Input[_builtins.str]] = None,
                 restore_type: Optional[pulumi.Input[_builtins.str]] = None,
                 secondary_vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 secondary_zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_ips: Optional[pulumi.Input[_builtins.str]] = None,
                 source_db_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_resource: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering DBClusterLakeVersion resources.
        :param pulumi.Input[_builtins.str] backup_set_id: The ID of the backup set that you want to use to restore data.
        :param pulumi.Input[_builtins.str] commodity_code: The name of the service.
        :param pulumi.Input[_builtins.str] compute_resource: The computing resources of the cluster.
        :param pulumi.Input[_builtins.str] connection_string: The endpoint of the cluster.
        :param pulumi.Input[_builtins.str] create_time: The createTime of the cluster.
        :param pulumi.Input[_builtins.str] db_cluster_description: The description of the cluster.
        :param pulumi.Input[_builtins.str] db_cluster_version: The version of the cluster. Valid values: `5.0`.
        :param pulumi.Input[_builtins.bool] disk_encryption: Specifies whether to enable disk encryption. Valid values: `true`, `false`.
        :param pulumi.Input[_builtins.bool] enable_default_resource_group: Whether to enable default allocation of resources to user_default resource groups.
        :param pulumi.Input[_builtins.bool] enable_ssl: Specifies whether to enable SSL encryption. Valid values: `true`, `false`.
        :param pulumi.Input[_builtins.str] engine: The engine of the database.
        :param pulumi.Input[_builtins.str] engine_version: The engine version of the database.
        :param pulumi.Input[_builtins.str] expire_time: The time when the cluster expires.
        :param pulumi.Input[_builtins.bool] expired: Indicates whether the cluster has expired.
        :param pulumi.Input[_builtins.str] kms_id: The ID of the key that is used to encrypt disk data. `kms_id` is valid only when `disk_encryption` is set to `true`.
        :param pulumi.Input[_builtins.str] lock_mode: The lock mode of the cluster.
        :param pulumi.Input[_builtins.str] lock_reason: The reason why the cluster is locked.
        :param pulumi.Input[_builtins.str] payment_type: The payment type of the resource. Valid values: `PayAsYouGo`, `Subscription`. **NOTE:** From version 1.245.0, `payment_type` can be set to `Subscription`.
        :param pulumi.Input[_builtins.int] period: The subscription period of the subscription cluster. Valid values: `1` to `9`, `12`, `24`, `36`.
        :param pulumi.Input[_builtins.str] port: The port that is used to access the cluster.
        :param pulumi.Input[_builtins.str] product_form: The product form of the cluster. Valid values:
               - `IntegrationForm`: Integrated.
               - `LegacyForm`: Data Lakehouse Edition.
        :param pulumi.Input[_builtins.str] product_version: The edition of the cluster. Valid values:
               - `BasicVersion`: Basic Edition.
               - `EnterpriseVersion`: Enterprise Edition.
               > **NOTE:** `product_version` must be specified only when `product_form` is set to `IntegrationForm`.
        :param pulumi.Input[_builtins.int] reserved_node_count: The number of reserved resource nodes.
        :param pulumi.Input[_builtins.str] reserved_node_size: The specifications of reserved resource nodes.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[_builtins.str] restore_to_time: The point in time to which you want to restore data from the backup set.
        :param pulumi.Input[_builtins.str] restore_type: The method that you want to use to restore data. Valid values:
        :param pulumi.Input[_builtins.str] secondary_vswitch_id: The ID of the secondary zone.
        :param pulumi.Input[_builtins.str] secondary_zone_id: The ID of the secondary vSwitch.
        :param pulumi.Input[_builtins.str] security_ips: The IP addresses in an IP address whitelist of a cluster. Separate multiple IP addresses with commas (,). You can add a maximum of 500 different IP addresses to a whitelist. The entries in the IP address whitelist must be in one of the following formats:
               - IP addresses, such as 10.23.XX.XX.
               - CIDR blocks, such as 10.23.xx.xx/24. In this example, 24 indicates that the prefix of each IP address in the IP whitelist is 24 bits in length. You can replace 24 with a value within the range of 1 to 32.
        :param pulumi.Input[_builtins.str] source_db_cluster_id: The ID of the source AnalyticDB for MySQL Data Warehouse Edition cluster.
        :param pulumi.Input[_builtins.str] status: The status of the resource.
        :param pulumi.Input[_builtins.str] storage_resource: The storage resources of the cluster.
        :param pulumi.Input[_builtins.str] vpc_id: The vpc ID of the resource.
        :param pulumi.Input[_builtins.str] vswitch_id: The ID of the vSwitch.
        :param pulumi.Input[_builtins.str] zone_id: The zone ID of the resource.
        """
        if backup_set_id is not None:
            pulumi.set(__self__, "backup_set_id", backup_set_id)
        if commodity_code is not None:
            pulumi.set(__self__, "commodity_code", commodity_code)
        if compute_resource is not None:
            pulumi.set(__self__, "compute_resource", compute_resource)
        if connection_string is not None:
            pulumi.set(__self__, "connection_string", connection_string)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if db_cluster_description is not None:
            pulumi.set(__self__, "db_cluster_description", db_cluster_description)
        if db_cluster_version is not None:
            pulumi.set(__self__, "db_cluster_version", db_cluster_version)
        if disk_encryption is not None:
            pulumi.set(__self__, "disk_encryption", disk_encryption)
        if enable_default_resource_group is not None:
            pulumi.set(__self__, "enable_default_resource_group", enable_default_resource_group)
        if enable_ssl is not None:
            pulumi.set(__self__, "enable_ssl", enable_ssl)
        if engine is not None:
            pulumi.set(__self__, "engine", engine)
        if engine_version is not None:
            pulumi.set(__self__, "engine_version", engine_version)
        if expire_time is not None:
            pulumi.set(__self__, "expire_time", expire_time)
        if expired is not None:
            pulumi.set(__self__, "expired", expired)
        if kms_id is not None:
            pulumi.set(__self__, "kms_id", kms_id)
        if lock_mode is not None:
            pulumi.set(__self__, "lock_mode", lock_mode)
        if lock_reason is not None:
            pulumi.set(__self__, "lock_reason", lock_reason)
        if payment_type is not None:
            pulumi.set(__self__, "payment_type", payment_type)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if product_form is not None:
            pulumi.set(__self__, "product_form", product_form)
        if product_version is not None:
            pulumi.set(__self__, "product_version", product_version)
        if reserved_node_count is not None:
            pulumi.set(__self__, "reserved_node_count", reserved_node_count)
        if reserved_node_size is not None:
            pulumi.set(__self__, "reserved_node_size", reserved_node_size)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if restore_to_time is not None:
            pulumi.set(__self__, "restore_to_time", restore_to_time)
        if restore_type is not None:
            pulumi.set(__self__, "restore_type", restore_type)
        if secondary_vswitch_id is not None:
            pulumi.set(__self__, "secondary_vswitch_id", secondary_vswitch_id)
        if secondary_zone_id is not None:
            pulumi.set(__self__, "secondary_zone_id", secondary_zone_id)
        if security_ips is not None:
            pulumi.set(__self__, "security_ips", security_ips)
        if source_db_cluster_id is not None:
            pulumi.set(__self__, "source_db_cluster_id", source_db_cluster_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if storage_resource is not None:
            pulumi.set(__self__, "storage_resource", storage_resource)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter(name="backupSetId")
    def backup_set_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the backup set that you want to use to restore data.
        """
        return pulumi.get(self, "backup_set_id")

    @backup_set_id.setter
    def backup_set_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backup_set_id", value)

    @_builtins.property
    @pulumi.getter(name="commodityCode")
    def commodity_code(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the service.
        """
        return pulumi.get(self, "commodity_code")

    @commodity_code.setter
    def commodity_code(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "commodity_code", value)

    @_builtins.property
    @pulumi.getter(name="computeResource")
    def compute_resource(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The computing resources of the cluster.
        """
        return pulumi.get(self, "compute_resource")

    @compute_resource.setter
    def compute_resource(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compute_resource", value)

    @_builtins.property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The endpoint of the cluster.
        """
        return pulumi.get(self, "connection_string")

    @connection_string.setter
    def connection_string(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "connection_string", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The createTime of the cluster.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="dbClusterDescription")
    def db_cluster_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the cluster.
        """
        return pulumi.get(self, "db_cluster_description")

    @db_cluster_description.setter
    def db_cluster_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_cluster_description", value)

    @_builtins.property
    @pulumi.getter(name="dbClusterVersion")
    def db_cluster_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The version of the cluster. Valid values: `5.0`.
        """
        return pulumi.get(self, "db_cluster_version")

    @db_cluster_version.setter
    def db_cluster_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_cluster_version", value)

    @_builtins.property
    @pulumi.getter(name="diskEncryption")
    def disk_encryption(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable disk encryption. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "disk_encryption")

    @disk_encryption.setter
    def disk_encryption(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disk_encryption", value)

    @_builtins.property
    @pulumi.getter(name="enableDefaultResourceGroup")
    def enable_default_resource_group(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable default allocation of resources to user_default resource groups.
        """
        return pulumi.get(self, "enable_default_resource_group")

    @enable_default_resource_group.setter
    def enable_default_resource_group(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_default_resource_group", value)

    @_builtins.property
    @pulumi.getter(name="enableSsl")
    def enable_ssl(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable SSL encryption. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "enable_ssl")

    @enable_ssl.setter
    def enable_ssl(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_ssl", value)

    @_builtins.property
    @pulumi.getter
    def engine(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The engine of the database.
        """
        return pulumi.get(self, "engine")

    @engine.setter
    def engine(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "engine", value)

    @_builtins.property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The engine version of the database.
        """
        return pulumi.get(self, "engine_version")

    @engine_version.setter
    def engine_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "engine_version", value)

    @_builtins.property
    @pulumi.getter(name="expireTime")
    def expire_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time when the cluster expires.
        """
        return pulumi.get(self, "expire_time")

    @expire_time.setter
    def expire_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "expire_time", value)

    @_builtins.property
    @pulumi.getter
    def expired(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether the cluster has expired.
        """
        return pulumi.get(self, "expired")

    @expired.setter
    def expired(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "expired", value)

    @_builtins.property
    @pulumi.getter(name="kmsId")
    def kms_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the key that is used to encrypt disk data. `kms_id` is valid only when `disk_encryption` is set to `true`.
        """
        return pulumi.get(self, "kms_id")

    @kms_id.setter
    def kms_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kms_id", value)

    @_builtins.property
    @pulumi.getter(name="lockMode")
    def lock_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The lock mode of the cluster.
        """
        return pulumi.get(self, "lock_mode")

    @lock_mode.setter
    def lock_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lock_mode", value)

    @_builtins.property
    @pulumi.getter(name="lockReason")
    def lock_reason(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The reason why the cluster is locked.
        """
        return pulumi.get(self, "lock_reason")

    @lock_reason.setter
    def lock_reason(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lock_reason", value)

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The payment type of the resource. Valid values: `PayAsYouGo`, `Subscription`. **NOTE:** From version 1.245.0, `payment_type` can be set to `Subscription`.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "payment_type", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The subscription period of the subscription cluster. Valid values: `1` to `9`, `12`, `24`, `36`.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The port that is used to access the cluster.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter(name="productForm")
    def product_form(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The product form of the cluster. Valid values:
        - `IntegrationForm`: Integrated.
        - `LegacyForm`: Data Lakehouse Edition.
        """
        return pulumi.get(self, "product_form")

    @product_form.setter
    def product_form(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "product_form", value)

    @_builtins.property
    @pulumi.getter(name="productVersion")
    def product_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The edition of the cluster. Valid values:
        - `BasicVersion`: Basic Edition.
        - `EnterpriseVersion`: Enterprise Edition.
        > **NOTE:** `product_version` must be specified only when `product_form` is set to `IntegrationForm`.
        """
        return pulumi.get(self, "product_version")

    @product_version.setter
    def product_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "product_version", value)

    @_builtins.property
    @pulumi.getter(name="reservedNodeCount")
    def reserved_node_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of reserved resource nodes.
        """
        return pulumi.get(self, "reserved_node_count")

    @reserved_node_count.setter
    def reserved_node_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "reserved_node_count", value)

    @_builtins.property
    @pulumi.getter(name="reservedNodeSize")
    def reserved_node_size(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The specifications of reserved resource nodes.
        """
        return pulumi.get(self, "reserved_node_size")

    @reserved_node_size.setter
    def reserved_node_size(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "reserved_node_size", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="restoreToTime")
    def restore_to_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The point in time to which you want to restore data from the backup set.
        """
        return pulumi.get(self, "restore_to_time")

    @restore_to_time.setter
    def restore_to_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "restore_to_time", value)

    @_builtins.property
    @pulumi.getter(name="restoreType")
    def restore_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The method that you want to use to restore data. Valid values:
        """
        return pulumi.get(self, "restore_type")

    @restore_type.setter
    def restore_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "restore_type", value)

    @_builtins.property
    @pulumi.getter(name="secondaryVswitchId")
    def secondary_vswitch_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the secondary zone.
        """
        return pulumi.get(self, "secondary_vswitch_id")

    @secondary_vswitch_id.setter
    def secondary_vswitch_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secondary_vswitch_id", value)

    @_builtins.property
    @pulumi.getter(name="secondaryZoneId")
    def secondary_zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the secondary vSwitch.
        """
        return pulumi.get(self, "secondary_zone_id")

    @secondary_zone_id.setter
    def secondary_zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secondary_zone_id", value)

    @_builtins.property
    @pulumi.getter(name="securityIps")
    def security_ips(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IP addresses in an IP address whitelist of a cluster. Separate multiple IP addresses with commas (,). You can add a maximum of 500 different IP addresses to a whitelist. The entries in the IP address whitelist must be in one of the following formats:
        - IP addresses, such as 10.23.XX.XX.
        - CIDR blocks, such as 10.23.xx.xx/24. In this example, 24 indicates that the prefix of each IP address in the IP whitelist is 24 bits in length. You can replace 24 with a value within the range of 1 to 32.
        """
        return pulumi.get(self, "security_ips")

    @security_ips.setter
    def security_ips(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_ips", value)

    @_builtins.property
    @pulumi.getter(name="sourceDbClusterId")
    def source_db_cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the source AnalyticDB for MySQL Data Warehouse Edition cluster.
        """
        return pulumi.get(self, "source_db_cluster_id")

    @source_db_cluster_id.setter
    def source_db_cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_db_cluster_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the resource.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="storageResource")
    def storage_resource(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The storage resources of the cluster.
        """
        return pulumi.get(self, "storage_resource")

    @storage_resource.setter
    def storage_resource(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_resource", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The vpc ID of the resource.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the vSwitch.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vswitch_id", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The zone ID of the resource.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone_id", value)


@pulumi.type_token("alicloud:adb/dBClusterLakeVersion:DBClusterLakeVersion")
class DBClusterLakeVersion(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backup_set_id: Optional[pulumi.Input[_builtins.str]] = None,
                 compute_resource: Optional[pulumi.Input[_builtins.str]] = None,
                 db_cluster_description: Optional[pulumi.Input[_builtins.str]] = None,
                 db_cluster_version: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_encryption: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_default_resource_group: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_ssl: Optional[pulumi.Input[_builtins.bool]] = None,
                 kms_id: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 product_form: Optional[pulumi.Input[_builtins.str]] = None,
                 product_version: Optional[pulumi.Input[_builtins.str]] = None,
                 reserved_node_count: Optional[pulumi.Input[_builtins.int]] = None,
                 reserved_node_size: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 restore_to_time: Optional[pulumi.Input[_builtins.str]] = None,
                 restore_type: Optional[pulumi.Input[_builtins.str]] = None,
                 secondary_vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 secondary_zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_ips: Optional[pulumi.Input[_builtins.str]] = None,
                 source_db_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_resource: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a AnalyticDB for MySQL (ADB) DB Cluster Lake Version resource.

        For information about AnalyticDB for MySQL (ADB) DB Cluster Lake Version and how to use it, see [What is DB Cluster Lake Version](https://www.alibabacloud.com/help/en/analyticdb-for-mysql/developer-reference/api-adb-2021-12-01-createdbcluster).

        > **NOTE:** Available since v1.190.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default = alicloud.adb.get_zones()
        default_get_networks = alicloud.vpc.get_networks(name_regex="^default-NODELETING$")
        default_get_switches = alicloud.vpc.get_switches(vpc_id=default_get_networks.ids[0],
            zone_id=default.ids[0])
        default_db_cluster_lake_version = alicloud.adb.DBClusterLakeVersion("default",
            db_cluster_version="5.0",
            vpc_id=default_get_networks.ids[0],
            vswitch_id=default_get_switches.ids[0],
            zone_id=default.ids[0],
            compute_resource="16ACU",
            storage_resource="0ACU",
            payment_type="PayAsYouGo",
            enable_default_resource_group=False)
        ```

        ## Import

        AnalyticDB for MySQL (ADB) DB Cluster Lake Version can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:adb/dBClusterLakeVersion:DBClusterLakeVersion example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] backup_set_id: The ID of the backup set that you want to use to restore data.
        :param pulumi.Input[_builtins.str] compute_resource: The computing resources of the cluster.
        :param pulumi.Input[_builtins.str] db_cluster_description: The description of the cluster.
        :param pulumi.Input[_builtins.str] db_cluster_version: The version of the cluster. Valid values: `5.0`.
        :param pulumi.Input[_builtins.bool] disk_encryption: Specifies whether to enable disk encryption. Valid values: `true`, `false`.
        :param pulumi.Input[_builtins.bool] enable_default_resource_group: Whether to enable default allocation of resources to user_default resource groups.
        :param pulumi.Input[_builtins.bool] enable_ssl: Specifies whether to enable SSL encryption. Valid values: `true`, `false`.
        :param pulumi.Input[_builtins.str] kms_id: The ID of the key that is used to encrypt disk data. `kms_id` is valid only when `disk_encryption` is set to `true`.
        :param pulumi.Input[_builtins.str] payment_type: The payment type of the resource. Valid values: `PayAsYouGo`, `Subscription`. **NOTE:** From version 1.245.0, `payment_type` can be set to `Subscription`.
        :param pulumi.Input[_builtins.int] period: The subscription period of the subscription cluster. Valid values: `1` to `9`, `12`, `24`, `36`.
        :param pulumi.Input[_builtins.str] product_form: The product form of the cluster. Valid values:
               - `IntegrationForm`: Integrated.
               - `LegacyForm`: Data Lakehouse Edition.
        :param pulumi.Input[_builtins.str] product_version: The edition of the cluster. Valid values:
               - `BasicVersion`: Basic Edition.
               - `EnterpriseVersion`: Enterprise Edition.
               > **NOTE:** `product_version` must be specified only when `product_form` is set to `IntegrationForm`.
        :param pulumi.Input[_builtins.int] reserved_node_count: The number of reserved resource nodes.
        :param pulumi.Input[_builtins.str] reserved_node_size: The specifications of reserved resource nodes.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[_builtins.str] restore_to_time: The point in time to which you want to restore data from the backup set.
        :param pulumi.Input[_builtins.str] restore_type: The method that you want to use to restore data. Valid values:
        :param pulumi.Input[_builtins.str] secondary_vswitch_id: The ID of the secondary zone.
        :param pulumi.Input[_builtins.str] secondary_zone_id: The ID of the secondary vSwitch.
        :param pulumi.Input[_builtins.str] security_ips: The IP addresses in an IP address whitelist of a cluster. Separate multiple IP addresses with commas (,). You can add a maximum of 500 different IP addresses to a whitelist. The entries in the IP address whitelist must be in one of the following formats:
               - IP addresses, such as 10.23.XX.XX.
               - CIDR blocks, such as 10.23.xx.xx/24. In this example, 24 indicates that the prefix of each IP address in the IP whitelist is 24 bits in length. You can replace 24 with a value within the range of 1 to 32.
        :param pulumi.Input[_builtins.str] source_db_cluster_id: The ID of the source AnalyticDB for MySQL Data Warehouse Edition cluster.
        :param pulumi.Input[_builtins.str] storage_resource: The storage resources of the cluster.
        :param pulumi.Input[_builtins.str] vpc_id: The vpc ID of the resource.
        :param pulumi.Input[_builtins.str] vswitch_id: The ID of the vSwitch.
        :param pulumi.Input[_builtins.str] zone_id: The zone ID of the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DBClusterLakeVersionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a AnalyticDB for MySQL (ADB) DB Cluster Lake Version resource.

        For information about AnalyticDB for MySQL (ADB) DB Cluster Lake Version and how to use it, see [What is DB Cluster Lake Version](https://www.alibabacloud.com/help/en/analyticdb-for-mysql/developer-reference/api-adb-2021-12-01-createdbcluster).

        > **NOTE:** Available since v1.190.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default = alicloud.adb.get_zones()
        default_get_networks = alicloud.vpc.get_networks(name_regex="^default-NODELETING$")
        default_get_switches = alicloud.vpc.get_switches(vpc_id=default_get_networks.ids[0],
            zone_id=default.ids[0])
        default_db_cluster_lake_version = alicloud.adb.DBClusterLakeVersion("default",
            db_cluster_version="5.0",
            vpc_id=default_get_networks.ids[0],
            vswitch_id=default_get_switches.ids[0],
            zone_id=default.ids[0],
            compute_resource="16ACU",
            storage_resource="0ACU",
            payment_type="PayAsYouGo",
            enable_default_resource_group=False)
        ```

        ## Import

        AnalyticDB for MySQL (ADB) DB Cluster Lake Version can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:adb/dBClusterLakeVersion:DBClusterLakeVersion example <id>
        ```

        :param str resource_name: The name of the resource.
        :param DBClusterLakeVersionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DBClusterLakeVersionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backup_set_id: Optional[pulumi.Input[_builtins.str]] = None,
                 compute_resource: Optional[pulumi.Input[_builtins.str]] = None,
                 db_cluster_description: Optional[pulumi.Input[_builtins.str]] = None,
                 db_cluster_version: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_encryption: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_default_resource_group: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_ssl: Optional[pulumi.Input[_builtins.bool]] = None,
                 kms_id: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 product_form: Optional[pulumi.Input[_builtins.str]] = None,
                 product_version: Optional[pulumi.Input[_builtins.str]] = None,
                 reserved_node_count: Optional[pulumi.Input[_builtins.int]] = None,
                 reserved_node_size: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 restore_to_time: Optional[pulumi.Input[_builtins.str]] = None,
                 restore_type: Optional[pulumi.Input[_builtins.str]] = None,
                 secondary_vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 secondary_zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_ips: Optional[pulumi.Input[_builtins.str]] = None,
                 source_db_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_resource: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DBClusterLakeVersionArgs.__new__(DBClusterLakeVersionArgs)

            __props__.__dict__["backup_set_id"] = backup_set_id
            __props__.__dict__["compute_resource"] = compute_resource
            __props__.__dict__["db_cluster_description"] = db_cluster_description
            if db_cluster_version is None and not opts.urn:
                raise TypeError("Missing required property 'db_cluster_version'")
            __props__.__dict__["db_cluster_version"] = db_cluster_version
            __props__.__dict__["disk_encryption"] = disk_encryption
            __props__.__dict__["enable_default_resource_group"] = enable_default_resource_group
            __props__.__dict__["enable_ssl"] = enable_ssl
            __props__.__dict__["kms_id"] = kms_id
            if payment_type is None and not opts.urn:
                raise TypeError("Missing required property 'payment_type'")
            __props__.__dict__["payment_type"] = payment_type
            __props__.__dict__["period"] = period
            __props__.__dict__["product_form"] = product_form
            __props__.__dict__["product_version"] = product_version
            __props__.__dict__["reserved_node_count"] = reserved_node_count
            __props__.__dict__["reserved_node_size"] = reserved_node_size
            __props__.__dict__["resource_group_id"] = resource_group_id
            __props__.__dict__["restore_to_time"] = restore_to_time
            __props__.__dict__["restore_type"] = restore_type
            __props__.__dict__["secondary_vswitch_id"] = secondary_vswitch_id
            __props__.__dict__["secondary_zone_id"] = secondary_zone_id
            __props__.__dict__["security_ips"] = security_ips
            __props__.__dict__["source_db_cluster_id"] = source_db_cluster_id
            __props__.__dict__["storage_resource"] = storage_resource
            if vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_id'")
            __props__.__dict__["vpc_id"] = vpc_id
            if vswitch_id is None and not opts.urn:
                raise TypeError("Missing required property 'vswitch_id'")
            __props__.__dict__["vswitch_id"] = vswitch_id
            if zone_id is None and not opts.urn:
                raise TypeError("Missing required property 'zone_id'")
            __props__.__dict__["zone_id"] = zone_id
            __props__.__dict__["commodity_code"] = None
            __props__.__dict__["connection_string"] = None
            __props__.__dict__["create_time"] = None
            __props__.__dict__["engine"] = None
            __props__.__dict__["engine_version"] = None
            __props__.__dict__["expire_time"] = None
            __props__.__dict__["expired"] = None
            __props__.__dict__["lock_mode"] = None
            __props__.__dict__["lock_reason"] = None
            __props__.__dict__["port"] = None
            __props__.__dict__["status"] = None
        super(DBClusterLakeVersion, __self__).__init__(
            'alicloud:adb/dBClusterLakeVersion:DBClusterLakeVersion',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            backup_set_id: Optional[pulumi.Input[_builtins.str]] = None,
            commodity_code: Optional[pulumi.Input[_builtins.str]] = None,
            compute_resource: Optional[pulumi.Input[_builtins.str]] = None,
            connection_string: Optional[pulumi.Input[_builtins.str]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            db_cluster_description: Optional[pulumi.Input[_builtins.str]] = None,
            db_cluster_version: Optional[pulumi.Input[_builtins.str]] = None,
            disk_encryption: Optional[pulumi.Input[_builtins.bool]] = None,
            enable_default_resource_group: Optional[pulumi.Input[_builtins.bool]] = None,
            enable_ssl: Optional[pulumi.Input[_builtins.bool]] = None,
            engine: Optional[pulumi.Input[_builtins.str]] = None,
            engine_version: Optional[pulumi.Input[_builtins.str]] = None,
            expire_time: Optional[pulumi.Input[_builtins.str]] = None,
            expired: Optional[pulumi.Input[_builtins.bool]] = None,
            kms_id: Optional[pulumi.Input[_builtins.str]] = None,
            lock_mode: Optional[pulumi.Input[_builtins.str]] = None,
            lock_reason: Optional[pulumi.Input[_builtins.str]] = None,
            payment_type: Optional[pulumi.Input[_builtins.str]] = None,
            period: Optional[pulumi.Input[_builtins.int]] = None,
            port: Optional[pulumi.Input[_builtins.str]] = None,
            product_form: Optional[pulumi.Input[_builtins.str]] = None,
            product_version: Optional[pulumi.Input[_builtins.str]] = None,
            reserved_node_count: Optional[pulumi.Input[_builtins.int]] = None,
            reserved_node_size: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            restore_to_time: Optional[pulumi.Input[_builtins.str]] = None,
            restore_type: Optional[pulumi.Input[_builtins.str]] = None,
            secondary_vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
            secondary_zone_id: Optional[pulumi.Input[_builtins.str]] = None,
            security_ips: Optional[pulumi.Input[_builtins.str]] = None,
            source_db_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            storage_resource: Optional[pulumi.Input[_builtins.str]] = None,
            vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
            vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
            zone_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'DBClusterLakeVersion':
        """
        Get an existing DBClusterLakeVersion resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] backup_set_id: The ID of the backup set that you want to use to restore data.
        :param pulumi.Input[_builtins.str] commodity_code: The name of the service.
        :param pulumi.Input[_builtins.str] compute_resource: The computing resources of the cluster.
        :param pulumi.Input[_builtins.str] connection_string: The endpoint of the cluster.
        :param pulumi.Input[_builtins.str] create_time: The createTime of the cluster.
        :param pulumi.Input[_builtins.str] db_cluster_description: The description of the cluster.
        :param pulumi.Input[_builtins.str] db_cluster_version: The version of the cluster. Valid values: `5.0`.
        :param pulumi.Input[_builtins.bool] disk_encryption: Specifies whether to enable disk encryption. Valid values: `true`, `false`.
        :param pulumi.Input[_builtins.bool] enable_default_resource_group: Whether to enable default allocation of resources to user_default resource groups.
        :param pulumi.Input[_builtins.bool] enable_ssl: Specifies whether to enable SSL encryption. Valid values: `true`, `false`.
        :param pulumi.Input[_builtins.str] engine: The engine of the database.
        :param pulumi.Input[_builtins.str] engine_version: The engine version of the database.
        :param pulumi.Input[_builtins.str] expire_time: The time when the cluster expires.
        :param pulumi.Input[_builtins.bool] expired: Indicates whether the cluster has expired.
        :param pulumi.Input[_builtins.str] kms_id: The ID of the key that is used to encrypt disk data. `kms_id` is valid only when `disk_encryption` is set to `true`.
        :param pulumi.Input[_builtins.str] lock_mode: The lock mode of the cluster.
        :param pulumi.Input[_builtins.str] lock_reason: The reason why the cluster is locked.
        :param pulumi.Input[_builtins.str] payment_type: The payment type of the resource. Valid values: `PayAsYouGo`, `Subscription`. **NOTE:** From version 1.245.0, `payment_type` can be set to `Subscription`.
        :param pulumi.Input[_builtins.int] period: The subscription period of the subscription cluster. Valid values: `1` to `9`, `12`, `24`, `36`.
        :param pulumi.Input[_builtins.str] port: The port that is used to access the cluster.
        :param pulumi.Input[_builtins.str] product_form: The product form of the cluster. Valid values:
               - `IntegrationForm`: Integrated.
               - `LegacyForm`: Data Lakehouse Edition.
        :param pulumi.Input[_builtins.str] product_version: The edition of the cluster. Valid values:
               - `BasicVersion`: Basic Edition.
               - `EnterpriseVersion`: Enterprise Edition.
               > **NOTE:** `product_version` must be specified only when `product_form` is set to `IntegrationForm`.
        :param pulumi.Input[_builtins.int] reserved_node_count: The number of reserved resource nodes.
        :param pulumi.Input[_builtins.str] reserved_node_size: The specifications of reserved resource nodes.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[_builtins.str] restore_to_time: The point in time to which you want to restore data from the backup set.
        :param pulumi.Input[_builtins.str] restore_type: The method that you want to use to restore data. Valid values:
        :param pulumi.Input[_builtins.str] secondary_vswitch_id: The ID of the secondary zone.
        :param pulumi.Input[_builtins.str] secondary_zone_id: The ID of the secondary vSwitch.
        :param pulumi.Input[_builtins.str] security_ips: The IP addresses in an IP address whitelist of a cluster. Separate multiple IP addresses with commas (,). You can add a maximum of 500 different IP addresses to a whitelist. The entries in the IP address whitelist must be in one of the following formats:
               - IP addresses, such as 10.23.XX.XX.
               - CIDR blocks, such as 10.23.xx.xx/24. In this example, 24 indicates that the prefix of each IP address in the IP whitelist is 24 bits in length. You can replace 24 with a value within the range of 1 to 32.
        :param pulumi.Input[_builtins.str] source_db_cluster_id: The ID of the source AnalyticDB for MySQL Data Warehouse Edition cluster.
        :param pulumi.Input[_builtins.str] status: The status of the resource.
        :param pulumi.Input[_builtins.str] storage_resource: The storage resources of the cluster.
        :param pulumi.Input[_builtins.str] vpc_id: The vpc ID of the resource.
        :param pulumi.Input[_builtins.str] vswitch_id: The ID of the vSwitch.
        :param pulumi.Input[_builtins.str] zone_id: The zone ID of the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DBClusterLakeVersionState.__new__(_DBClusterLakeVersionState)

        __props__.__dict__["backup_set_id"] = backup_set_id
        __props__.__dict__["commodity_code"] = commodity_code
        __props__.__dict__["compute_resource"] = compute_resource
        __props__.__dict__["connection_string"] = connection_string
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["db_cluster_description"] = db_cluster_description
        __props__.__dict__["db_cluster_version"] = db_cluster_version
        __props__.__dict__["disk_encryption"] = disk_encryption
        __props__.__dict__["enable_default_resource_group"] = enable_default_resource_group
        __props__.__dict__["enable_ssl"] = enable_ssl
        __props__.__dict__["engine"] = engine
        __props__.__dict__["engine_version"] = engine_version
        __props__.__dict__["expire_time"] = expire_time
        __props__.__dict__["expired"] = expired
        __props__.__dict__["kms_id"] = kms_id
        __props__.__dict__["lock_mode"] = lock_mode
        __props__.__dict__["lock_reason"] = lock_reason
        __props__.__dict__["payment_type"] = payment_type
        __props__.__dict__["period"] = period
        __props__.__dict__["port"] = port
        __props__.__dict__["product_form"] = product_form
        __props__.__dict__["product_version"] = product_version
        __props__.__dict__["reserved_node_count"] = reserved_node_count
        __props__.__dict__["reserved_node_size"] = reserved_node_size
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["restore_to_time"] = restore_to_time
        __props__.__dict__["restore_type"] = restore_type
        __props__.__dict__["secondary_vswitch_id"] = secondary_vswitch_id
        __props__.__dict__["secondary_zone_id"] = secondary_zone_id
        __props__.__dict__["security_ips"] = security_ips
        __props__.__dict__["source_db_cluster_id"] = source_db_cluster_id
        __props__.__dict__["status"] = status
        __props__.__dict__["storage_resource"] = storage_resource
        __props__.__dict__["vpc_id"] = vpc_id
        __props__.__dict__["vswitch_id"] = vswitch_id
        __props__.__dict__["zone_id"] = zone_id
        return DBClusterLakeVersion(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="backupSetId")
    def backup_set_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the backup set that you want to use to restore data.
        """
        return pulumi.get(self, "backup_set_id")

    @_builtins.property
    @pulumi.getter(name="commodityCode")
    def commodity_code(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the service.
        """
        return pulumi.get(self, "commodity_code")

    @_builtins.property
    @pulumi.getter(name="computeResource")
    def compute_resource(self) -> pulumi.Output[_builtins.str]:
        """
        The computing resources of the cluster.
        """
        return pulumi.get(self, "compute_resource")

    @_builtins.property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> pulumi.Output[_builtins.str]:
        """
        The endpoint of the cluster.
        """
        return pulumi.get(self, "connection_string")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The createTime of the cluster.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="dbClusterDescription")
    def db_cluster_description(self) -> pulumi.Output[_builtins.str]:
        """
        The description of the cluster.
        """
        return pulumi.get(self, "db_cluster_description")

    @_builtins.property
    @pulumi.getter(name="dbClusterVersion")
    def db_cluster_version(self) -> pulumi.Output[_builtins.str]:
        """
        The version of the cluster. Valid values: `5.0`.
        """
        return pulumi.get(self, "db_cluster_version")

    @_builtins.property
    @pulumi.getter(name="diskEncryption")
    def disk_encryption(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether to enable disk encryption. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "disk_encryption")

    @_builtins.property
    @pulumi.getter(name="enableDefaultResourceGroup")
    def enable_default_resource_group(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to enable default allocation of resources to user_default resource groups.
        """
        return pulumi.get(self, "enable_default_resource_group")

    @_builtins.property
    @pulumi.getter(name="enableSsl")
    def enable_ssl(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether to enable SSL encryption. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "enable_ssl")

    @_builtins.property
    @pulumi.getter
    def engine(self) -> pulumi.Output[_builtins.str]:
        """
        The engine of the database.
        """
        return pulumi.get(self, "engine")

    @_builtins.property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> pulumi.Output[_builtins.str]:
        """
        The engine version of the database.
        """
        return pulumi.get(self, "engine_version")

    @_builtins.property
    @pulumi.getter(name="expireTime")
    def expire_time(self) -> pulumi.Output[_builtins.str]:
        """
        The time when the cluster expires.
        """
        return pulumi.get(self, "expire_time")

    @_builtins.property
    @pulumi.getter
    def expired(self) -> pulumi.Output[_builtins.bool]:
        """
        Indicates whether the cluster has expired.
        """
        return pulumi.get(self, "expired")

    @_builtins.property
    @pulumi.getter(name="kmsId")
    def kms_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the key that is used to encrypt disk data. `kms_id` is valid only when `disk_encryption` is set to `true`.
        """
        return pulumi.get(self, "kms_id")

    @_builtins.property
    @pulumi.getter(name="lockMode")
    def lock_mode(self) -> pulumi.Output[_builtins.str]:
        """
        The lock mode of the cluster.
        """
        return pulumi.get(self, "lock_mode")

    @_builtins.property
    @pulumi.getter(name="lockReason")
    def lock_reason(self) -> pulumi.Output[_builtins.str]:
        """
        The reason why the cluster is locked.
        """
        return pulumi.get(self, "lock_reason")

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> pulumi.Output[_builtins.str]:
        """
        The payment type of the resource. Valid values: `PayAsYouGo`, `Subscription`. **NOTE:** From version 1.245.0, `payment_type` can be set to `Subscription`.
        """
        return pulumi.get(self, "payment_type")

    @_builtins.property
    @pulumi.getter
    def period(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The subscription period of the subscription cluster. Valid values: `1` to `9`, `12`, `24`, `36`.
        """
        return pulumi.get(self, "period")

    @_builtins.property
    @pulumi.getter
    def port(self) -> pulumi.Output[_builtins.str]:
        """
        The port that is used to access the cluster.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="productForm")
    def product_form(self) -> pulumi.Output[_builtins.str]:
        """
        The product form of the cluster. Valid values:
        - `IntegrationForm`: Integrated.
        - `LegacyForm`: Data Lakehouse Edition.
        """
        return pulumi.get(self, "product_form")

    @_builtins.property
    @pulumi.getter(name="productVersion")
    def product_version(self) -> pulumi.Output[_builtins.str]:
        """
        The edition of the cluster. Valid values:
        - `BasicVersion`: Basic Edition.
        - `EnterpriseVersion`: Enterprise Edition.
        > **NOTE:** `product_version` must be specified only when `product_form` is set to `IntegrationForm`.
        """
        return pulumi.get(self, "product_version")

    @_builtins.property
    @pulumi.getter(name="reservedNodeCount")
    def reserved_node_count(self) -> pulumi.Output[_builtins.int]:
        """
        The number of reserved resource nodes.
        """
        return pulumi.get(self, "reserved_node_count")

    @_builtins.property
    @pulumi.getter(name="reservedNodeSize")
    def reserved_node_size(self) -> pulumi.Output[_builtins.str]:
        """
        The specifications of reserved resource nodes.
        """
        return pulumi.get(self, "reserved_node_size")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter(name="restoreToTime")
    def restore_to_time(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The point in time to which you want to restore data from the backup set.
        """
        return pulumi.get(self, "restore_to_time")

    @_builtins.property
    @pulumi.getter(name="restoreType")
    def restore_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The method that you want to use to restore data. Valid values:
        """
        return pulumi.get(self, "restore_type")

    @_builtins.property
    @pulumi.getter(name="secondaryVswitchId")
    def secondary_vswitch_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the secondary zone.
        """
        return pulumi.get(self, "secondary_vswitch_id")

    @_builtins.property
    @pulumi.getter(name="secondaryZoneId")
    def secondary_zone_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the secondary vSwitch.
        """
        return pulumi.get(self, "secondary_zone_id")

    @_builtins.property
    @pulumi.getter(name="securityIps")
    def security_ips(self) -> pulumi.Output[_builtins.str]:
        """
        The IP addresses in an IP address whitelist of a cluster. Separate multiple IP addresses with commas (,). You can add a maximum of 500 different IP addresses to a whitelist. The entries in the IP address whitelist must be in one of the following formats:
        - IP addresses, such as 10.23.XX.XX.
        - CIDR blocks, such as 10.23.xx.xx/24. In this example, 24 indicates that the prefix of each IP address in the IP whitelist is 24 bits in length. You can replace 24 with a value within the range of 1 to 32.
        """
        return pulumi.get(self, "security_ips")

    @_builtins.property
    @pulumi.getter(name="sourceDbClusterId")
    def source_db_cluster_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the source AnalyticDB for MySQL Data Warehouse Edition cluster.
        """
        return pulumi.get(self, "source_db_cluster_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the resource.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="storageResource")
    def storage_resource(self) -> pulumi.Output[_builtins.str]:
        """
        The storage resources of the cluster.
        """
        return pulumi.get(self, "storage_resource")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[_builtins.str]:
        """
        The vpc ID of the resource.
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the vSwitch.
        """
        return pulumi.get(self, "vswitch_id")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[_builtins.str]:
        """
        The zone ID of the resource.
        """
        return pulumi.get(self, "zone_id")

