# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['LoadBalancerAccessLogConfigAttachmentArgs', 'LoadBalancerAccessLogConfigAttachment']

@pulumi.input_type
class LoadBalancerAccessLogConfigAttachmentArgs:
    def __init__(__self__, *,
                 load_balancer_id: pulumi.Input[_builtins.str],
                 log_project: pulumi.Input[_builtins.str],
                 log_store: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a LoadBalancerAccessLogConfigAttachment resource.
        :param pulumi.Input[_builtins.str] load_balancer_id: The ID of the load balancing instance.
        :param pulumi.Input[_builtins.str] log_project: The log items shipped by the access log.
        :param pulumi.Input[_builtins.str] log_store: Logstore for log delivery.
        """
        pulumi.set(__self__, "load_balancer_id", load_balancer_id)
        pulumi.set(__self__, "log_project", log_project)
        pulumi.set(__self__, "log_store", log_store)

    @_builtins.property
    @pulumi.getter(name="loadBalancerId")
    def load_balancer_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the load balancing instance.
        """
        return pulumi.get(self, "load_balancer_id")

    @load_balancer_id.setter
    def load_balancer_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "load_balancer_id", value)

    @_builtins.property
    @pulumi.getter(name="logProject")
    def log_project(self) -> pulumi.Input[_builtins.str]:
        """
        The log items shipped by the access log.
        """
        return pulumi.get(self, "log_project")

    @log_project.setter
    def log_project(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "log_project", value)

    @_builtins.property
    @pulumi.getter(name="logStore")
    def log_store(self) -> pulumi.Input[_builtins.str]:
        """
        Logstore for log delivery.
        """
        return pulumi.get(self, "log_store")

    @log_store.setter
    def log_store(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "log_store", value)


@pulumi.input_type
class _LoadBalancerAccessLogConfigAttachmentState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 load_balancer_id: Optional[pulumi.Input[_builtins.str]] = None,
                 log_project: Optional[pulumi.Input[_builtins.str]] = None,
                 log_store: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering LoadBalancerAccessLogConfigAttachment resources.
        :param pulumi.Input[_builtins.str] create_time: The creation time of the resource
        :param pulumi.Input[_builtins.str] load_balancer_id: The ID of the load balancing instance.
        :param pulumi.Input[_builtins.str] log_project: The log items shipped by the access log.
        :param pulumi.Input[_builtins.str] log_store: Logstore for log delivery.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if load_balancer_id is not None:
            pulumi.set(__self__, "load_balancer_id", load_balancer_id)
        if log_project is not None:
            pulumi.set(__self__, "log_project", log_project)
        if log_store is not None:
            pulumi.set(__self__, "log_store", log_store)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation time of the resource
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="loadBalancerId")
    def load_balancer_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the load balancing instance.
        """
        return pulumi.get(self, "load_balancer_id")

    @load_balancer_id.setter
    def load_balancer_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "load_balancer_id", value)

    @_builtins.property
    @pulumi.getter(name="logProject")
    def log_project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The log items shipped by the access log.
        """
        return pulumi.get(self, "log_project")

    @log_project.setter
    def log_project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "log_project", value)

    @_builtins.property
    @pulumi.getter(name="logStore")
    def log_store(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Logstore for log delivery.
        """
        return pulumi.get(self, "log_store")

    @log_store.setter
    def log_store(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "log_store", value)


@pulumi.type_token("alicloud:alb/loadBalancerAccessLogConfigAttachment:LoadBalancerAccessLogConfigAttachment")
class LoadBalancerAccessLogConfigAttachment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 load_balancer_id: Optional[pulumi.Input[_builtins.str]] = None,
                 log_project: Optional[pulumi.Input[_builtins.str]] = None,
                 log_store: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Application Load Balancer (ALB) Load Balancer Access Log Config Attachment resource.

        Attachment between ALB and AccessLog.

        For information about Application Load Balancer (ALB) Load Balancer Access Log Config Attachment and how to use it, see [What is Load Balancer Access Log Config Attachment](https://www.alibabacloud.com/help/en/slb/application-load-balancer/developer-reference/api-alb-2020-06-16-enableloadbalanceraccesslog).

        > **NOTE:** Available since v1.241.0.

        ## Import

        Application Load Balancer (ALB) Load Balancer Access Log Config Attachment can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:alb/loadBalancerAccessLogConfigAttachment:LoadBalancerAccessLogConfigAttachment example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] load_balancer_id: The ID of the load balancing instance.
        :param pulumi.Input[_builtins.str] log_project: The log items shipped by the access log.
        :param pulumi.Input[_builtins.str] log_store: Logstore for log delivery.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LoadBalancerAccessLogConfigAttachmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Application Load Balancer (ALB) Load Balancer Access Log Config Attachment resource.

        Attachment between ALB and AccessLog.

        For information about Application Load Balancer (ALB) Load Balancer Access Log Config Attachment and how to use it, see [What is Load Balancer Access Log Config Attachment](https://www.alibabacloud.com/help/en/slb/application-load-balancer/developer-reference/api-alb-2020-06-16-enableloadbalanceraccesslog).

        > **NOTE:** Available since v1.241.0.

        ## Import

        Application Load Balancer (ALB) Load Balancer Access Log Config Attachment can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:alb/loadBalancerAccessLogConfigAttachment:LoadBalancerAccessLogConfigAttachment example <id>
        ```

        :param str resource_name: The name of the resource.
        :param LoadBalancerAccessLogConfigAttachmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LoadBalancerAccessLogConfigAttachmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 load_balancer_id: Optional[pulumi.Input[_builtins.str]] = None,
                 log_project: Optional[pulumi.Input[_builtins.str]] = None,
                 log_store: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LoadBalancerAccessLogConfigAttachmentArgs.__new__(LoadBalancerAccessLogConfigAttachmentArgs)

            if load_balancer_id is None and not opts.urn:
                raise TypeError("Missing required property 'load_balancer_id'")
            __props__.__dict__["load_balancer_id"] = load_balancer_id
            if log_project is None and not opts.urn:
                raise TypeError("Missing required property 'log_project'")
            __props__.__dict__["log_project"] = log_project
            if log_store is None and not opts.urn:
                raise TypeError("Missing required property 'log_store'")
            __props__.__dict__["log_store"] = log_store
            __props__.__dict__["create_time"] = None
        super(LoadBalancerAccessLogConfigAttachment, __self__).__init__(
            'alicloud:alb/loadBalancerAccessLogConfigAttachment:LoadBalancerAccessLogConfigAttachment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            load_balancer_id: Optional[pulumi.Input[_builtins.str]] = None,
            log_project: Optional[pulumi.Input[_builtins.str]] = None,
            log_store: Optional[pulumi.Input[_builtins.str]] = None) -> 'LoadBalancerAccessLogConfigAttachment':
        """
        Get an existing LoadBalancerAccessLogConfigAttachment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] create_time: The creation time of the resource
        :param pulumi.Input[_builtins.str] load_balancer_id: The ID of the load balancing instance.
        :param pulumi.Input[_builtins.str] log_project: The log items shipped by the access log.
        :param pulumi.Input[_builtins.str] log_store: Logstore for log delivery.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LoadBalancerAccessLogConfigAttachmentState.__new__(_LoadBalancerAccessLogConfigAttachmentState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["load_balancer_id"] = load_balancer_id
        __props__.__dict__["log_project"] = log_project
        __props__.__dict__["log_store"] = log_store
        return LoadBalancerAccessLogConfigAttachment(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The creation time of the resource
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="loadBalancerId")
    def load_balancer_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the load balancing instance.
        """
        return pulumi.get(self, "load_balancer_id")

    @_builtins.property
    @pulumi.getter(name="logProject")
    def log_project(self) -> pulumi.Output[_builtins.str]:
        """
        The log items shipped by the access log.
        """
        return pulumi.get(self, "log_project")

    @_builtins.property
    @pulumi.getter(name="logStore")
    def log_store(self) -> pulumi.Output[_builtins.str]:
        """
        Logstore for log delivery.
        """
        return pulumi.get(self, "log_store")

