# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetQueuesResult',
    'AwaitableGetQueuesResult',
    'get_queues',
    'get_queues_output',
]

@pulumi.output_type
class GetQueuesResult:
    """
    A collection of values returned by getQueues.
    """
    def __init__(__self__, id=None, ids=None, instance_id=None, name_regex=None, names=None, output_file=None, queues=None, virtual_host_name=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if instance_id and not isinstance(instance_id, str):
            raise TypeError("Expected argument 'instance_id' to be a str")
        pulumi.set(__self__, "instance_id", instance_id)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if queues and not isinstance(queues, list):
            raise TypeError("Expected argument 'queues' to be a list")
        pulumi.set(__self__, "queues", queues)
        if virtual_host_name and not isinstance(virtual_host_name, str):
            raise TypeError("Expected argument 'virtual_host_name' to be a str")
        pulumi.set(__self__, "virtual_host_name", virtual_host_name)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> _builtins.str:
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name_regex")

    @_builtins.property
    @pulumi.getter
    def names(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "names")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")

    @_builtins.property
    @pulumi.getter
    def queues(self) -> Sequence['outputs.GetQueuesQueueResult']:
        return pulumi.get(self, "queues")

    @_builtins.property
    @pulumi.getter(name="virtualHostName")
    def virtual_host_name(self) -> _builtins.str:
        return pulumi.get(self, "virtual_host_name")


class AwaitableGetQueuesResult(GetQueuesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetQueuesResult(
            id=self.id,
            ids=self.ids,
            instance_id=self.instance_id,
            name_regex=self.name_regex,
            names=self.names,
            output_file=self.output_file,
            queues=self.queues,
            virtual_host_name=self.virtual_host_name)


def get_queues(ids: Optional[Sequence[_builtins.str]] = None,
               instance_id: Optional[_builtins.str] = None,
               name_regex: Optional[_builtins.str] = None,
               output_file: Optional[_builtins.str] = None,
               virtual_host_name: Optional[_builtins.str] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetQueuesResult:
    """
    This data source provides the Amqp Queues of the current Alibaba Cloud user.

    > **NOTE:** Available in v1.127.0+.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    ids = alicloud.amqp.get_queues(instance_id="amqp-abc12345",
        virtual_host_name="my-VirtualHost",
        ids=[
            "my-Queue-1",
            "my-Queue-2",
        ])
    pulumi.export("amqpQueueId1", ids.queues[0].id)
    name_regex = alicloud.amqp.get_queues(instance_id="amqp-abc12345",
        virtual_host_name="my-VirtualHost",
        name_regex="^my-Queue")
    pulumi.export("amqpQueueId2", name_regex.queues[0].id)
    ```


    :param Sequence[_builtins.str] ids: A list of Queue IDs. Its element value is same as Queue Name.
    :param _builtins.str instance_id: The ID of the instance.
    :param _builtins.str name_regex: A regex string to filter results by Queue name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str virtual_host_name: The name of the virtual host.
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['instanceId'] = instance_id
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['virtualHostName'] = virtual_host_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:amqp/getQueues:getQueues', __args__, opts=opts, typ=GetQueuesResult).value

    return AwaitableGetQueuesResult(
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        instance_id=pulumi.get(__ret__, 'instance_id'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        names=pulumi.get(__ret__, 'names'),
        output_file=pulumi.get(__ret__, 'output_file'),
        queues=pulumi.get(__ret__, 'queues'),
        virtual_host_name=pulumi.get(__ret__, 'virtual_host_name'))
def get_queues_output(ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                      instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                      name_regex: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                      output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                      virtual_host_name: Optional[pulumi.Input[_builtins.str]] = None,
                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetQueuesResult]:
    """
    This data source provides the Amqp Queues of the current Alibaba Cloud user.

    > **NOTE:** Available in v1.127.0+.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    ids = alicloud.amqp.get_queues(instance_id="amqp-abc12345",
        virtual_host_name="my-VirtualHost",
        ids=[
            "my-Queue-1",
            "my-Queue-2",
        ])
    pulumi.export("amqpQueueId1", ids.queues[0].id)
    name_regex = alicloud.amqp.get_queues(instance_id="amqp-abc12345",
        virtual_host_name="my-VirtualHost",
        name_regex="^my-Queue")
    pulumi.export("amqpQueueId2", name_regex.queues[0].id)
    ```


    :param Sequence[_builtins.str] ids: A list of Queue IDs. Its element value is same as Queue Name.
    :param _builtins.str instance_id: The ID of the instance.
    :param _builtins.str name_regex: A regex string to filter results by Queue name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str virtual_host_name: The name of the virtual host.
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['instanceId'] = instance_id
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['virtualHostName'] = virtual_host_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:amqp/getQueues:getQueues', __args__, opts=opts, typ=GetQueuesResult)
    return __ret__.apply(lambda __response__: GetQueuesResult(
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        instance_id=pulumi.get(__response__, 'instance_id'),
        name_regex=pulumi.get(__response__, 'name_regex'),
        names=pulumi.get(__response__, 'names'),
        output_file=pulumi.get(__response__, 'output_file'),
        queues=pulumi.get(__response__, 'queues'),
        virtual_host_name=pulumi.get(__response__, 'virtual_host_name')))
