# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['InstanceArgs', 'Instance']

@pulumi.input_type
class InstanceArgs:
    def __init__(__self__, *,
                 payment_type: pulumi.Input[_builtins.str],
                 auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 max_connections: Optional[pulumi.Input[_builtins.int]] = None,
                 max_eip_tps: Optional[pulumi.Input[_builtins.str]] = None,
                 max_tps: Optional[pulumi.Input[_builtins.str]] = None,
                 modify_type: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_cycle: Optional[pulumi.Input[_builtins.str]] = None,
                 queue_capacity: Optional[pulumi.Input[_builtins.str]] = None,
                 renewal_duration: Optional[pulumi.Input[_builtins.int]] = None,
                 renewal_duration_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 renewal_status: Optional[pulumi.Input[_builtins.str]] = None,
                 serverless_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_size: Optional[pulumi.Input[_builtins.str]] = None,
                 support_eip: Optional[pulumi.Input[_builtins.bool]] = None,
                 support_tracing: Optional[pulumi.Input[_builtins.bool]] = None,
                 tracing_storage_time: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a Instance resource.
        :param pulumi.Input[_builtins.str] payment_type: The Payment type. Valid value: 
               - Subscription: Pre-paid.
               - PayAsYouGo: Post-paid, and for serverless Edition.
        :param pulumi.Input[_builtins.bool] auto_renew: Renewal method. Automatic renewal: true; Manual renewal: false. When RenewalStatus has a value, the value of RenewalStatus shall prevail.
        :param pulumi.Input[_builtins.str] instance_name: The instance name.
        :param pulumi.Input[_builtins.str] instance_type: Instance type. Valid values: 
               - professional: professional Edition
               - enterprise: enterprise Edition
               - vip: Platinum Edition.
               - serverless: Serverless Edition.
               > **NOTE:** There should not set the `instance_type` parameter when creating a serverless instance. Only need to set `payment_type = "PayAsYouGo"` and `serverless_charge_type = "onDemand"`.
        :param pulumi.Input[_builtins.int] max_connections: The maximum number of connections, according to the value given on the purchase page of the cloud message queue RabbitMQ version console.
        :param pulumi.Input[_builtins.str] max_eip_tps: Peak TPS traffic of the public network, which must be a multiple of 128, unit: times per second.
        :param pulumi.Input[_builtins.str] max_tps: Configure the private network TPS traffic peak, please set the value according to the cloud message queue RabbitMQ version of the console purchase page given.
        :param pulumi.Input[_builtins.str] modify_type: This parameter must be provided while you change the instance specification. Type of instance lifting and lowering:
               - Upgrade: Upgrade
               - Downgrade: Downgrading.
        :param pulumi.Input[_builtins.int] period: Prepayment cycle, unit: periodCycle. This parameter is valid when PaymentType is set to Subscription.
        :param pulumi.Input[_builtins.str] period_cycle: Prepaid cycle units. Value: Month, Year.
        :param pulumi.Input[_builtins.str] queue_capacity: Configure the maximum number of queues. The value range is as follows:  Professional version:[50,1000], minimum modification step size is 5  Enterprise Edition:[200,6000], minimum modification step size is 100  Platinum version:[10000,80000], minimum modification step size is 100.
        :param pulumi.Input[_builtins.int] renewal_duration: The number of automatic renewal cycles.
        :param pulumi.Input[_builtins.str] renewal_duration_unit: Auto-Renewal Cycle Unit Values Include: Month: Month. Year: Years.
        :param pulumi.Input[_builtins.str] renewal_status: The renewal status. Value: AutoRenewal: automatic renewal. ManualRenewal: manual renewal. NotRenewal: no renewal.
        :param pulumi.Input[_builtins.str] serverless_charge_type: The billing type of the serverless instance. Value: onDemand.
        :param pulumi.Input[_builtins.str] storage_size: Configure the message storage space. Unit: GB. The value is as follows:  Professional Edition and Enterprise Edition: Fixed to 0. Description A value of 0 indicates that the Professional Edition and Enterprise Edition instances do not charge storage fees, but do not have storage space. Platinum version example: m × 100, where the value range of m is [7,28].
        :param pulumi.Input[_builtins.bool] support_eip: Whether to support public network.
        :param pulumi.Input[_builtins.bool] support_tracing: Whether to activate the message trace function. The values are as follows:  true: Enable message trace function false: message trace function is not enabled Description The Platinum Edition instance provides the 15-day message trace function free of charge. The trace function can only be enabled and the trace storage duration can only be set to 15 days. For instances of other specifications, you can enable or disable the trace function.
        :param pulumi.Input[_builtins.int] tracing_storage_time: Configure the storage duration of message traces. Unit: Days. The value is as follows:  3:3 days 7:7 days 15:15 days This parameter is valid when SupportTracing is true.
        """
        pulumi.set(__self__, "payment_type", payment_type)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if instance_name is not None:
            pulumi.set(__self__, "instance_name", instance_name)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if max_connections is not None:
            pulumi.set(__self__, "max_connections", max_connections)
        if max_eip_tps is not None:
            pulumi.set(__self__, "max_eip_tps", max_eip_tps)
        if max_tps is not None:
            pulumi.set(__self__, "max_tps", max_tps)
        if modify_type is not None:
            pulumi.set(__self__, "modify_type", modify_type)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_cycle is not None:
            pulumi.set(__self__, "period_cycle", period_cycle)
        if queue_capacity is not None:
            pulumi.set(__self__, "queue_capacity", queue_capacity)
        if renewal_duration is not None:
            pulumi.set(__self__, "renewal_duration", renewal_duration)
        if renewal_duration_unit is not None:
            pulumi.set(__self__, "renewal_duration_unit", renewal_duration_unit)
        if renewal_status is not None:
            pulumi.set(__self__, "renewal_status", renewal_status)
        if serverless_charge_type is not None:
            pulumi.set(__self__, "serverless_charge_type", serverless_charge_type)
        if storage_size is not None:
            pulumi.set(__self__, "storage_size", storage_size)
        if support_eip is not None:
            pulumi.set(__self__, "support_eip", support_eip)
        if support_tracing is not None:
            pulumi.set(__self__, "support_tracing", support_tracing)
        if tracing_storage_time is not None:
            pulumi.set(__self__, "tracing_storage_time", tracing_storage_time)

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> pulumi.Input[_builtins.str]:
        """
        The Payment type. Valid value: 
        - Subscription: Pre-paid.
        - PayAsYouGo: Post-paid, and for serverless Edition.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "payment_type", value)

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Renewal method. Automatic renewal: true; Manual renewal: false. When RenewalStatus has a value, the value of RenewalStatus shall prevail.
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_renew", value)

    @_builtins.property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The instance name.
        """
        return pulumi.get(self, "instance_name")

    @instance_name.setter
    def instance_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_name", value)

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Instance type. Valid values: 
        - professional: professional Edition
        - enterprise: enterprise Edition
        - vip: Platinum Edition.
        - serverless: Serverless Edition.
        > **NOTE:** There should not set the `instance_type` parameter when creating a serverless instance. Only need to set `payment_type = "PayAsYouGo"` and `serverless_charge_type = "onDemand"`.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_type", value)

    @_builtins.property
    @pulumi.getter(name="maxConnections")
    def max_connections(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum number of connections, according to the value given on the purchase page of the cloud message queue RabbitMQ version console.
        """
        return pulumi.get(self, "max_connections")

    @max_connections.setter
    def max_connections(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_connections", value)

    @_builtins.property
    @pulumi.getter(name="maxEipTps")
    def max_eip_tps(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Peak TPS traffic of the public network, which must be a multiple of 128, unit: times per second.
        """
        return pulumi.get(self, "max_eip_tps")

    @max_eip_tps.setter
    def max_eip_tps(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "max_eip_tps", value)

    @_builtins.property
    @pulumi.getter(name="maxTps")
    def max_tps(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Configure the private network TPS traffic peak, please set the value according to the cloud message queue RabbitMQ version of the console purchase page given.
        """
        return pulumi.get(self, "max_tps")

    @max_tps.setter
    def max_tps(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "max_tps", value)

    @_builtins.property
    @pulumi.getter(name="modifyType")
    def modify_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        This parameter must be provided while you change the instance specification. Type of instance lifting and lowering:
        - Upgrade: Upgrade
        - Downgrade: Downgrading.
        """
        return pulumi.get(self, "modify_type")

    @modify_type.setter
    def modify_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "modify_type", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Prepayment cycle, unit: periodCycle. This parameter is valid when PaymentType is set to Subscription.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="periodCycle")
    def period_cycle(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Prepaid cycle units. Value: Month, Year.
        """
        return pulumi.get(self, "period_cycle")

    @period_cycle.setter
    def period_cycle(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "period_cycle", value)

    @_builtins.property
    @pulumi.getter(name="queueCapacity")
    def queue_capacity(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Configure the maximum number of queues. The value range is as follows:  Professional version:[50,1000], minimum modification step size is 5  Enterprise Edition:[200,6000], minimum modification step size is 100  Platinum version:[10000,80000], minimum modification step size is 100.
        """
        return pulumi.get(self, "queue_capacity")

    @queue_capacity.setter
    def queue_capacity(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "queue_capacity", value)

    @_builtins.property
    @pulumi.getter(name="renewalDuration")
    def renewal_duration(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of automatic renewal cycles.
        """
        return pulumi.get(self, "renewal_duration")

    @renewal_duration.setter
    def renewal_duration(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "renewal_duration", value)

    @_builtins.property
    @pulumi.getter(name="renewalDurationUnit")
    def renewal_duration_unit(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Auto-Renewal Cycle Unit Values Include: Month: Month. Year: Years.
        """
        return pulumi.get(self, "renewal_duration_unit")

    @renewal_duration_unit.setter
    def renewal_duration_unit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "renewal_duration_unit", value)

    @_builtins.property
    @pulumi.getter(name="renewalStatus")
    def renewal_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The renewal status. Value: AutoRenewal: automatic renewal. ManualRenewal: manual renewal. NotRenewal: no renewal.
        """
        return pulumi.get(self, "renewal_status")

    @renewal_status.setter
    def renewal_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "renewal_status", value)

    @_builtins.property
    @pulumi.getter(name="serverlessChargeType")
    def serverless_charge_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The billing type of the serverless instance. Value: onDemand.
        """
        return pulumi.get(self, "serverless_charge_type")

    @serverless_charge_type.setter
    def serverless_charge_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "serverless_charge_type", value)

    @_builtins.property
    @pulumi.getter(name="storageSize")
    def storage_size(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Configure the message storage space. Unit: GB. The value is as follows:  Professional Edition and Enterprise Edition: Fixed to 0. Description A value of 0 indicates that the Professional Edition and Enterprise Edition instances do not charge storage fees, but do not have storage space. Platinum version example: m × 100, where the value range of m is [7,28].
        """
        return pulumi.get(self, "storage_size")

    @storage_size.setter
    def storage_size(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_size", value)

    @_builtins.property
    @pulumi.getter(name="supportEip")
    def support_eip(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to support public network.
        """
        return pulumi.get(self, "support_eip")

    @support_eip.setter
    def support_eip(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "support_eip", value)

    @_builtins.property
    @pulumi.getter(name="supportTracing")
    def support_tracing(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to activate the message trace function. The values are as follows:  true: Enable message trace function false: message trace function is not enabled Description The Platinum Edition instance provides the 15-day message trace function free of charge. The trace function can only be enabled and the trace storage duration can only be set to 15 days. For instances of other specifications, you can enable or disable the trace function.
        """
        return pulumi.get(self, "support_tracing")

    @support_tracing.setter
    def support_tracing(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "support_tracing", value)

    @_builtins.property
    @pulumi.getter(name="tracingStorageTime")
    def tracing_storage_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Configure the storage duration of message traces. Unit: Days. The value is as follows:  3:3 days 7:7 days 15:15 days This parameter is valid when SupportTracing is true.
        """
        return pulumi.get(self, "tracing_storage_time")

    @tracing_storage_time.setter
    def tracing_storage_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "tracing_storage_time", value)


@pulumi.input_type
class _InstanceState:
    def __init__(__self__, *,
                 auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
                 create_time: Optional[pulumi.Input[_builtins.int]] = None,
                 instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 max_connections: Optional[pulumi.Input[_builtins.int]] = None,
                 max_eip_tps: Optional[pulumi.Input[_builtins.str]] = None,
                 max_tps: Optional[pulumi.Input[_builtins.str]] = None,
                 modify_type: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_cycle: Optional[pulumi.Input[_builtins.str]] = None,
                 queue_capacity: Optional[pulumi.Input[_builtins.str]] = None,
                 renewal_duration: Optional[pulumi.Input[_builtins.int]] = None,
                 renewal_duration_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 renewal_status: Optional[pulumi.Input[_builtins.str]] = None,
                 serverless_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_size: Optional[pulumi.Input[_builtins.str]] = None,
                 support_eip: Optional[pulumi.Input[_builtins.bool]] = None,
                 support_tracing: Optional[pulumi.Input[_builtins.bool]] = None,
                 tracing_storage_time: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering Instance resources.
        :param pulumi.Input[_builtins.bool] auto_renew: Renewal method. Automatic renewal: true; Manual renewal: false. When RenewalStatus has a value, the value of RenewalStatus shall prevail.
        :param pulumi.Input[_builtins.int] create_time: OrderCreateTime.
        :param pulumi.Input[_builtins.str] instance_name: The instance name.
        :param pulumi.Input[_builtins.str] instance_type: Instance type. Valid values: 
               - professional: professional Edition
               - enterprise: enterprise Edition
               - vip: Platinum Edition.
               - serverless: Serverless Edition.
               > **NOTE:** There should not set the `instance_type` parameter when creating a serverless instance. Only need to set `payment_type = "PayAsYouGo"` and `serverless_charge_type = "onDemand"`.
        :param pulumi.Input[_builtins.int] max_connections: The maximum number of connections, according to the value given on the purchase page of the cloud message queue RabbitMQ version console.
        :param pulumi.Input[_builtins.str] max_eip_tps: Peak TPS traffic of the public network, which must be a multiple of 128, unit: times per second.
        :param pulumi.Input[_builtins.str] max_tps: Configure the private network TPS traffic peak, please set the value according to the cloud message queue RabbitMQ version of the console purchase page given.
        :param pulumi.Input[_builtins.str] modify_type: This parameter must be provided while you change the instance specification. Type of instance lifting and lowering:
               - Upgrade: Upgrade
               - Downgrade: Downgrading.
        :param pulumi.Input[_builtins.str] payment_type: The Payment type. Valid value: 
               - Subscription: Pre-paid.
               - PayAsYouGo: Post-paid, and for serverless Edition.
        :param pulumi.Input[_builtins.int] period: Prepayment cycle, unit: periodCycle. This parameter is valid when PaymentType is set to Subscription.
        :param pulumi.Input[_builtins.str] period_cycle: Prepaid cycle units. Value: Month, Year.
        :param pulumi.Input[_builtins.str] queue_capacity: Configure the maximum number of queues. The value range is as follows:  Professional version:[50,1000], minimum modification step size is 5  Enterprise Edition:[200,6000], minimum modification step size is 100  Platinum version:[10000,80000], minimum modification step size is 100.
        :param pulumi.Input[_builtins.int] renewal_duration: The number of automatic renewal cycles.
        :param pulumi.Input[_builtins.str] renewal_duration_unit: Auto-Renewal Cycle Unit Values Include: Month: Month. Year: Years.
        :param pulumi.Input[_builtins.str] renewal_status: The renewal status. Value: AutoRenewal: automatic renewal. ManualRenewal: manual renewal. NotRenewal: no renewal.
        :param pulumi.Input[_builtins.str] serverless_charge_type: The billing type of the serverless instance. Value: onDemand.
        :param pulumi.Input[_builtins.str] status: The status of the resource.
        :param pulumi.Input[_builtins.str] storage_size: Configure the message storage space. Unit: GB. The value is as follows:  Professional Edition and Enterprise Edition: Fixed to 0. Description A value of 0 indicates that the Professional Edition and Enterprise Edition instances do not charge storage fees, but do not have storage space. Platinum version example: m × 100, where the value range of m is [7,28].
        :param pulumi.Input[_builtins.bool] support_eip: Whether to support public network.
        :param pulumi.Input[_builtins.bool] support_tracing: Whether to activate the message trace function. The values are as follows:  true: Enable message trace function false: message trace function is not enabled Description The Platinum Edition instance provides the 15-day message trace function free of charge. The trace function can only be enabled and the trace storage duration can only be set to 15 days. For instances of other specifications, you can enable or disable the trace function.
        :param pulumi.Input[_builtins.int] tracing_storage_time: Configure the storage duration of message traces. Unit: Days. The value is as follows:  3:3 days 7:7 days 15:15 days This parameter is valid when SupportTracing is true.
        """
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if instance_name is not None:
            pulumi.set(__self__, "instance_name", instance_name)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if max_connections is not None:
            pulumi.set(__self__, "max_connections", max_connections)
        if max_eip_tps is not None:
            pulumi.set(__self__, "max_eip_tps", max_eip_tps)
        if max_tps is not None:
            pulumi.set(__self__, "max_tps", max_tps)
        if modify_type is not None:
            pulumi.set(__self__, "modify_type", modify_type)
        if payment_type is not None:
            pulumi.set(__self__, "payment_type", payment_type)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_cycle is not None:
            pulumi.set(__self__, "period_cycle", period_cycle)
        if queue_capacity is not None:
            pulumi.set(__self__, "queue_capacity", queue_capacity)
        if renewal_duration is not None:
            pulumi.set(__self__, "renewal_duration", renewal_duration)
        if renewal_duration_unit is not None:
            pulumi.set(__self__, "renewal_duration_unit", renewal_duration_unit)
        if renewal_status is not None:
            pulumi.set(__self__, "renewal_status", renewal_status)
        if serverless_charge_type is not None:
            pulumi.set(__self__, "serverless_charge_type", serverless_charge_type)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if storage_size is not None:
            pulumi.set(__self__, "storage_size", storage_size)
        if support_eip is not None:
            pulumi.set(__self__, "support_eip", support_eip)
        if support_tracing is not None:
            pulumi.set(__self__, "support_tracing", support_tracing)
        if tracing_storage_time is not None:
            pulumi.set(__self__, "tracing_storage_time", tracing_storage_time)

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Renewal method. Automatic renewal: true; Manual renewal: false. When RenewalStatus has a value, the value of RenewalStatus shall prevail.
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_renew", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        OrderCreateTime.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The instance name.
        """
        return pulumi.get(self, "instance_name")

    @instance_name.setter
    def instance_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_name", value)

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Instance type. Valid values: 
        - professional: professional Edition
        - enterprise: enterprise Edition
        - vip: Platinum Edition.
        - serverless: Serverless Edition.
        > **NOTE:** There should not set the `instance_type` parameter when creating a serverless instance. Only need to set `payment_type = "PayAsYouGo"` and `serverless_charge_type = "onDemand"`.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_type", value)

    @_builtins.property
    @pulumi.getter(name="maxConnections")
    def max_connections(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum number of connections, according to the value given on the purchase page of the cloud message queue RabbitMQ version console.
        """
        return pulumi.get(self, "max_connections")

    @max_connections.setter
    def max_connections(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_connections", value)

    @_builtins.property
    @pulumi.getter(name="maxEipTps")
    def max_eip_tps(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Peak TPS traffic of the public network, which must be a multiple of 128, unit: times per second.
        """
        return pulumi.get(self, "max_eip_tps")

    @max_eip_tps.setter
    def max_eip_tps(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "max_eip_tps", value)

    @_builtins.property
    @pulumi.getter(name="maxTps")
    def max_tps(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Configure the private network TPS traffic peak, please set the value according to the cloud message queue RabbitMQ version of the console purchase page given.
        """
        return pulumi.get(self, "max_tps")

    @max_tps.setter
    def max_tps(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "max_tps", value)

    @_builtins.property
    @pulumi.getter(name="modifyType")
    def modify_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        This parameter must be provided while you change the instance specification. Type of instance lifting and lowering:
        - Upgrade: Upgrade
        - Downgrade: Downgrading.
        """
        return pulumi.get(self, "modify_type")

    @modify_type.setter
    def modify_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "modify_type", value)

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Payment type. Valid value: 
        - Subscription: Pre-paid.
        - PayAsYouGo: Post-paid, and for serverless Edition.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "payment_type", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Prepayment cycle, unit: periodCycle. This parameter is valid when PaymentType is set to Subscription.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="periodCycle")
    def period_cycle(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Prepaid cycle units. Value: Month, Year.
        """
        return pulumi.get(self, "period_cycle")

    @period_cycle.setter
    def period_cycle(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "period_cycle", value)

    @_builtins.property
    @pulumi.getter(name="queueCapacity")
    def queue_capacity(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Configure the maximum number of queues. The value range is as follows:  Professional version:[50,1000], minimum modification step size is 5  Enterprise Edition:[200,6000], minimum modification step size is 100  Platinum version:[10000,80000], minimum modification step size is 100.
        """
        return pulumi.get(self, "queue_capacity")

    @queue_capacity.setter
    def queue_capacity(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "queue_capacity", value)

    @_builtins.property
    @pulumi.getter(name="renewalDuration")
    def renewal_duration(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of automatic renewal cycles.
        """
        return pulumi.get(self, "renewal_duration")

    @renewal_duration.setter
    def renewal_duration(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "renewal_duration", value)

    @_builtins.property
    @pulumi.getter(name="renewalDurationUnit")
    def renewal_duration_unit(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Auto-Renewal Cycle Unit Values Include: Month: Month. Year: Years.
        """
        return pulumi.get(self, "renewal_duration_unit")

    @renewal_duration_unit.setter
    def renewal_duration_unit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "renewal_duration_unit", value)

    @_builtins.property
    @pulumi.getter(name="renewalStatus")
    def renewal_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The renewal status. Value: AutoRenewal: automatic renewal. ManualRenewal: manual renewal. NotRenewal: no renewal.
        """
        return pulumi.get(self, "renewal_status")

    @renewal_status.setter
    def renewal_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "renewal_status", value)

    @_builtins.property
    @pulumi.getter(name="serverlessChargeType")
    def serverless_charge_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The billing type of the serverless instance. Value: onDemand.
        """
        return pulumi.get(self, "serverless_charge_type")

    @serverless_charge_type.setter
    def serverless_charge_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "serverless_charge_type", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the resource.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="storageSize")
    def storage_size(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Configure the message storage space. Unit: GB. The value is as follows:  Professional Edition and Enterprise Edition: Fixed to 0. Description A value of 0 indicates that the Professional Edition and Enterprise Edition instances do not charge storage fees, but do not have storage space. Platinum version example: m × 100, where the value range of m is [7,28].
        """
        return pulumi.get(self, "storage_size")

    @storage_size.setter
    def storage_size(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_size", value)

    @_builtins.property
    @pulumi.getter(name="supportEip")
    def support_eip(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to support public network.
        """
        return pulumi.get(self, "support_eip")

    @support_eip.setter
    def support_eip(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "support_eip", value)

    @_builtins.property
    @pulumi.getter(name="supportTracing")
    def support_tracing(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to activate the message trace function. The values are as follows:  true: Enable message trace function false: message trace function is not enabled Description The Platinum Edition instance provides the 15-day message trace function free of charge. The trace function can only be enabled and the trace storage duration can only be set to 15 days. For instances of other specifications, you can enable or disable the trace function.
        """
        return pulumi.get(self, "support_tracing")

    @support_tracing.setter
    def support_tracing(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "support_tracing", value)

    @_builtins.property
    @pulumi.getter(name="tracingStorageTime")
    def tracing_storage_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Configure the storage duration of message traces. Unit: Days. The value is as follows:  3:3 days 7:7 days 15:15 days This parameter is valid when SupportTracing is true.
        """
        return pulumi.get(self, "tracing_storage_time")

    @tracing_storage_time.setter
    def tracing_storage_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "tracing_storage_time", value)


@pulumi.type_token("alicloud:amqp/instance:Instance")
class Instance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 max_connections: Optional[pulumi.Input[_builtins.int]] = None,
                 max_eip_tps: Optional[pulumi.Input[_builtins.str]] = None,
                 max_tps: Optional[pulumi.Input[_builtins.str]] = None,
                 modify_type: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_cycle: Optional[pulumi.Input[_builtins.str]] = None,
                 queue_capacity: Optional[pulumi.Input[_builtins.str]] = None,
                 renewal_duration: Optional[pulumi.Input[_builtins.int]] = None,
                 renewal_duration_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 renewal_status: Optional[pulumi.Input[_builtins.str]] = None,
                 serverless_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_size: Optional[pulumi.Input[_builtins.str]] = None,
                 support_eip: Optional[pulumi.Input[_builtins.bool]] = None,
                 support_tracing: Optional[pulumi.Input[_builtins.bool]] = None,
                 tracing_storage_time: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        ## Import

        Amqp Instance can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:amqp/instance:Instance example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] auto_renew: Renewal method. Automatic renewal: true; Manual renewal: false. When RenewalStatus has a value, the value of RenewalStatus shall prevail.
        :param pulumi.Input[_builtins.str] instance_name: The instance name.
        :param pulumi.Input[_builtins.str] instance_type: Instance type. Valid values: 
               - professional: professional Edition
               - enterprise: enterprise Edition
               - vip: Platinum Edition.
               - serverless: Serverless Edition.
               > **NOTE:** There should not set the `instance_type` parameter when creating a serverless instance. Only need to set `payment_type = "PayAsYouGo"` and `serverless_charge_type = "onDemand"`.
        :param pulumi.Input[_builtins.int] max_connections: The maximum number of connections, according to the value given on the purchase page of the cloud message queue RabbitMQ version console.
        :param pulumi.Input[_builtins.str] max_eip_tps: Peak TPS traffic of the public network, which must be a multiple of 128, unit: times per second.
        :param pulumi.Input[_builtins.str] max_tps: Configure the private network TPS traffic peak, please set the value according to the cloud message queue RabbitMQ version of the console purchase page given.
        :param pulumi.Input[_builtins.str] modify_type: This parameter must be provided while you change the instance specification. Type of instance lifting and lowering:
               - Upgrade: Upgrade
               - Downgrade: Downgrading.
        :param pulumi.Input[_builtins.str] payment_type: The Payment type. Valid value: 
               - Subscription: Pre-paid.
               - PayAsYouGo: Post-paid, and for serverless Edition.
        :param pulumi.Input[_builtins.int] period: Prepayment cycle, unit: periodCycle. This parameter is valid when PaymentType is set to Subscription.
        :param pulumi.Input[_builtins.str] period_cycle: Prepaid cycle units. Value: Month, Year.
        :param pulumi.Input[_builtins.str] queue_capacity: Configure the maximum number of queues. The value range is as follows:  Professional version:[50,1000], minimum modification step size is 5  Enterprise Edition:[200,6000], minimum modification step size is 100  Platinum version:[10000,80000], minimum modification step size is 100.
        :param pulumi.Input[_builtins.int] renewal_duration: The number of automatic renewal cycles.
        :param pulumi.Input[_builtins.str] renewal_duration_unit: Auto-Renewal Cycle Unit Values Include: Month: Month. Year: Years.
        :param pulumi.Input[_builtins.str] renewal_status: The renewal status. Value: AutoRenewal: automatic renewal. ManualRenewal: manual renewal. NotRenewal: no renewal.
        :param pulumi.Input[_builtins.str] serverless_charge_type: The billing type of the serverless instance. Value: onDemand.
        :param pulumi.Input[_builtins.str] storage_size: Configure the message storage space. Unit: GB. The value is as follows:  Professional Edition and Enterprise Edition: Fixed to 0. Description A value of 0 indicates that the Professional Edition and Enterprise Edition instances do not charge storage fees, but do not have storage space. Platinum version example: m × 100, where the value range of m is [7,28].
        :param pulumi.Input[_builtins.bool] support_eip: Whether to support public network.
        :param pulumi.Input[_builtins.bool] support_tracing: Whether to activate the message trace function. The values are as follows:  true: Enable message trace function false: message trace function is not enabled Description The Platinum Edition instance provides the 15-day message trace function free of charge. The trace function can only be enabled and the trace storage duration can only be set to 15 days. For instances of other specifications, you can enable or disable the trace function.
        :param pulumi.Input[_builtins.int] tracing_storage_time: Configure the storage duration of message traces. Unit: Days. The value is as follows:  3:3 days 7:7 days 15:15 days This parameter is valid when SupportTracing is true.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        Amqp Instance can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:amqp/instance:Instance example <id>
        ```

        :param str resource_name: The name of the resource.
        :param InstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 max_connections: Optional[pulumi.Input[_builtins.int]] = None,
                 max_eip_tps: Optional[pulumi.Input[_builtins.str]] = None,
                 max_tps: Optional[pulumi.Input[_builtins.str]] = None,
                 modify_type: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_cycle: Optional[pulumi.Input[_builtins.str]] = None,
                 queue_capacity: Optional[pulumi.Input[_builtins.str]] = None,
                 renewal_duration: Optional[pulumi.Input[_builtins.int]] = None,
                 renewal_duration_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 renewal_status: Optional[pulumi.Input[_builtins.str]] = None,
                 serverless_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_size: Optional[pulumi.Input[_builtins.str]] = None,
                 support_eip: Optional[pulumi.Input[_builtins.bool]] = None,
                 support_tracing: Optional[pulumi.Input[_builtins.bool]] = None,
                 tracing_storage_time: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceArgs.__new__(InstanceArgs)

            __props__.__dict__["auto_renew"] = auto_renew
            __props__.__dict__["instance_name"] = instance_name
            __props__.__dict__["instance_type"] = instance_type
            __props__.__dict__["max_connections"] = max_connections
            __props__.__dict__["max_eip_tps"] = max_eip_tps
            __props__.__dict__["max_tps"] = max_tps
            __props__.__dict__["modify_type"] = modify_type
            if payment_type is None and not opts.urn:
                raise TypeError("Missing required property 'payment_type'")
            __props__.__dict__["payment_type"] = payment_type
            __props__.__dict__["period"] = period
            __props__.__dict__["period_cycle"] = period_cycle
            __props__.__dict__["queue_capacity"] = queue_capacity
            __props__.__dict__["renewal_duration"] = renewal_duration
            __props__.__dict__["renewal_duration_unit"] = renewal_duration_unit
            __props__.__dict__["renewal_status"] = renewal_status
            __props__.__dict__["serverless_charge_type"] = serverless_charge_type
            __props__.__dict__["storage_size"] = storage_size
            __props__.__dict__["support_eip"] = support_eip
            __props__.__dict__["support_tracing"] = support_tracing
            __props__.__dict__["tracing_storage_time"] = tracing_storage_time
            __props__.__dict__["create_time"] = None
            __props__.__dict__["status"] = None
        super(Instance, __self__).__init__(
            'alicloud:amqp/instance:Instance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
            create_time: Optional[pulumi.Input[_builtins.int]] = None,
            instance_name: Optional[pulumi.Input[_builtins.str]] = None,
            instance_type: Optional[pulumi.Input[_builtins.str]] = None,
            max_connections: Optional[pulumi.Input[_builtins.int]] = None,
            max_eip_tps: Optional[pulumi.Input[_builtins.str]] = None,
            max_tps: Optional[pulumi.Input[_builtins.str]] = None,
            modify_type: Optional[pulumi.Input[_builtins.str]] = None,
            payment_type: Optional[pulumi.Input[_builtins.str]] = None,
            period: Optional[pulumi.Input[_builtins.int]] = None,
            period_cycle: Optional[pulumi.Input[_builtins.str]] = None,
            queue_capacity: Optional[pulumi.Input[_builtins.str]] = None,
            renewal_duration: Optional[pulumi.Input[_builtins.int]] = None,
            renewal_duration_unit: Optional[pulumi.Input[_builtins.str]] = None,
            renewal_status: Optional[pulumi.Input[_builtins.str]] = None,
            serverless_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            storage_size: Optional[pulumi.Input[_builtins.str]] = None,
            support_eip: Optional[pulumi.Input[_builtins.bool]] = None,
            support_tracing: Optional[pulumi.Input[_builtins.bool]] = None,
            tracing_storage_time: Optional[pulumi.Input[_builtins.int]] = None) -> 'Instance':
        """
        Get an existing Instance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] auto_renew: Renewal method. Automatic renewal: true; Manual renewal: false. When RenewalStatus has a value, the value of RenewalStatus shall prevail.
        :param pulumi.Input[_builtins.int] create_time: OrderCreateTime.
        :param pulumi.Input[_builtins.str] instance_name: The instance name.
        :param pulumi.Input[_builtins.str] instance_type: Instance type. Valid values: 
               - professional: professional Edition
               - enterprise: enterprise Edition
               - vip: Platinum Edition.
               - serverless: Serverless Edition.
               > **NOTE:** There should not set the `instance_type` parameter when creating a serverless instance. Only need to set `payment_type = "PayAsYouGo"` and `serverless_charge_type = "onDemand"`.
        :param pulumi.Input[_builtins.int] max_connections: The maximum number of connections, according to the value given on the purchase page of the cloud message queue RabbitMQ version console.
        :param pulumi.Input[_builtins.str] max_eip_tps: Peak TPS traffic of the public network, which must be a multiple of 128, unit: times per second.
        :param pulumi.Input[_builtins.str] max_tps: Configure the private network TPS traffic peak, please set the value according to the cloud message queue RabbitMQ version of the console purchase page given.
        :param pulumi.Input[_builtins.str] modify_type: This parameter must be provided while you change the instance specification. Type of instance lifting and lowering:
               - Upgrade: Upgrade
               - Downgrade: Downgrading.
        :param pulumi.Input[_builtins.str] payment_type: The Payment type. Valid value: 
               - Subscription: Pre-paid.
               - PayAsYouGo: Post-paid, and for serverless Edition.
        :param pulumi.Input[_builtins.int] period: Prepayment cycle, unit: periodCycle. This parameter is valid when PaymentType is set to Subscription.
        :param pulumi.Input[_builtins.str] period_cycle: Prepaid cycle units. Value: Month, Year.
        :param pulumi.Input[_builtins.str] queue_capacity: Configure the maximum number of queues. The value range is as follows:  Professional version:[50,1000], minimum modification step size is 5  Enterprise Edition:[200,6000], minimum modification step size is 100  Platinum version:[10000,80000], minimum modification step size is 100.
        :param pulumi.Input[_builtins.int] renewal_duration: The number of automatic renewal cycles.
        :param pulumi.Input[_builtins.str] renewal_duration_unit: Auto-Renewal Cycle Unit Values Include: Month: Month. Year: Years.
        :param pulumi.Input[_builtins.str] renewal_status: The renewal status. Value: AutoRenewal: automatic renewal. ManualRenewal: manual renewal. NotRenewal: no renewal.
        :param pulumi.Input[_builtins.str] serverless_charge_type: The billing type of the serverless instance. Value: onDemand.
        :param pulumi.Input[_builtins.str] status: The status of the resource.
        :param pulumi.Input[_builtins.str] storage_size: Configure the message storage space. Unit: GB. The value is as follows:  Professional Edition and Enterprise Edition: Fixed to 0. Description A value of 0 indicates that the Professional Edition and Enterprise Edition instances do not charge storage fees, but do not have storage space. Platinum version example: m × 100, where the value range of m is [7,28].
        :param pulumi.Input[_builtins.bool] support_eip: Whether to support public network.
        :param pulumi.Input[_builtins.bool] support_tracing: Whether to activate the message trace function. The values are as follows:  true: Enable message trace function false: message trace function is not enabled Description The Platinum Edition instance provides the 15-day message trace function free of charge. The trace function can only be enabled and the trace storage duration can only be set to 15 days. For instances of other specifications, you can enable or disable the trace function.
        :param pulumi.Input[_builtins.int] tracing_storage_time: Configure the storage duration of message traces. Unit: Days. The value is as follows:  3:3 days 7:7 days 15:15 days This parameter is valid when SupportTracing is true.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstanceState.__new__(_InstanceState)

        __props__.__dict__["auto_renew"] = auto_renew
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["instance_name"] = instance_name
        __props__.__dict__["instance_type"] = instance_type
        __props__.__dict__["max_connections"] = max_connections
        __props__.__dict__["max_eip_tps"] = max_eip_tps
        __props__.__dict__["max_tps"] = max_tps
        __props__.__dict__["modify_type"] = modify_type
        __props__.__dict__["payment_type"] = payment_type
        __props__.__dict__["period"] = period
        __props__.__dict__["period_cycle"] = period_cycle
        __props__.__dict__["queue_capacity"] = queue_capacity
        __props__.__dict__["renewal_duration"] = renewal_duration
        __props__.__dict__["renewal_duration_unit"] = renewal_duration_unit
        __props__.__dict__["renewal_status"] = renewal_status
        __props__.__dict__["serverless_charge_type"] = serverless_charge_type
        __props__.__dict__["status"] = status
        __props__.__dict__["storage_size"] = storage_size
        __props__.__dict__["support_eip"] = support_eip
        __props__.__dict__["support_tracing"] = support_tracing
        __props__.__dict__["tracing_storage_time"] = tracing_storage_time
        return Instance(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Renewal method. Automatic renewal: true; Manual renewal: false. When RenewalStatus has a value, the value of RenewalStatus shall prevail.
        """
        return pulumi.get(self, "auto_renew")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.int]:
        """
        OrderCreateTime.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> pulumi.Output[_builtins.str]:
        """
        The instance name.
        """
        return pulumi.get(self, "instance_name")

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Output[_builtins.str]:
        """
        Instance type. Valid values: 
        - professional: professional Edition
        - enterprise: enterprise Edition
        - vip: Platinum Edition.
        - serverless: Serverless Edition.
        > **NOTE:** There should not set the `instance_type` parameter when creating a serverless instance. Only need to set `payment_type = "PayAsYouGo"` and `serverless_charge_type = "onDemand"`.
        """
        return pulumi.get(self, "instance_type")

    @_builtins.property
    @pulumi.getter(name="maxConnections")
    def max_connections(self) -> pulumi.Output[_builtins.int]:
        """
        The maximum number of connections, according to the value given on the purchase page of the cloud message queue RabbitMQ version console.
        """
        return pulumi.get(self, "max_connections")

    @_builtins.property
    @pulumi.getter(name="maxEipTps")
    def max_eip_tps(self) -> pulumi.Output[_builtins.str]:
        """
        Peak TPS traffic of the public network, which must be a multiple of 128, unit: times per second.
        """
        return pulumi.get(self, "max_eip_tps")

    @_builtins.property
    @pulumi.getter(name="maxTps")
    def max_tps(self) -> pulumi.Output[_builtins.str]:
        """
        Configure the private network TPS traffic peak, please set the value according to the cloud message queue RabbitMQ version of the console purchase page given.
        """
        return pulumi.get(self, "max_tps")

    @_builtins.property
    @pulumi.getter(name="modifyType")
    def modify_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        This parameter must be provided while you change the instance specification. Type of instance lifting and lowering:
        - Upgrade: Upgrade
        - Downgrade: Downgrading.
        """
        return pulumi.get(self, "modify_type")

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> pulumi.Output[_builtins.str]:
        """
        The Payment type. Valid value: 
        - Subscription: Pre-paid.
        - PayAsYouGo: Post-paid, and for serverless Edition.
        """
        return pulumi.get(self, "payment_type")

    @_builtins.property
    @pulumi.getter
    def period(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Prepayment cycle, unit: periodCycle. This parameter is valid when PaymentType is set to Subscription.
        """
        return pulumi.get(self, "period")

    @_builtins.property
    @pulumi.getter(name="periodCycle")
    def period_cycle(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Prepaid cycle units. Value: Month, Year.
        """
        return pulumi.get(self, "period_cycle")

    @_builtins.property
    @pulumi.getter(name="queueCapacity")
    def queue_capacity(self) -> pulumi.Output[_builtins.str]:
        """
        Configure the maximum number of queues. The value range is as follows:  Professional version:[50,1000], minimum modification step size is 5  Enterprise Edition:[200,6000], minimum modification step size is 100  Platinum version:[10000,80000], minimum modification step size is 100.
        """
        return pulumi.get(self, "queue_capacity")

    @_builtins.property
    @pulumi.getter(name="renewalDuration")
    def renewal_duration(self) -> pulumi.Output[_builtins.int]:
        """
        The number of automatic renewal cycles.
        """
        return pulumi.get(self, "renewal_duration")

    @_builtins.property
    @pulumi.getter(name="renewalDurationUnit")
    def renewal_duration_unit(self) -> pulumi.Output[_builtins.str]:
        """
        Auto-Renewal Cycle Unit Values Include: Month: Month. Year: Years.
        """
        return pulumi.get(self, "renewal_duration_unit")

    @_builtins.property
    @pulumi.getter(name="renewalStatus")
    def renewal_status(self) -> pulumi.Output[_builtins.str]:
        """
        The renewal status. Value: AutoRenewal: automatic renewal. ManualRenewal: manual renewal. NotRenewal: no renewal.
        """
        return pulumi.get(self, "renewal_status")

    @_builtins.property
    @pulumi.getter(name="serverlessChargeType")
    def serverless_charge_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The billing type of the serverless instance. Value: onDemand.
        """
        return pulumi.get(self, "serverless_charge_type")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the resource.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="storageSize")
    def storage_size(self) -> pulumi.Output[_builtins.str]:
        """
        Configure the message storage space. Unit: GB. The value is as follows:  Professional Edition and Enterprise Edition: Fixed to 0. Description A value of 0 indicates that the Professional Edition and Enterprise Edition instances do not charge storage fees, but do not have storage space. Platinum version example: m × 100, where the value range of m is [7,28].
        """
        return pulumi.get(self, "storage_size")

    @_builtins.property
    @pulumi.getter(name="supportEip")
    def support_eip(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to support public network.
        """
        return pulumi.get(self, "support_eip")

    @_builtins.property
    @pulumi.getter(name="supportTracing")
    def support_tracing(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether to activate the message trace function. The values are as follows:  true: Enable message trace function false: message trace function is not enabled Description The Platinum Edition instance provides the 15-day message trace function free of charge. The trace function can only be enabled and the trace storage duration can only be set to 15 days. For instances of other specifications, you can enable or disable the trace function.
        """
        return pulumi.get(self, "support_tracing")

    @_builtins.property
    @pulumi.getter(name="tracingStorageTime")
    def tracing_storage_time(self) -> pulumi.Output[_builtins.int]:
        """
        Configure the storage duration of message traces. Unit: Days. The value is as follows:  3:3 days 7:7 days 15:15 days This parameter is valid when SupportTracing is true.
        """
        return pulumi.get(self, "tracing_storage_time")

