# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetAlertRobotsResult',
    'AwaitableGetAlertRobotsResult',
    'get_alert_robots',
    'get_alert_robots_output',
]

@pulumi.output_type
class GetAlertRobotsResult:
    """
    A collection of values returned by getAlertRobots.
    """
    def __init__(__self__, alert_robot_name=None, id=None, ids=None, name_regex=None, names=None, output_file=None, robot_type=None, robots=None):
        if alert_robot_name and not isinstance(alert_robot_name, str):
            raise TypeError("Expected argument 'alert_robot_name' to be a str")
        pulumi.set(__self__, "alert_robot_name", alert_robot_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if robot_type and not isinstance(robot_type, str):
            raise TypeError("Expected argument 'robot_type' to be a str")
        pulumi.set(__self__, "robot_type", robot_type)
        if robots and not isinstance(robots, list):
            raise TypeError("Expected argument 'robots' to be a list")
        pulumi.set(__self__, "robots", robots)

    @_builtins.property
    @pulumi.getter(name="alertRobotName")
    def alert_robot_name(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "alert_robot_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        """
        A list of Alert Robot IDs.
        """
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name_regex")

    @_builtins.property
    @pulumi.getter
    def names(self) -> Sequence[_builtins.str]:
        """
        A list of Alert Robot names.
        """
        return pulumi.get(self, "names")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")

    @_builtins.property
    @pulumi.getter(name="robotType")
    def robot_type(self) -> Optional[_builtins.str]:
        """
        The type of the robot.
        """
        return pulumi.get(self, "robot_type")

    @_builtins.property
    @pulumi.getter
    def robots(self) -> Sequence['outputs.GetAlertRobotsRobotResult']:
        """
        A list of Arms Alert Robots. Each element contains the following attributes:
        """
        return pulumi.get(self, "robots")


class AwaitableGetAlertRobotsResult(GetAlertRobotsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAlertRobotsResult(
            alert_robot_name=self.alert_robot_name,
            id=self.id,
            ids=self.ids,
            name_regex=self.name_regex,
            names=self.names,
            output_file=self.output_file,
            robot_type=self.robot_type,
            robots=self.robots)


def get_alert_robots(alert_robot_name: Optional[_builtins.str] = None,
                     ids: Optional[Sequence[_builtins.str]] = None,
                     name_regex: Optional[_builtins.str] = None,
                     output_file: Optional[_builtins.str] = None,
                     robot_type: Optional[_builtins.str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAlertRobotsResult:
    """
    This data source provides the Arms Alert Robots of the current Alibaba Cloud user.

    > **NOTE:** Available since v1.237.0.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    default = alicloud.arms.AlertRobot("default",
        alert_robot_name="my-AlertRobot",
        robot_type="wechat",
        robot_addr="https://qyapi.weixin.qq.com/cgi-bin/webhook/send?key=1c704e23")
    name_regex = alicloud.arms.get_alert_robots_output(alert_robot_name=default.alert_robot_name)
    pulumi.export("armsAlertRobotId", name_regex.robots[0].id)
    ```


    :param _builtins.str alert_robot_name: The robot name.
    :param Sequence[_builtins.str] ids: A list of Alert Robot IDs.
    :param _builtins.str name_regex: A regex string to filter results by Alert Robot name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str robot_type: The robot type.
    """
    __args__ = dict()
    __args__['alertRobotName'] = alert_robot_name
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['robotType'] = robot_type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:arms/getAlertRobots:getAlertRobots', __args__, opts=opts, typ=GetAlertRobotsResult).value

    return AwaitableGetAlertRobotsResult(
        alert_robot_name=pulumi.get(__ret__, 'alert_robot_name'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        names=pulumi.get(__ret__, 'names'),
        output_file=pulumi.get(__ret__, 'output_file'),
        robot_type=pulumi.get(__ret__, 'robot_type'),
        robots=pulumi.get(__ret__, 'robots'))
def get_alert_robots_output(alert_robot_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                            name_regex: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            robot_type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAlertRobotsResult]:
    """
    This data source provides the Arms Alert Robots of the current Alibaba Cloud user.

    > **NOTE:** Available since v1.237.0.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    default = alicloud.arms.AlertRobot("default",
        alert_robot_name="my-AlertRobot",
        robot_type="wechat",
        robot_addr="https://qyapi.weixin.qq.com/cgi-bin/webhook/send?key=1c704e23")
    name_regex = alicloud.arms.get_alert_robots_output(alert_robot_name=default.alert_robot_name)
    pulumi.export("armsAlertRobotId", name_regex.robots[0].id)
    ```


    :param _builtins.str alert_robot_name: The robot name.
    :param Sequence[_builtins.str] ids: A list of Alert Robot IDs.
    :param _builtins.str name_regex: A regex string to filter results by Alert Robot name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str robot_type: The robot type.
    """
    __args__ = dict()
    __args__['alertRobotName'] = alert_robot_name
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['robotType'] = robot_type
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:arms/getAlertRobots:getAlertRobots', __args__, opts=opts, typ=GetAlertRobotsResult)
    return __ret__.apply(lambda __response__: GetAlertRobotsResult(
        alert_robot_name=pulumi.get(__response__, 'alert_robot_name'),
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        name_regex=pulumi.get(__response__, 'name_regex'),
        names=pulumi.get(__response__, 'names'),
        output_file=pulumi.get(__response__, 'output_file'),
        robot_type=pulumi.get(__response__, 'robot_type'),
        robots=pulumi.get(__response__, 'robots')))
