# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['StudioApplicationArgs', 'StudioApplication']

@pulumi.input_type
class StudioApplicationArgs:
    def __init__(__self__, *,
                 application_name: pulumi.Input[_builtins.str],
                 template_id: pulumi.Input[_builtins.str],
                 area_id: Optional[pulumi.Input[_builtins.str]] = None,
                 configuration: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 instances: Optional[pulumi.Input[Sequence[pulumi.Input['StudioApplicationInstanceArgs']]]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a StudioApplication resource.
        :param pulumi.Input[_builtins.str] application_name: The name of the application.
        :param pulumi.Input[_builtins.str] template_id: The id of the template.
        :param pulumi.Input[_builtins.str] area_id: The id of the area.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] configuration: The configuration of the application.
        :param pulumi.Input[Sequence[pulumi.Input['StudioApplicationInstanceArgs']]] instances: The instance list. Support the creation of instances in the existing vpc under the application. See the following `Block instances`.
        :param pulumi.Input[_builtins.str] resource_group_id: The id of the resource group.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] variables: The variables of the application.
        """
        pulumi.set(__self__, "application_name", application_name)
        pulumi.set(__self__, "template_id", template_id)
        if area_id is not None:
            pulumi.set(__self__, "area_id", area_id)
        if configuration is not None:
            pulumi.set(__self__, "configuration", configuration)
        if instances is not None:
            pulumi.set(__self__, "instances", instances)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if variables is not None:
            pulumi.set(__self__, "variables", variables)

    @_builtins.property
    @pulumi.getter(name="applicationName")
    def application_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the application.
        """
        return pulumi.get(self, "application_name")

    @application_name.setter
    def application_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "application_name", value)

    @_builtins.property
    @pulumi.getter(name="templateId")
    def template_id(self) -> pulumi.Input[_builtins.str]:
        """
        The id of the template.
        """
        return pulumi.get(self, "template_id")

    @template_id.setter
    def template_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "template_id", value)

    @_builtins.property
    @pulumi.getter(name="areaId")
    def area_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The id of the area.
        """
        return pulumi.get(self, "area_id")

    @area_id.setter
    def area_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "area_id", value)

    @_builtins.property
    @pulumi.getter
    def configuration(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The configuration of the application.
        """
        return pulumi.get(self, "configuration")

    @configuration.setter
    def configuration(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "configuration", value)

    @_builtins.property
    @pulumi.getter
    def instances(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['StudioApplicationInstanceArgs']]]]:
        """
        The instance list. Support the creation of instances in the existing vpc under the application. See the following `Block instances`.
        """
        return pulumi.get(self, "instances")

    @instances.setter
    def instances(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['StudioApplicationInstanceArgs']]]]):
        pulumi.set(self, "instances", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The id of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter
    def variables(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The variables of the application.
        """
        return pulumi.get(self, "variables")

    @variables.setter
    def variables(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "variables", value)


@pulumi.input_type
class _StudioApplicationState:
    def __init__(__self__, *,
                 application_name: Optional[pulumi.Input[_builtins.str]] = None,
                 area_id: Optional[pulumi.Input[_builtins.str]] = None,
                 configuration: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 instances: Optional[pulumi.Input[Sequence[pulumi.Input['StudioApplicationInstanceArgs']]]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 template_id: Optional[pulumi.Input[_builtins.str]] = None,
                 variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering StudioApplication resources.
        :param pulumi.Input[_builtins.str] application_name: The name of the application.
        :param pulumi.Input[_builtins.str] area_id: The id of the area.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] configuration: The configuration of the application.
        :param pulumi.Input[Sequence[pulumi.Input['StudioApplicationInstanceArgs']]] instances: The instance list. Support the creation of instances in the existing vpc under the application. See the following `Block instances`.
        :param pulumi.Input[_builtins.str] resource_group_id: The id of the resource group.
        :param pulumi.Input[_builtins.str] status: The status of the Application.
        :param pulumi.Input[_builtins.str] template_id: The id of the template.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] variables: The variables of the application.
        """
        if application_name is not None:
            pulumi.set(__self__, "application_name", application_name)
        if area_id is not None:
            pulumi.set(__self__, "area_id", area_id)
        if configuration is not None:
            pulumi.set(__self__, "configuration", configuration)
        if instances is not None:
            pulumi.set(__self__, "instances", instances)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if template_id is not None:
            pulumi.set(__self__, "template_id", template_id)
        if variables is not None:
            pulumi.set(__self__, "variables", variables)

    @_builtins.property
    @pulumi.getter(name="applicationName")
    def application_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the application.
        """
        return pulumi.get(self, "application_name")

    @application_name.setter
    def application_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "application_name", value)

    @_builtins.property
    @pulumi.getter(name="areaId")
    def area_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The id of the area.
        """
        return pulumi.get(self, "area_id")

    @area_id.setter
    def area_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "area_id", value)

    @_builtins.property
    @pulumi.getter
    def configuration(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The configuration of the application.
        """
        return pulumi.get(self, "configuration")

    @configuration.setter
    def configuration(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "configuration", value)

    @_builtins.property
    @pulumi.getter
    def instances(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['StudioApplicationInstanceArgs']]]]:
        """
        The instance list. Support the creation of instances in the existing vpc under the application. See the following `Block instances`.
        """
        return pulumi.get(self, "instances")

    @instances.setter
    def instances(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['StudioApplicationInstanceArgs']]]]):
        pulumi.set(self, "instances", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The id of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the Application.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="templateId")
    def template_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The id of the template.
        """
        return pulumi.get(self, "template_id")

    @template_id.setter
    def template_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "template_id", value)

    @_builtins.property
    @pulumi.getter
    def variables(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The variables of the application.
        """
        return pulumi.get(self, "variables")

    @variables.setter
    def variables(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "variables", value)


@pulumi.type_token("alicloud:bp/studioApplication:StudioApplication")
class StudioApplication(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_name: Optional[pulumi.Input[_builtins.str]] = None,
                 area_id: Optional[pulumi.Input[_builtins.str]] = None,
                 configuration: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 instances: Optional[pulumi.Input[Sequence[pulumi.Input[Union['StudioApplicationInstanceArgs', 'StudioApplicationInstanceArgsDict']]]]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 template_id: Optional[pulumi.Input[_builtins.str]] = None,
                 variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Provides a Cloud Architect Design Tools Application resource.

        For information about Cloud Architect Design Tools Application and how to use it, see [What is Application](https://help.aliyun.com/document_detail/428263.html).

        > **NOTE:** Available since v1.192.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default = alicloud.resourcemanager.get_resource_groups()
        default_get_instances = alicloud.ecs.get_instances(status="Running")
        default_studio_application = alicloud.bp.StudioApplication("default",
            application_name=name,
            template_id="YAUUQIYRSV1CMFGX",
            resource_group_id=default.groups[0].id,
            area_id="cn-hangzhou",
            instances=[{
                "id": "data.alicloud_instances.default.instances.0.id",
                "node_name": "data.alicloud_instances.default.instances.0.name",
                "node_type": "ecs",
            }],
            configuration={
                "enableMonitor": "1",
            },
            variables={
                "test": "1",
            })
        ```

        ## Import

        Cloud Architect Design Tools Application can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:bp/studioApplication:StudioApplication example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] application_name: The name of the application.
        :param pulumi.Input[_builtins.str] area_id: The id of the area.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] configuration: The configuration of the application.
        :param pulumi.Input[Sequence[pulumi.Input[Union['StudioApplicationInstanceArgs', 'StudioApplicationInstanceArgsDict']]]] instances: The instance list. Support the creation of instances in the existing vpc under the application. See the following `Block instances`.
        :param pulumi.Input[_builtins.str] resource_group_id: The id of the resource group.
        :param pulumi.Input[_builtins.str] template_id: The id of the template.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] variables: The variables of the application.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: StudioApplicationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Cloud Architect Design Tools Application resource.

        For information about Cloud Architect Design Tools Application and how to use it, see [What is Application](https://help.aliyun.com/document_detail/428263.html).

        > **NOTE:** Available since v1.192.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default = alicloud.resourcemanager.get_resource_groups()
        default_get_instances = alicloud.ecs.get_instances(status="Running")
        default_studio_application = alicloud.bp.StudioApplication("default",
            application_name=name,
            template_id="YAUUQIYRSV1CMFGX",
            resource_group_id=default.groups[0].id,
            area_id="cn-hangzhou",
            instances=[{
                "id": "data.alicloud_instances.default.instances.0.id",
                "node_name": "data.alicloud_instances.default.instances.0.name",
                "node_type": "ecs",
            }],
            configuration={
                "enableMonitor": "1",
            },
            variables={
                "test": "1",
            })
        ```

        ## Import

        Cloud Architect Design Tools Application can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:bp/studioApplication:StudioApplication example <id>
        ```

        :param str resource_name: The name of the resource.
        :param StudioApplicationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(StudioApplicationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_name: Optional[pulumi.Input[_builtins.str]] = None,
                 area_id: Optional[pulumi.Input[_builtins.str]] = None,
                 configuration: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 instances: Optional[pulumi.Input[Sequence[pulumi.Input[Union['StudioApplicationInstanceArgs', 'StudioApplicationInstanceArgsDict']]]]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 template_id: Optional[pulumi.Input[_builtins.str]] = None,
                 variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = StudioApplicationArgs.__new__(StudioApplicationArgs)

            if application_name is None and not opts.urn:
                raise TypeError("Missing required property 'application_name'")
            __props__.__dict__["application_name"] = application_name
            __props__.__dict__["area_id"] = area_id
            __props__.__dict__["configuration"] = configuration
            __props__.__dict__["instances"] = instances
            __props__.__dict__["resource_group_id"] = resource_group_id
            if template_id is None and not opts.urn:
                raise TypeError("Missing required property 'template_id'")
            __props__.__dict__["template_id"] = template_id
            __props__.__dict__["variables"] = variables
            __props__.__dict__["status"] = None
        super(StudioApplication, __self__).__init__(
            'alicloud:bp/studioApplication:StudioApplication',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            application_name: Optional[pulumi.Input[_builtins.str]] = None,
            area_id: Optional[pulumi.Input[_builtins.str]] = None,
            configuration: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            instances: Optional[pulumi.Input[Sequence[pulumi.Input[Union['StudioApplicationInstanceArgs', 'StudioApplicationInstanceArgsDict']]]]] = None,
            resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            template_id: Optional[pulumi.Input[_builtins.str]] = None,
            variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'StudioApplication':
        """
        Get an existing StudioApplication resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] application_name: The name of the application.
        :param pulumi.Input[_builtins.str] area_id: The id of the area.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] configuration: The configuration of the application.
        :param pulumi.Input[Sequence[pulumi.Input[Union['StudioApplicationInstanceArgs', 'StudioApplicationInstanceArgsDict']]]] instances: The instance list. Support the creation of instances in the existing vpc under the application. See the following `Block instances`.
        :param pulumi.Input[_builtins.str] resource_group_id: The id of the resource group.
        :param pulumi.Input[_builtins.str] status: The status of the Application.
        :param pulumi.Input[_builtins.str] template_id: The id of the template.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] variables: The variables of the application.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _StudioApplicationState.__new__(_StudioApplicationState)

        __props__.__dict__["application_name"] = application_name
        __props__.__dict__["area_id"] = area_id
        __props__.__dict__["configuration"] = configuration
        __props__.__dict__["instances"] = instances
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["status"] = status
        __props__.__dict__["template_id"] = template_id
        __props__.__dict__["variables"] = variables
        return StudioApplication(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="applicationName")
    def application_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the application.
        """
        return pulumi.get(self, "application_name")

    @_builtins.property
    @pulumi.getter(name="areaId")
    def area_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The id of the area.
        """
        return pulumi.get(self, "area_id")

    @_builtins.property
    @pulumi.getter
    def configuration(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        The configuration of the application.
        """
        return pulumi.get(self, "configuration")

    @_builtins.property
    @pulumi.getter
    def instances(self) -> pulumi.Output[Optional[Sequence['outputs.StudioApplicationInstance']]]:
        """
        The instance list. Support the creation of instances in the existing vpc under the application. See the following `Block instances`.
        """
        return pulumi.get(self, "instances")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The id of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the Application.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="templateId")
    def template_id(self) -> pulumi.Output[_builtins.str]:
        """
        The id of the template.
        """
        return pulumi.get(self, "template_id")

    @_builtins.property
    @pulumi.getter
    def variables(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        The variables of the application.
        """
        return pulumi.get(self, "variables")

