# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetRouteServicesResult',
    'AwaitableGetRouteServicesResult',
    'get_route_services',
    'get_route_services_output',
]

@pulumi.output_type
class GetRouteServicesResult:
    """
    A collection of values returned by getRouteServices.
    """
    def __init__(__self__, access_region_id=None, cen_id=None, host=None, host_region_id=None, host_vpc_id=None, id=None, ids=None, output_file=None, services=None, status=None):
        if access_region_id and not isinstance(access_region_id, str):
            raise TypeError("Expected argument 'access_region_id' to be a str")
        pulumi.set(__self__, "access_region_id", access_region_id)
        if cen_id and not isinstance(cen_id, str):
            raise TypeError("Expected argument 'cen_id' to be a str")
        pulumi.set(__self__, "cen_id", cen_id)
        if host and not isinstance(host, str):
            raise TypeError("Expected argument 'host' to be a str")
        pulumi.set(__self__, "host", host)
        if host_region_id and not isinstance(host_region_id, str):
            raise TypeError("Expected argument 'host_region_id' to be a str")
        pulumi.set(__self__, "host_region_id", host_region_id)
        if host_vpc_id and not isinstance(host_vpc_id, str):
            raise TypeError("Expected argument 'host_vpc_id' to be a str")
        pulumi.set(__self__, "host_vpc_id", host_vpc_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if services and not isinstance(services, list):
            raise TypeError("Expected argument 'services' to be a list")
        pulumi.set(__self__, "services", services)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="accessRegionId")
    def access_region_id(self) -> Optional[_builtins.str]:
        """
        The region of the network instances that access the cloud services.
        """
        return pulumi.get(self, "access_region_id")

    @_builtins.property
    @pulumi.getter(name="cenId")
    def cen_id(self) -> _builtins.str:
        """
        The ID of the CEN instance.
        """
        return pulumi.get(self, "cen_id")

    @_builtins.property
    @pulumi.getter
    def host(self) -> Optional[_builtins.str]:
        """
        The domain name or IP address of the cloud service.
        """
        return pulumi.get(self, "host")

    @_builtins.property
    @pulumi.getter(name="hostRegionId")
    def host_region_id(self) -> Optional[_builtins.str]:
        """
        The region of the cloud service.
        """
        return pulumi.get(self, "host_region_id")

    @_builtins.property
    @pulumi.getter(name="hostVpcId")
    def host_vpc_id(self) -> Optional[_builtins.str]:
        """
        The VPC associated with the cloud service.
        """
        return pulumi.get(self, "host_vpc_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        """
        A list of CEN Route Service IDs.
        """
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")

    @_builtins.property
    @pulumi.getter
    def services(self) -> Sequence['outputs.GetRouteServicesServiceResult']:
        """
        A list of CEN Route Services. Each element contains the following attributes:
        """
        return pulumi.get(self, "services")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        The status of the cloud service.
        """
        return pulumi.get(self, "status")


class AwaitableGetRouteServicesResult(GetRouteServicesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRouteServicesResult(
            access_region_id=self.access_region_id,
            cen_id=self.cen_id,
            host=self.host,
            host_region_id=self.host_region_id,
            host_vpc_id=self.host_vpc_id,
            id=self.id,
            ids=self.ids,
            output_file=self.output_file,
            services=self.services,
            status=self.status)


def get_route_services(access_region_id: Optional[_builtins.str] = None,
                       cen_id: Optional[_builtins.str] = None,
                       host: Optional[_builtins.str] = None,
                       host_region_id: Optional[_builtins.str] = None,
                       host_vpc_id: Optional[_builtins.str] = None,
                       output_file: Optional[_builtins.str] = None,
                       status: Optional[_builtins.str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRouteServicesResult:
    """
    This data source provides CEN Route Service available to the user.

    > **NOTE:** Available in v1.102.0+

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    example = alicloud.cen.get_route_services(cen_id="cen-7qthudw0ll6jmc****")
    pulumi.export("firstCenRouteServiceId", example.services[0].id)
    ```


    :param _builtins.str access_region_id: The region of the network instances that access the cloud services.
    :param _builtins.str cen_id: The ID of the CEN instance.
    :param _builtins.str host: The domain name or IP address of the cloud service.
    :param _builtins.str host_region_id: The region of the cloud service.
    :param _builtins.str host_vpc_id: The VPC associated with the cloud service.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str status: The status of the cloud service. Valid values: `Active`, `Creating` and `Deleting`.
    """
    __args__ = dict()
    __args__['accessRegionId'] = access_region_id
    __args__['cenId'] = cen_id
    __args__['host'] = host
    __args__['hostRegionId'] = host_region_id
    __args__['hostVpcId'] = host_vpc_id
    __args__['outputFile'] = output_file
    __args__['status'] = status
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:cen/getRouteServices:getRouteServices', __args__, opts=opts, typ=GetRouteServicesResult).value

    return AwaitableGetRouteServicesResult(
        access_region_id=pulumi.get(__ret__, 'access_region_id'),
        cen_id=pulumi.get(__ret__, 'cen_id'),
        host=pulumi.get(__ret__, 'host'),
        host_region_id=pulumi.get(__ret__, 'host_region_id'),
        host_vpc_id=pulumi.get(__ret__, 'host_vpc_id'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        output_file=pulumi.get(__ret__, 'output_file'),
        services=pulumi.get(__ret__, 'services'),
        status=pulumi.get(__ret__, 'status'))
def get_route_services_output(access_region_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              cen_id: Optional[pulumi.Input[_builtins.str]] = None,
                              host: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              host_region_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              host_vpc_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              status: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetRouteServicesResult]:
    """
    This data source provides CEN Route Service available to the user.

    > **NOTE:** Available in v1.102.0+

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    example = alicloud.cen.get_route_services(cen_id="cen-7qthudw0ll6jmc****")
    pulumi.export("firstCenRouteServiceId", example.services[0].id)
    ```


    :param _builtins.str access_region_id: The region of the network instances that access the cloud services.
    :param _builtins.str cen_id: The ID of the CEN instance.
    :param _builtins.str host: The domain name or IP address of the cloud service.
    :param _builtins.str host_region_id: The region of the cloud service.
    :param _builtins.str host_vpc_id: The VPC associated with the cloud service.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str status: The status of the cloud service. Valid values: `Active`, `Creating` and `Deleting`.
    """
    __args__ = dict()
    __args__['accessRegionId'] = access_region_id
    __args__['cenId'] = cen_id
    __args__['host'] = host
    __args__['hostRegionId'] = host_region_id
    __args__['hostVpcId'] = host_vpc_id
    __args__['outputFile'] = output_file
    __args__['status'] = status
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:cen/getRouteServices:getRouteServices', __args__, opts=opts, typ=GetRouteServicesResult)
    return __ret__.apply(lambda __response__: GetRouteServicesResult(
        access_region_id=pulumi.get(__response__, 'access_region_id'),
        cen_id=pulumi.get(__response__, 'cen_id'),
        host=pulumi.get(__response__, 'host'),
        host_region_id=pulumi.get(__response__, 'host_region_id'),
        host_vpc_id=pulumi.get(__response__, 'host_vpc_id'),
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        output_file=pulumi.get(__response__, 'output_file'),
        services=pulumi.get(__response__, 'services'),
        status=pulumi.get(__response__, 'status')))
