# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'TrafficMarkingPolicyTrafficMatchRule',
    'TransitRouterMulticastDomainOptions',
    'TransitRouterVpcAttachmentZoneMapping',
    'TransitRouterVpnAttachmentZone',
    'GetBandwidthLimitsLimitResult',
    'GetBandwidthPackagesPackageResult',
    'GetChildInstanceRouteEntryToAttachmentsAttachmentResult',
    'GetFlowlogsFlowlogResult',
    'GetInstanceAttachmentsAttachmentResult',
    'GetInstancesInstanceResult',
    'GetInterRegionTrafficQosPoliciesPolicyResult',
    'GetInterRegionTrafficQosQueuesQueueResult',
    'GetPrivateZonesZoneResult',
    'GetRegionRouteEntriesEntryResult',
    'GetRouteEntriesEntryResult',
    'GetRouteEntriesEntryConflictResult',
    'GetRouteMapsMapResult',
    'GetRouteServicesServiceResult',
    'GetTrafficMarkingPoliciesPolicyResult',
    'GetTransitRouteTableAggregationsTransitRouteTableAggregationResult',
    'GetTransitRouterAvailableResourcesResourceResult',
    'GetTransitRouterCidrsCidrResult',
    'GetTransitRouterMulticastDomainAssociationsAssociationResult',
    'GetTransitRouterMulticastDomainMembersMemberResult',
    'GetTransitRouterMulticastDomainPeerMembersMemberResult',
    'GetTransitRouterMulticastDomainSourcesSourceResult',
    'GetTransitRouterMulticastDomainsDomainResult',
    'GetTransitRouterPeerAttachmentsAttachmentResult',
    'GetTransitRouterPrefixListAssociationsAssociationResult',
    'GetTransitRouterRouteEntriesEntryResult',
    'GetTransitRouterRouteTableAssociationsAssociationResult',
    'GetTransitRouterRouteTablePropagationsPropagationResult',
    'GetTransitRouterRouteTablesTableResult',
    'GetTransitRouterVbrAttachmentsAttachmentResult',
    'GetTransitRouterVpcAttachmentsAttachmentResult',
    'GetTransitRouterVpcAttachmentsAttachmentZoneMappingResult',
    'GetTransitRouterVpnAttachmentsAttachmentResult',
    'GetTransitRouterVpnAttachmentsAttachmentZoneResult',
    'GetTransitRoutersTransitRouterResult',
    'GetVbrHealthChecksCheckResult',
]

@pulumi.output_type
class TrafficMarkingPolicyTrafficMatchRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "addressFamily":
            suggest = "address_family"
        elif key == "dstCidr":
            suggest = "dst_cidr"
        elif key == "dstPortRanges":
            suggest = "dst_port_ranges"
        elif key == "matchDscp":
            suggest = "match_dscp"
        elif key == "srcCidr":
            suggest = "src_cidr"
        elif key == "srcPortRanges":
            suggest = "src_port_ranges"
        elif key == "trafficMatchRuleDescription":
            suggest = "traffic_match_rule_description"
        elif key == "trafficMatchRuleName":
            suggest = "traffic_match_rule_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TrafficMarkingPolicyTrafficMatchRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TrafficMarkingPolicyTrafficMatchRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TrafficMarkingPolicyTrafficMatchRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address_family: Optional[_builtins.str] = None,
                 dst_cidr: Optional[_builtins.str] = None,
                 dst_port_ranges: Optional[Sequence[_builtins.int]] = None,
                 match_dscp: Optional[_builtins.int] = None,
                 protocol: Optional[_builtins.str] = None,
                 src_cidr: Optional[_builtins.str] = None,
                 src_port_ranges: Optional[Sequence[_builtins.int]] = None,
                 traffic_match_rule_description: Optional[_builtins.str] = None,
                 traffic_match_rule_name: Optional[_builtins.str] = None):
        """
        :param _builtins.str address_family: IP Address Family
        :param _builtins.str dst_cidr: The destination network segment of the traffic message.
               The flow classification matches the traffic of the destination IP address in the destination network segment. If the flow classification rule is not set, it means that the flow classification rule matches the traffic of any destination IP address.
        :param Sequence[_builtins.int] dst_port_ranges: The destination port of the traffic message. Valid values: **-1**, `1` to `65535`.
               
               The flow classification rule matches the traffic of the destination port number in the destination port range. If the flow classification rule is not set, it means that the flow classification rule matches the traffic of any destination port number.
               
               The current parameter supports a maximum of 2 port numbers. The input format is described as follows:
               - If you only enter a port number, such as 1, the system defaults to match the traffic with the destination port of 1.
               - If you enter 2 port numbers, such as 1 and 200, the system defaults to match the traffic of the destination port in the range of 1 to 200.
               - If you enter 2 port numbers and one of them is - 1, the other port must also be - 1, indicating that it matches any destination port.
        :param _builtins.int match_dscp: The DSCP value of the traffic message. Valid values: `0` to **63 * *.
               
               The flow classification rule matches the flow with the specified DSCP value. If the flow classification rule is not set, it means that the flow classification rule matches the flow with any DSCP value.
               
               > **NOTE:**  The current DSCP value refers to the DSCP value that the traffic message has carried before entering the cross-region connection.
        :param _builtins.str protocol: The protocol type of the traffic message.
               Stream classification rules can match traffic of multiple protocol types, such as `HTTP`, `HTTPS`, `TCP`, `UDP`, `SSH`, and **Telnet. For more protocol types, please log on to the [Cloud Enterprise Network Management Console](https://cen.console.aliyun.com/cen/list) to view.
        :param _builtins.str src_cidr: The source network segment of the traffic message.
               The flow classification rule matches the traffic of the source IP address in the source network segment. If the flow classification rule is not set, it means that the flow classification rule matches the traffic of any source IP address.
        :param Sequence[_builtins.int] src_port_ranges: The source port of the traffic message. Valid values: **-1**, `1` to `65535`.
               
               The flow classification rule matches the traffic of the source port number in the source port range. If it is not set, it means that the flow classification rule matches the traffic of any source port number.
               
               The current parameter supports entering up to two port numbers. The input format is described as follows:
               - If you only enter a port number, such as 1, the system defaults to match the traffic with source port 1.
               - If you enter two port numbers, such as 1 and 200, the system defaults to match the traffic with the source port in the range of 1 to 200.
               - If you enter two port numbers and one of them is - 1, the other port must also be - 1, indicating that it matches any source port.
        :param _builtins.str traffic_match_rule_description: The description information of the stream classification rule.
               The description must be 2 to 128 characters in length and can contain numbers, dashes (-), and underscores (_).
        :param _builtins.str traffic_match_rule_name: The name of the stream classification rule.
               The name must be 2 to 128 characters in length and can contain numbers, dashes (-), and underscores (_).
        """
        if address_family is not None:
            pulumi.set(__self__, "address_family", address_family)
        if dst_cidr is not None:
            pulumi.set(__self__, "dst_cidr", dst_cidr)
        if dst_port_ranges is not None:
            pulumi.set(__self__, "dst_port_ranges", dst_port_ranges)
        if match_dscp is not None:
            pulumi.set(__self__, "match_dscp", match_dscp)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if src_cidr is not None:
            pulumi.set(__self__, "src_cidr", src_cidr)
        if src_port_ranges is not None:
            pulumi.set(__self__, "src_port_ranges", src_port_ranges)
        if traffic_match_rule_description is not None:
            pulumi.set(__self__, "traffic_match_rule_description", traffic_match_rule_description)
        if traffic_match_rule_name is not None:
            pulumi.set(__self__, "traffic_match_rule_name", traffic_match_rule_name)

    @_builtins.property
    @pulumi.getter(name="addressFamily")
    def address_family(self) -> Optional[_builtins.str]:
        """
        IP Address Family
        """
        return pulumi.get(self, "address_family")

    @_builtins.property
    @pulumi.getter(name="dstCidr")
    def dst_cidr(self) -> Optional[_builtins.str]:
        """
        The destination network segment of the traffic message.
        The flow classification matches the traffic of the destination IP address in the destination network segment. If the flow classification rule is not set, it means that the flow classification rule matches the traffic of any destination IP address.
        """
        return pulumi.get(self, "dst_cidr")

    @_builtins.property
    @pulumi.getter(name="dstPortRanges")
    def dst_port_ranges(self) -> Optional[Sequence[_builtins.int]]:
        """
        The destination port of the traffic message. Valid values: **-1**, `1` to `65535`.

        The flow classification rule matches the traffic of the destination port number in the destination port range. If the flow classification rule is not set, it means that the flow classification rule matches the traffic of any destination port number.

        The current parameter supports a maximum of 2 port numbers. The input format is described as follows:
        - If you only enter a port number, such as 1, the system defaults to match the traffic with the destination port of 1.
        - If you enter 2 port numbers, such as 1 and 200, the system defaults to match the traffic of the destination port in the range of 1 to 200.
        - If you enter 2 port numbers and one of them is - 1, the other port must also be - 1, indicating that it matches any destination port.
        """
        return pulumi.get(self, "dst_port_ranges")

    @_builtins.property
    @pulumi.getter(name="matchDscp")
    def match_dscp(self) -> Optional[_builtins.int]:
        """
        The DSCP value of the traffic message. Valid values: `0` to **63 * *.

        The flow classification rule matches the flow with the specified DSCP value. If the flow classification rule is not set, it means that the flow classification rule matches the flow with any DSCP value.

        > **NOTE:**  The current DSCP value refers to the DSCP value that the traffic message has carried before entering the cross-region connection.
        """
        return pulumi.get(self, "match_dscp")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[_builtins.str]:
        """
        The protocol type of the traffic message.
        Stream classification rules can match traffic of multiple protocol types, such as `HTTP`, `HTTPS`, `TCP`, `UDP`, `SSH`, and **Telnet. For more protocol types, please log on to the [Cloud Enterprise Network Management Console](https://cen.console.aliyun.com/cen/list) to view.
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter(name="srcCidr")
    def src_cidr(self) -> Optional[_builtins.str]:
        """
        The source network segment of the traffic message.
        The flow classification rule matches the traffic of the source IP address in the source network segment. If the flow classification rule is not set, it means that the flow classification rule matches the traffic of any source IP address.
        """
        return pulumi.get(self, "src_cidr")

    @_builtins.property
    @pulumi.getter(name="srcPortRanges")
    def src_port_ranges(self) -> Optional[Sequence[_builtins.int]]:
        """
        The source port of the traffic message. Valid values: **-1**, `1` to `65535`.

        The flow classification rule matches the traffic of the source port number in the source port range. If it is not set, it means that the flow classification rule matches the traffic of any source port number.

        The current parameter supports entering up to two port numbers. The input format is described as follows:
        - If you only enter a port number, such as 1, the system defaults to match the traffic with source port 1.
        - If you enter two port numbers, such as 1 and 200, the system defaults to match the traffic with the source port in the range of 1 to 200.
        - If you enter two port numbers and one of them is - 1, the other port must also be - 1, indicating that it matches any source port.
        """
        return pulumi.get(self, "src_port_ranges")

    @_builtins.property
    @pulumi.getter(name="trafficMatchRuleDescription")
    def traffic_match_rule_description(self) -> Optional[_builtins.str]:
        """
        The description information of the stream classification rule.
        The description must be 2 to 128 characters in length and can contain numbers, dashes (-), and underscores (_).
        """
        return pulumi.get(self, "traffic_match_rule_description")

    @_builtins.property
    @pulumi.getter(name="trafficMatchRuleName")
    def traffic_match_rule_name(self) -> Optional[_builtins.str]:
        """
        The name of the stream classification rule.
        The name must be 2 to 128 characters in length and can contain numbers, dashes (-), and underscores (_).
        """
        return pulumi.get(self, "traffic_match_rule_name")


@pulumi.output_type
class TransitRouterMulticastDomainOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "igmpv2Support":
            suggest = "igmpv2_support"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TransitRouterMulticastDomainOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TransitRouterMulticastDomainOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TransitRouterMulticastDomainOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 igmpv2_support: Optional[_builtins.str] = None):
        """
        :param _builtins.str igmpv2_support: Whether to enable IGMP function for multicast domain. Default value: `disable`. Valid values: `enable`, `disable`.
        """
        if igmpv2_support is not None:
            pulumi.set(__self__, "igmpv2_support", igmpv2_support)

    @_builtins.property
    @pulumi.getter(name="igmpv2Support")
    def igmpv2_support(self) -> Optional[_builtins.str]:
        """
        Whether to enable IGMP function for multicast domain. Default value: `disable`. Valid values: `enable`, `disable`.
        """
        return pulumi.get(self, "igmpv2_support")


@pulumi.output_type
class TransitRouterVpcAttachmentZoneMapping(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "vswitchId":
            suggest = "vswitch_id"
        elif key == "zoneId":
            suggest = "zone_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TransitRouterVpcAttachmentZoneMapping. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TransitRouterVpcAttachmentZoneMapping.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TransitRouterVpcAttachmentZoneMapping.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 vswitch_id: _builtins.str,
                 zone_id: _builtins.str):
        """
        :param _builtins.str vswitch_id: The ID of the vSwitch that you want to add to the VPC connection.  You can specify at most 10 vSwitches in each call.
               - If the VPC connection belongs to the current Alibaba Cloud account, you can call the [DescribeVSwitches](https://www.alibabacloud.com/help/en/doc-detail/35748.html) operation to query the IDs of the vSwitches and zones of the VPC.
               - If the VPC connection belongs to another Alibaba Cloud account, you can call the [ListGrantVSwitchesToCen](https://www.alibabacloud.com/help/en/doc-detail/427599.html) operation to query the IDs of the vSwitches and zones of the VPC.
        :param _builtins.str zone_id: The ID of the zone that supports Enterprise Edition transit routers.  You can call the [DescribeZones](https://www.alibabacloud.com/help/en/doc-detail/36064.html) operation to query the most recent zone list.  You can specify at most 10 zones in each call.
        """
        pulumi.set(__self__, "vswitch_id", vswitch_id)
        pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> _builtins.str:
        """
        The ID of the vSwitch that you want to add to the VPC connection.  You can specify at most 10 vSwitches in each call.
        - If the VPC connection belongs to the current Alibaba Cloud account, you can call the [DescribeVSwitches](https://www.alibabacloud.com/help/en/doc-detail/35748.html) operation to query the IDs of the vSwitches and zones of the VPC.
        - If the VPC connection belongs to another Alibaba Cloud account, you can call the [ListGrantVSwitchesToCen](https://www.alibabacloud.com/help/en/doc-detail/427599.html) operation to query the IDs of the vSwitches and zones of the VPC.
        """
        return pulumi.get(self, "vswitch_id")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> _builtins.str:
        """
        The ID of the zone that supports Enterprise Edition transit routers.  You can call the [DescribeZones](https://www.alibabacloud.com/help/en/doc-detail/36064.html) operation to query the most recent zone list.  You can specify at most 10 zones in each call.
        """
        return pulumi.get(self, "zone_id")


@pulumi.output_type
class TransitRouterVpnAttachmentZone(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "zoneId":
            suggest = "zone_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TransitRouterVpnAttachmentZone. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TransitRouterVpnAttachmentZone.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TransitRouterVpnAttachmentZone.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 zone_id: _builtins.str):
        """
        :param _builtins.str zone_id: The zone ID of the read-only instance.
               You can call the [ListTransitRouterAvailableResource](https://www.alibabacloud.com/help/en/doc-detail/261356.html) operation to query the most recent zone list.
        """
        pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> _builtins.str:
        """
        The zone ID of the read-only instance.
        You can call the [ListTransitRouterAvailableResource](https://www.alibabacloud.com/help/en/doc-detail/261356.html) operation to query the most recent zone list.
        """
        return pulumi.get(self, "zone_id")


@pulumi.output_type
class GetBandwidthLimitsLimitResult(dict):
    def __init__(__self__, *,
                 bandwidth_limit: _builtins.int,
                 instance_id: _builtins.str,
                 local_region_id: _builtins.str,
                 opposite_region_id: _builtins.str,
                 status: _builtins.str):
        """
        :param _builtins.int bandwidth_limit: The bandwidth limit configured for the interconnected regions communication.
        :param _builtins.str instance_id: ID of the CEN instance.
        :param _builtins.str local_region_id: ID of local region.
        :param _builtins.str opposite_region_id: ID of opposite region.
        :param _builtins.str status: Status of the CEN Bandwidth Limit, including "Active" and "Modifying".
        """
        pulumi.set(__self__, "bandwidth_limit", bandwidth_limit)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "local_region_id", local_region_id)
        pulumi.set(__self__, "opposite_region_id", opposite_region_id)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="bandwidthLimit")
    def bandwidth_limit(self) -> _builtins.int:
        """
        The bandwidth limit configured for the interconnected regions communication.
        """
        return pulumi.get(self, "bandwidth_limit")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> _builtins.str:
        """
        ID of the CEN instance.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="localRegionId")
    def local_region_id(self) -> _builtins.str:
        """
        ID of local region.
        """
        return pulumi.get(self, "local_region_id")

    @_builtins.property
    @pulumi.getter(name="oppositeRegionId")
    def opposite_region_id(self) -> _builtins.str:
        """
        ID of opposite region.
        """
        return pulumi.get(self, "opposite_region_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Status of the CEN Bandwidth Limit, including "Active" and "Modifying".
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetBandwidthPackagesPackageResult(dict):
    def __init__(__self__, *,
                 bandwidth: _builtins.int,
                 bandwidth_package_charge_type: _builtins.str,
                 business_status: _builtins.str,
                 cen_bandwidth_package_id: _builtins.str,
                 cen_bandwidth_package_name: _builtins.str,
                 cen_ids: Sequence[_builtins.str],
                 description: _builtins.str,
                 expired_time: _builtins.str,
                 geographic_region_a_id: _builtins.str,
                 geographic_region_b_id: _builtins.str,
                 geographic_span_id: _builtins.str,
                 has_reservation_data: _builtins.str,
                 id: _builtins.str,
                 instance_id: _builtins.str,
                 is_cross_border: _builtins.bool,
                 name: _builtins.str,
                 payment_type: _builtins.str,
                 reservation_active_time: _builtins.str,
                 reservation_bandwidth: _builtins.str,
                 reservation_internet_charge_type: _builtins.str,
                 reservation_order_type: _builtins.str,
                 status: _builtins.str):
        """
        :param _builtins.int bandwidth: The bandwidth in Mbps of the CEN bandwidth package.
        :param _builtins.str bandwidth_package_charge_type: The billing method, including `POSTPAY` and `PREPAY`.
        :param _builtins.str business_status: Status of the CEN Bandwidth Package, including `Normal`, `FinancialLocked` and `SecurityLocked`.
        :param _builtins.str cen_bandwidth_package_id: The ID of the bandwidth package.
        :param _builtins.str cen_bandwidth_package_name: The name of the bandwidth package.
        :param Sequence[_builtins.str] cen_ids: The list of CEN instances that are associated with the bandwidth package.
        :param _builtins.str description: Description of the CEN Bandwidth Package.
        :param _builtins.str geographic_region_a_id: Region ID of the interconnected regions.
        :param _builtins.str geographic_region_b_id: Region ID of the interconnected regions.
        :param _builtins.str geographic_span_id: The area ID of the cross-area connection.
        :param _builtins.str has_reservation_data: Indicates whether renewal data is involved.
        :param _builtins.str id: ID of the CEN Bandwidth Package.
        :param _builtins.str instance_id: ID of a CEN instance.
        :param _builtins.bool is_cross_border: Indicates whether the bandwidth package is a cross-border bandwidth package.
        :param _builtins.str name: Name of the CEN Bandwidth Package.
        :param _builtins.str payment_type: The billing method of the bandwidth package.
        :param _builtins.str reservation_active_time: The expiration time of the temporary upgrade.
        :param _builtins.str reservation_bandwidth: The restored bandwidth after the temporary upgrade.
        :param _builtins.str reservation_internet_charge_type: The billing method after the configuration change.
        :param _builtins.str reservation_order_type: The type of the configuration change.
        :param _builtins.str status: Status of the CEN Bandwidth Package in CEN instance, Valid value: `Idle` and `InUse`.
        """
        pulumi.set(__self__, "bandwidth", bandwidth)
        pulumi.set(__self__, "bandwidth_package_charge_type", bandwidth_package_charge_type)
        pulumi.set(__self__, "business_status", business_status)
        pulumi.set(__self__, "cen_bandwidth_package_id", cen_bandwidth_package_id)
        pulumi.set(__self__, "cen_bandwidth_package_name", cen_bandwidth_package_name)
        pulumi.set(__self__, "cen_ids", cen_ids)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "expired_time", expired_time)
        pulumi.set(__self__, "geographic_region_a_id", geographic_region_a_id)
        pulumi.set(__self__, "geographic_region_b_id", geographic_region_b_id)
        pulumi.set(__self__, "geographic_span_id", geographic_span_id)
        pulumi.set(__self__, "has_reservation_data", has_reservation_data)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "is_cross_border", is_cross_border)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "payment_type", payment_type)
        pulumi.set(__self__, "reservation_active_time", reservation_active_time)
        pulumi.set(__self__, "reservation_bandwidth", reservation_bandwidth)
        pulumi.set(__self__, "reservation_internet_charge_type", reservation_internet_charge_type)
        pulumi.set(__self__, "reservation_order_type", reservation_order_type)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def bandwidth(self) -> _builtins.int:
        """
        The bandwidth in Mbps of the CEN bandwidth package.
        """
        return pulumi.get(self, "bandwidth")

    @_builtins.property
    @pulumi.getter(name="bandwidthPackageChargeType")
    def bandwidth_package_charge_type(self) -> _builtins.str:
        """
        The billing method, including `POSTPAY` and `PREPAY`.
        """
        return pulumi.get(self, "bandwidth_package_charge_type")

    @_builtins.property
    @pulumi.getter(name="businessStatus")
    def business_status(self) -> _builtins.str:
        """
        Status of the CEN Bandwidth Package, including `Normal`, `FinancialLocked` and `SecurityLocked`.
        """
        return pulumi.get(self, "business_status")

    @_builtins.property
    @pulumi.getter(name="cenBandwidthPackageId")
    def cen_bandwidth_package_id(self) -> _builtins.str:
        """
        The ID of the bandwidth package.
        """
        return pulumi.get(self, "cen_bandwidth_package_id")

    @_builtins.property
    @pulumi.getter(name="cenBandwidthPackageName")
    def cen_bandwidth_package_name(self) -> _builtins.str:
        """
        The name of the bandwidth package.
        """
        return pulumi.get(self, "cen_bandwidth_package_name")

    @_builtins.property
    @pulumi.getter(name="cenIds")
    def cen_ids(self) -> Sequence[_builtins.str]:
        """
        The list of CEN instances that are associated with the bandwidth package.
        """
        return pulumi.get(self, "cen_ids")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Description of the CEN Bandwidth Package.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="expiredTime")
    def expired_time(self) -> _builtins.str:
        return pulumi.get(self, "expired_time")

    @_builtins.property
    @pulumi.getter(name="geographicRegionAId")
    def geographic_region_a_id(self) -> _builtins.str:
        """
        Region ID of the interconnected regions.
        """
        return pulumi.get(self, "geographic_region_a_id")

    @_builtins.property
    @pulumi.getter(name="geographicRegionBId")
    def geographic_region_b_id(self) -> _builtins.str:
        """
        Region ID of the interconnected regions.
        """
        return pulumi.get(self, "geographic_region_b_id")

    @_builtins.property
    @pulumi.getter(name="geographicSpanId")
    def geographic_span_id(self) -> _builtins.str:
        """
        The area ID of the cross-area connection.
        """
        return pulumi.get(self, "geographic_span_id")

    @_builtins.property
    @pulumi.getter(name="hasReservationData")
    def has_reservation_data(self) -> _builtins.str:
        """
        Indicates whether renewal data is involved.
        """
        return pulumi.get(self, "has_reservation_data")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        ID of the CEN Bandwidth Package.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> _builtins.str:
        """
        ID of a CEN instance.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="isCrossBorder")
    def is_cross_border(self) -> _builtins.bool:
        """
        Indicates whether the bandwidth package is a cross-border bandwidth package.
        """
        return pulumi.get(self, "is_cross_border")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the CEN Bandwidth Package.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> _builtins.str:
        """
        The billing method of the bandwidth package.
        """
        return pulumi.get(self, "payment_type")

    @_builtins.property
    @pulumi.getter(name="reservationActiveTime")
    def reservation_active_time(self) -> _builtins.str:
        """
        The expiration time of the temporary upgrade.
        """
        return pulumi.get(self, "reservation_active_time")

    @_builtins.property
    @pulumi.getter(name="reservationBandwidth")
    def reservation_bandwidth(self) -> _builtins.str:
        """
        The restored bandwidth after the temporary upgrade.
        """
        return pulumi.get(self, "reservation_bandwidth")

    @_builtins.property
    @pulumi.getter(name="reservationInternetChargeType")
    def reservation_internet_charge_type(self) -> _builtins.str:
        """
        The billing method after the configuration change.
        """
        return pulumi.get(self, "reservation_internet_charge_type")

    @_builtins.property
    @pulumi.getter(name="reservationOrderType")
    def reservation_order_type(self) -> _builtins.str:
        """
        The type of the configuration change.
        """
        return pulumi.get(self, "reservation_order_type")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Status of the CEN Bandwidth Package in CEN instance, Valid value: `Idle` and `InUse`.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetChildInstanceRouteEntryToAttachmentsAttachmentResult(dict):
    def __init__(__self__, *,
                 cen_id: _builtins.str,
                 child_instance_route_table_id: _builtins.str,
                 destination_cidr_block: _builtins.str,
                 id: _builtins.str,
                 service_type: _builtins.str,
                 status: _builtins.str,
                 transit_router_attachment_id: _builtins.str):
        """
        :param _builtins.str cen_id: The ID of the CEN instance.
        :param _builtins.str child_instance_route_table_id: The first ID of the resource
        :param _builtins.str destination_cidr_block: DestinationCidrBlock
        :param _builtins.str id: The ID of the resource. The value is formulated as `<cen_id>:<child_instance_route_table_id>:<transit_router_attachment_id>:<destination_cidr_block>`.
        :param _builtins.str service_type: ServiceType
        :param _builtins.str status: The status of the resource
        :param _builtins.str transit_router_attachment_id: TransitRouterAttachmentId
        """
        pulumi.set(__self__, "cen_id", cen_id)
        pulumi.set(__self__, "child_instance_route_table_id", child_instance_route_table_id)
        pulumi.set(__self__, "destination_cidr_block", destination_cidr_block)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "service_type", service_type)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "transit_router_attachment_id", transit_router_attachment_id)

    @_builtins.property
    @pulumi.getter(name="cenId")
    def cen_id(self) -> _builtins.str:
        """
        The ID of the CEN instance.
        """
        return pulumi.get(self, "cen_id")

    @_builtins.property
    @pulumi.getter(name="childInstanceRouteTableId")
    def child_instance_route_table_id(self) -> _builtins.str:
        """
        The first ID of the resource
        """
        return pulumi.get(self, "child_instance_route_table_id")

    @_builtins.property
    @pulumi.getter(name="destinationCidrBlock")
    def destination_cidr_block(self) -> _builtins.str:
        """
        DestinationCidrBlock
        """
        return pulumi.get(self, "destination_cidr_block")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the resource. The value is formulated as `<cen_id>:<child_instance_route_table_id>:<transit_router_attachment_id>:<destination_cidr_block>`.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="serviceType")
    def service_type(self) -> _builtins.str:
        """
        ServiceType
        """
        return pulumi.get(self, "service_type")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the resource
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="transitRouterAttachmentId")
    def transit_router_attachment_id(self) -> _builtins.str:
        """
        TransitRouterAttachmentId
        """
        return pulumi.get(self, "transit_router_attachment_id")


@pulumi.output_type
class GetFlowlogsFlowlogResult(dict):
    def __init__(__self__, *,
                 cen_id: _builtins.str,
                 create_time: _builtins.str,
                 description: _builtins.str,
                 flow_log_id: _builtins.str,
                 flow_log_name: _builtins.str,
                 flow_log_version: _builtins.str,
                 id: _builtins.str,
                 interval: _builtins.int,
                 log_format_string: _builtins.str,
                 log_store_name: _builtins.str,
                 project_name: _builtins.str,
                 record_total: _builtins.str,
                 region_id: _builtins.str,
                 status: _builtins.str,
                 tags: Mapping[str, _builtins.str],
                 transit_router_attachment_id: _builtins.str,
                 transit_router_id: _builtins.str):
        """
        :param _builtins.str cen_id: The ID of Cen instance.
        :param _builtins.str create_time: The createTime of flowlog.
        :param _builtins.str description: The description of the flowlog.
        :param _builtins.str flow_log_id: The ID of FlowLog.
        :param _builtins.str flow_log_name: The name of the flowlog.
        :param _builtins.str flow_log_version: Flowlog Version.
        :param _builtins.str id: The ID of FlowLog.
        :param _builtins.int interval: The duration of the capture window for the flow log to capture traffic. Unit: seconds. Valid values: **60** or **600 * *. Default value: **600 * *.
        :param _builtins.str log_format_string: (Available since v1.236.0) Log Format.
        :param _builtins.str log_store_name: The LogStore that stores the flowlog.
        :param _builtins.str project_name: The Project that stores the flowlog.
        :param _builtins.str record_total: (Available since v1.236.0) Total number of records.
        :param _builtins.str region_id: Region id
        :param _builtins.str status: The status of the flow log. Valid values:-**Active**: started.-**InActive**: not started.
        :param Mapping[str, _builtins.str] tags: The tag of the resource.
        :param _builtins.str transit_router_attachment_id: (Available since v1.236.0) Cross-region Connection ID or VBR connection ID.> This parameter is required.
        :param _builtins.str transit_router_id: Transit Router ID
        """
        pulumi.set(__self__, "cen_id", cen_id)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "flow_log_id", flow_log_id)
        pulumi.set(__self__, "flow_log_name", flow_log_name)
        pulumi.set(__self__, "flow_log_version", flow_log_version)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "interval", interval)
        pulumi.set(__self__, "log_format_string", log_format_string)
        pulumi.set(__self__, "log_store_name", log_store_name)
        pulumi.set(__self__, "project_name", project_name)
        pulumi.set(__self__, "record_total", record_total)
        pulumi.set(__self__, "region_id", region_id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "transit_router_attachment_id", transit_router_attachment_id)
        pulumi.set(__self__, "transit_router_id", transit_router_id)

    @_builtins.property
    @pulumi.getter(name="cenId")
    def cen_id(self) -> _builtins.str:
        """
        The ID of Cen instance.
        """
        return pulumi.get(self, "cen_id")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        The createTime of flowlog.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the flowlog.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="flowLogId")
    def flow_log_id(self) -> _builtins.str:
        """
        The ID of FlowLog.
        """
        return pulumi.get(self, "flow_log_id")

    @_builtins.property
    @pulumi.getter(name="flowLogName")
    def flow_log_name(self) -> _builtins.str:
        """
        The name of the flowlog.
        """
        return pulumi.get(self, "flow_log_name")

    @_builtins.property
    @pulumi.getter(name="flowLogVersion")
    def flow_log_version(self) -> _builtins.str:
        """
        Flowlog Version.
        """
        return pulumi.get(self, "flow_log_version")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of FlowLog.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def interval(self) -> _builtins.int:
        """
        The duration of the capture window for the flow log to capture traffic. Unit: seconds. Valid values: **60** or **600 * *. Default value: **600 * *.
        """
        return pulumi.get(self, "interval")

    @_builtins.property
    @pulumi.getter(name="logFormatString")
    def log_format_string(self) -> _builtins.str:
        """
        (Available since v1.236.0) Log Format.
        """
        return pulumi.get(self, "log_format_string")

    @_builtins.property
    @pulumi.getter(name="logStoreName")
    def log_store_name(self) -> _builtins.str:
        """
        The LogStore that stores the flowlog.
        """
        return pulumi.get(self, "log_store_name")

    @_builtins.property
    @pulumi.getter(name="projectName")
    def project_name(self) -> _builtins.str:
        """
        The Project that stores the flowlog.
        """
        return pulumi.get(self, "project_name")

    @_builtins.property
    @pulumi.getter(name="recordTotal")
    def record_total(self) -> _builtins.str:
        """
        (Available since v1.236.0) Total number of records.
        """
        return pulumi.get(self, "record_total")

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> _builtins.str:
        """
        Region id
        """
        return pulumi.get(self, "region_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the flow log. Valid values:-**Active**: started.-**InActive**: not started.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        The tag of the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="transitRouterAttachmentId")
    def transit_router_attachment_id(self) -> _builtins.str:
        """
        (Available since v1.236.0) Cross-region Connection ID or VBR connection ID.> This parameter is required.
        """
        return pulumi.get(self, "transit_router_attachment_id")

    @_builtins.property
    @pulumi.getter(name="transitRouterId")
    def transit_router_id(self) -> _builtins.str:
        """
        Transit Router ID
        """
        return pulumi.get(self, "transit_router_id")


@pulumi.output_type
class GetInstanceAttachmentsAttachmentResult(dict):
    def __init__(__self__, *,
                 child_instance_attach_time: _builtins.str,
                 child_instance_id: _builtins.str,
                 child_instance_owner_id: _builtins.int,
                 child_instance_region_id: _builtins.str,
                 child_instance_type: _builtins.str,
                 id: _builtins.str,
                 instance_id: _builtins.str,
                 status: _builtins.str):
        """
        :param _builtins.str child_instance_attach_time: The time when the network is associated with the CEN instance.
        :param _builtins.str child_instance_id: The ID of the network.
        :param _builtins.int child_instance_owner_id: The ID of the account to which the network belongs.
        :param _builtins.str child_instance_region_id: The region to which the network to be queried belongs.
        :param _builtins.str child_instance_type: The type of the associated network. Valid values: `VPC`, `VBR` and `CCN`.
        :param _builtins.str id: The ID of the CEN Instance Attachment.
        :param _builtins.str instance_id: The ID of the CEN instance.
        :param _builtins.str status: The status of the Cen Child Instance Attachment. Valid value: `Attaching`, `Attached` and `Aetaching`.
        """
        pulumi.set(__self__, "child_instance_attach_time", child_instance_attach_time)
        pulumi.set(__self__, "child_instance_id", child_instance_id)
        pulumi.set(__self__, "child_instance_owner_id", child_instance_owner_id)
        pulumi.set(__self__, "child_instance_region_id", child_instance_region_id)
        pulumi.set(__self__, "child_instance_type", child_instance_type)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="childInstanceAttachTime")
    def child_instance_attach_time(self) -> _builtins.str:
        """
        The time when the network is associated with the CEN instance.
        """
        return pulumi.get(self, "child_instance_attach_time")

    @_builtins.property
    @pulumi.getter(name="childInstanceId")
    def child_instance_id(self) -> _builtins.str:
        """
        The ID of the network.
        """
        return pulumi.get(self, "child_instance_id")

    @_builtins.property
    @pulumi.getter(name="childInstanceOwnerId")
    def child_instance_owner_id(self) -> _builtins.int:
        """
        The ID of the account to which the network belongs.
        """
        return pulumi.get(self, "child_instance_owner_id")

    @_builtins.property
    @pulumi.getter(name="childInstanceRegionId")
    def child_instance_region_id(self) -> _builtins.str:
        """
        The region to which the network to be queried belongs.
        """
        return pulumi.get(self, "child_instance_region_id")

    @_builtins.property
    @pulumi.getter(name="childInstanceType")
    def child_instance_type(self) -> _builtins.str:
        """
        The type of the associated network. Valid values: `VPC`, `VBR` and `CCN`.
        """
        return pulumi.get(self, "child_instance_type")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the CEN Instance Attachment.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> _builtins.str:
        """
        The ID of the CEN instance.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the Cen Child Instance Attachment. Valid value: `Attaching`, `Attached` and `Aetaching`.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetInstancesInstanceResult(dict):
    def __init__(__self__, *,
                 cen_bandwidth_package_ids: Sequence[_builtins.str],
                 cen_id: _builtins.str,
                 cen_instance_name: _builtins.str,
                 create_time: _builtins.str,
                 description: _builtins.str,
                 id: _builtins.str,
                 name: _builtins.str,
                 protection_level: _builtins.str,
                 status: _builtins.str,
                 tags: Mapping[str, _builtins.str]):
        """
        :param Sequence[_builtins.str] cen_bandwidth_package_ids: List of CEN Bandwidth Package IDs in the specified CEN instance.
        :param _builtins.str cen_id: ID of the CEN instance.
        :param _builtins.str cen_instance_name: Name of the CEN instance.
        :param _builtins.str create_time: The creation time of the CEN Instance.
        :param _builtins.str description: Description of the CEN instance.
        :param _builtins.str id: ID of the CEN instance.
        :param _builtins.str name: Name of the CEN instance.
        :param _builtins.str protection_level: Indicates the allowed level of CIDR block overlapping.
        :param _builtins.str status: The status of CEN instance. Valid value: `Active`, `Creating` and `Deleting`.
        :param Mapping[str, _builtins.str] tags: A mapping of tags to assign to the resource.
        """
        pulumi.set(__self__, "cen_bandwidth_package_ids", cen_bandwidth_package_ids)
        pulumi.set(__self__, "cen_id", cen_id)
        pulumi.set(__self__, "cen_instance_name", cen_instance_name)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "protection_level", protection_level)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="cenBandwidthPackageIds")
    def cen_bandwidth_package_ids(self) -> Sequence[_builtins.str]:
        """
        List of CEN Bandwidth Package IDs in the specified CEN instance.
        """
        return pulumi.get(self, "cen_bandwidth_package_ids")

    @_builtins.property
    @pulumi.getter(name="cenId")
    def cen_id(self) -> _builtins.str:
        """
        ID of the CEN instance.
        """
        return pulumi.get(self, "cen_id")

    @_builtins.property
    @pulumi.getter(name="cenInstanceName")
    def cen_instance_name(self) -> _builtins.str:
        """
        Name of the CEN instance.
        """
        return pulumi.get(self, "cen_instance_name")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        The creation time of the CEN Instance.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Description of the CEN instance.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        ID of the CEN instance.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the CEN instance.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="protectionLevel")
    def protection_level(self) -> _builtins.str:
        """
        Indicates the allowed level of CIDR block overlapping.
        """
        return pulumi.get(self, "protection_level")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of CEN instance. Valid value: `Active`, `Creating` and `Deleting`.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class GetInterRegionTrafficQosPoliciesPolicyResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 inter_region_traffic_qos_policy_description: _builtins.str,
                 inter_region_traffic_qos_policy_id: _builtins.str,
                 inter_region_traffic_qos_policy_name: _builtins.str,
                 status: _builtins.str,
                 transit_router_attachment_id: _builtins.str,
                 transit_router_id: _builtins.str):
        """
        :param _builtins.str id: The ID of the Inter Region Traffic Qos Policy.
        :param _builtins.str inter_region_traffic_qos_policy_description: The description of the Inter Region Traffic Qos Policy.
        :param _builtins.str inter_region_traffic_qos_policy_id: The ID of the Inter Region Traffic Qos Policy.
        :param _builtins.str inter_region_traffic_qos_policy_name: The name of the Inter Region Traffic Qos Policy.
        :param _builtins.str status: The status of the traffic scheduling policy. Valid Value: `Creating`, `Active`, `Modifying`, `Deleting`, `Deleted`.
        :param _builtins.str transit_router_attachment_id: The ID of the inter-region connection.
        :param _builtins.str transit_router_id: The ID of the transit router.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "inter_region_traffic_qos_policy_description", inter_region_traffic_qos_policy_description)
        pulumi.set(__self__, "inter_region_traffic_qos_policy_id", inter_region_traffic_qos_policy_id)
        pulumi.set(__self__, "inter_region_traffic_qos_policy_name", inter_region_traffic_qos_policy_name)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "transit_router_attachment_id", transit_router_attachment_id)
        pulumi.set(__self__, "transit_router_id", transit_router_id)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Inter Region Traffic Qos Policy.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="interRegionTrafficQosPolicyDescription")
    def inter_region_traffic_qos_policy_description(self) -> _builtins.str:
        """
        The description of the Inter Region Traffic Qos Policy.
        """
        return pulumi.get(self, "inter_region_traffic_qos_policy_description")

    @_builtins.property
    @pulumi.getter(name="interRegionTrafficQosPolicyId")
    def inter_region_traffic_qos_policy_id(self) -> _builtins.str:
        """
        The ID of the Inter Region Traffic Qos Policy.
        """
        return pulumi.get(self, "inter_region_traffic_qos_policy_id")

    @_builtins.property
    @pulumi.getter(name="interRegionTrafficQosPolicyName")
    def inter_region_traffic_qos_policy_name(self) -> _builtins.str:
        """
        The name of the Inter Region Traffic Qos Policy.
        """
        return pulumi.get(self, "inter_region_traffic_qos_policy_name")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the traffic scheduling policy. Valid Value: `Creating`, `Active`, `Modifying`, `Deleting`, `Deleted`.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="transitRouterAttachmentId")
    def transit_router_attachment_id(self) -> _builtins.str:
        """
        The ID of the inter-region connection.
        """
        return pulumi.get(self, "transit_router_attachment_id")

    @_builtins.property
    @pulumi.getter(name="transitRouterId")
    def transit_router_id(self) -> _builtins.str:
        """
        The ID of the transit router.
        """
        return pulumi.get(self, "transit_router_id")


@pulumi.output_type
class GetInterRegionTrafficQosQueuesQueueResult(dict):
    def __init__(__self__, *,
                 dscps: Sequence[_builtins.str],
                 id: _builtins.str,
                 inter_region_traffic_qos_queue_description: _builtins.str,
                 inter_region_traffic_qos_queue_id: _builtins.str,
                 inter_region_traffic_qos_queue_name: _builtins.str,
                 remain_bandwidth_percent: _builtins.int,
                 status: _builtins.str,
                 traffic_qos_policy_id: _builtins.str):
        """
        :param Sequence[_builtins.str] dscps: The DSCP value of the traffic packet to be matched in the current queue, ranging from 0 to 63.
        :param _builtins.str inter_region_traffic_qos_queue_description: The description information of the traffic scheduling policy.
        :param _builtins.str inter_region_traffic_qos_queue_id: The ID of the resource.
        :param _builtins.str inter_region_traffic_qos_queue_name: The name of the traffic scheduling policy.
        :param _builtins.int remain_bandwidth_percent: The percentage of cross-region bandwidth that the current queue can use.
        :param _builtins.str status: The status of the traffic scheduling policy. -**Creating**: The function is being created.-**Active**: available.-**Modifying**: is being modified.-**Deleting**: Deleted.-**Deleted**: Deleted.
        :param _builtins.str traffic_qos_policy_id: The ID of the traffic scheduling policy.
        """
        pulumi.set(__self__, "dscps", dscps)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "inter_region_traffic_qos_queue_description", inter_region_traffic_qos_queue_description)
        pulumi.set(__self__, "inter_region_traffic_qos_queue_id", inter_region_traffic_qos_queue_id)
        pulumi.set(__self__, "inter_region_traffic_qos_queue_name", inter_region_traffic_qos_queue_name)
        pulumi.set(__self__, "remain_bandwidth_percent", remain_bandwidth_percent)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "traffic_qos_policy_id", traffic_qos_policy_id)

    @_builtins.property
    @pulumi.getter
    def dscps(self) -> Sequence[_builtins.str]:
        """
        The DSCP value of the traffic packet to be matched in the current queue, ranging from 0 to 63.
        """
        return pulumi.get(self, "dscps")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="interRegionTrafficQosQueueDescription")
    def inter_region_traffic_qos_queue_description(self) -> _builtins.str:
        """
        The description information of the traffic scheduling policy.
        """
        return pulumi.get(self, "inter_region_traffic_qos_queue_description")

    @_builtins.property
    @pulumi.getter(name="interRegionTrafficQosQueueId")
    def inter_region_traffic_qos_queue_id(self) -> _builtins.str:
        """
        The ID of the resource.
        """
        return pulumi.get(self, "inter_region_traffic_qos_queue_id")

    @_builtins.property
    @pulumi.getter(name="interRegionTrafficQosQueueName")
    def inter_region_traffic_qos_queue_name(self) -> _builtins.str:
        """
        The name of the traffic scheduling policy.
        """
        return pulumi.get(self, "inter_region_traffic_qos_queue_name")

    @_builtins.property
    @pulumi.getter(name="remainBandwidthPercent")
    def remain_bandwidth_percent(self) -> _builtins.int:
        """
        The percentage of cross-region bandwidth that the current queue can use.
        """
        return pulumi.get(self, "remain_bandwidth_percent")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the traffic scheduling policy. -**Creating**: The function is being created.-**Active**: available.-**Modifying**: is being modified.-**Deleting**: Deleted.-**Deleted**: Deleted.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="trafficQosPolicyId")
    def traffic_qos_policy_id(self) -> _builtins.str:
        """
        The ID of the traffic scheduling policy.
        """
        return pulumi.get(self, "traffic_qos_policy_id")


@pulumi.output_type
class GetPrivateZonesZoneResult(dict):
    def __init__(__self__, *,
                 access_region_id: _builtins.str,
                 cen_id: _builtins.str,
                 host_region_id: _builtins.str,
                 host_vpc_id: _builtins.str,
                 id: _builtins.str,
                 private_zone_dns_servers: _builtins.str,
                 status: _builtins.str):
        """
        :param _builtins.str access_region_id: The access region. The access region is the region of the cloud resource that accesses the PrivateZone service through CEN.
        :param _builtins.str cen_id: The ID of the CEN instance.
        :param _builtins.str host_region_id: The service region. The service region is the target region of the PrivateZone service accessed through CEN.
        :param _builtins.str host_vpc_id: The VPC that belongs to the service region.
        :param _builtins.str id: The ID of the private zone. It formats as `<cen_id>:<access_region_id>`.
        :param _builtins.str private_zone_dns_servers: The DNS IP addresses of the PrivateZone service.
        :param _builtins.str status: The status of the PrivateZone service, including `Creating`, `Active` and `Deleting`.
        """
        pulumi.set(__self__, "access_region_id", access_region_id)
        pulumi.set(__self__, "cen_id", cen_id)
        pulumi.set(__self__, "host_region_id", host_region_id)
        pulumi.set(__self__, "host_vpc_id", host_vpc_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "private_zone_dns_servers", private_zone_dns_servers)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="accessRegionId")
    def access_region_id(self) -> _builtins.str:
        """
        The access region. The access region is the region of the cloud resource that accesses the PrivateZone service through CEN.
        """
        return pulumi.get(self, "access_region_id")

    @_builtins.property
    @pulumi.getter(name="cenId")
    def cen_id(self) -> _builtins.str:
        """
        The ID of the CEN instance.
        """
        return pulumi.get(self, "cen_id")

    @_builtins.property
    @pulumi.getter(name="hostRegionId")
    def host_region_id(self) -> _builtins.str:
        """
        The service region. The service region is the target region of the PrivateZone service accessed through CEN.
        """
        return pulumi.get(self, "host_region_id")

    @_builtins.property
    @pulumi.getter(name="hostVpcId")
    def host_vpc_id(self) -> _builtins.str:
        """
        The VPC that belongs to the service region.
        """
        return pulumi.get(self, "host_vpc_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the private zone. It formats as `<cen_id>:<access_region_id>`.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="privateZoneDnsServers")
    def private_zone_dns_servers(self) -> _builtins.str:
        """
        The DNS IP addresses of the PrivateZone service.
        """
        return pulumi.get(self, "private_zone_dns_servers")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the PrivateZone service, including `Creating`, `Active` and `Deleting`.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetRegionRouteEntriesEntryResult(dict):
    def __init__(__self__, *,
                 cidr_block: _builtins.str,
                 next_hop_id: _builtins.str,
                 next_hop_region_id: _builtins.str,
                 next_hop_type: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str cidr_block: The destination CIDR block of the route entry.
        :param _builtins.str next_hop_id: ID of the next hop.
        :param _builtins.str next_hop_region_id: ID of the region where the next hop is located.
        :param _builtins.str next_hop_type: Type of the next hop.
        :param _builtins.str type: Type of the route entry.
        """
        pulumi.set(__self__, "cidr_block", cidr_block)
        pulumi.set(__self__, "next_hop_id", next_hop_id)
        pulumi.set(__self__, "next_hop_region_id", next_hop_region_id)
        pulumi.set(__self__, "next_hop_type", next_hop_type)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="cidrBlock")
    def cidr_block(self) -> _builtins.str:
        """
        The destination CIDR block of the route entry.
        """
        return pulumi.get(self, "cidr_block")

    @_builtins.property
    @pulumi.getter(name="nextHopId")
    def next_hop_id(self) -> _builtins.str:
        """
        ID of the next hop.
        """
        return pulumi.get(self, "next_hop_id")

    @_builtins.property
    @pulumi.getter(name="nextHopRegionId")
    def next_hop_region_id(self) -> _builtins.str:
        """
        ID of the region where the next hop is located.
        """
        return pulumi.get(self, "next_hop_region_id")

    @_builtins.property
    @pulumi.getter(name="nextHopType")
    def next_hop_type(self) -> _builtins.str:
        """
        Type of the next hop.
        """
        return pulumi.get(self, "next_hop_type")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Type of the route entry.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetRouteEntriesEntryResult(dict):
    def __init__(__self__, *,
                 cidr_block: _builtins.str,
                 conflicts: Sequence['outputs.GetRouteEntriesEntryConflictResult'],
                 next_hop_id: _builtins.str,
                 next_hop_type: _builtins.str,
                 operational_mode: _builtins.bool,
                 publish_status: _builtins.str,
                 route_table_id: _builtins.str,
                 route_type: _builtins.str):
        """
        :param _builtins.str cidr_block: The destination CIDR block of the route entry to query.
        :param Sequence['GetRouteEntriesEntryConflictArgs'] conflicts: A list of conflicted Route Entries. Each element contains the following attributes:
        :param _builtins.str next_hop_id: ID of the next hop.
        :param _builtins.str next_hop_type: Type of the next hop, including "Instance", "HaVip" and "RouterInterface".
        :param _builtins.bool operational_mode: Whether to allow the route entry to be published or removed to or from CEN.
        :param _builtins.str publish_status: The publish status of the route entry in CEN, including "Published" and "NonPublished".
        :param _builtins.str route_table_id: ID of the route table of the VPC or VBR.
        :param _builtins.str route_type: Type of the route entry, including "System", "Custom" and "BGP".
        """
        pulumi.set(__self__, "cidr_block", cidr_block)
        pulumi.set(__self__, "conflicts", conflicts)
        pulumi.set(__self__, "next_hop_id", next_hop_id)
        pulumi.set(__self__, "next_hop_type", next_hop_type)
        pulumi.set(__self__, "operational_mode", operational_mode)
        pulumi.set(__self__, "publish_status", publish_status)
        pulumi.set(__self__, "route_table_id", route_table_id)
        pulumi.set(__self__, "route_type", route_type)

    @_builtins.property
    @pulumi.getter(name="cidrBlock")
    def cidr_block(self) -> _builtins.str:
        """
        The destination CIDR block of the route entry to query.
        """
        return pulumi.get(self, "cidr_block")

    @_builtins.property
    @pulumi.getter
    def conflicts(self) -> Sequence['outputs.GetRouteEntriesEntryConflictResult']:
        """
        A list of conflicted Route Entries. Each element contains the following attributes:
        """
        return pulumi.get(self, "conflicts")

    @_builtins.property
    @pulumi.getter(name="nextHopId")
    def next_hop_id(self) -> _builtins.str:
        """
        ID of the next hop.
        """
        return pulumi.get(self, "next_hop_id")

    @_builtins.property
    @pulumi.getter(name="nextHopType")
    def next_hop_type(self) -> _builtins.str:
        """
        Type of the next hop, including "Instance", "HaVip" and "RouterInterface".
        """
        return pulumi.get(self, "next_hop_type")

    @_builtins.property
    @pulumi.getter(name="operationalMode")
    def operational_mode(self) -> _builtins.bool:
        """
        Whether to allow the route entry to be published or removed to or from CEN.
        """
        return pulumi.get(self, "operational_mode")

    @_builtins.property
    @pulumi.getter(name="publishStatus")
    def publish_status(self) -> _builtins.str:
        """
        The publish status of the route entry in CEN, including "Published" and "NonPublished".
        """
        return pulumi.get(self, "publish_status")

    @_builtins.property
    @pulumi.getter(name="routeTableId")
    def route_table_id(self) -> _builtins.str:
        """
        ID of the route table of the VPC or VBR.
        """
        return pulumi.get(self, "route_table_id")

    @_builtins.property
    @pulumi.getter(name="routeType")
    def route_type(self) -> _builtins.str:
        """
        Type of the route entry, including "System", "Custom" and "BGP".
        """
        return pulumi.get(self, "route_type")


@pulumi.output_type
class GetRouteEntriesEntryConflictResult(dict):
    def __init__(__self__, *,
                 cidr_block: _builtins.str,
                 instance_id: _builtins.str,
                 instance_type: _builtins.str,
                 region_id: _builtins.str,
                 status: _builtins.str):
        """
        :param _builtins.str cidr_block: The destination CIDR block of the route entry to query.
        :param _builtins.str instance_id: ID of the CEN instance.
        :param _builtins.str instance_type: The type of the CEN child instance.
        :param _builtins.str region_id: ID of the region where the conflicted route entry is located.
        :param _builtins.str status: Reasons of exceptions.
        """
        pulumi.set(__self__, "cidr_block", cidr_block)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "instance_type", instance_type)
        pulumi.set(__self__, "region_id", region_id)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="cidrBlock")
    def cidr_block(self) -> _builtins.str:
        """
        The destination CIDR block of the route entry to query.
        """
        return pulumi.get(self, "cidr_block")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> _builtins.str:
        """
        ID of the CEN instance.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> _builtins.str:
        """
        The type of the CEN child instance.
        """
        return pulumi.get(self, "instance_type")

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> _builtins.str:
        """
        ID of the region where the conflicted route entry is located.
        """
        return pulumi.get(self, "region_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Reasons of exceptions.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetRouteMapsMapResult(dict):
    def __init__(__self__, *,
                 as_path_match_mode: _builtins.str,
                 cen_id: _builtins.str,
                 cen_region_id: _builtins.str,
                 cidr_match_mode: _builtins.str,
                 community_match_mode: _builtins.str,
                 community_operate_mode: _builtins.str,
                 description: _builtins.str,
                 destination_child_instance_types: Sequence[_builtins.str],
                 destination_cidr_blocks: Sequence[_builtins.str],
                 destination_instance_ids: Sequence[_builtins.str],
                 destination_instance_ids_reverse_match: _builtins.bool,
                 destination_route_table_ids: Sequence[_builtins.str],
                 id: _builtins.str,
                 map_result: _builtins.str,
                 match_asns: Sequence[_builtins.str],
                 match_community_sets: Sequence[_builtins.str],
                 next_priority: _builtins.int,
                 operate_community_sets: Sequence[_builtins.str],
                 preference: _builtins.int,
                 prepend_as_paths: Sequence[_builtins.str],
                 priority: _builtins.int,
                 route_map_id: _builtins.str,
                 route_types: Sequence[_builtins.str],
                 source_child_instance_types: Sequence[_builtins.str],
                 source_instance_ids: Sequence[_builtins.str],
                 source_instance_ids_reverse_match: _builtins.bool,
                 source_region_ids: Sequence[_builtins.str],
                 source_route_table_ids: Sequence[_builtins.str],
                 status: _builtins.str,
                 transmit_direction: _builtins.str):
        """
        :param _builtins.str as_path_match_mode: A match statement. It indicates the mode in which the as-path attribute is matched.
        :param _builtins.str cen_id: The ID of the CEN instance.
        :param _builtins.str cen_region_id: The ID of the region to which the CEN instance belongs.
        :param _builtins.str cidr_match_mode: A match statement. It indicates the mode in which the prefix attribute is matched.
        :param _builtins.str community_match_mode: A match statement. It indicates the mode in which the community attribute is matched.
        :param _builtins.str community_operate_mode: An action statement. It indicates the mode in which the community attribute is operated.
        :param _builtins.str description: The description of the route map.
        :param Sequence[_builtins.str] destination_child_instance_types: A match statement that indicates the list of IDs of the destination instances.
        :param Sequence[_builtins.str] destination_cidr_blocks: A match statement that indicates the prefix list.
        :param Sequence[_builtins.str] destination_instance_ids: A match statement that indicates the list of IDs of the destination instances.
        :param _builtins.bool destination_instance_ids_reverse_match: Indicates whether to enable the reverse match method of the DestinationInstanceIds match condition.
        :param Sequence[_builtins.str] destination_route_table_ids: A match statement that indicates the list of IDs of the destination route tables.
        :param _builtins.str id: The ID of the route map. It formats as `<cen_id>:<route_map_id>`. Before 1.161.0, it is `route_map_id`.
        :param _builtins.str map_result: The action that is performed to a route if the route meets all the match conditions.
        :param Sequence[_builtins.str] match_asns: A match statement that indicates the As path list.
        :param Sequence[_builtins.str] match_community_sets: A match statement that indicates the community set.
        :param _builtins.int next_priority: The priority of the next route map that is associated with the current route map.
        :param Sequence[_builtins.str] operate_community_sets: An action statement that operates the community attribute.
        :param _builtins.int preference: An action statement that modifies the preference of the route.
        :param Sequence[_builtins.str] prepend_as_paths: Indicates AS Path prepending when a regional gateway receives or publishes a route.
        :param _builtins.int priority: The priority of the route map.
        :param _builtins.str route_map_id: The ID of the route map.
        :param Sequence[_builtins.str] route_types: A match statement that indicates the list of route types.
        :param Sequence[_builtins.str] source_child_instance_types: A match statement that indicates the list of IDs of the source instances.
        :param Sequence[_builtins.str] source_instance_ids: A match statement that indicates the list of IDs of the source instances.
        :param _builtins.bool source_instance_ids_reverse_match: Indicates whether to enable the reverse match method of the SourceInstanceIds match condition.
        :param Sequence[_builtins.str] source_region_ids: A match statement that indicates the list of IDs of the source regions.
        :param Sequence[_builtins.str] source_route_table_ids: A match statement that indicates the list of IDs of the source route tables.
        :param _builtins.str status: The status of the route map, including `Creating`, `Active` and `Deleting`.
        :param _builtins.str transmit_direction: The direction in which the route map is applied, including `RegionIn` and `RegionOut`.
        """
        pulumi.set(__self__, "as_path_match_mode", as_path_match_mode)
        pulumi.set(__self__, "cen_id", cen_id)
        pulumi.set(__self__, "cen_region_id", cen_region_id)
        pulumi.set(__self__, "cidr_match_mode", cidr_match_mode)
        pulumi.set(__self__, "community_match_mode", community_match_mode)
        pulumi.set(__self__, "community_operate_mode", community_operate_mode)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "destination_child_instance_types", destination_child_instance_types)
        pulumi.set(__self__, "destination_cidr_blocks", destination_cidr_blocks)
        pulumi.set(__self__, "destination_instance_ids", destination_instance_ids)
        pulumi.set(__self__, "destination_instance_ids_reverse_match", destination_instance_ids_reverse_match)
        pulumi.set(__self__, "destination_route_table_ids", destination_route_table_ids)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "map_result", map_result)
        pulumi.set(__self__, "match_asns", match_asns)
        pulumi.set(__self__, "match_community_sets", match_community_sets)
        pulumi.set(__self__, "next_priority", next_priority)
        pulumi.set(__self__, "operate_community_sets", operate_community_sets)
        pulumi.set(__self__, "preference", preference)
        pulumi.set(__self__, "prepend_as_paths", prepend_as_paths)
        pulumi.set(__self__, "priority", priority)
        pulumi.set(__self__, "route_map_id", route_map_id)
        pulumi.set(__self__, "route_types", route_types)
        pulumi.set(__self__, "source_child_instance_types", source_child_instance_types)
        pulumi.set(__self__, "source_instance_ids", source_instance_ids)
        pulumi.set(__self__, "source_instance_ids_reverse_match", source_instance_ids_reverse_match)
        pulumi.set(__self__, "source_region_ids", source_region_ids)
        pulumi.set(__self__, "source_route_table_ids", source_route_table_ids)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "transmit_direction", transmit_direction)

    @_builtins.property
    @pulumi.getter(name="asPathMatchMode")
    def as_path_match_mode(self) -> _builtins.str:
        """
        A match statement. It indicates the mode in which the as-path attribute is matched.
        """
        return pulumi.get(self, "as_path_match_mode")

    @_builtins.property
    @pulumi.getter(name="cenId")
    def cen_id(self) -> _builtins.str:
        """
        The ID of the CEN instance.
        """
        return pulumi.get(self, "cen_id")

    @_builtins.property
    @pulumi.getter(name="cenRegionId")
    def cen_region_id(self) -> _builtins.str:
        """
        The ID of the region to which the CEN instance belongs.
        """
        return pulumi.get(self, "cen_region_id")

    @_builtins.property
    @pulumi.getter(name="cidrMatchMode")
    def cidr_match_mode(self) -> _builtins.str:
        """
        A match statement. It indicates the mode in which the prefix attribute is matched.
        """
        return pulumi.get(self, "cidr_match_mode")

    @_builtins.property
    @pulumi.getter(name="communityMatchMode")
    def community_match_mode(self) -> _builtins.str:
        """
        A match statement. It indicates the mode in which the community attribute is matched.
        """
        return pulumi.get(self, "community_match_mode")

    @_builtins.property
    @pulumi.getter(name="communityOperateMode")
    def community_operate_mode(self) -> _builtins.str:
        """
        An action statement. It indicates the mode in which the community attribute is operated.
        """
        return pulumi.get(self, "community_operate_mode")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the route map.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="destinationChildInstanceTypes")
    def destination_child_instance_types(self) -> Sequence[_builtins.str]:
        """
        A match statement that indicates the list of IDs of the destination instances.
        """
        return pulumi.get(self, "destination_child_instance_types")

    @_builtins.property
    @pulumi.getter(name="destinationCidrBlocks")
    def destination_cidr_blocks(self) -> Sequence[_builtins.str]:
        """
        A match statement that indicates the prefix list.
        """
        return pulumi.get(self, "destination_cidr_blocks")

    @_builtins.property
    @pulumi.getter(name="destinationInstanceIds")
    def destination_instance_ids(self) -> Sequence[_builtins.str]:
        """
        A match statement that indicates the list of IDs of the destination instances.
        """
        return pulumi.get(self, "destination_instance_ids")

    @_builtins.property
    @pulumi.getter(name="destinationInstanceIdsReverseMatch")
    def destination_instance_ids_reverse_match(self) -> _builtins.bool:
        """
        Indicates whether to enable the reverse match method of the DestinationInstanceIds match condition.
        """
        return pulumi.get(self, "destination_instance_ids_reverse_match")

    @_builtins.property
    @pulumi.getter(name="destinationRouteTableIds")
    def destination_route_table_ids(self) -> Sequence[_builtins.str]:
        """
        A match statement that indicates the list of IDs of the destination route tables.
        """
        return pulumi.get(self, "destination_route_table_ids")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the route map. It formats as `<cen_id>:<route_map_id>`. Before 1.161.0, it is `route_map_id`.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="mapResult")
    def map_result(self) -> _builtins.str:
        """
        The action that is performed to a route if the route meets all the match conditions.
        """
        return pulumi.get(self, "map_result")

    @_builtins.property
    @pulumi.getter(name="matchAsns")
    def match_asns(self) -> Sequence[_builtins.str]:
        """
        A match statement that indicates the As path list.
        """
        return pulumi.get(self, "match_asns")

    @_builtins.property
    @pulumi.getter(name="matchCommunitySets")
    def match_community_sets(self) -> Sequence[_builtins.str]:
        """
        A match statement that indicates the community set.
        """
        return pulumi.get(self, "match_community_sets")

    @_builtins.property
    @pulumi.getter(name="nextPriority")
    def next_priority(self) -> _builtins.int:
        """
        The priority of the next route map that is associated with the current route map.
        """
        return pulumi.get(self, "next_priority")

    @_builtins.property
    @pulumi.getter(name="operateCommunitySets")
    def operate_community_sets(self) -> Sequence[_builtins.str]:
        """
        An action statement that operates the community attribute.
        """
        return pulumi.get(self, "operate_community_sets")

    @_builtins.property
    @pulumi.getter
    def preference(self) -> _builtins.int:
        """
        An action statement that modifies the preference of the route.
        """
        return pulumi.get(self, "preference")

    @_builtins.property
    @pulumi.getter(name="prependAsPaths")
    def prepend_as_paths(self) -> Sequence[_builtins.str]:
        """
        Indicates AS Path prepending when a regional gateway receives or publishes a route.
        """
        return pulumi.get(self, "prepend_as_paths")

    @_builtins.property
    @pulumi.getter
    def priority(self) -> _builtins.int:
        """
        The priority of the route map.
        """
        return pulumi.get(self, "priority")

    @_builtins.property
    @pulumi.getter(name="routeMapId")
    def route_map_id(self) -> _builtins.str:
        """
        The ID of the route map.
        """
        return pulumi.get(self, "route_map_id")

    @_builtins.property
    @pulumi.getter(name="routeTypes")
    def route_types(self) -> Sequence[_builtins.str]:
        """
        A match statement that indicates the list of route types.
        """
        return pulumi.get(self, "route_types")

    @_builtins.property
    @pulumi.getter(name="sourceChildInstanceTypes")
    def source_child_instance_types(self) -> Sequence[_builtins.str]:
        """
        A match statement that indicates the list of IDs of the source instances.
        """
        return pulumi.get(self, "source_child_instance_types")

    @_builtins.property
    @pulumi.getter(name="sourceInstanceIds")
    def source_instance_ids(self) -> Sequence[_builtins.str]:
        """
        A match statement that indicates the list of IDs of the source instances.
        """
        return pulumi.get(self, "source_instance_ids")

    @_builtins.property
    @pulumi.getter(name="sourceInstanceIdsReverseMatch")
    def source_instance_ids_reverse_match(self) -> _builtins.bool:
        """
        Indicates whether to enable the reverse match method of the SourceInstanceIds match condition.
        """
        return pulumi.get(self, "source_instance_ids_reverse_match")

    @_builtins.property
    @pulumi.getter(name="sourceRegionIds")
    def source_region_ids(self) -> Sequence[_builtins.str]:
        """
        A match statement that indicates the list of IDs of the source regions.
        """
        return pulumi.get(self, "source_region_ids")

    @_builtins.property
    @pulumi.getter(name="sourceRouteTableIds")
    def source_route_table_ids(self) -> Sequence[_builtins.str]:
        """
        A match statement that indicates the list of IDs of the source route tables.
        """
        return pulumi.get(self, "source_route_table_ids")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the route map, including `Creating`, `Active` and `Deleting`.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="transmitDirection")
    def transmit_direction(self) -> _builtins.str:
        """
        The direction in which the route map is applied, including `RegionIn` and `RegionOut`.
        """
        return pulumi.get(self, "transmit_direction")


@pulumi.output_type
class GetRouteServicesServiceResult(dict):
    def __init__(__self__, *,
                 access_region_id: _builtins.str,
                 cen_id: _builtins.str,
                 cidrs: Sequence[_builtins.str],
                 description: _builtins.str,
                 host: _builtins.str,
                 host_region_id: _builtins.str,
                 host_vpc_id: _builtins.str,
                 id: _builtins.str,
                 status: _builtins.str,
                 update_interval: _builtins.str):
        """
        :param _builtins.str access_region_id: The region of the network instances that access the cloud services.
        :param _builtins.str cen_id: The ID of the CEN instance.
        :param Sequence[_builtins.str] cidrs: The IP address of the cloud service.
        :param _builtins.str description: The description of the cloud service.
        :param _builtins.str host: The domain name or IP address of the cloud service.
        :param _builtins.str host_region_id: The region of the cloud service.
        :param _builtins.str host_vpc_id: The VPC associated with the cloud service.
        :param _builtins.str id: The ID of the route service.
        :param _builtins.str status: The status of the cloud service. Valid values: `Active`, `Creating` and `Deleting`.
        :param _builtins.str update_interval: The update interval. Default value: 5. The value cannot be modified.
        """
        pulumi.set(__self__, "access_region_id", access_region_id)
        pulumi.set(__self__, "cen_id", cen_id)
        pulumi.set(__self__, "cidrs", cidrs)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "host_region_id", host_region_id)
        pulumi.set(__self__, "host_vpc_id", host_vpc_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "update_interval", update_interval)

    @_builtins.property
    @pulumi.getter(name="accessRegionId")
    def access_region_id(self) -> _builtins.str:
        """
        The region of the network instances that access the cloud services.
        """
        return pulumi.get(self, "access_region_id")

    @_builtins.property
    @pulumi.getter(name="cenId")
    def cen_id(self) -> _builtins.str:
        """
        The ID of the CEN instance.
        """
        return pulumi.get(self, "cen_id")

    @_builtins.property
    @pulumi.getter
    def cidrs(self) -> Sequence[_builtins.str]:
        """
        The IP address of the cloud service.
        """
        return pulumi.get(self, "cidrs")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the cloud service.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def host(self) -> _builtins.str:
        """
        The domain name or IP address of the cloud service.
        """
        return pulumi.get(self, "host")

    @_builtins.property
    @pulumi.getter(name="hostRegionId")
    def host_region_id(self) -> _builtins.str:
        """
        The region of the cloud service.
        """
        return pulumi.get(self, "host_region_id")

    @_builtins.property
    @pulumi.getter(name="hostVpcId")
    def host_vpc_id(self) -> _builtins.str:
        """
        The VPC associated with the cloud service.
        """
        return pulumi.get(self, "host_vpc_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the route service.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the cloud service. Valid values: `Active`, `Creating` and `Deleting`.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="updateInterval")
    def update_interval(self) -> _builtins.str:
        """
        The update interval. Default value: 5. The value cannot be modified.
        """
        return pulumi.get(self, "update_interval")


@pulumi.output_type
class GetTrafficMarkingPoliciesPolicyResult(dict):
    def __init__(__self__, *,
                 description: _builtins.str,
                 id: _builtins.str,
                 marking_dscp: _builtins.int,
                 priority: _builtins.int,
                 status: _builtins.str,
                 traffic_marking_policy_id: _builtins.str,
                 traffic_marking_policy_name: _builtins.str,
                 transit_router_id: _builtins.str):
        """
        :param _builtins.str description: The description of the Traffic Marking Policy.
        :param _builtins.str id: The ID of the resource. The value is formatted `<transit_router_id>:<traffic_marking_policy_id>`.
        :param _builtins.int marking_dscp: The DSCP(Differentiated Services Code Point) of the Traffic Marking Policy.
        :param _builtins.int priority: The Priority of the Traffic Marking Policy.
        :param _builtins.str status: The status of the resource.
        :param _builtins.str traffic_marking_policy_id: The ID of the Traffic Marking Policy.
        :param _builtins.str traffic_marking_policy_name: The name of the Traffic Marking Policy.
        :param _builtins.str transit_router_id: The ID of the transit router.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "marking_dscp", marking_dscp)
        pulumi.set(__self__, "priority", priority)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "traffic_marking_policy_id", traffic_marking_policy_id)
        pulumi.set(__self__, "traffic_marking_policy_name", traffic_marking_policy_name)
        pulumi.set(__self__, "transit_router_id", transit_router_id)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the Traffic Marking Policy.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the resource. The value is formatted `<transit_router_id>:<traffic_marking_policy_id>`.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="markingDscp")
    def marking_dscp(self) -> _builtins.int:
        """
        The DSCP(Differentiated Services Code Point) of the Traffic Marking Policy.
        """
        return pulumi.get(self, "marking_dscp")

    @_builtins.property
    @pulumi.getter
    def priority(self) -> _builtins.int:
        """
        The Priority of the Traffic Marking Policy.
        """
        return pulumi.get(self, "priority")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the resource.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="trafficMarkingPolicyId")
    def traffic_marking_policy_id(self) -> _builtins.str:
        """
        The ID of the Traffic Marking Policy.
        """
        return pulumi.get(self, "traffic_marking_policy_id")

    @_builtins.property
    @pulumi.getter(name="trafficMarkingPolicyName")
    def traffic_marking_policy_name(self) -> _builtins.str:
        """
        The name of the Traffic Marking Policy.
        """
        return pulumi.get(self, "traffic_marking_policy_name")

    @_builtins.property
    @pulumi.getter(name="transitRouterId")
    def transit_router_id(self) -> _builtins.str:
        """
        The ID of the transit router.
        """
        return pulumi.get(self, "transit_router_id")


@pulumi.output_type
class GetTransitRouteTableAggregationsTransitRouteTableAggregationResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 route_type: _builtins.str,
                 status: _builtins.str,
                 transit_route_table_aggregation_cidr: _builtins.str,
                 transit_route_table_aggregation_description: _builtins.str,
                 transit_route_table_aggregation_name: _builtins.str,
                 transit_route_table_aggregation_scope: _builtins.str,
                 transit_route_table_id: _builtins.str):
        """
        :param _builtins.str id: The ID of the Transit Route Table Aggregation. It formats as `<transit_route_table_id>:<transit_route_table_aggregation_cidr>`.
        :param _builtins.str route_type: The route type of the aggregate route.
        :param _builtins.str status: The status of Transit Route Table Aggregation. Valid Values: `AllConfigured`, `Configuring`, `ConfigFailed`, `PartialConfigured`, `Deleting`.
        :param _builtins.str transit_route_table_aggregation_cidr: The destination CIDR block of the aggregate route.
        :param _builtins.str transit_route_table_aggregation_description: The description of the aggregate route.
        :param _builtins.str transit_route_table_aggregation_name: The name of the aggregate route.
        :param _builtins.str transit_route_table_aggregation_scope: The scope of networks that you want to advertise the aggregate route.
        :param _builtins.str transit_route_table_id: The ID of the route table of the Enterprise Edition transit router.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "route_type", route_type)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "transit_route_table_aggregation_cidr", transit_route_table_aggregation_cidr)
        pulumi.set(__self__, "transit_route_table_aggregation_description", transit_route_table_aggregation_description)
        pulumi.set(__self__, "transit_route_table_aggregation_name", transit_route_table_aggregation_name)
        pulumi.set(__self__, "transit_route_table_aggregation_scope", transit_route_table_aggregation_scope)
        pulumi.set(__self__, "transit_route_table_id", transit_route_table_id)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Transit Route Table Aggregation. It formats as `<transit_route_table_id>:<transit_route_table_aggregation_cidr>`.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="routeType")
    def route_type(self) -> _builtins.str:
        """
        The route type of the aggregate route.
        """
        return pulumi.get(self, "route_type")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of Transit Route Table Aggregation. Valid Values: `AllConfigured`, `Configuring`, `ConfigFailed`, `PartialConfigured`, `Deleting`.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="transitRouteTableAggregationCidr")
    def transit_route_table_aggregation_cidr(self) -> _builtins.str:
        """
        The destination CIDR block of the aggregate route.
        """
        return pulumi.get(self, "transit_route_table_aggregation_cidr")

    @_builtins.property
    @pulumi.getter(name="transitRouteTableAggregationDescription")
    def transit_route_table_aggregation_description(self) -> _builtins.str:
        """
        The description of the aggregate route.
        """
        return pulumi.get(self, "transit_route_table_aggregation_description")

    @_builtins.property
    @pulumi.getter(name="transitRouteTableAggregationName")
    def transit_route_table_aggregation_name(self) -> _builtins.str:
        """
        The name of the aggregate route.
        """
        return pulumi.get(self, "transit_route_table_aggregation_name")

    @_builtins.property
    @pulumi.getter(name="transitRouteTableAggregationScope")
    def transit_route_table_aggregation_scope(self) -> _builtins.str:
        """
        The scope of networks that you want to advertise the aggregate route.
        """
        return pulumi.get(self, "transit_route_table_aggregation_scope")

    @_builtins.property
    @pulumi.getter(name="transitRouteTableId")
    def transit_route_table_id(self) -> _builtins.str:
        """
        The ID of the route table of the Enterprise Edition transit router.
        """
        return pulumi.get(self, "transit_route_table_id")


@pulumi.output_type
class GetTransitRouterAvailableResourcesResourceResult(dict):
    def __init__(__self__, *,
                 available_zones: Sequence[_builtins.str],
                 master_zones: Sequence[_builtins.str],
                 slave_zones: Sequence[_builtins.str],
                 support_multicast: _builtins.bool):
        """
        :param Sequence[_builtins.str] available_zones: (Available since v1.225.0) The list of available zones.
        :param Sequence[_builtins.str] master_zones: The list of primary zones.
        :param Sequence[_builtins.str] slave_zones: The list of secondary zones.
        :param _builtins.bool support_multicast: Specifies whether to query only the zones in which the multicast feature is supported.
        """
        pulumi.set(__self__, "available_zones", available_zones)
        pulumi.set(__self__, "master_zones", master_zones)
        pulumi.set(__self__, "slave_zones", slave_zones)
        pulumi.set(__self__, "support_multicast", support_multicast)

    @_builtins.property
    @pulumi.getter(name="availableZones")
    def available_zones(self) -> Sequence[_builtins.str]:
        """
        (Available since v1.225.0) The list of available zones.
        """
        return pulumi.get(self, "available_zones")

    @_builtins.property
    @pulumi.getter(name="masterZones")
    def master_zones(self) -> Sequence[_builtins.str]:
        """
        The list of primary zones.
        """
        return pulumi.get(self, "master_zones")

    @_builtins.property
    @pulumi.getter(name="slaveZones")
    def slave_zones(self) -> Sequence[_builtins.str]:
        """
        The list of secondary zones.
        """
        return pulumi.get(self, "slave_zones")

    @_builtins.property
    @pulumi.getter(name="supportMulticast")
    def support_multicast(self) -> _builtins.bool:
        """
        Specifies whether to query only the zones in which the multicast feature is supported.
        """
        return pulumi.get(self, "support_multicast")


@pulumi.output_type
class GetTransitRouterCidrsCidrResult(dict):
    def __init__(__self__, *,
                 cidr: _builtins.str,
                 description: _builtins.str,
                 family: _builtins.str,
                 id: _builtins.str,
                 publish_cidr_route: _builtins.bool,
                 transit_router_cidr_id: _builtins.str,
                 transit_router_cidr_name: _builtins.str,
                 transit_router_id: _builtins.str):
        """
        :param _builtins.str cidr: The cidr of the transit router.
        :param _builtins.str description: The description of the transit router.
        :param _builtins.str family: The type of the transit router cidr.
        :param _builtins.str id: The ID of the Cen Transit Router Cidr. It formats as `<transit_router_id>:<transit_router_cidr_id>`.
        :param _builtins.bool publish_cidr_route: Whether to allow automatically adding Transit Router Cidr in Transit Router Route Table.
        :param _builtins.str transit_router_cidr_id: The ID of the transit router cidr.
        :param _builtins.str transit_router_cidr_name: The name of the transit router.
        :param _builtins.str transit_router_id: The ID of the transit router.
        """
        pulumi.set(__self__, "cidr", cidr)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "family", family)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "publish_cidr_route", publish_cidr_route)
        pulumi.set(__self__, "transit_router_cidr_id", transit_router_cidr_id)
        pulumi.set(__self__, "transit_router_cidr_name", transit_router_cidr_name)
        pulumi.set(__self__, "transit_router_id", transit_router_id)

    @_builtins.property
    @pulumi.getter
    def cidr(self) -> _builtins.str:
        """
        The cidr of the transit router.
        """
        return pulumi.get(self, "cidr")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the transit router.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def family(self) -> _builtins.str:
        """
        The type of the transit router cidr.
        """
        return pulumi.get(self, "family")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Cen Transit Router Cidr. It formats as `<transit_router_id>:<transit_router_cidr_id>`.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="publishCidrRoute")
    def publish_cidr_route(self) -> _builtins.bool:
        """
        Whether to allow automatically adding Transit Router Cidr in Transit Router Route Table.
        """
        return pulumi.get(self, "publish_cidr_route")

    @_builtins.property
    @pulumi.getter(name="transitRouterCidrId")
    def transit_router_cidr_id(self) -> _builtins.str:
        """
        The ID of the transit router cidr.
        """
        return pulumi.get(self, "transit_router_cidr_id")

    @_builtins.property
    @pulumi.getter(name="transitRouterCidrName")
    def transit_router_cidr_name(self) -> _builtins.str:
        """
        The name of the transit router.
        """
        return pulumi.get(self, "transit_router_cidr_name")

    @_builtins.property
    @pulumi.getter(name="transitRouterId")
    def transit_router_id(self) -> _builtins.str:
        """
        The ID of the transit router.
        """
        return pulumi.get(self, "transit_router_id")


@pulumi.output_type
class GetTransitRouterMulticastDomainAssociationsAssociationResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 resource_id: _builtins.str,
                 resource_owner_id: _builtins.int,
                 resource_type: _builtins.str,
                 status: _builtins.str,
                 transit_router_attachment_id: _builtins.str,
                 transit_router_multicast_domain_id: _builtins.str,
                 vswitch_id: _builtins.str):
        """
        :param _builtins.str id: The ID of the Transit Router Multicast Domain Association. It formats as `<transit_router_multicast_domain_id>:<transit_router_attachment_id>:<vswitch_id>`.
        :param _builtins.str resource_id: The ID of the resource associated with the multicast domain.
        :param _builtins.int resource_owner_id: The ID of the Alibaba Cloud account to which the resource associated with the multicast domain belongs.
        :param _builtins.str resource_type: The type of resource associated with the multicast domain. Valid Value: `VPC`.
        :param _builtins.str status: The status of the associated resource. Valid Value: `Associated`, `Associating`, `Dissociating`.
        :param _builtins.str transit_router_attachment_id: The ID of the network instance connection.
        :param _builtins.str transit_router_multicast_domain_id: The ID of the multicast domain.
        :param _builtins.str vswitch_id: The ID of the vSwitch.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "resource_id", resource_id)
        pulumi.set(__self__, "resource_owner_id", resource_owner_id)
        pulumi.set(__self__, "resource_type", resource_type)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "transit_router_attachment_id", transit_router_attachment_id)
        pulumi.set(__self__, "transit_router_multicast_domain_id", transit_router_multicast_domain_id)
        pulumi.set(__self__, "vswitch_id", vswitch_id)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Transit Router Multicast Domain Association. It formats as `<transit_router_multicast_domain_id>:<transit_router_attachment_id>:<vswitch_id>`.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> _builtins.str:
        """
        The ID of the resource associated with the multicast domain.
        """
        return pulumi.get(self, "resource_id")

    @_builtins.property
    @pulumi.getter(name="resourceOwnerId")
    def resource_owner_id(self) -> _builtins.int:
        """
        The ID of the Alibaba Cloud account to which the resource associated with the multicast domain belongs.
        """
        return pulumi.get(self, "resource_owner_id")

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> _builtins.str:
        """
        The type of resource associated with the multicast domain. Valid Value: `VPC`.
        """
        return pulumi.get(self, "resource_type")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the associated resource. Valid Value: `Associated`, `Associating`, `Dissociating`.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="transitRouterAttachmentId")
    def transit_router_attachment_id(self) -> _builtins.str:
        """
        The ID of the network instance connection.
        """
        return pulumi.get(self, "transit_router_attachment_id")

    @_builtins.property
    @pulumi.getter(name="transitRouterMulticastDomainId")
    def transit_router_multicast_domain_id(self) -> _builtins.str:
        """
        The ID of the multicast domain.
        """
        return pulumi.get(self, "transit_router_multicast_domain_id")

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> _builtins.str:
        """
        The ID of the vSwitch.
        """
        return pulumi.get(self, "vswitch_id")


@pulumi.output_type
class GetTransitRouterMulticastDomainMembersMemberResult(dict):
    def __init__(__self__, *,
                 group_ip_address: _builtins.str,
                 id: _builtins.str,
                 network_interface_id: _builtins.str,
                 status: _builtins.str,
                 transit_router_multicast_domain_id: _builtins.str,
                 vpc_id: _builtins.str):
        """
        :param _builtins.str group_ip_address: The IP address of the multicast group to which the multicast member belongs. If the multicast group you specified does not exist in the current multicast domain, the system will automatically create a new multicast group for you in the current multicast domain.
        :param _builtins.str id: The `key` of the resource supplied above.The value is formulated as `<transit_router_multicast_domain_id>:<group_ip_address>:<network_interface_id>`.
        :param _builtins.str network_interface_id: The ID of the ENI.
        :param _builtins.str status: The status of the resource
        :param _builtins.str transit_router_multicast_domain_id: The ID of the multicast domain to which the multicast member belongs.
        :param _builtins.str vpc_id: The VPC to which the ENI of the multicast member belongs. This field is mandatory for VPCs owned by another accounts.
        """
        pulumi.set(__self__, "group_ip_address", group_ip_address)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "network_interface_id", network_interface_id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "transit_router_multicast_domain_id", transit_router_multicast_domain_id)
        pulumi.set(__self__, "vpc_id", vpc_id)

    @_builtins.property
    @pulumi.getter(name="groupIpAddress")
    def group_ip_address(self) -> _builtins.str:
        """
        The IP address of the multicast group to which the multicast member belongs. If the multicast group you specified does not exist in the current multicast domain, the system will automatically create a new multicast group for you in the current multicast domain.
        """
        return pulumi.get(self, "group_ip_address")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The `key` of the resource supplied above.The value is formulated as `<transit_router_multicast_domain_id>:<group_ip_address>:<network_interface_id>`.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="networkInterfaceId")
    def network_interface_id(self) -> _builtins.str:
        """
        The ID of the ENI.
        """
        return pulumi.get(self, "network_interface_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the resource
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="transitRouterMulticastDomainId")
    def transit_router_multicast_domain_id(self) -> _builtins.str:
        """
        The ID of the multicast domain to which the multicast member belongs.
        """
        return pulumi.get(self, "transit_router_multicast_domain_id")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> _builtins.str:
        """
        The VPC to which the ENI of the multicast member belongs. This field is mandatory for VPCs owned by another accounts.
        """
        return pulumi.get(self, "vpc_id")


@pulumi.output_type
class GetTransitRouterMulticastDomainPeerMembersMemberResult(dict):
    def __init__(__self__, *,
                 group_ip_address: _builtins.str,
                 id: _builtins.str,
                 peer_transit_router_multicast_domain_id: _builtins.str,
                 status: _builtins.str,
                 transit_router_multicast_domain_id: _builtins.str):
        """
        :param _builtins.str group_ip_address: The IP address of the multicast group to which the multicast member belongs. Value range: **224.0.0.1** to **239.255.255.254**.If the multicast group you specified does not exist in the current multicast domain, the system will automatically create a new multicast group for you in the current multicast domain.
        :param _builtins.str id: The `key` of the resource supplied above.The value is formulated as `<transit_router_multicast_domain_id>:<group_ip_address>:<peer_transit_router_multicast_domain_id>`.
        :param _builtins.str peer_transit_router_multicast_domain_id: The multicast domain ID of the peer transit router.
        :param _builtins.str status: The status of the resource
        :param _builtins.str transit_router_multicast_domain_id: The ID of the multicast domain to which the multicast member belongs.
        """
        pulumi.set(__self__, "group_ip_address", group_ip_address)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "peer_transit_router_multicast_domain_id", peer_transit_router_multicast_domain_id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "transit_router_multicast_domain_id", transit_router_multicast_domain_id)

    @_builtins.property
    @pulumi.getter(name="groupIpAddress")
    def group_ip_address(self) -> _builtins.str:
        """
        The IP address of the multicast group to which the multicast member belongs. Value range: **224.0.0.1** to **239.255.255.254**.If the multicast group you specified does not exist in the current multicast domain, the system will automatically create a new multicast group for you in the current multicast domain.
        """
        return pulumi.get(self, "group_ip_address")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The `key` of the resource supplied above.The value is formulated as `<transit_router_multicast_domain_id>:<group_ip_address>:<peer_transit_router_multicast_domain_id>`.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="peerTransitRouterMulticastDomainId")
    def peer_transit_router_multicast_domain_id(self) -> _builtins.str:
        """
        The multicast domain ID of the peer transit router.
        """
        return pulumi.get(self, "peer_transit_router_multicast_domain_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the resource
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="transitRouterMulticastDomainId")
    def transit_router_multicast_domain_id(self) -> _builtins.str:
        """
        The ID of the multicast domain to which the multicast member belongs.
        """
        return pulumi.get(self, "transit_router_multicast_domain_id")


@pulumi.output_type
class GetTransitRouterMulticastDomainSourcesSourceResult(dict):
    def __init__(__self__, *,
                 group_ip_address: _builtins.str,
                 id: _builtins.str,
                 network_interface_id: _builtins.str,
                 status: _builtins.str,
                 transit_router_multicast_domain_id: _builtins.str,
                 vpc_id: _builtins.str):
        """
        :param _builtins.str group_ip_address: The IP address of the multicast group to which the multicast source belongs. Value range: **224.0.0.1** to **239.255.255.254**. If the multicast group you specified does not exist in the current multicast domain, the system will automatically create a new multicast group for you.
        :param _builtins.str id: The id of the resource.
        :param _builtins.str network_interface_id: ENI ID of the multicast source.
        :param _builtins.str status: The status of the resource.
        :param _builtins.str transit_router_multicast_domain_id: The ID of the multicast domain to which the multicast source belongs.
        :param _builtins.str vpc_id: The VPC to which the ENI of the multicast source belongs. This field is mandatory for VPCs that is owned by another accounts.
        """
        pulumi.set(__self__, "group_ip_address", group_ip_address)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "network_interface_id", network_interface_id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "transit_router_multicast_domain_id", transit_router_multicast_domain_id)
        pulumi.set(__self__, "vpc_id", vpc_id)

    @_builtins.property
    @pulumi.getter(name="groupIpAddress")
    def group_ip_address(self) -> _builtins.str:
        """
        The IP address of the multicast group to which the multicast source belongs. Value range: **224.0.0.1** to **239.255.255.254**. If the multicast group you specified does not exist in the current multicast domain, the system will automatically create a new multicast group for you.
        """
        return pulumi.get(self, "group_ip_address")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The id of the resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="networkInterfaceId")
    def network_interface_id(self) -> _builtins.str:
        """
        ENI ID of the multicast source.
        """
        return pulumi.get(self, "network_interface_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the resource.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="transitRouterMulticastDomainId")
    def transit_router_multicast_domain_id(self) -> _builtins.str:
        """
        The ID of the multicast domain to which the multicast source belongs.
        """
        return pulumi.get(self, "transit_router_multicast_domain_id")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> _builtins.str:
        """
        The VPC to which the ENI of the multicast source belongs. This field is mandatory for VPCs that is owned by another accounts.
        """
        return pulumi.get(self, "vpc_id")


@pulumi.output_type
class GetTransitRouterMulticastDomainsDomainResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 status: _builtins.str,
                 transit_router_id: _builtins.str,
                 transit_router_multicast_domain_description: _builtins.str,
                 transit_router_multicast_domain_id: _builtins.str,
                 transit_router_multicast_domain_name: _builtins.str):
        """
        :param _builtins.str id: The ID of the Transit Router Multicast Domain.
        :param _builtins.str status: The status of the multicast domain. Valid Value: `Active`.
        :param _builtins.str transit_router_id: The ID of the transit router.
        :param _builtins.str transit_router_multicast_domain_description: The description of the Transit Router Multicast Domain.
        :param _builtins.str transit_router_multicast_domain_id: The ID of the multicast domain.
        :param _builtins.str transit_router_multicast_domain_name: The name of the Transit Router Multicast Domain.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "transit_router_id", transit_router_id)
        pulumi.set(__self__, "transit_router_multicast_domain_description", transit_router_multicast_domain_description)
        pulumi.set(__self__, "transit_router_multicast_domain_id", transit_router_multicast_domain_id)
        pulumi.set(__self__, "transit_router_multicast_domain_name", transit_router_multicast_domain_name)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Transit Router Multicast Domain.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the multicast domain. Valid Value: `Active`.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="transitRouterId")
    def transit_router_id(self) -> _builtins.str:
        """
        The ID of the transit router.
        """
        return pulumi.get(self, "transit_router_id")

    @_builtins.property
    @pulumi.getter(name="transitRouterMulticastDomainDescription")
    def transit_router_multicast_domain_description(self) -> _builtins.str:
        """
        The description of the Transit Router Multicast Domain.
        """
        return pulumi.get(self, "transit_router_multicast_domain_description")

    @_builtins.property
    @pulumi.getter(name="transitRouterMulticastDomainId")
    def transit_router_multicast_domain_id(self) -> _builtins.str:
        """
        The ID of the multicast domain.
        """
        return pulumi.get(self, "transit_router_multicast_domain_id")

    @_builtins.property
    @pulumi.getter(name="transitRouterMulticastDomainName")
    def transit_router_multicast_domain_name(self) -> _builtins.str:
        """
        The name of the Transit Router Multicast Domain.
        """
        return pulumi.get(self, "transit_router_multicast_domain_name")


@pulumi.output_type
class GetTransitRouterPeerAttachmentsAttachmentResult(dict):
    def __init__(__self__, *,
                 auto_publish_route_enabled: _builtins.bool,
                 bandwidth: _builtins.int,
                 cen_bandwidth_package_id: _builtins.str,
                 geographic_span_id: _builtins.str,
                 id: _builtins.str,
                 peer_transit_router_id: _builtins.str,
                 peer_transit_router_owner_id: _builtins.str,
                 peer_transit_router_region_id: _builtins.str,
                 resource_type: _builtins.str,
                 status: _builtins.str,
                 transit_router_attachment_description: _builtins.str,
                 transit_router_attachment_id: _builtins.str,
                 transit_router_attachment_name: _builtins.str,
                 transit_router_id: _builtins.str):
        """
        :param _builtins.bool auto_publish_route_enabled: Auto publish route enabled.
        :param _builtins.int bandwidth: The bandwidth of the bandwidth package.
        :param _builtins.str cen_bandwidth_package_id: ID of the CEN bandwidth package.
        :param _builtins.str geographic_span_id: ID of the geographic.
        :param _builtins.str id: The ID of CEN Transit Router peer attachments.
        :param _builtins.str peer_transit_router_id: ID of the peer transit router.
        :param _builtins.str peer_transit_router_owner_id: Owner ID of the peer transit router.
        :param _builtins.str peer_transit_router_region_id: Region ID of the peer transit router.
        :param _builtins.str resource_type: Type of the resource.
        :param _builtins.str status: The status of CEN Transit Router peer attachment. Valid values `Attached`, `Attaching` and `Detaching`.
        :param _builtins.str transit_router_attachment_description: The description of CEN Transit Router peer attachments.
        :param _builtins.str transit_router_attachment_id: The ID of CEN Transit Router peer attachments.
        :param _builtins.str transit_router_attachment_name: Name of the transit router attachment.
        :param _builtins.str transit_router_id: The ID of transit router.
        """
        pulumi.set(__self__, "auto_publish_route_enabled", auto_publish_route_enabled)
        pulumi.set(__self__, "bandwidth", bandwidth)
        pulumi.set(__self__, "cen_bandwidth_package_id", cen_bandwidth_package_id)
        pulumi.set(__self__, "geographic_span_id", geographic_span_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "peer_transit_router_id", peer_transit_router_id)
        pulumi.set(__self__, "peer_transit_router_owner_id", peer_transit_router_owner_id)
        pulumi.set(__self__, "peer_transit_router_region_id", peer_transit_router_region_id)
        pulumi.set(__self__, "resource_type", resource_type)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "transit_router_attachment_description", transit_router_attachment_description)
        pulumi.set(__self__, "transit_router_attachment_id", transit_router_attachment_id)
        pulumi.set(__self__, "transit_router_attachment_name", transit_router_attachment_name)
        pulumi.set(__self__, "transit_router_id", transit_router_id)

    @_builtins.property
    @pulumi.getter(name="autoPublishRouteEnabled")
    def auto_publish_route_enabled(self) -> _builtins.bool:
        """
        Auto publish route enabled.
        """
        return pulumi.get(self, "auto_publish_route_enabled")

    @_builtins.property
    @pulumi.getter
    def bandwidth(self) -> _builtins.int:
        """
        The bandwidth of the bandwidth package.
        """
        return pulumi.get(self, "bandwidth")

    @_builtins.property
    @pulumi.getter(name="cenBandwidthPackageId")
    def cen_bandwidth_package_id(self) -> _builtins.str:
        """
        ID of the CEN bandwidth package.
        """
        return pulumi.get(self, "cen_bandwidth_package_id")

    @_builtins.property
    @pulumi.getter(name="geographicSpanId")
    def geographic_span_id(self) -> _builtins.str:
        """
        ID of the geographic.
        """
        return pulumi.get(self, "geographic_span_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of CEN Transit Router peer attachments.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="peerTransitRouterId")
    def peer_transit_router_id(self) -> _builtins.str:
        """
        ID of the peer transit router.
        """
        return pulumi.get(self, "peer_transit_router_id")

    @_builtins.property
    @pulumi.getter(name="peerTransitRouterOwnerId")
    def peer_transit_router_owner_id(self) -> _builtins.str:
        """
        Owner ID of the peer transit router.
        """
        return pulumi.get(self, "peer_transit_router_owner_id")

    @_builtins.property
    @pulumi.getter(name="peerTransitRouterRegionId")
    def peer_transit_router_region_id(self) -> _builtins.str:
        """
        Region ID of the peer transit router.
        """
        return pulumi.get(self, "peer_transit_router_region_id")

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> _builtins.str:
        """
        Type of the resource.
        """
        return pulumi.get(self, "resource_type")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of CEN Transit Router peer attachment. Valid values `Attached`, `Attaching` and `Detaching`.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="transitRouterAttachmentDescription")
    def transit_router_attachment_description(self) -> _builtins.str:
        """
        The description of CEN Transit Router peer attachments.
        """
        return pulumi.get(self, "transit_router_attachment_description")

    @_builtins.property
    @pulumi.getter(name="transitRouterAttachmentId")
    def transit_router_attachment_id(self) -> _builtins.str:
        """
        The ID of CEN Transit Router peer attachments.
        """
        return pulumi.get(self, "transit_router_attachment_id")

    @_builtins.property
    @pulumi.getter(name="transitRouterAttachmentName")
    def transit_router_attachment_name(self) -> _builtins.str:
        """
        Name of the transit router attachment.
        """
        return pulumi.get(self, "transit_router_attachment_name")

    @_builtins.property
    @pulumi.getter(name="transitRouterId")
    def transit_router_id(self) -> _builtins.str:
        """
        The ID of transit router.
        """
        return pulumi.get(self, "transit_router_id")


@pulumi.output_type
class GetTransitRouterPrefixListAssociationsAssociationResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 next_hop: _builtins.str,
                 next_hop_instance_id: _builtins.str,
                 next_hop_type: _builtins.str,
                 owner_uid: _builtins.int,
                 prefix_list_id: _builtins.str,
                 status: _builtins.str,
                 transit_router_id: _builtins.str,
                 transit_router_table_id: _builtins.str):
        """
        :param _builtins.str id: The ID of the Cen Transit Router Prefix List Association. It formats as `<prefix_list_id>:<transit_router_id>:<transit_router_table_id>:<next_hop>`.
        :param _builtins.str next_hop: The ID of the next hop connection.
        :param _builtins.str next_hop_instance_id: The ID of the network instance associated with the next hop connection.
        :param _builtins.str next_hop_type: The type of the next hop.
        :param _builtins.int owner_uid: The ID of the Alibaba Cloud account to which the prefix list belongs.
        :param _builtins.str prefix_list_id: The ID of the prefix list.
        :param _builtins.str status: The status of the prefix list.
        :param _builtins.str transit_router_id: The ID of the transit router.
        :param _builtins.str transit_router_table_id: The ID of the route table of the transit router.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "next_hop", next_hop)
        pulumi.set(__self__, "next_hop_instance_id", next_hop_instance_id)
        pulumi.set(__self__, "next_hop_type", next_hop_type)
        pulumi.set(__self__, "owner_uid", owner_uid)
        pulumi.set(__self__, "prefix_list_id", prefix_list_id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "transit_router_id", transit_router_id)
        pulumi.set(__self__, "transit_router_table_id", transit_router_table_id)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Cen Transit Router Prefix List Association. It formats as `<prefix_list_id>:<transit_router_id>:<transit_router_table_id>:<next_hop>`.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="nextHop")
    def next_hop(self) -> _builtins.str:
        """
        The ID of the next hop connection.
        """
        return pulumi.get(self, "next_hop")

    @_builtins.property
    @pulumi.getter(name="nextHopInstanceId")
    def next_hop_instance_id(self) -> _builtins.str:
        """
        The ID of the network instance associated with the next hop connection.
        """
        return pulumi.get(self, "next_hop_instance_id")

    @_builtins.property
    @pulumi.getter(name="nextHopType")
    def next_hop_type(self) -> _builtins.str:
        """
        The type of the next hop.
        """
        return pulumi.get(self, "next_hop_type")

    @_builtins.property
    @pulumi.getter(name="ownerUid")
    def owner_uid(self) -> _builtins.int:
        """
        The ID of the Alibaba Cloud account to which the prefix list belongs.
        """
        return pulumi.get(self, "owner_uid")

    @_builtins.property
    @pulumi.getter(name="prefixListId")
    def prefix_list_id(self) -> _builtins.str:
        """
        The ID of the prefix list.
        """
        return pulumi.get(self, "prefix_list_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the prefix list.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="transitRouterId")
    def transit_router_id(self) -> _builtins.str:
        """
        The ID of the transit router.
        """
        return pulumi.get(self, "transit_router_id")

    @_builtins.property
    @pulumi.getter(name="transitRouterTableId")
    def transit_router_table_id(self) -> _builtins.str:
        """
        The ID of the route table of the transit router.
        """
        return pulumi.get(self, "transit_router_table_id")


@pulumi.output_type
class GetTransitRouterRouteEntriesEntryResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 status: _builtins.str,
                 transit_router_route_entry_description: _builtins.str,
                 transit_router_route_entry_destination_cidr_block: _builtins.str,
                 transit_router_route_entry_id: _builtins.str,
                 transit_router_route_entry_name: _builtins.str,
                 transit_router_route_entry_next_hop_id: _builtins.str,
                 transit_router_route_entry_next_hop_type: _builtins.str,
                 transit_router_route_entry_type: _builtins.str):
        """
        :param _builtins.str transit_router_route_entry_destination_cidr_block: The target network segment of the route entry.
        :param _builtins.str transit_router_route_entry_next_hop_id: ID of the next hop.
        :param _builtins.str transit_router_route_entry_next_hop_type: Type of the next hop.
        :param _builtins.str transit_router_route_entry_type: Type of the route entry.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "transit_router_route_entry_description", transit_router_route_entry_description)
        pulumi.set(__self__, "transit_router_route_entry_destination_cidr_block", transit_router_route_entry_destination_cidr_block)
        pulumi.set(__self__, "transit_router_route_entry_id", transit_router_route_entry_id)
        pulumi.set(__self__, "transit_router_route_entry_name", transit_router_route_entry_name)
        pulumi.set(__self__, "transit_router_route_entry_next_hop_id", transit_router_route_entry_next_hop_id)
        pulumi.set(__self__, "transit_router_route_entry_next_hop_type", transit_router_route_entry_next_hop_type)
        pulumi.set(__self__, "transit_router_route_entry_type", transit_router_route_entry_type)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="transitRouterRouteEntryDescription")
    def transit_router_route_entry_description(self) -> _builtins.str:
        return pulumi.get(self, "transit_router_route_entry_description")

    @_builtins.property
    @pulumi.getter(name="transitRouterRouteEntryDestinationCidrBlock")
    def transit_router_route_entry_destination_cidr_block(self) -> _builtins.str:
        """
        The target network segment of the route entry.
        """
        return pulumi.get(self, "transit_router_route_entry_destination_cidr_block")

    @_builtins.property
    @pulumi.getter(name="transitRouterRouteEntryId")
    def transit_router_route_entry_id(self) -> _builtins.str:
        return pulumi.get(self, "transit_router_route_entry_id")

    @_builtins.property
    @pulumi.getter(name="transitRouterRouteEntryName")
    def transit_router_route_entry_name(self) -> _builtins.str:
        return pulumi.get(self, "transit_router_route_entry_name")

    @_builtins.property
    @pulumi.getter(name="transitRouterRouteEntryNextHopId")
    def transit_router_route_entry_next_hop_id(self) -> _builtins.str:
        """
        ID of the next hop.
        """
        return pulumi.get(self, "transit_router_route_entry_next_hop_id")

    @_builtins.property
    @pulumi.getter(name="transitRouterRouteEntryNextHopType")
    def transit_router_route_entry_next_hop_type(self) -> _builtins.str:
        """
        Type of the next hop.
        """
        return pulumi.get(self, "transit_router_route_entry_next_hop_type")

    @_builtins.property
    @pulumi.getter(name="transitRouterRouteEntryType")
    def transit_router_route_entry_type(self) -> _builtins.str:
        """
        Type of the route entry.
        """
        return pulumi.get(self, "transit_router_route_entry_type")


@pulumi.output_type
class GetTransitRouterRouteTableAssociationsAssociationResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 resource_id: _builtins.str,
                 resource_type: _builtins.str,
                 status: _builtins.str,
                 transit_router_attachment_id: _builtins.str,
                 transit_router_route_table_id: _builtins.str):
        """
        :param _builtins.str resource_id: ID of the transit router route table association.
        :param _builtins.str resource_type: Type of the resource.
        :param _builtins.str status: The status of the route table, including `Active`, `Associating`, `Dissociating`.
        :param _builtins.str transit_router_attachment_id: The ID of the network instance connection.
        :param _builtins.str transit_router_route_table_id: The ID of the route table of the Enterprise Edition transit router.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "resource_id", resource_id)
        pulumi.set(__self__, "resource_type", resource_type)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "transit_router_attachment_id", transit_router_attachment_id)
        pulumi.set(__self__, "transit_router_route_table_id", transit_router_route_table_id)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> _builtins.str:
        """
        ID of the transit router route table association.
        """
        return pulumi.get(self, "resource_id")

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> _builtins.str:
        """
        Type of the resource.
        """
        return pulumi.get(self, "resource_type")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the route table, including `Active`, `Associating`, `Dissociating`.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="transitRouterAttachmentId")
    def transit_router_attachment_id(self) -> _builtins.str:
        """
        The ID of the network instance connection.
        """
        return pulumi.get(self, "transit_router_attachment_id")

    @_builtins.property
    @pulumi.getter(name="transitRouterRouteTableId")
    def transit_router_route_table_id(self) -> _builtins.str:
        """
        The ID of the route table of the Enterprise Edition transit router.
        """
        return pulumi.get(self, "transit_router_route_table_id")


@pulumi.output_type
class GetTransitRouterRouteTablePropagationsPropagationResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 resource_id: _builtins.str,
                 resource_type: _builtins.str,
                 status: _builtins.str,
                 transit_router_attachment_id: _builtins.str,
                 transit_router_route_table_id: _builtins.str):
        """
        :param _builtins.str id: The ID of the network instance connection.
        :param _builtins.str resource_id: The ID of the network instance.
        :param _builtins.str resource_type: The type of the network instance.
        :param _builtins.str status: The status of the route learning correlation. Valid values: `Active`, `Enabling`, `Disabling`.
        :param _builtins.str transit_router_attachment_id: The ID of the network instance connection.
        :param _builtins.str transit_router_route_table_id: The ID of the route table of the Enterprise Edition transit router.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "resource_id", resource_id)
        pulumi.set(__self__, "resource_type", resource_type)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "transit_router_attachment_id", transit_router_attachment_id)
        pulumi.set(__self__, "transit_router_route_table_id", transit_router_route_table_id)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the network instance connection.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> _builtins.str:
        """
        The ID of the network instance.
        """
        return pulumi.get(self, "resource_id")

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> _builtins.str:
        """
        The type of the network instance.
        """
        return pulumi.get(self, "resource_type")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the route learning correlation. Valid values: `Active`, `Enabling`, `Disabling`.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="transitRouterAttachmentId")
    def transit_router_attachment_id(self) -> _builtins.str:
        """
        The ID of the network instance connection.
        """
        return pulumi.get(self, "transit_router_attachment_id")

    @_builtins.property
    @pulumi.getter(name="transitRouterRouteTableId")
    def transit_router_route_table_id(self) -> _builtins.str:
        """
        The ID of the route table of the Enterprise Edition transit router.
        """
        return pulumi.get(self, "transit_router_route_table_id")


@pulumi.output_type
class GetTransitRouterRouteTablesTableResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 status: _builtins.str,
                 transit_router_route_table_description: _builtins.str,
                 transit_router_route_table_id: _builtins.str,
                 transit_router_route_table_name: _builtins.str,
                 transit_router_route_table_type: _builtins.str):
        """
        :param _builtins.str id: The ID of the Transit Router Route Table.
        :param _builtins.str status: The status of the route table. Valid values: `Creating`, `Active`, `Deleting`.
        :param _builtins.str transit_router_route_table_description: The description of the route table.
        :param _builtins.str transit_router_route_table_id: The ID of the Transit Router Route Table.
        :param _builtins.str transit_router_route_table_name: The name of the route table.
        :param _builtins.str transit_router_route_table_type: The type of the route table. Valid values: `System`, `Custom`.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "transit_router_route_table_description", transit_router_route_table_description)
        pulumi.set(__self__, "transit_router_route_table_id", transit_router_route_table_id)
        pulumi.set(__self__, "transit_router_route_table_name", transit_router_route_table_name)
        pulumi.set(__self__, "transit_router_route_table_type", transit_router_route_table_type)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Transit Router Route Table.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the route table. Valid values: `Creating`, `Active`, `Deleting`.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="transitRouterRouteTableDescription")
    def transit_router_route_table_description(self) -> _builtins.str:
        """
        The description of the route table.
        """
        return pulumi.get(self, "transit_router_route_table_description")

    @_builtins.property
    @pulumi.getter(name="transitRouterRouteTableId")
    def transit_router_route_table_id(self) -> _builtins.str:
        """
        The ID of the Transit Router Route Table.
        """
        return pulumi.get(self, "transit_router_route_table_id")

    @_builtins.property
    @pulumi.getter(name="transitRouterRouteTableName")
    def transit_router_route_table_name(self) -> _builtins.str:
        """
        The name of the route table.
        """
        return pulumi.get(self, "transit_router_route_table_name")

    @_builtins.property
    @pulumi.getter(name="transitRouterRouteTableType")
    def transit_router_route_table_type(self) -> _builtins.str:
        """
        The type of the route table. Valid values: `System`, `Custom`.
        """
        return pulumi.get(self, "transit_router_route_table_type")


@pulumi.output_type
class GetTransitRouterVbrAttachmentsAttachmentResult(dict):
    def __init__(__self__, *,
                 auto_publish_route_enabled: _builtins.bool,
                 id: _builtins.str,
                 resource_type: _builtins.str,
                 status: _builtins.str,
                 transit_router_attachment_description: _builtins.str,
                 transit_router_attachment_id: _builtins.str,
                 transit_router_attachment_name: _builtins.str,
                 vbr_id: _builtins.str,
                 vbr_owner_id: _builtins.str):
        """
        :param _builtins.bool auto_publish_route_enabled: ID of the region where the conflicted VBR is located.
        :param _builtins.str resource_type: Type of the resource.
        :param _builtins.str status: The status of the resource. Valid values `Attached`, `Attaching` and `Detaching`.
        :param _builtins.str transit_router_attachment_id: ID of the transit router VBR attachment.
        :param _builtins.str transit_router_attachment_name: Name of the transit router attachment.
        :param _builtins.str vbr_id: ID of the VBR.
        :param _builtins.str vbr_owner_id: The Owner ID of the VBR.
        """
        pulumi.set(__self__, "auto_publish_route_enabled", auto_publish_route_enabled)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "resource_type", resource_type)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "transit_router_attachment_description", transit_router_attachment_description)
        pulumi.set(__self__, "transit_router_attachment_id", transit_router_attachment_id)
        pulumi.set(__self__, "transit_router_attachment_name", transit_router_attachment_name)
        pulumi.set(__self__, "vbr_id", vbr_id)
        pulumi.set(__self__, "vbr_owner_id", vbr_owner_id)

    @_builtins.property
    @pulumi.getter(name="autoPublishRouteEnabled")
    def auto_publish_route_enabled(self) -> _builtins.bool:
        """
        ID of the region where the conflicted VBR is located.
        """
        return pulumi.get(self, "auto_publish_route_enabled")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> _builtins.str:
        """
        Type of the resource.
        """
        return pulumi.get(self, "resource_type")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the resource. Valid values `Attached`, `Attaching` and `Detaching`.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="transitRouterAttachmentDescription")
    def transit_router_attachment_description(self) -> _builtins.str:
        return pulumi.get(self, "transit_router_attachment_description")

    @_builtins.property
    @pulumi.getter(name="transitRouterAttachmentId")
    def transit_router_attachment_id(self) -> _builtins.str:
        """
        ID of the transit router VBR attachment.
        """
        return pulumi.get(self, "transit_router_attachment_id")

    @_builtins.property
    @pulumi.getter(name="transitRouterAttachmentName")
    def transit_router_attachment_name(self) -> _builtins.str:
        """
        Name of the transit router attachment.
        """
        return pulumi.get(self, "transit_router_attachment_name")

    @_builtins.property
    @pulumi.getter(name="vbrId")
    def vbr_id(self) -> _builtins.str:
        """
        ID of the VBR.
        """
        return pulumi.get(self, "vbr_id")

    @_builtins.property
    @pulumi.getter(name="vbrOwnerId")
    def vbr_owner_id(self) -> _builtins.str:
        """
        The Owner ID of the VBR.
        """
        return pulumi.get(self, "vbr_owner_id")


@pulumi.output_type
class GetTransitRouterVpcAttachmentsAttachmentResult(dict):
    def __init__(__self__, *,
                 auto_publish_route_enabled: _builtins.bool,
                 cen_id: _builtins.str,
                 id: _builtins.str,
                 payment_type: _builtins.str,
                 resource_type: _builtins.str,
                 status: _builtins.str,
                 transit_router_attachment_description: _builtins.str,
                 transit_router_attachment_id: _builtins.str,
                 transit_router_attachment_name: _builtins.str,
                 transit_router_id: _builtins.str,
                 vpc_id: _builtins.str,
                 vpc_owner_id: _builtins.str,
                 zone_mappings: Sequence['outputs.GetTransitRouterVpcAttachmentsAttachmentZoneMappingResult']):
        """
        :param _builtins.bool auto_publish_route_enabled: (Available since v1.224.0) Whether the transit router is automatically published to the VPC instance.
        :param _builtins.str cen_id: The ID of the CEN instance.
        :param _builtins.str payment_type: The payment type of the resource.
        :param _builtins.str resource_type: The resource type of the Transit Router VPC Attachment.
        :param _builtins.str status: The status of the Transit Router VPC Attachment. Valid Values: `Attached`, `Attaching`, `Detaching`.
        :param _builtins.str transit_router_attachment_description: The description of the Transit Router VPC Attachment.
        :param _builtins.str transit_router_attachment_id: The ID of the Transit Router VPC Attachment.
        :param _builtins.str transit_router_attachment_name: The name of the Transit Router VPC Attachment.
        :param _builtins.str transit_router_id: The ID of the transit router.
        :param _builtins.str vpc_id: The ID of the VPC.
        :param _builtins.str vpc_owner_id: The Owner ID of the VPC.
        :param Sequence['GetTransitRouterVpcAttachmentsAttachmentZoneMappingArgs'] zone_mappings: The list of zone mapping of the VPC.
        """
        pulumi.set(__self__, "auto_publish_route_enabled", auto_publish_route_enabled)
        pulumi.set(__self__, "cen_id", cen_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "payment_type", payment_type)
        pulumi.set(__self__, "resource_type", resource_type)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "transit_router_attachment_description", transit_router_attachment_description)
        pulumi.set(__self__, "transit_router_attachment_id", transit_router_attachment_id)
        pulumi.set(__self__, "transit_router_attachment_name", transit_router_attachment_name)
        pulumi.set(__self__, "transit_router_id", transit_router_id)
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "vpc_owner_id", vpc_owner_id)
        pulumi.set(__self__, "zone_mappings", zone_mappings)

    @_builtins.property
    @pulumi.getter(name="autoPublishRouteEnabled")
    def auto_publish_route_enabled(self) -> _builtins.bool:
        """
        (Available since v1.224.0) Whether the transit router is automatically published to the VPC instance.
        """
        return pulumi.get(self, "auto_publish_route_enabled")

    @_builtins.property
    @pulumi.getter(name="cenId")
    def cen_id(self) -> _builtins.str:
        """
        The ID of the CEN instance.
        """
        return pulumi.get(self, "cen_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> _builtins.str:
        """
        The payment type of the resource.
        """
        return pulumi.get(self, "payment_type")

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> _builtins.str:
        """
        The resource type of the Transit Router VPC Attachment.
        """
        return pulumi.get(self, "resource_type")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the Transit Router VPC Attachment. Valid Values: `Attached`, `Attaching`, `Detaching`.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="transitRouterAttachmentDescription")
    def transit_router_attachment_description(self) -> _builtins.str:
        """
        The description of the Transit Router VPC Attachment.
        """
        return pulumi.get(self, "transit_router_attachment_description")

    @_builtins.property
    @pulumi.getter(name="transitRouterAttachmentId")
    def transit_router_attachment_id(self) -> _builtins.str:
        """
        The ID of the Transit Router VPC Attachment.
        """
        return pulumi.get(self, "transit_router_attachment_id")

    @_builtins.property
    @pulumi.getter(name="transitRouterAttachmentName")
    def transit_router_attachment_name(self) -> _builtins.str:
        """
        The name of the Transit Router VPC Attachment.
        """
        return pulumi.get(self, "transit_router_attachment_name")

    @_builtins.property
    @pulumi.getter(name="transitRouterId")
    def transit_router_id(self) -> _builtins.str:
        """
        The ID of the transit router.
        """
        return pulumi.get(self, "transit_router_id")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> _builtins.str:
        """
        The ID of the VPC.
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="vpcOwnerId")
    def vpc_owner_id(self) -> _builtins.str:
        """
        The Owner ID of the VPC.
        """
        return pulumi.get(self, "vpc_owner_id")

    @_builtins.property
    @pulumi.getter(name="zoneMappings")
    def zone_mappings(self) -> Sequence['outputs.GetTransitRouterVpcAttachmentsAttachmentZoneMappingResult']:
        """
        The list of zone mapping of the VPC.
        """
        return pulumi.get(self, "zone_mappings")


@pulumi.output_type
class GetTransitRouterVpcAttachmentsAttachmentZoneMappingResult(dict):
    def __init__(__self__, *,
                 vswitch_id: _builtins.str,
                 zone_id: _builtins.str):
        """
        :param _builtins.str vswitch_id: The ID of the vSwitch.
        :param _builtins.str zone_id: The ID of the zone.
        """
        pulumi.set(__self__, "vswitch_id", vswitch_id)
        pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> _builtins.str:
        """
        The ID of the vSwitch.
        """
        return pulumi.get(self, "vswitch_id")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> _builtins.str:
        """
        The ID of the zone.
        """
        return pulumi.get(self, "zone_id")


@pulumi.output_type
class GetTransitRouterVpnAttachmentsAttachmentResult(dict):
    def __init__(__self__, *,
                 auto_publish_route_enabled: _builtins.bool,
                 cen_id: _builtins.str,
                 charge_type: _builtins.str,
                 create_time: _builtins.str,
                 id: _builtins.str,
                 resource_type: _builtins.str,
                 status: _builtins.str,
                 tags: Mapping[str, _builtins.str],
                 transit_router_attachment_description: _builtins.str,
                 transit_router_attachment_id: _builtins.str,
                 transit_router_attachment_name: _builtins.str,
                 transit_router_id: _builtins.str,
                 vpn_id: _builtins.str,
                 vpn_owner_id: _builtins.int,
                 zones: Sequence['outputs.GetTransitRouterVpnAttachmentsAttachmentZoneResult']):
        """
        :param _builtins.bool auto_publish_route_enabled: Specifies whether to allow the transit router to automatically advertise routes to the IPsec-VPN attachment.
        :param _builtins.str cen_id: The ID of the Cloud Enterprise Network (CEN) instance.
        :param _builtins.str charge_type: (Available since v1.245.0) The billing method of the VPN attachment.
        :param _builtins.str create_time: The time when the VPN connection was created.
        :param _builtins.str id: The ID of the resource supplied above.
        :param _builtins.str resource_type: The type of resource attached to the transit router.
        :param _builtins.str status: The Status of Transit Router Vpn Attachment. Valid values: `Attached`, `Attaching`, `Detaching`.
        :param Mapping[str, _builtins.str] tags: The tag of the resource.
        :param _builtins.str transit_router_attachment_description: The description of the IPsec-VPN connection.
        :param _builtins.str transit_router_attachment_id: The ID of the VPN attachment.
        :param _builtins.str transit_router_attachment_name: The name of the VPN attachment.
        :param _builtins.str transit_router_id: The ID of the transit router.
        :param _builtins.str vpn_id: The ID of the IPsec-VPN attachment.
        :param _builtins.int vpn_owner_id: The ID of the Alibaba Cloud account to which the IPsec-VPN connection belongs.
        :param Sequence['GetTransitRouterVpnAttachmentsAttachmentZoneArgs'] zones: The Zone ID in the current region.System will create resources under the Zone that you specify.Left blank if associated IPSec connection is in dual-tunnel mode.
        """
        pulumi.set(__self__, "auto_publish_route_enabled", auto_publish_route_enabled)
        pulumi.set(__self__, "cen_id", cen_id)
        pulumi.set(__self__, "charge_type", charge_type)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "resource_type", resource_type)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "transit_router_attachment_description", transit_router_attachment_description)
        pulumi.set(__self__, "transit_router_attachment_id", transit_router_attachment_id)
        pulumi.set(__self__, "transit_router_attachment_name", transit_router_attachment_name)
        pulumi.set(__self__, "transit_router_id", transit_router_id)
        pulumi.set(__self__, "vpn_id", vpn_id)
        pulumi.set(__self__, "vpn_owner_id", vpn_owner_id)
        pulumi.set(__self__, "zones", zones)

    @_builtins.property
    @pulumi.getter(name="autoPublishRouteEnabled")
    def auto_publish_route_enabled(self) -> _builtins.bool:
        """
        Specifies whether to allow the transit router to automatically advertise routes to the IPsec-VPN attachment.
        """
        return pulumi.get(self, "auto_publish_route_enabled")

    @_builtins.property
    @pulumi.getter(name="cenId")
    def cen_id(self) -> _builtins.str:
        """
        The ID of the Cloud Enterprise Network (CEN) instance.
        """
        return pulumi.get(self, "cen_id")

    @_builtins.property
    @pulumi.getter(name="chargeType")
    def charge_type(self) -> _builtins.str:
        """
        (Available since v1.245.0) The billing method of the VPN attachment.
        """
        return pulumi.get(self, "charge_type")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        The time when the VPN connection was created.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the resource supplied above.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> _builtins.str:
        """
        The type of resource attached to the transit router.
        """
        return pulumi.get(self, "resource_type")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The Status of Transit Router Vpn Attachment. Valid values: `Attached`, `Attaching`, `Detaching`.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        The tag of the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="transitRouterAttachmentDescription")
    def transit_router_attachment_description(self) -> _builtins.str:
        """
        The description of the IPsec-VPN connection.
        """
        return pulumi.get(self, "transit_router_attachment_description")

    @_builtins.property
    @pulumi.getter(name="transitRouterAttachmentId")
    def transit_router_attachment_id(self) -> _builtins.str:
        """
        The ID of the VPN attachment.
        """
        return pulumi.get(self, "transit_router_attachment_id")

    @_builtins.property
    @pulumi.getter(name="transitRouterAttachmentName")
    def transit_router_attachment_name(self) -> _builtins.str:
        """
        The name of the VPN attachment.
        """
        return pulumi.get(self, "transit_router_attachment_name")

    @_builtins.property
    @pulumi.getter(name="transitRouterId")
    def transit_router_id(self) -> _builtins.str:
        """
        The ID of the transit router.
        """
        return pulumi.get(self, "transit_router_id")

    @_builtins.property
    @pulumi.getter(name="vpnId")
    def vpn_id(self) -> _builtins.str:
        """
        The ID of the IPsec-VPN attachment.
        """
        return pulumi.get(self, "vpn_id")

    @_builtins.property
    @pulumi.getter(name="vpnOwnerId")
    def vpn_owner_id(self) -> _builtins.int:
        """
        The ID of the Alibaba Cloud account to which the IPsec-VPN connection belongs.
        """
        return pulumi.get(self, "vpn_owner_id")

    @_builtins.property
    @pulumi.getter
    def zones(self) -> Sequence['outputs.GetTransitRouterVpnAttachmentsAttachmentZoneResult']:
        """
        The Zone ID in the current region.System will create resources under the Zone that you specify.Left blank if associated IPSec connection is in dual-tunnel mode.
        """
        return pulumi.get(self, "zones")


@pulumi.output_type
class GetTransitRouterVpnAttachmentsAttachmentZoneResult(dict):
    def __init__(__self__, *,
                 zone_id: _builtins.str):
        """
        :param _builtins.str zone_id: The zone ID of the read-only instance.
        """
        pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> _builtins.str:
        """
        The zone ID of the read-only instance.
        """
        return pulumi.get(self, "zone_id")


@pulumi.output_type
class GetTransitRoutersTransitRouterResult(dict):
    def __init__(__self__, *,
                 ali_uid: _builtins.str,
                 cen_id: _builtins.str,
                 id: _builtins.str,
                 status: _builtins.str,
                 transit_router_description: _builtins.str,
                 transit_router_id: _builtins.str,
                 transit_router_name: _builtins.str,
                 type: _builtins.str,
                 xgw_vip: _builtins.str):
        """
        :param _builtins.str ali_uid: The UID of the Aliyun.
        :param _builtins.str cen_id: The ID of the CEN instance.
        :param _builtins.str id: The ID of the resource, It is formatted to `<cen_id>:<transit_router_id>`. **NOTE:** Before 1.151.0, It is formatted to `<transit_router_id>`.
        :param _builtins.str status: The status of the resource. Valid values `Active`, `Creating`, `Deleting` and `Updating`.
        :param _builtins.str transit_router_description: The description of the transit router.
        :param _builtins.str transit_router_id: The ID of the transit router.
        :param _builtins.str transit_router_name: The name of the transit router.
        :param _builtins.str type: The Type of the transit router.
        :param _builtins.str xgw_vip: The vip of the XGW.
        """
        pulumi.set(__self__, "ali_uid", ali_uid)
        pulumi.set(__self__, "cen_id", cen_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "transit_router_description", transit_router_description)
        pulumi.set(__self__, "transit_router_id", transit_router_id)
        pulumi.set(__self__, "transit_router_name", transit_router_name)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "xgw_vip", xgw_vip)

    @_builtins.property
    @pulumi.getter(name="aliUid")
    def ali_uid(self) -> _builtins.str:
        """
        The UID of the Aliyun.
        """
        return pulumi.get(self, "ali_uid")

    @_builtins.property
    @pulumi.getter(name="cenId")
    def cen_id(self) -> _builtins.str:
        """
        The ID of the CEN instance.
        """
        return pulumi.get(self, "cen_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the resource, It is formatted to `<cen_id>:<transit_router_id>`. **NOTE:** Before 1.151.0, It is formatted to `<transit_router_id>`.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the resource. Valid values `Active`, `Creating`, `Deleting` and `Updating`.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="transitRouterDescription")
    def transit_router_description(self) -> _builtins.str:
        """
        The description of the transit router.
        """
        return pulumi.get(self, "transit_router_description")

    @_builtins.property
    @pulumi.getter(name="transitRouterId")
    def transit_router_id(self) -> _builtins.str:
        """
        The ID of the transit router.
        """
        return pulumi.get(self, "transit_router_id")

    @_builtins.property
    @pulumi.getter(name="transitRouterName")
    def transit_router_name(self) -> _builtins.str:
        """
        The name of the transit router.
        """
        return pulumi.get(self, "transit_router_name")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The Type of the transit router.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="xgwVip")
    def xgw_vip(self) -> _builtins.str:
        """
        The vip of the XGW.
        """
        return pulumi.get(self, "xgw_vip")


@pulumi.output_type
class GetVbrHealthChecksCheckResult(dict):
    def __init__(__self__, *,
                 cen_id: _builtins.str,
                 health_check_interval: _builtins.int,
                 health_check_source_ip: _builtins.str,
                 health_check_target_ip: _builtins.str,
                 healthy_threshold: _builtins.int,
                 id: _builtins.str,
                 vbr_instance_id: _builtins.str,
                 vbr_instance_region_id: _builtins.str):
        """
        :param _builtins.str cen_id: The ID of the Cloud Enterprise Network (CEN) instance.
        :param _builtins.int health_check_interval: The time interval at which probe packets are sent during the health check.
        :param _builtins.str health_check_source_ip: The source IP address of the health check.
        :param _builtins.str health_check_target_ip: The destination IP address of the health check.
        :param _builtins.int healthy_threshold: The number of probe packets that are sent during the health check.
        :param _builtins.str id: The ID of the CEN VBR Heath Check.
        :param _builtins.str vbr_instance_id: The ID of the VBR instance.
        :param _builtins.str vbr_instance_region_id: The ID of the region where the VBR instance is deployed.
        """
        pulumi.set(__self__, "cen_id", cen_id)
        pulumi.set(__self__, "health_check_interval", health_check_interval)
        pulumi.set(__self__, "health_check_source_ip", health_check_source_ip)
        pulumi.set(__self__, "health_check_target_ip", health_check_target_ip)
        pulumi.set(__self__, "healthy_threshold", healthy_threshold)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "vbr_instance_id", vbr_instance_id)
        pulumi.set(__self__, "vbr_instance_region_id", vbr_instance_region_id)

    @_builtins.property
    @pulumi.getter(name="cenId")
    def cen_id(self) -> _builtins.str:
        """
        The ID of the Cloud Enterprise Network (CEN) instance.
        """
        return pulumi.get(self, "cen_id")

    @_builtins.property
    @pulumi.getter(name="healthCheckInterval")
    def health_check_interval(self) -> _builtins.int:
        """
        The time interval at which probe packets are sent during the health check.
        """
        return pulumi.get(self, "health_check_interval")

    @_builtins.property
    @pulumi.getter(name="healthCheckSourceIp")
    def health_check_source_ip(self) -> _builtins.str:
        """
        The source IP address of the health check.
        """
        return pulumi.get(self, "health_check_source_ip")

    @_builtins.property
    @pulumi.getter(name="healthCheckTargetIp")
    def health_check_target_ip(self) -> _builtins.str:
        """
        The destination IP address of the health check.
        """
        return pulumi.get(self, "health_check_target_ip")

    @_builtins.property
    @pulumi.getter(name="healthyThreshold")
    def healthy_threshold(self) -> _builtins.int:
        """
        The number of probe packets that are sent during the health check.
        """
        return pulumi.get(self, "healthy_threshold")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the CEN VBR Heath Check.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="vbrInstanceId")
    def vbr_instance_id(self) -> _builtins.str:
        """
        The ID of the VBR instance.
        """
        return pulumi.get(self, "vbr_instance_id")

    @_builtins.property
    @pulumi.getter(name="vbrInstanceRegionId")
    def vbr_instance_region_id(self) -> _builtins.str:
        """
        The ID of the region where the VBR instance is deployed.
        """
        return pulumi.get(self, "vbr_instance_region_id")


