# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['TransitRouterVpnAttachmentArgs', 'TransitRouterVpnAttachment']

@pulumi.input_type
class TransitRouterVpnAttachmentArgs:
    def __init__(__self__, *,
                 vpn_id: pulumi.Input[_builtins.str],
                 auto_publish_route_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 cen_id: Optional[pulumi.Input[_builtins.str]] = None,
                 charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 transit_router_attachment_description: Optional[pulumi.Input[_builtins.str]] = None,
                 transit_router_attachment_name: Optional[pulumi.Input[_builtins.str]] = None,
                 transit_router_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vpn_owner_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zones: Optional[pulumi.Input[Sequence[pulumi.Input['TransitRouterVpnAttachmentZoneArgs']]]] = None):
        """
        The set of arguments for constructing a TransitRouterVpnAttachment resource.
        :param pulumi.Input[_builtins.str] vpn_id: The ID of the IPsec-VPN attachment.
        :param pulumi.Input[_builtins.bool] auto_publish_route_enabled: Specifies whether to allow the transit router to automatically advertise routes to the IPsec-VPN attachment. Valid values:
        :param pulumi.Input[_builtins.str] cen_id: The ID of the Cloud Enterprise Network (CEN) instance.
        :param pulumi.Input[_builtins.str] charge_type: The billing method.
               Set the value to `POSTPAY`, which is the default value and specifies the pay-as-you-go billing method.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource
        :param pulumi.Input[_builtins.str] transit_router_attachment_description: The new description of the VPN attachment.
               The description must be 2 to 256 characters in length. The description must start with a letter but cannot start with `http://` or `https://`.
        :param pulumi.Input[_builtins.str] transit_router_attachment_name: The name of the VPN attachment.
               The name must be 2 to 128 characters in length, and can contain letters, digits, underscores (\\_), and hyphens (-). It must start with a letter.
        :param pulumi.Input[_builtins.str] transit_router_id: The ID of the transit router.
        :param pulumi.Input[_builtins.str] vpn_owner_id: The ID of the Alibaba Cloud account to which the IPsec-VPN connection belongs.
               
               - If you do not set this parameter, the ID of the current Alibaba Cloud account is used.
               - You must set VpnOwnerId if you want to connect the transit router to an IPsec-VPN connection that belongs to another Alibaba Cloud account.
        :param pulumi.Input[Sequence[pulumi.Input['TransitRouterVpnAttachmentZoneArgs']]] zones: The Zone ID in the current region.
               System will create resources under the Zone that you specify.
               Left blank if associated IPSec connection is in dual-tunnel mode. See `zone` below.
        """
        pulumi.set(__self__, "vpn_id", vpn_id)
        if auto_publish_route_enabled is not None:
            pulumi.set(__self__, "auto_publish_route_enabled", auto_publish_route_enabled)
        if cen_id is not None:
            pulumi.set(__self__, "cen_id", cen_id)
        if charge_type is not None:
            pulumi.set(__self__, "charge_type", charge_type)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if transit_router_attachment_description is not None:
            pulumi.set(__self__, "transit_router_attachment_description", transit_router_attachment_description)
        if transit_router_attachment_name is not None:
            pulumi.set(__self__, "transit_router_attachment_name", transit_router_attachment_name)
        if transit_router_id is not None:
            pulumi.set(__self__, "transit_router_id", transit_router_id)
        if vpn_owner_id is not None:
            pulumi.set(__self__, "vpn_owner_id", vpn_owner_id)
        if zones is not None:
            pulumi.set(__self__, "zones", zones)

    @_builtins.property
    @pulumi.getter(name="vpnId")
    def vpn_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the IPsec-VPN attachment.
        """
        return pulumi.get(self, "vpn_id")

    @vpn_id.setter
    def vpn_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vpn_id", value)

    @_builtins.property
    @pulumi.getter(name="autoPublishRouteEnabled")
    def auto_publish_route_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to allow the transit router to automatically advertise routes to the IPsec-VPN attachment. Valid values:
        """
        return pulumi.get(self, "auto_publish_route_enabled")

    @auto_publish_route_enabled.setter
    def auto_publish_route_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_publish_route_enabled", value)

    @_builtins.property
    @pulumi.getter(name="cenId")
    def cen_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Cloud Enterprise Network (CEN) instance.
        """
        return pulumi.get(self, "cen_id")

    @cen_id.setter
    def cen_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cen_id", value)

    @_builtins.property
    @pulumi.getter(name="chargeType")
    def charge_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The billing method.
        Set the value to `POSTPAY`, which is the default value and specifies the pay-as-you-go billing method.
        """
        return pulumi.get(self, "charge_type")

    @charge_type.setter
    def charge_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "charge_type", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The tag of the resource
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="transitRouterAttachmentDescription")
    def transit_router_attachment_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The new description of the VPN attachment.
        The description must be 2 to 256 characters in length. The description must start with a letter but cannot start with `http://` or `https://`.
        """
        return pulumi.get(self, "transit_router_attachment_description")

    @transit_router_attachment_description.setter
    def transit_router_attachment_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "transit_router_attachment_description", value)

    @_builtins.property
    @pulumi.getter(name="transitRouterAttachmentName")
    def transit_router_attachment_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the VPN attachment.
        The name must be 2 to 128 characters in length, and can contain letters, digits, underscores (\\_), and hyphens (-). It must start with a letter.
        """
        return pulumi.get(self, "transit_router_attachment_name")

    @transit_router_attachment_name.setter
    def transit_router_attachment_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "transit_router_attachment_name", value)

    @_builtins.property
    @pulumi.getter(name="transitRouterId")
    def transit_router_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the transit router.
        """
        return pulumi.get(self, "transit_router_id")

    @transit_router_id.setter
    def transit_router_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "transit_router_id", value)

    @_builtins.property
    @pulumi.getter(name="vpnOwnerId")
    def vpn_owner_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Alibaba Cloud account to which the IPsec-VPN connection belongs.

        - If you do not set this parameter, the ID of the current Alibaba Cloud account is used.
        - You must set VpnOwnerId if you want to connect the transit router to an IPsec-VPN connection that belongs to another Alibaba Cloud account.
        """
        return pulumi.get(self, "vpn_owner_id")

    @vpn_owner_id.setter
    def vpn_owner_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpn_owner_id", value)

    @_builtins.property
    @pulumi.getter
    def zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TransitRouterVpnAttachmentZoneArgs']]]]:
        """
        The Zone ID in the current region.
        System will create resources under the Zone that you specify.
        Left blank if associated IPSec connection is in dual-tunnel mode. See `zone` below.
        """
        return pulumi.get(self, "zones")

    @zones.setter
    def zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TransitRouterVpnAttachmentZoneArgs']]]]):
        pulumi.set(self, "zones", value)


@pulumi.input_type
class _TransitRouterVpnAttachmentState:
    def __init__(__self__, *,
                 auto_publish_route_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 cen_id: Optional[pulumi.Input[_builtins.str]] = None,
                 charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 transit_router_attachment_description: Optional[pulumi.Input[_builtins.str]] = None,
                 transit_router_attachment_name: Optional[pulumi.Input[_builtins.str]] = None,
                 transit_router_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vpn_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vpn_owner_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zones: Optional[pulumi.Input[Sequence[pulumi.Input['TransitRouterVpnAttachmentZoneArgs']]]] = None):
        """
        Input properties used for looking up and filtering TransitRouterVpnAttachment resources.
        :param pulumi.Input[_builtins.bool] auto_publish_route_enabled: Specifies whether to allow the transit router to automatically advertise routes to the IPsec-VPN attachment. Valid values:
        :param pulumi.Input[_builtins.str] cen_id: The ID of the Cloud Enterprise Network (CEN) instance.
        :param pulumi.Input[_builtins.str] charge_type: The billing method.
               Set the value to `POSTPAY`, which is the default value and specifies the pay-as-you-go billing method.
        :param pulumi.Input[_builtins.str] create_time: The creation time of the resource
        :param pulumi.Input[_builtins.str] region_id: The ID of the region where the transit router is deployed.
        :param pulumi.Input[_builtins.str] status: Status
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource
        :param pulumi.Input[_builtins.str] transit_router_attachment_description: The new description of the VPN attachment.
               The description must be 2 to 256 characters in length. The description must start with a letter but cannot start with `http://` or `https://`.
        :param pulumi.Input[_builtins.str] transit_router_attachment_name: The name of the VPN attachment.
               The name must be 2 to 128 characters in length, and can contain letters, digits, underscores (\\_), and hyphens (-). It must start with a letter.
        :param pulumi.Input[_builtins.str] transit_router_id: The ID of the transit router.
        :param pulumi.Input[_builtins.str] vpn_id: The ID of the IPsec-VPN attachment.
        :param pulumi.Input[_builtins.str] vpn_owner_id: The ID of the Alibaba Cloud account to which the IPsec-VPN connection belongs.
               
               - If you do not set this parameter, the ID of the current Alibaba Cloud account is used.
               - You must set VpnOwnerId if you want to connect the transit router to an IPsec-VPN connection that belongs to another Alibaba Cloud account.
        :param pulumi.Input[Sequence[pulumi.Input['TransitRouterVpnAttachmentZoneArgs']]] zones: The Zone ID in the current region.
               System will create resources under the Zone that you specify.
               Left blank if associated IPSec connection is in dual-tunnel mode. See `zone` below.
        """
        if auto_publish_route_enabled is not None:
            pulumi.set(__self__, "auto_publish_route_enabled", auto_publish_route_enabled)
        if cen_id is not None:
            pulumi.set(__self__, "cen_id", cen_id)
        if charge_type is not None:
            pulumi.set(__self__, "charge_type", charge_type)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if region_id is not None:
            pulumi.set(__self__, "region_id", region_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if transit_router_attachment_description is not None:
            pulumi.set(__self__, "transit_router_attachment_description", transit_router_attachment_description)
        if transit_router_attachment_name is not None:
            pulumi.set(__self__, "transit_router_attachment_name", transit_router_attachment_name)
        if transit_router_id is not None:
            pulumi.set(__self__, "transit_router_id", transit_router_id)
        if vpn_id is not None:
            pulumi.set(__self__, "vpn_id", vpn_id)
        if vpn_owner_id is not None:
            pulumi.set(__self__, "vpn_owner_id", vpn_owner_id)
        if zones is not None:
            pulumi.set(__self__, "zones", zones)

    @_builtins.property
    @pulumi.getter(name="autoPublishRouteEnabled")
    def auto_publish_route_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to allow the transit router to automatically advertise routes to the IPsec-VPN attachment. Valid values:
        """
        return pulumi.get(self, "auto_publish_route_enabled")

    @auto_publish_route_enabled.setter
    def auto_publish_route_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_publish_route_enabled", value)

    @_builtins.property
    @pulumi.getter(name="cenId")
    def cen_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Cloud Enterprise Network (CEN) instance.
        """
        return pulumi.get(self, "cen_id")

    @cen_id.setter
    def cen_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cen_id", value)

    @_builtins.property
    @pulumi.getter(name="chargeType")
    def charge_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The billing method.
        Set the value to `POSTPAY`, which is the default value and specifies the pay-as-you-go billing method.
        """
        return pulumi.get(self, "charge_type")

    @charge_type.setter
    def charge_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "charge_type", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation time of the resource
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the region where the transit router is deployed.
        """
        return pulumi.get(self, "region_id")

    @region_id.setter
    def region_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Status
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The tag of the resource
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="transitRouterAttachmentDescription")
    def transit_router_attachment_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The new description of the VPN attachment.
        The description must be 2 to 256 characters in length. The description must start with a letter but cannot start with `http://` or `https://`.
        """
        return pulumi.get(self, "transit_router_attachment_description")

    @transit_router_attachment_description.setter
    def transit_router_attachment_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "transit_router_attachment_description", value)

    @_builtins.property
    @pulumi.getter(name="transitRouterAttachmentName")
    def transit_router_attachment_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the VPN attachment.
        The name must be 2 to 128 characters in length, and can contain letters, digits, underscores (\\_), and hyphens (-). It must start with a letter.
        """
        return pulumi.get(self, "transit_router_attachment_name")

    @transit_router_attachment_name.setter
    def transit_router_attachment_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "transit_router_attachment_name", value)

    @_builtins.property
    @pulumi.getter(name="transitRouterId")
    def transit_router_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the transit router.
        """
        return pulumi.get(self, "transit_router_id")

    @transit_router_id.setter
    def transit_router_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "transit_router_id", value)

    @_builtins.property
    @pulumi.getter(name="vpnId")
    def vpn_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the IPsec-VPN attachment.
        """
        return pulumi.get(self, "vpn_id")

    @vpn_id.setter
    def vpn_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpn_id", value)

    @_builtins.property
    @pulumi.getter(name="vpnOwnerId")
    def vpn_owner_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Alibaba Cloud account to which the IPsec-VPN connection belongs.

        - If you do not set this parameter, the ID of the current Alibaba Cloud account is used.
        - You must set VpnOwnerId if you want to connect the transit router to an IPsec-VPN connection that belongs to another Alibaba Cloud account.
        """
        return pulumi.get(self, "vpn_owner_id")

    @vpn_owner_id.setter
    def vpn_owner_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpn_owner_id", value)

    @_builtins.property
    @pulumi.getter
    def zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TransitRouterVpnAttachmentZoneArgs']]]]:
        """
        The Zone ID in the current region.
        System will create resources under the Zone that you specify.
        Left blank if associated IPSec connection is in dual-tunnel mode. See `zone` below.
        """
        return pulumi.get(self, "zones")

    @zones.setter
    def zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TransitRouterVpnAttachmentZoneArgs']]]]):
        pulumi.set(self, "zones", value)


@pulumi.type_token("alicloud:cen/transitRouterVpnAttachment:TransitRouterVpnAttachment")
class TransitRouterVpnAttachment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_publish_route_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 cen_id: Optional[pulumi.Input[_builtins.str]] = None,
                 charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 transit_router_attachment_description: Optional[pulumi.Input[_builtins.str]] = None,
                 transit_router_attachment_name: Optional[pulumi.Input[_builtins.str]] = None,
                 transit_router_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vpn_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vpn_owner_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zones: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TransitRouterVpnAttachmentZoneArgs', 'TransitRouterVpnAttachmentZoneArgsDict']]]]] = None,
                 __props__=None):
        """
        Provides a Cloud Enterprise Network (CEN) Transit Router Vpn Attachment resource.

        For information about Cloud Enterprise Network (CEN) Transit Router Vpn Attachment and how to use it, see [What is Transit Router Vpn Attachment](https://www.alibabacloud.com/help/en/cen/developer-reference/api-cbn-2017-09-12-createtransitroutervpnattachment).

        > **NOTE:** Available since v1.183.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf_example"
        default = alicloud.cen.get_transit_router_available_resources()
        example = alicloud.cen.Instance("example", cen_instance_name=name)
        example_transit_router = alicloud.cen.TransitRouter("example",
            cen_id=example.id,
            transit_router_description=name,
            transit_router_name=name)
        example_customer_gateway = alicloud.vpn.CustomerGateway("example",
            customer_gateway_name=name,
            ip_address="42.104.22.210",
            asn="45014",
            description=name)
        example_gateway_vpn_attachment = alicloud.vpn.GatewayVpnAttachment("example",
            customer_gateway_id=example_customer_gateway.id,
            network_type="public",
            local_subnet="0.0.0.0/0",
            remote_subnet="0.0.0.0/0",
            effect_immediately=False,
            ike_config={
                "ike_auth_alg": "md5",
                "ike_enc_alg": "des",
                "ike_version": "ikev2",
                "ike_mode": "main",
                "ike_lifetime": 86400,
                "psk": "tf-examplevpn2",
                "ike_pfs": "group1",
                "remote_id": "examplebob2",
                "local_id": "examplealice2",
            },
            ipsec_config={
                "ipsec_pfs": "group5",
                "ipsec_enc_alg": "des",
                "ipsec_auth_alg": "md5",
                "ipsec_lifetime": 86400,
            },
            bgp_config={
                "enable": True,
                "local_asn": 45014,
                "tunnel_cidr": "169.254.11.0/30",
                "local_bgp_ip": "169.254.11.1",
            },
            health_check_config={
                "enable": True,
                "sip": "192.168.1.1",
                "dip": "10.0.0.1",
                "interval": 10,
                "retry": 10,
                "policy": "revoke_route",
            },
            enable_dpd=True,
            enable_nat_traversal=True,
            vpn_attachment_name=name)
        example_transit_router_cidr = alicloud.cen.TransitRouterCidr("example",
            transit_router_id=example_transit_router.transit_router_id,
            cidr="192.168.0.0/16",
            transit_router_cidr_name=name,
            description=name,
            publish_cidr_route=True)
        example_transit_router_vpn_attachment = alicloud.cen.TransitRouterVpnAttachment("example",
            auto_publish_route_enabled=False,
            transit_router_attachment_description=name,
            transit_router_attachment_name=name,
            cen_id=example_transit_router.cen_id,
            transit_router_id=example_transit_router_cidr.transit_router_id,
            vpn_id=example_gateway_vpn_attachment.id,
            zones=[{
                "zone_id": default.resources[0].master_zones[0],
            }])
        ```

        Dual Tunnel Mode Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf_example"
        default = alicloud.get_account()
        defaultbp_r5_uk = alicloud.cen.Instance("defaultbpR5Uk", cen_instance_name="example-vpn-attachment")
        default_m8_zo6_h = alicloud.cen.TransitRouter("defaultM8Zo6H", cen_id=defaultbp_r5_uk.id)
        defaultu_uty_cv = alicloud.cen.TransitRouterCidr("defaultuUtyCv",
            cidr="192.168.10.0/24",
            transit_router_id=default_m8_zo6_h.transit_router_id)
        default_meo_c_iz = alicloud.vpn.CustomerGateway("defaultMeoCIz",
            ip_address="0.0.0.0",
            customer_gateway_name="example-vpn-attachment",
            opts = pulumi.ResourceOptions(depends_on=[defaultu_uty_cv]))
        default_get_transit_router_service = alicloud.cen.get_transit_router_service(enable="On")
        defaultvr_pzdh = alicloud.vpn.GatewayVpnAttachment("defaultvrPzdh",
            network_type="public",
            local_subnet="0.0.0.0/0",
            enable_tunnels_bgp=False,
            vpn_attachment_name=name,
            tunnel_options_specifications=[
                {
                    "customer_gateway_id": default_meo_c_iz.id,
                    "enable_dpd": True,
                    "enable_nat_traversal": True,
                    "tunnel_index": 1,
                    "tunnel_ike_config": {
                        "remote_id": "2.2.2.2",
                        "ike_enc_alg": "aes",
                        "ike_mode": "main",
                        "ike_version": "ikev1",
                        "local_id": "1.1.1.1",
                        "ike_auth_alg": "md5",
                        "ike_lifetime": 86100,
                        "ike_pfs": "group2",
                        "psk": "12345678",
                    },
                    "tunnel_ipsec_config": {
                        "ipsec_auth_alg": "md5",
                        "ipsec_enc_alg": "aes",
                        "ipsec_lifetime": 86200,
                        "ipsec_pfs": "group5",
                    },
                },
                {
                    "enable_nat_traversal": True,
                    "tunnel_index": 2,
                    "tunnel_ike_config": {
                        "local_id": "4.4.4.4",
                        "remote_id": "5.5.5.5",
                        "ike_lifetime": 86400,
                        "ike_pfs": "group5",
                        "ike_mode": "main",
                        "ike_version": "ikev2",
                        "psk": "32333442",
                        "ike_auth_alg": "md5",
                        "ike_enc_alg": "aes",
                    },
                    "tunnel_ipsec_config": {
                        "ipsec_enc_alg": "aes",
                        "ipsec_lifetime": 86400,
                        "ipsec_pfs": "group5",
                        "ipsec_auth_alg": "sha256",
                    },
                    "customer_gateway_id": default_meo_c_iz.id,
                    "enable_dpd": True,
                },
            ],
            remote_subnet="0.0.0.0/0")
        default_transit_router_vpn_attachment = alicloud.cen.TransitRouterVpnAttachment("default",
            transit_router_id=default_m8_zo6_h.transit_router_id,
            vpn_id=defaultvr_pzdh.id,
            auto_publish_route_enabled=False,
            charge_type="POSTPAY",
            transit_router_attachment_name="example-vpn-attachment",
            vpn_owner_id=default.id,
            cen_id=default_m8_zo6_h.cen_id,
            transit_router_attachment_description="example-vpn-attachment")
        ```

        ## Import

        Cloud Enterprise Network (CEN) Transit Router Vpn Attachment can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:cen/transitRouterVpnAttachment:TransitRouterVpnAttachment example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] auto_publish_route_enabled: Specifies whether to allow the transit router to automatically advertise routes to the IPsec-VPN attachment. Valid values:
        :param pulumi.Input[_builtins.str] cen_id: The ID of the Cloud Enterprise Network (CEN) instance.
        :param pulumi.Input[_builtins.str] charge_type: The billing method.
               Set the value to `POSTPAY`, which is the default value and specifies the pay-as-you-go billing method.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource
        :param pulumi.Input[_builtins.str] transit_router_attachment_description: The new description of the VPN attachment.
               The description must be 2 to 256 characters in length. The description must start with a letter but cannot start with `http://` or `https://`.
        :param pulumi.Input[_builtins.str] transit_router_attachment_name: The name of the VPN attachment.
               The name must be 2 to 128 characters in length, and can contain letters, digits, underscores (\\_), and hyphens (-). It must start with a letter.
        :param pulumi.Input[_builtins.str] transit_router_id: The ID of the transit router.
        :param pulumi.Input[_builtins.str] vpn_id: The ID of the IPsec-VPN attachment.
        :param pulumi.Input[_builtins.str] vpn_owner_id: The ID of the Alibaba Cloud account to which the IPsec-VPN connection belongs.
               
               - If you do not set this parameter, the ID of the current Alibaba Cloud account is used.
               - You must set VpnOwnerId if you want to connect the transit router to an IPsec-VPN connection that belongs to another Alibaba Cloud account.
        :param pulumi.Input[Sequence[pulumi.Input[Union['TransitRouterVpnAttachmentZoneArgs', 'TransitRouterVpnAttachmentZoneArgsDict']]]] zones: The Zone ID in the current region.
               System will create resources under the Zone that you specify.
               Left blank if associated IPSec connection is in dual-tunnel mode. See `zone` below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TransitRouterVpnAttachmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Cloud Enterprise Network (CEN) Transit Router Vpn Attachment resource.

        For information about Cloud Enterprise Network (CEN) Transit Router Vpn Attachment and how to use it, see [What is Transit Router Vpn Attachment](https://www.alibabacloud.com/help/en/cen/developer-reference/api-cbn-2017-09-12-createtransitroutervpnattachment).

        > **NOTE:** Available since v1.183.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf_example"
        default = alicloud.cen.get_transit_router_available_resources()
        example = alicloud.cen.Instance("example", cen_instance_name=name)
        example_transit_router = alicloud.cen.TransitRouter("example",
            cen_id=example.id,
            transit_router_description=name,
            transit_router_name=name)
        example_customer_gateway = alicloud.vpn.CustomerGateway("example",
            customer_gateway_name=name,
            ip_address="42.104.22.210",
            asn="45014",
            description=name)
        example_gateway_vpn_attachment = alicloud.vpn.GatewayVpnAttachment("example",
            customer_gateway_id=example_customer_gateway.id,
            network_type="public",
            local_subnet="0.0.0.0/0",
            remote_subnet="0.0.0.0/0",
            effect_immediately=False,
            ike_config={
                "ike_auth_alg": "md5",
                "ike_enc_alg": "des",
                "ike_version": "ikev2",
                "ike_mode": "main",
                "ike_lifetime": 86400,
                "psk": "tf-examplevpn2",
                "ike_pfs": "group1",
                "remote_id": "examplebob2",
                "local_id": "examplealice2",
            },
            ipsec_config={
                "ipsec_pfs": "group5",
                "ipsec_enc_alg": "des",
                "ipsec_auth_alg": "md5",
                "ipsec_lifetime": 86400,
            },
            bgp_config={
                "enable": True,
                "local_asn": 45014,
                "tunnel_cidr": "169.254.11.0/30",
                "local_bgp_ip": "169.254.11.1",
            },
            health_check_config={
                "enable": True,
                "sip": "192.168.1.1",
                "dip": "10.0.0.1",
                "interval": 10,
                "retry": 10,
                "policy": "revoke_route",
            },
            enable_dpd=True,
            enable_nat_traversal=True,
            vpn_attachment_name=name)
        example_transit_router_cidr = alicloud.cen.TransitRouterCidr("example",
            transit_router_id=example_transit_router.transit_router_id,
            cidr="192.168.0.0/16",
            transit_router_cidr_name=name,
            description=name,
            publish_cidr_route=True)
        example_transit_router_vpn_attachment = alicloud.cen.TransitRouterVpnAttachment("example",
            auto_publish_route_enabled=False,
            transit_router_attachment_description=name,
            transit_router_attachment_name=name,
            cen_id=example_transit_router.cen_id,
            transit_router_id=example_transit_router_cidr.transit_router_id,
            vpn_id=example_gateway_vpn_attachment.id,
            zones=[{
                "zone_id": default.resources[0].master_zones[0],
            }])
        ```

        Dual Tunnel Mode Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf_example"
        default = alicloud.get_account()
        defaultbp_r5_uk = alicloud.cen.Instance("defaultbpR5Uk", cen_instance_name="example-vpn-attachment")
        default_m8_zo6_h = alicloud.cen.TransitRouter("defaultM8Zo6H", cen_id=defaultbp_r5_uk.id)
        defaultu_uty_cv = alicloud.cen.TransitRouterCidr("defaultuUtyCv",
            cidr="192.168.10.0/24",
            transit_router_id=default_m8_zo6_h.transit_router_id)
        default_meo_c_iz = alicloud.vpn.CustomerGateway("defaultMeoCIz",
            ip_address="0.0.0.0",
            customer_gateway_name="example-vpn-attachment",
            opts = pulumi.ResourceOptions(depends_on=[defaultu_uty_cv]))
        default_get_transit_router_service = alicloud.cen.get_transit_router_service(enable="On")
        defaultvr_pzdh = alicloud.vpn.GatewayVpnAttachment("defaultvrPzdh",
            network_type="public",
            local_subnet="0.0.0.0/0",
            enable_tunnels_bgp=False,
            vpn_attachment_name=name,
            tunnel_options_specifications=[
                {
                    "customer_gateway_id": default_meo_c_iz.id,
                    "enable_dpd": True,
                    "enable_nat_traversal": True,
                    "tunnel_index": 1,
                    "tunnel_ike_config": {
                        "remote_id": "2.2.2.2",
                        "ike_enc_alg": "aes",
                        "ike_mode": "main",
                        "ike_version": "ikev1",
                        "local_id": "1.1.1.1",
                        "ike_auth_alg": "md5",
                        "ike_lifetime": 86100,
                        "ike_pfs": "group2",
                        "psk": "12345678",
                    },
                    "tunnel_ipsec_config": {
                        "ipsec_auth_alg": "md5",
                        "ipsec_enc_alg": "aes",
                        "ipsec_lifetime": 86200,
                        "ipsec_pfs": "group5",
                    },
                },
                {
                    "enable_nat_traversal": True,
                    "tunnel_index": 2,
                    "tunnel_ike_config": {
                        "local_id": "4.4.4.4",
                        "remote_id": "5.5.5.5",
                        "ike_lifetime": 86400,
                        "ike_pfs": "group5",
                        "ike_mode": "main",
                        "ike_version": "ikev2",
                        "psk": "32333442",
                        "ike_auth_alg": "md5",
                        "ike_enc_alg": "aes",
                    },
                    "tunnel_ipsec_config": {
                        "ipsec_enc_alg": "aes",
                        "ipsec_lifetime": 86400,
                        "ipsec_pfs": "group5",
                        "ipsec_auth_alg": "sha256",
                    },
                    "customer_gateway_id": default_meo_c_iz.id,
                    "enable_dpd": True,
                },
            ],
            remote_subnet="0.0.0.0/0")
        default_transit_router_vpn_attachment = alicloud.cen.TransitRouterVpnAttachment("default",
            transit_router_id=default_m8_zo6_h.transit_router_id,
            vpn_id=defaultvr_pzdh.id,
            auto_publish_route_enabled=False,
            charge_type="POSTPAY",
            transit_router_attachment_name="example-vpn-attachment",
            vpn_owner_id=default.id,
            cen_id=default_m8_zo6_h.cen_id,
            transit_router_attachment_description="example-vpn-attachment")
        ```

        ## Import

        Cloud Enterprise Network (CEN) Transit Router Vpn Attachment can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:cen/transitRouterVpnAttachment:TransitRouterVpnAttachment example <id>
        ```

        :param str resource_name: The name of the resource.
        :param TransitRouterVpnAttachmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TransitRouterVpnAttachmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_publish_route_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 cen_id: Optional[pulumi.Input[_builtins.str]] = None,
                 charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 transit_router_attachment_description: Optional[pulumi.Input[_builtins.str]] = None,
                 transit_router_attachment_name: Optional[pulumi.Input[_builtins.str]] = None,
                 transit_router_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vpn_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vpn_owner_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zones: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TransitRouterVpnAttachmentZoneArgs', 'TransitRouterVpnAttachmentZoneArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TransitRouterVpnAttachmentArgs.__new__(TransitRouterVpnAttachmentArgs)

            __props__.__dict__["auto_publish_route_enabled"] = auto_publish_route_enabled
            __props__.__dict__["cen_id"] = cen_id
            __props__.__dict__["charge_type"] = charge_type
            __props__.__dict__["tags"] = tags
            __props__.__dict__["transit_router_attachment_description"] = transit_router_attachment_description
            __props__.__dict__["transit_router_attachment_name"] = transit_router_attachment_name
            __props__.__dict__["transit_router_id"] = transit_router_id
            if vpn_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpn_id'")
            __props__.__dict__["vpn_id"] = vpn_id
            __props__.__dict__["vpn_owner_id"] = vpn_owner_id
            __props__.__dict__["zones"] = zones
            __props__.__dict__["create_time"] = None
            __props__.__dict__["region_id"] = None
            __props__.__dict__["status"] = None
        super(TransitRouterVpnAttachment, __self__).__init__(
            'alicloud:cen/transitRouterVpnAttachment:TransitRouterVpnAttachment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_publish_route_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            cen_id: Optional[pulumi.Input[_builtins.str]] = None,
            charge_type: Optional[pulumi.Input[_builtins.str]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            region_id: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            transit_router_attachment_description: Optional[pulumi.Input[_builtins.str]] = None,
            transit_router_attachment_name: Optional[pulumi.Input[_builtins.str]] = None,
            transit_router_id: Optional[pulumi.Input[_builtins.str]] = None,
            vpn_id: Optional[pulumi.Input[_builtins.str]] = None,
            vpn_owner_id: Optional[pulumi.Input[_builtins.str]] = None,
            zones: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TransitRouterVpnAttachmentZoneArgs', 'TransitRouterVpnAttachmentZoneArgsDict']]]]] = None) -> 'TransitRouterVpnAttachment':
        """
        Get an existing TransitRouterVpnAttachment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] auto_publish_route_enabled: Specifies whether to allow the transit router to automatically advertise routes to the IPsec-VPN attachment. Valid values:
        :param pulumi.Input[_builtins.str] cen_id: The ID of the Cloud Enterprise Network (CEN) instance.
        :param pulumi.Input[_builtins.str] charge_type: The billing method.
               Set the value to `POSTPAY`, which is the default value and specifies the pay-as-you-go billing method.
        :param pulumi.Input[_builtins.str] create_time: The creation time of the resource
        :param pulumi.Input[_builtins.str] region_id: The ID of the region where the transit router is deployed.
        :param pulumi.Input[_builtins.str] status: Status
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource
        :param pulumi.Input[_builtins.str] transit_router_attachment_description: The new description of the VPN attachment.
               The description must be 2 to 256 characters in length. The description must start with a letter but cannot start with `http://` or `https://`.
        :param pulumi.Input[_builtins.str] transit_router_attachment_name: The name of the VPN attachment.
               The name must be 2 to 128 characters in length, and can contain letters, digits, underscores (\\_), and hyphens (-). It must start with a letter.
        :param pulumi.Input[_builtins.str] transit_router_id: The ID of the transit router.
        :param pulumi.Input[_builtins.str] vpn_id: The ID of the IPsec-VPN attachment.
        :param pulumi.Input[_builtins.str] vpn_owner_id: The ID of the Alibaba Cloud account to which the IPsec-VPN connection belongs.
               
               - If you do not set this parameter, the ID of the current Alibaba Cloud account is used.
               - You must set VpnOwnerId if you want to connect the transit router to an IPsec-VPN connection that belongs to another Alibaba Cloud account.
        :param pulumi.Input[Sequence[pulumi.Input[Union['TransitRouterVpnAttachmentZoneArgs', 'TransitRouterVpnAttachmentZoneArgsDict']]]] zones: The Zone ID in the current region.
               System will create resources under the Zone that you specify.
               Left blank if associated IPSec connection is in dual-tunnel mode. See `zone` below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TransitRouterVpnAttachmentState.__new__(_TransitRouterVpnAttachmentState)

        __props__.__dict__["auto_publish_route_enabled"] = auto_publish_route_enabled
        __props__.__dict__["cen_id"] = cen_id
        __props__.__dict__["charge_type"] = charge_type
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["region_id"] = region_id
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["transit_router_attachment_description"] = transit_router_attachment_description
        __props__.__dict__["transit_router_attachment_name"] = transit_router_attachment_name
        __props__.__dict__["transit_router_id"] = transit_router_id
        __props__.__dict__["vpn_id"] = vpn_id
        __props__.__dict__["vpn_owner_id"] = vpn_owner_id
        __props__.__dict__["zones"] = zones
        return TransitRouterVpnAttachment(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="autoPublishRouteEnabled")
    def auto_publish_route_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether to allow the transit router to automatically advertise routes to the IPsec-VPN attachment. Valid values:
        """
        return pulumi.get(self, "auto_publish_route_enabled")

    @_builtins.property
    @pulumi.getter(name="cenId")
    def cen_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Cloud Enterprise Network (CEN) instance.
        """
        return pulumi.get(self, "cen_id")

    @_builtins.property
    @pulumi.getter(name="chargeType")
    def charge_type(self) -> pulumi.Output[_builtins.str]:
        """
        The billing method.
        Set the value to `POSTPAY`, which is the default value and specifies the pay-as-you-go billing method.
        """
        return pulumi.get(self, "charge_type")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The creation time of the resource
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the region where the transit router is deployed.
        """
        return pulumi.get(self, "region_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Status
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        The tag of the resource
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="transitRouterAttachmentDescription")
    def transit_router_attachment_description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The new description of the VPN attachment.
        The description must be 2 to 256 characters in length. The description must start with a letter but cannot start with `http://` or `https://`.
        """
        return pulumi.get(self, "transit_router_attachment_description")

    @_builtins.property
    @pulumi.getter(name="transitRouterAttachmentName")
    def transit_router_attachment_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of the VPN attachment.
        The name must be 2 to 128 characters in length, and can contain letters, digits, underscores (\\_), and hyphens (-). It must start with a letter.
        """
        return pulumi.get(self, "transit_router_attachment_name")

    @_builtins.property
    @pulumi.getter(name="transitRouterId")
    def transit_router_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the transit router.
        """
        return pulumi.get(self, "transit_router_id")

    @_builtins.property
    @pulumi.getter(name="vpnId")
    def vpn_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the IPsec-VPN attachment.
        """
        return pulumi.get(self, "vpn_id")

    @_builtins.property
    @pulumi.getter(name="vpnOwnerId")
    def vpn_owner_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Alibaba Cloud account to which the IPsec-VPN connection belongs.

        - If you do not set this parameter, the ID of the current Alibaba Cloud account is used.
        - You must set VpnOwnerId if you want to connect the transit router to an IPsec-VPN connection that belongs to another Alibaba Cloud account.
        """
        return pulumi.get(self, "vpn_owner_id")

    @_builtins.property
    @pulumi.getter
    def zones(self) -> pulumi.Output[Optional[Sequence['outputs.TransitRouterVpnAttachmentZone']]]:
        """
        The Zone ID in the current region.
        System will create resources under the Zone that you specify.
        Left blank if associated IPSec connection is in dual-tunnel mode. See `zone` below.
        """
        return pulumi.get(self, "zones")

