# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FirewallVpcFirewallCenArgs', 'FirewallVpcFirewallCen']

@pulumi.input_type
class FirewallVpcFirewallCenArgs:
    def __init__(__self__, *,
                 cen_id: pulumi.Input[_builtins.str],
                 local_vpc: pulumi.Input['FirewallVpcFirewallCenLocalVpcArgs'],
                 status: pulumi.Input[_builtins.str],
                 vpc_firewall_name: pulumi.Input[_builtins.str],
                 vpc_region: pulumi.Input[_builtins.str],
                 lang: Optional[pulumi.Input[_builtins.str]] = None,
                 member_uid: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a FirewallVpcFirewallCen resource.
        :param pulumi.Input[_builtins.str] cen_id: The ID of the CEN instance.
        :param pulumi.Input['FirewallVpcFirewallCenLocalVpcArgs'] local_vpc: The details of the VPC. See `local_vpc` below.
        :param pulumi.Input[_builtins.str] status: Firewall switch status.
        :param pulumi.Input[_builtins.str] vpc_firewall_name: The name of the VPC firewall instance.
        :param pulumi.Input[_builtins.str] vpc_region: The ID of the region to which the VPC is created.
        :param pulumi.Input[_builtins.str] lang: The language type of the requested and received messages. Valid values:
        :param pulumi.Input[_builtins.str] member_uid: The UID of the member account (other Alibaba Cloud account) of the current Alibaba cloud account.
        """
        pulumi.set(__self__, "cen_id", cen_id)
        pulumi.set(__self__, "local_vpc", local_vpc)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "vpc_firewall_name", vpc_firewall_name)
        pulumi.set(__self__, "vpc_region", vpc_region)
        if lang is not None:
            pulumi.set(__self__, "lang", lang)
        if member_uid is not None:
            pulumi.set(__self__, "member_uid", member_uid)

    @_builtins.property
    @pulumi.getter(name="cenId")
    def cen_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the CEN instance.
        """
        return pulumi.get(self, "cen_id")

    @cen_id.setter
    def cen_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cen_id", value)

    @_builtins.property
    @pulumi.getter(name="localVpc")
    def local_vpc(self) -> pulumi.Input['FirewallVpcFirewallCenLocalVpcArgs']:
        """
        The details of the VPC. See `local_vpc` below.
        """
        return pulumi.get(self, "local_vpc")

    @local_vpc.setter
    def local_vpc(self, value: pulumi.Input['FirewallVpcFirewallCenLocalVpcArgs']):
        pulumi.set(self, "local_vpc", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Input[_builtins.str]:
        """
        Firewall switch status.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="vpcFirewallName")
    def vpc_firewall_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the VPC firewall instance.
        """
        return pulumi.get(self, "vpc_firewall_name")

    @vpc_firewall_name.setter
    def vpc_firewall_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vpc_firewall_name", value)

    @_builtins.property
    @pulumi.getter(name="vpcRegion")
    def vpc_region(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the region to which the VPC is created.
        """
        return pulumi.get(self, "vpc_region")

    @vpc_region.setter
    def vpc_region(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vpc_region", value)

    @_builtins.property
    @pulumi.getter
    def lang(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The language type of the requested and received messages. Valid values:
        """
        return pulumi.get(self, "lang")

    @lang.setter
    def lang(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lang", value)

    @_builtins.property
    @pulumi.getter(name="memberUid")
    def member_uid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The UID of the member account (other Alibaba Cloud account) of the current Alibaba cloud account.
        """
        return pulumi.get(self, "member_uid")

    @member_uid.setter
    def member_uid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "member_uid", value)


@pulumi.input_type
class _FirewallVpcFirewallCenState:
    def __init__(__self__, *,
                 cen_id: Optional[pulumi.Input[_builtins.str]] = None,
                 connect_type: Optional[pulumi.Input[_builtins.str]] = None,
                 lang: Optional[pulumi.Input[_builtins.str]] = None,
                 local_vpc: Optional[pulumi.Input['FirewallVpcFirewallCenLocalVpcArgs']] = None,
                 member_uid: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_firewall_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_firewall_name: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering FirewallVpcFirewallCen resources.
        :param pulumi.Input[_builtins.str] cen_id: The ID of the CEN instance.
        :param pulumi.Input[_builtins.str] connect_type: Intercommunication type, value: expressconnect: Express Channel cen: Cloud Enterprise Network
        :param pulumi.Input[_builtins.str] lang: The language type of the requested and received messages. Valid values:
        :param pulumi.Input['FirewallVpcFirewallCenLocalVpcArgs'] local_vpc: The details of the VPC. See `local_vpc` below.
        :param pulumi.Input[_builtins.str] member_uid: The UID of the member account (other Alibaba Cloud account) of the current Alibaba cloud account.
        :param pulumi.Input[_builtins.str] status: Firewall switch status.
        :param pulumi.Input[_builtins.str] vpc_firewall_id: VPC firewall ID
        :param pulumi.Input[_builtins.str] vpc_firewall_name: The name of the VPC firewall instance.
        :param pulumi.Input[_builtins.str] vpc_region: The ID of the region to which the VPC is created.
        """
        if cen_id is not None:
            pulumi.set(__self__, "cen_id", cen_id)
        if connect_type is not None:
            pulumi.set(__self__, "connect_type", connect_type)
        if lang is not None:
            pulumi.set(__self__, "lang", lang)
        if local_vpc is not None:
            pulumi.set(__self__, "local_vpc", local_vpc)
        if member_uid is not None:
            pulumi.set(__self__, "member_uid", member_uid)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if vpc_firewall_id is not None:
            pulumi.set(__self__, "vpc_firewall_id", vpc_firewall_id)
        if vpc_firewall_name is not None:
            pulumi.set(__self__, "vpc_firewall_name", vpc_firewall_name)
        if vpc_region is not None:
            pulumi.set(__self__, "vpc_region", vpc_region)

    @_builtins.property
    @pulumi.getter(name="cenId")
    def cen_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the CEN instance.
        """
        return pulumi.get(self, "cen_id")

    @cen_id.setter
    def cen_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cen_id", value)

    @_builtins.property
    @pulumi.getter(name="connectType")
    def connect_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Intercommunication type, value: expressconnect: Express Channel cen: Cloud Enterprise Network
        """
        return pulumi.get(self, "connect_type")

    @connect_type.setter
    def connect_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "connect_type", value)

    @_builtins.property
    @pulumi.getter
    def lang(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The language type of the requested and received messages. Valid values:
        """
        return pulumi.get(self, "lang")

    @lang.setter
    def lang(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lang", value)

    @_builtins.property
    @pulumi.getter(name="localVpc")
    def local_vpc(self) -> Optional[pulumi.Input['FirewallVpcFirewallCenLocalVpcArgs']]:
        """
        The details of the VPC. See `local_vpc` below.
        """
        return pulumi.get(self, "local_vpc")

    @local_vpc.setter
    def local_vpc(self, value: Optional[pulumi.Input['FirewallVpcFirewallCenLocalVpcArgs']]):
        pulumi.set(self, "local_vpc", value)

    @_builtins.property
    @pulumi.getter(name="memberUid")
    def member_uid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The UID of the member account (other Alibaba Cloud account) of the current Alibaba cloud account.
        """
        return pulumi.get(self, "member_uid")

    @member_uid.setter
    def member_uid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "member_uid", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Firewall switch status.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="vpcFirewallId")
    def vpc_firewall_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        VPC firewall ID
        """
        return pulumi.get(self, "vpc_firewall_id")

    @vpc_firewall_id.setter
    def vpc_firewall_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_firewall_id", value)

    @_builtins.property
    @pulumi.getter(name="vpcFirewallName")
    def vpc_firewall_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the VPC firewall instance.
        """
        return pulumi.get(self, "vpc_firewall_name")

    @vpc_firewall_name.setter
    def vpc_firewall_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_firewall_name", value)

    @_builtins.property
    @pulumi.getter(name="vpcRegion")
    def vpc_region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the region to which the VPC is created.
        """
        return pulumi.get(self, "vpc_region")

    @vpc_region.setter
    def vpc_region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_region", value)


@pulumi.type_token("alicloud:cloudfirewall/firewallVpcFirewallCen:FirewallVpcFirewallCen")
class FirewallVpcFirewallCen(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cen_id: Optional[pulumi.Input[_builtins.str]] = None,
                 lang: Optional[pulumi.Input[_builtins.str]] = None,
                 local_vpc: Optional[pulumi.Input[Union['FirewallVpcFirewallCenLocalVpcArgs', 'FirewallVpcFirewallCenLocalVpcArgsDict']]] = None,
                 member_uid: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_firewall_name: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Cloud Firewall Vpc Firewall Cen resource.

        For information about Cloud Firewall Vpc Firewall Cen and how to use it, see [What is Vpc Firewall Cen](https://www.alibabacloud.com/help/en/cloud-firewall/latest/createvpcfirewallcenconfigure).

        > **NOTE:** Available since v1.194.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        # These resource primary keys should be replaced with your actual values.
        default = alicloud.cloudfirewall.FirewallVpcFirewallCen("default",
            cen_id="cen-xxx",
            local_vpc={
                "network_instance_id": "vpc-xxx",
            },
            status="open",
            member_uid="14151*****827022",
            vpc_region="cn-hangzhou",
            vpc_firewall_name="tf-vpc-firewall-name")
        ```

        ## Import

        Cloud Firewall Vpc Firewall Cen can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:cloudfirewall/firewallVpcFirewallCen:FirewallVpcFirewallCen example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cen_id: The ID of the CEN instance.
        :param pulumi.Input[_builtins.str] lang: The language type of the requested and received messages. Valid values:
        :param pulumi.Input[Union['FirewallVpcFirewallCenLocalVpcArgs', 'FirewallVpcFirewallCenLocalVpcArgsDict']] local_vpc: The details of the VPC. See `local_vpc` below.
        :param pulumi.Input[_builtins.str] member_uid: The UID of the member account (other Alibaba Cloud account) of the current Alibaba cloud account.
        :param pulumi.Input[_builtins.str] status: Firewall switch status.
        :param pulumi.Input[_builtins.str] vpc_firewall_name: The name of the VPC firewall instance.
        :param pulumi.Input[_builtins.str] vpc_region: The ID of the region to which the VPC is created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FirewallVpcFirewallCenArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Cloud Firewall Vpc Firewall Cen resource.

        For information about Cloud Firewall Vpc Firewall Cen and how to use it, see [What is Vpc Firewall Cen](https://www.alibabacloud.com/help/en/cloud-firewall/latest/createvpcfirewallcenconfigure).

        > **NOTE:** Available since v1.194.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        # These resource primary keys should be replaced with your actual values.
        default = alicloud.cloudfirewall.FirewallVpcFirewallCen("default",
            cen_id="cen-xxx",
            local_vpc={
                "network_instance_id": "vpc-xxx",
            },
            status="open",
            member_uid="14151*****827022",
            vpc_region="cn-hangzhou",
            vpc_firewall_name="tf-vpc-firewall-name")
        ```

        ## Import

        Cloud Firewall Vpc Firewall Cen can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:cloudfirewall/firewallVpcFirewallCen:FirewallVpcFirewallCen example <id>
        ```

        :param str resource_name: The name of the resource.
        :param FirewallVpcFirewallCenArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FirewallVpcFirewallCenArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cen_id: Optional[pulumi.Input[_builtins.str]] = None,
                 lang: Optional[pulumi.Input[_builtins.str]] = None,
                 local_vpc: Optional[pulumi.Input[Union['FirewallVpcFirewallCenLocalVpcArgs', 'FirewallVpcFirewallCenLocalVpcArgsDict']]] = None,
                 member_uid: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_firewall_name: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FirewallVpcFirewallCenArgs.__new__(FirewallVpcFirewallCenArgs)

            if cen_id is None and not opts.urn:
                raise TypeError("Missing required property 'cen_id'")
            __props__.__dict__["cen_id"] = cen_id
            __props__.__dict__["lang"] = lang
            if local_vpc is None and not opts.urn:
                raise TypeError("Missing required property 'local_vpc'")
            __props__.__dict__["local_vpc"] = local_vpc
            __props__.__dict__["member_uid"] = member_uid
            if status is None and not opts.urn:
                raise TypeError("Missing required property 'status'")
            __props__.__dict__["status"] = status
            if vpc_firewall_name is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_firewall_name'")
            __props__.__dict__["vpc_firewall_name"] = vpc_firewall_name
            if vpc_region is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_region'")
            __props__.__dict__["vpc_region"] = vpc_region
            __props__.__dict__["connect_type"] = None
            __props__.__dict__["vpc_firewall_id"] = None
        super(FirewallVpcFirewallCen, __self__).__init__(
            'alicloud:cloudfirewall/firewallVpcFirewallCen:FirewallVpcFirewallCen',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cen_id: Optional[pulumi.Input[_builtins.str]] = None,
            connect_type: Optional[pulumi.Input[_builtins.str]] = None,
            lang: Optional[pulumi.Input[_builtins.str]] = None,
            local_vpc: Optional[pulumi.Input[Union['FirewallVpcFirewallCenLocalVpcArgs', 'FirewallVpcFirewallCenLocalVpcArgsDict']]] = None,
            member_uid: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            vpc_firewall_id: Optional[pulumi.Input[_builtins.str]] = None,
            vpc_firewall_name: Optional[pulumi.Input[_builtins.str]] = None,
            vpc_region: Optional[pulumi.Input[_builtins.str]] = None) -> 'FirewallVpcFirewallCen':
        """
        Get an existing FirewallVpcFirewallCen resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cen_id: The ID of the CEN instance.
        :param pulumi.Input[_builtins.str] connect_type: Intercommunication type, value: expressconnect: Express Channel cen: Cloud Enterprise Network
        :param pulumi.Input[_builtins.str] lang: The language type of the requested and received messages. Valid values:
        :param pulumi.Input[Union['FirewallVpcFirewallCenLocalVpcArgs', 'FirewallVpcFirewallCenLocalVpcArgsDict']] local_vpc: The details of the VPC. See `local_vpc` below.
        :param pulumi.Input[_builtins.str] member_uid: The UID of the member account (other Alibaba Cloud account) of the current Alibaba cloud account.
        :param pulumi.Input[_builtins.str] status: Firewall switch status.
        :param pulumi.Input[_builtins.str] vpc_firewall_id: VPC firewall ID
        :param pulumi.Input[_builtins.str] vpc_firewall_name: The name of the VPC firewall instance.
        :param pulumi.Input[_builtins.str] vpc_region: The ID of the region to which the VPC is created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FirewallVpcFirewallCenState.__new__(_FirewallVpcFirewallCenState)

        __props__.__dict__["cen_id"] = cen_id
        __props__.__dict__["connect_type"] = connect_type
        __props__.__dict__["lang"] = lang
        __props__.__dict__["local_vpc"] = local_vpc
        __props__.__dict__["member_uid"] = member_uid
        __props__.__dict__["status"] = status
        __props__.__dict__["vpc_firewall_id"] = vpc_firewall_id
        __props__.__dict__["vpc_firewall_name"] = vpc_firewall_name
        __props__.__dict__["vpc_region"] = vpc_region
        return FirewallVpcFirewallCen(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="cenId")
    def cen_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the CEN instance.
        """
        return pulumi.get(self, "cen_id")

    @_builtins.property
    @pulumi.getter(name="connectType")
    def connect_type(self) -> pulumi.Output[_builtins.str]:
        """
        Intercommunication type, value: expressconnect: Express Channel cen: Cloud Enterprise Network
        """
        return pulumi.get(self, "connect_type")

    @_builtins.property
    @pulumi.getter
    def lang(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The language type of the requested and received messages. Valid values:
        """
        return pulumi.get(self, "lang")

    @_builtins.property
    @pulumi.getter(name="localVpc")
    def local_vpc(self) -> pulumi.Output['outputs.FirewallVpcFirewallCenLocalVpc']:
        """
        The details of the VPC. See `local_vpc` below.
        """
        return pulumi.get(self, "local_vpc")

    @_builtins.property
    @pulumi.getter(name="memberUid")
    def member_uid(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The UID of the member account (other Alibaba Cloud account) of the current Alibaba cloud account.
        """
        return pulumi.get(self, "member_uid")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Firewall switch status.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="vpcFirewallId")
    def vpc_firewall_id(self) -> pulumi.Output[_builtins.str]:
        """
        VPC firewall ID
        """
        return pulumi.get(self, "vpc_firewall_id")

    @_builtins.property
    @pulumi.getter(name="vpcFirewallName")
    def vpc_firewall_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the VPC firewall instance.
        """
        return pulumi.get(self, "vpc_firewall_name")

    @_builtins.property
    @pulumi.getter(name="vpcRegion")
    def vpc_region(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the region to which the VPC is created.
        """
        return pulumi.get(self, "vpc_region")

