# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetVpcCenTrFirewallsResult',
    'AwaitableGetVpcCenTrFirewallsResult',
    'get_vpc_cen_tr_firewalls',
    'get_vpc_cen_tr_firewalls_output',
]

@pulumi.output_type
class GetVpcCenTrFirewallsResult:
    """
    A collection of values returned by getVpcCenTrFirewalls.
    """
    def __init__(__self__, cen_id=None, current_page=None, firewall_id=None, firewall_name=None, firewall_switch_status=None, firewalls=None, id=None, ids=None, output_file=None, page_number=None, page_size=None, region_no=None, route_mode=None, transit_router_id=None):
        if cen_id and not isinstance(cen_id, str):
            raise TypeError("Expected argument 'cen_id' to be a str")
        pulumi.set(__self__, "cen_id", cen_id)
        if current_page and not isinstance(current_page, int):
            raise TypeError("Expected argument 'current_page' to be a int")
        pulumi.set(__self__, "current_page", current_page)
        if firewall_id and not isinstance(firewall_id, str):
            raise TypeError("Expected argument 'firewall_id' to be a str")
        pulumi.set(__self__, "firewall_id", firewall_id)
        if firewall_name and not isinstance(firewall_name, str):
            raise TypeError("Expected argument 'firewall_name' to be a str")
        pulumi.set(__self__, "firewall_name", firewall_name)
        if firewall_switch_status and not isinstance(firewall_switch_status, str):
            raise TypeError("Expected argument 'firewall_switch_status' to be a str")
        pulumi.set(__self__, "firewall_switch_status", firewall_switch_status)
        if firewalls and not isinstance(firewalls, list):
            raise TypeError("Expected argument 'firewalls' to be a list")
        pulumi.set(__self__, "firewalls", firewalls)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if page_number and not isinstance(page_number, int):
            raise TypeError("Expected argument 'page_number' to be a int")
        pulumi.set(__self__, "page_number", page_number)
        if page_size and not isinstance(page_size, int):
            raise TypeError("Expected argument 'page_size' to be a int")
        pulumi.set(__self__, "page_size", page_size)
        if region_no and not isinstance(region_no, str):
            raise TypeError("Expected argument 'region_no' to be a str")
        pulumi.set(__self__, "region_no", region_no)
        if route_mode and not isinstance(route_mode, str):
            raise TypeError("Expected argument 'route_mode' to be a str")
        pulumi.set(__self__, "route_mode", route_mode)
        if transit_router_id and not isinstance(transit_router_id, str):
            raise TypeError("Expected argument 'transit_router_id' to be a str")
        pulumi.set(__self__, "transit_router_id", transit_router_id)

    @_builtins.property
    @pulumi.getter(name="cenId")
    def cen_id(self) -> Optional[_builtins.str]:
        """
        The ID of the CEN instance.
        """
        return pulumi.get(self, "cen_id")

    @_builtins.property
    @pulumi.getter(name="currentPage")
    def current_page(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "current_page")

    @_builtins.property
    @pulumi.getter(name="firewallId")
    def firewall_id(self) -> Optional[_builtins.str]:
        """
        Firewall ID
        """
        return pulumi.get(self, "firewall_id")

    @_builtins.property
    @pulumi.getter(name="firewallName")
    def firewall_name(self) -> Optional[_builtins.str]:
        """
        The name of Cloud Firewall.
        """
        return pulumi.get(self, "firewall_name")

    @_builtins.property
    @pulumi.getter(name="firewallSwitchStatus")
    def firewall_switch_status(self) -> Optional[_builtins.str]:
        """
        The status of the VPC boundary firewall. Value:-**opened**: opened-**closed**: closed-**notconfigured**: indicates that the VPC boundary firewall has not been configured yet.-**configured**: indicates that the VPC boundary firewall has been configured.-**creating**: indicates that a VPC boundary firewall is being created.-**opening**: indicates that the VPC border firewall is being enabled.-**deleting**: indicates that the VPC boundary firewall is being deleted.> If this parameter is not set, the VPC boundary firewall in all states is queried.
        """
        return pulumi.get(self, "firewall_switch_status")

    @_builtins.property
    @pulumi.getter
    def firewalls(self) -> Sequence['outputs.GetVpcCenTrFirewallsFirewallResult']:
        """
        A list of Vpc Cen Tr Firewall Entries. Each element contains the following attributes:
        """
        return pulumi.get(self, "firewalls")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        """
        A list of Vpc Cen Tr Firewall IDs.
        """
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")

    @_builtins.property
    @pulumi.getter(name="pageNumber")
    def page_number(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "page_number")

    @_builtins.property
    @pulumi.getter(name="pageSize")
    def page_size(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "page_size")

    @_builtins.property
    @pulumi.getter(name="regionNo")
    def region_no(self) -> Optional[_builtins.str]:
        """
        The region ID of the transit router instance.
        """
        return pulumi.get(self, "region_no")

    @_builtins.property
    @pulumi.getter(name="routeMode")
    def route_mode(self) -> Optional[_builtins.str]:
        """
        The routing pattern. Value: managed: indicates automatic mode
        """
        return pulumi.get(self, "route_mode")

    @_builtins.property
    @pulumi.getter(name="transitRouterId")
    def transit_router_id(self) -> Optional[_builtins.str]:
        """
        The ID of the transit router instance.
        """
        return pulumi.get(self, "transit_router_id")


class AwaitableGetVpcCenTrFirewallsResult(GetVpcCenTrFirewallsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVpcCenTrFirewallsResult(
            cen_id=self.cen_id,
            current_page=self.current_page,
            firewall_id=self.firewall_id,
            firewall_name=self.firewall_name,
            firewall_switch_status=self.firewall_switch_status,
            firewalls=self.firewalls,
            id=self.id,
            ids=self.ids,
            output_file=self.output_file,
            page_number=self.page_number,
            page_size=self.page_size,
            region_no=self.region_no,
            route_mode=self.route_mode,
            transit_router_id=self.transit_router_id)


def get_vpc_cen_tr_firewalls(cen_id: Optional[_builtins.str] = None,
                             current_page: Optional[_builtins.int] = None,
                             firewall_id: Optional[_builtins.str] = None,
                             firewall_name: Optional[_builtins.str] = None,
                             firewall_switch_status: Optional[_builtins.str] = None,
                             ids: Optional[Sequence[_builtins.str]] = None,
                             output_file: Optional[_builtins.str] = None,
                             page_number: Optional[_builtins.int] = None,
                             page_size: Optional[_builtins.int] = None,
                             region_no: Optional[_builtins.str] = None,
                             route_mode: Optional[_builtins.str] = None,
                             transit_router_id: Optional[_builtins.str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVpcCenTrFirewallsResult:
    """
    This data source provides Cloud Firewall Vpc Cen Tr Firewall available to the user.[What is Vpc Cen Tr Firewall](https://next.api.alibabacloud.com/document/Cloudfw/2017-12-07/CreateTrFirewallV2)

    > **NOTE:** Available since v1.243.0.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    config = pulumi.Config()
    name = config.get("name")
    if name is None:
        name = "terraform-example"
    description = config.get("description")
    if description is None:
        description = "Created by Terraform"
    firewall_name = config.get("firewallName")
    if firewall_name is None:
        firewall_name = "tf-example"
    tr_attachment_master_cidr = config.get("trAttachmentMasterCidr")
    if tr_attachment_master_cidr is None:
        tr_attachment_master_cidr = "192.168.3.192/26"
    firewall_subnet_cidr = config.get("firewallSubnetCidr")
    if firewall_subnet_cidr is None:
        firewall_subnet_cidr = "192.168.3.0/25"
    region = config.get("region")
    if region is None:
        region = "cn-hangzhou"
    tr_attachment_slave_cidr = config.get("trAttachmentSlaveCidr")
    if tr_attachment_slave_cidr is None:
        tr_attachment_slave_cidr = "192.168.3.128/26"
    firewall_vpc_cidr = config.get("firewallVpcCidr")
    if firewall_vpc_cidr is None:
        firewall_vpc_cidr = "192.168.3.0/24"
    zone1 = config.get("zone1")
    if zone1 is None:
        zone1 = "cn-hangzhou-h"
    firewall_name_update = config.get("firewallNameUpdate")
    if firewall_name_update is None:
        firewall_name_update = "tf-example-1"
    zone2 = config.get("zone2")
    if zone2 is None:
        zone2 = "cn-hangzhou-i"
    cen = alicloud.cen.Instance("cen",
        description="terraform example",
        cen_instance_name="Cen_Terraform_example01")
    tr = alicloud.cen.TransitRouter("tr",
        support_multicast=False,
        transit_router_name="CEN_TR_Terraform",
        transit_router_description="tr-created-by-terraform",
        cen_id=cen.id)
    vpc1 = alicloud.vpc.Network("vpc1",
        description="created by terraform",
        cidr_block="192.168.1.0/24",
        vpc_name="vpc1-Terraform")
    vpc1vsw1 = alicloud.vpc.Switch("vpc1vsw1",
        cidr_block="192.168.1.0/25",
        vswitch_name="vpc1-vsw1",
        vpc_id=vpc1.id,
        zone_id=zone1)
    vpc1vsw2 = alicloud.vpc.Switch("vpc1vsw2",
        vpc_id=vpc1.id,
        cidr_block="192.168.1.128/26",
        vswitch_name="vpc1-vsw2",
        zone_id=zone2)
    vpc2 = alicloud.vpc.Network("vpc2",
        description="created by terraform",
        cidr_block="192.168.2.0/24",
        vpc_name="vpc2-Terraform")
    vpc2vsw1 = alicloud.vpc.Switch("vpc2vsw1",
        cidr_block="192.168.2.0/25",
        vswitch_name="vpc2-vsw1",
        vpc_id=vpc2.id,
        zone_id=zone1)
    vpc2vsw2 = alicloud.vpc.Switch("vpc2vsw2",
        cidr_block="192.168.2.128/26",
        vswitch_name="vpc2-vsw2",
        vpc_id=vpc2.id,
        zone_id=zone2)
    tr_vpc1 = alicloud.cen.TransitRouterVpcAttachment("tr-vpc1",
        auto_publish_route_enabled=False,
        zone_mappings=[
            {
                "vswitch_id": vpc1vsw1.id,
                "zone_id": vpc1vsw1.zone_id,
            },
            {
                "zone_id": vpc1vsw2.zone_id,
                "vswitch_id": vpc1vsw2.id,
            },
        ],
        vpc_id=vpc1.id,
        cen_id=cen.id)
    tr_vpc2 = alicloud.cen.TransitRouterVpcAttachment("tr-vpc2",
        auto_publish_route_enabled=False,
        vpc_id=vpc2.id,
        zone_mappings=[
            {
                "vswitch_id": vpc2vsw1.id,
                "zone_id": vpc2vsw1.zone_id,
            },
            {
                "vswitch_id": vpc2vsw2.id,
                "zone_id": vpc2vsw2.zone_id,
            },
        ],
        cen_id=cen.id)
    default_vpc_cen_tr_firewall = alicloud.cloudfirewall.VpcCenTrFirewall("default",
        firewall_description="VpcCenTrFirewall created by terraform",
        region_no=region,
        route_mode="managed",
        cen_id=cen.id,
        firewall_vpc_cidr=firewall_vpc_cidr,
        transit_router_id=tr.transit_router_id,
        tr_attachment_master_cidr=tr_attachment_master_cidr,
        firewall_name=firewall_name,
        firewall_subnet_cidr=firewall_subnet_cidr,
        tr_attachment_slave_cidr=tr_attachment_slave_cidr)
    default = alicloud.cloudfirewall.get_vpc_cen_tr_firewalls_output(ids=[default_vpc_cen_tr_firewall.id],
        cen_id=cen.id,
        firewall_name=firewall_name,
        region_no=region,
        route_mode="managed",
        transit_router_id=tr.transit_router_id)
    pulumi.export("alicloudCloudFirewallVpcCenTrFirewallExampleId", default.firewalls[0].id)
    ```


    :param _builtins.str cen_id: The ID of the CEN instance.
    :param _builtins.int current_page: The page number of the pagination query. The default value is 1.
    :param _builtins.str firewall_id: Firewall ID
    :param _builtins.str firewall_name: The name of Cloud Firewall.
    :param _builtins.str firewall_switch_status: The status of the VPC boundary firewall. Value:-**opened**: opened-**closed**: closed-**notconfigured**: indicates that the VPC boundary firewall has not been configured yet.-**configured**: indicates that the VPC boundary firewall has been configured.-**creating**: indicates that a VPC boundary firewall is being created.-**opening**: indicates that the VPC border firewall is being enabled.-**deleting**: indicates that the VPC boundary firewall is being deleted.> If this parameter is not set, the VPC boundary firewall in all states is queried.
    :param Sequence[_builtins.str] ids: A list of Vpc Cen Tr Firewall IDs.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.int page_number: Current page number.
    :param _builtins.int page_size: The maximum number of pieces of data per page that are displayed during a paged query. The default value is 10.
    :param _builtins.str region_no: The region ID of the transit router instance.
    :param _builtins.str route_mode: The routing pattern. Value: managed: indicates automatic mode
    :param _builtins.str transit_router_id: The ID of the transit router instance.
    """
    __args__ = dict()
    __args__['cenId'] = cen_id
    __args__['currentPage'] = current_page
    __args__['firewallId'] = firewall_id
    __args__['firewallName'] = firewall_name
    __args__['firewallSwitchStatus'] = firewall_switch_status
    __args__['ids'] = ids
    __args__['outputFile'] = output_file
    __args__['pageNumber'] = page_number
    __args__['pageSize'] = page_size
    __args__['regionNo'] = region_no
    __args__['routeMode'] = route_mode
    __args__['transitRouterId'] = transit_router_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:cloudfirewall/getVpcCenTrFirewalls:getVpcCenTrFirewalls', __args__, opts=opts, typ=GetVpcCenTrFirewallsResult).value

    return AwaitableGetVpcCenTrFirewallsResult(
        cen_id=pulumi.get(__ret__, 'cen_id'),
        current_page=pulumi.get(__ret__, 'current_page'),
        firewall_id=pulumi.get(__ret__, 'firewall_id'),
        firewall_name=pulumi.get(__ret__, 'firewall_name'),
        firewall_switch_status=pulumi.get(__ret__, 'firewall_switch_status'),
        firewalls=pulumi.get(__ret__, 'firewalls'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        output_file=pulumi.get(__ret__, 'output_file'),
        page_number=pulumi.get(__ret__, 'page_number'),
        page_size=pulumi.get(__ret__, 'page_size'),
        region_no=pulumi.get(__ret__, 'region_no'),
        route_mode=pulumi.get(__ret__, 'route_mode'),
        transit_router_id=pulumi.get(__ret__, 'transit_router_id'))
def get_vpc_cen_tr_firewalls_output(cen_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                    current_page: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                                    firewall_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                    firewall_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                    firewall_switch_status: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                    ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                                    output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                    page_number: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                                    page_size: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                                    region_no: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                    route_mode: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                    transit_router_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetVpcCenTrFirewallsResult]:
    """
    This data source provides Cloud Firewall Vpc Cen Tr Firewall available to the user.[What is Vpc Cen Tr Firewall](https://next.api.alibabacloud.com/document/Cloudfw/2017-12-07/CreateTrFirewallV2)

    > **NOTE:** Available since v1.243.0.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    config = pulumi.Config()
    name = config.get("name")
    if name is None:
        name = "terraform-example"
    description = config.get("description")
    if description is None:
        description = "Created by Terraform"
    firewall_name = config.get("firewallName")
    if firewall_name is None:
        firewall_name = "tf-example"
    tr_attachment_master_cidr = config.get("trAttachmentMasterCidr")
    if tr_attachment_master_cidr is None:
        tr_attachment_master_cidr = "192.168.3.192/26"
    firewall_subnet_cidr = config.get("firewallSubnetCidr")
    if firewall_subnet_cidr is None:
        firewall_subnet_cidr = "192.168.3.0/25"
    region = config.get("region")
    if region is None:
        region = "cn-hangzhou"
    tr_attachment_slave_cidr = config.get("trAttachmentSlaveCidr")
    if tr_attachment_slave_cidr is None:
        tr_attachment_slave_cidr = "192.168.3.128/26"
    firewall_vpc_cidr = config.get("firewallVpcCidr")
    if firewall_vpc_cidr is None:
        firewall_vpc_cidr = "192.168.3.0/24"
    zone1 = config.get("zone1")
    if zone1 is None:
        zone1 = "cn-hangzhou-h"
    firewall_name_update = config.get("firewallNameUpdate")
    if firewall_name_update is None:
        firewall_name_update = "tf-example-1"
    zone2 = config.get("zone2")
    if zone2 is None:
        zone2 = "cn-hangzhou-i"
    cen = alicloud.cen.Instance("cen",
        description="terraform example",
        cen_instance_name="Cen_Terraform_example01")
    tr = alicloud.cen.TransitRouter("tr",
        support_multicast=False,
        transit_router_name="CEN_TR_Terraform",
        transit_router_description="tr-created-by-terraform",
        cen_id=cen.id)
    vpc1 = alicloud.vpc.Network("vpc1",
        description="created by terraform",
        cidr_block="192.168.1.0/24",
        vpc_name="vpc1-Terraform")
    vpc1vsw1 = alicloud.vpc.Switch("vpc1vsw1",
        cidr_block="192.168.1.0/25",
        vswitch_name="vpc1-vsw1",
        vpc_id=vpc1.id,
        zone_id=zone1)
    vpc1vsw2 = alicloud.vpc.Switch("vpc1vsw2",
        vpc_id=vpc1.id,
        cidr_block="192.168.1.128/26",
        vswitch_name="vpc1-vsw2",
        zone_id=zone2)
    vpc2 = alicloud.vpc.Network("vpc2",
        description="created by terraform",
        cidr_block="192.168.2.0/24",
        vpc_name="vpc2-Terraform")
    vpc2vsw1 = alicloud.vpc.Switch("vpc2vsw1",
        cidr_block="192.168.2.0/25",
        vswitch_name="vpc2-vsw1",
        vpc_id=vpc2.id,
        zone_id=zone1)
    vpc2vsw2 = alicloud.vpc.Switch("vpc2vsw2",
        cidr_block="192.168.2.128/26",
        vswitch_name="vpc2-vsw2",
        vpc_id=vpc2.id,
        zone_id=zone2)
    tr_vpc1 = alicloud.cen.TransitRouterVpcAttachment("tr-vpc1",
        auto_publish_route_enabled=False,
        zone_mappings=[
            {
                "vswitch_id": vpc1vsw1.id,
                "zone_id": vpc1vsw1.zone_id,
            },
            {
                "zone_id": vpc1vsw2.zone_id,
                "vswitch_id": vpc1vsw2.id,
            },
        ],
        vpc_id=vpc1.id,
        cen_id=cen.id)
    tr_vpc2 = alicloud.cen.TransitRouterVpcAttachment("tr-vpc2",
        auto_publish_route_enabled=False,
        vpc_id=vpc2.id,
        zone_mappings=[
            {
                "vswitch_id": vpc2vsw1.id,
                "zone_id": vpc2vsw1.zone_id,
            },
            {
                "vswitch_id": vpc2vsw2.id,
                "zone_id": vpc2vsw2.zone_id,
            },
        ],
        cen_id=cen.id)
    default_vpc_cen_tr_firewall = alicloud.cloudfirewall.VpcCenTrFirewall("default",
        firewall_description="VpcCenTrFirewall created by terraform",
        region_no=region,
        route_mode="managed",
        cen_id=cen.id,
        firewall_vpc_cidr=firewall_vpc_cidr,
        transit_router_id=tr.transit_router_id,
        tr_attachment_master_cidr=tr_attachment_master_cidr,
        firewall_name=firewall_name,
        firewall_subnet_cidr=firewall_subnet_cidr,
        tr_attachment_slave_cidr=tr_attachment_slave_cidr)
    default = alicloud.cloudfirewall.get_vpc_cen_tr_firewalls_output(ids=[default_vpc_cen_tr_firewall.id],
        cen_id=cen.id,
        firewall_name=firewall_name,
        region_no=region,
        route_mode="managed",
        transit_router_id=tr.transit_router_id)
    pulumi.export("alicloudCloudFirewallVpcCenTrFirewallExampleId", default.firewalls[0].id)
    ```


    :param _builtins.str cen_id: The ID of the CEN instance.
    :param _builtins.int current_page: The page number of the pagination query. The default value is 1.
    :param _builtins.str firewall_id: Firewall ID
    :param _builtins.str firewall_name: The name of Cloud Firewall.
    :param _builtins.str firewall_switch_status: The status of the VPC boundary firewall. Value:-**opened**: opened-**closed**: closed-**notconfigured**: indicates that the VPC boundary firewall has not been configured yet.-**configured**: indicates that the VPC boundary firewall has been configured.-**creating**: indicates that a VPC boundary firewall is being created.-**opening**: indicates that the VPC border firewall is being enabled.-**deleting**: indicates that the VPC boundary firewall is being deleted.> If this parameter is not set, the VPC boundary firewall in all states is queried.
    :param Sequence[_builtins.str] ids: A list of Vpc Cen Tr Firewall IDs.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.int page_number: Current page number.
    :param _builtins.int page_size: The maximum number of pieces of data per page that are displayed during a paged query. The default value is 10.
    :param _builtins.str region_no: The region ID of the transit router instance.
    :param _builtins.str route_mode: The routing pattern. Value: managed: indicates automatic mode
    :param _builtins.str transit_router_id: The ID of the transit router instance.
    """
    __args__ = dict()
    __args__['cenId'] = cen_id
    __args__['currentPage'] = current_page
    __args__['firewallId'] = firewall_id
    __args__['firewallName'] = firewall_name
    __args__['firewallSwitchStatus'] = firewall_switch_status
    __args__['ids'] = ids
    __args__['outputFile'] = output_file
    __args__['pageNumber'] = page_number
    __args__['pageSize'] = page_size
    __args__['regionNo'] = region_no
    __args__['routeMode'] = route_mode
    __args__['transitRouterId'] = transit_router_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:cloudfirewall/getVpcCenTrFirewalls:getVpcCenTrFirewalls', __args__, opts=opts, typ=GetVpcCenTrFirewallsResult)
    return __ret__.apply(lambda __response__: GetVpcCenTrFirewallsResult(
        cen_id=pulumi.get(__response__, 'cen_id'),
        current_page=pulumi.get(__response__, 'current_page'),
        firewall_id=pulumi.get(__response__, 'firewall_id'),
        firewall_name=pulumi.get(__response__, 'firewall_name'),
        firewall_switch_status=pulumi.get(__response__, 'firewall_switch_status'),
        firewalls=pulumi.get(__response__, 'firewalls'),
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        output_file=pulumi.get(__response__, 'output_file'),
        page_number=pulumi.get(__response__, 'page_number'),
        page_size=pulumi.get(__response__, 'page_size'),
        region_no=pulumi.get(__response__, 'region_no'),
        route_mode=pulumi.get(__response__, 'route_mode'),
        transit_router_id=pulumi.get(__response__, 'transit_router_id')))
