# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['InstanceArgs', 'Instance']

@pulumi.input_type
class InstanceArgs:
    def __init__(__self__, *,
                 payment_type: pulumi.Input[_builtins.str],
                 account_number: Optional[pulumi.Input[_builtins.int]] = None,
                 band_width: Optional[pulumi.Input[_builtins.int]] = None,
                 cfw_account: Optional[pulumi.Input[_builtins.bool]] = None,
                 cfw_log: Optional[pulumi.Input[_builtins.bool]] = None,
                 cfw_log_storage: Optional[pulumi.Input[_builtins.int]] = None,
                 fw_vpc_number: Optional[pulumi.Input[_builtins.int]] = None,
                 instance_count: Optional[pulumi.Input[_builtins.int]] = None,
                 ip_number: Optional[pulumi.Input[_builtins.int]] = None,
                 logistics: Optional[pulumi.Input[_builtins.str]] = None,
                 modify_type: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 renew_period: Optional[pulumi.Input[_builtins.int]] = None,
                 renewal_duration: Optional[pulumi.Input[_builtins.int]] = None,
                 renewal_duration_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 renewal_status: Optional[pulumi.Input[_builtins.str]] = None,
                 spec: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Instance resource.
        :param pulumi.Input[_builtins.str] payment_type: The payment type of the resource. Valid values: `Subscription`, `PayAsYouGo`. **NOTE:** From version 1.220.0, `payment_type` can be set to `PayAsYouGo`.
        :param pulumi.Input[_builtins.int] account_number: The number of multi account. It will be ignored when `cfw_account = false`.
        :param pulumi.Input[_builtins.int] band_width: Public network processing capability. Valid values: 10 to 15000. Unit: Mbps.
        :param pulumi.Input[_builtins.bool] cfw_account: Whether to use multi-account. Valid values: `true`, `false`.
        :param pulumi.Input[_builtins.bool] cfw_log: Whether to use log audit. Valid values: `true`, `false`. **NOTE:** From version 1.232.0, When `payment_type` is set to `PayAsYouGo`, `cfw_log` can only be set to `true`, `cfw_log` cannot be modified to `false`.
        :param pulumi.Input[_builtins.int] cfw_log_storage: The log storage capacity. **NOTE:** From version 1.232.0, When `payment_type` is set to `PayAsYouGo`, or `cfw_log` is set to `false`, `cfw_log_storage` will be ignored.
        :param pulumi.Input[_builtins.int] fw_vpc_number: The number of protected VPCs. It will be ignored when `spec = "premium_version"`. Valid values between 2 and 500.
        :param pulumi.Input[_builtins.int] instance_count: The number of assets.
        :param pulumi.Input[_builtins.int] ip_number: The number of public IPs that can be protected. Valid values: 20 to 4000.
        :param pulumi.Input[_builtins.str] logistics: The logistics.
        :param pulumi.Input[_builtins.str] modify_type: The type of modification. Valid values: `Upgrade`, `Downgrade`. **NOTE:** The `modify_type` is required when you execute an update operation.
        :param pulumi.Input[_builtins.int] period: The prepaid period. Valid values: `1`, `3`, `6`, `12`, `24`, `36`. **NOTE:** 1 and 3 available since 1.204.1. If `payment_type` is set to `Subscription`, `period` is required. Otherwise, it will be ignored.
        :param pulumi.Input[_builtins.int] renew_period: Automatic renewal period. Attribute `renew_period` has been deprecated since 1.209.1. Using `renewal_duration` instead.
        :param pulumi.Input[_builtins.int] renewal_duration: Auto-Renewal Duration. It is required under the condition that `renewal_status` is `AutoRenewal`. Valid values: `1`, `2`, `3`, `6`, `12`.
               **NOTE:** `renewal_duration` takes effect only if `payment_type` is set to `Subscription`, and `renewal_status` is set to `AutoRenewal`.
        :param pulumi.Input[_builtins.str] renewal_duration_unit: Auto-Renewal Cycle Unit Values Include: Month: Month. Year: Years. Valid values: `Month`, `Year`.
        :param pulumi.Input[_builtins.str] renewal_status: Whether to renew an instance automatically or not. Default value: `ManualRenewal`.
               - `AutoRenewal`: Auto renewal.
               - `ManualRenewal`: Manual renewal.
               - `NotRenewal`: No renewal any longer. After you specify this value, Alibaba Cloud stop sending notification of instance expiry, and only gives a brief reminder on the third day before the instance expiry.
               **NOTE:** `renewal_status` takes effect only if `payment_type` is set to `Subscription`.
        :param pulumi.Input[_builtins.str] spec: Current version. Valid values: `premium_version`, `enterprise_version`,`ultimate_version`.
        """
        pulumi.set(__self__, "payment_type", payment_type)
        if account_number is not None:
            pulumi.set(__self__, "account_number", account_number)
        if band_width is not None:
            pulumi.set(__self__, "band_width", band_width)
        if cfw_account is not None:
            pulumi.set(__self__, "cfw_account", cfw_account)
        if cfw_log is not None:
            pulumi.set(__self__, "cfw_log", cfw_log)
        if cfw_log_storage is not None:
            pulumi.set(__self__, "cfw_log_storage", cfw_log_storage)
        if fw_vpc_number is not None:
            pulumi.set(__self__, "fw_vpc_number", fw_vpc_number)
        if instance_count is not None:
            pulumi.set(__self__, "instance_count", instance_count)
        if ip_number is not None:
            pulumi.set(__self__, "ip_number", ip_number)
        if logistics is not None:
            pulumi.set(__self__, "logistics", logistics)
        if modify_type is not None:
            pulumi.set(__self__, "modify_type", modify_type)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if renew_period is not None:
            warnings.warn("""Attribute 'renew_period' has been deprecated since 1.209.1. Using 'renewal_duration' instead.""", DeprecationWarning)
            pulumi.log.warn("""renew_period is deprecated: Attribute 'renew_period' has been deprecated since 1.209.1. Using 'renewal_duration' instead.""")
        if renew_period is not None:
            pulumi.set(__self__, "renew_period", renew_period)
        if renewal_duration is not None:
            pulumi.set(__self__, "renewal_duration", renewal_duration)
        if renewal_duration_unit is not None:
            pulumi.set(__self__, "renewal_duration_unit", renewal_duration_unit)
        if renewal_status is not None:
            pulumi.set(__self__, "renewal_status", renewal_status)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> pulumi.Input[_builtins.str]:
        """
        The payment type of the resource. Valid values: `Subscription`, `PayAsYouGo`. **NOTE:** From version 1.220.0, `payment_type` can be set to `PayAsYouGo`.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "payment_type", value)

    @_builtins.property
    @pulumi.getter(name="accountNumber")
    def account_number(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of multi account. It will be ignored when `cfw_account = false`.
        """
        return pulumi.get(self, "account_number")

    @account_number.setter
    def account_number(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "account_number", value)

    @_builtins.property
    @pulumi.getter(name="bandWidth")
    def band_width(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Public network processing capability. Valid values: 10 to 15000. Unit: Mbps.
        """
        return pulumi.get(self, "band_width")

    @band_width.setter
    def band_width(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "band_width", value)

    @_builtins.property
    @pulumi.getter(name="cfwAccount")
    def cfw_account(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to use multi-account. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "cfw_account")

    @cfw_account.setter
    def cfw_account(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "cfw_account", value)

    @_builtins.property
    @pulumi.getter(name="cfwLog")
    def cfw_log(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to use log audit. Valid values: `true`, `false`. **NOTE:** From version 1.232.0, When `payment_type` is set to `PayAsYouGo`, `cfw_log` can only be set to `true`, `cfw_log` cannot be modified to `false`.
        """
        return pulumi.get(self, "cfw_log")

    @cfw_log.setter
    def cfw_log(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "cfw_log", value)

    @_builtins.property
    @pulumi.getter(name="cfwLogStorage")
    def cfw_log_storage(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The log storage capacity. **NOTE:** From version 1.232.0, When `payment_type` is set to `PayAsYouGo`, or `cfw_log` is set to `false`, `cfw_log_storage` will be ignored.
        """
        return pulumi.get(self, "cfw_log_storage")

    @cfw_log_storage.setter
    def cfw_log_storage(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cfw_log_storage", value)

    @_builtins.property
    @pulumi.getter(name="fwVpcNumber")
    def fw_vpc_number(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of protected VPCs. It will be ignored when `spec = "premium_version"`. Valid values between 2 and 500.
        """
        return pulumi.get(self, "fw_vpc_number")

    @fw_vpc_number.setter
    def fw_vpc_number(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "fw_vpc_number", value)

    @_builtins.property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of assets.
        """
        return pulumi.get(self, "instance_count")

    @instance_count.setter
    def instance_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "instance_count", value)

    @_builtins.property
    @pulumi.getter(name="ipNumber")
    def ip_number(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of public IPs that can be protected. Valid values: 20 to 4000.
        """
        return pulumi.get(self, "ip_number")

    @ip_number.setter
    def ip_number(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ip_number", value)

    @_builtins.property
    @pulumi.getter
    def logistics(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The logistics.
        """
        return pulumi.get(self, "logistics")

    @logistics.setter
    def logistics(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "logistics", value)

    @_builtins.property
    @pulumi.getter(name="modifyType")
    def modify_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of modification. Valid values: `Upgrade`, `Downgrade`. **NOTE:** The `modify_type` is required when you execute an update operation.
        """
        return pulumi.get(self, "modify_type")

    @modify_type.setter
    def modify_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "modify_type", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The prepaid period. Valid values: `1`, `3`, `6`, `12`, `24`, `36`. **NOTE:** 1 and 3 available since 1.204.1. If `payment_type` is set to `Subscription`, `period` is required. Otherwise, it will be ignored.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="renewPeriod")
    @_utilities.deprecated("""Attribute 'renew_period' has been deprecated since 1.209.1. Using 'renewal_duration' instead.""")
    def renew_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Automatic renewal period. Attribute `renew_period` has been deprecated since 1.209.1. Using `renewal_duration` instead.
        """
        return pulumi.get(self, "renew_period")

    @renew_period.setter
    def renew_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "renew_period", value)

    @_builtins.property
    @pulumi.getter(name="renewalDuration")
    def renewal_duration(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Auto-Renewal Duration. It is required under the condition that `renewal_status` is `AutoRenewal`. Valid values: `1`, `2`, `3`, `6`, `12`.
        **NOTE:** `renewal_duration` takes effect only if `payment_type` is set to `Subscription`, and `renewal_status` is set to `AutoRenewal`.
        """
        return pulumi.get(self, "renewal_duration")

    @renewal_duration.setter
    def renewal_duration(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "renewal_duration", value)

    @_builtins.property
    @pulumi.getter(name="renewalDurationUnit")
    def renewal_duration_unit(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Auto-Renewal Cycle Unit Values Include: Month: Month. Year: Years. Valid values: `Month`, `Year`.
        """
        return pulumi.get(self, "renewal_duration_unit")

    @renewal_duration_unit.setter
    def renewal_duration_unit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "renewal_duration_unit", value)

    @_builtins.property
    @pulumi.getter(name="renewalStatus")
    def renewal_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether to renew an instance automatically or not. Default value: `ManualRenewal`.
        - `AutoRenewal`: Auto renewal.
        - `ManualRenewal`: Manual renewal.
        - `NotRenewal`: No renewal any longer. After you specify this value, Alibaba Cloud stop sending notification of instance expiry, and only gives a brief reminder on the third day before the instance expiry.
        **NOTE:** `renewal_status` takes effect only if `payment_type` is set to `Subscription`.
        """
        return pulumi.get(self, "renewal_status")

    @renewal_status.setter
    def renewal_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "renewal_status", value)

    @_builtins.property
    @pulumi.getter
    def spec(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Current version. Valid values: `premium_version`, `enterprise_version`,`ultimate_version`.
        """
        return pulumi.get(self, "spec")

    @spec.setter
    def spec(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "spec", value)


@pulumi.input_type
class _InstanceState:
    def __init__(__self__, *,
                 account_number: Optional[pulumi.Input[_builtins.int]] = None,
                 band_width: Optional[pulumi.Input[_builtins.int]] = None,
                 cfw_account: Optional[pulumi.Input[_builtins.bool]] = None,
                 cfw_log: Optional[pulumi.Input[_builtins.bool]] = None,
                 cfw_log_storage: Optional[pulumi.Input[_builtins.int]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 end_time: Optional[pulumi.Input[_builtins.str]] = None,
                 fw_vpc_number: Optional[pulumi.Input[_builtins.int]] = None,
                 instance_count: Optional[pulumi.Input[_builtins.int]] = None,
                 ip_number: Optional[pulumi.Input[_builtins.int]] = None,
                 logistics: Optional[pulumi.Input[_builtins.str]] = None,
                 modify_type: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 release_time: Optional[pulumi.Input[_builtins.str]] = None,
                 renew_period: Optional[pulumi.Input[_builtins.int]] = None,
                 renewal_duration: Optional[pulumi.Input[_builtins.int]] = None,
                 renewal_duration_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 renewal_status: Optional[pulumi.Input[_builtins.str]] = None,
                 spec: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 user_status: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering Instance resources.
        :param pulumi.Input[_builtins.int] account_number: The number of multi account. It will be ignored when `cfw_account = false`.
        :param pulumi.Input[_builtins.int] band_width: Public network processing capability. Valid values: 10 to 15000. Unit: Mbps.
        :param pulumi.Input[_builtins.bool] cfw_account: Whether to use multi-account. Valid values: `true`, `false`.
        :param pulumi.Input[_builtins.bool] cfw_log: Whether to use log audit. Valid values: `true`, `false`. **NOTE:** From version 1.232.0, When `payment_type` is set to `PayAsYouGo`, `cfw_log` can only be set to `true`, `cfw_log` cannot be modified to `false`.
        :param pulumi.Input[_builtins.int] cfw_log_storage: The log storage capacity. **NOTE:** From version 1.232.0, When `payment_type` is set to `PayAsYouGo`, or `cfw_log` is set to `false`, `cfw_log_storage` will be ignored.
        :param pulumi.Input[_builtins.str] create_time: The creation time.
        :param pulumi.Input[_builtins.str] end_time: The end time.
        :param pulumi.Input[_builtins.int] fw_vpc_number: The number of protected VPCs. It will be ignored when `spec = "premium_version"`. Valid values between 2 and 500.
        :param pulumi.Input[_builtins.int] instance_count: The number of assets.
        :param pulumi.Input[_builtins.int] ip_number: The number of public IPs that can be protected. Valid values: 20 to 4000.
        :param pulumi.Input[_builtins.str] logistics: The logistics.
        :param pulumi.Input[_builtins.str] modify_type: The type of modification. Valid values: `Upgrade`, `Downgrade`. **NOTE:** The `modify_type` is required when you execute an update operation.
        :param pulumi.Input[_builtins.str] payment_type: The payment type of the resource. Valid values: `Subscription`, `PayAsYouGo`. **NOTE:** From version 1.220.0, `payment_type` can be set to `PayAsYouGo`.
        :param pulumi.Input[_builtins.int] period: The prepaid period. Valid values: `1`, `3`, `6`, `12`, `24`, `36`. **NOTE:** 1 and 3 available since 1.204.1. If `payment_type` is set to `Subscription`, `period` is required. Otherwise, it will be ignored.
        :param pulumi.Input[_builtins.str] release_time: The release time.
        :param pulumi.Input[_builtins.int] renew_period: Automatic renewal period. Attribute `renew_period` has been deprecated since 1.209.1. Using `renewal_duration` instead.
        :param pulumi.Input[_builtins.int] renewal_duration: Auto-Renewal Duration. It is required under the condition that `renewal_status` is `AutoRenewal`. Valid values: `1`, `2`, `3`, `6`, `12`.
               **NOTE:** `renewal_duration` takes effect only if `payment_type` is set to `Subscription`, and `renewal_status` is set to `AutoRenewal`.
        :param pulumi.Input[_builtins.str] renewal_duration_unit: Auto-Renewal Cycle Unit Values Include: Month: Month. Year: Years. Valid values: `Month`, `Year`.
        :param pulumi.Input[_builtins.str] renewal_status: Whether to renew an instance automatically or not. Default value: `ManualRenewal`.
               - `AutoRenewal`: Auto renewal.
               - `ManualRenewal`: Manual renewal.
               - `NotRenewal`: No renewal any longer. After you specify this value, Alibaba Cloud stop sending notification of instance expiry, and only gives a brief reminder on the third day before the instance expiry.
               **NOTE:** `renewal_status` takes effect only if `payment_type` is set to `Subscription`.
        :param pulumi.Input[_builtins.str] spec: Current version. Valid values: `premium_version`, `enterprise_version`,`ultimate_version`.
        :param pulumi.Input[_builtins.str] status: The status of Cloud Firewall Instance.
        :param pulumi.Input[_builtins.bool] user_status: (Available since v1.232.0) The user status of Cloud Firewall Instance.
        """
        if account_number is not None:
            pulumi.set(__self__, "account_number", account_number)
        if band_width is not None:
            pulumi.set(__self__, "band_width", band_width)
        if cfw_account is not None:
            pulumi.set(__self__, "cfw_account", cfw_account)
        if cfw_log is not None:
            pulumi.set(__self__, "cfw_log", cfw_log)
        if cfw_log_storage is not None:
            pulumi.set(__self__, "cfw_log_storage", cfw_log_storage)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if fw_vpc_number is not None:
            pulumi.set(__self__, "fw_vpc_number", fw_vpc_number)
        if instance_count is not None:
            pulumi.set(__self__, "instance_count", instance_count)
        if ip_number is not None:
            pulumi.set(__self__, "ip_number", ip_number)
        if logistics is not None:
            pulumi.set(__self__, "logistics", logistics)
        if modify_type is not None:
            pulumi.set(__self__, "modify_type", modify_type)
        if payment_type is not None:
            pulumi.set(__self__, "payment_type", payment_type)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if release_time is not None:
            pulumi.set(__self__, "release_time", release_time)
        if renew_period is not None:
            warnings.warn("""Attribute 'renew_period' has been deprecated since 1.209.1. Using 'renewal_duration' instead.""", DeprecationWarning)
            pulumi.log.warn("""renew_period is deprecated: Attribute 'renew_period' has been deprecated since 1.209.1. Using 'renewal_duration' instead.""")
        if renew_period is not None:
            pulumi.set(__self__, "renew_period", renew_period)
        if renewal_duration is not None:
            pulumi.set(__self__, "renewal_duration", renewal_duration)
        if renewal_duration_unit is not None:
            pulumi.set(__self__, "renewal_duration_unit", renewal_duration_unit)
        if renewal_status is not None:
            pulumi.set(__self__, "renewal_status", renewal_status)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if user_status is not None:
            pulumi.set(__self__, "user_status", user_status)

    @_builtins.property
    @pulumi.getter(name="accountNumber")
    def account_number(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of multi account. It will be ignored when `cfw_account = false`.
        """
        return pulumi.get(self, "account_number")

    @account_number.setter
    def account_number(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "account_number", value)

    @_builtins.property
    @pulumi.getter(name="bandWidth")
    def band_width(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Public network processing capability. Valid values: 10 to 15000. Unit: Mbps.
        """
        return pulumi.get(self, "band_width")

    @band_width.setter
    def band_width(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "band_width", value)

    @_builtins.property
    @pulumi.getter(name="cfwAccount")
    def cfw_account(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to use multi-account. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "cfw_account")

    @cfw_account.setter
    def cfw_account(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "cfw_account", value)

    @_builtins.property
    @pulumi.getter(name="cfwLog")
    def cfw_log(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to use log audit. Valid values: `true`, `false`. **NOTE:** From version 1.232.0, When `payment_type` is set to `PayAsYouGo`, `cfw_log` can only be set to `true`, `cfw_log` cannot be modified to `false`.
        """
        return pulumi.get(self, "cfw_log")

    @cfw_log.setter
    def cfw_log(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "cfw_log", value)

    @_builtins.property
    @pulumi.getter(name="cfwLogStorage")
    def cfw_log_storage(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The log storage capacity. **NOTE:** From version 1.232.0, When `payment_type` is set to `PayAsYouGo`, or `cfw_log` is set to `false`, `cfw_log_storage` will be ignored.
        """
        return pulumi.get(self, "cfw_log_storage")

    @cfw_log_storage.setter
    def cfw_log_storage(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cfw_log_storage", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation time.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The end time.
        """
        return pulumi.get(self, "end_time")

    @end_time.setter
    def end_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "end_time", value)

    @_builtins.property
    @pulumi.getter(name="fwVpcNumber")
    def fw_vpc_number(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of protected VPCs. It will be ignored when `spec = "premium_version"`. Valid values between 2 and 500.
        """
        return pulumi.get(self, "fw_vpc_number")

    @fw_vpc_number.setter
    def fw_vpc_number(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "fw_vpc_number", value)

    @_builtins.property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of assets.
        """
        return pulumi.get(self, "instance_count")

    @instance_count.setter
    def instance_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "instance_count", value)

    @_builtins.property
    @pulumi.getter(name="ipNumber")
    def ip_number(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of public IPs that can be protected. Valid values: 20 to 4000.
        """
        return pulumi.get(self, "ip_number")

    @ip_number.setter
    def ip_number(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ip_number", value)

    @_builtins.property
    @pulumi.getter
    def logistics(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The logistics.
        """
        return pulumi.get(self, "logistics")

    @logistics.setter
    def logistics(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "logistics", value)

    @_builtins.property
    @pulumi.getter(name="modifyType")
    def modify_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of modification. Valid values: `Upgrade`, `Downgrade`. **NOTE:** The `modify_type` is required when you execute an update operation.
        """
        return pulumi.get(self, "modify_type")

    @modify_type.setter
    def modify_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "modify_type", value)

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The payment type of the resource. Valid values: `Subscription`, `PayAsYouGo`. **NOTE:** From version 1.220.0, `payment_type` can be set to `PayAsYouGo`.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "payment_type", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The prepaid period. Valid values: `1`, `3`, `6`, `12`, `24`, `36`. **NOTE:** 1 and 3 available since 1.204.1. If `payment_type` is set to `Subscription`, `period` is required. Otherwise, it will be ignored.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="releaseTime")
    def release_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The release time.
        """
        return pulumi.get(self, "release_time")

    @release_time.setter
    def release_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "release_time", value)

    @_builtins.property
    @pulumi.getter(name="renewPeriod")
    @_utilities.deprecated("""Attribute 'renew_period' has been deprecated since 1.209.1. Using 'renewal_duration' instead.""")
    def renew_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Automatic renewal period. Attribute `renew_period` has been deprecated since 1.209.1. Using `renewal_duration` instead.
        """
        return pulumi.get(self, "renew_period")

    @renew_period.setter
    def renew_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "renew_period", value)

    @_builtins.property
    @pulumi.getter(name="renewalDuration")
    def renewal_duration(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Auto-Renewal Duration. It is required under the condition that `renewal_status` is `AutoRenewal`. Valid values: `1`, `2`, `3`, `6`, `12`.
        **NOTE:** `renewal_duration` takes effect only if `payment_type` is set to `Subscription`, and `renewal_status` is set to `AutoRenewal`.
        """
        return pulumi.get(self, "renewal_duration")

    @renewal_duration.setter
    def renewal_duration(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "renewal_duration", value)

    @_builtins.property
    @pulumi.getter(name="renewalDurationUnit")
    def renewal_duration_unit(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Auto-Renewal Cycle Unit Values Include: Month: Month. Year: Years. Valid values: `Month`, `Year`.
        """
        return pulumi.get(self, "renewal_duration_unit")

    @renewal_duration_unit.setter
    def renewal_duration_unit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "renewal_duration_unit", value)

    @_builtins.property
    @pulumi.getter(name="renewalStatus")
    def renewal_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether to renew an instance automatically or not. Default value: `ManualRenewal`.
        - `AutoRenewal`: Auto renewal.
        - `ManualRenewal`: Manual renewal.
        - `NotRenewal`: No renewal any longer. After you specify this value, Alibaba Cloud stop sending notification of instance expiry, and only gives a brief reminder on the third day before the instance expiry.
        **NOTE:** `renewal_status` takes effect only if `payment_type` is set to `Subscription`.
        """
        return pulumi.get(self, "renewal_status")

    @renewal_status.setter
    def renewal_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "renewal_status", value)

    @_builtins.property
    @pulumi.getter
    def spec(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Current version. Valid values: `premium_version`, `enterprise_version`,`ultimate_version`.
        """
        return pulumi.get(self, "spec")

    @spec.setter
    def spec(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "spec", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of Cloud Firewall Instance.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="userStatus")
    def user_status(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Available since v1.232.0) The user status of Cloud Firewall Instance.
        """
        return pulumi.get(self, "user_status")

    @user_status.setter
    def user_status(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "user_status", value)


@pulumi.type_token("alicloud:cloudfirewall/instance:Instance")
class Instance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_number: Optional[pulumi.Input[_builtins.int]] = None,
                 band_width: Optional[pulumi.Input[_builtins.int]] = None,
                 cfw_account: Optional[pulumi.Input[_builtins.bool]] = None,
                 cfw_log: Optional[pulumi.Input[_builtins.bool]] = None,
                 cfw_log_storage: Optional[pulumi.Input[_builtins.int]] = None,
                 fw_vpc_number: Optional[pulumi.Input[_builtins.int]] = None,
                 instance_count: Optional[pulumi.Input[_builtins.int]] = None,
                 ip_number: Optional[pulumi.Input[_builtins.int]] = None,
                 logistics: Optional[pulumi.Input[_builtins.str]] = None,
                 modify_type: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 renew_period: Optional[pulumi.Input[_builtins.int]] = None,
                 renewal_duration: Optional[pulumi.Input[_builtins.int]] = None,
                 renewal_duration_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 renewal_status: Optional[pulumi.Input[_builtins.str]] = None,
                 spec: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Cloud Firewall Instance resource.

        For information about Cloud Firewall Instance and how to use it, see [What is Instance](https://www.alibabacloud.com/help/en/product/90174.htm).

        > **NOTE:** Available since v1.139.0.

        ## Example Usage

        Basic Usage

        create a pay-as-you-go instance

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        pay_as_you_go = alicloud.cloudfirewall.Instance("PayAsYouGo", payment_type="PayAsYouGo")
        ```

        create a subscription instance

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        subscription = alicloud.cloudfirewall.Instance("Subscription",
            payment_type="Subscription",
            spec="premium_version",
            ip_number=20,
            band_width=10,
            cfw_log=False,
            period=1)
        ```

        ## Import

        Cloud Firewall Instance can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:cloudfirewall/instance:Instance example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] account_number: The number of multi account. It will be ignored when `cfw_account = false`.
        :param pulumi.Input[_builtins.int] band_width: Public network processing capability. Valid values: 10 to 15000. Unit: Mbps.
        :param pulumi.Input[_builtins.bool] cfw_account: Whether to use multi-account. Valid values: `true`, `false`.
        :param pulumi.Input[_builtins.bool] cfw_log: Whether to use log audit. Valid values: `true`, `false`. **NOTE:** From version 1.232.0, When `payment_type` is set to `PayAsYouGo`, `cfw_log` can only be set to `true`, `cfw_log` cannot be modified to `false`.
        :param pulumi.Input[_builtins.int] cfw_log_storage: The log storage capacity. **NOTE:** From version 1.232.0, When `payment_type` is set to `PayAsYouGo`, or `cfw_log` is set to `false`, `cfw_log_storage` will be ignored.
        :param pulumi.Input[_builtins.int] fw_vpc_number: The number of protected VPCs. It will be ignored when `spec = "premium_version"`. Valid values between 2 and 500.
        :param pulumi.Input[_builtins.int] instance_count: The number of assets.
        :param pulumi.Input[_builtins.int] ip_number: The number of public IPs that can be protected. Valid values: 20 to 4000.
        :param pulumi.Input[_builtins.str] logistics: The logistics.
        :param pulumi.Input[_builtins.str] modify_type: The type of modification. Valid values: `Upgrade`, `Downgrade`. **NOTE:** The `modify_type` is required when you execute an update operation.
        :param pulumi.Input[_builtins.str] payment_type: The payment type of the resource. Valid values: `Subscription`, `PayAsYouGo`. **NOTE:** From version 1.220.0, `payment_type` can be set to `PayAsYouGo`.
        :param pulumi.Input[_builtins.int] period: The prepaid period. Valid values: `1`, `3`, `6`, `12`, `24`, `36`. **NOTE:** 1 and 3 available since 1.204.1. If `payment_type` is set to `Subscription`, `period` is required. Otherwise, it will be ignored.
        :param pulumi.Input[_builtins.int] renew_period: Automatic renewal period. Attribute `renew_period` has been deprecated since 1.209.1. Using `renewal_duration` instead.
        :param pulumi.Input[_builtins.int] renewal_duration: Auto-Renewal Duration. It is required under the condition that `renewal_status` is `AutoRenewal`. Valid values: `1`, `2`, `3`, `6`, `12`.
               **NOTE:** `renewal_duration` takes effect only if `payment_type` is set to `Subscription`, and `renewal_status` is set to `AutoRenewal`.
        :param pulumi.Input[_builtins.str] renewal_duration_unit: Auto-Renewal Cycle Unit Values Include: Month: Month. Year: Years. Valid values: `Month`, `Year`.
        :param pulumi.Input[_builtins.str] renewal_status: Whether to renew an instance automatically or not. Default value: `ManualRenewal`.
               - `AutoRenewal`: Auto renewal.
               - `ManualRenewal`: Manual renewal.
               - `NotRenewal`: No renewal any longer. After you specify this value, Alibaba Cloud stop sending notification of instance expiry, and only gives a brief reminder on the third day before the instance expiry.
               **NOTE:** `renewal_status` takes effect only if `payment_type` is set to `Subscription`.
        :param pulumi.Input[_builtins.str] spec: Current version. Valid values: `premium_version`, `enterprise_version`,`ultimate_version`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Cloud Firewall Instance resource.

        For information about Cloud Firewall Instance and how to use it, see [What is Instance](https://www.alibabacloud.com/help/en/product/90174.htm).

        > **NOTE:** Available since v1.139.0.

        ## Example Usage

        Basic Usage

        create a pay-as-you-go instance

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        pay_as_you_go = alicloud.cloudfirewall.Instance("PayAsYouGo", payment_type="PayAsYouGo")
        ```

        create a subscription instance

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        subscription = alicloud.cloudfirewall.Instance("Subscription",
            payment_type="Subscription",
            spec="premium_version",
            ip_number=20,
            band_width=10,
            cfw_log=False,
            period=1)
        ```

        ## Import

        Cloud Firewall Instance can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:cloudfirewall/instance:Instance example <id>
        ```

        :param str resource_name: The name of the resource.
        :param InstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_number: Optional[pulumi.Input[_builtins.int]] = None,
                 band_width: Optional[pulumi.Input[_builtins.int]] = None,
                 cfw_account: Optional[pulumi.Input[_builtins.bool]] = None,
                 cfw_log: Optional[pulumi.Input[_builtins.bool]] = None,
                 cfw_log_storage: Optional[pulumi.Input[_builtins.int]] = None,
                 fw_vpc_number: Optional[pulumi.Input[_builtins.int]] = None,
                 instance_count: Optional[pulumi.Input[_builtins.int]] = None,
                 ip_number: Optional[pulumi.Input[_builtins.int]] = None,
                 logistics: Optional[pulumi.Input[_builtins.str]] = None,
                 modify_type: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 renew_period: Optional[pulumi.Input[_builtins.int]] = None,
                 renewal_duration: Optional[pulumi.Input[_builtins.int]] = None,
                 renewal_duration_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 renewal_status: Optional[pulumi.Input[_builtins.str]] = None,
                 spec: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceArgs.__new__(InstanceArgs)

            __props__.__dict__["account_number"] = account_number
            __props__.__dict__["band_width"] = band_width
            __props__.__dict__["cfw_account"] = cfw_account
            __props__.__dict__["cfw_log"] = cfw_log
            __props__.__dict__["cfw_log_storage"] = cfw_log_storage
            __props__.__dict__["fw_vpc_number"] = fw_vpc_number
            __props__.__dict__["instance_count"] = instance_count
            __props__.__dict__["ip_number"] = ip_number
            __props__.__dict__["logistics"] = logistics
            __props__.__dict__["modify_type"] = modify_type
            if payment_type is None and not opts.urn:
                raise TypeError("Missing required property 'payment_type'")
            __props__.__dict__["payment_type"] = payment_type
            __props__.__dict__["period"] = period
            __props__.__dict__["renew_period"] = renew_period
            __props__.__dict__["renewal_duration"] = renewal_duration
            __props__.__dict__["renewal_duration_unit"] = renewal_duration_unit
            __props__.__dict__["renewal_status"] = renewal_status
            __props__.__dict__["spec"] = spec
            __props__.__dict__["create_time"] = None
            __props__.__dict__["end_time"] = None
            __props__.__dict__["release_time"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["user_status"] = None
        super(Instance, __self__).__init__(
            'alicloud:cloudfirewall/instance:Instance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_number: Optional[pulumi.Input[_builtins.int]] = None,
            band_width: Optional[pulumi.Input[_builtins.int]] = None,
            cfw_account: Optional[pulumi.Input[_builtins.bool]] = None,
            cfw_log: Optional[pulumi.Input[_builtins.bool]] = None,
            cfw_log_storage: Optional[pulumi.Input[_builtins.int]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            end_time: Optional[pulumi.Input[_builtins.str]] = None,
            fw_vpc_number: Optional[pulumi.Input[_builtins.int]] = None,
            instance_count: Optional[pulumi.Input[_builtins.int]] = None,
            ip_number: Optional[pulumi.Input[_builtins.int]] = None,
            logistics: Optional[pulumi.Input[_builtins.str]] = None,
            modify_type: Optional[pulumi.Input[_builtins.str]] = None,
            payment_type: Optional[pulumi.Input[_builtins.str]] = None,
            period: Optional[pulumi.Input[_builtins.int]] = None,
            release_time: Optional[pulumi.Input[_builtins.str]] = None,
            renew_period: Optional[pulumi.Input[_builtins.int]] = None,
            renewal_duration: Optional[pulumi.Input[_builtins.int]] = None,
            renewal_duration_unit: Optional[pulumi.Input[_builtins.str]] = None,
            renewal_status: Optional[pulumi.Input[_builtins.str]] = None,
            spec: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            user_status: Optional[pulumi.Input[_builtins.bool]] = None) -> 'Instance':
        """
        Get an existing Instance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] account_number: The number of multi account. It will be ignored when `cfw_account = false`.
        :param pulumi.Input[_builtins.int] band_width: Public network processing capability. Valid values: 10 to 15000. Unit: Mbps.
        :param pulumi.Input[_builtins.bool] cfw_account: Whether to use multi-account. Valid values: `true`, `false`.
        :param pulumi.Input[_builtins.bool] cfw_log: Whether to use log audit. Valid values: `true`, `false`. **NOTE:** From version 1.232.0, When `payment_type` is set to `PayAsYouGo`, `cfw_log` can only be set to `true`, `cfw_log` cannot be modified to `false`.
        :param pulumi.Input[_builtins.int] cfw_log_storage: The log storage capacity. **NOTE:** From version 1.232.0, When `payment_type` is set to `PayAsYouGo`, or `cfw_log` is set to `false`, `cfw_log_storage` will be ignored.
        :param pulumi.Input[_builtins.str] create_time: The creation time.
        :param pulumi.Input[_builtins.str] end_time: The end time.
        :param pulumi.Input[_builtins.int] fw_vpc_number: The number of protected VPCs. It will be ignored when `spec = "premium_version"`. Valid values between 2 and 500.
        :param pulumi.Input[_builtins.int] instance_count: The number of assets.
        :param pulumi.Input[_builtins.int] ip_number: The number of public IPs that can be protected. Valid values: 20 to 4000.
        :param pulumi.Input[_builtins.str] logistics: The logistics.
        :param pulumi.Input[_builtins.str] modify_type: The type of modification. Valid values: `Upgrade`, `Downgrade`. **NOTE:** The `modify_type` is required when you execute an update operation.
        :param pulumi.Input[_builtins.str] payment_type: The payment type of the resource. Valid values: `Subscription`, `PayAsYouGo`. **NOTE:** From version 1.220.0, `payment_type` can be set to `PayAsYouGo`.
        :param pulumi.Input[_builtins.int] period: The prepaid period. Valid values: `1`, `3`, `6`, `12`, `24`, `36`. **NOTE:** 1 and 3 available since 1.204.1. If `payment_type` is set to `Subscription`, `period` is required. Otherwise, it will be ignored.
        :param pulumi.Input[_builtins.str] release_time: The release time.
        :param pulumi.Input[_builtins.int] renew_period: Automatic renewal period. Attribute `renew_period` has been deprecated since 1.209.1. Using `renewal_duration` instead.
        :param pulumi.Input[_builtins.int] renewal_duration: Auto-Renewal Duration. It is required under the condition that `renewal_status` is `AutoRenewal`. Valid values: `1`, `2`, `3`, `6`, `12`.
               **NOTE:** `renewal_duration` takes effect only if `payment_type` is set to `Subscription`, and `renewal_status` is set to `AutoRenewal`.
        :param pulumi.Input[_builtins.str] renewal_duration_unit: Auto-Renewal Cycle Unit Values Include: Month: Month. Year: Years. Valid values: `Month`, `Year`.
        :param pulumi.Input[_builtins.str] renewal_status: Whether to renew an instance automatically or not. Default value: `ManualRenewal`.
               - `AutoRenewal`: Auto renewal.
               - `ManualRenewal`: Manual renewal.
               - `NotRenewal`: No renewal any longer. After you specify this value, Alibaba Cloud stop sending notification of instance expiry, and only gives a brief reminder on the third day before the instance expiry.
               **NOTE:** `renewal_status` takes effect only if `payment_type` is set to `Subscription`.
        :param pulumi.Input[_builtins.str] spec: Current version. Valid values: `premium_version`, `enterprise_version`,`ultimate_version`.
        :param pulumi.Input[_builtins.str] status: The status of Cloud Firewall Instance.
        :param pulumi.Input[_builtins.bool] user_status: (Available since v1.232.0) The user status of Cloud Firewall Instance.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstanceState.__new__(_InstanceState)

        __props__.__dict__["account_number"] = account_number
        __props__.__dict__["band_width"] = band_width
        __props__.__dict__["cfw_account"] = cfw_account
        __props__.__dict__["cfw_log"] = cfw_log
        __props__.__dict__["cfw_log_storage"] = cfw_log_storage
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["end_time"] = end_time
        __props__.__dict__["fw_vpc_number"] = fw_vpc_number
        __props__.__dict__["instance_count"] = instance_count
        __props__.__dict__["ip_number"] = ip_number
        __props__.__dict__["logistics"] = logistics
        __props__.__dict__["modify_type"] = modify_type
        __props__.__dict__["payment_type"] = payment_type
        __props__.__dict__["period"] = period
        __props__.__dict__["release_time"] = release_time
        __props__.__dict__["renew_period"] = renew_period
        __props__.__dict__["renewal_duration"] = renewal_duration
        __props__.__dict__["renewal_duration_unit"] = renewal_duration_unit
        __props__.__dict__["renewal_status"] = renewal_status
        __props__.__dict__["spec"] = spec
        __props__.__dict__["status"] = status
        __props__.__dict__["user_status"] = user_status
        return Instance(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accountNumber")
    def account_number(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The number of multi account. It will be ignored when `cfw_account = false`.
        """
        return pulumi.get(self, "account_number")

    @_builtins.property
    @pulumi.getter(name="bandWidth")
    def band_width(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Public network processing capability. Valid values: 10 to 15000. Unit: Mbps.
        """
        return pulumi.get(self, "band_width")

    @_builtins.property
    @pulumi.getter(name="cfwAccount")
    def cfw_account(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to use multi-account. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "cfw_account")

    @_builtins.property
    @pulumi.getter(name="cfwLog")
    def cfw_log(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to use log audit. Valid values: `true`, `false`. **NOTE:** From version 1.232.0, When `payment_type` is set to `PayAsYouGo`, `cfw_log` can only be set to `true`, `cfw_log` cannot be modified to `false`.
        """
        return pulumi.get(self, "cfw_log")

    @_builtins.property
    @pulumi.getter(name="cfwLogStorage")
    def cfw_log_storage(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The log storage capacity. **NOTE:** From version 1.232.0, When `payment_type` is set to `PayAsYouGo`, or `cfw_log` is set to `false`, `cfw_log_storage` will be ignored.
        """
        return pulumi.get(self, "cfw_log_storage")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The creation time.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="endTime")
    def end_time(self) -> pulumi.Output[_builtins.str]:
        """
        The end time.
        """
        return pulumi.get(self, "end_time")

    @_builtins.property
    @pulumi.getter(name="fwVpcNumber")
    def fw_vpc_number(self) -> pulumi.Output[_builtins.int]:
        """
        The number of protected VPCs. It will be ignored when `spec = "premium_version"`. Valid values between 2 and 500.
        """
        return pulumi.get(self, "fw_vpc_number")

    @_builtins.property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The number of assets.
        """
        return pulumi.get(self, "instance_count")

    @_builtins.property
    @pulumi.getter(name="ipNumber")
    def ip_number(self) -> pulumi.Output[_builtins.int]:
        """
        The number of public IPs that can be protected. Valid values: 20 to 4000.
        """
        return pulumi.get(self, "ip_number")

    @_builtins.property
    @pulumi.getter
    def logistics(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The logistics.
        """
        return pulumi.get(self, "logistics")

    @_builtins.property
    @pulumi.getter(name="modifyType")
    def modify_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The type of modification. Valid values: `Upgrade`, `Downgrade`. **NOTE:** The `modify_type` is required when you execute an update operation.
        """
        return pulumi.get(self, "modify_type")

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> pulumi.Output[_builtins.str]:
        """
        The payment type of the resource. Valid values: `Subscription`, `PayAsYouGo`. **NOTE:** From version 1.220.0, `payment_type` can be set to `PayAsYouGo`.
        """
        return pulumi.get(self, "payment_type")

    @_builtins.property
    @pulumi.getter
    def period(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The prepaid period. Valid values: `1`, `3`, `6`, `12`, `24`, `36`. **NOTE:** 1 and 3 available since 1.204.1. If `payment_type` is set to `Subscription`, `period` is required. Otherwise, it will be ignored.
        """
        return pulumi.get(self, "period")

    @_builtins.property
    @pulumi.getter(name="releaseTime")
    def release_time(self) -> pulumi.Output[_builtins.str]:
        """
        The release time.
        """
        return pulumi.get(self, "release_time")

    @_builtins.property
    @pulumi.getter(name="renewPeriod")
    @_utilities.deprecated("""Attribute 'renew_period' has been deprecated since 1.209.1. Using 'renewal_duration' instead.""")
    def renew_period(self) -> pulumi.Output[_builtins.int]:
        """
        Automatic renewal period. Attribute `renew_period` has been deprecated since 1.209.1. Using `renewal_duration` instead.
        """
        return pulumi.get(self, "renew_period")

    @_builtins.property
    @pulumi.getter(name="renewalDuration")
    def renewal_duration(self) -> pulumi.Output[_builtins.int]:
        """
        Auto-Renewal Duration. It is required under the condition that `renewal_status` is `AutoRenewal`. Valid values: `1`, `2`, `3`, `6`, `12`.
        **NOTE:** `renewal_duration` takes effect only if `payment_type` is set to `Subscription`, and `renewal_status` is set to `AutoRenewal`.
        """
        return pulumi.get(self, "renewal_duration")

    @_builtins.property
    @pulumi.getter(name="renewalDurationUnit")
    def renewal_duration_unit(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Auto-Renewal Cycle Unit Values Include: Month: Month. Year: Years. Valid values: `Month`, `Year`.
        """
        return pulumi.get(self, "renewal_duration_unit")

    @_builtins.property
    @pulumi.getter(name="renewalStatus")
    def renewal_status(self) -> pulumi.Output[_builtins.str]:
        """
        Whether to renew an instance automatically or not. Default value: `ManualRenewal`.
        - `AutoRenewal`: Auto renewal.
        - `ManualRenewal`: Manual renewal.
        - `NotRenewal`: No renewal any longer. After you specify this value, Alibaba Cloud stop sending notification of instance expiry, and only gives a brief reminder on the third day before the instance expiry.
        **NOTE:** `renewal_status` takes effect only if `payment_type` is set to `Subscription`.
        """
        return pulumi.get(self, "renewal_status")

    @_builtins.property
    @pulumi.getter
    def spec(self) -> pulumi.Output[_builtins.str]:
        """
        Current version. Valid values: `premium_version`, `enterprise_version`,`ultimate_version`.
        """
        return pulumi.get(self, "spec")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of Cloud Firewall Instance.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="userStatus")
    def user_status(self) -> pulumi.Output[_builtins.bool]:
        """
        (Available since v1.232.0) The user status of Cloud Firewall Instance.
        """
        return pulumi.get(self, "user_status")

