# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['GroupArgs', 'Group']

@pulumi.input_type
class GroupArgs:
    def __init__(__self__, *,
                 image_id: pulumi.Input[_builtins.str],
                 instance_group_spec: pulumi.Input[_builtins.str],
                 amount: Optional[pulumi.Input[_builtins.int]] = None,
                 auto_pay: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
                 charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 gpu_acceleration: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 number_of_instances: Optional[pulumi.Input[_builtins.int]] = None,
                 office_site_id: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Group resource.
        :param pulumi.Input[_builtins.str] image_id: The image ID.
        :param pulumi.Input[_builtins.str] instance_group_spec: Instance group specifications.
        :param pulumi.Input[_builtins.int] amount: The number of instance groups. The default value is 1 and the maximum value is 100.
        :param pulumi.Input[_builtins.bool] auto_pay: Whether to pay automatically. The default is false.
        :param pulumi.Input[_builtins.bool] auto_renew: Whether to enable automatic renewal. The default is false.
        :param pulumi.Input[_builtins.str] charge_type: The billing type.
        :param pulumi.Input[_builtins.bool] gpu_acceleration: Whether to enable GPU acceleration. The default value is false.
               - true: On.
               - false: closed.
        :param pulumi.Input[_builtins.str] instance_group_name: The instance group name
               
               > **NOTE:** >
               
               > **NOTE:** - The instance group name must be no more than 30 characters in length. Start with an uppercase/lowercase letter or Chinese. It cannot start with http:// or https://. Only Chinese, English, numbers, half-width colons (:), underscores (_), periods (.), or hyphens (-) are supported.
        :param pulumi.Input[_builtins.int] number_of_instances: The number of instances in the instance group. The maximum value is 100.
        :param pulumi.Input[_builtins.str] office_site_id: The network ID.
               - Create a shared network instance: Network ID is optional. Enter the network ID whose type is **Shared Network** on the [cloud mobile phone console> Network](https://wya.wuying.aliyun.com/network) page. If the console does not have a shared network, you can fill it in. A shared network is automatically created when the instance group is created.
               - Create a VPC instance: the network ID is required. Enter the network ID of `VPC` on the [cloud mobile phone console> Network](https://wya.wuying.aliyun.com/network) page. If the console does not have a VPC network, you need to create a network first.
        :param pulumi.Input[_builtins.int] period: The duration of the resource purchase. The unit is specified by PeriodUnit.
        :param pulumi.Input[_builtins.str] period_unit: The unit of time for purchasing resources.
        :param pulumi.Input[_builtins.str] policy_group_id: The policy ID. You can query the list of policies by calling ListPolicyGroups.
        :param pulumi.Input[_builtins.str] vswitch_id: The vSwitch ID.
        """
        pulumi.set(__self__, "image_id", image_id)
        pulumi.set(__self__, "instance_group_spec", instance_group_spec)
        if amount is not None:
            pulumi.set(__self__, "amount", amount)
        if auto_pay is not None:
            pulumi.set(__self__, "auto_pay", auto_pay)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if charge_type is not None:
            pulumi.set(__self__, "charge_type", charge_type)
        if gpu_acceleration is not None:
            pulumi.set(__self__, "gpu_acceleration", gpu_acceleration)
        if instance_group_name is not None:
            pulumi.set(__self__, "instance_group_name", instance_group_name)
        if number_of_instances is not None:
            pulumi.set(__self__, "number_of_instances", number_of_instances)
        if office_site_id is not None:
            pulumi.set(__self__, "office_site_id", office_site_id)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)
        if policy_group_id is not None:
            pulumi.set(__self__, "policy_group_id", policy_group_id)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)

    @_builtins.property
    @pulumi.getter(name="imageId")
    def image_id(self) -> pulumi.Input[_builtins.str]:
        """
        The image ID.
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "image_id", value)

    @_builtins.property
    @pulumi.getter(name="instanceGroupSpec")
    def instance_group_spec(self) -> pulumi.Input[_builtins.str]:
        """
        Instance group specifications.
        """
        return pulumi.get(self, "instance_group_spec")

    @instance_group_spec.setter
    def instance_group_spec(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_group_spec", value)

    @_builtins.property
    @pulumi.getter
    def amount(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of instance groups. The default value is 1 and the maximum value is 100.
        """
        return pulumi.get(self, "amount")

    @amount.setter
    def amount(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "amount", value)

    @_builtins.property
    @pulumi.getter(name="autoPay")
    def auto_pay(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to pay automatically. The default is false.
        """
        return pulumi.get(self, "auto_pay")

    @auto_pay.setter
    def auto_pay(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_pay", value)

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable automatic renewal. The default is false.
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_renew", value)

    @_builtins.property
    @pulumi.getter(name="chargeType")
    def charge_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The billing type.
        """
        return pulumi.get(self, "charge_type")

    @charge_type.setter
    def charge_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "charge_type", value)

    @_builtins.property
    @pulumi.getter(name="gpuAcceleration")
    def gpu_acceleration(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable GPU acceleration. The default value is false.
        - true: On.
        - false: closed.
        """
        return pulumi.get(self, "gpu_acceleration")

    @gpu_acceleration.setter
    def gpu_acceleration(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "gpu_acceleration", value)

    @_builtins.property
    @pulumi.getter(name="instanceGroupName")
    def instance_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The instance group name

        > **NOTE:** >

        > **NOTE:** - The instance group name must be no more than 30 characters in length. Start with an uppercase/lowercase letter or Chinese. It cannot start with http:// or https://. Only Chinese, English, numbers, half-width colons (:), underscores (_), periods (.), or hyphens (-) are supported.
        """
        return pulumi.get(self, "instance_group_name")

    @instance_group_name.setter
    def instance_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_group_name", value)

    @_builtins.property
    @pulumi.getter(name="numberOfInstances")
    def number_of_instances(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of instances in the instance group. The maximum value is 100.
        """
        return pulumi.get(self, "number_of_instances")

    @number_of_instances.setter
    def number_of_instances(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "number_of_instances", value)

    @_builtins.property
    @pulumi.getter(name="officeSiteId")
    def office_site_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The network ID.
        - Create a shared network instance: Network ID is optional. Enter the network ID whose type is **Shared Network** on the [cloud mobile phone console> Network](https://wya.wuying.aliyun.com/network) page. If the console does not have a shared network, you can fill it in. A shared network is automatically created when the instance group is created.
        - Create a VPC instance: the network ID is required. Enter the network ID of `VPC` on the [cloud mobile phone console> Network](https://wya.wuying.aliyun.com/network) page. If the console does not have a VPC network, you need to create a network first.
        """
        return pulumi.get(self, "office_site_id")

    @office_site_id.setter
    def office_site_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "office_site_id", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The duration of the resource purchase. The unit is specified by PeriodUnit.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unit of time for purchasing resources.
        """
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "period_unit", value)

    @_builtins.property
    @pulumi.getter(name="policyGroupId")
    def policy_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The policy ID. You can query the list of policies by calling ListPolicyGroups.
        """
        return pulumi.get(self, "policy_group_id")

    @policy_group_id.setter
    def policy_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "policy_group_id", value)

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The vSwitch ID.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vswitch_id", value)


@pulumi.input_type
class _GroupState:
    def __init__(__self__, *,
                 amount: Optional[pulumi.Input[_builtins.int]] = None,
                 auto_pay: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
                 charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 gpu_acceleration: Optional[pulumi.Input[_builtins.bool]] = None,
                 image_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_group_spec: Optional[pulumi.Input[_builtins.str]] = None,
                 number_of_instances: Optional[pulumi.Input[_builtins.int]] = None,
                 office_site_id: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Group resources.
        :param pulumi.Input[_builtins.int] amount: The number of instance groups. The default value is 1 and the maximum value is 100.
        :param pulumi.Input[_builtins.bool] auto_pay: Whether to pay automatically. The default is false.
        :param pulumi.Input[_builtins.bool] auto_renew: Whether to enable automatic renewal. The default is false.
        :param pulumi.Input[_builtins.str] charge_type: The billing type.
        :param pulumi.Input[_builtins.bool] gpu_acceleration: Whether to enable GPU acceleration. The default value is false.
               - true: On.
               - false: closed.
        :param pulumi.Input[_builtins.str] image_id: The image ID.
        :param pulumi.Input[_builtins.str] instance_group_name: The instance group name
               
               > **NOTE:** >
               
               > **NOTE:** - The instance group name must be no more than 30 characters in length. Start with an uppercase/lowercase letter or Chinese. It cannot start with http:// or https://. Only Chinese, English, numbers, half-width colons (:), underscores (_), periods (.), or hyphens (-) are supported.
        :param pulumi.Input[_builtins.str] instance_group_spec: Instance group specifications.
        :param pulumi.Input[_builtins.int] number_of_instances: The number of instances in the instance group. The maximum value is 100.
        :param pulumi.Input[_builtins.str] office_site_id: The network ID.
               - Create a shared network instance: Network ID is optional. Enter the network ID whose type is **Shared Network** on the [cloud mobile phone console> Network](https://wya.wuying.aliyun.com/network) page. If the console does not have a shared network, you can fill it in. A shared network is automatically created when the instance group is created.
               - Create a VPC instance: the network ID is required. Enter the network ID of `VPC` on the [cloud mobile phone console> Network](https://wya.wuying.aliyun.com/network) page. If the console does not have a VPC network, you need to create a network first.
        :param pulumi.Input[_builtins.int] period: The duration of the resource purchase. The unit is specified by PeriodUnit.
        :param pulumi.Input[_builtins.str] period_unit: The unit of time for purchasing resources.
        :param pulumi.Input[_builtins.str] policy_group_id: The policy ID. You can query the list of policies by calling ListPolicyGroups.
        :param pulumi.Input[_builtins.str] status: Instance group status
        :param pulumi.Input[_builtins.str] vswitch_id: The vSwitch ID.
        """
        if amount is not None:
            pulumi.set(__self__, "amount", amount)
        if auto_pay is not None:
            pulumi.set(__self__, "auto_pay", auto_pay)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if charge_type is not None:
            pulumi.set(__self__, "charge_type", charge_type)
        if gpu_acceleration is not None:
            pulumi.set(__self__, "gpu_acceleration", gpu_acceleration)
        if image_id is not None:
            pulumi.set(__self__, "image_id", image_id)
        if instance_group_name is not None:
            pulumi.set(__self__, "instance_group_name", instance_group_name)
        if instance_group_spec is not None:
            pulumi.set(__self__, "instance_group_spec", instance_group_spec)
        if number_of_instances is not None:
            pulumi.set(__self__, "number_of_instances", number_of_instances)
        if office_site_id is not None:
            pulumi.set(__self__, "office_site_id", office_site_id)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)
        if policy_group_id is not None:
            pulumi.set(__self__, "policy_group_id", policy_group_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)

    @_builtins.property
    @pulumi.getter
    def amount(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of instance groups. The default value is 1 and the maximum value is 100.
        """
        return pulumi.get(self, "amount")

    @amount.setter
    def amount(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "amount", value)

    @_builtins.property
    @pulumi.getter(name="autoPay")
    def auto_pay(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to pay automatically. The default is false.
        """
        return pulumi.get(self, "auto_pay")

    @auto_pay.setter
    def auto_pay(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_pay", value)

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable automatic renewal. The default is false.
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_renew", value)

    @_builtins.property
    @pulumi.getter(name="chargeType")
    def charge_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The billing type.
        """
        return pulumi.get(self, "charge_type")

    @charge_type.setter
    def charge_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "charge_type", value)

    @_builtins.property
    @pulumi.getter(name="gpuAcceleration")
    def gpu_acceleration(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable GPU acceleration. The default value is false.
        - true: On.
        - false: closed.
        """
        return pulumi.get(self, "gpu_acceleration")

    @gpu_acceleration.setter
    def gpu_acceleration(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "gpu_acceleration", value)

    @_builtins.property
    @pulumi.getter(name="imageId")
    def image_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The image ID.
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "image_id", value)

    @_builtins.property
    @pulumi.getter(name="instanceGroupName")
    def instance_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The instance group name

        > **NOTE:** >

        > **NOTE:** - The instance group name must be no more than 30 characters in length. Start with an uppercase/lowercase letter or Chinese. It cannot start with http:// or https://. Only Chinese, English, numbers, half-width colons (:), underscores (_), periods (.), or hyphens (-) are supported.
        """
        return pulumi.get(self, "instance_group_name")

    @instance_group_name.setter
    def instance_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_group_name", value)

    @_builtins.property
    @pulumi.getter(name="instanceGroupSpec")
    def instance_group_spec(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Instance group specifications.
        """
        return pulumi.get(self, "instance_group_spec")

    @instance_group_spec.setter
    def instance_group_spec(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_group_spec", value)

    @_builtins.property
    @pulumi.getter(name="numberOfInstances")
    def number_of_instances(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of instances in the instance group. The maximum value is 100.
        """
        return pulumi.get(self, "number_of_instances")

    @number_of_instances.setter
    def number_of_instances(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "number_of_instances", value)

    @_builtins.property
    @pulumi.getter(name="officeSiteId")
    def office_site_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The network ID.
        - Create a shared network instance: Network ID is optional. Enter the network ID whose type is **Shared Network** on the [cloud mobile phone console> Network](https://wya.wuying.aliyun.com/network) page. If the console does not have a shared network, you can fill it in. A shared network is automatically created when the instance group is created.
        - Create a VPC instance: the network ID is required. Enter the network ID of `VPC` on the [cloud mobile phone console> Network](https://wya.wuying.aliyun.com/network) page. If the console does not have a VPC network, you need to create a network first.
        """
        return pulumi.get(self, "office_site_id")

    @office_site_id.setter
    def office_site_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "office_site_id", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The duration of the resource purchase. The unit is specified by PeriodUnit.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unit of time for purchasing resources.
        """
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "period_unit", value)

    @_builtins.property
    @pulumi.getter(name="policyGroupId")
    def policy_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The policy ID. You can query the list of policies by calling ListPolicyGroups.
        """
        return pulumi.get(self, "policy_group_id")

    @policy_group_id.setter
    def policy_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "policy_group_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Instance group status
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The vSwitch ID.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vswitch_id", value)


@pulumi.type_token("alicloud:cloudphoneinstance/group:Group")
class Group(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 amount: Optional[pulumi.Input[_builtins.int]] = None,
                 auto_pay: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
                 charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 gpu_acceleration: Optional[pulumi.Input[_builtins.bool]] = None,
                 image_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_group_spec: Optional[pulumi.Input[_builtins.str]] = None,
                 number_of_instances: Optional[pulumi.Input[_builtins.int]] = None,
                 office_site_id: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Cloud Phone Instance Group resource.

        For information about Cloud Phone Instance Group and how to use it, see [What is Instance Group](https://next.api.alibabacloud.com/document/eds-aic/2023-09-30/CreateAndroidInstanceGroup).

        > **NOTE:** Available since v1.243.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        region_id = config.get("regionId")
        if region_id is None:
            region_id = "cn-hangzhou"
        defaultj_z1gi0 = alicloud.cloudphone.Policy("defaultjZ1gi0",
            lock_resolution="off",
            resolution_width=720,
            camera_redirect="on",
            policy_group_name="defaultPolicyGroup",
            resolution_height=1280,
            clipboard="readwrite",
            net_redirect_policy={
                "net_redirect": "off",
                "custom_proxy": "off",
            })
        default_h2a5_ks = alicloud.eds.SimpleOfficeSite("defaultH2a5KS",
            office_site_name="InitOfficeSite",
            cidr_block="172.16.0.0/12")
        default = alicloud.cloudphoneinstance.Group("default",
            instance_group_spec="acp.basic.small",
            instance_group_name="AutoCreateGroupName",
            period=1,
            number_of_instances=1,
            charge_type="PostPaid",
            image_id="imgc-075cllfeuazh03tg9",
            period_unit="Hour",
            auto_renew=False,
            amount=1,
            auto_pay=False,
            gpu_acceleration=False,
            policy_group_id=defaultj_z1gi0.id,
            office_site_id=default_h2a5_ks.id)
        ```

        ## Import

        Cloud Phone Instance Group can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:cloudphoneinstance/group:Group example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] amount: The number of instance groups. The default value is 1 and the maximum value is 100.
        :param pulumi.Input[_builtins.bool] auto_pay: Whether to pay automatically. The default is false.
        :param pulumi.Input[_builtins.bool] auto_renew: Whether to enable automatic renewal. The default is false.
        :param pulumi.Input[_builtins.str] charge_type: The billing type.
        :param pulumi.Input[_builtins.bool] gpu_acceleration: Whether to enable GPU acceleration. The default value is false.
               - true: On.
               - false: closed.
        :param pulumi.Input[_builtins.str] image_id: The image ID.
        :param pulumi.Input[_builtins.str] instance_group_name: The instance group name
               
               > **NOTE:** >
               
               > **NOTE:** - The instance group name must be no more than 30 characters in length. Start with an uppercase/lowercase letter or Chinese. It cannot start with http:// or https://. Only Chinese, English, numbers, half-width colons (:), underscores (_), periods (.), or hyphens (-) are supported.
        :param pulumi.Input[_builtins.str] instance_group_spec: Instance group specifications.
        :param pulumi.Input[_builtins.int] number_of_instances: The number of instances in the instance group. The maximum value is 100.
        :param pulumi.Input[_builtins.str] office_site_id: The network ID.
               - Create a shared network instance: Network ID is optional. Enter the network ID whose type is **Shared Network** on the [cloud mobile phone console> Network](https://wya.wuying.aliyun.com/network) page. If the console does not have a shared network, you can fill it in. A shared network is automatically created when the instance group is created.
               - Create a VPC instance: the network ID is required. Enter the network ID of `VPC` on the [cloud mobile phone console> Network](https://wya.wuying.aliyun.com/network) page. If the console does not have a VPC network, you need to create a network first.
        :param pulumi.Input[_builtins.int] period: The duration of the resource purchase. The unit is specified by PeriodUnit.
        :param pulumi.Input[_builtins.str] period_unit: The unit of time for purchasing resources.
        :param pulumi.Input[_builtins.str] policy_group_id: The policy ID. You can query the list of policies by calling ListPolicyGroups.
        :param pulumi.Input[_builtins.str] vswitch_id: The vSwitch ID.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Cloud Phone Instance Group resource.

        For information about Cloud Phone Instance Group and how to use it, see [What is Instance Group](https://next.api.alibabacloud.com/document/eds-aic/2023-09-30/CreateAndroidInstanceGroup).

        > **NOTE:** Available since v1.243.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        region_id = config.get("regionId")
        if region_id is None:
            region_id = "cn-hangzhou"
        defaultj_z1gi0 = alicloud.cloudphone.Policy("defaultjZ1gi0",
            lock_resolution="off",
            resolution_width=720,
            camera_redirect="on",
            policy_group_name="defaultPolicyGroup",
            resolution_height=1280,
            clipboard="readwrite",
            net_redirect_policy={
                "net_redirect": "off",
                "custom_proxy": "off",
            })
        default_h2a5_ks = alicloud.eds.SimpleOfficeSite("defaultH2a5KS",
            office_site_name="InitOfficeSite",
            cidr_block="172.16.0.0/12")
        default = alicloud.cloudphoneinstance.Group("default",
            instance_group_spec="acp.basic.small",
            instance_group_name="AutoCreateGroupName",
            period=1,
            number_of_instances=1,
            charge_type="PostPaid",
            image_id="imgc-075cllfeuazh03tg9",
            period_unit="Hour",
            auto_renew=False,
            amount=1,
            auto_pay=False,
            gpu_acceleration=False,
            policy_group_id=defaultj_z1gi0.id,
            office_site_id=default_h2a5_ks.id)
        ```

        ## Import

        Cloud Phone Instance Group can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:cloudphoneinstance/group:Group example <id>
        ```

        :param str resource_name: The name of the resource.
        :param GroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 amount: Optional[pulumi.Input[_builtins.int]] = None,
                 auto_pay: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
                 charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 gpu_acceleration: Optional[pulumi.Input[_builtins.bool]] = None,
                 image_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_group_spec: Optional[pulumi.Input[_builtins.str]] = None,
                 number_of_instances: Optional[pulumi.Input[_builtins.int]] = None,
                 office_site_id: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GroupArgs.__new__(GroupArgs)

            __props__.__dict__["amount"] = amount
            __props__.__dict__["auto_pay"] = auto_pay
            __props__.__dict__["auto_renew"] = auto_renew
            __props__.__dict__["charge_type"] = charge_type
            __props__.__dict__["gpu_acceleration"] = gpu_acceleration
            if image_id is None and not opts.urn:
                raise TypeError("Missing required property 'image_id'")
            __props__.__dict__["image_id"] = image_id
            __props__.__dict__["instance_group_name"] = instance_group_name
            if instance_group_spec is None and not opts.urn:
                raise TypeError("Missing required property 'instance_group_spec'")
            __props__.__dict__["instance_group_spec"] = instance_group_spec
            __props__.__dict__["number_of_instances"] = number_of_instances
            __props__.__dict__["office_site_id"] = office_site_id
            __props__.__dict__["period"] = period
            __props__.__dict__["period_unit"] = period_unit
            __props__.__dict__["policy_group_id"] = policy_group_id
            __props__.__dict__["vswitch_id"] = vswitch_id
            __props__.__dict__["status"] = None
        super(Group, __self__).__init__(
            'alicloud:cloudphoneinstance/group:Group',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            amount: Optional[pulumi.Input[_builtins.int]] = None,
            auto_pay: Optional[pulumi.Input[_builtins.bool]] = None,
            auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
            charge_type: Optional[pulumi.Input[_builtins.str]] = None,
            gpu_acceleration: Optional[pulumi.Input[_builtins.bool]] = None,
            image_id: Optional[pulumi.Input[_builtins.str]] = None,
            instance_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            instance_group_spec: Optional[pulumi.Input[_builtins.str]] = None,
            number_of_instances: Optional[pulumi.Input[_builtins.int]] = None,
            office_site_id: Optional[pulumi.Input[_builtins.str]] = None,
            period: Optional[pulumi.Input[_builtins.int]] = None,
            period_unit: Optional[pulumi.Input[_builtins.str]] = None,
            policy_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            vswitch_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'Group':
        """
        Get an existing Group resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] amount: The number of instance groups. The default value is 1 and the maximum value is 100.
        :param pulumi.Input[_builtins.bool] auto_pay: Whether to pay automatically. The default is false.
        :param pulumi.Input[_builtins.bool] auto_renew: Whether to enable automatic renewal. The default is false.
        :param pulumi.Input[_builtins.str] charge_type: The billing type.
        :param pulumi.Input[_builtins.bool] gpu_acceleration: Whether to enable GPU acceleration. The default value is false.
               - true: On.
               - false: closed.
        :param pulumi.Input[_builtins.str] image_id: The image ID.
        :param pulumi.Input[_builtins.str] instance_group_name: The instance group name
               
               > **NOTE:** >
               
               > **NOTE:** - The instance group name must be no more than 30 characters in length. Start with an uppercase/lowercase letter or Chinese. It cannot start with http:// or https://. Only Chinese, English, numbers, half-width colons (:), underscores (_), periods (.), or hyphens (-) are supported.
        :param pulumi.Input[_builtins.str] instance_group_spec: Instance group specifications.
        :param pulumi.Input[_builtins.int] number_of_instances: The number of instances in the instance group. The maximum value is 100.
        :param pulumi.Input[_builtins.str] office_site_id: The network ID.
               - Create a shared network instance: Network ID is optional. Enter the network ID whose type is **Shared Network** on the [cloud mobile phone console> Network](https://wya.wuying.aliyun.com/network) page. If the console does not have a shared network, you can fill it in. A shared network is automatically created when the instance group is created.
               - Create a VPC instance: the network ID is required. Enter the network ID of `VPC` on the [cloud mobile phone console> Network](https://wya.wuying.aliyun.com/network) page. If the console does not have a VPC network, you need to create a network first.
        :param pulumi.Input[_builtins.int] period: The duration of the resource purchase. The unit is specified by PeriodUnit.
        :param pulumi.Input[_builtins.str] period_unit: The unit of time for purchasing resources.
        :param pulumi.Input[_builtins.str] policy_group_id: The policy ID. You can query the list of policies by calling ListPolicyGroups.
        :param pulumi.Input[_builtins.str] status: Instance group status
        :param pulumi.Input[_builtins.str] vswitch_id: The vSwitch ID.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GroupState.__new__(_GroupState)

        __props__.__dict__["amount"] = amount
        __props__.__dict__["auto_pay"] = auto_pay
        __props__.__dict__["auto_renew"] = auto_renew
        __props__.__dict__["charge_type"] = charge_type
        __props__.__dict__["gpu_acceleration"] = gpu_acceleration
        __props__.__dict__["image_id"] = image_id
        __props__.__dict__["instance_group_name"] = instance_group_name
        __props__.__dict__["instance_group_spec"] = instance_group_spec
        __props__.__dict__["number_of_instances"] = number_of_instances
        __props__.__dict__["office_site_id"] = office_site_id
        __props__.__dict__["period"] = period
        __props__.__dict__["period_unit"] = period_unit
        __props__.__dict__["policy_group_id"] = policy_group_id
        __props__.__dict__["status"] = status
        __props__.__dict__["vswitch_id"] = vswitch_id
        return Group(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def amount(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The number of instance groups. The default value is 1 and the maximum value is 100.
        """
        return pulumi.get(self, "amount")

    @_builtins.property
    @pulumi.getter(name="autoPay")
    def auto_pay(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to pay automatically. The default is false.
        """
        return pulumi.get(self, "auto_pay")

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to enable automatic renewal. The default is false.
        """
        return pulumi.get(self, "auto_renew")

    @_builtins.property
    @pulumi.getter(name="chargeType")
    def charge_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The billing type.
        """
        return pulumi.get(self, "charge_type")

    @_builtins.property
    @pulumi.getter(name="gpuAcceleration")
    def gpu_acceleration(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to enable GPU acceleration. The default value is false.
        - true: On.
        - false: closed.
        """
        return pulumi.get(self, "gpu_acceleration")

    @_builtins.property
    @pulumi.getter(name="imageId")
    def image_id(self) -> pulumi.Output[_builtins.str]:
        """
        The image ID.
        """
        return pulumi.get(self, "image_id")

    @_builtins.property
    @pulumi.getter(name="instanceGroupName")
    def instance_group_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The instance group name

        > **NOTE:** >

        > **NOTE:** - The instance group name must be no more than 30 characters in length. Start with an uppercase/lowercase letter or Chinese. It cannot start with http:// or https://. Only Chinese, English, numbers, half-width colons (:), underscores (_), periods (.), or hyphens (-) are supported.
        """
        return pulumi.get(self, "instance_group_name")

    @_builtins.property
    @pulumi.getter(name="instanceGroupSpec")
    def instance_group_spec(self) -> pulumi.Output[_builtins.str]:
        """
        Instance group specifications.
        """
        return pulumi.get(self, "instance_group_spec")

    @_builtins.property
    @pulumi.getter(name="numberOfInstances")
    def number_of_instances(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The number of instances in the instance group. The maximum value is 100.
        """
        return pulumi.get(self, "number_of_instances")

    @_builtins.property
    @pulumi.getter(name="officeSiteId")
    def office_site_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The network ID.
        - Create a shared network instance: Network ID is optional. Enter the network ID whose type is **Shared Network** on the [cloud mobile phone console> Network](https://wya.wuying.aliyun.com/network) page. If the console does not have a shared network, you can fill it in. A shared network is automatically created when the instance group is created.
        - Create a VPC instance: the network ID is required. Enter the network ID of `VPC` on the [cloud mobile phone console> Network](https://wya.wuying.aliyun.com/network) page. If the console does not have a VPC network, you need to create a network first.
        """
        return pulumi.get(self, "office_site_id")

    @_builtins.property
    @pulumi.getter
    def period(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The duration of the resource purchase. The unit is specified by PeriodUnit.
        """
        return pulumi.get(self, "period")

    @_builtins.property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The unit of time for purchasing resources.
        """
        return pulumi.get(self, "period_unit")

    @_builtins.property
    @pulumi.getter(name="policyGroupId")
    def policy_group_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The policy ID. You can query the list of policies by calling ListPolicyGroups.
        """
        return pulumi.get(self, "policy_group_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Instance group status
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The vSwitch ID.
        """
        return pulumi.get(self, "vswitch_id")

