# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetMetricRuleBlackListsResult',
    'AwaitableGetMetricRuleBlackListsResult',
    'get_metric_rule_black_lists',
    'get_metric_rule_black_lists_output',
]

@pulumi.output_type
class GetMetricRuleBlackListsResult:
    """
    A collection of values returned by getMetricRuleBlackLists.
    """
    def __init__(__self__, category=None, id=None, ids=None, lists=None, metric_rule_black_list_id=None, name_regex=None, names=None, namespace=None, order=None, output_file=None, page_number=None, page_size=None):
        if category and not isinstance(category, str):
            raise TypeError("Expected argument 'category' to be a str")
        pulumi.set(__self__, "category", category)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if lists and not isinstance(lists, list):
            raise TypeError("Expected argument 'lists' to be a list")
        pulumi.set(__self__, "lists", lists)
        if metric_rule_black_list_id and not isinstance(metric_rule_black_list_id, str):
            raise TypeError("Expected argument 'metric_rule_black_list_id' to be a str")
        pulumi.set(__self__, "metric_rule_black_list_id", metric_rule_black_list_id)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if namespace and not isinstance(namespace, str):
            raise TypeError("Expected argument 'namespace' to be a str")
        pulumi.set(__self__, "namespace", namespace)
        if order and not isinstance(order, int):
            raise TypeError("Expected argument 'order' to be a int")
        pulumi.set(__self__, "order", order)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if page_number and not isinstance(page_number, int):
            raise TypeError("Expected argument 'page_number' to be a int")
        pulumi.set(__self__, "page_number", page_number)
        if page_size and not isinstance(page_size, int):
            raise TypeError("Expected argument 'page_size' to be a int")
        pulumi.set(__self__, "page_size", page_size)

    @_builtins.property
    @pulumi.getter
    def category(self) -> Optional[_builtins.str]:
        """
        Cloud service classification. For example, Redis includes kvstore_standard, kvstore_sharding, and kvstore_splitrw.
        """
        return pulumi.get(self, "category")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        """
        A list of Metric Rule Black List IDs.
        """
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter
    def lists(self) -> Sequence['outputs.GetMetricRuleBlackListsListResult']:
        """
        A list of Metric Rule Black List Entries. Each element contains the following attributes:
        """
        return pulumi.get(self, "lists")

    @_builtins.property
    @pulumi.getter(name="metricRuleBlackListId")
    def metric_rule_black_list_id(self) -> Optional[_builtins.str]:
        """
        The first ID of the resource
        """
        return pulumi.get(self, "metric_rule_black_list_id")

    @_builtins.property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name_regex")

    @_builtins.property
    @pulumi.getter
    def names(self) -> Sequence[_builtins.str]:
        """
        A list of name of Metric Rule Black Lists.
        """
        return pulumi.get(self, "names")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[_builtins.str]:
        """
        The data namespace of the cloud service.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter
    def order(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "order")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")

    @_builtins.property
    @pulumi.getter(name="pageNumber")
    def page_number(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "page_number")

    @_builtins.property
    @pulumi.getter(name="pageSize")
    def page_size(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "page_size")


class AwaitableGetMetricRuleBlackListsResult(GetMetricRuleBlackListsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMetricRuleBlackListsResult(
            category=self.category,
            id=self.id,
            ids=self.ids,
            lists=self.lists,
            metric_rule_black_list_id=self.metric_rule_black_list_id,
            name_regex=self.name_regex,
            names=self.names,
            namespace=self.namespace,
            order=self.order,
            output_file=self.output_file,
            page_number=self.page_number,
            page_size=self.page_size)


def get_metric_rule_black_lists(category: Optional[_builtins.str] = None,
                                ids: Optional[Sequence[_builtins.str]] = None,
                                metric_rule_black_list_id: Optional[_builtins.str] = None,
                                name_regex: Optional[_builtins.str] = None,
                                namespace: Optional[_builtins.str] = None,
                                order: Optional[_builtins.int] = None,
                                output_file: Optional[_builtins.str] = None,
                                page_number: Optional[_builtins.int] = None,
                                page_size: Optional[_builtins.int] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMetricRuleBlackListsResult:
    """
    This data source provides Cloud Monitor Service Metric Rule Black List available to the user.[What is Metric Rule Black List](https://www.alibabacloud.com/help/en/cloudmonitor/latest/describemetricruleblacklist)

    > **NOTE:** Available in 1.194.0+

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    default = alicloud.cms.get_metric_rule_black_lists(ids=[default_alicloud_cms_metric_rule_black_lists["id"]],
        category="ecs",
        namespace="acs_ecs_dashboard")
    pulumi.export("alicloudCmsRuleBlackListExampleId", lists[0]["id"])
    ```


    :param _builtins.str category: Cloud service classification. For example, Redis includes kvstore_standard, kvstore_sharding, and kvstore_splitrw.
    :param Sequence[_builtins.str] ids: A list of Metric Rule Black List IDs.
    :param _builtins.str metric_rule_black_list_id: The first ID of the resource
    :param _builtins.str name_regex: A regex string to filter results by Group Metric Rule name.
    :param _builtins.str namespace: The data namespace of the cloud service.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    """
    __args__ = dict()
    __args__['category'] = category
    __args__['ids'] = ids
    __args__['metricRuleBlackListId'] = metric_rule_black_list_id
    __args__['nameRegex'] = name_regex
    __args__['namespace'] = namespace
    __args__['order'] = order
    __args__['outputFile'] = output_file
    __args__['pageNumber'] = page_number
    __args__['pageSize'] = page_size
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:cms/getMetricRuleBlackLists:getMetricRuleBlackLists', __args__, opts=opts, typ=GetMetricRuleBlackListsResult).value

    return AwaitableGetMetricRuleBlackListsResult(
        category=pulumi.get(__ret__, 'category'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        lists=pulumi.get(__ret__, 'lists'),
        metric_rule_black_list_id=pulumi.get(__ret__, 'metric_rule_black_list_id'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        names=pulumi.get(__ret__, 'names'),
        namespace=pulumi.get(__ret__, 'namespace'),
        order=pulumi.get(__ret__, 'order'),
        output_file=pulumi.get(__ret__, 'output_file'),
        page_number=pulumi.get(__ret__, 'page_number'),
        page_size=pulumi.get(__ret__, 'page_size'))
def get_metric_rule_black_lists_output(category: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                       ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                                       metric_rule_black_list_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                       name_regex: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                       namespace: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                       order: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                                       output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                       page_number: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                                       page_size: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetMetricRuleBlackListsResult]:
    """
    This data source provides Cloud Monitor Service Metric Rule Black List available to the user.[What is Metric Rule Black List](https://www.alibabacloud.com/help/en/cloudmonitor/latest/describemetricruleblacklist)

    > **NOTE:** Available in 1.194.0+

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    default = alicloud.cms.get_metric_rule_black_lists(ids=[default_alicloud_cms_metric_rule_black_lists["id"]],
        category="ecs",
        namespace="acs_ecs_dashboard")
    pulumi.export("alicloudCmsRuleBlackListExampleId", lists[0]["id"])
    ```


    :param _builtins.str category: Cloud service classification. For example, Redis includes kvstore_standard, kvstore_sharding, and kvstore_splitrw.
    :param Sequence[_builtins.str] ids: A list of Metric Rule Black List IDs.
    :param _builtins.str metric_rule_black_list_id: The first ID of the resource
    :param _builtins.str name_regex: A regex string to filter results by Group Metric Rule name.
    :param _builtins.str namespace: The data namespace of the cloud service.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    """
    __args__ = dict()
    __args__['category'] = category
    __args__['ids'] = ids
    __args__['metricRuleBlackListId'] = metric_rule_black_list_id
    __args__['nameRegex'] = name_regex
    __args__['namespace'] = namespace
    __args__['order'] = order
    __args__['outputFile'] = output_file
    __args__['pageNumber'] = page_number
    __args__['pageSize'] = page_size
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:cms/getMetricRuleBlackLists:getMetricRuleBlackLists', __args__, opts=opts, typ=GetMetricRuleBlackListsResult)
    return __ret__.apply(lambda __response__: GetMetricRuleBlackListsResult(
        category=pulumi.get(__response__, 'category'),
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        lists=pulumi.get(__response__, 'lists'),
        metric_rule_black_list_id=pulumi.get(__response__, 'metric_rule_black_list_id'),
        name_regex=pulumi.get(__response__, 'name_regex'),
        names=pulumi.get(__response__, 'names'),
        namespace=pulumi.get(__response__, 'namespace'),
        order=pulumi.get(__response__, 'order'),
        output_file=pulumi.get(__response__, 'output_file'),
        page_number=pulumi.get(__response__, 'page_number'),
        page_size=pulumi.get(__response__, 'page_size')))
