# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'AssumeRole',
    'AssumeRoleWithOidc',
    'Endpoints',
    'SignVersion',
]

@pulumi.output_type
class AssumeRole(dict):
    def __init__(__self__, *,
                 role_arn: _builtins.str,
                 external_id: Optional[_builtins.str] = None,
                 policy: Optional[_builtins.str] = None,
                 session_expiration: Optional[_builtins.int] = None,
                 session_name: Optional[_builtins.str] = None):
        """
        :param _builtins.str role_arn: The ARN of a RAM role to assume prior to making API calls.
        :param _builtins.str policy: The permissions applied when assuming a role. You cannot use, this policy to grant further permissions that are in excess to those of the, role that is being assumed.
        :param _builtins.int session_expiration: The time after which the established session for assuming role expires. Valid value range: [900-3600] seconds. Default to 0 (in this case Alicloud use own default value).
        """
        pulumi.set(__self__, "role_arn", role_arn)
        if external_id is not None:
            pulumi.set(__self__, "external_id", external_id)
        if policy is not None:
            pulumi.set(__self__, "policy", policy)
        if session_expiration is not None:
            pulumi.set(__self__, "session_expiration", session_expiration)
        if session_name is not None:
            pulumi.set(__self__, "session_name", session_name)

    @_builtins.property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> _builtins.str:
        """
        The ARN of a RAM role to assume prior to making API calls.
        """
        return pulumi.get(self, "role_arn")

    @_builtins.property
    @pulumi.getter(name="externalId")
    def external_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "external_id")

    @_builtins.property
    @pulumi.getter
    def policy(self) -> Optional[_builtins.str]:
        """
        The permissions applied when assuming a role. You cannot use, this policy to grant further permissions that are in excess to those of the, role that is being assumed.
        """
        return pulumi.get(self, "policy")

    @_builtins.property
    @pulumi.getter(name="sessionExpiration")
    def session_expiration(self) -> Optional[_builtins.int]:
        """
        The time after which the established session for assuming role expires. Valid value range: [900-3600] seconds. Default to 0 (in this case Alicloud use own default value).
        """
        return pulumi.get(self, "session_expiration")

    @_builtins.property
    @pulumi.getter(name="sessionName")
    def session_name(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "session_name")


@pulumi.output_type
class AssumeRoleWithOidc(dict):
    def __init__(__self__, *,
                 oidc_provider_arn: _builtins.str,
                 role_arn: _builtins.str,
                 oidc_token: Optional[_builtins.str] = None,
                 oidc_token_file: Optional[_builtins.str] = None,
                 policy: Optional[_builtins.str] = None,
                 role_session_name: Optional[_builtins.str] = None,
                 session_expiration: Optional[_builtins.int] = None):
        """
        :param _builtins.str oidc_provider_arn: ARN of the OIDC IdP.
        :param _builtins.str role_arn: ARN of a RAM role to assume prior to making API calls.
        :param _builtins.str oidc_token_file: The file path of OIDC token that is issued by the external IdP.
        :param _builtins.str policy: The policy that specifies the permissions of the returned STS token. You can use this parameter to grant the STS token fewer permissions than the permissions granted to the RAM role.
        :param _builtins.str role_session_name: The custom name of the role session. Set this parameter based on your business requirements. In most cases, this parameter is set to the identity of the user who calls the operation, for example, the username.
        :param _builtins.int session_expiration: The validity period of the STS token. Unit: seconds. Default value: 3600. Minimum value: 900. Maximum value: the value of the MaxSessionDuration parameter when creating a ram role.
        """
        pulumi.set(__self__, "oidc_provider_arn", oidc_provider_arn)
        pulumi.set(__self__, "role_arn", role_arn)
        if oidc_token is not None:
            pulumi.set(__self__, "oidc_token", oidc_token)
        if oidc_token_file is not None:
            pulumi.set(__self__, "oidc_token_file", oidc_token_file)
        if policy is not None:
            pulumi.set(__self__, "policy", policy)
        if role_session_name is not None:
            pulumi.set(__self__, "role_session_name", role_session_name)
        if session_expiration is not None:
            pulumi.set(__self__, "session_expiration", session_expiration)

    @_builtins.property
    @pulumi.getter(name="oidcProviderArn")
    def oidc_provider_arn(self) -> _builtins.str:
        """
        ARN of the OIDC IdP.
        """
        return pulumi.get(self, "oidc_provider_arn")

    @_builtins.property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> _builtins.str:
        """
        ARN of a RAM role to assume prior to making API calls.
        """
        return pulumi.get(self, "role_arn")

    @_builtins.property
    @pulumi.getter(name="oidcToken")
    def oidc_token(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "oidc_token")

    @_builtins.property
    @pulumi.getter(name="oidcTokenFile")
    def oidc_token_file(self) -> Optional[_builtins.str]:
        """
        The file path of OIDC token that is issued by the external IdP.
        """
        return pulumi.get(self, "oidc_token_file")

    @_builtins.property
    @pulumi.getter
    def policy(self) -> Optional[_builtins.str]:
        """
        The policy that specifies the permissions of the returned STS token. You can use this parameter to grant the STS token fewer permissions than the permissions granted to the RAM role.
        """
        return pulumi.get(self, "policy")

    @_builtins.property
    @pulumi.getter(name="roleSessionName")
    def role_session_name(self) -> Optional[_builtins.str]:
        """
        The custom name of the role session. Set this parameter based on your business requirements. In most cases, this parameter is set to the identity of the user who calls the operation, for example, the username.
        """
        return pulumi.get(self, "role_session_name")

    @_builtins.property
    @pulumi.getter(name="sessionExpiration")
    def session_expiration(self) -> Optional[_builtins.int]:
        """
        The validity period of the STS token. Unit: seconds. Default value: 3600. Minimum value: 900. Maximum value: the value of the MaxSessionDuration parameter when creating a ram role.
        """
        return pulumi.get(self, "session_expiration")


@pulumi.output_type
class Endpoints(dict):
    def __init__(__self__, *,
                 acr: Optional[_builtins.str] = None,
                 actiontrail: Optional[_builtins.str] = None,
                 adb: Optional[_builtins.str] = None,
                 aiworkspace: Optional[_builtins.str] = None,
                 alb: Optional[_builtins.str] = None,
                 alidfs: Optional[_builtins.str] = None,
                 alidns: Optional[_builtins.str] = None,
                 alikafka: Optional[_builtins.str] = None,
                 amqp: Optional[_builtins.str] = None,
                 antiddos_public: Optional[_builtins.str] = None,
                 apig: Optional[_builtins.str] = None,
                 apigateway: Optional[_builtins.str] = None,
                 arms: Optional[_builtins.str] = None,
                 bastionhost: Optional[_builtins.str] = None,
                 beebot: Optional[_builtins.str] = None,
                 bpstudio: Optional[_builtins.str] = None,
                 brain_industrial: Optional[_builtins.str] = None,
                 bssopenapi: Optional[_builtins.str] = None,
                 cas: Optional[_builtins.str] = None,
                 cassandra: Optional[_builtins.str] = None,
                 cbn: Optional[_builtins.str] = None,
                 cbs: Optional[_builtins.str] = None,
                 cddc: Optional[_builtins.str] = None,
                 cdn: Optional[_builtins.str] = None,
                 cds: Optional[_builtins.str] = None,
                 chatbot: Optional[_builtins.str] = None,
                 clickhouse: Optional[_builtins.str] = None,
                 cloudapi: Optional[_builtins.str] = None,
                 cloudauth: Optional[_builtins.str] = None,
                 cloudfirewall: Optional[_builtins.str] = None,
                 cloudfw: Optional[_builtins.str] = None,
                 cloudphone: Optional[_builtins.str] = None,
                 cloudsso: Optional[_builtins.str] = None,
                 cms: Optional[_builtins.str] = None,
                 computenest: Optional[_builtins.str] = None,
                 config: Optional[_builtins.str] = None,
                 cr: Optional[_builtins.str] = None,
                 cs: Optional[_builtins.str] = None,
                 das: Optional[_builtins.str] = None,
                 datahub: Optional[_builtins.str] = None,
                 dataworks_public: Optional[_builtins.str] = None,
                 dataworkspublic: Optional[_builtins.str] = None,
                 dbfs: Optional[_builtins.str] = None,
                 dbs: Optional[_builtins.str] = None,
                 dcdn: Optional[_builtins.str] = None,
                 ddosbasic: Optional[_builtins.str] = None,
                 ddosbgp: Optional[_builtins.str] = None,
                 ddoscoo: Optional[_builtins.str] = None,
                 dds: Optional[_builtins.str] = None,
                 devops_rdc: Optional[_builtins.str] = None,
                 devopsrdc: Optional[_builtins.str] = None,
                 dfs: Optional[_builtins.str] = None,
                 dg: Optional[_builtins.str] = None,
                 dm: Optional[_builtins.str] = None,
                 dms_enterprise: Optional[_builtins.str] = None,
                 dmsenterprise: Optional[_builtins.str] = None,
                 dns: Optional[_builtins.str] = None,
                 drds: Optional[_builtins.str] = None,
                 dts: Optional[_builtins.str] = None,
                 dysms: Optional[_builtins.str] = None,
                 dysmsapi: Optional[_builtins.str] = None,
                 eais: Optional[_builtins.str] = None,
                 ebs: Optional[_builtins.str] = None,
                 ecd: Optional[_builtins.str] = None,
                 eci: Optional[_builtins.str] = None,
                 ecs: Optional[_builtins.str] = None,
                 edas: Optional[_builtins.str] = None,
                 edasschedulerx: Optional[_builtins.str] = None,
                 eds_user: Optional[_builtins.str] = None,
                 edsuser: Optional[_builtins.str] = None,
                 eflo: Optional[_builtins.str] = None,
                 eflo_cnp: Optional[_builtins.str] = None,
                 eflo_controller: Optional[_builtins.str] = None,
                 ehpc: Optional[_builtins.str] = None,
                 ehs: Optional[_builtins.str] = None,
                 eipanycast: Optional[_builtins.str] = None,
                 elasticsearch: Optional[_builtins.str] = None,
                 emr: Optional[_builtins.str] = None,
                 ens: Optional[_builtins.str] = None,
                 esa: Optional[_builtins.str] = None,
                 ess: Optional[_builtins.str] = None,
                 eventbridge: Optional[_builtins.str] = None,
                 fc: Optional[_builtins.str] = None,
                 fc_open: Optional[_builtins.str] = None,
                 fnf: Optional[_builtins.str] = None,
                 ga: Optional[_builtins.str] = None,
                 gaplus: Optional[_builtins.str] = None,
                 gdb: Optional[_builtins.str] = None,
                 gds: Optional[_builtins.str] = None,
                 gpdb: Optional[_builtins.str] = None,
                 gwlb: Optional[_builtins.str] = None,
                 gwsecd: Optional[_builtins.str] = None,
                 hbr: Optional[_builtins.str] = None,
                 hcs_sgw: Optional[_builtins.str] = None,
                 hitsdb: Optional[_builtins.str] = None,
                 imm: Optional[_builtins.str] = None,
                 imp: Optional[_builtins.str] = None,
                 ims: Optional[_builtins.str] = None,
                 iot: Optional[_builtins.str] = None,
                 kms: Optional[_builtins.str] = None,
                 kvstore: Optional[_builtins.str] = None,
                 location: Optional[_builtins.str] = None,
                 log: Optional[_builtins.str] = None,
                 market: Optional[_builtins.str] = None,
                 maxcompute: Optional[_builtins.str] = None,
                 mhub: Optional[_builtins.str] = None,
                 mns: Optional[_builtins.str] = None,
                 mns_open: Optional[_builtins.str] = None,
                 mscopensubscription: Optional[_builtins.str] = None,
                 mse: Optional[_builtins.str] = None,
                 nas: Optional[_builtins.str] = None,
                 nlb: Optional[_builtins.str] = None,
                 oceanbase: Optional[_builtins.str] = None,
                 oceanbasepro: Optional[_builtins.str] = None,
                 ons: Optional[_builtins.str] = None,
                 onsproxy: Optional[_builtins.str] = None,
                 oos: Optional[_builtins.str] = None,
                 opensearch: Optional[_builtins.str] = None,
                 oss: Optional[_builtins.str] = None,
                 ots: Optional[_builtins.str] = None,
                 polardb: Optional[_builtins.str] = None,
                 polardbx: Optional[_builtins.str] = None,
                 privatelink: Optional[_builtins.str] = None,
                 pvtz: Optional[_builtins.str] = None,
                 quickbi: Optional[_builtins.str] = None,
                 quickbi_public: Optional[_builtins.str] = None,
                 quotas: Optional[_builtins.str] = None,
                 r_kvstore: Optional[_builtins.str] = None,
                 ram: Optional[_builtins.str] = None,
                 rds: Optional[_builtins.str] = None,
                 redisa: Optional[_builtins.str] = None,
                 resourcemanager: Optional[_builtins.str] = None,
                 resourcesharing: Optional[_builtins.str] = None,
                 ressharing: Optional[_builtins.str] = None,
                 rocketmq: Optional[_builtins.str] = None,
                 ros: Optional[_builtins.str] = None,
                 sae: Optional[_builtins.str] = None,
                 sas: Optional[_builtins.str] = None,
                 scdn: Optional[_builtins.str] = None,
                 schedulerx2: Optional[_builtins.str] = None,
                 sddp: Optional[_builtins.str] = None,
                 selectdb: Optional[_builtins.str] = None,
                 serverless: Optional[_builtins.str] = None,
                 servicecatalog: Optional[_builtins.str] = None,
                 servicemesh: Optional[_builtins.str] = None,
                 sgw: Optional[_builtins.str] = None,
                 slb: Optional[_builtins.str] = None,
                 smartag: Optional[_builtins.str] = None,
                 srvcatalog: Optional[_builtins.str] = None,
                 sts: Optional[_builtins.str] = None,
                 swas: Optional[_builtins.str] = None,
                 swas_open: Optional[_builtins.str] = None,
                 tag: Optional[_builtins.str] = None,
                 vod: Optional[_builtins.str] = None,
                 vpc: Optional[_builtins.str] = None,
                 vpcipam: Optional[_builtins.str] = None,
                 vpcpeer: Optional[_builtins.str] = None,
                 vs: Optional[_builtins.str] = None,
                 waf: Optional[_builtins.str] = None,
                 waf_openapi: Optional[_builtins.str] = None):
        """
        :param _builtins.str acr: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom acr endpoints.
        :param _builtins.str actiontrail: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom Actiontrail endpoints.
        :param _builtins.str adb: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom AnalyticDB endpoints.
        :param _builtins.str alb: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom alb endpoints.
        :param _builtins.str alidfs: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom alidfs endpoints.
        :param _builtins.str alidns: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom alidns endpoints.
        :param _builtins.str alikafka: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom ALIKAFKA endpoints.
        :param _builtins.str amqp: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom onsproxy endpoints.
        :param _builtins.str antiddos_public: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom ddosbasic endpoints.
        :param _builtins.str apigateway: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom Api Gateway endpoints.
        :param _builtins.str arms: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom arms endpoints.
        :param _builtins.str bastionhost: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom bastionhost endpoints.
        :param _builtins.str beebot: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom beebot endpoints.
        :param _builtins.str bpstudio: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom bpstudio endpoints.
        :param _builtins.str brain_industrial: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom brain_industrial endpoints.
        :param _builtins.str bssopenapi: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom BSSOPENAPI endpoints.
        :param _builtins.str cas: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom CAS endpoints.
        :param _builtins.str cassandra: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom cassandra endpoints.
        :param _builtins.str cbn: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom cbn endpoints.
        :param _builtins.str cbs: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom cbs endpoints.
        :param _builtins.str cddc: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom cddc endpoints.
        :param _builtins.str cdn: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom CDN endpoints.
        :param _builtins.str cds: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom cds endpoints.
        :param _builtins.str chatbot: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom beebot endpoints.
        :param _builtins.str clickhouse: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom clickhouse endpoints.
        :param _builtins.str cloudapi: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom Api Gateway endpoints.
        :param _builtins.str cloudauth: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom cloudauth endpoints.
        :param _builtins.str cloudfirewall: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom cloudfirewall endpoints.
        :param _builtins.str cloudfw: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom cloudfw endpoints.
        :param _builtins.str cloudphone: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom cloudphone endpoints.
        :param _builtins.str cloudsso: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom cloudsso endpoints.
        :param _builtins.str cms: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom Cloud Monitor endpoints.
        :param _builtins.str computenest: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom computenest endpoints.
        :param _builtins.str config: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom config endpoints.
        :param _builtins.str cr: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom Container Registry endpoints.
        :param _builtins.str cs: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom Container Service endpoints.
        :param _builtins.str das: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom das endpoints.
        :param _builtins.str datahub: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom Datahub endpoints.
        :param _builtins.str dataworks_public: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom dataworkspublic endpoints.
        :param _builtins.str dataworkspublic: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom dataworkspublic endpoints.
        :param _builtins.str dbfs: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom dbfs endpoints.
        :param _builtins.str dbs: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom cbs endpoints.
        :param _builtins.str dcdn: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom dcdn endpoints.
        :param _builtins.str ddosbasic: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom ddosbasic endpoints.
        :param _builtins.str ddosbgp: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom DDOSBGP endpoints.
        :param _builtins.str ddoscoo: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom DDOSCOO endpoints.
        :param _builtins.str dds: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom MongoDB endpoints.
        :param _builtins.str devopsrdc: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom devopsrdc endpoints.
        :param _builtins.str dfs: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom alidfs endpoints.
        :param _builtins.str dg: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom dg endpoints.
        :param _builtins.str dm: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom dm endpoints.
        :param _builtins.str dms_enterprise: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom dms_enterprise endpoints.
        :param _builtins.str dmsenterprise: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom dmsenterprise endpoints.
        :param _builtins.str dns: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom DNS endpoints.
        :param _builtins.str drds: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom DRDS endpoints.
        :param _builtins.str dts: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom dts endpoints.
        :param _builtins.str dysmsapi: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom dysmsapi endpoints.
        :param _builtins.str eais: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom eais endpoints.
        :param _builtins.str ebs: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom ebs endpoints.
        :param _builtins.str ecd: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom gwsecd endpoints.
        :param _builtins.str eci: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom eci endpoints.
        :param _builtins.str ecs: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom ECS endpoints.
        :param _builtins.str edas: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom edas endpoints.
        :param _builtins.str edasschedulerx: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom edasschedulerx endpoints.
        :param _builtins.str eds_user: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom edsuser endpoints.
        :param _builtins.str edsuser: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom edsuser endpoints.
        :param _builtins.str eflo: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom eflo endpoints.
        :param _builtins.str eflo_controller: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom efloctrl endpoints.
        :param _builtins.str ehpc: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom ehpc endpoints.
        :param _builtins.str ehs: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom ehs endpoints.
        :param _builtins.str eipanycast: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom eipanycast endpoints.
        :param _builtins.str elasticsearch: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom Elasticsearch endpoints.
        :param _builtins.str emr: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom EMR endpoints.
        :param _builtins.str ens: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom ens endpoints.
        :param _builtins.str ess: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom Autoscaling endpoints.
        :param _builtins.str eventbridge: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom eventbridge_share endpoints.
        :param _builtins.str fc: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom Function Computing endpoints.
        :param _builtins.str fc_open: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom Function Computing endpoints.
        :param _builtins.str fnf: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom fnf endpoints.
        :param _builtins.str ga: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom ga endpoints.
        :param _builtins.str gaplus: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom gaplus endpoints.
        :param _builtins.str gdb: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom gds endpoints.
        :param _builtins.str gds: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom gds endpoints.
        :param _builtins.str gpdb: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom GPDB endpoints.
        :param _builtins.str gwsecd: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom gwsecd endpoints.
        :param _builtins.str hbr: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom hbr endpoints.
        :param _builtins.str hcs_sgw: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom hcs_sgw endpoints.
        :param _builtins.str hitsdb: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom hitsdb endpoints.
        :param _builtins.str imm: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom imm endpoints.
        :param _builtins.str imp: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom imp endpoints.
        :param _builtins.str ims: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom ims endpoints.
        :param _builtins.str iot: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom iot endpoints.
        :param _builtins.str kms: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom KMS endpoints.
        :param _builtins.str kvstore: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom R-KVStore endpoints.
        :param _builtins.str location: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom Location Service endpoints.
        :param _builtins.str log: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom Log Service endpoints.
        :param _builtins.str market: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom Market Place endpoints.
        :param _builtins.str maxcompute: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom MaxCompute endpoints.
        :param _builtins.str mhub: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom mhub endpoints.
        :param _builtins.str mns: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom MNS endpoints.
        :param _builtins.str mns_open: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom MNS endpoints.
        :param _builtins.str mscopensubscription: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom mscopensubscription endpoints.
        :param _builtins.str mse: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom mse endpoints.
        :param _builtins.str nas: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom NAS endpoints.
        :param _builtins.str nlb: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom nlb endpoints.
        :param _builtins.str oceanbase: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom oceanbase endpoints.
        :param _builtins.str oceanbasepro: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom oceanbase endpoints.
        :param _builtins.str ons: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom ONS endpoints.
        :param _builtins.str onsproxy: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom onsproxy endpoints.
        :param _builtins.str oos: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom oos endpoints.
        :param _builtins.str opensearch: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom opensearch endpoints.
        :param _builtins.str oss: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom OSS endpoints.
        :param _builtins.str ots: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom Table Store endpoints.
        :param _builtins.str polardb: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom PolarDB endpoints.
        :param _builtins.str polardbx: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom DRDS endpoints.
        :param _builtins.str privatelink: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom privatelink endpoints.
        :param _builtins.str pvtz: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom Private Zone endpoints.
        :param _builtins.str quickbi: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom quickbi endpoints.
        :param _builtins.str quickbi_public: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom quickbi endpoints.
        :param _builtins.str quotas: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom quotas endpoints.
        :param _builtins.str r_kvstore: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom r_kvstore endpoints.
        :param _builtins.str ram: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom RAM endpoints.
        :param _builtins.str rds: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom RDS endpoints.
        :param _builtins.str redisa: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom redisa endpoints.
        :param _builtins.str resourcemanager: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom resourcemanager endpoints.
        :param _builtins.str ressharing: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom resourcesharing endpoints.
        :param _builtins.str ros: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom ros endpoints.
        :param _builtins.str sae: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom serverless endpoints.
        :param _builtins.str sas: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom sas endpoints.
        :param _builtins.str scdn: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom scdn endpoints.
        :param _builtins.str schedulerx2: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom edasschedulerx endpoints.
        :param _builtins.str sddp: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom sddp endpoints.
        :param _builtins.str selectdb: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom selectdb endpoints.
        :param _builtins.str serverless: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom serverless endpoints.
        :param _builtins.str servicecatalog: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom srvcatalog endpoints.
        :param _builtins.str servicemesh: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom servicemesh endpoints.
        :param _builtins.str sgw: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom sgw endpoints.
        :param _builtins.str slb: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom SLB endpoints.
        :param _builtins.str smartag: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom smartag endpoints.
        :param _builtins.str srvcatalog: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom srvcatalog endpoints.
        :param _builtins.str sts: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom STS endpoints.
        :param _builtins.str swas: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom swas endpoints.
        :param _builtins.str swas_open: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom swas endpoints.
        :param _builtins.str tag: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom tag endpoints.
        :param _builtins.str vod: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom vod endpoints.
        :param _builtins.str vpc: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom VPC and VPN endpoints.
        :param _builtins.str vpcpeer: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom vpcpeer endpoints.
        :param _builtins.str vs: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom vs endpoints.
        :param _builtins.str waf: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom waf endpoints.
        :param _builtins.str waf_openapi: Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom waf_openapi endpoints.
        """
        if acr is not None:
            pulumi.set(__self__, "acr", acr)
        if actiontrail is not None:
            pulumi.set(__self__, "actiontrail", actiontrail)
        if adb is not None:
            pulumi.set(__self__, "adb", adb)
        if aiworkspace is not None:
            pulumi.set(__self__, "aiworkspace", aiworkspace)
        if alb is not None:
            pulumi.set(__self__, "alb", alb)
        if alidfs is not None:
            pulumi.set(__self__, "alidfs", alidfs)
        if alidns is not None:
            pulumi.set(__self__, "alidns", alidns)
        if alikafka is not None:
            pulumi.set(__self__, "alikafka", alikafka)
        if amqp is not None:
            pulumi.set(__self__, "amqp", amqp)
        if antiddos_public is not None:
            pulumi.set(__self__, "antiddos_public", antiddos_public)
        if apig is not None:
            pulumi.set(__self__, "apig", apig)
        if apigateway is not None:
            pulumi.set(__self__, "apigateway", apigateway)
        if arms is not None:
            pulumi.set(__self__, "arms", arms)
        if bastionhost is not None:
            pulumi.set(__self__, "bastionhost", bastionhost)
        if beebot is not None:
            pulumi.set(__self__, "beebot", beebot)
        if bpstudio is not None:
            pulumi.set(__self__, "bpstudio", bpstudio)
        if brain_industrial is not None:
            pulumi.set(__self__, "brain_industrial", brain_industrial)
        if bssopenapi is not None:
            pulumi.set(__self__, "bssopenapi", bssopenapi)
        if cas is not None:
            pulumi.set(__self__, "cas", cas)
        if cassandra is not None:
            pulumi.set(__self__, "cassandra", cassandra)
        if cbn is not None:
            pulumi.set(__self__, "cbn", cbn)
        if cbs is not None:
            pulumi.set(__self__, "cbs", cbs)
        if cddc is not None:
            pulumi.set(__self__, "cddc", cddc)
        if cdn is not None:
            pulumi.set(__self__, "cdn", cdn)
        if cds is not None:
            pulumi.set(__self__, "cds", cds)
        if chatbot is not None:
            pulumi.set(__self__, "chatbot", chatbot)
        if clickhouse is not None:
            pulumi.set(__self__, "clickhouse", clickhouse)
        if cloudapi is not None:
            pulumi.set(__self__, "cloudapi", cloudapi)
        if cloudauth is not None:
            pulumi.set(__self__, "cloudauth", cloudauth)
        if cloudfirewall is not None:
            pulumi.set(__self__, "cloudfirewall", cloudfirewall)
        if cloudfw is not None:
            pulumi.set(__self__, "cloudfw", cloudfw)
        if cloudphone is not None:
            pulumi.set(__self__, "cloudphone", cloudphone)
        if cloudsso is not None:
            pulumi.set(__self__, "cloudsso", cloudsso)
        if cms is not None:
            pulumi.set(__self__, "cms", cms)
        if computenest is not None:
            pulumi.set(__self__, "computenest", computenest)
        if config is not None:
            pulumi.set(__self__, "config", config)
        if cr is not None:
            pulumi.set(__self__, "cr", cr)
        if cs is not None:
            pulumi.set(__self__, "cs", cs)
        if das is not None:
            pulumi.set(__self__, "das", das)
        if datahub is not None:
            pulumi.set(__self__, "datahub", datahub)
        if dataworks_public is not None:
            pulumi.set(__self__, "dataworks_public", dataworks_public)
        if dataworkspublic is not None:
            pulumi.set(__self__, "dataworkspublic", dataworkspublic)
        if dbfs is not None:
            pulumi.set(__self__, "dbfs", dbfs)
        if dbs is not None:
            pulumi.set(__self__, "dbs", dbs)
        if dcdn is not None:
            pulumi.set(__self__, "dcdn", dcdn)
        if ddosbasic is not None:
            pulumi.set(__self__, "ddosbasic", ddosbasic)
        if ddosbgp is not None:
            pulumi.set(__self__, "ddosbgp", ddosbgp)
        if ddoscoo is not None:
            pulumi.set(__self__, "ddoscoo", ddoscoo)
        if dds is not None:
            pulumi.set(__self__, "dds", dds)
        if devops_rdc is not None:
            pulumi.set(__self__, "devops_rdc", devops_rdc)
        if devopsrdc is not None:
            pulumi.set(__self__, "devopsrdc", devopsrdc)
        if dfs is not None:
            pulumi.set(__self__, "dfs", dfs)
        if dg is not None:
            pulumi.set(__self__, "dg", dg)
        if dm is not None:
            pulumi.set(__self__, "dm", dm)
        if dms_enterprise is not None:
            pulumi.set(__self__, "dms_enterprise", dms_enterprise)
        if dmsenterprise is not None:
            pulumi.set(__self__, "dmsenterprise", dmsenterprise)
        if dns is not None:
            pulumi.set(__self__, "dns", dns)
        if drds is not None:
            pulumi.set(__self__, "drds", drds)
        if dts is not None:
            pulumi.set(__self__, "dts", dts)
        if dysms is not None:
            pulumi.set(__self__, "dysms", dysms)
        if dysmsapi is not None:
            pulumi.set(__self__, "dysmsapi", dysmsapi)
        if eais is not None:
            pulumi.set(__self__, "eais", eais)
        if ebs is not None:
            pulumi.set(__self__, "ebs", ebs)
        if ecd is not None:
            pulumi.set(__self__, "ecd", ecd)
        if eci is not None:
            pulumi.set(__self__, "eci", eci)
        if ecs is not None:
            pulumi.set(__self__, "ecs", ecs)
        if edas is not None:
            pulumi.set(__self__, "edas", edas)
        if edasschedulerx is not None:
            pulumi.set(__self__, "edasschedulerx", edasschedulerx)
        if eds_user is not None:
            pulumi.set(__self__, "eds_user", eds_user)
        if edsuser is not None:
            pulumi.set(__self__, "edsuser", edsuser)
        if eflo is not None:
            pulumi.set(__self__, "eflo", eflo)
        if eflo_cnp is not None:
            pulumi.set(__self__, "eflo_cnp", eflo_cnp)
        if eflo_controller is not None:
            pulumi.set(__self__, "eflo_controller", eflo_controller)
        if ehpc is not None:
            pulumi.set(__self__, "ehpc", ehpc)
        if ehs is not None:
            pulumi.set(__self__, "ehs", ehs)
        if eipanycast is not None:
            pulumi.set(__self__, "eipanycast", eipanycast)
        if elasticsearch is not None:
            pulumi.set(__self__, "elasticsearch", elasticsearch)
        if emr is not None:
            pulumi.set(__self__, "emr", emr)
        if ens is not None:
            pulumi.set(__self__, "ens", ens)
        if esa is not None:
            pulumi.set(__self__, "esa", esa)
        if ess is not None:
            pulumi.set(__self__, "ess", ess)
        if eventbridge is not None:
            pulumi.set(__self__, "eventbridge", eventbridge)
        if fc is not None:
            pulumi.set(__self__, "fc", fc)
        if fc_open is not None:
            pulumi.set(__self__, "fc_open", fc_open)
        if fnf is not None:
            pulumi.set(__self__, "fnf", fnf)
        if ga is not None:
            pulumi.set(__self__, "ga", ga)
        if gaplus is not None:
            pulumi.set(__self__, "gaplus", gaplus)
        if gdb is not None:
            pulumi.set(__self__, "gdb", gdb)
        if gds is not None:
            pulumi.set(__self__, "gds", gds)
        if gpdb is not None:
            pulumi.set(__self__, "gpdb", gpdb)
        if gwlb is not None:
            pulumi.set(__self__, "gwlb", gwlb)
        if gwsecd is not None:
            pulumi.set(__self__, "gwsecd", gwsecd)
        if hbr is not None:
            pulumi.set(__self__, "hbr", hbr)
        if hcs_sgw is not None:
            pulumi.set(__self__, "hcs_sgw", hcs_sgw)
        if hitsdb is not None:
            pulumi.set(__self__, "hitsdb", hitsdb)
        if imm is not None:
            pulumi.set(__self__, "imm", imm)
        if imp is not None:
            pulumi.set(__self__, "imp", imp)
        if ims is not None:
            pulumi.set(__self__, "ims", ims)
        if iot is not None:
            pulumi.set(__self__, "iot", iot)
        if kms is not None:
            pulumi.set(__self__, "kms", kms)
        if kvstore is not None:
            pulumi.set(__self__, "kvstore", kvstore)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if log is not None:
            pulumi.set(__self__, "log", log)
        if market is not None:
            pulumi.set(__self__, "market", market)
        if maxcompute is not None:
            pulumi.set(__self__, "maxcompute", maxcompute)
        if mhub is not None:
            pulumi.set(__self__, "mhub", mhub)
        if mns is not None:
            pulumi.set(__self__, "mns", mns)
        if mns_open is not None:
            pulumi.set(__self__, "mns_open", mns_open)
        if mscopensubscription is not None:
            pulumi.set(__self__, "mscopensubscription", mscopensubscription)
        if mse is not None:
            pulumi.set(__self__, "mse", mse)
        if nas is not None:
            pulumi.set(__self__, "nas", nas)
        if nlb is not None:
            pulumi.set(__self__, "nlb", nlb)
        if oceanbase is not None:
            pulumi.set(__self__, "oceanbase", oceanbase)
        if oceanbasepro is not None:
            pulumi.set(__self__, "oceanbasepro", oceanbasepro)
        if ons is not None:
            pulumi.set(__self__, "ons", ons)
        if onsproxy is not None:
            pulumi.set(__self__, "onsproxy", onsproxy)
        if oos is not None:
            pulumi.set(__self__, "oos", oos)
        if opensearch is not None:
            pulumi.set(__self__, "opensearch", opensearch)
        if oss is not None:
            pulumi.set(__self__, "oss", oss)
        if ots is not None:
            pulumi.set(__self__, "ots", ots)
        if polardb is not None:
            pulumi.set(__self__, "polardb", polardb)
        if polardbx is not None:
            pulumi.set(__self__, "polardbx", polardbx)
        if privatelink is not None:
            pulumi.set(__self__, "privatelink", privatelink)
        if pvtz is not None:
            pulumi.set(__self__, "pvtz", pvtz)
        if quickbi is not None:
            pulumi.set(__self__, "quickbi", quickbi)
        if quickbi_public is not None:
            pulumi.set(__self__, "quickbi_public", quickbi_public)
        if quotas is not None:
            pulumi.set(__self__, "quotas", quotas)
        if r_kvstore is not None:
            pulumi.set(__self__, "r_kvstore", r_kvstore)
        if ram is not None:
            pulumi.set(__self__, "ram", ram)
        if rds is not None:
            pulumi.set(__self__, "rds", rds)
        if redisa is not None:
            pulumi.set(__self__, "redisa", redisa)
        if resourcemanager is not None:
            pulumi.set(__self__, "resourcemanager", resourcemanager)
        if resourcesharing is not None:
            pulumi.set(__self__, "resourcesharing", resourcesharing)
        if ressharing is not None:
            pulumi.set(__self__, "ressharing", ressharing)
        if rocketmq is not None:
            pulumi.set(__self__, "rocketmq", rocketmq)
        if ros is not None:
            pulumi.set(__self__, "ros", ros)
        if sae is not None:
            pulumi.set(__self__, "sae", sae)
        if sas is not None:
            pulumi.set(__self__, "sas", sas)
        if scdn is not None:
            pulumi.set(__self__, "scdn", scdn)
        if schedulerx2 is not None:
            pulumi.set(__self__, "schedulerx2", schedulerx2)
        if sddp is not None:
            pulumi.set(__self__, "sddp", sddp)
        if selectdb is not None:
            pulumi.set(__self__, "selectdb", selectdb)
        if serverless is not None:
            pulumi.set(__self__, "serverless", serverless)
        if servicecatalog is not None:
            pulumi.set(__self__, "servicecatalog", servicecatalog)
        if servicemesh is not None:
            pulumi.set(__self__, "servicemesh", servicemesh)
        if sgw is not None:
            pulumi.set(__self__, "sgw", sgw)
        if slb is not None:
            pulumi.set(__self__, "slb", slb)
        if smartag is not None:
            pulumi.set(__self__, "smartag", smartag)
        if srvcatalog is not None:
            pulumi.set(__self__, "srvcatalog", srvcatalog)
        if sts is not None:
            pulumi.set(__self__, "sts", sts)
        if swas is not None:
            pulumi.set(__self__, "swas", swas)
        if swas_open is not None:
            pulumi.set(__self__, "swas_open", swas_open)
        if tag is not None:
            pulumi.set(__self__, "tag", tag)
        if vod is not None:
            pulumi.set(__self__, "vod", vod)
        if vpc is not None:
            pulumi.set(__self__, "vpc", vpc)
        if vpcipam is not None:
            pulumi.set(__self__, "vpcipam", vpcipam)
        if vpcpeer is not None:
            pulumi.set(__self__, "vpcpeer", vpcpeer)
        if vs is not None:
            pulumi.set(__self__, "vs", vs)
        if waf is not None:
            pulumi.set(__self__, "waf", waf)
        if waf_openapi is not None:
            pulumi.set(__self__, "waf_openapi", waf_openapi)

    @_builtins.property
    @pulumi.getter
    def acr(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom acr endpoints.
        """
        return pulumi.get(self, "acr")

    @_builtins.property
    @pulumi.getter
    def actiontrail(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom Actiontrail endpoints.
        """
        return pulumi.get(self, "actiontrail")

    @_builtins.property
    @pulumi.getter
    def adb(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom AnalyticDB endpoints.
        """
        return pulumi.get(self, "adb")

    @_builtins.property
    @pulumi.getter
    def aiworkspace(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "aiworkspace")

    @_builtins.property
    @pulumi.getter
    def alb(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom alb endpoints.
        """
        return pulumi.get(self, "alb")

    @_builtins.property
    @pulumi.getter
    def alidfs(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom alidfs endpoints.
        """
        return pulumi.get(self, "alidfs")

    @_builtins.property
    @pulumi.getter
    def alidns(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom alidns endpoints.
        """
        return pulumi.get(self, "alidns")

    @_builtins.property
    @pulumi.getter
    def alikafka(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom ALIKAFKA endpoints.
        """
        return pulumi.get(self, "alikafka")

    @_builtins.property
    @pulumi.getter
    def amqp(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom onsproxy endpoints.
        """
        return pulumi.get(self, "amqp")

    @_builtins.property
    @pulumi.getter(name="antiddosPublic")
    def antiddos_public(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom ddosbasic endpoints.
        """
        return pulumi.get(self, "antiddos_public")

    @_builtins.property
    @pulumi.getter
    def apig(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "apig")

    @_builtins.property
    @pulumi.getter
    def apigateway(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom Api Gateway endpoints.
        """
        return pulumi.get(self, "apigateway")

    @_builtins.property
    @pulumi.getter
    def arms(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom arms endpoints.
        """
        return pulumi.get(self, "arms")

    @_builtins.property
    @pulumi.getter
    def bastionhost(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom bastionhost endpoints.
        """
        return pulumi.get(self, "bastionhost")

    @_builtins.property
    @pulumi.getter
    def beebot(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom beebot endpoints.
        """
        return pulumi.get(self, "beebot")

    @_builtins.property
    @pulumi.getter
    def bpstudio(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom bpstudio endpoints.
        """
        return pulumi.get(self, "bpstudio")

    @_builtins.property
    @pulumi.getter(name="brainIndustrial")
    def brain_industrial(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom brain_industrial endpoints.
        """
        return pulumi.get(self, "brain_industrial")

    @_builtins.property
    @pulumi.getter
    def bssopenapi(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom BSSOPENAPI endpoints.
        """
        return pulumi.get(self, "bssopenapi")

    @_builtins.property
    @pulumi.getter
    def cas(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom CAS endpoints.
        """
        return pulumi.get(self, "cas")

    @_builtins.property
    @pulumi.getter
    def cassandra(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom cassandra endpoints.
        """
        return pulumi.get(self, "cassandra")

    @_builtins.property
    @pulumi.getter
    def cbn(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom cbn endpoints.
        """
        return pulumi.get(self, "cbn")

    @_builtins.property
    @pulumi.getter
    def cbs(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom cbs endpoints.
        """
        return pulumi.get(self, "cbs")

    @_builtins.property
    @pulumi.getter
    def cddc(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom cddc endpoints.
        """
        return pulumi.get(self, "cddc")

    @_builtins.property
    @pulumi.getter
    def cdn(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom CDN endpoints.
        """
        return pulumi.get(self, "cdn")

    @_builtins.property
    @pulumi.getter
    def cds(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom cds endpoints.
        """
        return pulumi.get(self, "cds")

    @_builtins.property
    @pulumi.getter
    def chatbot(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom beebot endpoints.
        """
        return pulumi.get(self, "chatbot")

    @_builtins.property
    @pulumi.getter
    def clickhouse(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom clickhouse endpoints.
        """
        return pulumi.get(self, "clickhouse")

    @_builtins.property
    @pulumi.getter
    def cloudapi(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom Api Gateway endpoints.
        """
        return pulumi.get(self, "cloudapi")

    @_builtins.property
    @pulumi.getter
    def cloudauth(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom cloudauth endpoints.
        """
        return pulumi.get(self, "cloudauth")

    @_builtins.property
    @pulumi.getter
    def cloudfirewall(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom cloudfirewall endpoints.
        """
        return pulumi.get(self, "cloudfirewall")

    @_builtins.property
    @pulumi.getter
    def cloudfw(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom cloudfw endpoints.
        """
        return pulumi.get(self, "cloudfw")

    @_builtins.property
    @pulumi.getter
    def cloudphone(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom cloudphone endpoints.
        """
        return pulumi.get(self, "cloudphone")

    @_builtins.property
    @pulumi.getter
    def cloudsso(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom cloudsso endpoints.
        """
        return pulumi.get(self, "cloudsso")

    @_builtins.property
    @pulumi.getter
    def cms(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom Cloud Monitor endpoints.
        """
        return pulumi.get(self, "cms")

    @_builtins.property
    @pulumi.getter
    def computenest(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom computenest endpoints.
        """
        return pulumi.get(self, "computenest")

    @_builtins.property
    @pulumi.getter
    def config(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom config endpoints.
        """
        return pulumi.get(self, "config")

    @_builtins.property
    @pulumi.getter
    def cr(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom Container Registry endpoints.
        """
        return pulumi.get(self, "cr")

    @_builtins.property
    @pulumi.getter
    def cs(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom Container Service endpoints.
        """
        return pulumi.get(self, "cs")

    @_builtins.property
    @pulumi.getter
    def das(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom das endpoints.
        """
        return pulumi.get(self, "das")

    @_builtins.property
    @pulumi.getter
    def datahub(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom Datahub endpoints.
        """
        return pulumi.get(self, "datahub")

    @_builtins.property
    @pulumi.getter(name="dataworksPublic")
    def dataworks_public(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom dataworkspublic endpoints.
        """
        return pulumi.get(self, "dataworks_public")

    @_builtins.property
    @pulumi.getter
    def dataworkspublic(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom dataworkspublic endpoints.
        """
        return pulumi.get(self, "dataworkspublic")

    @_builtins.property
    @pulumi.getter
    def dbfs(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom dbfs endpoints.
        """
        return pulumi.get(self, "dbfs")

    @_builtins.property
    @pulumi.getter
    def dbs(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom cbs endpoints.
        """
        return pulumi.get(self, "dbs")

    @_builtins.property
    @pulumi.getter
    def dcdn(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom dcdn endpoints.
        """
        return pulumi.get(self, "dcdn")

    @_builtins.property
    @pulumi.getter
    def ddosbasic(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom ddosbasic endpoints.
        """
        return pulumi.get(self, "ddosbasic")

    @_builtins.property
    @pulumi.getter
    def ddosbgp(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom DDOSBGP endpoints.
        """
        return pulumi.get(self, "ddosbgp")

    @_builtins.property
    @pulumi.getter
    def ddoscoo(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom DDOSCOO endpoints.
        """
        return pulumi.get(self, "ddoscoo")

    @_builtins.property
    @pulumi.getter
    def dds(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom MongoDB endpoints.
        """
        return pulumi.get(self, "dds")

    @_builtins.property
    @pulumi.getter(name="devopsRdc")
    def devops_rdc(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "devops_rdc")

    @_builtins.property
    @pulumi.getter
    def devopsrdc(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom devopsrdc endpoints.
        """
        return pulumi.get(self, "devopsrdc")

    @_builtins.property
    @pulumi.getter
    def dfs(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom alidfs endpoints.
        """
        return pulumi.get(self, "dfs")

    @_builtins.property
    @pulumi.getter
    def dg(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom dg endpoints.
        """
        return pulumi.get(self, "dg")

    @_builtins.property
    @pulumi.getter
    def dm(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom dm endpoints.
        """
        return pulumi.get(self, "dm")

    @_builtins.property
    @pulumi.getter(name="dmsEnterprise")
    def dms_enterprise(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom dms_enterprise endpoints.
        """
        return pulumi.get(self, "dms_enterprise")

    @_builtins.property
    @pulumi.getter
    def dmsenterprise(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom dmsenterprise endpoints.
        """
        return pulumi.get(self, "dmsenterprise")

    @_builtins.property
    @pulumi.getter
    def dns(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom DNS endpoints.
        """
        return pulumi.get(self, "dns")

    @_builtins.property
    @pulumi.getter
    def drds(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom DRDS endpoints.
        """
        return pulumi.get(self, "drds")

    @_builtins.property
    @pulumi.getter
    def dts(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom dts endpoints.
        """
        return pulumi.get(self, "dts")

    @_builtins.property
    @pulumi.getter
    def dysms(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "dysms")

    @_builtins.property
    @pulumi.getter
    def dysmsapi(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom dysmsapi endpoints.
        """
        return pulumi.get(self, "dysmsapi")

    @_builtins.property
    @pulumi.getter
    def eais(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom eais endpoints.
        """
        return pulumi.get(self, "eais")

    @_builtins.property
    @pulumi.getter
    def ebs(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom ebs endpoints.
        """
        return pulumi.get(self, "ebs")

    @_builtins.property
    @pulumi.getter
    def ecd(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom gwsecd endpoints.
        """
        return pulumi.get(self, "ecd")

    @_builtins.property
    @pulumi.getter
    def eci(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom eci endpoints.
        """
        return pulumi.get(self, "eci")

    @_builtins.property
    @pulumi.getter
    def ecs(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom ECS endpoints.
        """
        return pulumi.get(self, "ecs")

    @_builtins.property
    @pulumi.getter
    def edas(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom edas endpoints.
        """
        return pulumi.get(self, "edas")

    @_builtins.property
    @pulumi.getter
    def edasschedulerx(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom edasschedulerx endpoints.
        """
        return pulumi.get(self, "edasschedulerx")

    @_builtins.property
    @pulumi.getter(name="edsUser")
    def eds_user(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom edsuser endpoints.
        """
        return pulumi.get(self, "eds_user")

    @_builtins.property
    @pulumi.getter
    def edsuser(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom edsuser endpoints.
        """
        return pulumi.get(self, "edsuser")

    @_builtins.property
    @pulumi.getter
    def eflo(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom eflo endpoints.
        """
        return pulumi.get(self, "eflo")

    @_builtins.property
    @pulumi.getter(name="efloCnp")
    def eflo_cnp(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "eflo_cnp")

    @_builtins.property
    @pulumi.getter(name="efloController")
    def eflo_controller(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom efloctrl endpoints.
        """
        return pulumi.get(self, "eflo_controller")

    @_builtins.property
    @pulumi.getter
    def ehpc(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom ehpc endpoints.
        """
        return pulumi.get(self, "ehpc")

    @_builtins.property
    @pulumi.getter
    def ehs(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom ehs endpoints.
        """
        return pulumi.get(self, "ehs")

    @_builtins.property
    @pulumi.getter
    def eipanycast(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom eipanycast endpoints.
        """
        return pulumi.get(self, "eipanycast")

    @_builtins.property
    @pulumi.getter
    def elasticsearch(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom Elasticsearch endpoints.
        """
        return pulumi.get(self, "elasticsearch")

    @_builtins.property
    @pulumi.getter
    def emr(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom EMR endpoints.
        """
        return pulumi.get(self, "emr")

    @_builtins.property
    @pulumi.getter
    def ens(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom ens endpoints.
        """
        return pulumi.get(self, "ens")

    @_builtins.property
    @pulumi.getter
    def esa(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "esa")

    @_builtins.property
    @pulumi.getter
    def ess(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom Autoscaling endpoints.
        """
        return pulumi.get(self, "ess")

    @_builtins.property
    @pulumi.getter
    def eventbridge(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom eventbridge_share endpoints.
        """
        return pulumi.get(self, "eventbridge")

    @_builtins.property
    @pulumi.getter
    def fc(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom Function Computing endpoints.
        """
        return pulumi.get(self, "fc")

    @_builtins.property
    @pulumi.getter(name="fcOpen")
    def fc_open(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom Function Computing endpoints.
        """
        return pulumi.get(self, "fc_open")

    @_builtins.property
    @pulumi.getter
    def fnf(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom fnf endpoints.
        """
        return pulumi.get(self, "fnf")

    @_builtins.property
    @pulumi.getter
    def ga(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom ga endpoints.
        """
        return pulumi.get(self, "ga")

    @_builtins.property
    @pulumi.getter
    def gaplus(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom gaplus endpoints.
        """
        return pulumi.get(self, "gaplus")

    @_builtins.property
    @pulumi.getter
    def gdb(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom gds endpoints.
        """
        return pulumi.get(self, "gdb")

    @_builtins.property
    @pulumi.getter
    def gds(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom gds endpoints.
        """
        return pulumi.get(self, "gds")

    @_builtins.property
    @pulumi.getter
    def gpdb(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom GPDB endpoints.
        """
        return pulumi.get(self, "gpdb")

    @_builtins.property
    @pulumi.getter
    def gwlb(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "gwlb")

    @_builtins.property
    @pulumi.getter
    def gwsecd(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom gwsecd endpoints.
        """
        return pulumi.get(self, "gwsecd")

    @_builtins.property
    @pulumi.getter
    def hbr(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom hbr endpoints.
        """
        return pulumi.get(self, "hbr")

    @_builtins.property
    @pulumi.getter(name="hcsSgw")
    def hcs_sgw(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom hcs_sgw endpoints.
        """
        return pulumi.get(self, "hcs_sgw")

    @_builtins.property
    @pulumi.getter
    def hitsdb(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom hitsdb endpoints.
        """
        return pulumi.get(self, "hitsdb")

    @_builtins.property
    @pulumi.getter
    def imm(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom imm endpoints.
        """
        return pulumi.get(self, "imm")

    @_builtins.property
    @pulumi.getter
    def imp(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom imp endpoints.
        """
        return pulumi.get(self, "imp")

    @_builtins.property
    @pulumi.getter
    def ims(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom ims endpoints.
        """
        return pulumi.get(self, "ims")

    @_builtins.property
    @pulumi.getter
    def iot(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom iot endpoints.
        """
        return pulumi.get(self, "iot")

    @_builtins.property
    @pulumi.getter
    def kms(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom KMS endpoints.
        """
        return pulumi.get(self, "kms")

    @_builtins.property
    @pulumi.getter
    def kvstore(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom R-KVStore endpoints.
        """
        return pulumi.get(self, "kvstore")

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom Location Service endpoints.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def log(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom Log Service endpoints.
        """
        return pulumi.get(self, "log")

    @_builtins.property
    @pulumi.getter
    def market(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom Market Place endpoints.
        """
        return pulumi.get(self, "market")

    @_builtins.property
    @pulumi.getter
    def maxcompute(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom MaxCompute endpoints.
        """
        return pulumi.get(self, "maxcompute")

    @_builtins.property
    @pulumi.getter
    def mhub(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom mhub endpoints.
        """
        return pulumi.get(self, "mhub")

    @_builtins.property
    @pulumi.getter
    def mns(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom MNS endpoints.
        """
        return pulumi.get(self, "mns")

    @_builtins.property
    @pulumi.getter(name="mnsOpen")
    def mns_open(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom MNS endpoints.
        """
        return pulumi.get(self, "mns_open")

    @_builtins.property
    @pulumi.getter
    def mscopensubscription(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom mscopensubscription endpoints.
        """
        return pulumi.get(self, "mscopensubscription")

    @_builtins.property
    @pulumi.getter
    def mse(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom mse endpoints.
        """
        return pulumi.get(self, "mse")

    @_builtins.property
    @pulumi.getter
    def nas(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom NAS endpoints.
        """
        return pulumi.get(self, "nas")

    @_builtins.property
    @pulumi.getter
    def nlb(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom nlb endpoints.
        """
        return pulumi.get(self, "nlb")

    @_builtins.property
    @pulumi.getter
    def oceanbase(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom oceanbase endpoints.
        """
        return pulumi.get(self, "oceanbase")

    @_builtins.property
    @pulumi.getter
    def oceanbasepro(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom oceanbase endpoints.
        """
        return pulumi.get(self, "oceanbasepro")

    @_builtins.property
    @pulumi.getter
    def ons(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom ONS endpoints.
        """
        return pulumi.get(self, "ons")

    @_builtins.property
    @pulumi.getter
    def onsproxy(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom onsproxy endpoints.
        """
        return pulumi.get(self, "onsproxy")

    @_builtins.property
    @pulumi.getter
    def oos(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom oos endpoints.
        """
        return pulumi.get(self, "oos")

    @_builtins.property
    @pulumi.getter
    def opensearch(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom opensearch endpoints.
        """
        return pulumi.get(self, "opensearch")

    @_builtins.property
    @pulumi.getter
    def oss(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom OSS endpoints.
        """
        return pulumi.get(self, "oss")

    @_builtins.property
    @pulumi.getter
    def ots(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom Table Store endpoints.
        """
        return pulumi.get(self, "ots")

    @_builtins.property
    @pulumi.getter
    def polardb(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom PolarDB endpoints.
        """
        return pulumi.get(self, "polardb")

    @_builtins.property
    @pulumi.getter
    def polardbx(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom DRDS endpoints.
        """
        return pulumi.get(self, "polardbx")

    @_builtins.property
    @pulumi.getter
    def privatelink(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom privatelink endpoints.
        """
        return pulumi.get(self, "privatelink")

    @_builtins.property
    @pulumi.getter
    def pvtz(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom Private Zone endpoints.
        """
        return pulumi.get(self, "pvtz")

    @_builtins.property
    @pulumi.getter
    def quickbi(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom quickbi endpoints.
        """
        return pulumi.get(self, "quickbi")

    @_builtins.property
    @pulumi.getter(name="quickbiPublic")
    def quickbi_public(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom quickbi endpoints.
        """
        return pulumi.get(self, "quickbi_public")

    @_builtins.property
    @pulumi.getter
    def quotas(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom quotas endpoints.
        """
        return pulumi.get(self, "quotas")

    @_builtins.property
    @pulumi.getter(name="rKvstore")
    def r_kvstore(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom r_kvstore endpoints.
        """
        return pulumi.get(self, "r_kvstore")

    @_builtins.property
    @pulumi.getter
    def ram(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom RAM endpoints.
        """
        return pulumi.get(self, "ram")

    @_builtins.property
    @pulumi.getter
    def rds(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom RDS endpoints.
        """
        return pulumi.get(self, "rds")

    @_builtins.property
    @pulumi.getter
    def redisa(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom redisa endpoints.
        """
        return pulumi.get(self, "redisa")

    @_builtins.property
    @pulumi.getter
    def resourcemanager(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom resourcemanager endpoints.
        """
        return pulumi.get(self, "resourcemanager")

    @_builtins.property
    @pulumi.getter
    def resourcesharing(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "resourcesharing")

    @_builtins.property
    @pulumi.getter
    def ressharing(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom resourcesharing endpoints.
        """
        return pulumi.get(self, "ressharing")

    @_builtins.property
    @pulumi.getter
    def rocketmq(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "rocketmq")

    @_builtins.property
    @pulumi.getter
    def ros(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom ros endpoints.
        """
        return pulumi.get(self, "ros")

    @_builtins.property
    @pulumi.getter
    def sae(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom serverless endpoints.
        """
        return pulumi.get(self, "sae")

    @_builtins.property
    @pulumi.getter
    def sas(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom sas endpoints.
        """
        return pulumi.get(self, "sas")

    @_builtins.property
    @pulumi.getter
    def scdn(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom scdn endpoints.
        """
        return pulumi.get(self, "scdn")

    @_builtins.property
    @pulumi.getter
    def schedulerx2(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom edasschedulerx endpoints.
        """
        return pulumi.get(self, "schedulerx2")

    @_builtins.property
    @pulumi.getter
    def sddp(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom sddp endpoints.
        """
        return pulumi.get(self, "sddp")

    @_builtins.property
    @pulumi.getter
    def selectdb(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom selectdb endpoints.
        """
        return pulumi.get(self, "selectdb")

    @_builtins.property
    @pulumi.getter
    def serverless(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom serverless endpoints.
        """
        return pulumi.get(self, "serverless")

    @_builtins.property
    @pulumi.getter
    def servicecatalog(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom srvcatalog endpoints.
        """
        return pulumi.get(self, "servicecatalog")

    @_builtins.property
    @pulumi.getter
    def servicemesh(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom servicemesh endpoints.
        """
        return pulumi.get(self, "servicemesh")

    @_builtins.property
    @pulumi.getter
    def sgw(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom sgw endpoints.
        """
        return pulumi.get(self, "sgw")

    @_builtins.property
    @pulumi.getter
    def slb(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom SLB endpoints.
        """
        return pulumi.get(self, "slb")

    @_builtins.property
    @pulumi.getter
    def smartag(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom smartag endpoints.
        """
        return pulumi.get(self, "smartag")

    @_builtins.property
    @pulumi.getter
    def srvcatalog(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom srvcatalog endpoints.
        """
        return pulumi.get(self, "srvcatalog")

    @_builtins.property
    @pulumi.getter
    def sts(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom STS endpoints.
        """
        return pulumi.get(self, "sts")

    @_builtins.property
    @pulumi.getter
    def swas(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom swas endpoints.
        """
        return pulumi.get(self, "swas")

    @_builtins.property
    @pulumi.getter(name="swasOpen")
    def swas_open(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom swas endpoints.
        """
        return pulumi.get(self, "swas_open")

    @_builtins.property
    @pulumi.getter
    def tag(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom tag endpoints.
        """
        return pulumi.get(self, "tag")

    @_builtins.property
    @pulumi.getter
    def vod(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom vod endpoints.
        """
        return pulumi.get(self, "vod")

    @_builtins.property
    @pulumi.getter
    def vpc(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom VPC and VPN endpoints.
        """
        return pulumi.get(self, "vpc")

    @_builtins.property
    @pulumi.getter
    def vpcipam(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "vpcipam")

    @_builtins.property
    @pulumi.getter
    def vpcpeer(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom vpcpeer endpoints.
        """
        return pulumi.get(self, "vpcpeer")

    @_builtins.property
    @pulumi.getter
    def vs(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom vs endpoints.
        """
        return pulumi.get(self, "vs")

    @_builtins.property
    @pulumi.getter
    def waf(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom waf endpoints.
        """
        return pulumi.get(self, "waf")

    @_builtins.property
    @pulumi.getter(name="wafOpenapi")
    def waf_openapi(self) -> Optional[_builtins.str]:
        """
        Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom waf_openapi endpoints.
        """
        return pulumi.get(self, "waf_openapi")


@pulumi.output_type
class SignVersion(dict):
    def __init__(__self__, *,
                 oss: Optional[_builtins.str] = None,
                 sls: Optional[_builtins.str] = None):
        if oss is not None:
            pulumi.set(__self__, "oss", oss)
        if sls is not None:
            pulumi.set(__self__, "sls", sls)

    @_builtins.property
    @pulumi.getter
    def oss(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "oss")

    @_builtins.property
    @pulumi.getter
    def sls(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "sls")


