# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'VscMountPointInstanceArgs',
    'VscMountPointInstanceArgsDict',
    'VscMountPointInstanceVscArgs',
    'VscMountPointInstanceVscArgsDict',
]

MYPY = False

if not MYPY:
    class VscMountPointInstanceArgsDict(TypedDict):
        instance_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The ID of the ECS instance to which the HDFS file system is mounted.
        """
        status: NotRequired[pulumi.Input[_builtins.str]]
        """
        The status of the ECS instance on which the HDFS file system is mounted.
        """
        vscs: NotRequired[pulumi.Input[Sequence[pulumi.Input['VscMountPointInstanceVscArgsDict']]]]
        """
        The VSC list of mounted HDFS file systems.
        """
elif False:
    VscMountPointInstanceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VscMountPointInstanceArgs:
    def __init__(__self__, *,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 vscs: Optional[pulumi.Input[Sequence[pulumi.Input['VscMountPointInstanceVscArgs']]]] = None):
        """
        :param pulumi.Input[_builtins.str] instance_id: The ID of the ECS instance to which the HDFS file system is mounted.
        :param pulumi.Input[_builtins.str] status: The status of the ECS instance on which the HDFS file system is mounted.
        :param pulumi.Input[Sequence[pulumi.Input['VscMountPointInstanceVscArgs']]] vscs: The VSC list of mounted HDFS file systems.
        """
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if vscs is not None:
            pulumi.set(__self__, "vscs", vscs)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the ECS instance to which the HDFS file system is mounted.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the ECS instance on which the HDFS file system is mounted.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def vscs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VscMountPointInstanceVscArgs']]]]:
        """
        The VSC list of mounted HDFS file systems.
        """
        return pulumi.get(self, "vscs")

    @vscs.setter
    def vscs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VscMountPointInstanceVscArgs']]]]):
        pulumi.set(self, "vscs", value)


if not MYPY:
    class VscMountPointInstanceVscArgsDict(TypedDict):
        vsc_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        VSC Channel primary key representation, used to retrieve the specified VSC Channel.
        """
        vsc_status: NotRequired[pulumi.Input[_builtins.str]]
        """
        VSC Mount status.
        """
        vsc_type: NotRequired[pulumi.Input[_builtins.str]]
        """
        The VSC type.
        """
elif False:
    VscMountPointInstanceVscArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VscMountPointInstanceVscArgs:
    def __init__(__self__, *,
                 vsc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vsc_status: Optional[pulumi.Input[_builtins.str]] = None,
                 vsc_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] vsc_id: VSC Channel primary key representation, used to retrieve the specified VSC Channel.
        :param pulumi.Input[_builtins.str] vsc_status: VSC Mount status.
        :param pulumi.Input[_builtins.str] vsc_type: The VSC type.
        """
        if vsc_id is not None:
            pulumi.set(__self__, "vsc_id", vsc_id)
        if vsc_status is not None:
            pulumi.set(__self__, "vsc_status", vsc_status)
        if vsc_type is not None:
            pulumi.set(__self__, "vsc_type", vsc_type)

    @_builtins.property
    @pulumi.getter(name="vscId")
    def vsc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        VSC Channel primary key representation, used to retrieve the specified VSC Channel.
        """
        return pulumi.get(self, "vsc_id")

    @vsc_id.setter
    def vsc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vsc_id", value)

    @_builtins.property
    @pulumi.getter(name="vscStatus")
    def vsc_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        VSC Mount status.
        """
        return pulumi.get(self, "vsc_status")

    @vsc_status.setter
    def vsc_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vsc_status", value)

    @_builtins.property
    @pulumi.getter(name="vscType")
    def vsc_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The VSC type.
        """
        return pulumi.get(self, "vsc_type")

    @vsc_type.setter
    def vsc_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vsc_type", value)


