# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetInstancesResult',
    'AwaitableGetInstancesResult',
    'get_instances',
    'get_instances_output',
]

@pulumi.output_type
class GetInstancesResult:
    """
    A collection of values returned by getInstances.
    """
    def __init__(__self__, enable_details=None, id=None, ids=None, image_id=None, instance_name=None, instance_type=None, instances=None, key_pair_name=None, name_regex=None, names=None, output_file=None, payment_type=None, resolution=None, status=None, zone_id=None):
        if enable_details and not isinstance(enable_details, bool):
            raise TypeError("Expected argument 'enable_details' to be a bool")
        pulumi.set(__self__, "enable_details", enable_details)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if image_id and not isinstance(image_id, str):
            raise TypeError("Expected argument 'image_id' to be a str")
        pulumi.set(__self__, "image_id", image_id)
        if instance_name and not isinstance(instance_name, str):
            raise TypeError("Expected argument 'instance_name' to be a str")
        pulumi.set(__self__, "instance_name", instance_name)
        if instance_type and not isinstance(instance_type, str):
            raise TypeError("Expected argument 'instance_type' to be a str")
        pulumi.set(__self__, "instance_type", instance_type)
        if instances and not isinstance(instances, list):
            raise TypeError("Expected argument 'instances' to be a list")
        pulumi.set(__self__, "instances", instances)
        if key_pair_name and not isinstance(key_pair_name, str):
            raise TypeError("Expected argument 'key_pair_name' to be a str")
        pulumi.set(__self__, "key_pair_name", key_pair_name)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if payment_type and not isinstance(payment_type, str):
            raise TypeError("Expected argument 'payment_type' to be a str")
        pulumi.set(__self__, "payment_type", payment_type)
        if resolution and not isinstance(resolution, str):
            raise TypeError("Expected argument 'resolution' to be a str")
        pulumi.set(__self__, "resolution", resolution)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if zone_id and not isinstance(zone_id, str):
            raise TypeError("Expected argument 'zone_id' to be a str")
        pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter(name="enableDetails")
    def enable_details(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "enable_details")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter(name="imageId")
    def image_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "image_id")

    @_builtins.property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "instance_name")

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "instance_type")

    @_builtins.property
    @pulumi.getter
    def instances(self) -> Sequence['outputs.GetInstancesInstanceResult']:
        return pulumi.get(self, "instances")

    @_builtins.property
    @pulumi.getter(name="keyPairName")
    def key_pair_name(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "key_pair_name")

    @_builtins.property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name_regex")

    @_builtins.property
    @pulumi.getter
    def names(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "names")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "payment_type")

    @_builtins.property
    @pulumi.getter
    def resolution(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "resolution")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "zone_id")


class AwaitableGetInstancesResult(GetInstancesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetInstancesResult(
            enable_details=self.enable_details,
            id=self.id,
            ids=self.ids,
            image_id=self.image_id,
            instance_name=self.instance_name,
            instance_type=self.instance_type,
            instances=self.instances,
            key_pair_name=self.key_pair_name,
            name_regex=self.name_regex,
            names=self.names,
            output_file=self.output_file,
            payment_type=self.payment_type,
            resolution=self.resolution,
            status=self.status,
            zone_id=self.zone_id)


def get_instances(enable_details: Optional[_builtins.bool] = None,
                  ids: Optional[Sequence[_builtins.str]] = None,
                  image_id: Optional[_builtins.str] = None,
                  instance_name: Optional[_builtins.str] = None,
                  instance_type: Optional[_builtins.str] = None,
                  key_pair_name: Optional[_builtins.str] = None,
                  name_regex: Optional[_builtins.str] = None,
                  output_file: Optional[_builtins.str] = None,
                  payment_type: Optional[_builtins.str] = None,
                  resolution: Optional[_builtins.str] = None,
                  status: Optional[_builtins.str] = None,
                  zone_id: Optional[_builtins.str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetInstancesResult:
    """
    This data source provides the Ecp Instances of the current Alibaba Cloud user.

    > **NOTE:** Available in v1.158.0+.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    default = alicloud.ecp.get_zones()
    default_get_instance_types = alicloud.ecp.get_instance_types()
    count_size = len(default.zones)
    zone_id = count_size.apply(lambda count_size: default.zones[count_size - 1]).apply(lambda obj: obj.zone_id)
    instance_type_count_size = len(default_get_instance_types.instance_types)
    instance_type = instance_type_count_size.apply(lambda instance_type_count_size: default_get_instance_types.instance_types[instance_type_count_size - 1]).apply(lambda obj: obj.instance_type)
    default_get_networks = alicloud.vpc.get_networks(name_regex="default-NODELETING")
    default_get_switches = alicloud.vpc.get_switches(vpc_id=default_get_networks.ids[0],
        zone_id=zone_id)
    group = alicloud.ecs.SecurityGroup("group",
        name=name,
        vpc_id=default_get_networks.ids[0])
    default_key_pair = alicloud.ecp.KeyPair("default",
        key_pair_name=name,
        public_key_body="ssh-rsa AAAAB3Nza12345678qwertyuudsfsg")
    default_instance = alicloud.ecp.Instance("default",
        instance_name=name,
        description=name,
        force=True,
        key_pair_name=default_key_pair.key_pair_name,
        vswitch_id=default_get_switches.ids[0],
        image_id="android_9_0_0_release_2851157_20211201.vhd",
        instance_type=instance_type_count_size.apply(lambda instance_type_count_size: default_get_instance_types.instance_types[instance_type_count_size - 1]).apply(lambda obj: obj.instance_type),
        payment_type="PayAsYouGo")
    ```


    :param Sequence[_builtins.str] ids: A list of Ecp Instances IDs.
    :param _builtins.str image_id: The ID Of The Image.
    :param _builtins.str instance_name: The name of the instance. It must be 2 to 128 characters in length and must start with an
           uppercase letter or Chinese. It cannot start with http:// or https. It can contain Chinese, English, numbers,
           half-width colons (:), underscores (_), half-width periods (.), or dashes (-). The default value is the InstanceId of
           the instance.
    :param _builtins.str instance_type: Instance Type.
    :param _builtins.str key_pair_name: The name of the key pair of the mobile phone instance.
    :param _builtins.str name_regex: A regex string to filter results by mobile phone name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str payment_type: The payment type.Valid values: `PayAsYouGo`,`Subscription`
    :param _builtins.str resolution: The selected resolution for the cloud mobile phone instance.
    :param _builtins.str status: Instance status. Valid values: `Pending`, `Running`, `Starting`, `Stopped`, `Stopping`
           .
    """
    __args__ = dict()
    __args__['enableDetails'] = enable_details
    __args__['ids'] = ids
    __args__['imageId'] = image_id
    __args__['instanceName'] = instance_name
    __args__['instanceType'] = instance_type
    __args__['keyPairName'] = key_pair_name
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['paymentType'] = payment_type
    __args__['resolution'] = resolution
    __args__['status'] = status
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:ecp/getInstances:getInstances', __args__, opts=opts, typ=GetInstancesResult).value

    return AwaitableGetInstancesResult(
        enable_details=pulumi.get(__ret__, 'enable_details'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        image_id=pulumi.get(__ret__, 'image_id'),
        instance_name=pulumi.get(__ret__, 'instance_name'),
        instance_type=pulumi.get(__ret__, 'instance_type'),
        instances=pulumi.get(__ret__, 'instances'),
        key_pair_name=pulumi.get(__ret__, 'key_pair_name'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        names=pulumi.get(__ret__, 'names'),
        output_file=pulumi.get(__ret__, 'output_file'),
        payment_type=pulumi.get(__ret__, 'payment_type'),
        resolution=pulumi.get(__ret__, 'resolution'),
        status=pulumi.get(__ret__, 'status'),
        zone_id=pulumi.get(__ret__, 'zone_id'))
def get_instances_output(enable_details: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                         ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                         image_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         instance_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         instance_type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         key_pair_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         name_regex: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         payment_type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         resolution: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         status: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         zone_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetInstancesResult]:
    """
    This data source provides the Ecp Instances of the current Alibaba Cloud user.

    > **NOTE:** Available in v1.158.0+.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    default = alicloud.ecp.get_zones()
    default_get_instance_types = alicloud.ecp.get_instance_types()
    count_size = len(default.zones)
    zone_id = count_size.apply(lambda count_size: default.zones[count_size - 1]).apply(lambda obj: obj.zone_id)
    instance_type_count_size = len(default_get_instance_types.instance_types)
    instance_type = instance_type_count_size.apply(lambda instance_type_count_size: default_get_instance_types.instance_types[instance_type_count_size - 1]).apply(lambda obj: obj.instance_type)
    default_get_networks = alicloud.vpc.get_networks(name_regex="default-NODELETING")
    default_get_switches = alicloud.vpc.get_switches(vpc_id=default_get_networks.ids[0],
        zone_id=zone_id)
    group = alicloud.ecs.SecurityGroup("group",
        name=name,
        vpc_id=default_get_networks.ids[0])
    default_key_pair = alicloud.ecp.KeyPair("default",
        key_pair_name=name,
        public_key_body="ssh-rsa AAAAB3Nza12345678qwertyuudsfsg")
    default_instance = alicloud.ecp.Instance("default",
        instance_name=name,
        description=name,
        force=True,
        key_pair_name=default_key_pair.key_pair_name,
        vswitch_id=default_get_switches.ids[0],
        image_id="android_9_0_0_release_2851157_20211201.vhd",
        instance_type=instance_type_count_size.apply(lambda instance_type_count_size: default_get_instance_types.instance_types[instance_type_count_size - 1]).apply(lambda obj: obj.instance_type),
        payment_type="PayAsYouGo")
    ```


    :param Sequence[_builtins.str] ids: A list of Ecp Instances IDs.
    :param _builtins.str image_id: The ID Of The Image.
    :param _builtins.str instance_name: The name of the instance. It must be 2 to 128 characters in length and must start with an
           uppercase letter or Chinese. It cannot start with http:// or https. It can contain Chinese, English, numbers,
           half-width colons (:), underscores (_), half-width periods (.), or dashes (-). The default value is the InstanceId of
           the instance.
    :param _builtins.str instance_type: Instance Type.
    :param _builtins.str key_pair_name: The name of the key pair of the mobile phone instance.
    :param _builtins.str name_regex: A regex string to filter results by mobile phone name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str payment_type: The payment type.Valid values: `PayAsYouGo`,`Subscription`
    :param _builtins.str resolution: The selected resolution for the cloud mobile phone instance.
    :param _builtins.str status: Instance status. Valid values: `Pending`, `Running`, `Starting`, `Stopped`, `Stopping`
           .
    """
    __args__ = dict()
    __args__['enableDetails'] = enable_details
    __args__['ids'] = ids
    __args__['imageId'] = image_id
    __args__['instanceName'] = instance_name
    __args__['instanceType'] = instance_type
    __args__['keyPairName'] = key_pair_name
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['paymentType'] = payment_type
    __args__['resolution'] = resolution
    __args__['status'] = status
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:ecp/getInstances:getInstances', __args__, opts=opts, typ=GetInstancesResult)
    return __ret__.apply(lambda __response__: GetInstancesResult(
        enable_details=pulumi.get(__response__, 'enable_details'),
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        image_id=pulumi.get(__response__, 'image_id'),
        instance_name=pulumi.get(__response__, 'instance_name'),
        instance_type=pulumi.get(__response__, 'instance_type'),
        instances=pulumi.get(__response__, 'instances'),
        key_pair_name=pulumi.get(__response__, 'key_pair_name'),
        name_regex=pulumi.get(__response__, 'name_regex'),
        names=pulumi.get(__response__, 'names'),
        output_file=pulumi.get(__response__, 'output_file'),
        payment_type=pulumi.get(__response__, 'payment_type'),
        resolution=pulumi.get(__response__, 'resolution'),
        status=pulumi.get(__response__, 'status'),
        zone_id=pulumi.get(__response__, 'zone_id')))
