# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['KeyPairArgs', 'KeyPair']

@pulumi.input_type
class KeyPairArgs:
    def __init__(__self__, *,
                 key_pair_name: pulumi.Input[_builtins.str],
                 public_key_body: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a KeyPair resource.
        :param pulumi.Input[_builtins.str] key_pair_name: The Key Name.
        :param pulumi.Input[_builtins.str] public_key_body: The public key body.
        """
        pulumi.set(__self__, "key_pair_name", key_pair_name)
        pulumi.set(__self__, "public_key_body", public_key_body)

    @_builtins.property
    @pulumi.getter(name="keyPairName")
    def key_pair_name(self) -> pulumi.Input[_builtins.str]:
        """
        The Key Name.
        """
        return pulumi.get(self, "key_pair_name")

    @key_pair_name.setter
    def key_pair_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "key_pair_name", value)

    @_builtins.property
    @pulumi.getter(name="publicKeyBody")
    def public_key_body(self) -> pulumi.Input[_builtins.str]:
        """
        The public key body.
        """
        return pulumi.get(self, "public_key_body")

    @public_key_body.setter
    def public_key_body(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "public_key_body", value)


@pulumi.input_type
class _KeyPairState:
    def __init__(__self__, *,
                 key_pair_name: Optional[pulumi.Input[_builtins.str]] = None,
                 public_key_body: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering KeyPair resources.
        :param pulumi.Input[_builtins.str] key_pair_name: The Key Name.
        :param pulumi.Input[_builtins.str] public_key_body: The public key body.
        """
        if key_pair_name is not None:
            pulumi.set(__self__, "key_pair_name", key_pair_name)
        if public_key_body is not None:
            pulumi.set(__self__, "public_key_body", public_key_body)

    @_builtins.property
    @pulumi.getter(name="keyPairName")
    def key_pair_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Key Name.
        """
        return pulumi.get(self, "key_pair_name")

    @key_pair_name.setter
    def key_pair_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_pair_name", value)

    @_builtins.property
    @pulumi.getter(name="publicKeyBody")
    def public_key_body(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The public key body.
        """
        return pulumi.get(self, "public_key_body")

    @public_key_body.setter
    def public_key_body(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_key_body", value)


@pulumi.type_token("alicloud:ecp/keyPair:KeyPair")
class KeyPair(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 key_pair_name: Optional[pulumi.Input[_builtins.str]] = None,
                 public_key_body: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Elastic Cloud Phone (ECP) Key Pair resource.

        For information about Elastic Cloud Phone (ECP) Key Pair and how to use it, see [What is Key Pair](https://next.api.aliyun.com/document/cloudphone/2020-12-30/ImportImage).

        > **NOTE:** Available since v1.130.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        example = alicloud.ecp.KeyPair("example",
            key_pair_name="my-KeyPair",
            public_key_body="ssh-rsa AAAAxxxxxxxxxxtyuudsfsg")
        ```

        ## Import

        Elastic Cloud Phone (ECP) Key Pair can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ecp/keyPair:KeyPair example <key_pair_name>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] key_pair_name: The Key Name.
        :param pulumi.Input[_builtins.str] public_key_body: The public key body.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: KeyPairArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Elastic Cloud Phone (ECP) Key Pair resource.

        For information about Elastic Cloud Phone (ECP) Key Pair and how to use it, see [What is Key Pair](https://next.api.aliyun.com/document/cloudphone/2020-12-30/ImportImage).

        > **NOTE:** Available since v1.130.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        example = alicloud.ecp.KeyPair("example",
            key_pair_name="my-KeyPair",
            public_key_body="ssh-rsa AAAAxxxxxxxxxxtyuudsfsg")
        ```

        ## Import

        Elastic Cloud Phone (ECP) Key Pair can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ecp/keyPair:KeyPair example <key_pair_name>
        ```

        :param str resource_name: The name of the resource.
        :param KeyPairArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(KeyPairArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 key_pair_name: Optional[pulumi.Input[_builtins.str]] = None,
                 public_key_body: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = KeyPairArgs.__new__(KeyPairArgs)

            if key_pair_name is None and not opts.urn:
                raise TypeError("Missing required property 'key_pair_name'")
            __props__.__dict__["key_pair_name"] = key_pair_name
            if public_key_body is None and not opts.urn:
                raise TypeError("Missing required property 'public_key_body'")
            __props__.__dict__["public_key_body"] = public_key_body
        super(KeyPair, __self__).__init__(
            'alicloud:ecp/keyPair:KeyPair',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            key_pair_name: Optional[pulumi.Input[_builtins.str]] = None,
            public_key_body: Optional[pulumi.Input[_builtins.str]] = None) -> 'KeyPair':
        """
        Get an existing KeyPair resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] key_pair_name: The Key Name.
        :param pulumi.Input[_builtins.str] public_key_body: The public key body.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _KeyPairState.__new__(_KeyPairState)

        __props__.__dict__["key_pair_name"] = key_pair_name
        __props__.__dict__["public_key_body"] = public_key_body
        return KeyPair(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="keyPairName")
    def key_pair_name(self) -> pulumi.Output[_builtins.str]:
        """
        The Key Name.
        """
        return pulumi.get(self, "key_pair_name")

    @_builtins.property
    @pulumi.getter(name="publicKeyBody")
    def public_key_body(self) -> pulumi.Output[_builtins.str]:
        """
        The public key body.
        """
        return pulumi.get(self, "public_key_body")

