# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['EcsDiskArgs', 'EcsDisk']

@pulumi.input_type
class EcsDiskArgs:
    def __init__(__self__, *,
                 advanced_features: Optional[pulumi.Input[_builtins.str]] = None,
                 availability_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 bursting_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 category: Optional[pulumi.Input[_builtins.str]] = None,
                 delete_auto_snapshot: Optional[pulumi.Input[_builtins.bool]] = None,
                 delete_with_instance: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_name: Optional[pulumi.Input[_builtins.str]] = None,
                 dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_auto_snapshot: Optional[pulumi.Input[_builtins.bool]] = None,
                 encrypt_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 encrypted: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 multi_attach: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 performance_level: Optional[pulumi.Input[_builtins.str]] = None,
                 provisioned_iops: Optional[pulumi.Input[_builtins.int]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 size: Optional[pulumi.Input[_builtins.int]] = None,
                 snapshot_id: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_set_id: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_set_partition_number: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a EcsDisk resource.
        :param pulumi.Input[_builtins.str] availability_zone: Field `availability_zone` has been deprecated from provider version 1.122.0. New field `zone_id` instead.
        :param pulumi.Input[_builtins.bool] bursting_enabled: Specifies whether to enable the performance burst feature. Valid values: `true`, `false`. **NOTE:** `bursting_enabled` is only valid when `category` is `cloud_auto`.
        :param pulumi.Input[_builtins.str] category: The category of the data disk. Default value: `cloud_efficiency`. Valid Values: `cloud`, `cloud_efficiency`, `cloud_ssd`, `cloud_essd`, `cloud_auto`, `cloud_essd_entry`, `elastic_ephemeral_disk_standard`, `elastic_ephemeral_disk_premium`.
        :param pulumi.Input[_builtins.bool] delete_auto_snapshot: Specifies whether to delete the automatic snapshots of the disk when the disk is released. Default value: `false`.
        :param pulumi.Input[_builtins.bool] delete_with_instance: Specifies whether to release the disk along with its associated instance. Default value: `false`.
        :param pulumi.Input[_builtins.str] description: The description of the disk. The description must be 2 to 256 characters in length and cannot start with http:// or https://.
        :param pulumi.Input[_builtins.str] disk_name: The name of the data disk. The name must be 2 to 128 characters in length and can contain letters, digits, colons (:), underscores (_), periods (.), and hyphens (-). The name must start with a letter.
        :param pulumi.Input[_builtins.bool] dry_run: Specifies whether to check the validity of the request without actually making the request.request Default value: `false`. Valid values:
        :param pulumi.Input[_builtins.bool] enable_auto_snapshot: Specifies whether to enable the automatic snapshot policy feature for the cloud disk. Valid values: `true`, `false`.
        :param pulumi.Input[_builtins.bool] encrypted: Specifies whether to encrypt the disk. Default value: `false`. Valid values:
        :param pulumi.Input[_builtins.str] instance_id: The ID of the instance to which the created subscription disk is automatically attached.
               * After you specify the instance ID, the specified `resource_group_id`, `tags`, and `kms_key_id` parameters are ignored.
               * One of the `zone_id` and `instance_id` must be set but can not be set at the same time.
        :param pulumi.Input[_builtins.str] kms_key_id: The ID of the Key Management Service (KMS) key that is used for the disk. **NOTE:** `kms_key_id` is only valid when `encrypted` is `true`.
        :param pulumi.Input[_builtins.str] multi_attach: Specifies whether to enable the multi-attach feature for the disk. Default value: `Disabled`. Valid values: `Enabled`, `Disabled`. **NOTE:** Currently, `multi_attach` can only be set to `Enabled` when `category` is set to `cloud_essd`.
        :param pulumi.Input[_builtins.str] name: Field `name` has been deprecated from provider version 1.122.0. New field `disk_name` instead.
               
               > **NOTE:** Disk category `cloud` has been outdated, and it only can be used none I/O Optimized ECS instances. Recommend `cloud_efficiency` and `cloud_ssd` disk.
        :param pulumi.Input[_builtins.str] payment_type: The payment type of the disk. Default to `PayAsYouGo`. Valid values: `PayAsYouGo`, `Subscription`. If you want to change the disk payment type, the `instance_id` is required.
        :param pulumi.Input[_builtins.str] performance_level: Specifies the performance level of an ESSD when you create the ESSD. Valid values:
               - `PL0`: A single ESSD delivers up to 10,000 random read/write IOPS.
               - `PL1`: A single ESSD delivers up to 50,000 random read/write IOPS.
               - `PL2`: A single ESSD delivers up to 100,000 random read/write IOPS.
               - `PL3`: A single ESSD delivers up to 1,000,000 random read/write IOPS.
        :param pulumi.Input[_builtins.int] provisioned_iops: The provisioned read/write IOPS of the ESSD AutoPL disk. Valid values: 0 to min{50,000, 1,000 × Capacity - Baseline IOPS}. **NOTE:** `provisioned_iops` is only valid when `category` is `cloud_auto`.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group to which to add the disk.
        :param pulumi.Input[_builtins.int] size: The size of the disk. Unit: GiB. This parameter is required. Valid values:
               - If `category` is set to `cloud`. Valid values: `5` to `2000`.
               - If `category` is set to `cloud_efficiency`. Valid values: `20` to `32768`.
               - If `category` is set to `cloud_ssd`. Valid values: `20` to `32768`.
               - If `category` is set to `cloud_auto`. Valid values: `1` to `65536`.
               - If `category` is set to `cloud_essd_entry`. Valid values: `10` to `32768`.
               - If `category` is set to `elastic_ephemeral_disk_standard`. Valid values: `64` to `8192`.
               - If `category` is set to `elastic_ephemeral_disk_premium`. Valid values: `64` to `8192`.
               - If `category` is set to `cloud_essd`, the valid values are related to `performance_level`. Valid values:
               - If `performance_level` is set to `PL0`. Valid values: `1` to `65536`.
               - If `performance_level` is set to `PL1`. Valid values: `20` to `65536`.
               - If `performance_level` is set to `PL2`. Valid values: `461` to `65536`.
               - If `performance_level` is set to `PL3`. Valid values: `1261` to `65536`.
        :param pulumi.Input[_builtins.str] snapshot_id: The ID of the snapshot to use to create the disk. **NOTE:** If the size of the snapshot specified by `snapshot_id` is larger than the value of `size`, the size of the created disk is equal to the specified snapshot size. If the size of the snapshot specified by `snapshot_id` is smaller than the value of `size`, the size of the created disk is equal to the value of `size`.
        :param pulumi.Input[_builtins.str] storage_set_id: The ID of the storage set.
        :param pulumi.Input[_builtins.int] storage_set_partition_number: The number of partitions in the storage set.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.str] type: The type to expand cloud disks. Valid Values: `online`, `offline`. Default to `offline`.
        :param pulumi.Input[_builtins.str] zone_id: ID of the free zone to which the disk belongs. One of the `zone_id` and `instance_id` must be set but can not be set at the same time.
        """
        if advanced_features is not None:
            pulumi.set(__self__, "advanced_features", advanced_features)
        if availability_zone is not None:
            warnings.warn("""Field `availability_zone` has been deprecated from provider version 1.122.0. New field `zone_id` instead""", DeprecationWarning)
            pulumi.log.warn("""availability_zone is deprecated: Field `availability_zone` has been deprecated from provider version 1.122.0. New field `zone_id` instead""")
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if bursting_enabled is not None:
            pulumi.set(__self__, "bursting_enabled", bursting_enabled)
        if category is not None:
            pulumi.set(__self__, "category", category)
        if delete_auto_snapshot is not None:
            pulumi.set(__self__, "delete_auto_snapshot", delete_auto_snapshot)
        if delete_with_instance is not None:
            pulumi.set(__self__, "delete_with_instance", delete_with_instance)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disk_name is not None:
            pulumi.set(__self__, "disk_name", disk_name)
        if dry_run is not None:
            pulumi.set(__self__, "dry_run", dry_run)
        if enable_auto_snapshot is not None:
            pulumi.set(__self__, "enable_auto_snapshot", enable_auto_snapshot)
        if encrypt_algorithm is not None:
            pulumi.set(__self__, "encrypt_algorithm", encrypt_algorithm)
        if encrypted is not None:
            pulumi.set(__self__, "encrypted", encrypted)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if multi_attach is not None:
            pulumi.set(__self__, "multi_attach", multi_attach)
        if name is not None:
            warnings.warn("""Field `name` has been deprecated from provider version 1.122.0. New field `disk_name` instead.""", DeprecationWarning)
            pulumi.log.warn("""name is deprecated: Field `name` has been deprecated from provider version 1.122.0. New field `disk_name` instead.""")
        if name is not None:
            pulumi.set(__self__, "name", name)
        if payment_type is not None:
            pulumi.set(__self__, "payment_type", payment_type)
        if performance_level is not None:
            pulumi.set(__self__, "performance_level", performance_level)
        if provisioned_iops is not None:
            pulumi.set(__self__, "provisioned_iops", provisioned_iops)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if snapshot_id is not None:
            pulumi.set(__self__, "snapshot_id", snapshot_id)
        if storage_set_id is not None:
            pulumi.set(__self__, "storage_set_id", storage_set_id)
        if storage_set_partition_number is not None:
            pulumi.set(__self__, "storage_set_partition_number", storage_set_partition_number)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter(name="advancedFeatures")
    def advanced_features(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "advanced_features")

    @advanced_features.setter
    def advanced_features(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "advanced_features", value)

    @_builtins.property
    @pulumi.getter(name="availabilityZone")
    @_utilities.deprecated("""Field `availability_zone` has been deprecated from provider version 1.122.0. New field `zone_id` instead""")
    def availability_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Field `availability_zone` has been deprecated from provider version 1.122.0. New field `zone_id` instead.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "availability_zone", value)

    @_builtins.property
    @pulumi.getter(name="burstingEnabled")
    def bursting_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable the performance burst feature. Valid values: `true`, `false`. **NOTE:** `bursting_enabled` is only valid when `category` is `cloud_auto`.
        """
        return pulumi.get(self, "bursting_enabled")

    @bursting_enabled.setter
    def bursting_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "bursting_enabled", value)

    @_builtins.property
    @pulumi.getter
    def category(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The category of the data disk. Default value: `cloud_efficiency`. Valid Values: `cloud`, `cloud_efficiency`, `cloud_ssd`, `cloud_essd`, `cloud_auto`, `cloud_essd_entry`, `elastic_ephemeral_disk_standard`, `elastic_ephemeral_disk_premium`.
        """
        return pulumi.get(self, "category")

    @category.setter
    def category(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "category", value)

    @_builtins.property
    @pulumi.getter(name="deleteAutoSnapshot")
    def delete_auto_snapshot(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to delete the automatic snapshots of the disk when the disk is released. Default value: `false`.
        """
        return pulumi.get(self, "delete_auto_snapshot")

    @delete_auto_snapshot.setter
    def delete_auto_snapshot(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "delete_auto_snapshot", value)

    @_builtins.property
    @pulumi.getter(name="deleteWithInstance")
    def delete_with_instance(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to release the disk along with its associated instance. Default value: `false`.
        """
        return pulumi.get(self, "delete_with_instance")

    @delete_with_instance.setter
    def delete_with_instance(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "delete_with_instance", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the disk. The description must be 2 to 256 characters in length and cannot start with http:// or https://.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="diskName")
    def disk_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the data disk. The name must be 2 to 128 characters in length and can contain letters, digits, colons (:), underscores (_), periods (.), and hyphens (-). The name must start with a letter.
        """
        return pulumi.get(self, "disk_name")

    @disk_name.setter
    def disk_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "disk_name", value)

    @_builtins.property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to check the validity of the request without actually making the request.request Default value: `false`. Valid values:
        """
        return pulumi.get(self, "dry_run")

    @dry_run.setter
    def dry_run(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "dry_run", value)

    @_builtins.property
    @pulumi.getter(name="enableAutoSnapshot")
    def enable_auto_snapshot(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable the automatic snapshot policy feature for the cloud disk. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "enable_auto_snapshot")

    @enable_auto_snapshot.setter
    def enable_auto_snapshot(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_auto_snapshot", value)

    @_builtins.property
    @pulumi.getter(name="encryptAlgorithm")
    def encrypt_algorithm(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "encrypt_algorithm")

    @encrypt_algorithm.setter
    def encrypt_algorithm(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "encrypt_algorithm", value)

    @_builtins.property
    @pulumi.getter
    def encrypted(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to encrypt the disk. Default value: `false`. Valid values:
        """
        return pulumi.get(self, "encrypted")

    @encrypted.setter
    def encrypted(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "encrypted", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the instance to which the created subscription disk is automatically attached.
        * After you specify the instance ID, the specified `resource_group_id`, `tags`, and `kms_key_id` parameters are ignored.
        * One of the `zone_id` and `instance_id` must be set but can not be set at the same time.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Key Management Service (KMS) key that is used for the disk. **NOTE:** `kms_key_id` is only valid when `encrypted` is `true`.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kms_key_id", value)

    @_builtins.property
    @pulumi.getter(name="multiAttach")
    def multi_attach(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether to enable the multi-attach feature for the disk. Default value: `Disabled`. Valid values: `Enabled`, `Disabled`. **NOTE:** Currently, `multi_attach` can only be set to `Enabled` when `category` is set to `cloud_essd`.
        """
        return pulumi.get(self, "multi_attach")

    @multi_attach.setter
    def multi_attach(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "multi_attach", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field `name` has been deprecated from provider version 1.122.0. New field `disk_name` instead.""")
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Field `name` has been deprecated from provider version 1.122.0. New field `disk_name` instead.

        > **NOTE:** Disk category `cloud` has been outdated, and it only can be used none I/O Optimized ECS instances. Recommend `cloud_efficiency` and `cloud_ssd` disk.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The payment type of the disk. Default to `PayAsYouGo`. Valid values: `PayAsYouGo`, `Subscription`. If you want to change the disk payment type, the `instance_id` is required.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "payment_type", value)

    @_builtins.property
    @pulumi.getter(name="performanceLevel")
    def performance_level(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the performance level of an ESSD when you create the ESSD. Valid values:
        - `PL0`: A single ESSD delivers up to 10,000 random read/write IOPS.
        - `PL1`: A single ESSD delivers up to 50,000 random read/write IOPS.
        - `PL2`: A single ESSD delivers up to 100,000 random read/write IOPS.
        - `PL3`: A single ESSD delivers up to 1,000,000 random read/write IOPS.
        """
        return pulumi.get(self, "performance_level")

    @performance_level.setter
    def performance_level(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "performance_level", value)

    @_builtins.property
    @pulumi.getter(name="provisionedIops")
    def provisioned_iops(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The provisioned read/write IOPS of the ESSD AutoPL disk. Valid values: 0 to min{50,000, 1,000 × Capacity - Baseline IOPS}. **NOTE:** `provisioned_iops` is only valid when `category` is `cloud_auto`.
        """
        return pulumi.get(self, "provisioned_iops")

    @provisioned_iops.setter
    def provisioned_iops(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "provisioned_iops", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group to which to add the disk.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The size of the disk. Unit: GiB. This parameter is required. Valid values:
        - If `category` is set to `cloud`. Valid values: `5` to `2000`.
        - If `category` is set to `cloud_efficiency`. Valid values: `20` to `32768`.
        - If `category` is set to `cloud_ssd`. Valid values: `20` to `32768`.
        - If `category` is set to `cloud_auto`. Valid values: `1` to `65536`.
        - If `category` is set to `cloud_essd_entry`. Valid values: `10` to `32768`.
        - If `category` is set to `elastic_ephemeral_disk_standard`. Valid values: `64` to `8192`.
        - If `category` is set to `elastic_ephemeral_disk_premium`. Valid values: `64` to `8192`.
        - If `category` is set to `cloud_essd`, the valid values are related to `performance_level`. Valid values:
        - If `performance_level` is set to `PL0`. Valid values: `1` to `65536`.
        - If `performance_level` is set to `PL1`. Valid values: `20` to `65536`.
        - If `performance_level` is set to `PL2`. Valid values: `461` to `65536`.
        - If `performance_level` is set to `PL3`. Valid values: `1261` to `65536`.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "size", value)

    @_builtins.property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the snapshot to use to create the disk. **NOTE:** If the size of the snapshot specified by `snapshot_id` is larger than the value of `size`, the size of the created disk is equal to the specified snapshot size. If the size of the snapshot specified by `snapshot_id` is smaller than the value of `size`, the size of the created disk is equal to the value of `size`.
        """
        return pulumi.get(self, "snapshot_id")

    @snapshot_id.setter
    def snapshot_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snapshot_id", value)

    @_builtins.property
    @pulumi.getter(name="storageSetId")
    def storage_set_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the storage set.
        """
        return pulumi.get(self, "storage_set_id")

    @storage_set_id.setter
    def storage_set_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_set_id", value)

    @_builtins.property
    @pulumi.getter(name="storageSetPartitionNumber")
    def storage_set_partition_number(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of partitions in the storage set.
        """
        return pulumi.get(self, "storage_set_partition_number")

    @storage_set_partition_number.setter
    def storage_set_partition_number(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "storage_set_partition_number", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type to expand cloud disks. Valid Values: `online`, `offline`. Default to `offline`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the free zone to which the disk belongs. One of the `zone_id` and `instance_id` must be set but can not be set at the same time.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone_id", value)


@pulumi.input_type
class _EcsDiskState:
    def __init__(__self__, *,
                 advanced_features: Optional[pulumi.Input[_builtins.str]] = None,
                 availability_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 bursting_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 category: Optional[pulumi.Input[_builtins.str]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 delete_auto_snapshot: Optional[pulumi.Input[_builtins.bool]] = None,
                 delete_with_instance: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_name: Optional[pulumi.Input[_builtins.str]] = None,
                 dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_auto_snapshot: Optional[pulumi.Input[_builtins.bool]] = None,
                 encrypt_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 encrypted: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 multi_attach: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 performance_level: Optional[pulumi.Input[_builtins.str]] = None,
                 provisioned_iops: Optional[pulumi.Input[_builtins.int]] = None,
                 region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 size: Optional[pulumi.Input[_builtins.int]] = None,
                 snapshot_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_set_id: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_set_partition_number: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering EcsDisk resources.
        :param pulumi.Input[_builtins.str] availability_zone: Field `availability_zone` has been deprecated from provider version 1.122.0. New field `zone_id` instead.
        :param pulumi.Input[_builtins.bool] bursting_enabled: Specifies whether to enable the performance burst feature. Valid values: `true`, `false`. **NOTE:** `bursting_enabled` is only valid when `category` is `cloud_auto`.
        :param pulumi.Input[_builtins.str] category: The category of the data disk. Default value: `cloud_efficiency`. Valid Values: `cloud`, `cloud_efficiency`, `cloud_ssd`, `cloud_essd`, `cloud_auto`, `cloud_essd_entry`, `elastic_ephemeral_disk_standard`, `elastic_ephemeral_disk_premium`.
        :param pulumi.Input[_builtins.str] create_time: (Available since v1.237.0) The time when the disk was created.
        :param pulumi.Input[_builtins.bool] delete_auto_snapshot: Specifies whether to delete the automatic snapshots of the disk when the disk is released. Default value: `false`.
        :param pulumi.Input[_builtins.bool] delete_with_instance: Specifies whether to release the disk along with its associated instance. Default value: `false`.
        :param pulumi.Input[_builtins.str] description: The description of the disk. The description must be 2 to 256 characters in length and cannot start with http:// or https://.
        :param pulumi.Input[_builtins.str] disk_name: The name of the data disk. The name must be 2 to 128 characters in length and can contain letters, digits, colons (:), underscores (_), periods (.), and hyphens (-). The name must start with a letter.
        :param pulumi.Input[_builtins.bool] dry_run: Specifies whether to check the validity of the request without actually making the request.request Default value: `false`. Valid values:
        :param pulumi.Input[_builtins.bool] enable_auto_snapshot: Specifies whether to enable the automatic snapshot policy feature for the cloud disk. Valid values: `true`, `false`.
        :param pulumi.Input[_builtins.bool] encrypted: Specifies whether to encrypt the disk. Default value: `false`. Valid values:
        :param pulumi.Input[_builtins.str] instance_id: The ID of the instance to which the created subscription disk is automatically attached.
               * After you specify the instance ID, the specified `resource_group_id`, `tags`, and `kms_key_id` parameters are ignored.
               * One of the `zone_id` and `instance_id` must be set but can not be set at the same time.
        :param pulumi.Input[_builtins.str] kms_key_id: The ID of the Key Management Service (KMS) key that is used for the disk. **NOTE:** `kms_key_id` is only valid when `encrypted` is `true`.
        :param pulumi.Input[_builtins.str] multi_attach: Specifies whether to enable the multi-attach feature for the disk. Default value: `Disabled`. Valid values: `Enabled`, `Disabled`. **NOTE:** Currently, `multi_attach` can only be set to `Enabled` when `category` is set to `cloud_essd`.
        :param pulumi.Input[_builtins.str] name: Field `name` has been deprecated from provider version 1.122.0. New field `disk_name` instead.
               
               > **NOTE:** Disk category `cloud` has been outdated, and it only can be used none I/O Optimized ECS instances. Recommend `cloud_efficiency` and `cloud_ssd` disk.
        :param pulumi.Input[_builtins.str] payment_type: The payment type of the disk. Default to `PayAsYouGo`. Valid values: `PayAsYouGo`, `Subscription`. If you want to change the disk payment type, the `instance_id` is required.
        :param pulumi.Input[_builtins.str] performance_level: Specifies the performance level of an ESSD when you create the ESSD. Valid values:
               - `PL0`: A single ESSD delivers up to 10,000 random read/write IOPS.
               - `PL1`: A single ESSD delivers up to 50,000 random read/write IOPS.
               - `PL2`: A single ESSD delivers up to 100,000 random read/write IOPS.
               - `PL3`: A single ESSD delivers up to 1,000,000 random read/write IOPS.
        :param pulumi.Input[_builtins.int] provisioned_iops: The provisioned read/write IOPS of the ESSD AutoPL disk. Valid values: 0 to min{50,000, 1,000 × Capacity - Baseline IOPS}. **NOTE:** `provisioned_iops` is only valid when `category` is `cloud_auto`.
        :param pulumi.Input[_builtins.str] region_id: (Available since v1.237.0) The ID of the region to which the disk belongs.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group to which to add the disk.
        :param pulumi.Input[_builtins.int] size: The size of the disk. Unit: GiB. This parameter is required. Valid values:
               - If `category` is set to `cloud`. Valid values: `5` to `2000`.
               - If `category` is set to `cloud_efficiency`. Valid values: `20` to `32768`.
               - If `category` is set to `cloud_ssd`. Valid values: `20` to `32768`.
               - If `category` is set to `cloud_auto`. Valid values: `1` to `65536`.
               - If `category` is set to `cloud_essd_entry`. Valid values: `10` to `32768`.
               - If `category` is set to `elastic_ephemeral_disk_standard`. Valid values: `64` to `8192`.
               - If `category` is set to `elastic_ephemeral_disk_premium`. Valid values: `64` to `8192`.
               - If `category` is set to `cloud_essd`, the valid values are related to `performance_level`. Valid values:
               - If `performance_level` is set to `PL0`. Valid values: `1` to `65536`.
               - If `performance_level` is set to `PL1`. Valid values: `20` to `65536`.
               - If `performance_level` is set to `PL2`. Valid values: `461` to `65536`.
               - If `performance_level` is set to `PL3`. Valid values: `1261` to `65536`.
        :param pulumi.Input[_builtins.str] snapshot_id: The ID of the snapshot to use to create the disk. **NOTE:** If the size of the snapshot specified by `snapshot_id` is larger than the value of `size`, the size of the created disk is equal to the specified snapshot size. If the size of the snapshot specified by `snapshot_id` is smaller than the value of `size`, the size of the created disk is equal to the value of `size`.
        :param pulumi.Input[_builtins.str] status: The status of the disk.
        :param pulumi.Input[_builtins.str] storage_set_id: The ID of the storage set.
        :param pulumi.Input[_builtins.int] storage_set_partition_number: The number of partitions in the storage set.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.str] type: The type to expand cloud disks. Valid Values: `online`, `offline`. Default to `offline`.
        :param pulumi.Input[_builtins.str] zone_id: ID of the free zone to which the disk belongs. One of the `zone_id` and `instance_id` must be set but can not be set at the same time.
        """
        if advanced_features is not None:
            pulumi.set(__self__, "advanced_features", advanced_features)
        if availability_zone is not None:
            warnings.warn("""Field `availability_zone` has been deprecated from provider version 1.122.0. New field `zone_id` instead""", DeprecationWarning)
            pulumi.log.warn("""availability_zone is deprecated: Field `availability_zone` has been deprecated from provider version 1.122.0. New field `zone_id` instead""")
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if bursting_enabled is not None:
            pulumi.set(__self__, "bursting_enabled", bursting_enabled)
        if category is not None:
            pulumi.set(__self__, "category", category)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if delete_auto_snapshot is not None:
            pulumi.set(__self__, "delete_auto_snapshot", delete_auto_snapshot)
        if delete_with_instance is not None:
            pulumi.set(__self__, "delete_with_instance", delete_with_instance)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disk_name is not None:
            pulumi.set(__self__, "disk_name", disk_name)
        if dry_run is not None:
            pulumi.set(__self__, "dry_run", dry_run)
        if enable_auto_snapshot is not None:
            pulumi.set(__self__, "enable_auto_snapshot", enable_auto_snapshot)
        if encrypt_algorithm is not None:
            pulumi.set(__self__, "encrypt_algorithm", encrypt_algorithm)
        if encrypted is not None:
            pulumi.set(__self__, "encrypted", encrypted)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if multi_attach is not None:
            pulumi.set(__self__, "multi_attach", multi_attach)
        if name is not None:
            warnings.warn("""Field `name` has been deprecated from provider version 1.122.0. New field `disk_name` instead.""", DeprecationWarning)
            pulumi.log.warn("""name is deprecated: Field `name` has been deprecated from provider version 1.122.0. New field `disk_name` instead.""")
        if name is not None:
            pulumi.set(__self__, "name", name)
        if payment_type is not None:
            pulumi.set(__self__, "payment_type", payment_type)
        if performance_level is not None:
            pulumi.set(__self__, "performance_level", performance_level)
        if provisioned_iops is not None:
            pulumi.set(__self__, "provisioned_iops", provisioned_iops)
        if region_id is not None:
            pulumi.set(__self__, "region_id", region_id)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if snapshot_id is not None:
            pulumi.set(__self__, "snapshot_id", snapshot_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if storage_set_id is not None:
            pulumi.set(__self__, "storage_set_id", storage_set_id)
        if storage_set_partition_number is not None:
            pulumi.set(__self__, "storage_set_partition_number", storage_set_partition_number)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter(name="advancedFeatures")
    def advanced_features(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "advanced_features")

    @advanced_features.setter
    def advanced_features(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "advanced_features", value)

    @_builtins.property
    @pulumi.getter(name="availabilityZone")
    @_utilities.deprecated("""Field `availability_zone` has been deprecated from provider version 1.122.0. New field `zone_id` instead""")
    def availability_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Field `availability_zone` has been deprecated from provider version 1.122.0. New field `zone_id` instead.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "availability_zone", value)

    @_builtins.property
    @pulumi.getter(name="burstingEnabled")
    def bursting_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable the performance burst feature. Valid values: `true`, `false`. **NOTE:** `bursting_enabled` is only valid when `category` is `cloud_auto`.
        """
        return pulumi.get(self, "bursting_enabled")

    @bursting_enabled.setter
    def bursting_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "bursting_enabled", value)

    @_builtins.property
    @pulumi.getter
    def category(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The category of the data disk. Default value: `cloud_efficiency`. Valid Values: `cloud`, `cloud_efficiency`, `cloud_ssd`, `cloud_essd`, `cloud_auto`, `cloud_essd_entry`, `elastic_ephemeral_disk_standard`, `elastic_ephemeral_disk_premium`.
        """
        return pulumi.get(self, "category")

    @category.setter
    def category(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "category", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Available since v1.237.0) The time when the disk was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="deleteAutoSnapshot")
    def delete_auto_snapshot(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to delete the automatic snapshots of the disk when the disk is released. Default value: `false`.
        """
        return pulumi.get(self, "delete_auto_snapshot")

    @delete_auto_snapshot.setter
    def delete_auto_snapshot(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "delete_auto_snapshot", value)

    @_builtins.property
    @pulumi.getter(name="deleteWithInstance")
    def delete_with_instance(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to release the disk along with its associated instance. Default value: `false`.
        """
        return pulumi.get(self, "delete_with_instance")

    @delete_with_instance.setter
    def delete_with_instance(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "delete_with_instance", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the disk. The description must be 2 to 256 characters in length and cannot start with http:// or https://.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="diskName")
    def disk_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the data disk. The name must be 2 to 128 characters in length and can contain letters, digits, colons (:), underscores (_), periods (.), and hyphens (-). The name must start with a letter.
        """
        return pulumi.get(self, "disk_name")

    @disk_name.setter
    def disk_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "disk_name", value)

    @_builtins.property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to check the validity of the request without actually making the request.request Default value: `false`. Valid values:
        """
        return pulumi.get(self, "dry_run")

    @dry_run.setter
    def dry_run(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "dry_run", value)

    @_builtins.property
    @pulumi.getter(name="enableAutoSnapshot")
    def enable_auto_snapshot(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable the automatic snapshot policy feature for the cloud disk. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "enable_auto_snapshot")

    @enable_auto_snapshot.setter
    def enable_auto_snapshot(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_auto_snapshot", value)

    @_builtins.property
    @pulumi.getter(name="encryptAlgorithm")
    def encrypt_algorithm(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "encrypt_algorithm")

    @encrypt_algorithm.setter
    def encrypt_algorithm(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "encrypt_algorithm", value)

    @_builtins.property
    @pulumi.getter
    def encrypted(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to encrypt the disk. Default value: `false`. Valid values:
        """
        return pulumi.get(self, "encrypted")

    @encrypted.setter
    def encrypted(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "encrypted", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the instance to which the created subscription disk is automatically attached.
        * After you specify the instance ID, the specified `resource_group_id`, `tags`, and `kms_key_id` parameters are ignored.
        * One of the `zone_id` and `instance_id` must be set but can not be set at the same time.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Key Management Service (KMS) key that is used for the disk. **NOTE:** `kms_key_id` is only valid when `encrypted` is `true`.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kms_key_id", value)

    @_builtins.property
    @pulumi.getter(name="multiAttach")
    def multi_attach(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether to enable the multi-attach feature for the disk. Default value: `Disabled`. Valid values: `Enabled`, `Disabled`. **NOTE:** Currently, `multi_attach` can only be set to `Enabled` when `category` is set to `cloud_essd`.
        """
        return pulumi.get(self, "multi_attach")

    @multi_attach.setter
    def multi_attach(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "multi_attach", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field `name` has been deprecated from provider version 1.122.0. New field `disk_name` instead.""")
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Field `name` has been deprecated from provider version 1.122.0. New field `disk_name` instead.

        > **NOTE:** Disk category `cloud` has been outdated, and it only can be used none I/O Optimized ECS instances. Recommend `cloud_efficiency` and `cloud_ssd` disk.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The payment type of the disk. Default to `PayAsYouGo`. Valid values: `PayAsYouGo`, `Subscription`. If you want to change the disk payment type, the `instance_id` is required.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "payment_type", value)

    @_builtins.property
    @pulumi.getter(name="performanceLevel")
    def performance_level(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the performance level of an ESSD when you create the ESSD. Valid values:
        - `PL0`: A single ESSD delivers up to 10,000 random read/write IOPS.
        - `PL1`: A single ESSD delivers up to 50,000 random read/write IOPS.
        - `PL2`: A single ESSD delivers up to 100,000 random read/write IOPS.
        - `PL3`: A single ESSD delivers up to 1,000,000 random read/write IOPS.
        """
        return pulumi.get(self, "performance_level")

    @performance_level.setter
    def performance_level(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "performance_level", value)

    @_builtins.property
    @pulumi.getter(name="provisionedIops")
    def provisioned_iops(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The provisioned read/write IOPS of the ESSD AutoPL disk. Valid values: 0 to min{50,000, 1,000 × Capacity - Baseline IOPS}. **NOTE:** `provisioned_iops` is only valid when `category` is `cloud_auto`.
        """
        return pulumi.get(self, "provisioned_iops")

    @provisioned_iops.setter
    def provisioned_iops(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "provisioned_iops", value)

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Available since v1.237.0) The ID of the region to which the disk belongs.
        """
        return pulumi.get(self, "region_id")

    @region_id.setter
    def region_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region_id", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group to which to add the disk.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The size of the disk. Unit: GiB. This parameter is required. Valid values:
        - If `category` is set to `cloud`. Valid values: `5` to `2000`.
        - If `category` is set to `cloud_efficiency`. Valid values: `20` to `32768`.
        - If `category` is set to `cloud_ssd`. Valid values: `20` to `32768`.
        - If `category` is set to `cloud_auto`. Valid values: `1` to `65536`.
        - If `category` is set to `cloud_essd_entry`. Valid values: `10` to `32768`.
        - If `category` is set to `elastic_ephemeral_disk_standard`. Valid values: `64` to `8192`.
        - If `category` is set to `elastic_ephemeral_disk_premium`. Valid values: `64` to `8192`.
        - If `category` is set to `cloud_essd`, the valid values are related to `performance_level`. Valid values:
        - If `performance_level` is set to `PL0`. Valid values: `1` to `65536`.
        - If `performance_level` is set to `PL1`. Valid values: `20` to `65536`.
        - If `performance_level` is set to `PL2`. Valid values: `461` to `65536`.
        - If `performance_level` is set to `PL3`. Valid values: `1261` to `65536`.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "size", value)

    @_builtins.property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the snapshot to use to create the disk. **NOTE:** If the size of the snapshot specified by `snapshot_id` is larger than the value of `size`, the size of the created disk is equal to the specified snapshot size. If the size of the snapshot specified by `snapshot_id` is smaller than the value of `size`, the size of the created disk is equal to the value of `size`.
        """
        return pulumi.get(self, "snapshot_id")

    @snapshot_id.setter
    def snapshot_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snapshot_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the disk.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="storageSetId")
    def storage_set_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the storage set.
        """
        return pulumi.get(self, "storage_set_id")

    @storage_set_id.setter
    def storage_set_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_set_id", value)

    @_builtins.property
    @pulumi.getter(name="storageSetPartitionNumber")
    def storage_set_partition_number(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of partitions in the storage set.
        """
        return pulumi.get(self, "storage_set_partition_number")

    @storage_set_partition_number.setter
    def storage_set_partition_number(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "storage_set_partition_number", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type to expand cloud disks. Valid Values: `online`, `offline`. Default to `offline`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the free zone to which the disk belongs. One of the `zone_id` and `instance_id` must be set but can not be set at the same time.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone_id", value)


@pulumi.type_token("alicloud:ecs/ecsDisk:EcsDisk")
class EcsDisk(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 advanced_features: Optional[pulumi.Input[_builtins.str]] = None,
                 availability_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 bursting_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 category: Optional[pulumi.Input[_builtins.str]] = None,
                 delete_auto_snapshot: Optional[pulumi.Input[_builtins.bool]] = None,
                 delete_with_instance: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_name: Optional[pulumi.Input[_builtins.str]] = None,
                 dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_auto_snapshot: Optional[pulumi.Input[_builtins.bool]] = None,
                 encrypt_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 encrypted: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 multi_attach: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 performance_level: Optional[pulumi.Input[_builtins.str]] = None,
                 provisioned_iops: Optional[pulumi.Input[_builtins.int]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 size: Optional[pulumi.Input[_builtins.int]] = None,
                 snapshot_id: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_set_id: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_set_partition_number: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Import

        ECS Disk can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ecs/ecsDisk:EcsDisk example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] availability_zone: Field `availability_zone` has been deprecated from provider version 1.122.0. New field `zone_id` instead.
        :param pulumi.Input[_builtins.bool] bursting_enabled: Specifies whether to enable the performance burst feature. Valid values: `true`, `false`. **NOTE:** `bursting_enabled` is only valid when `category` is `cloud_auto`.
        :param pulumi.Input[_builtins.str] category: The category of the data disk. Default value: `cloud_efficiency`. Valid Values: `cloud`, `cloud_efficiency`, `cloud_ssd`, `cloud_essd`, `cloud_auto`, `cloud_essd_entry`, `elastic_ephemeral_disk_standard`, `elastic_ephemeral_disk_premium`.
        :param pulumi.Input[_builtins.bool] delete_auto_snapshot: Specifies whether to delete the automatic snapshots of the disk when the disk is released. Default value: `false`.
        :param pulumi.Input[_builtins.bool] delete_with_instance: Specifies whether to release the disk along with its associated instance. Default value: `false`.
        :param pulumi.Input[_builtins.str] description: The description of the disk. The description must be 2 to 256 characters in length and cannot start with http:// or https://.
        :param pulumi.Input[_builtins.str] disk_name: The name of the data disk. The name must be 2 to 128 characters in length and can contain letters, digits, colons (:), underscores (_), periods (.), and hyphens (-). The name must start with a letter.
        :param pulumi.Input[_builtins.bool] dry_run: Specifies whether to check the validity of the request without actually making the request.request Default value: `false`. Valid values:
        :param pulumi.Input[_builtins.bool] enable_auto_snapshot: Specifies whether to enable the automatic snapshot policy feature for the cloud disk. Valid values: `true`, `false`.
        :param pulumi.Input[_builtins.bool] encrypted: Specifies whether to encrypt the disk. Default value: `false`. Valid values:
        :param pulumi.Input[_builtins.str] instance_id: The ID of the instance to which the created subscription disk is automatically attached.
               * After you specify the instance ID, the specified `resource_group_id`, `tags`, and `kms_key_id` parameters are ignored.
               * One of the `zone_id` and `instance_id` must be set but can not be set at the same time.
        :param pulumi.Input[_builtins.str] kms_key_id: The ID of the Key Management Service (KMS) key that is used for the disk. **NOTE:** `kms_key_id` is only valid when `encrypted` is `true`.
        :param pulumi.Input[_builtins.str] multi_attach: Specifies whether to enable the multi-attach feature for the disk. Default value: `Disabled`. Valid values: `Enabled`, `Disabled`. **NOTE:** Currently, `multi_attach` can only be set to `Enabled` when `category` is set to `cloud_essd`.
        :param pulumi.Input[_builtins.str] name: Field `name` has been deprecated from provider version 1.122.0. New field `disk_name` instead.
               
               > **NOTE:** Disk category `cloud` has been outdated, and it only can be used none I/O Optimized ECS instances. Recommend `cloud_efficiency` and `cloud_ssd` disk.
        :param pulumi.Input[_builtins.str] payment_type: The payment type of the disk. Default to `PayAsYouGo`. Valid values: `PayAsYouGo`, `Subscription`. If you want to change the disk payment type, the `instance_id` is required.
        :param pulumi.Input[_builtins.str] performance_level: Specifies the performance level of an ESSD when you create the ESSD. Valid values:
               - `PL0`: A single ESSD delivers up to 10,000 random read/write IOPS.
               - `PL1`: A single ESSD delivers up to 50,000 random read/write IOPS.
               - `PL2`: A single ESSD delivers up to 100,000 random read/write IOPS.
               - `PL3`: A single ESSD delivers up to 1,000,000 random read/write IOPS.
        :param pulumi.Input[_builtins.int] provisioned_iops: The provisioned read/write IOPS of the ESSD AutoPL disk. Valid values: 0 to min{50,000, 1,000 × Capacity - Baseline IOPS}. **NOTE:** `provisioned_iops` is only valid when `category` is `cloud_auto`.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group to which to add the disk.
        :param pulumi.Input[_builtins.int] size: The size of the disk. Unit: GiB. This parameter is required. Valid values:
               - If `category` is set to `cloud`. Valid values: `5` to `2000`.
               - If `category` is set to `cloud_efficiency`. Valid values: `20` to `32768`.
               - If `category` is set to `cloud_ssd`. Valid values: `20` to `32768`.
               - If `category` is set to `cloud_auto`. Valid values: `1` to `65536`.
               - If `category` is set to `cloud_essd_entry`. Valid values: `10` to `32768`.
               - If `category` is set to `elastic_ephemeral_disk_standard`. Valid values: `64` to `8192`.
               - If `category` is set to `elastic_ephemeral_disk_premium`. Valid values: `64` to `8192`.
               - If `category` is set to `cloud_essd`, the valid values are related to `performance_level`. Valid values:
               - If `performance_level` is set to `PL0`. Valid values: `1` to `65536`.
               - If `performance_level` is set to `PL1`. Valid values: `20` to `65536`.
               - If `performance_level` is set to `PL2`. Valid values: `461` to `65536`.
               - If `performance_level` is set to `PL3`. Valid values: `1261` to `65536`.
        :param pulumi.Input[_builtins.str] snapshot_id: The ID of the snapshot to use to create the disk. **NOTE:** If the size of the snapshot specified by `snapshot_id` is larger than the value of `size`, the size of the created disk is equal to the specified snapshot size. If the size of the snapshot specified by `snapshot_id` is smaller than the value of `size`, the size of the created disk is equal to the value of `size`.
        :param pulumi.Input[_builtins.str] storage_set_id: The ID of the storage set.
        :param pulumi.Input[_builtins.int] storage_set_partition_number: The number of partitions in the storage set.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.str] type: The type to expand cloud disks. Valid Values: `online`, `offline`. Default to `offline`.
        :param pulumi.Input[_builtins.str] zone_id: ID of the free zone to which the disk belongs. One of the `zone_id` and `instance_id` must be set but can not be set at the same time.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[EcsDiskArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        ECS Disk can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ecs/ecsDisk:EcsDisk example <id>
        ```

        :param str resource_name: The name of the resource.
        :param EcsDiskArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EcsDiskArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 advanced_features: Optional[pulumi.Input[_builtins.str]] = None,
                 availability_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 bursting_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 category: Optional[pulumi.Input[_builtins.str]] = None,
                 delete_auto_snapshot: Optional[pulumi.Input[_builtins.bool]] = None,
                 delete_with_instance: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_name: Optional[pulumi.Input[_builtins.str]] = None,
                 dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_auto_snapshot: Optional[pulumi.Input[_builtins.bool]] = None,
                 encrypt_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 encrypted: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 multi_attach: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 performance_level: Optional[pulumi.Input[_builtins.str]] = None,
                 provisioned_iops: Optional[pulumi.Input[_builtins.int]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 size: Optional[pulumi.Input[_builtins.int]] = None,
                 snapshot_id: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_set_id: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_set_partition_number: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EcsDiskArgs.__new__(EcsDiskArgs)

            __props__.__dict__["advanced_features"] = advanced_features
            __props__.__dict__["availability_zone"] = availability_zone
            __props__.__dict__["bursting_enabled"] = bursting_enabled
            __props__.__dict__["category"] = category
            __props__.__dict__["delete_auto_snapshot"] = delete_auto_snapshot
            __props__.__dict__["delete_with_instance"] = delete_with_instance
            __props__.__dict__["description"] = description
            __props__.__dict__["disk_name"] = disk_name
            __props__.__dict__["dry_run"] = dry_run
            __props__.__dict__["enable_auto_snapshot"] = enable_auto_snapshot
            __props__.__dict__["encrypt_algorithm"] = encrypt_algorithm
            __props__.__dict__["encrypted"] = encrypted
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["kms_key_id"] = kms_key_id
            __props__.__dict__["multi_attach"] = multi_attach
            __props__.__dict__["name"] = name
            __props__.__dict__["payment_type"] = payment_type
            __props__.__dict__["performance_level"] = performance_level
            __props__.__dict__["provisioned_iops"] = provisioned_iops
            __props__.__dict__["resource_group_id"] = resource_group_id
            __props__.__dict__["size"] = size
            __props__.__dict__["snapshot_id"] = snapshot_id
            __props__.__dict__["storage_set_id"] = storage_set_id
            __props__.__dict__["storage_set_partition_number"] = storage_set_partition_number
            __props__.__dict__["tags"] = tags
            __props__.__dict__["type"] = type
            __props__.__dict__["zone_id"] = zone_id
            __props__.__dict__["create_time"] = None
            __props__.__dict__["region_id"] = None
            __props__.__dict__["status"] = None
        super(EcsDisk, __self__).__init__(
            'alicloud:ecs/ecsDisk:EcsDisk',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            advanced_features: Optional[pulumi.Input[_builtins.str]] = None,
            availability_zone: Optional[pulumi.Input[_builtins.str]] = None,
            bursting_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            category: Optional[pulumi.Input[_builtins.str]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            delete_auto_snapshot: Optional[pulumi.Input[_builtins.bool]] = None,
            delete_with_instance: Optional[pulumi.Input[_builtins.bool]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            disk_name: Optional[pulumi.Input[_builtins.str]] = None,
            dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
            enable_auto_snapshot: Optional[pulumi.Input[_builtins.bool]] = None,
            encrypt_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
            encrypted: Optional[pulumi.Input[_builtins.bool]] = None,
            instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
            multi_attach: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            payment_type: Optional[pulumi.Input[_builtins.str]] = None,
            performance_level: Optional[pulumi.Input[_builtins.str]] = None,
            provisioned_iops: Optional[pulumi.Input[_builtins.int]] = None,
            region_id: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            size: Optional[pulumi.Input[_builtins.int]] = None,
            snapshot_id: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            storage_set_id: Optional[pulumi.Input[_builtins.str]] = None,
            storage_set_partition_number: Optional[pulumi.Input[_builtins.int]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            zone_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'EcsDisk':
        """
        Get an existing EcsDisk resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] availability_zone: Field `availability_zone` has been deprecated from provider version 1.122.0. New field `zone_id` instead.
        :param pulumi.Input[_builtins.bool] bursting_enabled: Specifies whether to enable the performance burst feature. Valid values: `true`, `false`. **NOTE:** `bursting_enabled` is only valid when `category` is `cloud_auto`.
        :param pulumi.Input[_builtins.str] category: The category of the data disk. Default value: `cloud_efficiency`. Valid Values: `cloud`, `cloud_efficiency`, `cloud_ssd`, `cloud_essd`, `cloud_auto`, `cloud_essd_entry`, `elastic_ephemeral_disk_standard`, `elastic_ephemeral_disk_premium`.
        :param pulumi.Input[_builtins.str] create_time: (Available since v1.237.0) The time when the disk was created.
        :param pulumi.Input[_builtins.bool] delete_auto_snapshot: Specifies whether to delete the automatic snapshots of the disk when the disk is released. Default value: `false`.
        :param pulumi.Input[_builtins.bool] delete_with_instance: Specifies whether to release the disk along with its associated instance. Default value: `false`.
        :param pulumi.Input[_builtins.str] description: The description of the disk. The description must be 2 to 256 characters in length and cannot start with http:// or https://.
        :param pulumi.Input[_builtins.str] disk_name: The name of the data disk. The name must be 2 to 128 characters in length and can contain letters, digits, colons (:), underscores (_), periods (.), and hyphens (-). The name must start with a letter.
        :param pulumi.Input[_builtins.bool] dry_run: Specifies whether to check the validity of the request without actually making the request.request Default value: `false`. Valid values:
        :param pulumi.Input[_builtins.bool] enable_auto_snapshot: Specifies whether to enable the automatic snapshot policy feature for the cloud disk. Valid values: `true`, `false`.
        :param pulumi.Input[_builtins.bool] encrypted: Specifies whether to encrypt the disk. Default value: `false`. Valid values:
        :param pulumi.Input[_builtins.str] instance_id: The ID of the instance to which the created subscription disk is automatically attached.
               * After you specify the instance ID, the specified `resource_group_id`, `tags`, and `kms_key_id` parameters are ignored.
               * One of the `zone_id` and `instance_id` must be set but can not be set at the same time.
        :param pulumi.Input[_builtins.str] kms_key_id: The ID of the Key Management Service (KMS) key that is used for the disk. **NOTE:** `kms_key_id` is only valid when `encrypted` is `true`.
        :param pulumi.Input[_builtins.str] multi_attach: Specifies whether to enable the multi-attach feature for the disk. Default value: `Disabled`. Valid values: `Enabled`, `Disabled`. **NOTE:** Currently, `multi_attach` can only be set to `Enabled` when `category` is set to `cloud_essd`.
        :param pulumi.Input[_builtins.str] name: Field `name` has been deprecated from provider version 1.122.0. New field `disk_name` instead.
               
               > **NOTE:** Disk category `cloud` has been outdated, and it only can be used none I/O Optimized ECS instances. Recommend `cloud_efficiency` and `cloud_ssd` disk.
        :param pulumi.Input[_builtins.str] payment_type: The payment type of the disk. Default to `PayAsYouGo`. Valid values: `PayAsYouGo`, `Subscription`. If you want to change the disk payment type, the `instance_id` is required.
        :param pulumi.Input[_builtins.str] performance_level: Specifies the performance level of an ESSD when you create the ESSD. Valid values:
               - `PL0`: A single ESSD delivers up to 10,000 random read/write IOPS.
               - `PL1`: A single ESSD delivers up to 50,000 random read/write IOPS.
               - `PL2`: A single ESSD delivers up to 100,000 random read/write IOPS.
               - `PL3`: A single ESSD delivers up to 1,000,000 random read/write IOPS.
        :param pulumi.Input[_builtins.int] provisioned_iops: The provisioned read/write IOPS of the ESSD AutoPL disk. Valid values: 0 to min{50,000, 1,000 × Capacity - Baseline IOPS}. **NOTE:** `provisioned_iops` is only valid when `category` is `cloud_auto`.
        :param pulumi.Input[_builtins.str] region_id: (Available since v1.237.0) The ID of the region to which the disk belongs.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group to which to add the disk.
        :param pulumi.Input[_builtins.int] size: The size of the disk. Unit: GiB. This parameter is required. Valid values:
               - If `category` is set to `cloud`. Valid values: `5` to `2000`.
               - If `category` is set to `cloud_efficiency`. Valid values: `20` to `32768`.
               - If `category` is set to `cloud_ssd`. Valid values: `20` to `32768`.
               - If `category` is set to `cloud_auto`. Valid values: `1` to `65536`.
               - If `category` is set to `cloud_essd_entry`. Valid values: `10` to `32768`.
               - If `category` is set to `elastic_ephemeral_disk_standard`. Valid values: `64` to `8192`.
               - If `category` is set to `elastic_ephemeral_disk_premium`. Valid values: `64` to `8192`.
               - If `category` is set to `cloud_essd`, the valid values are related to `performance_level`. Valid values:
               - If `performance_level` is set to `PL0`. Valid values: `1` to `65536`.
               - If `performance_level` is set to `PL1`. Valid values: `20` to `65536`.
               - If `performance_level` is set to `PL2`. Valid values: `461` to `65536`.
               - If `performance_level` is set to `PL3`. Valid values: `1261` to `65536`.
        :param pulumi.Input[_builtins.str] snapshot_id: The ID of the snapshot to use to create the disk. **NOTE:** If the size of the snapshot specified by `snapshot_id` is larger than the value of `size`, the size of the created disk is equal to the specified snapshot size. If the size of the snapshot specified by `snapshot_id` is smaller than the value of `size`, the size of the created disk is equal to the value of `size`.
        :param pulumi.Input[_builtins.str] status: The status of the disk.
        :param pulumi.Input[_builtins.str] storage_set_id: The ID of the storage set.
        :param pulumi.Input[_builtins.int] storage_set_partition_number: The number of partitions in the storage set.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.str] type: The type to expand cloud disks. Valid Values: `online`, `offline`. Default to `offline`.
        :param pulumi.Input[_builtins.str] zone_id: ID of the free zone to which the disk belongs. One of the `zone_id` and `instance_id` must be set but can not be set at the same time.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EcsDiskState.__new__(_EcsDiskState)

        __props__.__dict__["advanced_features"] = advanced_features
        __props__.__dict__["availability_zone"] = availability_zone
        __props__.__dict__["bursting_enabled"] = bursting_enabled
        __props__.__dict__["category"] = category
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["delete_auto_snapshot"] = delete_auto_snapshot
        __props__.__dict__["delete_with_instance"] = delete_with_instance
        __props__.__dict__["description"] = description
        __props__.__dict__["disk_name"] = disk_name
        __props__.__dict__["dry_run"] = dry_run
        __props__.__dict__["enable_auto_snapshot"] = enable_auto_snapshot
        __props__.__dict__["encrypt_algorithm"] = encrypt_algorithm
        __props__.__dict__["encrypted"] = encrypted
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["kms_key_id"] = kms_key_id
        __props__.__dict__["multi_attach"] = multi_attach
        __props__.__dict__["name"] = name
        __props__.__dict__["payment_type"] = payment_type
        __props__.__dict__["performance_level"] = performance_level
        __props__.__dict__["provisioned_iops"] = provisioned_iops
        __props__.__dict__["region_id"] = region_id
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["size"] = size
        __props__.__dict__["snapshot_id"] = snapshot_id
        __props__.__dict__["status"] = status
        __props__.__dict__["storage_set_id"] = storage_set_id
        __props__.__dict__["storage_set_partition_number"] = storage_set_partition_number
        __props__.__dict__["tags"] = tags
        __props__.__dict__["type"] = type
        __props__.__dict__["zone_id"] = zone_id
        return EcsDisk(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="advancedFeatures")
    def advanced_features(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "advanced_features")

    @_builtins.property
    @pulumi.getter(name="availabilityZone")
    @_utilities.deprecated("""Field `availability_zone` has been deprecated from provider version 1.122.0. New field `zone_id` instead""")
    def availability_zone(self) -> pulumi.Output[_builtins.str]:
        """
        Field `availability_zone` has been deprecated from provider version 1.122.0. New field `zone_id` instead.
        """
        return pulumi.get(self, "availability_zone")

    @_builtins.property
    @pulumi.getter(name="burstingEnabled")
    def bursting_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether to enable the performance burst feature. Valid values: `true`, `false`. **NOTE:** `bursting_enabled` is only valid when `category` is `cloud_auto`.
        """
        return pulumi.get(self, "bursting_enabled")

    @_builtins.property
    @pulumi.getter
    def category(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The category of the data disk. Default value: `cloud_efficiency`. Valid Values: `cloud`, `cloud_efficiency`, `cloud_ssd`, `cloud_essd`, `cloud_auto`, `cloud_essd_entry`, `elastic_ephemeral_disk_standard`, `elastic_ephemeral_disk_premium`.
        """
        return pulumi.get(self, "category")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        (Available since v1.237.0) The time when the disk was created.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="deleteAutoSnapshot")
    def delete_auto_snapshot(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether to delete the automatic snapshots of the disk when the disk is released. Default value: `false`.
        """
        return pulumi.get(self, "delete_auto_snapshot")

    @_builtins.property
    @pulumi.getter(name="deleteWithInstance")
    def delete_with_instance(self) -> pulumi.Output[_builtins.bool]:
        """
        Specifies whether to release the disk along with its associated instance. Default value: `false`.
        """
        return pulumi.get(self, "delete_with_instance")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the disk. The description must be 2 to 256 characters in length and cannot start with http:// or https://.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="diskName")
    def disk_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the data disk. The name must be 2 to 128 characters in length and can contain letters, digits, colons (:), underscores (_), periods (.), and hyphens (-). The name must start with a letter.
        """
        return pulumi.get(self, "disk_name")

    @_builtins.property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether to check the validity of the request without actually making the request.request Default value: `false`. Valid values:
        """
        return pulumi.get(self, "dry_run")

    @_builtins.property
    @pulumi.getter(name="enableAutoSnapshot")
    def enable_auto_snapshot(self) -> pulumi.Output[_builtins.bool]:
        """
        Specifies whether to enable the automatic snapshot policy feature for the cloud disk. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "enable_auto_snapshot")

    @_builtins.property
    @pulumi.getter(name="encryptAlgorithm")
    def encrypt_algorithm(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "encrypt_algorithm")

    @_builtins.property
    @pulumi.getter
    def encrypted(self) -> pulumi.Output[_builtins.bool]:
        """
        Specifies whether to encrypt the disk. Default value: `false`. Valid values:
        """
        return pulumi.get(self, "encrypted")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the instance to which the created subscription disk is automatically attached.
        * After you specify the instance ID, the specified `resource_group_id`, `tags`, and `kms_key_id` parameters are ignored.
        * One of the `zone_id` and `instance_id` must be set but can not be set at the same time.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Key Management Service (KMS) key that is used for the disk. **NOTE:** `kms_key_id` is only valid when `encrypted` is `true`.
        """
        return pulumi.get(self, "kms_key_id")

    @_builtins.property
    @pulumi.getter(name="multiAttach")
    def multi_attach(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies whether to enable the multi-attach feature for the disk. Default value: `Disabled`. Valid values: `Enabled`, `Disabled`. **NOTE:** Currently, `multi_attach` can only be set to `Enabled` when `category` is set to `cloud_essd`.
        """
        return pulumi.get(self, "multi_attach")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field `name` has been deprecated from provider version 1.122.0. New field `disk_name` instead.""")
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Field `name` has been deprecated from provider version 1.122.0. New field `disk_name` instead.

        > **NOTE:** Disk category `cloud` has been outdated, and it only can be used none I/O Optimized ECS instances. Recommend `cloud_efficiency` and `cloud_ssd` disk.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> pulumi.Output[_builtins.str]:
        """
        The payment type of the disk. Default to `PayAsYouGo`. Valid values: `PayAsYouGo`, `Subscription`. If you want to change the disk payment type, the `instance_id` is required.
        """
        return pulumi.get(self, "payment_type")

    @_builtins.property
    @pulumi.getter(name="performanceLevel")
    def performance_level(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the performance level of an ESSD when you create the ESSD. Valid values:
        - `PL0`: A single ESSD delivers up to 10,000 random read/write IOPS.
        - `PL1`: A single ESSD delivers up to 50,000 random read/write IOPS.
        - `PL2`: A single ESSD delivers up to 100,000 random read/write IOPS.
        - `PL3`: A single ESSD delivers up to 1,000,000 random read/write IOPS.
        """
        return pulumi.get(self, "performance_level")

    @_builtins.property
    @pulumi.getter(name="provisionedIops")
    def provisioned_iops(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The provisioned read/write IOPS of the ESSD AutoPL disk. Valid values: 0 to min{50,000, 1,000 × Capacity - Baseline IOPS}. **NOTE:** `provisioned_iops` is only valid when `category` is `cloud_auto`.
        """
        return pulumi.get(self, "provisioned_iops")

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Available since v1.237.0) The ID of the region to which the disk belongs.
        """
        return pulumi.get(self, "region_id")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the resource group to which to add the disk.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter
    def size(self) -> pulumi.Output[_builtins.int]:
        """
        The size of the disk. Unit: GiB. This parameter is required. Valid values:
        - If `category` is set to `cloud`. Valid values: `5` to `2000`.
        - If `category` is set to `cloud_efficiency`. Valid values: `20` to `32768`.
        - If `category` is set to `cloud_ssd`. Valid values: `20` to `32768`.
        - If `category` is set to `cloud_auto`. Valid values: `1` to `65536`.
        - If `category` is set to `cloud_essd_entry`. Valid values: `10` to `32768`.
        - If `category` is set to `elastic_ephemeral_disk_standard`. Valid values: `64` to `8192`.
        - If `category` is set to `elastic_ephemeral_disk_premium`. Valid values: `64` to `8192`.
        - If `category` is set to `cloud_essd`, the valid values are related to `performance_level`. Valid values:
        - If `performance_level` is set to `PL0`. Valid values: `1` to `65536`.
        - If `performance_level` is set to `PL1`. Valid values: `20` to `65536`.
        - If `performance_level` is set to `PL2`. Valid values: `461` to `65536`.
        - If `performance_level` is set to `PL3`. Valid values: `1261` to `65536`.
        """
        return pulumi.get(self, "size")

    @_builtins.property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the snapshot to use to create the disk. **NOTE:** If the size of the snapshot specified by `snapshot_id` is larger than the value of `size`, the size of the created disk is equal to the specified snapshot size. If the size of the snapshot specified by `snapshot_id` is smaller than the value of `size`, the size of the created disk is equal to the value of `size`.
        """
        return pulumi.get(self, "snapshot_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the disk.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="storageSetId")
    def storage_set_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the storage set.
        """
        return pulumi.get(self, "storage_set_id")

    @_builtins.property
    @pulumi.getter(name="storageSetPartitionNumber")
    def storage_set_partition_number(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The number of partitions in the storage set.
        """
        return pulumi.get(self, "storage_set_partition_number")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The type to expand cloud disks. Valid Values: `online`, `offline`. Default to `offline`.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of the free zone to which the disk belongs. One of the `zone_id` and `instance_id` must be set but can not be set at the same time.
        """
        return pulumi.get(self, "zone_id")

