# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['EcsNetworkInterfaceArgs', 'EcsNetworkInterface']

@pulumi.input_type
class EcsNetworkInterfaceArgs:
    def __init__(__self__, *,
                 vswitch_id: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv4_prefix_count: Optional[pulumi.Input[_builtins.int]] = None,
                 ipv4_prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 ipv6_address_count: Optional[pulumi.Input[_builtins.int]] = None,
                 ipv6_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_interface_name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_interface_traffic_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 primary_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 private_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 private_ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 private_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 private_ips_count: Optional[pulumi.Input[_builtins.int]] = None,
                 queue_number: Optional[pulumi.Input[_builtins.int]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 secondary_private_ip_address_count: Optional[pulumi.Input[_builtins.int]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 source_dest_check: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a EcsNetworkInterface resource.
        :param pulumi.Input[_builtins.str] vswitch_id: The ID of the VSwitch in the specified VPC. The private IP addresses assigned to the ENI must be available IP addresses within the CIDR block of the VSwitch.
        :param pulumi.Input[_builtins.str] description: The description of the ENI. The description must be 2 to 256 characters in length and cannot start with http:// or https://.
        :param pulumi.Input[_builtins.str] instance_type: The type of the ENI. Default value: `Secondary`. Valid values: `Secondary`, `Trunk`.
        :param pulumi.Input[_builtins.int] ipv4_prefix_count: The number of IPv4 prefixes that can be automatically created by ECS. Valid values: 1 to 10. **NOTE:** You cannot specify both the `ipv4_prefixes` and `ipv4_prefix_count` parameters.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ipv4_prefixes: A list of IPv4 prefixes to be assigned to the ENI. Support up to 10.
        :param pulumi.Input[_builtins.int] ipv6_address_count: The number of IPv6 addresses to randomly generate for the primary ENI. Valid values: 1 to 10. **NOTE:** You cannot specify both the `ipv6_addresses` and `ipv6_address_count` parameters.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ipv6_addresses: A list of IPv6 address to be assigned to the primary ENI. Support up to 10.
        :param pulumi.Input[_builtins.str] name: Field `name` has been deprecated from provider version 1.123.1. New field `network_interface_name` instead
        :param pulumi.Input[_builtins.str] network_interface_name: The name of the ENI. The name must be 2 to 128 characters in length, and can contain letters, digits, colons (:), underscores (_), and hyphens (-). It must start with a letter and cannot start with http:// or https://.
        :param pulumi.Input[_builtins.str] network_interface_traffic_mode: The communication mode of the ENI. Default value: `Standard`. Valid values: `Standard`, `HighPerformance`.
        :param pulumi.Input[_builtins.str] primary_ip_address: The primary private IP address of the ENI. The specified IP address must be available within the CIDR block of the VSwitch. If this parameter is not specified, an available IP address is assigned from the VSwitch CIDR block at random.
        :param pulumi.Input[_builtins.str] private_ip: Field `private_ip` has been deprecated from provider version 1.123.1. New field `primary_ip_address` instead
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] private_ip_addresses: Specifies secondary private IP address N of the ENI. This IP address must be an available IP address within the CIDR block of the VSwitch to which the ENI belongs.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] private_ips: Field `private_ips` has been deprecated from provider version 1.123.1. New field `private_ip_addresses` instead
        :param pulumi.Input[_builtins.int] private_ips_count: Field `private_ips_count` has been deprecated from provider version 1.123.1. New field `secondary_private_ip_address_count` instead
        :param pulumi.Input[_builtins.int] queue_number: The queue number of the ENI.
        :param pulumi.Input[_builtins.str] resource_group_id: The resource group id.
        :param pulumi.Input[_builtins.int] secondary_private_ip_address_count: The number of private IP addresses that can be automatically created by ECS.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_group_ids: The ID of security group N. The security groups and the ENI must belong to the same VPC. The valid values of N are based on the maximum number of security groups to which an ENI can be added. **NOTE:** Either `security_group_ids` or `security_groups` must be set with valid security group IDs.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_groups: Field `security_groups` has been deprecated from provider version 1.123.1. New field `security_group_ids` instead. **NOTE:** Either `security_group_ids` or `security_groups` must be set with valid security group IDs.
        :param pulumi.Input[_builtins.bool] source_dest_check: Indicates whether the source and destination IP address check feature is enabled. To improve network security, enable this feature. Default value: `false`. Valid values: `true`, `false`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        pulumi.set(__self__, "vswitch_id", vswitch_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if ipv4_prefix_count is not None:
            pulumi.set(__self__, "ipv4_prefix_count", ipv4_prefix_count)
        if ipv4_prefixes is not None:
            pulumi.set(__self__, "ipv4_prefixes", ipv4_prefixes)
        if ipv6_address_count is not None:
            pulumi.set(__self__, "ipv6_address_count", ipv6_address_count)
        if ipv6_addresses is not None:
            pulumi.set(__self__, "ipv6_addresses", ipv6_addresses)
        if name is not None:
            warnings.warn("""Field 'name' has been deprecated from provider version 1.123.1. New field 'network_interface_name' instead""", DeprecationWarning)
            pulumi.log.warn("""name is deprecated: Field 'name' has been deprecated from provider version 1.123.1. New field 'network_interface_name' instead""")
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_interface_name is not None:
            pulumi.set(__self__, "network_interface_name", network_interface_name)
        if network_interface_traffic_mode is not None:
            pulumi.set(__self__, "network_interface_traffic_mode", network_interface_traffic_mode)
        if primary_ip_address is not None:
            pulumi.set(__self__, "primary_ip_address", primary_ip_address)
        if private_ip is not None:
            warnings.warn("""Field 'private_ip' has been deprecated from provider version 1.123.1. New field 'primary_ip_address' instead""", DeprecationWarning)
            pulumi.log.warn("""private_ip is deprecated: Field 'private_ip' has been deprecated from provider version 1.123.1. New field 'primary_ip_address' instead""")
        if private_ip is not None:
            pulumi.set(__self__, "private_ip", private_ip)
        if private_ip_addresses is not None:
            pulumi.set(__self__, "private_ip_addresses", private_ip_addresses)
        if private_ips is not None:
            warnings.warn("""Field 'private_ips' has been deprecated from provider version 1.123.1. New field 'private_ip_addresses' instead""", DeprecationWarning)
            pulumi.log.warn("""private_ips is deprecated: Field 'private_ips' has been deprecated from provider version 1.123.1. New field 'private_ip_addresses' instead""")
        if private_ips is not None:
            pulumi.set(__self__, "private_ips", private_ips)
        if private_ips_count is not None:
            warnings.warn("""Field 'private_ips_count' has been deprecated from provider version 1.123.1. New field 'secondary_private_ip_address_count' instead""", DeprecationWarning)
            pulumi.log.warn("""private_ips_count is deprecated: Field 'private_ips_count' has been deprecated from provider version 1.123.1. New field 'secondary_private_ip_address_count' instead""")
        if private_ips_count is not None:
            pulumi.set(__self__, "private_ips_count", private_ips_count)
        if queue_number is not None:
            pulumi.set(__self__, "queue_number", queue_number)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if secondary_private_ip_address_count is not None:
            pulumi.set(__self__, "secondary_private_ip_address_count", secondary_private_ip_address_count)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if security_groups is not None:
            warnings.warn("""Field 'security_groups' has been deprecated from provider version 1.123.1. New field 'security_group_ids' instead""", DeprecationWarning)
            pulumi.log.warn("""security_groups is deprecated: Field 'security_groups' has been deprecated from provider version 1.123.1. New field 'security_group_ids' instead""")
        if security_groups is not None:
            pulumi.set(__self__, "security_groups", security_groups)
        if source_dest_check is not None:
            pulumi.set(__self__, "source_dest_check", source_dest_check)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the VSwitch in the specified VPC. The private IP addresses assigned to the ENI must be available IP addresses within the CIDR block of the VSwitch.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vswitch_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the ENI. The description must be 2 to 256 characters in length and cannot start with http:// or https://.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the ENI. Default value: `Secondary`. Valid values: `Secondary`, `Trunk`.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_type", value)

    @_builtins.property
    @pulumi.getter(name="ipv4PrefixCount")
    def ipv4_prefix_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of IPv4 prefixes that can be automatically created by ECS. Valid values: 1 to 10. **NOTE:** You cannot specify both the `ipv4_prefixes` and `ipv4_prefix_count` parameters.
        """
        return pulumi.get(self, "ipv4_prefix_count")

    @ipv4_prefix_count.setter
    def ipv4_prefix_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ipv4_prefix_count", value)

    @_builtins.property
    @pulumi.getter(name="ipv4Prefixes")
    def ipv4_prefixes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of IPv4 prefixes to be assigned to the ENI. Support up to 10.
        """
        return pulumi.get(self, "ipv4_prefixes")

    @ipv4_prefixes.setter
    def ipv4_prefixes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ipv4_prefixes", value)

    @_builtins.property
    @pulumi.getter(name="ipv6AddressCount")
    def ipv6_address_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of IPv6 addresses to randomly generate for the primary ENI. Valid values: 1 to 10. **NOTE:** You cannot specify both the `ipv6_addresses` and `ipv6_address_count` parameters.
        """
        return pulumi.get(self, "ipv6_address_count")

    @ipv6_address_count.setter
    def ipv6_address_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ipv6_address_count", value)

    @_builtins.property
    @pulumi.getter(name="ipv6Addresses")
    def ipv6_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of IPv6 address to be assigned to the primary ENI. Support up to 10.
        """
        return pulumi.get(self, "ipv6_addresses")

    @ipv6_addresses.setter
    def ipv6_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ipv6_addresses", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'name' has been deprecated from provider version 1.123.1. New field 'network_interface_name' instead""")
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Field `name` has been deprecated from provider version 1.123.1. New field `network_interface_name` instead
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkInterfaceName")
    def network_interface_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the ENI. The name must be 2 to 128 characters in length, and can contain letters, digits, colons (:), underscores (_), and hyphens (-). It must start with a letter and cannot start with http:// or https://.
        """
        return pulumi.get(self, "network_interface_name")

    @network_interface_name.setter
    def network_interface_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_interface_name", value)

    @_builtins.property
    @pulumi.getter(name="networkInterfaceTrafficMode")
    def network_interface_traffic_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The communication mode of the ENI. Default value: `Standard`. Valid values: `Standard`, `HighPerformance`.
        """
        return pulumi.get(self, "network_interface_traffic_mode")

    @network_interface_traffic_mode.setter
    def network_interface_traffic_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_interface_traffic_mode", value)

    @_builtins.property
    @pulumi.getter(name="primaryIpAddress")
    def primary_ip_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The primary private IP address of the ENI. The specified IP address must be available within the CIDR block of the VSwitch. If this parameter is not specified, an available IP address is assigned from the VSwitch CIDR block at random.
        """
        return pulumi.get(self, "primary_ip_address")

    @primary_ip_address.setter
    def primary_ip_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "primary_ip_address", value)

    @_builtins.property
    @pulumi.getter(name="privateIp")
    @_utilities.deprecated("""Field 'private_ip' has been deprecated from provider version 1.123.1. New field 'primary_ip_address' instead""")
    def private_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Field `private_ip` has been deprecated from provider version 1.123.1. New field `primary_ip_address` instead
        """
        return pulumi.get(self, "private_ip")

    @private_ip.setter
    def private_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_ip", value)

    @_builtins.property
    @pulumi.getter(name="privateIpAddresses")
    def private_ip_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies secondary private IP address N of the ENI. This IP address must be an available IP address within the CIDR block of the VSwitch to which the ENI belongs.
        """
        return pulumi.get(self, "private_ip_addresses")

    @private_ip_addresses.setter
    def private_ip_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "private_ip_addresses", value)

    @_builtins.property
    @pulumi.getter(name="privateIps")
    @_utilities.deprecated("""Field 'private_ips' has been deprecated from provider version 1.123.1. New field 'private_ip_addresses' instead""")
    def private_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Field `private_ips` has been deprecated from provider version 1.123.1. New field `private_ip_addresses` instead
        """
        return pulumi.get(self, "private_ips")

    @private_ips.setter
    def private_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "private_ips", value)

    @_builtins.property
    @pulumi.getter(name="privateIpsCount")
    @_utilities.deprecated("""Field 'private_ips_count' has been deprecated from provider version 1.123.1. New field 'secondary_private_ip_address_count' instead""")
    def private_ips_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Field `private_ips_count` has been deprecated from provider version 1.123.1. New field `secondary_private_ip_address_count` instead
        """
        return pulumi.get(self, "private_ips_count")

    @private_ips_count.setter
    def private_ips_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "private_ips_count", value)

    @_builtins.property
    @pulumi.getter(name="queueNumber")
    def queue_number(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The queue number of the ENI.
        """
        return pulumi.get(self, "queue_number")

    @queue_number.setter
    def queue_number(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "queue_number", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource group id.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="secondaryPrivateIpAddressCount")
    def secondary_private_ip_address_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of private IP addresses that can be automatically created by ECS.
        """
        return pulumi.get(self, "secondary_private_ip_address_count")

    @secondary_private_ip_address_count.setter
    def secondary_private_ip_address_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "secondary_private_ip_address_count", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The ID of security group N. The security groups and the ENI must belong to the same VPC. The valid values of N are based on the maximum number of security groups to which an ENI can be added. **NOTE:** Either `security_group_ids` or `security_groups` must be set with valid security group IDs.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @_builtins.property
    @pulumi.getter(name="securityGroups")
    @_utilities.deprecated("""Field 'security_groups' has been deprecated from provider version 1.123.1. New field 'security_group_ids' instead""")
    def security_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Field `security_groups` has been deprecated from provider version 1.123.1. New field `security_group_ids` instead. **NOTE:** Either `security_group_ids` or `security_groups` must be set with valid security group IDs.
        """
        return pulumi.get(self, "security_groups")

    @security_groups.setter
    def security_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "security_groups", value)

    @_builtins.property
    @pulumi.getter(name="sourceDestCheck")
    def source_dest_check(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether the source and destination IP address check feature is enabled. To improve network security, enable this feature. Default value: `false`. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "source_dest_check")

    @source_dest_check.setter
    def source_dest_check(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "source_dest_check", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _EcsNetworkInterfaceState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv4_prefix_count: Optional[pulumi.Input[_builtins.int]] = None,
                 ipv4_prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 ipv6_address_count: Optional[pulumi.Input[_builtins.int]] = None,
                 ipv6_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 mac: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_interface_name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_interface_traffic_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 primary_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 private_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 private_ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 private_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 private_ips_count: Optional[pulumi.Input[_builtins.int]] = None,
                 queue_number: Optional[pulumi.Input[_builtins.int]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 secondary_private_ip_address_count: Optional[pulumi.Input[_builtins.int]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 source_dest_check: Optional[pulumi.Input[_builtins.bool]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering EcsNetworkInterface resources.
        :param pulumi.Input[_builtins.str] description: The description of the ENI. The description must be 2 to 256 characters in length and cannot start with http:// or https://.
        :param pulumi.Input[_builtins.str] instance_type: The type of the ENI. Default value: `Secondary`. Valid values: `Secondary`, `Trunk`.
        :param pulumi.Input[_builtins.int] ipv4_prefix_count: The number of IPv4 prefixes that can be automatically created by ECS. Valid values: 1 to 10. **NOTE:** You cannot specify both the `ipv4_prefixes` and `ipv4_prefix_count` parameters.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ipv4_prefixes: A list of IPv4 prefixes to be assigned to the ENI. Support up to 10.
        :param pulumi.Input[_builtins.int] ipv6_address_count: The number of IPv6 addresses to randomly generate for the primary ENI. Valid values: 1 to 10. **NOTE:** You cannot specify both the `ipv6_addresses` and `ipv6_address_count` parameters.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ipv6_addresses: A list of IPv6 address to be assigned to the primary ENI. Support up to 10.
        :param pulumi.Input[_builtins.str] mac: The MAC address of the ENI.
        :param pulumi.Input[_builtins.str] name: Field `name` has been deprecated from provider version 1.123.1. New field `network_interface_name` instead
        :param pulumi.Input[_builtins.str] network_interface_name: The name of the ENI. The name must be 2 to 128 characters in length, and can contain letters, digits, colons (:), underscores (_), and hyphens (-). It must start with a letter and cannot start with http:// or https://.
        :param pulumi.Input[_builtins.str] network_interface_traffic_mode: The communication mode of the ENI. Default value: `Standard`. Valid values: `Standard`, `HighPerformance`.
        :param pulumi.Input[_builtins.str] primary_ip_address: The primary private IP address of the ENI. The specified IP address must be available within the CIDR block of the VSwitch. If this parameter is not specified, an available IP address is assigned from the VSwitch CIDR block at random.
        :param pulumi.Input[_builtins.str] private_ip: Field `private_ip` has been deprecated from provider version 1.123.1. New field `primary_ip_address` instead
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] private_ip_addresses: Specifies secondary private IP address N of the ENI. This IP address must be an available IP address within the CIDR block of the VSwitch to which the ENI belongs.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] private_ips: Field `private_ips` has been deprecated from provider version 1.123.1. New field `private_ip_addresses` instead
        :param pulumi.Input[_builtins.int] private_ips_count: Field `private_ips_count` has been deprecated from provider version 1.123.1. New field `secondary_private_ip_address_count` instead
        :param pulumi.Input[_builtins.int] queue_number: The queue number of the ENI.
        :param pulumi.Input[_builtins.str] resource_group_id: The resource group id.
        :param pulumi.Input[_builtins.int] secondary_private_ip_address_count: The number of private IP addresses that can be automatically created by ECS.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_group_ids: The ID of security group N. The security groups and the ENI must belong to the same VPC. The valid values of N are based on the maximum number of security groups to which an ENI can be added. **NOTE:** Either `security_group_ids` or `security_groups` must be set with valid security group IDs.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_groups: Field `security_groups` has been deprecated from provider version 1.123.1. New field `security_group_ids` instead. **NOTE:** Either `security_group_ids` or `security_groups` must be set with valid security group IDs.
        :param pulumi.Input[_builtins.bool] source_dest_check: Indicates whether the source and destination IP address check feature is enabled. To improve network security, enable this feature. Default value: `false`. Valid values: `true`, `false`.
        :param pulumi.Input[_builtins.str] status: The status of the ENI.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.str] vswitch_id: The ID of the VSwitch in the specified VPC. The private IP addresses assigned to the ENI must be available IP addresses within the CIDR block of the VSwitch.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if ipv4_prefix_count is not None:
            pulumi.set(__self__, "ipv4_prefix_count", ipv4_prefix_count)
        if ipv4_prefixes is not None:
            pulumi.set(__self__, "ipv4_prefixes", ipv4_prefixes)
        if ipv6_address_count is not None:
            pulumi.set(__self__, "ipv6_address_count", ipv6_address_count)
        if ipv6_addresses is not None:
            pulumi.set(__self__, "ipv6_addresses", ipv6_addresses)
        if mac is not None:
            pulumi.set(__self__, "mac", mac)
        if name is not None:
            warnings.warn("""Field 'name' has been deprecated from provider version 1.123.1. New field 'network_interface_name' instead""", DeprecationWarning)
            pulumi.log.warn("""name is deprecated: Field 'name' has been deprecated from provider version 1.123.1. New field 'network_interface_name' instead""")
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_interface_name is not None:
            pulumi.set(__self__, "network_interface_name", network_interface_name)
        if network_interface_traffic_mode is not None:
            pulumi.set(__self__, "network_interface_traffic_mode", network_interface_traffic_mode)
        if primary_ip_address is not None:
            pulumi.set(__self__, "primary_ip_address", primary_ip_address)
        if private_ip is not None:
            warnings.warn("""Field 'private_ip' has been deprecated from provider version 1.123.1. New field 'primary_ip_address' instead""", DeprecationWarning)
            pulumi.log.warn("""private_ip is deprecated: Field 'private_ip' has been deprecated from provider version 1.123.1. New field 'primary_ip_address' instead""")
        if private_ip is not None:
            pulumi.set(__self__, "private_ip", private_ip)
        if private_ip_addresses is not None:
            pulumi.set(__self__, "private_ip_addresses", private_ip_addresses)
        if private_ips is not None:
            warnings.warn("""Field 'private_ips' has been deprecated from provider version 1.123.1. New field 'private_ip_addresses' instead""", DeprecationWarning)
            pulumi.log.warn("""private_ips is deprecated: Field 'private_ips' has been deprecated from provider version 1.123.1. New field 'private_ip_addresses' instead""")
        if private_ips is not None:
            pulumi.set(__self__, "private_ips", private_ips)
        if private_ips_count is not None:
            warnings.warn("""Field 'private_ips_count' has been deprecated from provider version 1.123.1. New field 'secondary_private_ip_address_count' instead""", DeprecationWarning)
            pulumi.log.warn("""private_ips_count is deprecated: Field 'private_ips_count' has been deprecated from provider version 1.123.1. New field 'secondary_private_ip_address_count' instead""")
        if private_ips_count is not None:
            pulumi.set(__self__, "private_ips_count", private_ips_count)
        if queue_number is not None:
            pulumi.set(__self__, "queue_number", queue_number)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if secondary_private_ip_address_count is not None:
            pulumi.set(__self__, "secondary_private_ip_address_count", secondary_private_ip_address_count)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if security_groups is not None:
            warnings.warn("""Field 'security_groups' has been deprecated from provider version 1.123.1. New field 'security_group_ids' instead""", DeprecationWarning)
            pulumi.log.warn("""security_groups is deprecated: Field 'security_groups' has been deprecated from provider version 1.123.1. New field 'security_group_ids' instead""")
        if security_groups is not None:
            pulumi.set(__self__, "security_groups", security_groups)
        if source_dest_check is not None:
            pulumi.set(__self__, "source_dest_check", source_dest_check)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the ENI. The description must be 2 to 256 characters in length and cannot start with http:// or https://.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the ENI. Default value: `Secondary`. Valid values: `Secondary`, `Trunk`.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_type", value)

    @_builtins.property
    @pulumi.getter(name="ipv4PrefixCount")
    def ipv4_prefix_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of IPv4 prefixes that can be automatically created by ECS. Valid values: 1 to 10. **NOTE:** You cannot specify both the `ipv4_prefixes` and `ipv4_prefix_count` parameters.
        """
        return pulumi.get(self, "ipv4_prefix_count")

    @ipv4_prefix_count.setter
    def ipv4_prefix_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ipv4_prefix_count", value)

    @_builtins.property
    @pulumi.getter(name="ipv4Prefixes")
    def ipv4_prefixes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of IPv4 prefixes to be assigned to the ENI. Support up to 10.
        """
        return pulumi.get(self, "ipv4_prefixes")

    @ipv4_prefixes.setter
    def ipv4_prefixes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ipv4_prefixes", value)

    @_builtins.property
    @pulumi.getter(name="ipv6AddressCount")
    def ipv6_address_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of IPv6 addresses to randomly generate for the primary ENI. Valid values: 1 to 10. **NOTE:** You cannot specify both the `ipv6_addresses` and `ipv6_address_count` parameters.
        """
        return pulumi.get(self, "ipv6_address_count")

    @ipv6_address_count.setter
    def ipv6_address_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ipv6_address_count", value)

    @_builtins.property
    @pulumi.getter(name="ipv6Addresses")
    def ipv6_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of IPv6 address to be assigned to the primary ENI. Support up to 10.
        """
        return pulumi.get(self, "ipv6_addresses")

    @ipv6_addresses.setter
    def ipv6_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ipv6_addresses", value)

    @_builtins.property
    @pulumi.getter
    def mac(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The MAC address of the ENI.
        """
        return pulumi.get(self, "mac")

    @mac.setter
    def mac(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mac", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'name' has been deprecated from provider version 1.123.1. New field 'network_interface_name' instead""")
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Field `name` has been deprecated from provider version 1.123.1. New field `network_interface_name` instead
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkInterfaceName")
    def network_interface_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the ENI. The name must be 2 to 128 characters in length, and can contain letters, digits, colons (:), underscores (_), and hyphens (-). It must start with a letter and cannot start with http:// or https://.
        """
        return pulumi.get(self, "network_interface_name")

    @network_interface_name.setter
    def network_interface_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_interface_name", value)

    @_builtins.property
    @pulumi.getter(name="networkInterfaceTrafficMode")
    def network_interface_traffic_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The communication mode of the ENI. Default value: `Standard`. Valid values: `Standard`, `HighPerformance`.
        """
        return pulumi.get(self, "network_interface_traffic_mode")

    @network_interface_traffic_mode.setter
    def network_interface_traffic_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_interface_traffic_mode", value)

    @_builtins.property
    @pulumi.getter(name="primaryIpAddress")
    def primary_ip_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The primary private IP address of the ENI. The specified IP address must be available within the CIDR block of the VSwitch. If this parameter is not specified, an available IP address is assigned from the VSwitch CIDR block at random.
        """
        return pulumi.get(self, "primary_ip_address")

    @primary_ip_address.setter
    def primary_ip_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "primary_ip_address", value)

    @_builtins.property
    @pulumi.getter(name="privateIp")
    @_utilities.deprecated("""Field 'private_ip' has been deprecated from provider version 1.123.1. New field 'primary_ip_address' instead""")
    def private_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Field `private_ip` has been deprecated from provider version 1.123.1. New field `primary_ip_address` instead
        """
        return pulumi.get(self, "private_ip")

    @private_ip.setter
    def private_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_ip", value)

    @_builtins.property
    @pulumi.getter(name="privateIpAddresses")
    def private_ip_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies secondary private IP address N of the ENI. This IP address must be an available IP address within the CIDR block of the VSwitch to which the ENI belongs.
        """
        return pulumi.get(self, "private_ip_addresses")

    @private_ip_addresses.setter
    def private_ip_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "private_ip_addresses", value)

    @_builtins.property
    @pulumi.getter(name="privateIps")
    @_utilities.deprecated("""Field 'private_ips' has been deprecated from provider version 1.123.1. New field 'private_ip_addresses' instead""")
    def private_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Field `private_ips` has been deprecated from provider version 1.123.1. New field `private_ip_addresses` instead
        """
        return pulumi.get(self, "private_ips")

    @private_ips.setter
    def private_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "private_ips", value)

    @_builtins.property
    @pulumi.getter(name="privateIpsCount")
    @_utilities.deprecated("""Field 'private_ips_count' has been deprecated from provider version 1.123.1. New field 'secondary_private_ip_address_count' instead""")
    def private_ips_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Field `private_ips_count` has been deprecated from provider version 1.123.1. New field `secondary_private_ip_address_count` instead
        """
        return pulumi.get(self, "private_ips_count")

    @private_ips_count.setter
    def private_ips_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "private_ips_count", value)

    @_builtins.property
    @pulumi.getter(name="queueNumber")
    def queue_number(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The queue number of the ENI.
        """
        return pulumi.get(self, "queue_number")

    @queue_number.setter
    def queue_number(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "queue_number", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource group id.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="secondaryPrivateIpAddressCount")
    def secondary_private_ip_address_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of private IP addresses that can be automatically created by ECS.
        """
        return pulumi.get(self, "secondary_private_ip_address_count")

    @secondary_private_ip_address_count.setter
    def secondary_private_ip_address_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "secondary_private_ip_address_count", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The ID of security group N. The security groups and the ENI must belong to the same VPC. The valid values of N are based on the maximum number of security groups to which an ENI can be added. **NOTE:** Either `security_group_ids` or `security_groups` must be set with valid security group IDs.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @_builtins.property
    @pulumi.getter(name="securityGroups")
    @_utilities.deprecated("""Field 'security_groups' has been deprecated from provider version 1.123.1. New field 'security_group_ids' instead""")
    def security_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Field `security_groups` has been deprecated from provider version 1.123.1. New field `security_group_ids` instead. **NOTE:** Either `security_group_ids` or `security_groups` must be set with valid security group IDs.
        """
        return pulumi.get(self, "security_groups")

    @security_groups.setter
    def security_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "security_groups", value)

    @_builtins.property
    @pulumi.getter(name="sourceDestCheck")
    def source_dest_check(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether the source and destination IP address check feature is enabled. To improve network security, enable this feature. Default value: `false`. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "source_dest_check")

    @source_dest_check.setter
    def source_dest_check(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "source_dest_check", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the ENI.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the VSwitch in the specified VPC. The private IP addresses assigned to the ENI must be available IP addresses within the CIDR block of the VSwitch.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vswitch_id", value)


@pulumi.type_token("alicloud:ecs/ecsNetworkInterface:EcsNetworkInterface")
class EcsNetworkInterface(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv4_prefix_count: Optional[pulumi.Input[_builtins.int]] = None,
                 ipv4_prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 ipv6_address_count: Optional[pulumi.Input[_builtins.int]] = None,
                 ipv6_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_interface_name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_interface_traffic_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 primary_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 private_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 private_ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 private_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 private_ips_count: Optional[pulumi.Input[_builtins.int]] = None,
                 queue_number: Optional[pulumi.Input[_builtins.int]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 secondary_private_ip_address_count: Optional[pulumi.Input[_builtins.int]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 source_dest_check: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a ECS Network Interface resource.

        For information about ECS Network Interface and how to use it, see [What is Network Interface](https://www.alibabacloud.com/help/en/doc-detail/58504.htm).

        > **NOTE:** Available since v1.123.1.

        > **NOTE** Only one of `private_ip_addresses` or `secondary_private_ip_address_count` can be specified when assign private IPs.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default_network = alicloud.vpc.Network("default",
            vpc_name=name,
            cidr_block="192.168.0.0/24")
        default = alicloud.get_zones(available_resource_creation="VSwitch")
        default_switch = alicloud.vpc.Switch("default",
            vswitch_name=name,
            cidr_block="192.168.0.0/24",
            zone_id=default.zones[0].id,
            vpc_id=default_network.id)
        default_security_group = alicloud.ecs.SecurityGroup("default",
            name=name,
            vpc_id=default_network.id)
        default_get_resource_groups = alicloud.resourcemanager.get_resource_groups(status="OK")
        default_ecs_network_interface = alicloud.ecs.EcsNetworkInterface("default",
            network_interface_name=name,
            vswitch_id=default_switch.id,
            security_group_ids=[default_security_group.id],
            description="Basic test",
            primary_ip_address="192.168.0.2",
            tags={
                "Created": "TF",
                "For": "Test",
            },
            resource_group_id=default_get_resource_groups.ids[0])
        ```

        ## Import

        ECS Network Interface can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ecs/ecsNetworkInterface:EcsNetworkInterface example eni-abcd12345
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: The description of the ENI. The description must be 2 to 256 characters in length and cannot start with http:// or https://.
        :param pulumi.Input[_builtins.str] instance_type: The type of the ENI. Default value: `Secondary`. Valid values: `Secondary`, `Trunk`.
        :param pulumi.Input[_builtins.int] ipv4_prefix_count: The number of IPv4 prefixes that can be automatically created by ECS. Valid values: 1 to 10. **NOTE:** You cannot specify both the `ipv4_prefixes` and `ipv4_prefix_count` parameters.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ipv4_prefixes: A list of IPv4 prefixes to be assigned to the ENI. Support up to 10.
        :param pulumi.Input[_builtins.int] ipv6_address_count: The number of IPv6 addresses to randomly generate for the primary ENI. Valid values: 1 to 10. **NOTE:** You cannot specify both the `ipv6_addresses` and `ipv6_address_count` parameters.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ipv6_addresses: A list of IPv6 address to be assigned to the primary ENI. Support up to 10.
        :param pulumi.Input[_builtins.str] name: Field `name` has been deprecated from provider version 1.123.1. New field `network_interface_name` instead
        :param pulumi.Input[_builtins.str] network_interface_name: The name of the ENI. The name must be 2 to 128 characters in length, and can contain letters, digits, colons (:), underscores (_), and hyphens (-). It must start with a letter and cannot start with http:// or https://.
        :param pulumi.Input[_builtins.str] network_interface_traffic_mode: The communication mode of the ENI. Default value: `Standard`. Valid values: `Standard`, `HighPerformance`.
        :param pulumi.Input[_builtins.str] primary_ip_address: The primary private IP address of the ENI. The specified IP address must be available within the CIDR block of the VSwitch. If this parameter is not specified, an available IP address is assigned from the VSwitch CIDR block at random.
        :param pulumi.Input[_builtins.str] private_ip: Field `private_ip` has been deprecated from provider version 1.123.1. New field `primary_ip_address` instead
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] private_ip_addresses: Specifies secondary private IP address N of the ENI. This IP address must be an available IP address within the CIDR block of the VSwitch to which the ENI belongs.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] private_ips: Field `private_ips` has been deprecated from provider version 1.123.1. New field `private_ip_addresses` instead
        :param pulumi.Input[_builtins.int] private_ips_count: Field `private_ips_count` has been deprecated from provider version 1.123.1. New field `secondary_private_ip_address_count` instead
        :param pulumi.Input[_builtins.int] queue_number: The queue number of the ENI.
        :param pulumi.Input[_builtins.str] resource_group_id: The resource group id.
        :param pulumi.Input[_builtins.int] secondary_private_ip_address_count: The number of private IP addresses that can be automatically created by ECS.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_group_ids: The ID of security group N. The security groups and the ENI must belong to the same VPC. The valid values of N are based on the maximum number of security groups to which an ENI can be added. **NOTE:** Either `security_group_ids` or `security_groups` must be set with valid security group IDs.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_groups: Field `security_groups` has been deprecated from provider version 1.123.1. New field `security_group_ids` instead. **NOTE:** Either `security_group_ids` or `security_groups` must be set with valid security group IDs.
        :param pulumi.Input[_builtins.bool] source_dest_check: Indicates whether the source and destination IP address check feature is enabled. To improve network security, enable this feature. Default value: `false`. Valid values: `true`, `false`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.str] vswitch_id: The ID of the VSwitch in the specified VPC. The private IP addresses assigned to the ENI must be available IP addresses within the CIDR block of the VSwitch.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EcsNetworkInterfaceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a ECS Network Interface resource.

        For information about ECS Network Interface and how to use it, see [What is Network Interface](https://www.alibabacloud.com/help/en/doc-detail/58504.htm).

        > **NOTE:** Available since v1.123.1.

        > **NOTE** Only one of `private_ip_addresses` or `secondary_private_ip_address_count` can be specified when assign private IPs.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default_network = alicloud.vpc.Network("default",
            vpc_name=name,
            cidr_block="192.168.0.0/24")
        default = alicloud.get_zones(available_resource_creation="VSwitch")
        default_switch = alicloud.vpc.Switch("default",
            vswitch_name=name,
            cidr_block="192.168.0.0/24",
            zone_id=default.zones[0].id,
            vpc_id=default_network.id)
        default_security_group = alicloud.ecs.SecurityGroup("default",
            name=name,
            vpc_id=default_network.id)
        default_get_resource_groups = alicloud.resourcemanager.get_resource_groups(status="OK")
        default_ecs_network_interface = alicloud.ecs.EcsNetworkInterface("default",
            network_interface_name=name,
            vswitch_id=default_switch.id,
            security_group_ids=[default_security_group.id],
            description="Basic test",
            primary_ip_address="192.168.0.2",
            tags={
                "Created": "TF",
                "For": "Test",
            },
            resource_group_id=default_get_resource_groups.ids[0])
        ```

        ## Import

        ECS Network Interface can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ecs/ecsNetworkInterface:EcsNetworkInterface example eni-abcd12345
        ```

        :param str resource_name: The name of the resource.
        :param EcsNetworkInterfaceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EcsNetworkInterfaceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv4_prefix_count: Optional[pulumi.Input[_builtins.int]] = None,
                 ipv4_prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 ipv6_address_count: Optional[pulumi.Input[_builtins.int]] = None,
                 ipv6_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_interface_name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_interface_traffic_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 primary_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 private_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 private_ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 private_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 private_ips_count: Optional[pulumi.Input[_builtins.int]] = None,
                 queue_number: Optional[pulumi.Input[_builtins.int]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 secondary_private_ip_address_count: Optional[pulumi.Input[_builtins.int]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 source_dest_check: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EcsNetworkInterfaceArgs.__new__(EcsNetworkInterfaceArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["instance_type"] = instance_type
            __props__.__dict__["ipv4_prefix_count"] = ipv4_prefix_count
            __props__.__dict__["ipv4_prefixes"] = ipv4_prefixes
            __props__.__dict__["ipv6_address_count"] = ipv6_address_count
            __props__.__dict__["ipv6_addresses"] = ipv6_addresses
            __props__.__dict__["name"] = name
            __props__.__dict__["network_interface_name"] = network_interface_name
            __props__.__dict__["network_interface_traffic_mode"] = network_interface_traffic_mode
            __props__.__dict__["primary_ip_address"] = primary_ip_address
            __props__.__dict__["private_ip"] = private_ip
            __props__.__dict__["private_ip_addresses"] = private_ip_addresses
            __props__.__dict__["private_ips"] = private_ips
            __props__.__dict__["private_ips_count"] = private_ips_count
            __props__.__dict__["queue_number"] = queue_number
            __props__.__dict__["resource_group_id"] = resource_group_id
            __props__.__dict__["secondary_private_ip_address_count"] = secondary_private_ip_address_count
            __props__.__dict__["security_group_ids"] = security_group_ids
            __props__.__dict__["security_groups"] = security_groups
            __props__.__dict__["source_dest_check"] = source_dest_check
            __props__.__dict__["tags"] = tags
            if vswitch_id is None and not opts.urn:
                raise TypeError("Missing required property 'vswitch_id'")
            __props__.__dict__["vswitch_id"] = vswitch_id
            __props__.__dict__["mac"] = None
            __props__.__dict__["status"] = None
        super(EcsNetworkInterface, __self__).__init__(
            'alicloud:ecs/ecsNetworkInterface:EcsNetworkInterface',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            instance_type: Optional[pulumi.Input[_builtins.str]] = None,
            ipv4_prefix_count: Optional[pulumi.Input[_builtins.int]] = None,
            ipv4_prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            ipv6_address_count: Optional[pulumi.Input[_builtins.int]] = None,
            ipv6_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            mac: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            network_interface_name: Optional[pulumi.Input[_builtins.str]] = None,
            network_interface_traffic_mode: Optional[pulumi.Input[_builtins.str]] = None,
            primary_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
            private_ip: Optional[pulumi.Input[_builtins.str]] = None,
            private_ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            private_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            private_ips_count: Optional[pulumi.Input[_builtins.int]] = None,
            queue_number: Optional[pulumi.Input[_builtins.int]] = None,
            resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            secondary_private_ip_address_count: Optional[pulumi.Input[_builtins.int]] = None,
            security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            source_dest_check: Optional[pulumi.Input[_builtins.bool]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            vswitch_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'EcsNetworkInterface':
        """
        Get an existing EcsNetworkInterface resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: The description of the ENI. The description must be 2 to 256 characters in length and cannot start with http:// or https://.
        :param pulumi.Input[_builtins.str] instance_type: The type of the ENI. Default value: `Secondary`. Valid values: `Secondary`, `Trunk`.
        :param pulumi.Input[_builtins.int] ipv4_prefix_count: The number of IPv4 prefixes that can be automatically created by ECS. Valid values: 1 to 10. **NOTE:** You cannot specify both the `ipv4_prefixes` and `ipv4_prefix_count` parameters.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ipv4_prefixes: A list of IPv4 prefixes to be assigned to the ENI. Support up to 10.
        :param pulumi.Input[_builtins.int] ipv6_address_count: The number of IPv6 addresses to randomly generate for the primary ENI. Valid values: 1 to 10. **NOTE:** You cannot specify both the `ipv6_addresses` and `ipv6_address_count` parameters.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ipv6_addresses: A list of IPv6 address to be assigned to the primary ENI. Support up to 10.
        :param pulumi.Input[_builtins.str] mac: The MAC address of the ENI.
        :param pulumi.Input[_builtins.str] name: Field `name` has been deprecated from provider version 1.123.1. New field `network_interface_name` instead
        :param pulumi.Input[_builtins.str] network_interface_name: The name of the ENI. The name must be 2 to 128 characters in length, and can contain letters, digits, colons (:), underscores (_), and hyphens (-). It must start with a letter and cannot start with http:// or https://.
        :param pulumi.Input[_builtins.str] network_interface_traffic_mode: The communication mode of the ENI. Default value: `Standard`. Valid values: `Standard`, `HighPerformance`.
        :param pulumi.Input[_builtins.str] primary_ip_address: The primary private IP address of the ENI. The specified IP address must be available within the CIDR block of the VSwitch. If this parameter is not specified, an available IP address is assigned from the VSwitch CIDR block at random.
        :param pulumi.Input[_builtins.str] private_ip: Field `private_ip` has been deprecated from provider version 1.123.1. New field `primary_ip_address` instead
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] private_ip_addresses: Specifies secondary private IP address N of the ENI. This IP address must be an available IP address within the CIDR block of the VSwitch to which the ENI belongs.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] private_ips: Field `private_ips` has been deprecated from provider version 1.123.1. New field `private_ip_addresses` instead
        :param pulumi.Input[_builtins.int] private_ips_count: Field `private_ips_count` has been deprecated from provider version 1.123.1. New field `secondary_private_ip_address_count` instead
        :param pulumi.Input[_builtins.int] queue_number: The queue number of the ENI.
        :param pulumi.Input[_builtins.str] resource_group_id: The resource group id.
        :param pulumi.Input[_builtins.int] secondary_private_ip_address_count: The number of private IP addresses that can be automatically created by ECS.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_group_ids: The ID of security group N. The security groups and the ENI must belong to the same VPC. The valid values of N are based on the maximum number of security groups to which an ENI can be added. **NOTE:** Either `security_group_ids` or `security_groups` must be set with valid security group IDs.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_groups: Field `security_groups` has been deprecated from provider version 1.123.1. New field `security_group_ids` instead. **NOTE:** Either `security_group_ids` or `security_groups` must be set with valid security group IDs.
        :param pulumi.Input[_builtins.bool] source_dest_check: Indicates whether the source and destination IP address check feature is enabled. To improve network security, enable this feature. Default value: `false`. Valid values: `true`, `false`.
        :param pulumi.Input[_builtins.str] status: The status of the ENI.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.str] vswitch_id: The ID of the VSwitch in the specified VPC. The private IP addresses assigned to the ENI must be available IP addresses within the CIDR block of the VSwitch.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EcsNetworkInterfaceState.__new__(_EcsNetworkInterfaceState)

        __props__.__dict__["description"] = description
        __props__.__dict__["instance_type"] = instance_type
        __props__.__dict__["ipv4_prefix_count"] = ipv4_prefix_count
        __props__.__dict__["ipv4_prefixes"] = ipv4_prefixes
        __props__.__dict__["ipv6_address_count"] = ipv6_address_count
        __props__.__dict__["ipv6_addresses"] = ipv6_addresses
        __props__.__dict__["mac"] = mac
        __props__.__dict__["name"] = name
        __props__.__dict__["network_interface_name"] = network_interface_name
        __props__.__dict__["network_interface_traffic_mode"] = network_interface_traffic_mode
        __props__.__dict__["primary_ip_address"] = primary_ip_address
        __props__.__dict__["private_ip"] = private_ip
        __props__.__dict__["private_ip_addresses"] = private_ip_addresses
        __props__.__dict__["private_ips"] = private_ips
        __props__.__dict__["private_ips_count"] = private_ips_count
        __props__.__dict__["queue_number"] = queue_number
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["secondary_private_ip_address_count"] = secondary_private_ip_address_count
        __props__.__dict__["security_group_ids"] = security_group_ids
        __props__.__dict__["security_groups"] = security_groups
        __props__.__dict__["source_dest_check"] = source_dest_check
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["vswitch_id"] = vswitch_id
        return EcsNetworkInterface(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the ENI. The description must be 2 to 256 characters in length and cannot start with http:// or https://.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the ENI. Default value: `Secondary`. Valid values: `Secondary`, `Trunk`.
        """
        return pulumi.get(self, "instance_type")

    @_builtins.property
    @pulumi.getter(name="ipv4PrefixCount")
    def ipv4_prefix_count(self) -> pulumi.Output[_builtins.int]:
        """
        The number of IPv4 prefixes that can be automatically created by ECS. Valid values: 1 to 10. **NOTE:** You cannot specify both the `ipv4_prefixes` and `ipv4_prefix_count` parameters.
        """
        return pulumi.get(self, "ipv4_prefix_count")

    @_builtins.property
    @pulumi.getter(name="ipv4Prefixes")
    def ipv4_prefixes(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        A list of IPv4 prefixes to be assigned to the ENI. Support up to 10.
        """
        return pulumi.get(self, "ipv4_prefixes")

    @_builtins.property
    @pulumi.getter(name="ipv6AddressCount")
    def ipv6_address_count(self) -> pulumi.Output[_builtins.int]:
        """
        The number of IPv6 addresses to randomly generate for the primary ENI. Valid values: 1 to 10. **NOTE:** You cannot specify both the `ipv6_addresses` and `ipv6_address_count` parameters.
        """
        return pulumi.get(self, "ipv6_address_count")

    @_builtins.property
    @pulumi.getter(name="ipv6Addresses")
    def ipv6_addresses(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        A list of IPv6 address to be assigned to the primary ENI. Support up to 10.
        """
        return pulumi.get(self, "ipv6_addresses")

    @_builtins.property
    @pulumi.getter
    def mac(self) -> pulumi.Output[_builtins.str]:
        """
        The MAC address of the ENI.
        """
        return pulumi.get(self, "mac")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'name' has been deprecated from provider version 1.123.1. New field 'network_interface_name' instead""")
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Field `name` has been deprecated from provider version 1.123.1. New field `network_interface_name` instead
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkInterfaceName")
    def network_interface_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the ENI. The name must be 2 to 128 characters in length, and can contain letters, digits, colons (:), underscores (_), and hyphens (-). It must start with a letter and cannot start with http:// or https://.
        """
        return pulumi.get(self, "network_interface_name")

    @_builtins.property
    @pulumi.getter(name="networkInterfaceTrafficMode")
    def network_interface_traffic_mode(self) -> pulumi.Output[_builtins.str]:
        """
        The communication mode of the ENI. Default value: `Standard`. Valid values: `Standard`, `HighPerformance`.
        """
        return pulumi.get(self, "network_interface_traffic_mode")

    @_builtins.property
    @pulumi.getter(name="primaryIpAddress")
    def primary_ip_address(self) -> pulumi.Output[_builtins.str]:
        """
        The primary private IP address of the ENI. The specified IP address must be available within the CIDR block of the VSwitch. If this parameter is not specified, an available IP address is assigned from the VSwitch CIDR block at random.
        """
        return pulumi.get(self, "primary_ip_address")

    @_builtins.property
    @pulumi.getter(name="privateIp")
    @_utilities.deprecated("""Field 'private_ip' has been deprecated from provider version 1.123.1. New field 'primary_ip_address' instead""")
    def private_ip(self) -> pulumi.Output[_builtins.str]:
        """
        Field `private_ip` has been deprecated from provider version 1.123.1. New field `primary_ip_address` instead
        """
        return pulumi.get(self, "private_ip")

    @_builtins.property
    @pulumi.getter(name="privateIpAddresses")
    def private_ip_addresses(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Specifies secondary private IP address N of the ENI. This IP address must be an available IP address within the CIDR block of the VSwitch to which the ENI belongs.
        """
        return pulumi.get(self, "private_ip_addresses")

    @_builtins.property
    @pulumi.getter(name="privateIps")
    @_utilities.deprecated("""Field 'private_ips' has been deprecated from provider version 1.123.1. New field 'private_ip_addresses' instead""")
    def private_ips(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Field `private_ips` has been deprecated from provider version 1.123.1. New field `private_ip_addresses` instead
        """
        return pulumi.get(self, "private_ips")

    @_builtins.property
    @pulumi.getter(name="privateIpsCount")
    @_utilities.deprecated("""Field 'private_ips_count' has been deprecated from provider version 1.123.1. New field 'secondary_private_ip_address_count' instead""")
    def private_ips_count(self) -> pulumi.Output[_builtins.int]:
        """
        Field `private_ips_count` has been deprecated from provider version 1.123.1. New field `secondary_private_ip_address_count` instead
        """
        return pulumi.get(self, "private_ips_count")

    @_builtins.property
    @pulumi.getter(name="queueNumber")
    def queue_number(self) -> pulumi.Output[_builtins.int]:
        """
        The queue number of the ENI.
        """
        return pulumi.get(self, "queue_number")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The resource group id.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter(name="secondaryPrivateIpAddressCount")
    def secondary_private_ip_address_count(self) -> pulumi.Output[_builtins.int]:
        """
        The number of private IP addresses that can be automatically created by ECS.
        """
        return pulumi.get(self, "secondary_private_ip_address_count")

    @_builtins.property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The ID of security group N. The security groups and the ENI must belong to the same VPC. The valid values of N are based on the maximum number of security groups to which an ENI can be added. **NOTE:** Either `security_group_ids` or `security_groups` must be set with valid security group IDs.
        """
        return pulumi.get(self, "security_group_ids")

    @_builtins.property
    @pulumi.getter(name="securityGroups")
    @_utilities.deprecated("""Field 'security_groups' has been deprecated from provider version 1.123.1. New field 'security_group_ids' instead""")
    def security_groups(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Field `security_groups` has been deprecated from provider version 1.123.1. New field `security_group_ids` instead. **NOTE:** Either `security_group_ids` or `security_groups` must be set with valid security group IDs.
        """
        return pulumi.get(self, "security_groups")

    @_builtins.property
    @pulumi.getter(name="sourceDestCheck")
    def source_dest_check(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Indicates whether the source and destination IP address check feature is enabled. To improve network security, enable this feature. Default value: `false`. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "source_dest_check")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the ENI.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the VSwitch in the specified VPC. The private IP addresses assigned to the ENI must be available IP addresses within the CIDR block of the VSwitch.
        """
        return pulumi.get(self, "vswitch_id")

