# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetElasticityAssurancesResult',
    'AwaitableGetElasticityAssurancesResult',
    'get_elasticity_assurances',
    'get_elasticity_assurances_output',
]

@pulumi.output_type
class GetElasticityAssurancesResult:
    """
    A collection of values returned by getElasticityAssurances.
    """
    def __init__(__self__, assurances=None, id=None, ids=None, output_file=None, private_pool_options_ids=None, resource_group_id=None, status=None, tags=None):
        if assurances and not isinstance(assurances, list):
            raise TypeError("Expected argument 'assurances' to be a list")
        pulumi.set(__self__, "assurances", assurances)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if private_pool_options_ids and not isinstance(private_pool_options_ids, list):
            raise TypeError("Expected argument 'private_pool_options_ids' to be a list")
        pulumi.set(__self__, "private_pool_options_ids", private_pool_options_ids)
        if resource_group_id and not isinstance(resource_group_id, str):
            raise TypeError("Expected argument 'resource_group_id' to be a str")
        pulumi.set(__self__, "resource_group_id", resource_group_id)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def assurances(self) -> Sequence['outputs.GetElasticityAssurancesAssuranceResult']:
        """
        A list of Elasticity Assurance Entries. Each element contains the following attributes:
        """
        return pulumi.get(self, "assurances")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        """
        A list of Elasticity Assurance IDs.
        """
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")

    @_builtins.property
    @pulumi.getter(name="privatePoolOptionsIds")
    def private_pool_options_ids(self) -> Optional[Sequence[_builtins.str]]:
        return pulumi.get(self, "private_pool_options_ids")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[_builtins.str]:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        The status of flexible guarantee services. Possible values:-Preparing: in preparation.-Prepared: to take effect.-Active: in effect.-Released: Released.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        A mapping of tags to assign to the Capacity Reservation.
        """
        return pulumi.get(self, "tags")


class AwaitableGetElasticityAssurancesResult(GetElasticityAssurancesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetElasticityAssurancesResult(
            assurances=self.assurances,
            id=self.id,
            ids=self.ids,
            output_file=self.output_file,
            private_pool_options_ids=self.private_pool_options_ids,
            resource_group_id=self.resource_group_id,
            status=self.status,
            tags=self.tags)


def get_elasticity_assurances(ids: Optional[Sequence[_builtins.str]] = None,
                              output_file: Optional[_builtins.str] = None,
                              private_pool_options_ids: Optional[Sequence[_builtins.str]] = None,
                              resource_group_id: Optional[_builtins.str] = None,
                              status: Optional[_builtins.str] = None,
                              tags: Optional[Mapping[str, _builtins.str]] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetElasticityAssurancesResult:
    """
    This data source provides Ecs Elasticity Assurance available to the user.

    > **NOTE:** Available in 1.196.0+

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    default = alicloud.ecs.get_elasticity_assurances(ids=[default_alicloud_ecs_elasticity_assurance["id"]])
    pulumi.export("alicloudEcsElasticityAssuranceExampleId", default.assurances[0].id)
    ```


    :param Sequence[_builtins.str] ids: A list of Elasticity Assurance IDs.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param Sequence[_builtins.str] private_pool_options_ids: The ID of the elastic protection service.
    :param _builtins.str resource_group_id: The ID of the resource group.
    :param _builtins.str status: The status of flexible guarantee services. Possible values: `All`, `Preparing`, `Prepared`, `Active`, `Released`.
    :param Mapping[str, _builtins.str] tags: The tag key-value pair information bound by the elastic guarantee service.
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['outputFile'] = output_file
    __args__['privatePoolOptionsIds'] = private_pool_options_ids
    __args__['resourceGroupId'] = resource_group_id
    __args__['status'] = status
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:ecs/getElasticityAssurances:getElasticityAssurances', __args__, opts=opts, typ=GetElasticityAssurancesResult).value

    return AwaitableGetElasticityAssurancesResult(
        assurances=pulumi.get(__ret__, 'assurances'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        output_file=pulumi.get(__ret__, 'output_file'),
        private_pool_options_ids=pulumi.get(__ret__, 'private_pool_options_ids'),
        resource_group_id=pulumi.get(__ret__, 'resource_group_id'),
        status=pulumi.get(__ret__, 'status'),
        tags=pulumi.get(__ret__, 'tags'))
def get_elasticity_assurances_output(ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                                     output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                     private_pool_options_ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                                     resource_group_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                     status: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                     tags: Optional[pulumi.Input[Optional[Mapping[str, _builtins.str]]]] = None,
                                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetElasticityAssurancesResult]:
    """
    This data source provides Ecs Elasticity Assurance available to the user.

    > **NOTE:** Available in 1.196.0+

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    default = alicloud.ecs.get_elasticity_assurances(ids=[default_alicloud_ecs_elasticity_assurance["id"]])
    pulumi.export("alicloudEcsElasticityAssuranceExampleId", default.assurances[0].id)
    ```


    :param Sequence[_builtins.str] ids: A list of Elasticity Assurance IDs.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param Sequence[_builtins.str] private_pool_options_ids: The ID of the elastic protection service.
    :param _builtins.str resource_group_id: The ID of the resource group.
    :param _builtins.str status: The status of flexible guarantee services. Possible values: `All`, `Preparing`, `Prepared`, `Active`, `Released`.
    :param Mapping[str, _builtins.str] tags: The tag key-value pair information bound by the elastic guarantee service.
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['outputFile'] = output_file
    __args__['privatePoolOptionsIds'] = private_pool_options_ids
    __args__['resourceGroupId'] = resource_group_id
    __args__['status'] = status
    __args__['tags'] = tags
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:ecs/getElasticityAssurances:getElasticityAssurances', __args__, opts=opts, typ=GetElasticityAssurancesResult)
    return __ret__.apply(lambda __response__: GetElasticityAssurancesResult(
        assurances=pulumi.get(__response__, 'assurances'),
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        output_file=pulumi.get(__response__, 'output_file'),
        private_pool_options_ids=pulumi.get(__response__, 'private_pool_options_ids'),
        resource_group_id=pulumi.get(__response__, 'resource_group_id'),
        status=pulumi.get(__response__, 'status'),
        tags=pulumi.get(__response__, 'tags')))
