# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['LaunchTemplateArgs', 'LaunchTemplate']

@pulumi.input_type
class LaunchTemplateArgs:
    def __init__(__self__, *,
                 auto_release_time: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_renew_period: Optional[pulumi.Input[_builtins.int]] = None,
                 data_disks: Optional[pulumi.Input[Sequence[pulumi.Input['LaunchTemplateDataDiskArgs']]]] = None,
                 default_version_number: Optional[pulumi.Input[_builtins.int]] = None,
                 deployment_set_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_vm_os_config: Optional[pulumi.Input[_builtins.bool]] = None,
                 host_name: Optional[pulumi.Input[_builtins.str]] = None,
                 http_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 http_put_response_hop_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 http_tokens: Optional[pulumi.Input[_builtins.str]] = None,
                 image_id: Optional[pulumi.Input[_builtins.str]] = None,
                 image_options: Optional[pulumi.Input['LaunchTemplateImageOptionsArgs']] = None,
                 image_owner_alias: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 internet_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 internet_max_bandwidth_in: Optional[pulumi.Input[_builtins.int]] = None,
                 internet_max_bandwidth_out: Optional[pulumi.Input[_builtins.int]] = None,
                 io_optimized: Optional[pulumi.Input[_builtins.str]] = None,
                 key_pair_name: Optional[pulumi.Input[_builtins.str]] = None,
                 launch_template_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_interfaces: Optional[pulumi.Input['LaunchTemplateNetworkInterfacesArgs']] = None,
                 network_type: Optional[pulumi.Input[_builtins.str]] = None,
                 password_inherit: Optional[pulumi.Input[_builtins.bool]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 private_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 ram_role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_enhancement_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 spot_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 spot_price_limit: Optional[pulumi.Input[_builtins.float]] = None,
                 spot_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk: Optional[pulumi.Input['LaunchTemplateSystemDiskArgs']] = None,
                 system_disk_category: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk_description: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk_name: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk_size: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 template_resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 template_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 update_default_version_number: Optional[pulumi.Input[_builtins.bool]] = None,
                 user_data: Optional[pulumi.Input[_builtins.str]] = None,
                 userdata: Optional[pulumi.Input[_builtins.str]] = None,
                 version_description: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a LaunchTemplate resource.
        :param pulumi.Input[_builtins.str] auto_release_time: Instance auto release time. The time is presented using the ISO8601 standard and in UTC time. The format is  YYYY-MM-DDTHH:MM:SSZ.
        :param pulumi.Input[Sequence[pulumi.Input['LaunchTemplateDataDiskArgs']]] data_disks: The list of data disks created with instance.
        :param pulumi.Input[_builtins.str] description: Description of instance launch template version 1. It can be [2, 256] characters in length. It cannot start with "http://" or "https://". The default value is null.
        :param pulumi.Input[_builtins.str] host_name: Instance host name.It cannot start or end with a period (.) or a hyphen (-) and it cannot have two or more consecutive periods (.) or hyphens (-).For Windows: The host name can be [2, 15] characters in length. It can contain A-Z, a-z, numbers, periods (.), and hyphens (-). It cannot only contain numbers. For other operating systems: The host name can be [2, 64] characters in length. It can be segments separated by periods (.). It can contain A-Z, a-z, numbers, and hyphens (-).
        :param pulumi.Input[_builtins.str] image_id: Image ID.
        :param pulumi.Input[_builtins.str] instance_charge_type: Billing methods. Optional values:
               - PrePaid: Monthly, or annual subscription. Make sure that your registered credit card is invalid or you have insufficient balance in your PayPal account. Otherwise, InvalidPayMethod error may occur.
               - PostPaid: Pay-As-You-Go.
               
               Default value: PostPaid.
        :param pulumi.Input[_builtins.str] instance_name: The name of the instance. The name is a string of 2 to 128 characters. It must begin with an English or a Chinese character. It can contain A-Z, a-z, Chinese characters, numbers, periods (.), colons (:), underscores (_), and hyphens (-).
        :param pulumi.Input[_builtins.str] instance_type: Instance type. For more information, call resource_alicloud_instances to obtain the latest instance type list.
        :param pulumi.Input[_builtins.str] internet_charge_type: Internet bandwidth billing method. Optional values: `PayByTraffic` | `PayByBandwidth`.
        :param pulumi.Input[_builtins.int] internet_max_bandwidth_in: The maximum inbound bandwidth from the Internet network, measured in Mbit/s. Value range: [1, 200].
        :param pulumi.Input[_builtins.int] internet_max_bandwidth_out: Maximum outbound bandwidth from the Internet, its unit of measurement is Mbit/s. Value range: [0, 100].
        :param pulumi.Input[_builtins.str] io_optimized: Whether it is an I/O-optimized instance or not. Optional values:
               - none
               - optimized
        :param pulumi.Input[_builtins.str] key_pair_name: The name of the key pair.
               - Ignore this parameter for Windows instances. It is null by default. Even if you enter this parameter, only the  Password content is used.
               - The password logon method for Linux instances is set to forbidden upon initialization.
        :param pulumi.Input[_builtins.str] name: Instance launch template name. Can contain [2, 128] characters in length. It must start with an English letter or Chinese, can contain numbers, periods (.), colons (:), underscores (_), and hyphens (-). It cannot start with "http://" or "https://".
        :param pulumi.Input['LaunchTemplateNetworkInterfacesArgs'] network_interfaces: The list of network interfaces created with instance.
        :param pulumi.Input[_builtins.str] network_type: Network type of the instance. Value options: `classic` | `vpc`.
        :param pulumi.Input[_builtins.str] ram_role_name: The RAM role name of the instance. You can use the RAM API ListRoles to query instance RAM role names.
        :param pulumi.Input[_builtins.str] security_enhancement_strategy: Whether or not to activate the security enhancement feature and install network security software free of charge. Optional values: Active | Deactive.
        :param pulumi.Input[_builtins.str] security_group_id: The security group ID.
        :param pulumi.Input[_builtins.float] spot_price_limit: Sets the maximum hourly instance price. Supports up to three decimal places.
        :param pulumi.Input[_builtins.str] spot_strategy: The spot strategy for a Pay-As-You-Go instance. This parameter is valid and required only when InstanceChargeType is set to PostPaid. Value range:
               - NoSpot: Normal Pay-As-You-Go instance.
               - SpotWithPriceLimit: Sets the maximum price for a spot instance.
               - SpotAsPriceGo: The system automatically calculates the price. The maximum value is the Pay-As-You-Go price.
        :param pulumi.Input[_builtins.str] system_disk_category: The category of the system disk. System disk type. Optional values:
               - cloud: Basic cloud disk.
               - cloud_efficiency: Ultra cloud disk.
               - cloud_ssd: SSD cloud Disks.
               - ephemeral_ssd: local SSD Disks
               - cloud_essd: ESSD cloud Disks.
        :param pulumi.Input[_builtins.str] system_disk_description: System disk description. It cannot begin with http:// or https://.
        :param pulumi.Input[_builtins.str] system_disk_name: System disk name. The name is a string of 2 to 128 characters. It must begin with an English or a Chinese character. It can contain A-Z, a-z, Chinese characters, numbers, periods (.), colons (:), underscores (_), and hyphens (-).
        :param pulumi.Input[_builtins.int] system_disk_size: Size of the system disk, measured in GB. Value range: [20, 500].
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
               - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
               - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
        :param pulumi.Input[_builtins.str] userdata: User data of the instance, which is Base64-encoded. Size of the raw data cannot exceed 16 KB.
        :param pulumi.Input[_builtins.str] vswitch_id: When creating a VPC-Connected instance, you must specify its VSwitch ID.
        :param pulumi.Input[_builtins.str] zone_id: The zone ID of the instance.
        """
        if auto_release_time is not None:
            pulumi.set(__self__, "auto_release_time", auto_release_time)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if auto_renew_period is not None:
            pulumi.set(__self__, "auto_renew_period", auto_renew_period)
        if data_disks is not None:
            pulumi.set(__self__, "data_disks", data_disks)
        if default_version_number is not None:
            pulumi.set(__self__, "default_version_number", default_version_number)
        if deployment_set_id is not None:
            pulumi.set(__self__, "deployment_set_id", deployment_set_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enable_vm_os_config is not None:
            pulumi.set(__self__, "enable_vm_os_config", enable_vm_os_config)
        if host_name is not None:
            pulumi.set(__self__, "host_name", host_name)
        if http_endpoint is not None:
            pulumi.set(__self__, "http_endpoint", http_endpoint)
        if http_put_response_hop_limit is not None:
            pulumi.set(__self__, "http_put_response_hop_limit", http_put_response_hop_limit)
        if http_tokens is not None:
            pulumi.set(__self__, "http_tokens", http_tokens)
        if image_id is not None:
            pulumi.set(__self__, "image_id", image_id)
        if image_options is not None:
            pulumi.set(__self__, "image_options", image_options)
        if image_owner_alias is not None:
            pulumi.set(__self__, "image_owner_alias", image_owner_alias)
        if instance_charge_type is not None:
            pulumi.set(__self__, "instance_charge_type", instance_charge_type)
        if instance_name is not None:
            pulumi.set(__self__, "instance_name", instance_name)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if internet_charge_type is not None:
            pulumi.set(__self__, "internet_charge_type", internet_charge_type)
        if internet_max_bandwidth_in is not None:
            pulumi.set(__self__, "internet_max_bandwidth_in", internet_max_bandwidth_in)
        if internet_max_bandwidth_out is not None:
            pulumi.set(__self__, "internet_max_bandwidth_out", internet_max_bandwidth_out)
        if io_optimized is not None:
            pulumi.set(__self__, "io_optimized", io_optimized)
        if key_pair_name is not None:
            pulumi.set(__self__, "key_pair_name", key_pair_name)
        if launch_template_name is not None:
            pulumi.set(__self__, "launch_template_name", launch_template_name)
        if name is not None:
            warnings.warn("""Field 'name' has been deprecated from provider version 1.120.0. New field 'launch_template_name' instead.""", DeprecationWarning)
            pulumi.log.warn("""name is deprecated: Field 'name' has been deprecated from provider version 1.120.0. New field 'launch_template_name' instead.""")
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_interfaces is not None:
            pulumi.set(__self__, "network_interfaces", network_interfaces)
        if network_type is not None:
            pulumi.set(__self__, "network_type", network_type)
        if password_inherit is not None:
            pulumi.set(__self__, "password_inherit", password_inherit)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)
        if private_ip_address is not None:
            pulumi.set(__self__, "private_ip_address", private_ip_address)
        if ram_role_name is not None:
            pulumi.set(__self__, "ram_role_name", ram_role_name)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if security_enhancement_strategy is not None:
            pulumi.set(__self__, "security_enhancement_strategy", security_enhancement_strategy)
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if spot_duration is not None:
            pulumi.set(__self__, "spot_duration", spot_duration)
        if spot_price_limit is not None:
            pulumi.set(__self__, "spot_price_limit", spot_price_limit)
        if spot_strategy is not None:
            pulumi.set(__self__, "spot_strategy", spot_strategy)
        if system_disk is not None:
            pulumi.set(__self__, "system_disk", system_disk)
        if system_disk_category is not None:
            warnings.warn("""Field 'system_disk_category' has been deprecated from provider version 1.120.0. New field 'system_disk' instead.""", DeprecationWarning)
            pulumi.log.warn("""system_disk_category is deprecated: Field 'system_disk_category' has been deprecated from provider version 1.120.0. New field 'system_disk' instead.""")
        if system_disk_category is not None:
            pulumi.set(__self__, "system_disk_category", system_disk_category)
        if system_disk_description is not None:
            warnings.warn("""Field 'system_disk_description' has been deprecated from provider version 1.120.0. New field 'system_disk' instead.""", DeprecationWarning)
            pulumi.log.warn("""system_disk_description is deprecated: Field 'system_disk_description' has been deprecated from provider version 1.120.0. New field 'system_disk' instead.""")
        if system_disk_description is not None:
            pulumi.set(__self__, "system_disk_description", system_disk_description)
        if system_disk_name is not None:
            warnings.warn("""Field 'system_disk_name' has been deprecated from provider version 1.120.0. New field 'system_disk' instead.""", DeprecationWarning)
            pulumi.log.warn("""system_disk_name is deprecated: Field 'system_disk_name' has been deprecated from provider version 1.120.0. New field 'system_disk' instead.""")
        if system_disk_name is not None:
            pulumi.set(__self__, "system_disk_name", system_disk_name)
        if system_disk_size is not None:
            warnings.warn("""Field 'system_disk_size' has been deprecated from provider version 1.120.0. New field 'system_disk' instead.""", DeprecationWarning)
            pulumi.log.warn("""system_disk_size is deprecated: Field 'system_disk_size' has been deprecated from provider version 1.120.0. New field 'system_disk' instead.""")
        if system_disk_size is not None:
            pulumi.set(__self__, "system_disk_size", system_disk_size)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if template_resource_group_id is not None:
            pulumi.set(__self__, "template_resource_group_id", template_resource_group_id)
        if template_tags is not None:
            pulumi.set(__self__, "template_tags", template_tags)
        if update_default_version_number is not None:
            pulumi.set(__self__, "update_default_version_number", update_default_version_number)
        if user_data is not None:
            pulumi.set(__self__, "user_data", user_data)
        if userdata is not None:
            warnings.warn("""Field 'userdata' has been deprecated from provider version 1.120.0. New field 'user_data' instead.""", DeprecationWarning)
            pulumi.log.warn("""userdata is deprecated: Field 'userdata' has been deprecated from provider version 1.120.0. New field 'user_data' instead.""")
        if userdata is not None:
            pulumi.set(__self__, "userdata", userdata)
        if version_description is not None:
            pulumi.set(__self__, "version_description", version_description)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter(name="autoReleaseTime")
    def auto_release_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Instance auto release time. The time is presented using the ISO8601 standard and in UTC time. The format is  YYYY-MM-DDTHH:MM:SSZ.
        """
        return pulumi.get(self, "auto_release_time")

    @auto_release_time.setter
    def auto_release_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_release_time", value)

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_renew", value)

    @_builtins.property
    @pulumi.getter(name="autoRenewPeriod")
    def auto_renew_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "auto_renew_period")

    @auto_renew_period.setter
    def auto_renew_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "auto_renew_period", value)

    @_builtins.property
    @pulumi.getter(name="dataDisks")
    def data_disks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LaunchTemplateDataDiskArgs']]]]:
        """
        The list of data disks created with instance.
        """
        return pulumi.get(self, "data_disks")

    @data_disks.setter
    def data_disks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LaunchTemplateDataDiskArgs']]]]):
        pulumi.set(self, "data_disks", value)

    @_builtins.property
    @pulumi.getter(name="defaultVersionNumber")
    def default_version_number(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "default_version_number")

    @default_version_number.setter
    def default_version_number(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "default_version_number", value)

    @_builtins.property
    @pulumi.getter(name="deploymentSetId")
    def deployment_set_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "deployment_set_id")

    @deployment_set_id.setter
    def deployment_set_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "deployment_set_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of instance launch template version 1. It can be [2, 256] characters in length. It cannot start with "http://" or "https://". The default value is null.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="enableVmOsConfig")
    def enable_vm_os_config(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "enable_vm_os_config")

    @enable_vm_os_config.setter
    def enable_vm_os_config(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_vm_os_config", value)

    @_builtins.property
    @pulumi.getter(name="hostName")
    def host_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Instance host name.It cannot start or end with a period (.) or a hyphen (-) and it cannot have two or more consecutive periods (.) or hyphens (-).For Windows: The host name can be [2, 15] characters in length. It can contain A-Z, a-z, numbers, periods (.), and hyphens (-). It cannot only contain numbers. For other operating systems: The host name can be [2, 64] characters in length. It can be segments separated by periods (.). It can contain A-Z, a-z, numbers, and hyphens (-).
        """
        return pulumi.get(self, "host_name")

    @host_name.setter
    def host_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "host_name", value)

    @_builtins.property
    @pulumi.getter(name="httpEndpoint")
    def http_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "http_endpoint")

    @http_endpoint.setter
    def http_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "http_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="httpPutResponseHopLimit")
    def http_put_response_hop_limit(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "http_put_response_hop_limit")

    @http_put_response_hop_limit.setter
    def http_put_response_hop_limit(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "http_put_response_hop_limit", value)

    @_builtins.property
    @pulumi.getter(name="httpTokens")
    def http_tokens(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "http_tokens")

    @http_tokens.setter
    def http_tokens(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "http_tokens", value)

    @_builtins.property
    @pulumi.getter(name="imageId")
    def image_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Image ID.
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "image_id", value)

    @_builtins.property
    @pulumi.getter(name="imageOptions")
    def image_options(self) -> Optional[pulumi.Input['LaunchTemplateImageOptionsArgs']]:
        return pulumi.get(self, "image_options")

    @image_options.setter
    def image_options(self, value: Optional[pulumi.Input['LaunchTemplateImageOptionsArgs']]):
        pulumi.set(self, "image_options", value)

    @_builtins.property
    @pulumi.getter(name="imageOwnerAlias")
    def image_owner_alias(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "image_owner_alias")

    @image_owner_alias.setter
    def image_owner_alias(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "image_owner_alias", value)

    @_builtins.property
    @pulumi.getter(name="instanceChargeType")
    def instance_charge_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Billing methods. Optional values:
        - PrePaid: Monthly, or annual subscription. Make sure that your registered credit card is invalid or you have insufficient balance in your PayPal account. Otherwise, InvalidPayMethod error may occur.
        - PostPaid: Pay-As-You-Go.

        Default value: PostPaid.
        """
        return pulumi.get(self, "instance_charge_type")

    @instance_charge_type.setter
    def instance_charge_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_charge_type", value)

    @_builtins.property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the instance. The name is a string of 2 to 128 characters. It must begin with an English or a Chinese character. It can contain A-Z, a-z, Chinese characters, numbers, periods (.), colons (:), underscores (_), and hyphens (-).
        """
        return pulumi.get(self, "instance_name")

    @instance_name.setter
    def instance_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_name", value)

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Instance type. For more information, call resource_alicloud_instances to obtain the latest instance type list.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_type", value)

    @_builtins.property
    @pulumi.getter(name="internetChargeType")
    def internet_charge_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Internet bandwidth billing method. Optional values: `PayByTraffic` | `PayByBandwidth`.
        """
        return pulumi.get(self, "internet_charge_type")

    @internet_charge_type.setter
    def internet_charge_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "internet_charge_type", value)

    @_builtins.property
    @pulumi.getter(name="internetMaxBandwidthIn")
    def internet_max_bandwidth_in(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum inbound bandwidth from the Internet network, measured in Mbit/s. Value range: [1, 200].
        """
        return pulumi.get(self, "internet_max_bandwidth_in")

    @internet_max_bandwidth_in.setter
    def internet_max_bandwidth_in(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "internet_max_bandwidth_in", value)

    @_builtins.property
    @pulumi.getter(name="internetMaxBandwidthOut")
    def internet_max_bandwidth_out(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum outbound bandwidth from the Internet, its unit of measurement is Mbit/s. Value range: [0, 100].
        """
        return pulumi.get(self, "internet_max_bandwidth_out")

    @internet_max_bandwidth_out.setter
    def internet_max_bandwidth_out(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "internet_max_bandwidth_out", value)

    @_builtins.property
    @pulumi.getter(name="ioOptimized")
    def io_optimized(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether it is an I/O-optimized instance or not. Optional values:
        - none
        - optimized
        """
        return pulumi.get(self, "io_optimized")

    @io_optimized.setter
    def io_optimized(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "io_optimized", value)

    @_builtins.property
    @pulumi.getter(name="keyPairName")
    def key_pair_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the key pair.
        - Ignore this parameter for Windows instances. It is null by default. Even if you enter this parameter, only the  Password content is used.
        - The password logon method for Linux instances is set to forbidden upon initialization.
        """
        return pulumi.get(self, "key_pair_name")

    @key_pair_name.setter
    def key_pair_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_pair_name", value)

    @_builtins.property
    @pulumi.getter(name="launchTemplateName")
    def launch_template_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "launch_template_name")

    @launch_template_name.setter
    def launch_template_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "launch_template_name", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'name' has been deprecated from provider version 1.120.0. New field 'launch_template_name' instead.""")
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Instance launch template name. Can contain [2, 128] characters in length. It must start with an English letter or Chinese, can contain numbers, periods (.), colons (:), underscores (_), and hyphens (-). It cannot start with "http://" or "https://".
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> Optional[pulumi.Input['LaunchTemplateNetworkInterfacesArgs']]:
        """
        The list of network interfaces created with instance.
        """
        return pulumi.get(self, "network_interfaces")

    @network_interfaces.setter
    def network_interfaces(self, value: Optional[pulumi.Input['LaunchTemplateNetworkInterfacesArgs']]):
        pulumi.set(self, "network_interfaces", value)

    @_builtins.property
    @pulumi.getter(name="networkType")
    def network_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Network type of the instance. Value options: `classic` | `vpc`.
        """
        return pulumi.get(self, "network_type")

    @network_type.setter
    def network_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_type", value)

    @_builtins.property
    @pulumi.getter(name="passwordInherit")
    def password_inherit(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "password_inherit")

    @password_inherit.setter
    def password_inherit(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "password_inherit", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "period_unit", value)

    @_builtins.property
    @pulumi.getter(name="privateIpAddress")
    def private_ip_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "private_ip_address")

    @private_ip_address.setter
    def private_ip_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_ip_address", value)

    @_builtins.property
    @pulumi.getter(name="ramRoleName")
    def ram_role_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The RAM role name of the instance. You can use the RAM API ListRoles to query instance RAM role names.
        """
        return pulumi.get(self, "ram_role_name")

    @ram_role_name.setter
    def ram_role_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ram_role_name", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="securityEnhancementStrategy")
    def security_enhancement_strategy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether or not to activate the security enhancement feature and install network security software free of charge. Optional values: Active | Deactive.
        """
        return pulumi.get(self, "security_enhancement_strategy")

    @security_enhancement_strategy.setter
    def security_enhancement_strategy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_enhancement_strategy", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The security group ID.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_group_id", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @_builtins.property
    @pulumi.getter(name="spotDuration")
    def spot_duration(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "spot_duration")

    @spot_duration.setter
    def spot_duration(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "spot_duration", value)

    @_builtins.property
    @pulumi.getter(name="spotPriceLimit")
    def spot_price_limit(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        Sets the maximum hourly instance price. Supports up to three decimal places.
        """
        return pulumi.get(self, "spot_price_limit")

    @spot_price_limit.setter
    def spot_price_limit(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "spot_price_limit", value)

    @_builtins.property
    @pulumi.getter(name="spotStrategy")
    def spot_strategy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The spot strategy for a Pay-As-You-Go instance. This parameter is valid and required only when InstanceChargeType is set to PostPaid. Value range:
        - NoSpot: Normal Pay-As-You-Go instance.
        - SpotWithPriceLimit: Sets the maximum price for a spot instance.
        - SpotAsPriceGo: The system automatically calculates the price. The maximum value is the Pay-As-You-Go price.
        """
        return pulumi.get(self, "spot_strategy")

    @spot_strategy.setter
    def spot_strategy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "spot_strategy", value)

    @_builtins.property
    @pulumi.getter(name="systemDisk")
    def system_disk(self) -> Optional[pulumi.Input['LaunchTemplateSystemDiskArgs']]:
        return pulumi.get(self, "system_disk")

    @system_disk.setter
    def system_disk(self, value: Optional[pulumi.Input['LaunchTemplateSystemDiskArgs']]):
        pulumi.set(self, "system_disk", value)

    @_builtins.property
    @pulumi.getter(name="systemDiskCategory")
    @_utilities.deprecated("""Field 'system_disk_category' has been deprecated from provider version 1.120.0. New field 'system_disk' instead.""")
    def system_disk_category(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The category of the system disk. System disk type. Optional values:
        - cloud: Basic cloud disk.
        - cloud_efficiency: Ultra cloud disk.
        - cloud_ssd: SSD cloud Disks.
        - ephemeral_ssd: local SSD Disks
        - cloud_essd: ESSD cloud Disks.
        """
        return pulumi.get(self, "system_disk_category")

    @system_disk_category.setter
    def system_disk_category(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "system_disk_category", value)

    @_builtins.property
    @pulumi.getter(name="systemDiskDescription")
    @_utilities.deprecated("""Field 'system_disk_description' has been deprecated from provider version 1.120.0. New field 'system_disk' instead.""")
    def system_disk_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        System disk description. It cannot begin with http:// or https://.
        """
        return pulumi.get(self, "system_disk_description")

    @system_disk_description.setter
    def system_disk_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "system_disk_description", value)

    @_builtins.property
    @pulumi.getter(name="systemDiskName")
    @_utilities.deprecated("""Field 'system_disk_name' has been deprecated from provider version 1.120.0. New field 'system_disk' instead.""")
    def system_disk_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        System disk name. The name is a string of 2 to 128 characters. It must begin with an English or a Chinese character. It can contain A-Z, a-z, Chinese characters, numbers, periods (.), colons (:), underscores (_), and hyphens (-).
        """
        return pulumi.get(self, "system_disk_name")

    @system_disk_name.setter
    def system_disk_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "system_disk_name", value)

    @_builtins.property
    @pulumi.getter(name="systemDiskSize")
    @_utilities.deprecated("""Field 'system_disk_size' has been deprecated from provider version 1.120.0. New field 'system_disk' instead.""")
    def system_disk_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Size of the system disk, measured in GB. Value range: [20, 500].
        """
        return pulumi.get(self, "system_disk_size")

    @system_disk_size.setter
    def system_disk_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "system_disk_size", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
        - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="templateResourceGroupId")
    def template_resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "template_resource_group_id")

    @template_resource_group_id.setter
    def template_resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "template_resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="templateTags")
    def template_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "template_tags")

    @template_tags.setter
    def template_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "template_tags", value)

    @_builtins.property
    @pulumi.getter(name="updateDefaultVersionNumber")
    def update_default_version_number(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "update_default_version_number")

    @update_default_version_number.setter
    def update_default_version_number(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "update_default_version_number", value)

    @_builtins.property
    @pulumi.getter(name="userData")
    def user_data(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "user_data")

    @user_data.setter
    def user_data(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_data", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'userdata' has been deprecated from provider version 1.120.0. New field 'user_data' instead.""")
    def userdata(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User data of the instance, which is Base64-encoded. Size of the raw data cannot exceed 16 KB.
        """
        return pulumi.get(self, "userdata")

    @userdata.setter
    def userdata(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "userdata", value)

    @_builtins.property
    @pulumi.getter(name="versionDescription")
    def version_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "version_description")

    @version_description.setter
    def version_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version_description", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        When creating a VPC-Connected instance, you must specify its VSwitch ID.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vswitch_id", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The zone ID of the instance.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone_id", value)


@pulumi.input_type
class _LaunchTemplateState:
    def __init__(__self__, *,
                 auto_release_time: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_renew_period: Optional[pulumi.Input[_builtins.int]] = None,
                 data_disks: Optional[pulumi.Input[Sequence[pulumi.Input['LaunchTemplateDataDiskArgs']]]] = None,
                 default_version_number: Optional[pulumi.Input[_builtins.int]] = None,
                 deployment_set_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_vm_os_config: Optional[pulumi.Input[_builtins.bool]] = None,
                 host_name: Optional[pulumi.Input[_builtins.str]] = None,
                 http_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 http_put_response_hop_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 http_tokens: Optional[pulumi.Input[_builtins.str]] = None,
                 image_id: Optional[pulumi.Input[_builtins.str]] = None,
                 image_options: Optional[pulumi.Input['LaunchTemplateImageOptionsArgs']] = None,
                 image_owner_alias: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 internet_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 internet_max_bandwidth_in: Optional[pulumi.Input[_builtins.int]] = None,
                 internet_max_bandwidth_out: Optional[pulumi.Input[_builtins.int]] = None,
                 io_optimized: Optional[pulumi.Input[_builtins.str]] = None,
                 key_pair_name: Optional[pulumi.Input[_builtins.str]] = None,
                 latest_version_number: Optional[pulumi.Input[_builtins.int]] = None,
                 launch_template_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_interfaces: Optional[pulumi.Input['LaunchTemplateNetworkInterfacesArgs']] = None,
                 network_type: Optional[pulumi.Input[_builtins.str]] = None,
                 password_inherit: Optional[pulumi.Input[_builtins.bool]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 private_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 ram_role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_enhancement_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 spot_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 spot_price_limit: Optional[pulumi.Input[_builtins.float]] = None,
                 spot_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk: Optional[pulumi.Input['LaunchTemplateSystemDiskArgs']] = None,
                 system_disk_category: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk_description: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk_name: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk_size: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 template_resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 template_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 update_default_version_number: Optional[pulumi.Input[_builtins.bool]] = None,
                 user_data: Optional[pulumi.Input[_builtins.str]] = None,
                 userdata: Optional[pulumi.Input[_builtins.str]] = None,
                 version_description: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering LaunchTemplate resources.
        :param pulumi.Input[_builtins.str] auto_release_time: Instance auto release time. The time is presented using the ISO8601 standard and in UTC time. The format is  YYYY-MM-DDTHH:MM:SSZ.
        :param pulumi.Input[Sequence[pulumi.Input['LaunchTemplateDataDiskArgs']]] data_disks: The list of data disks created with instance.
        :param pulumi.Input[_builtins.str] description: Description of instance launch template version 1. It can be [2, 256] characters in length. It cannot start with "http://" or "https://". The default value is null.
        :param pulumi.Input[_builtins.str] host_name: Instance host name.It cannot start or end with a period (.) or a hyphen (-) and it cannot have two or more consecutive periods (.) or hyphens (-).For Windows: The host name can be [2, 15] characters in length. It can contain A-Z, a-z, numbers, periods (.), and hyphens (-). It cannot only contain numbers. For other operating systems: The host name can be [2, 64] characters in length. It can be segments separated by periods (.). It can contain A-Z, a-z, numbers, and hyphens (-).
        :param pulumi.Input[_builtins.str] image_id: Image ID.
        :param pulumi.Input[_builtins.str] instance_charge_type: Billing methods. Optional values:
               - PrePaid: Monthly, or annual subscription. Make sure that your registered credit card is invalid or you have insufficient balance in your PayPal account. Otherwise, InvalidPayMethod error may occur.
               - PostPaid: Pay-As-You-Go.
               
               Default value: PostPaid.
        :param pulumi.Input[_builtins.str] instance_name: The name of the instance. The name is a string of 2 to 128 characters. It must begin with an English or a Chinese character. It can contain A-Z, a-z, Chinese characters, numbers, periods (.), colons (:), underscores (_), and hyphens (-).
        :param pulumi.Input[_builtins.str] instance_type: Instance type. For more information, call resource_alicloud_instances to obtain the latest instance type list.
        :param pulumi.Input[_builtins.str] internet_charge_type: Internet bandwidth billing method. Optional values: `PayByTraffic` | `PayByBandwidth`.
        :param pulumi.Input[_builtins.int] internet_max_bandwidth_in: The maximum inbound bandwidth from the Internet network, measured in Mbit/s. Value range: [1, 200].
        :param pulumi.Input[_builtins.int] internet_max_bandwidth_out: Maximum outbound bandwidth from the Internet, its unit of measurement is Mbit/s. Value range: [0, 100].
        :param pulumi.Input[_builtins.str] io_optimized: Whether it is an I/O-optimized instance or not. Optional values:
               - none
               - optimized
        :param pulumi.Input[_builtins.str] key_pair_name: The name of the key pair.
               - Ignore this parameter for Windows instances. It is null by default. Even if you enter this parameter, only the  Password content is used.
               - The password logon method for Linux instances is set to forbidden upon initialization.
        :param pulumi.Input[_builtins.str] name: Instance launch template name. Can contain [2, 128] characters in length. It must start with an English letter or Chinese, can contain numbers, periods (.), colons (:), underscores (_), and hyphens (-). It cannot start with "http://" or "https://".
        :param pulumi.Input['LaunchTemplateNetworkInterfacesArgs'] network_interfaces: The list of network interfaces created with instance.
        :param pulumi.Input[_builtins.str] network_type: Network type of the instance. Value options: `classic` | `vpc`.
        :param pulumi.Input[_builtins.str] ram_role_name: The RAM role name of the instance. You can use the RAM API ListRoles to query instance RAM role names.
        :param pulumi.Input[_builtins.str] security_enhancement_strategy: Whether or not to activate the security enhancement feature and install network security software free of charge. Optional values: Active | Deactive.
        :param pulumi.Input[_builtins.str] security_group_id: The security group ID.
        :param pulumi.Input[_builtins.float] spot_price_limit: Sets the maximum hourly instance price. Supports up to three decimal places.
        :param pulumi.Input[_builtins.str] spot_strategy: The spot strategy for a Pay-As-You-Go instance. This parameter is valid and required only when InstanceChargeType is set to PostPaid. Value range:
               - NoSpot: Normal Pay-As-You-Go instance.
               - SpotWithPriceLimit: Sets the maximum price for a spot instance.
               - SpotAsPriceGo: The system automatically calculates the price. The maximum value is the Pay-As-You-Go price.
        :param pulumi.Input[_builtins.str] system_disk_category: The category of the system disk. System disk type. Optional values:
               - cloud: Basic cloud disk.
               - cloud_efficiency: Ultra cloud disk.
               - cloud_ssd: SSD cloud Disks.
               - ephemeral_ssd: local SSD Disks
               - cloud_essd: ESSD cloud Disks.
        :param pulumi.Input[_builtins.str] system_disk_description: System disk description. It cannot begin with http:// or https://.
        :param pulumi.Input[_builtins.str] system_disk_name: System disk name. The name is a string of 2 to 128 characters. It must begin with an English or a Chinese character. It can contain A-Z, a-z, Chinese characters, numbers, periods (.), colons (:), underscores (_), and hyphens (-).
        :param pulumi.Input[_builtins.int] system_disk_size: Size of the system disk, measured in GB. Value range: [20, 500].
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
               - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
               - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
        :param pulumi.Input[_builtins.str] userdata: User data of the instance, which is Base64-encoded. Size of the raw data cannot exceed 16 KB.
        :param pulumi.Input[_builtins.str] vswitch_id: When creating a VPC-Connected instance, you must specify its VSwitch ID.
        :param pulumi.Input[_builtins.str] zone_id: The zone ID of the instance.
        """
        if auto_release_time is not None:
            pulumi.set(__self__, "auto_release_time", auto_release_time)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if auto_renew_period is not None:
            pulumi.set(__self__, "auto_renew_period", auto_renew_period)
        if data_disks is not None:
            pulumi.set(__self__, "data_disks", data_disks)
        if default_version_number is not None:
            pulumi.set(__self__, "default_version_number", default_version_number)
        if deployment_set_id is not None:
            pulumi.set(__self__, "deployment_set_id", deployment_set_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enable_vm_os_config is not None:
            pulumi.set(__self__, "enable_vm_os_config", enable_vm_os_config)
        if host_name is not None:
            pulumi.set(__self__, "host_name", host_name)
        if http_endpoint is not None:
            pulumi.set(__self__, "http_endpoint", http_endpoint)
        if http_put_response_hop_limit is not None:
            pulumi.set(__self__, "http_put_response_hop_limit", http_put_response_hop_limit)
        if http_tokens is not None:
            pulumi.set(__self__, "http_tokens", http_tokens)
        if image_id is not None:
            pulumi.set(__self__, "image_id", image_id)
        if image_options is not None:
            pulumi.set(__self__, "image_options", image_options)
        if image_owner_alias is not None:
            pulumi.set(__self__, "image_owner_alias", image_owner_alias)
        if instance_charge_type is not None:
            pulumi.set(__self__, "instance_charge_type", instance_charge_type)
        if instance_name is not None:
            pulumi.set(__self__, "instance_name", instance_name)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if internet_charge_type is not None:
            pulumi.set(__self__, "internet_charge_type", internet_charge_type)
        if internet_max_bandwidth_in is not None:
            pulumi.set(__self__, "internet_max_bandwidth_in", internet_max_bandwidth_in)
        if internet_max_bandwidth_out is not None:
            pulumi.set(__self__, "internet_max_bandwidth_out", internet_max_bandwidth_out)
        if io_optimized is not None:
            pulumi.set(__self__, "io_optimized", io_optimized)
        if key_pair_name is not None:
            pulumi.set(__self__, "key_pair_name", key_pair_name)
        if latest_version_number is not None:
            pulumi.set(__self__, "latest_version_number", latest_version_number)
        if launch_template_name is not None:
            pulumi.set(__self__, "launch_template_name", launch_template_name)
        if name is not None:
            warnings.warn("""Field 'name' has been deprecated from provider version 1.120.0. New field 'launch_template_name' instead.""", DeprecationWarning)
            pulumi.log.warn("""name is deprecated: Field 'name' has been deprecated from provider version 1.120.0. New field 'launch_template_name' instead.""")
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_interfaces is not None:
            pulumi.set(__self__, "network_interfaces", network_interfaces)
        if network_type is not None:
            pulumi.set(__self__, "network_type", network_type)
        if password_inherit is not None:
            pulumi.set(__self__, "password_inherit", password_inherit)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)
        if private_ip_address is not None:
            pulumi.set(__self__, "private_ip_address", private_ip_address)
        if ram_role_name is not None:
            pulumi.set(__self__, "ram_role_name", ram_role_name)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if security_enhancement_strategy is not None:
            pulumi.set(__self__, "security_enhancement_strategy", security_enhancement_strategy)
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if spot_duration is not None:
            pulumi.set(__self__, "spot_duration", spot_duration)
        if spot_price_limit is not None:
            pulumi.set(__self__, "spot_price_limit", spot_price_limit)
        if spot_strategy is not None:
            pulumi.set(__self__, "spot_strategy", spot_strategy)
        if system_disk is not None:
            pulumi.set(__self__, "system_disk", system_disk)
        if system_disk_category is not None:
            warnings.warn("""Field 'system_disk_category' has been deprecated from provider version 1.120.0. New field 'system_disk' instead.""", DeprecationWarning)
            pulumi.log.warn("""system_disk_category is deprecated: Field 'system_disk_category' has been deprecated from provider version 1.120.0. New field 'system_disk' instead.""")
        if system_disk_category is not None:
            pulumi.set(__self__, "system_disk_category", system_disk_category)
        if system_disk_description is not None:
            warnings.warn("""Field 'system_disk_description' has been deprecated from provider version 1.120.0. New field 'system_disk' instead.""", DeprecationWarning)
            pulumi.log.warn("""system_disk_description is deprecated: Field 'system_disk_description' has been deprecated from provider version 1.120.0. New field 'system_disk' instead.""")
        if system_disk_description is not None:
            pulumi.set(__self__, "system_disk_description", system_disk_description)
        if system_disk_name is not None:
            warnings.warn("""Field 'system_disk_name' has been deprecated from provider version 1.120.0. New field 'system_disk' instead.""", DeprecationWarning)
            pulumi.log.warn("""system_disk_name is deprecated: Field 'system_disk_name' has been deprecated from provider version 1.120.0. New field 'system_disk' instead.""")
        if system_disk_name is not None:
            pulumi.set(__self__, "system_disk_name", system_disk_name)
        if system_disk_size is not None:
            warnings.warn("""Field 'system_disk_size' has been deprecated from provider version 1.120.0. New field 'system_disk' instead.""", DeprecationWarning)
            pulumi.log.warn("""system_disk_size is deprecated: Field 'system_disk_size' has been deprecated from provider version 1.120.0. New field 'system_disk' instead.""")
        if system_disk_size is not None:
            pulumi.set(__self__, "system_disk_size", system_disk_size)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if template_resource_group_id is not None:
            pulumi.set(__self__, "template_resource_group_id", template_resource_group_id)
        if template_tags is not None:
            pulumi.set(__self__, "template_tags", template_tags)
        if update_default_version_number is not None:
            pulumi.set(__self__, "update_default_version_number", update_default_version_number)
        if user_data is not None:
            pulumi.set(__self__, "user_data", user_data)
        if userdata is not None:
            warnings.warn("""Field 'userdata' has been deprecated from provider version 1.120.0. New field 'user_data' instead.""", DeprecationWarning)
            pulumi.log.warn("""userdata is deprecated: Field 'userdata' has been deprecated from provider version 1.120.0. New field 'user_data' instead.""")
        if userdata is not None:
            pulumi.set(__self__, "userdata", userdata)
        if version_description is not None:
            pulumi.set(__self__, "version_description", version_description)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter(name="autoReleaseTime")
    def auto_release_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Instance auto release time. The time is presented using the ISO8601 standard and in UTC time. The format is  YYYY-MM-DDTHH:MM:SSZ.
        """
        return pulumi.get(self, "auto_release_time")

    @auto_release_time.setter
    def auto_release_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_release_time", value)

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_renew", value)

    @_builtins.property
    @pulumi.getter(name="autoRenewPeriod")
    def auto_renew_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "auto_renew_period")

    @auto_renew_period.setter
    def auto_renew_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "auto_renew_period", value)

    @_builtins.property
    @pulumi.getter(name="dataDisks")
    def data_disks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LaunchTemplateDataDiskArgs']]]]:
        """
        The list of data disks created with instance.
        """
        return pulumi.get(self, "data_disks")

    @data_disks.setter
    def data_disks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LaunchTemplateDataDiskArgs']]]]):
        pulumi.set(self, "data_disks", value)

    @_builtins.property
    @pulumi.getter(name="defaultVersionNumber")
    def default_version_number(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "default_version_number")

    @default_version_number.setter
    def default_version_number(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "default_version_number", value)

    @_builtins.property
    @pulumi.getter(name="deploymentSetId")
    def deployment_set_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "deployment_set_id")

    @deployment_set_id.setter
    def deployment_set_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "deployment_set_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of instance launch template version 1. It can be [2, 256] characters in length. It cannot start with "http://" or "https://". The default value is null.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="enableVmOsConfig")
    def enable_vm_os_config(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "enable_vm_os_config")

    @enable_vm_os_config.setter
    def enable_vm_os_config(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_vm_os_config", value)

    @_builtins.property
    @pulumi.getter(name="hostName")
    def host_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Instance host name.It cannot start or end with a period (.) or a hyphen (-) and it cannot have two or more consecutive periods (.) or hyphens (-).For Windows: The host name can be [2, 15] characters in length. It can contain A-Z, a-z, numbers, periods (.), and hyphens (-). It cannot only contain numbers. For other operating systems: The host name can be [2, 64] characters in length. It can be segments separated by periods (.). It can contain A-Z, a-z, numbers, and hyphens (-).
        """
        return pulumi.get(self, "host_name")

    @host_name.setter
    def host_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "host_name", value)

    @_builtins.property
    @pulumi.getter(name="httpEndpoint")
    def http_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "http_endpoint")

    @http_endpoint.setter
    def http_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "http_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="httpPutResponseHopLimit")
    def http_put_response_hop_limit(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "http_put_response_hop_limit")

    @http_put_response_hop_limit.setter
    def http_put_response_hop_limit(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "http_put_response_hop_limit", value)

    @_builtins.property
    @pulumi.getter(name="httpTokens")
    def http_tokens(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "http_tokens")

    @http_tokens.setter
    def http_tokens(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "http_tokens", value)

    @_builtins.property
    @pulumi.getter(name="imageId")
    def image_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Image ID.
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "image_id", value)

    @_builtins.property
    @pulumi.getter(name="imageOptions")
    def image_options(self) -> Optional[pulumi.Input['LaunchTemplateImageOptionsArgs']]:
        return pulumi.get(self, "image_options")

    @image_options.setter
    def image_options(self, value: Optional[pulumi.Input['LaunchTemplateImageOptionsArgs']]):
        pulumi.set(self, "image_options", value)

    @_builtins.property
    @pulumi.getter(name="imageOwnerAlias")
    def image_owner_alias(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "image_owner_alias")

    @image_owner_alias.setter
    def image_owner_alias(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "image_owner_alias", value)

    @_builtins.property
    @pulumi.getter(name="instanceChargeType")
    def instance_charge_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Billing methods. Optional values:
        - PrePaid: Monthly, or annual subscription. Make sure that your registered credit card is invalid or you have insufficient balance in your PayPal account. Otherwise, InvalidPayMethod error may occur.
        - PostPaid: Pay-As-You-Go.

        Default value: PostPaid.
        """
        return pulumi.get(self, "instance_charge_type")

    @instance_charge_type.setter
    def instance_charge_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_charge_type", value)

    @_builtins.property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the instance. The name is a string of 2 to 128 characters. It must begin with an English or a Chinese character. It can contain A-Z, a-z, Chinese characters, numbers, periods (.), colons (:), underscores (_), and hyphens (-).
        """
        return pulumi.get(self, "instance_name")

    @instance_name.setter
    def instance_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_name", value)

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Instance type. For more information, call resource_alicloud_instances to obtain the latest instance type list.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_type", value)

    @_builtins.property
    @pulumi.getter(name="internetChargeType")
    def internet_charge_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Internet bandwidth billing method. Optional values: `PayByTraffic` | `PayByBandwidth`.
        """
        return pulumi.get(self, "internet_charge_type")

    @internet_charge_type.setter
    def internet_charge_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "internet_charge_type", value)

    @_builtins.property
    @pulumi.getter(name="internetMaxBandwidthIn")
    def internet_max_bandwidth_in(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum inbound bandwidth from the Internet network, measured in Mbit/s. Value range: [1, 200].
        """
        return pulumi.get(self, "internet_max_bandwidth_in")

    @internet_max_bandwidth_in.setter
    def internet_max_bandwidth_in(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "internet_max_bandwidth_in", value)

    @_builtins.property
    @pulumi.getter(name="internetMaxBandwidthOut")
    def internet_max_bandwidth_out(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum outbound bandwidth from the Internet, its unit of measurement is Mbit/s. Value range: [0, 100].
        """
        return pulumi.get(self, "internet_max_bandwidth_out")

    @internet_max_bandwidth_out.setter
    def internet_max_bandwidth_out(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "internet_max_bandwidth_out", value)

    @_builtins.property
    @pulumi.getter(name="ioOptimized")
    def io_optimized(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether it is an I/O-optimized instance or not. Optional values:
        - none
        - optimized
        """
        return pulumi.get(self, "io_optimized")

    @io_optimized.setter
    def io_optimized(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "io_optimized", value)

    @_builtins.property
    @pulumi.getter(name="keyPairName")
    def key_pair_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the key pair.
        - Ignore this parameter for Windows instances. It is null by default. Even if you enter this parameter, only the  Password content is used.
        - The password logon method for Linux instances is set to forbidden upon initialization.
        """
        return pulumi.get(self, "key_pair_name")

    @key_pair_name.setter
    def key_pair_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_pair_name", value)

    @_builtins.property
    @pulumi.getter(name="latestVersionNumber")
    def latest_version_number(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "latest_version_number")

    @latest_version_number.setter
    def latest_version_number(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "latest_version_number", value)

    @_builtins.property
    @pulumi.getter(name="launchTemplateName")
    def launch_template_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "launch_template_name")

    @launch_template_name.setter
    def launch_template_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "launch_template_name", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'name' has been deprecated from provider version 1.120.0. New field 'launch_template_name' instead.""")
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Instance launch template name. Can contain [2, 128] characters in length. It must start with an English letter or Chinese, can contain numbers, periods (.), colons (:), underscores (_), and hyphens (-). It cannot start with "http://" or "https://".
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> Optional[pulumi.Input['LaunchTemplateNetworkInterfacesArgs']]:
        """
        The list of network interfaces created with instance.
        """
        return pulumi.get(self, "network_interfaces")

    @network_interfaces.setter
    def network_interfaces(self, value: Optional[pulumi.Input['LaunchTemplateNetworkInterfacesArgs']]):
        pulumi.set(self, "network_interfaces", value)

    @_builtins.property
    @pulumi.getter(name="networkType")
    def network_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Network type of the instance. Value options: `classic` | `vpc`.
        """
        return pulumi.get(self, "network_type")

    @network_type.setter
    def network_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_type", value)

    @_builtins.property
    @pulumi.getter(name="passwordInherit")
    def password_inherit(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "password_inherit")

    @password_inherit.setter
    def password_inherit(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "password_inherit", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "period_unit", value)

    @_builtins.property
    @pulumi.getter(name="privateIpAddress")
    def private_ip_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "private_ip_address")

    @private_ip_address.setter
    def private_ip_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_ip_address", value)

    @_builtins.property
    @pulumi.getter(name="ramRoleName")
    def ram_role_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The RAM role name of the instance. You can use the RAM API ListRoles to query instance RAM role names.
        """
        return pulumi.get(self, "ram_role_name")

    @ram_role_name.setter
    def ram_role_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ram_role_name", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="securityEnhancementStrategy")
    def security_enhancement_strategy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether or not to activate the security enhancement feature and install network security software free of charge. Optional values: Active | Deactive.
        """
        return pulumi.get(self, "security_enhancement_strategy")

    @security_enhancement_strategy.setter
    def security_enhancement_strategy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_enhancement_strategy", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The security group ID.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_group_id", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @_builtins.property
    @pulumi.getter(name="spotDuration")
    def spot_duration(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "spot_duration")

    @spot_duration.setter
    def spot_duration(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "spot_duration", value)

    @_builtins.property
    @pulumi.getter(name="spotPriceLimit")
    def spot_price_limit(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        Sets the maximum hourly instance price. Supports up to three decimal places.
        """
        return pulumi.get(self, "spot_price_limit")

    @spot_price_limit.setter
    def spot_price_limit(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "spot_price_limit", value)

    @_builtins.property
    @pulumi.getter(name="spotStrategy")
    def spot_strategy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The spot strategy for a Pay-As-You-Go instance. This parameter is valid and required only when InstanceChargeType is set to PostPaid. Value range:
        - NoSpot: Normal Pay-As-You-Go instance.
        - SpotWithPriceLimit: Sets the maximum price for a spot instance.
        - SpotAsPriceGo: The system automatically calculates the price. The maximum value is the Pay-As-You-Go price.
        """
        return pulumi.get(self, "spot_strategy")

    @spot_strategy.setter
    def spot_strategy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "spot_strategy", value)

    @_builtins.property
    @pulumi.getter(name="systemDisk")
    def system_disk(self) -> Optional[pulumi.Input['LaunchTemplateSystemDiskArgs']]:
        return pulumi.get(self, "system_disk")

    @system_disk.setter
    def system_disk(self, value: Optional[pulumi.Input['LaunchTemplateSystemDiskArgs']]):
        pulumi.set(self, "system_disk", value)

    @_builtins.property
    @pulumi.getter(name="systemDiskCategory")
    @_utilities.deprecated("""Field 'system_disk_category' has been deprecated from provider version 1.120.0. New field 'system_disk' instead.""")
    def system_disk_category(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The category of the system disk. System disk type. Optional values:
        - cloud: Basic cloud disk.
        - cloud_efficiency: Ultra cloud disk.
        - cloud_ssd: SSD cloud Disks.
        - ephemeral_ssd: local SSD Disks
        - cloud_essd: ESSD cloud Disks.
        """
        return pulumi.get(self, "system_disk_category")

    @system_disk_category.setter
    def system_disk_category(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "system_disk_category", value)

    @_builtins.property
    @pulumi.getter(name="systemDiskDescription")
    @_utilities.deprecated("""Field 'system_disk_description' has been deprecated from provider version 1.120.0. New field 'system_disk' instead.""")
    def system_disk_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        System disk description. It cannot begin with http:// or https://.
        """
        return pulumi.get(self, "system_disk_description")

    @system_disk_description.setter
    def system_disk_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "system_disk_description", value)

    @_builtins.property
    @pulumi.getter(name="systemDiskName")
    @_utilities.deprecated("""Field 'system_disk_name' has been deprecated from provider version 1.120.0. New field 'system_disk' instead.""")
    def system_disk_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        System disk name. The name is a string of 2 to 128 characters. It must begin with an English or a Chinese character. It can contain A-Z, a-z, Chinese characters, numbers, periods (.), colons (:), underscores (_), and hyphens (-).
        """
        return pulumi.get(self, "system_disk_name")

    @system_disk_name.setter
    def system_disk_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "system_disk_name", value)

    @_builtins.property
    @pulumi.getter(name="systemDiskSize")
    @_utilities.deprecated("""Field 'system_disk_size' has been deprecated from provider version 1.120.0. New field 'system_disk' instead.""")
    def system_disk_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Size of the system disk, measured in GB. Value range: [20, 500].
        """
        return pulumi.get(self, "system_disk_size")

    @system_disk_size.setter
    def system_disk_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "system_disk_size", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
        - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="templateResourceGroupId")
    def template_resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "template_resource_group_id")

    @template_resource_group_id.setter
    def template_resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "template_resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="templateTags")
    def template_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "template_tags")

    @template_tags.setter
    def template_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "template_tags", value)

    @_builtins.property
    @pulumi.getter(name="updateDefaultVersionNumber")
    def update_default_version_number(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "update_default_version_number")

    @update_default_version_number.setter
    def update_default_version_number(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "update_default_version_number", value)

    @_builtins.property
    @pulumi.getter(name="userData")
    def user_data(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "user_data")

    @user_data.setter
    def user_data(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_data", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'userdata' has been deprecated from provider version 1.120.0. New field 'user_data' instead.""")
    def userdata(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User data of the instance, which is Base64-encoded. Size of the raw data cannot exceed 16 KB.
        """
        return pulumi.get(self, "userdata")

    @userdata.setter
    def userdata(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "userdata", value)

    @_builtins.property
    @pulumi.getter(name="versionDescription")
    def version_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "version_description")

    @version_description.setter
    def version_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version_description", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        When creating a VPC-Connected instance, you must specify its VSwitch ID.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vswitch_id", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The zone ID of the instance.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone_id", value)


@pulumi.type_token("alicloud:ecs/launchTemplate:LaunchTemplate")
class LaunchTemplate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_release_time: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_renew_period: Optional[pulumi.Input[_builtins.int]] = None,
                 data_disks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LaunchTemplateDataDiskArgs', 'LaunchTemplateDataDiskArgsDict']]]]] = None,
                 default_version_number: Optional[pulumi.Input[_builtins.int]] = None,
                 deployment_set_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_vm_os_config: Optional[pulumi.Input[_builtins.bool]] = None,
                 host_name: Optional[pulumi.Input[_builtins.str]] = None,
                 http_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 http_put_response_hop_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 http_tokens: Optional[pulumi.Input[_builtins.str]] = None,
                 image_id: Optional[pulumi.Input[_builtins.str]] = None,
                 image_options: Optional[pulumi.Input[Union['LaunchTemplateImageOptionsArgs', 'LaunchTemplateImageOptionsArgsDict']]] = None,
                 image_owner_alias: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 internet_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 internet_max_bandwidth_in: Optional[pulumi.Input[_builtins.int]] = None,
                 internet_max_bandwidth_out: Optional[pulumi.Input[_builtins.int]] = None,
                 io_optimized: Optional[pulumi.Input[_builtins.str]] = None,
                 key_pair_name: Optional[pulumi.Input[_builtins.str]] = None,
                 launch_template_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_interfaces: Optional[pulumi.Input[Union['LaunchTemplateNetworkInterfacesArgs', 'LaunchTemplateNetworkInterfacesArgsDict']]] = None,
                 network_type: Optional[pulumi.Input[_builtins.str]] = None,
                 password_inherit: Optional[pulumi.Input[_builtins.bool]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 private_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 ram_role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_enhancement_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 spot_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 spot_price_limit: Optional[pulumi.Input[_builtins.float]] = None,
                 spot_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk: Optional[pulumi.Input[Union['LaunchTemplateSystemDiskArgs', 'LaunchTemplateSystemDiskArgsDict']]] = None,
                 system_disk_category: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk_description: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk_name: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk_size: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 template_resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 template_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 update_default_version_number: Optional[pulumi.Input[_builtins.bool]] = None,
                 user_data: Optional[pulumi.Input[_builtins.str]] = None,
                 userdata: Optional[pulumi.Input[_builtins.str]] = None,
                 version_description: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides an ECS Launch Template resource.

        For information about Launch Template and how to use it, see [Launch Template](https://www.alibabacloud.com/help/doc-detail/73916.html).

        > **DEPRECATED:**  This resource  has been deprecated from version `1.120.0`. Please use new resource alicloud_ecs_launch_template.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        images = alicloud.ecs.get_images(owners="system")
        instances = alicloud.ecs.get_instances()
        template = alicloud.ecs.LaunchTemplate("template",
            name="tf-test-template",
            description="test1",
            image_id=images.images[0].id,
            host_name="tf-test-host",
            instance_charge_type="PrePaid",
            instance_name="tf-instance-name",
            instance_type=instances.instances[0].instance_type,
            internet_charge_type="PayByBandwidth",
            internet_max_bandwidth_in=5,
            internet_max_bandwidth_out=0,
            io_optimized="none",
            key_pair_name="test-key-pair",
            ram_role_name="xxxxx",
            network_type="vpc",
            security_enhancement_strategy="Active",
            spot_price_limit=5,
            spot_strategy="SpotWithPriceLimit",
            security_group_id="sg-zxcvj0lasdf102350asdf9a",
            system_disk_category="cloud_ssd",
            system_disk_description="test disk",
            system_disk_name="hello",
            system_disk_size=40,
            resource_group_id="rg-zkdfjahg9zxncv0",
            userdata="xxxxxxxxxxxxxx",
            vswitch_id="sw-ljkngaksdjfj0nnasdf",
            vpc_id="vpc-asdfnbg0as8dfk1nb2",
            zone_id="beijing-a",
            tags={
                "tag1": "hello",
                "tag2": "world",
            },
            network_interfaces={
                "name": "eth0",
                "description": "hello1",
                "primary_ip": "10.0.0.2",
                "security_group_id": "xxxx",
                "vswitch_id": "xxxxxxx",
            },
            data_disks=[
                {
                    "name": "disk1",
                    "description": "test1",
                },
                {
                    "name": "disk2",
                    "description": "test2",
                },
            ])
        ```

        ## Import

        Launch Template can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ecs/launchTemplate:LaunchTemplate lt lt-abc1234567890000
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] auto_release_time: Instance auto release time. The time is presented using the ISO8601 standard and in UTC time. The format is  YYYY-MM-DDTHH:MM:SSZ.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LaunchTemplateDataDiskArgs', 'LaunchTemplateDataDiskArgsDict']]]] data_disks: The list of data disks created with instance.
        :param pulumi.Input[_builtins.str] description: Description of instance launch template version 1. It can be [2, 256] characters in length. It cannot start with "http://" or "https://". The default value is null.
        :param pulumi.Input[_builtins.str] host_name: Instance host name.It cannot start or end with a period (.) or a hyphen (-) and it cannot have two or more consecutive periods (.) or hyphens (-).For Windows: The host name can be [2, 15] characters in length. It can contain A-Z, a-z, numbers, periods (.), and hyphens (-). It cannot only contain numbers. For other operating systems: The host name can be [2, 64] characters in length. It can be segments separated by periods (.). It can contain A-Z, a-z, numbers, and hyphens (-).
        :param pulumi.Input[_builtins.str] image_id: Image ID.
        :param pulumi.Input[_builtins.str] instance_charge_type: Billing methods. Optional values:
               - PrePaid: Monthly, or annual subscription. Make sure that your registered credit card is invalid or you have insufficient balance in your PayPal account. Otherwise, InvalidPayMethod error may occur.
               - PostPaid: Pay-As-You-Go.
               
               Default value: PostPaid.
        :param pulumi.Input[_builtins.str] instance_name: The name of the instance. The name is a string of 2 to 128 characters. It must begin with an English or a Chinese character. It can contain A-Z, a-z, Chinese characters, numbers, periods (.), colons (:), underscores (_), and hyphens (-).
        :param pulumi.Input[_builtins.str] instance_type: Instance type. For more information, call resource_alicloud_instances to obtain the latest instance type list.
        :param pulumi.Input[_builtins.str] internet_charge_type: Internet bandwidth billing method. Optional values: `PayByTraffic` | `PayByBandwidth`.
        :param pulumi.Input[_builtins.int] internet_max_bandwidth_in: The maximum inbound bandwidth from the Internet network, measured in Mbit/s. Value range: [1, 200].
        :param pulumi.Input[_builtins.int] internet_max_bandwidth_out: Maximum outbound bandwidth from the Internet, its unit of measurement is Mbit/s. Value range: [0, 100].
        :param pulumi.Input[_builtins.str] io_optimized: Whether it is an I/O-optimized instance or not. Optional values:
               - none
               - optimized
        :param pulumi.Input[_builtins.str] key_pair_name: The name of the key pair.
               - Ignore this parameter for Windows instances. It is null by default. Even if you enter this parameter, only the  Password content is used.
               - The password logon method for Linux instances is set to forbidden upon initialization.
        :param pulumi.Input[_builtins.str] name: Instance launch template name. Can contain [2, 128] characters in length. It must start with an English letter or Chinese, can contain numbers, periods (.), colons (:), underscores (_), and hyphens (-). It cannot start with "http://" or "https://".
        :param pulumi.Input[Union['LaunchTemplateNetworkInterfacesArgs', 'LaunchTemplateNetworkInterfacesArgsDict']] network_interfaces: The list of network interfaces created with instance.
        :param pulumi.Input[_builtins.str] network_type: Network type of the instance. Value options: `classic` | `vpc`.
        :param pulumi.Input[_builtins.str] ram_role_name: The RAM role name of the instance. You can use the RAM API ListRoles to query instance RAM role names.
        :param pulumi.Input[_builtins.str] security_enhancement_strategy: Whether or not to activate the security enhancement feature and install network security software free of charge. Optional values: Active | Deactive.
        :param pulumi.Input[_builtins.str] security_group_id: The security group ID.
        :param pulumi.Input[_builtins.float] spot_price_limit: Sets the maximum hourly instance price. Supports up to three decimal places.
        :param pulumi.Input[_builtins.str] spot_strategy: The spot strategy for a Pay-As-You-Go instance. This parameter is valid and required only when InstanceChargeType is set to PostPaid. Value range:
               - NoSpot: Normal Pay-As-You-Go instance.
               - SpotWithPriceLimit: Sets the maximum price for a spot instance.
               - SpotAsPriceGo: The system automatically calculates the price. The maximum value is the Pay-As-You-Go price.
        :param pulumi.Input[_builtins.str] system_disk_category: The category of the system disk. System disk type. Optional values:
               - cloud: Basic cloud disk.
               - cloud_efficiency: Ultra cloud disk.
               - cloud_ssd: SSD cloud Disks.
               - ephemeral_ssd: local SSD Disks
               - cloud_essd: ESSD cloud Disks.
        :param pulumi.Input[_builtins.str] system_disk_description: System disk description. It cannot begin with http:// or https://.
        :param pulumi.Input[_builtins.str] system_disk_name: System disk name. The name is a string of 2 to 128 characters. It must begin with an English or a Chinese character. It can contain A-Z, a-z, Chinese characters, numbers, periods (.), colons (:), underscores (_), and hyphens (-).
        :param pulumi.Input[_builtins.int] system_disk_size: Size of the system disk, measured in GB. Value range: [20, 500].
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
               - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
               - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
        :param pulumi.Input[_builtins.str] userdata: User data of the instance, which is Base64-encoded. Size of the raw data cannot exceed 16 KB.
        :param pulumi.Input[_builtins.str] vswitch_id: When creating a VPC-Connected instance, you must specify its VSwitch ID.
        :param pulumi.Input[_builtins.str] zone_id: The zone ID of the instance.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[LaunchTemplateArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an ECS Launch Template resource.

        For information about Launch Template and how to use it, see [Launch Template](https://www.alibabacloud.com/help/doc-detail/73916.html).

        > **DEPRECATED:**  This resource  has been deprecated from version `1.120.0`. Please use new resource alicloud_ecs_launch_template.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        images = alicloud.ecs.get_images(owners="system")
        instances = alicloud.ecs.get_instances()
        template = alicloud.ecs.LaunchTemplate("template",
            name="tf-test-template",
            description="test1",
            image_id=images.images[0].id,
            host_name="tf-test-host",
            instance_charge_type="PrePaid",
            instance_name="tf-instance-name",
            instance_type=instances.instances[0].instance_type,
            internet_charge_type="PayByBandwidth",
            internet_max_bandwidth_in=5,
            internet_max_bandwidth_out=0,
            io_optimized="none",
            key_pair_name="test-key-pair",
            ram_role_name="xxxxx",
            network_type="vpc",
            security_enhancement_strategy="Active",
            spot_price_limit=5,
            spot_strategy="SpotWithPriceLimit",
            security_group_id="sg-zxcvj0lasdf102350asdf9a",
            system_disk_category="cloud_ssd",
            system_disk_description="test disk",
            system_disk_name="hello",
            system_disk_size=40,
            resource_group_id="rg-zkdfjahg9zxncv0",
            userdata="xxxxxxxxxxxxxx",
            vswitch_id="sw-ljkngaksdjfj0nnasdf",
            vpc_id="vpc-asdfnbg0as8dfk1nb2",
            zone_id="beijing-a",
            tags={
                "tag1": "hello",
                "tag2": "world",
            },
            network_interfaces={
                "name": "eth0",
                "description": "hello1",
                "primary_ip": "10.0.0.2",
                "security_group_id": "xxxx",
                "vswitch_id": "xxxxxxx",
            },
            data_disks=[
                {
                    "name": "disk1",
                    "description": "test1",
                },
                {
                    "name": "disk2",
                    "description": "test2",
                },
            ])
        ```

        ## Import

        Launch Template can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ecs/launchTemplate:LaunchTemplate lt lt-abc1234567890000
        ```

        :param str resource_name: The name of the resource.
        :param LaunchTemplateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LaunchTemplateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_release_time: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_renew_period: Optional[pulumi.Input[_builtins.int]] = None,
                 data_disks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LaunchTemplateDataDiskArgs', 'LaunchTemplateDataDiskArgsDict']]]]] = None,
                 default_version_number: Optional[pulumi.Input[_builtins.int]] = None,
                 deployment_set_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_vm_os_config: Optional[pulumi.Input[_builtins.bool]] = None,
                 host_name: Optional[pulumi.Input[_builtins.str]] = None,
                 http_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 http_put_response_hop_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 http_tokens: Optional[pulumi.Input[_builtins.str]] = None,
                 image_id: Optional[pulumi.Input[_builtins.str]] = None,
                 image_options: Optional[pulumi.Input[Union['LaunchTemplateImageOptionsArgs', 'LaunchTemplateImageOptionsArgsDict']]] = None,
                 image_owner_alias: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 internet_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 internet_max_bandwidth_in: Optional[pulumi.Input[_builtins.int]] = None,
                 internet_max_bandwidth_out: Optional[pulumi.Input[_builtins.int]] = None,
                 io_optimized: Optional[pulumi.Input[_builtins.str]] = None,
                 key_pair_name: Optional[pulumi.Input[_builtins.str]] = None,
                 launch_template_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_interfaces: Optional[pulumi.Input[Union['LaunchTemplateNetworkInterfacesArgs', 'LaunchTemplateNetworkInterfacesArgsDict']]] = None,
                 network_type: Optional[pulumi.Input[_builtins.str]] = None,
                 password_inherit: Optional[pulumi.Input[_builtins.bool]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 private_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 ram_role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_enhancement_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 spot_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 spot_price_limit: Optional[pulumi.Input[_builtins.float]] = None,
                 spot_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk: Optional[pulumi.Input[Union['LaunchTemplateSystemDiskArgs', 'LaunchTemplateSystemDiskArgsDict']]] = None,
                 system_disk_category: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk_description: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk_name: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk_size: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 template_resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 template_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 update_default_version_number: Optional[pulumi.Input[_builtins.bool]] = None,
                 user_data: Optional[pulumi.Input[_builtins.str]] = None,
                 userdata: Optional[pulumi.Input[_builtins.str]] = None,
                 version_description: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LaunchTemplateArgs.__new__(LaunchTemplateArgs)

            __props__.__dict__["auto_release_time"] = auto_release_time
            __props__.__dict__["auto_renew"] = auto_renew
            __props__.__dict__["auto_renew_period"] = auto_renew_period
            __props__.__dict__["data_disks"] = data_disks
            __props__.__dict__["default_version_number"] = default_version_number
            __props__.__dict__["deployment_set_id"] = deployment_set_id
            __props__.__dict__["description"] = description
            __props__.__dict__["enable_vm_os_config"] = enable_vm_os_config
            __props__.__dict__["host_name"] = host_name
            __props__.__dict__["http_endpoint"] = http_endpoint
            __props__.__dict__["http_put_response_hop_limit"] = http_put_response_hop_limit
            __props__.__dict__["http_tokens"] = http_tokens
            __props__.__dict__["image_id"] = image_id
            __props__.__dict__["image_options"] = image_options
            __props__.__dict__["image_owner_alias"] = image_owner_alias
            __props__.__dict__["instance_charge_type"] = instance_charge_type
            __props__.__dict__["instance_name"] = instance_name
            __props__.__dict__["instance_type"] = instance_type
            __props__.__dict__["internet_charge_type"] = internet_charge_type
            __props__.__dict__["internet_max_bandwidth_in"] = internet_max_bandwidth_in
            __props__.__dict__["internet_max_bandwidth_out"] = internet_max_bandwidth_out
            __props__.__dict__["io_optimized"] = io_optimized
            __props__.__dict__["key_pair_name"] = key_pair_name
            __props__.__dict__["launch_template_name"] = launch_template_name
            __props__.__dict__["name"] = name
            __props__.__dict__["network_interfaces"] = network_interfaces
            __props__.__dict__["network_type"] = network_type
            __props__.__dict__["password_inherit"] = password_inherit
            __props__.__dict__["period"] = period
            __props__.__dict__["period_unit"] = period_unit
            __props__.__dict__["private_ip_address"] = private_ip_address
            __props__.__dict__["ram_role_name"] = ram_role_name
            __props__.__dict__["resource_group_id"] = resource_group_id
            __props__.__dict__["security_enhancement_strategy"] = security_enhancement_strategy
            __props__.__dict__["security_group_id"] = security_group_id
            __props__.__dict__["security_group_ids"] = security_group_ids
            __props__.__dict__["spot_duration"] = spot_duration
            __props__.__dict__["spot_price_limit"] = spot_price_limit
            __props__.__dict__["spot_strategy"] = spot_strategy
            __props__.__dict__["system_disk"] = system_disk
            __props__.__dict__["system_disk_category"] = system_disk_category
            __props__.__dict__["system_disk_description"] = system_disk_description
            __props__.__dict__["system_disk_name"] = system_disk_name
            __props__.__dict__["system_disk_size"] = system_disk_size
            __props__.__dict__["tags"] = tags
            __props__.__dict__["template_resource_group_id"] = template_resource_group_id
            __props__.__dict__["template_tags"] = template_tags
            __props__.__dict__["update_default_version_number"] = update_default_version_number
            __props__.__dict__["user_data"] = user_data
            __props__.__dict__["userdata"] = userdata
            __props__.__dict__["version_description"] = version_description
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["vswitch_id"] = vswitch_id
            __props__.__dict__["zone_id"] = zone_id
            __props__.__dict__["latest_version_number"] = None
        super(LaunchTemplate, __self__).__init__(
            'alicloud:ecs/launchTemplate:LaunchTemplate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_release_time: Optional[pulumi.Input[_builtins.str]] = None,
            auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
            auto_renew_period: Optional[pulumi.Input[_builtins.int]] = None,
            data_disks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LaunchTemplateDataDiskArgs', 'LaunchTemplateDataDiskArgsDict']]]]] = None,
            default_version_number: Optional[pulumi.Input[_builtins.int]] = None,
            deployment_set_id: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            enable_vm_os_config: Optional[pulumi.Input[_builtins.bool]] = None,
            host_name: Optional[pulumi.Input[_builtins.str]] = None,
            http_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
            http_put_response_hop_limit: Optional[pulumi.Input[_builtins.int]] = None,
            http_tokens: Optional[pulumi.Input[_builtins.str]] = None,
            image_id: Optional[pulumi.Input[_builtins.str]] = None,
            image_options: Optional[pulumi.Input[Union['LaunchTemplateImageOptionsArgs', 'LaunchTemplateImageOptionsArgsDict']]] = None,
            image_owner_alias: Optional[pulumi.Input[_builtins.str]] = None,
            instance_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
            instance_name: Optional[pulumi.Input[_builtins.str]] = None,
            instance_type: Optional[pulumi.Input[_builtins.str]] = None,
            internet_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
            internet_max_bandwidth_in: Optional[pulumi.Input[_builtins.int]] = None,
            internet_max_bandwidth_out: Optional[pulumi.Input[_builtins.int]] = None,
            io_optimized: Optional[pulumi.Input[_builtins.str]] = None,
            key_pair_name: Optional[pulumi.Input[_builtins.str]] = None,
            latest_version_number: Optional[pulumi.Input[_builtins.int]] = None,
            launch_template_name: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            network_interfaces: Optional[pulumi.Input[Union['LaunchTemplateNetworkInterfacesArgs', 'LaunchTemplateNetworkInterfacesArgsDict']]] = None,
            network_type: Optional[pulumi.Input[_builtins.str]] = None,
            password_inherit: Optional[pulumi.Input[_builtins.bool]] = None,
            period: Optional[pulumi.Input[_builtins.int]] = None,
            period_unit: Optional[pulumi.Input[_builtins.str]] = None,
            private_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
            ram_role_name: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            security_enhancement_strategy: Optional[pulumi.Input[_builtins.str]] = None,
            security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            spot_duration: Optional[pulumi.Input[_builtins.str]] = None,
            spot_price_limit: Optional[pulumi.Input[_builtins.float]] = None,
            spot_strategy: Optional[pulumi.Input[_builtins.str]] = None,
            system_disk: Optional[pulumi.Input[Union['LaunchTemplateSystemDiskArgs', 'LaunchTemplateSystemDiskArgsDict']]] = None,
            system_disk_category: Optional[pulumi.Input[_builtins.str]] = None,
            system_disk_description: Optional[pulumi.Input[_builtins.str]] = None,
            system_disk_name: Optional[pulumi.Input[_builtins.str]] = None,
            system_disk_size: Optional[pulumi.Input[_builtins.int]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            template_resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            template_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            update_default_version_number: Optional[pulumi.Input[_builtins.bool]] = None,
            user_data: Optional[pulumi.Input[_builtins.str]] = None,
            userdata: Optional[pulumi.Input[_builtins.str]] = None,
            version_description: Optional[pulumi.Input[_builtins.str]] = None,
            vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
            vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
            zone_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'LaunchTemplate':
        """
        Get an existing LaunchTemplate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] auto_release_time: Instance auto release time. The time is presented using the ISO8601 standard and in UTC time. The format is  YYYY-MM-DDTHH:MM:SSZ.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LaunchTemplateDataDiskArgs', 'LaunchTemplateDataDiskArgsDict']]]] data_disks: The list of data disks created with instance.
        :param pulumi.Input[_builtins.str] description: Description of instance launch template version 1. It can be [2, 256] characters in length. It cannot start with "http://" or "https://". The default value is null.
        :param pulumi.Input[_builtins.str] host_name: Instance host name.It cannot start or end with a period (.) or a hyphen (-) and it cannot have two or more consecutive periods (.) or hyphens (-).For Windows: The host name can be [2, 15] characters in length. It can contain A-Z, a-z, numbers, periods (.), and hyphens (-). It cannot only contain numbers. For other operating systems: The host name can be [2, 64] characters in length. It can be segments separated by periods (.). It can contain A-Z, a-z, numbers, and hyphens (-).
        :param pulumi.Input[_builtins.str] image_id: Image ID.
        :param pulumi.Input[_builtins.str] instance_charge_type: Billing methods. Optional values:
               - PrePaid: Monthly, or annual subscription. Make sure that your registered credit card is invalid or you have insufficient balance in your PayPal account. Otherwise, InvalidPayMethod error may occur.
               - PostPaid: Pay-As-You-Go.
               
               Default value: PostPaid.
        :param pulumi.Input[_builtins.str] instance_name: The name of the instance. The name is a string of 2 to 128 characters. It must begin with an English or a Chinese character. It can contain A-Z, a-z, Chinese characters, numbers, periods (.), colons (:), underscores (_), and hyphens (-).
        :param pulumi.Input[_builtins.str] instance_type: Instance type. For more information, call resource_alicloud_instances to obtain the latest instance type list.
        :param pulumi.Input[_builtins.str] internet_charge_type: Internet bandwidth billing method. Optional values: `PayByTraffic` | `PayByBandwidth`.
        :param pulumi.Input[_builtins.int] internet_max_bandwidth_in: The maximum inbound bandwidth from the Internet network, measured in Mbit/s. Value range: [1, 200].
        :param pulumi.Input[_builtins.int] internet_max_bandwidth_out: Maximum outbound bandwidth from the Internet, its unit of measurement is Mbit/s. Value range: [0, 100].
        :param pulumi.Input[_builtins.str] io_optimized: Whether it is an I/O-optimized instance or not. Optional values:
               - none
               - optimized
        :param pulumi.Input[_builtins.str] key_pair_name: The name of the key pair.
               - Ignore this parameter for Windows instances. It is null by default. Even if you enter this parameter, only the  Password content is used.
               - The password logon method for Linux instances is set to forbidden upon initialization.
        :param pulumi.Input[_builtins.str] name: Instance launch template name. Can contain [2, 128] characters in length. It must start with an English letter or Chinese, can contain numbers, periods (.), colons (:), underscores (_), and hyphens (-). It cannot start with "http://" or "https://".
        :param pulumi.Input[Union['LaunchTemplateNetworkInterfacesArgs', 'LaunchTemplateNetworkInterfacesArgsDict']] network_interfaces: The list of network interfaces created with instance.
        :param pulumi.Input[_builtins.str] network_type: Network type of the instance. Value options: `classic` | `vpc`.
        :param pulumi.Input[_builtins.str] ram_role_name: The RAM role name of the instance. You can use the RAM API ListRoles to query instance RAM role names.
        :param pulumi.Input[_builtins.str] security_enhancement_strategy: Whether or not to activate the security enhancement feature and install network security software free of charge. Optional values: Active | Deactive.
        :param pulumi.Input[_builtins.str] security_group_id: The security group ID.
        :param pulumi.Input[_builtins.float] spot_price_limit: Sets the maximum hourly instance price. Supports up to three decimal places.
        :param pulumi.Input[_builtins.str] spot_strategy: The spot strategy for a Pay-As-You-Go instance. This parameter is valid and required only when InstanceChargeType is set to PostPaid. Value range:
               - NoSpot: Normal Pay-As-You-Go instance.
               - SpotWithPriceLimit: Sets the maximum price for a spot instance.
               - SpotAsPriceGo: The system automatically calculates the price. The maximum value is the Pay-As-You-Go price.
        :param pulumi.Input[_builtins.str] system_disk_category: The category of the system disk. System disk type. Optional values:
               - cloud: Basic cloud disk.
               - cloud_efficiency: Ultra cloud disk.
               - cloud_ssd: SSD cloud Disks.
               - ephemeral_ssd: local SSD Disks
               - cloud_essd: ESSD cloud Disks.
        :param pulumi.Input[_builtins.str] system_disk_description: System disk description. It cannot begin with http:// or https://.
        :param pulumi.Input[_builtins.str] system_disk_name: System disk name. The name is a string of 2 to 128 characters. It must begin with an English or a Chinese character. It can contain A-Z, a-z, Chinese characters, numbers, periods (.), colons (:), underscores (_), and hyphens (-).
        :param pulumi.Input[_builtins.int] system_disk_size: Size of the system disk, measured in GB. Value range: [20, 500].
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
               - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
               - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
        :param pulumi.Input[_builtins.str] userdata: User data of the instance, which is Base64-encoded. Size of the raw data cannot exceed 16 KB.
        :param pulumi.Input[_builtins.str] vswitch_id: When creating a VPC-Connected instance, you must specify its VSwitch ID.
        :param pulumi.Input[_builtins.str] zone_id: The zone ID of the instance.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LaunchTemplateState.__new__(_LaunchTemplateState)

        __props__.__dict__["auto_release_time"] = auto_release_time
        __props__.__dict__["auto_renew"] = auto_renew
        __props__.__dict__["auto_renew_period"] = auto_renew_period
        __props__.__dict__["data_disks"] = data_disks
        __props__.__dict__["default_version_number"] = default_version_number
        __props__.__dict__["deployment_set_id"] = deployment_set_id
        __props__.__dict__["description"] = description
        __props__.__dict__["enable_vm_os_config"] = enable_vm_os_config
        __props__.__dict__["host_name"] = host_name
        __props__.__dict__["http_endpoint"] = http_endpoint
        __props__.__dict__["http_put_response_hop_limit"] = http_put_response_hop_limit
        __props__.__dict__["http_tokens"] = http_tokens
        __props__.__dict__["image_id"] = image_id
        __props__.__dict__["image_options"] = image_options
        __props__.__dict__["image_owner_alias"] = image_owner_alias
        __props__.__dict__["instance_charge_type"] = instance_charge_type
        __props__.__dict__["instance_name"] = instance_name
        __props__.__dict__["instance_type"] = instance_type
        __props__.__dict__["internet_charge_type"] = internet_charge_type
        __props__.__dict__["internet_max_bandwidth_in"] = internet_max_bandwidth_in
        __props__.__dict__["internet_max_bandwidth_out"] = internet_max_bandwidth_out
        __props__.__dict__["io_optimized"] = io_optimized
        __props__.__dict__["key_pair_name"] = key_pair_name
        __props__.__dict__["latest_version_number"] = latest_version_number
        __props__.__dict__["launch_template_name"] = launch_template_name
        __props__.__dict__["name"] = name
        __props__.__dict__["network_interfaces"] = network_interfaces
        __props__.__dict__["network_type"] = network_type
        __props__.__dict__["password_inherit"] = password_inherit
        __props__.__dict__["period"] = period
        __props__.__dict__["period_unit"] = period_unit
        __props__.__dict__["private_ip_address"] = private_ip_address
        __props__.__dict__["ram_role_name"] = ram_role_name
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["security_enhancement_strategy"] = security_enhancement_strategy
        __props__.__dict__["security_group_id"] = security_group_id
        __props__.__dict__["security_group_ids"] = security_group_ids
        __props__.__dict__["spot_duration"] = spot_duration
        __props__.__dict__["spot_price_limit"] = spot_price_limit
        __props__.__dict__["spot_strategy"] = spot_strategy
        __props__.__dict__["system_disk"] = system_disk
        __props__.__dict__["system_disk_category"] = system_disk_category
        __props__.__dict__["system_disk_description"] = system_disk_description
        __props__.__dict__["system_disk_name"] = system_disk_name
        __props__.__dict__["system_disk_size"] = system_disk_size
        __props__.__dict__["tags"] = tags
        __props__.__dict__["template_resource_group_id"] = template_resource_group_id
        __props__.__dict__["template_tags"] = template_tags
        __props__.__dict__["update_default_version_number"] = update_default_version_number
        __props__.__dict__["user_data"] = user_data
        __props__.__dict__["userdata"] = userdata
        __props__.__dict__["version_description"] = version_description
        __props__.__dict__["vpc_id"] = vpc_id
        __props__.__dict__["vswitch_id"] = vswitch_id
        __props__.__dict__["zone_id"] = zone_id
        return LaunchTemplate(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="autoReleaseTime")
    def auto_release_time(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Instance auto release time. The time is presented using the ISO8601 standard and in UTC time. The format is  YYYY-MM-DDTHH:MM:SSZ.
        """
        return pulumi.get(self, "auto_release_time")

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> pulumi.Output[_builtins.bool]:
        return pulumi.get(self, "auto_renew")

    @_builtins.property
    @pulumi.getter(name="autoRenewPeriod")
    def auto_renew_period(self) -> pulumi.Output[_builtins.int]:
        return pulumi.get(self, "auto_renew_period")

    @_builtins.property
    @pulumi.getter(name="dataDisks")
    def data_disks(self) -> pulumi.Output[Optional[Sequence['outputs.LaunchTemplateDataDisk']]]:
        """
        The list of data disks created with instance.
        """
        return pulumi.get(self, "data_disks")

    @_builtins.property
    @pulumi.getter(name="defaultVersionNumber")
    def default_version_number(self) -> pulumi.Output[_builtins.int]:
        return pulumi.get(self, "default_version_number")

    @_builtins.property
    @pulumi.getter(name="deploymentSetId")
    def deployment_set_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "deployment_set_id")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Description of instance launch template version 1. It can be [2, 256] characters in length. It cannot start with "http://" or "https://". The default value is null.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="enableVmOsConfig")
    def enable_vm_os_config(self) -> pulumi.Output[Optional[_builtins.bool]]:
        return pulumi.get(self, "enable_vm_os_config")

    @_builtins.property
    @pulumi.getter(name="hostName")
    def host_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Instance host name.It cannot start or end with a period (.) or a hyphen (-) and it cannot have two or more consecutive periods (.) or hyphens (-).For Windows: The host name can be [2, 15] characters in length. It can contain A-Z, a-z, numbers, periods (.), and hyphens (-). It cannot only contain numbers. For other operating systems: The host name can be [2, 64] characters in length. It can be segments separated by periods (.). It can contain A-Z, a-z, numbers, and hyphens (-).
        """
        return pulumi.get(self, "host_name")

    @_builtins.property
    @pulumi.getter(name="httpEndpoint")
    def http_endpoint(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "http_endpoint")

    @_builtins.property
    @pulumi.getter(name="httpPutResponseHopLimit")
    def http_put_response_hop_limit(self) -> pulumi.Output[_builtins.int]:
        return pulumi.get(self, "http_put_response_hop_limit")

    @_builtins.property
    @pulumi.getter(name="httpTokens")
    def http_tokens(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "http_tokens")

    @_builtins.property
    @pulumi.getter(name="imageId")
    def image_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Image ID.
        """
        return pulumi.get(self, "image_id")

    @_builtins.property
    @pulumi.getter(name="imageOptions")
    def image_options(self) -> pulumi.Output['outputs.LaunchTemplateImageOptions']:
        return pulumi.get(self, "image_options")

    @_builtins.property
    @pulumi.getter(name="imageOwnerAlias")
    def image_owner_alias(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "image_owner_alias")

    @_builtins.property
    @pulumi.getter(name="instanceChargeType")
    def instance_charge_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Billing methods. Optional values:
        - PrePaid: Monthly, or annual subscription. Make sure that your registered credit card is invalid or you have insufficient balance in your PayPal account. Otherwise, InvalidPayMethod error may occur.
        - PostPaid: Pay-As-You-Go.

        Default value: PostPaid.
        """
        return pulumi.get(self, "instance_charge_type")

    @_builtins.property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of the instance. The name is a string of 2 to 128 characters. It must begin with an English or a Chinese character. It can contain A-Z, a-z, Chinese characters, numbers, periods (.), colons (:), underscores (_), and hyphens (-).
        """
        return pulumi.get(self, "instance_name")

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Instance type. For more information, call resource_alicloud_instances to obtain the latest instance type list.
        """
        return pulumi.get(self, "instance_type")

    @_builtins.property
    @pulumi.getter(name="internetChargeType")
    def internet_charge_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Internet bandwidth billing method. Optional values: `PayByTraffic` | `PayByBandwidth`.
        """
        return pulumi.get(self, "internet_charge_type")

    @_builtins.property
    @pulumi.getter(name="internetMaxBandwidthIn")
    def internet_max_bandwidth_in(self) -> pulumi.Output[_builtins.int]:
        """
        The maximum inbound bandwidth from the Internet network, measured in Mbit/s. Value range: [1, 200].
        """
        return pulumi.get(self, "internet_max_bandwidth_in")

    @_builtins.property
    @pulumi.getter(name="internetMaxBandwidthOut")
    def internet_max_bandwidth_out(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Maximum outbound bandwidth from the Internet, its unit of measurement is Mbit/s. Value range: [0, 100].
        """
        return pulumi.get(self, "internet_max_bandwidth_out")

    @_builtins.property
    @pulumi.getter(name="ioOptimized")
    def io_optimized(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Whether it is an I/O-optimized instance or not. Optional values:
        - none
        - optimized
        """
        return pulumi.get(self, "io_optimized")

    @_builtins.property
    @pulumi.getter(name="keyPairName")
    def key_pair_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of the key pair.
        - Ignore this parameter for Windows instances. It is null by default. Even if you enter this parameter, only the  Password content is used.
        - The password logon method for Linux instances is set to forbidden upon initialization.
        """
        return pulumi.get(self, "key_pair_name")

    @_builtins.property
    @pulumi.getter(name="latestVersionNumber")
    def latest_version_number(self) -> pulumi.Output[_builtins.int]:
        return pulumi.get(self, "latest_version_number")

    @_builtins.property
    @pulumi.getter(name="launchTemplateName")
    def launch_template_name(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "launch_template_name")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'name' has been deprecated from provider version 1.120.0. New field 'launch_template_name' instead.""")
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Instance launch template name. Can contain [2, 128] characters in length. It must start with an English letter or Chinese, can contain numbers, periods (.), colons (:), underscores (_), and hyphens (-). It cannot start with "http://" or "https://".
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> pulumi.Output[Optional['outputs.LaunchTemplateNetworkInterfaces']]:
        """
        The list of network interfaces created with instance.
        """
        return pulumi.get(self, "network_interfaces")

    @_builtins.property
    @pulumi.getter(name="networkType")
    def network_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Network type of the instance. Value options: `classic` | `vpc`.
        """
        return pulumi.get(self, "network_type")

    @_builtins.property
    @pulumi.getter(name="passwordInherit")
    def password_inherit(self) -> pulumi.Output[Optional[_builtins.bool]]:
        return pulumi.get(self, "password_inherit")

    @_builtins.property
    @pulumi.getter
    def period(self) -> pulumi.Output[_builtins.int]:
        return pulumi.get(self, "period")

    @_builtins.property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "period_unit")

    @_builtins.property
    @pulumi.getter(name="privateIpAddress")
    def private_ip_address(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "private_ip_address")

    @_builtins.property
    @pulumi.getter(name="ramRoleName")
    def ram_role_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The RAM role name of the instance. You can use the RAM API ListRoles to query instance RAM role names.
        """
        return pulumi.get(self, "ram_role_name")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter(name="securityEnhancementStrategy")
    def security_enhancement_strategy(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Whether or not to activate the security enhancement feature and install network security software free of charge. Optional values: Active | Deactive.
        """
        return pulumi.get(self, "security_enhancement_strategy")

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The security group ID.
        """
        return pulumi.get(self, "security_group_id")

    @_builtins.property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        return pulumi.get(self, "security_group_ids")

    @_builtins.property
    @pulumi.getter(name="spotDuration")
    def spot_duration(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "spot_duration")

    @_builtins.property
    @pulumi.getter(name="spotPriceLimit")
    def spot_price_limit(self) -> pulumi.Output[Optional[_builtins.float]]:
        """
        Sets the maximum hourly instance price. Supports up to three decimal places.
        """
        return pulumi.get(self, "spot_price_limit")

    @_builtins.property
    @pulumi.getter(name="spotStrategy")
    def spot_strategy(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The spot strategy for a Pay-As-You-Go instance. This parameter is valid and required only when InstanceChargeType is set to PostPaid. Value range:
        - NoSpot: Normal Pay-As-You-Go instance.
        - SpotWithPriceLimit: Sets the maximum price for a spot instance.
        - SpotAsPriceGo: The system automatically calculates the price. The maximum value is the Pay-As-You-Go price.
        """
        return pulumi.get(self, "spot_strategy")

    @_builtins.property
    @pulumi.getter(name="systemDisk")
    def system_disk(self) -> pulumi.Output['outputs.LaunchTemplateSystemDisk']:
        return pulumi.get(self, "system_disk")

    @_builtins.property
    @pulumi.getter(name="systemDiskCategory")
    @_utilities.deprecated("""Field 'system_disk_category' has been deprecated from provider version 1.120.0. New field 'system_disk' instead.""")
    def system_disk_category(self) -> pulumi.Output[_builtins.str]:
        """
        The category of the system disk. System disk type. Optional values:
        - cloud: Basic cloud disk.
        - cloud_efficiency: Ultra cloud disk.
        - cloud_ssd: SSD cloud Disks.
        - ephemeral_ssd: local SSD Disks
        - cloud_essd: ESSD cloud Disks.
        """
        return pulumi.get(self, "system_disk_category")

    @_builtins.property
    @pulumi.getter(name="systemDiskDescription")
    @_utilities.deprecated("""Field 'system_disk_description' has been deprecated from provider version 1.120.0. New field 'system_disk' instead.""")
    def system_disk_description(self) -> pulumi.Output[_builtins.str]:
        """
        System disk description. It cannot begin with http:// or https://.
        """
        return pulumi.get(self, "system_disk_description")

    @_builtins.property
    @pulumi.getter(name="systemDiskName")
    @_utilities.deprecated("""Field 'system_disk_name' has been deprecated from provider version 1.120.0. New field 'system_disk' instead.""")
    def system_disk_name(self) -> pulumi.Output[_builtins.str]:
        """
        System disk name. The name is a string of 2 to 128 characters. It must begin with an English or a Chinese character. It can contain A-Z, a-z, Chinese characters, numbers, periods (.), colons (:), underscores (_), and hyphens (-).
        """
        return pulumi.get(self, "system_disk_name")

    @_builtins.property
    @pulumi.getter(name="systemDiskSize")
    @_utilities.deprecated("""Field 'system_disk_size' has been deprecated from provider version 1.120.0. New field 'system_disk' instead.""")
    def system_disk_size(self) -> pulumi.Output[_builtins.int]:
        """
        Size of the system disk, measured in GB. Value range: [20, 500].
        """
        return pulumi.get(self, "system_disk_size")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags to assign to the resource.
        - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
        - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="templateResourceGroupId")
    def template_resource_group_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "template_resource_group_id")

    @_builtins.property
    @pulumi.getter(name="templateTags")
    def template_tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        return pulumi.get(self, "template_tags")

    @_builtins.property
    @pulumi.getter(name="updateDefaultVersionNumber")
    def update_default_version_number(self) -> pulumi.Output[Optional[_builtins.bool]]:
        return pulumi.get(self, "update_default_version_number")

    @_builtins.property
    @pulumi.getter(name="userData")
    def user_data(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "user_data")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'userdata' has been deprecated from provider version 1.120.0. New field 'user_data' instead.""")
    def userdata(self) -> pulumi.Output[_builtins.str]:
        """
        User data of the instance, which is Base64-encoded. Size of the raw data cannot exceed 16 KB.
        """
        return pulumi.get(self, "userdata")

    @_builtins.property
    @pulumi.getter(name="versionDescription")
    def version_description(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "version_description")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        When creating a VPC-Connected instance, you must specify its VSwitch ID.
        """
        return pulumi.get(self, "vswitch_id")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[_builtins.str]:
        """
        The zone ID of the instance.
        """
        return pulumi.get(self, "zone_id")

