# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ReservedInstanceArgs', 'ReservedInstance']

@pulumi.input_type
class ReservedInstanceArgs:
    def __init__(__self__, *,
                 instance_type: pulumi.Input[_builtins.str],
                 auto_renew_period: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_amount: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 offering_type: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 platform: Optional[pulumi.Input[_builtins.str]] = None,
                 renewal_status: Optional[pulumi.Input[_builtins.str]] = None,
                 reserved_instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 scope: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ReservedInstance resource.
        :param pulumi.Input[_builtins.str] instance_type: Instance type of the RI. For more information, see [Instance type families](https://www.alibabacloud.com/help/doc-detail/25378.html).
        :param pulumi.Input[_builtins.int] auto_renew_period: The auto-renewal term of the reserved instance. This parameter takes effect only when AutoRenew is set to true. Valid values: 1, 12, 36, and 60. Default value when `period_unit` is set to Month: 1 Default value when `period_unit` is set to Year: 12
        :param pulumi.Input[_builtins.str] description: Description of the RI. 2 to 256 English or Chinese characters. It cannot start with `http://` or `https://`.
        :param pulumi.Input[_builtins.int] instance_amount: Number of instances allocated to an RI (An RI is a coupon that includes one or more allocated instances.).
        :param pulumi.Input[_builtins.str] name: Field `name` has been deprecated from provider version 1.194.0. New field `reserved_instance_name` instead.
        :param pulumi.Input[_builtins.str] offering_type: Payment type of the RI. Default value: `All Upfront`. Valid values:
               - `No Upfront`: No upfront payment.
               - `Partial Upfront`: A portion of upfront payment.
               - `All Upfront`: Full upfront payment.
        :param pulumi.Input[_builtins.int] period: The validity period of the reserved instance. Default value: `1`. **NOTE:** From version 1.183.0, `period` can be set to `5`, when `period_unit` is `Year`.
               - When `period_unit` is `Year`, Valid values: `1`, `3`, `5`.
               - When `period_unit` is `Month`, Valid values: `1`.
        :param pulumi.Input[_builtins.str] period_unit: The unit of the validity period of the reserved instance. Valid value: `Month`, `Year`. Default value: `Year`. **NOTE:** From version 1.183.0, `period_unit` can be set to `Month`.
        :param pulumi.Input[_builtins.str] platform: The operating system type of the image used by the instance. Optional values: `Windows`, `Linux`. Default is `Linux`.
        :param pulumi.Input[_builtins.str] renewal_status: Automatic renewal status. Valid values: `AutoRenewal`,`Normal`.
        :param pulumi.Input[_builtins.str] reserved_instance_name: Name of the RI. The name must be a string of 2 to 128 characters in length and can contain letters, numbers, colons (:), underscores (_), and hyphens. It must start with a letter. It cannot start with http:// or https://.
        :param pulumi.Input[_builtins.str] resource_group_id: Resource group ID.
        :param pulumi.Input[_builtins.str] scope: Scope of the RI. Optional values: `Region`: region-level, `Zone`: zone-level. Default is `Region`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.str] zone_id: ID of the zone to which the RI belongs. When Scope is set to Zone, this parameter is required. For information about the zone list, see [DescribeZones](https://www.alibabacloud.com/help/doc-detail/25610.html).
        """
        pulumi.set(__self__, "instance_type", instance_type)
        if auto_renew_period is not None:
            pulumi.set(__self__, "auto_renew_period", auto_renew_period)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if instance_amount is not None:
            pulumi.set(__self__, "instance_amount", instance_amount)
        if name is not None:
            warnings.warn("""Field 'name' has been deprecated from provider version 1.194.0. New field 'reserved_instance_name' instead.""", DeprecationWarning)
            pulumi.log.warn("""name is deprecated: Field 'name' has been deprecated from provider version 1.194.0. New field 'reserved_instance_name' instead.""")
        if name is not None:
            pulumi.set(__self__, "name", name)
        if offering_type is not None:
            pulumi.set(__self__, "offering_type", offering_type)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)
        if platform is not None:
            pulumi.set(__self__, "platform", platform)
        if renewal_status is not None:
            pulumi.set(__self__, "renewal_status", renewal_status)
        if reserved_instance_name is not None:
            pulumi.set(__self__, "reserved_instance_name", reserved_instance_name)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Input[_builtins.str]:
        """
        Instance type of the RI. For more information, see [Instance type families](https://www.alibabacloud.com/help/doc-detail/25378.html).
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_type", value)

    @_builtins.property
    @pulumi.getter(name="autoRenewPeriod")
    def auto_renew_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The auto-renewal term of the reserved instance. This parameter takes effect only when AutoRenew is set to true. Valid values: 1, 12, 36, and 60. Default value when `period_unit` is set to Month: 1 Default value when `period_unit` is set to Year: 12
        """
        return pulumi.get(self, "auto_renew_period")

    @auto_renew_period.setter
    def auto_renew_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "auto_renew_period", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the RI. 2 to 256 English or Chinese characters. It cannot start with `http://` or `https://`.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="instanceAmount")
    def instance_amount(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of instances allocated to an RI (An RI is a coupon that includes one or more allocated instances.).
        """
        return pulumi.get(self, "instance_amount")

    @instance_amount.setter
    def instance_amount(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "instance_amount", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'name' has been deprecated from provider version 1.194.0. New field 'reserved_instance_name' instead.""")
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Field `name` has been deprecated from provider version 1.194.0. New field `reserved_instance_name` instead.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="offeringType")
    def offering_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Payment type of the RI. Default value: `All Upfront`. Valid values:
        - `No Upfront`: No upfront payment.
        - `Partial Upfront`: A portion of upfront payment.
        - `All Upfront`: Full upfront payment.
        """
        return pulumi.get(self, "offering_type")

    @offering_type.setter
    def offering_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "offering_type", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The validity period of the reserved instance. Default value: `1`. **NOTE:** From version 1.183.0, `period` can be set to `5`, when `period_unit` is `Year`.
        - When `period_unit` is `Year`, Valid values: `1`, `3`, `5`.
        - When `period_unit` is `Month`, Valid values: `1`.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unit of the validity period of the reserved instance. Valid value: `Month`, `Year`. Default value: `Year`. **NOTE:** From version 1.183.0, `period_unit` can be set to `Month`.
        """
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "period_unit", value)

    @_builtins.property
    @pulumi.getter
    def platform(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The operating system type of the image used by the instance. Optional values: `Windows`, `Linux`. Default is `Linux`.
        """
        return pulumi.get(self, "platform")

    @platform.setter
    def platform(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "platform", value)

    @_builtins.property
    @pulumi.getter(name="renewalStatus")
    def renewal_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Automatic renewal status. Valid values: `AutoRenewal`,`Normal`.
        """
        return pulumi.get(self, "renewal_status")

    @renewal_status.setter
    def renewal_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "renewal_status", value)

    @_builtins.property
    @pulumi.getter(name="reservedInstanceName")
    def reserved_instance_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the RI. The name must be a string of 2 to 128 characters in length and can contain letters, numbers, colons (:), underscores (_), and hyphens. It must start with a letter. It cannot start with http:// or https://.
        """
        return pulumi.get(self, "reserved_instance_name")

    @reserved_instance_name.setter
    def reserved_instance_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "reserved_instance_name", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource group ID.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Scope of the RI. Optional values: `Region`: region-level, `Zone`: zone-level. Default is `Region`.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scope", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the zone to which the RI belongs. When Scope is set to Zone, this parameter is required. For information about the zone list, see [DescribeZones](https://www.alibabacloud.com/help/doc-detail/25610.html).
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone_id", value)


@pulumi.input_type
class _ReservedInstanceState:
    def __init__(__self__, *,
                 allocation_status: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_renew_period: Optional[pulumi.Input[_builtins.int]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 expired_time: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_amount: Optional[pulumi.Input[_builtins.int]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 offering_type: Optional[pulumi.Input[_builtins.str]] = None,
                 operation_locks: Optional[pulumi.Input[Sequence[pulumi.Input['ReservedInstanceOperationLockArgs']]]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 platform: Optional[pulumi.Input[_builtins.str]] = None,
                 renewal_status: Optional[pulumi.Input[_builtins.str]] = None,
                 reserved_instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 scope: Optional[pulumi.Input[_builtins.str]] = None,
                 start_time: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ReservedInstance resources.
        :param pulumi.Input[_builtins.str] allocation_status: Indicates the sharing status of the reserved instance when the AllocationType parameter is set to Shared. Valid values: `allocated`: The reserved instance is allocated to another account. `beAllocated`: The reserved instance is allocated by another account.
        :param pulumi.Input[_builtins.int] auto_renew_period: The auto-renewal term of the reserved instance. This parameter takes effect only when AutoRenew is set to true. Valid values: 1, 12, 36, and 60. Default value when `period_unit` is set to Month: 1 Default value when `period_unit` is set to Year: 12
        :param pulumi.Input[_builtins.str] create_time: The time when the reserved instance was created.
        :param pulumi.Input[_builtins.str] description: Description of the RI. 2 to 256 English or Chinese characters. It cannot start with `http://` or `https://`.
        :param pulumi.Input[_builtins.str] expired_time: The time when the reserved instance expires.
        :param pulumi.Input[_builtins.int] instance_amount: Number of instances allocated to an RI (An RI is a coupon that includes one or more allocated instances.).
        :param pulumi.Input[_builtins.str] instance_type: Instance type of the RI. For more information, see [Instance type families](https://www.alibabacloud.com/help/doc-detail/25378.html).
        :param pulumi.Input[_builtins.str] name: Field `name` has been deprecated from provider version 1.194.0. New field `reserved_instance_name` instead.
        :param pulumi.Input[_builtins.str] offering_type: Payment type of the RI. Default value: `All Upfront`. Valid values:
               - `No Upfront`: No upfront payment.
               - `Partial Upfront`: A portion of upfront payment.
               - `All Upfront`: Full upfront payment.
        :param pulumi.Input[Sequence[pulumi.Input['ReservedInstanceOperationLockArgs']]] operation_locks: Details about the lock status of the reserved instance.
        :param pulumi.Input[_builtins.int] period: The validity period of the reserved instance. Default value: `1`. **NOTE:** From version 1.183.0, `period` can be set to `5`, when `period_unit` is `Year`.
               - When `period_unit` is `Year`, Valid values: `1`, `3`, `5`.
               - When `period_unit` is `Month`, Valid values: `1`.
        :param pulumi.Input[_builtins.str] period_unit: The unit of the validity period of the reserved instance. Valid value: `Month`, `Year`. Default value: `Year`. **NOTE:** From version 1.183.0, `period_unit` can be set to `Month`.
        :param pulumi.Input[_builtins.str] platform: The operating system type of the image used by the instance. Optional values: `Windows`, `Linux`. Default is `Linux`.
        :param pulumi.Input[_builtins.str] renewal_status: Automatic renewal status. Valid values: `AutoRenewal`,`Normal`.
        :param pulumi.Input[_builtins.str] reserved_instance_name: Name of the RI. The name must be a string of 2 to 128 characters in length and can contain letters, numbers, colons (:), underscores (_), and hyphens. It must start with a letter. It cannot start with http:// or https://.
        :param pulumi.Input[_builtins.str] resource_group_id: Resource group ID.
        :param pulumi.Input[_builtins.str] scope: Scope of the RI. Optional values: `Region`: region-level, `Zone`: zone-level. Default is `Region`.
        :param pulumi.Input[_builtins.str] start_time: The time when the reserved instance took effect.
        :param pulumi.Input[_builtins.str] status: The status of the reserved instance.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.str] zone_id: ID of the zone to which the RI belongs. When Scope is set to Zone, this parameter is required. For information about the zone list, see [DescribeZones](https://www.alibabacloud.com/help/doc-detail/25610.html).
        """
        if allocation_status is not None:
            pulumi.set(__self__, "allocation_status", allocation_status)
        if auto_renew_period is not None:
            pulumi.set(__self__, "auto_renew_period", auto_renew_period)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if expired_time is not None:
            pulumi.set(__self__, "expired_time", expired_time)
        if instance_amount is not None:
            pulumi.set(__self__, "instance_amount", instance_amount)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if name is not None:
            warnings.warn("""Field 'name' has been deprecated from provider version 1.194.0. New field 'reserved_instance_name' instead.""", DeprecationWarning)
            pulumi.log.warn("""name is deprecated: Field 'name' has been deprecated from provider version 1.194.0. New field 'reserved_instance_name' instead.""")
        if name is not None:
            pulumi.set(__self__, "name", name)
        if offering_type is not None:
            pulumi.set(__self__, "offering_type", offering_type)
        if operation_locks is not None:
            pulumi.set(__self__, "operation_locks", operation_locks)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)
        if platform is not None:
            pulumi.set(__self__, "platform", platform)
        if renewal_status is not None:
            pulumi.set(__self__, "renewal_status", renewal_status)
        if reserved_instance_name is not None:
            pulumi.set(__self__, "reserved_instance_name", reserved_instance_name)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter(name="allocationStatus")
    def allocation_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the sharing status of the reserved instance when the AllocationType parameter is set to Shared. Valid values: `allocated`: The reserved instance is allocated to another account. `beAllocated`: The reserved instance is allocated by another account.
        """
        return pulumi.get(self, "allocation_status")

    @allocation_status.setter
    def allocation_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "allocation_status", value)

    @_builtins.property
    @pulumi.getter(name="autoRenewPeriod")
    def auto_renew_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The auto-renewal term of the reserved instance. This parameter takes effect only when AutoRenew is set to true. Valid values: 1, 12, 36, and 60. Default value when `period_unit` is set to Month: 1 Default value when `period_unit` is set to Year: 12
        """
        return pulumi.get(self, "auto_renew_period")

    @auto_renew_period.setter
    def auto_renew_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "auto_renew_period", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time when the reserved instance was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the RI. 2 to 256 English or Chinese characters. It cannot start with `http://` or `https://`.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="expiredTime")
    def expired_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time when the reserved instance expires.
        """
        return pulumi.get(self, "expired_time")

    @expired_time.setter
    def expired_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "expired_time", value)

    @_builtins.property
    @pulumi.getter(name="instanceAmount")
    def instance_amount(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of instances allocated to an RI (An RI is a coupon that includes one or more allocated instances.).
        """
        return pulumi.get(self, "instance_amount")

    @instance_amount.setter
    def instance_amount(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "instance_amount", value)

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Instance type of the RI. For more information, see [Instance type families](https://www.alibabacloud.com/help/doc-detail/25378.html).
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_type", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'name' has been deprecated from provider version 1.194.0. New field 'reserved_instance_name' instead.""")
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Field `name` has been deprecated from provider version 1.194.0. New field `reserved_instance_name` instead.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="offeringType")
    def offering_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Payment type of the RI. Default value: `All Upfront`. Valid values:
        - `No Upfront`: No upfront payment.
        - `Partial Upfront`: A portion of upfront payment.
        - `All Upfront`: Full upfront payment.
        """
        return pulumi.get(self, "offering_type")

    @offering_type.setter
    def offering_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "offering_type", value)

    @_builtins.property
    @pulumi.getter(name="operationLocks")
    def operation_locks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ReservedInstanceOperationLockArgs']]]]:
        """
        Details about the lock status of the reserved instance.
        """
        return pulumi.get(self, "operation_locks")

    @operation_locks.setter
    def operation_locks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ReservedInstanceOperationLockArgs']]]]):
        pulumi.set(self, "operation_locks", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The validity period of the reserved instance. Default value: `1`. **NOTE:** From version 1.183.0, `period` can be set to `5`, when `period_unit` is `Year`.
        - When `period_unit` is `Year`, Valid values: `1`, `3`, `5`.
        - When `period_unit` is `Month`, Valid values: `1`.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unit of the validity period of the reserved instance. Valid value: `Month`, `Year`. Default value: `Year`. **NOTE:** From version 1.183.0, `period_unit` can be set to `Month`.
        """
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "period_unit", value)

    @_builtins.property
    @pulumi.getter
    def platform(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The operating system type of the image used by the instance. Optional values: `Windows`, `Linux`. Default is `Linux`.
        """
        return pulumi.get(self, "platform")

    @platform.setter
    def platform(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "platform", value)

    @_builtins.property
    @pulumi.getter(name="renewalStatus")
    def renewal_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Automatic renewal status. Valid values: `AutoRenewal`,`Normal`.
        """
        return pulumi.get(self, "renewal_status")

    @renewal_status.setter
    def renewal_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "renewal_status", value)

    @_builtins.property
    @pulumi.getter(name="reservedInstanceName")
    def reserved_instance_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the RI. The name must be a string of 2 to 128 characters in length and can contain letters, numbers, colons (:), underscores (_), and hyphens. It must start with a letter. It cannot start with http:// or https://.
        """
        return pulumi.get(self, "reserved_instance_name")

    @reserved_instance_name.setter
    def reserved_instance_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "reserved_instance_name", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource group ID.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Scope of the RI. Optional values: `Region`: region-level, `Zone`: zone-level. Default is `Region`.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scope", value)

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time when the reserved instance took effect.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "start_time", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the reserved instance.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the zone to which the RI belongs. When Scope is set to Zone, this parameter is required. For information about the zone list, see [DescribeZones](https://www.alibabacloud.com/help/doc-detail/25610.html).
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone_id", value)


@pulumi.type_token("alicloud:ecs/reservedInstance:ReservedInstance")
class ReservedInstance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_renew_period: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_amount: Optional[pulumi.Input[_builtins.int]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 offering_type: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 platform: Optional[pulumi.Input[_builtins.str]] = None,
                 renewal_status: Optional[pulumi.Input[_builtins.str]] = None,
                 reserved_instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 scope: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides an Reserved Instance resource.

        > **NOTE:** Available since v1.65.0.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default = alicloud.ecs.get_instance_types(instance_type_family="ecs.g6")
        default_reserved_instance = alicloud.ecs.ReservedInstance("default",
            instance_type=default.instance_types[0].id,
            instance_amount=1,
            period_unit="Month",
            offering_type="All Upfront",
            reserved_instance_name="terraform-example",
            description="ReservedInstance",
            zone_id=default.instance_types[0].availability_zones[0],
            scope="Zone")
        ```

        ## Import

        reservedInstance can be imported using id, e.g.

        ```sh
        $ pulumi import alicloud:ecs/reservedInstance:ReservedInstance default ecsri-uf6df4xm0h3licit****
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] auto_renew_period: The auto-renewal term of the reserved instance. This parameter takes effect only when AutoRenew is set to true. Valid values: 1, 12, 36, and 60. Default value when `period_unit` is set to Month: 1 Default value when `period_unit` is set to Year: 12
        :param pulumi.Input[_builtins.str] description: Description of the RI. 2 to 256 English or Chinese characters. It cannot start with `http://` or `https://`.
        :param pulumi.Input[_builtins.int] instance_amount: Number of instances allocated to an RI (An RI is a coupon that includes one or more allocated instances.).
        :param pulumi.Input[_builtins.str] instance_type: Instance type of the RI. For more information, see [Instance type families](https://www.alibabacloud.com/help/doc-detail/25378.html).
        :param pulumi.Input[_builtins.str] name: Field `name` has been deprecated from provider version 1.194.0. New field `reserved_instance_name` instead.
        :param pulumi.Input[_builtins.str] offering_type: Payment type of the RI. Default value: `All Upfront`. Valid values:
               - `No Upfront`: No upfront payment.
               - `Partial Upfront`: A portion of upfront payment.
               - `All Upfront`: Full upfront payment.
        :param pulumi.Input[_builtins.int] period: The validity period of the reserved instance. Default value: `1`. **NOTE:** From version 1.183.0, `period` can be set to `5`, when `period_unit` is `Year`.
               - When `period_unit` is `Year`, Valid values: `1`, `3`, `5`.
               - When `period_unit` is `Month`, Valid values: `1`.
        :param pulumi.Input[_builtins.str] period_unit: The unit of the validity period of the reserved instance. Valid value: `Month`, `Year`. Default value: `Year`. **NOTE:** From version 1.183.0, `period_unit` can be set to `Month`.
        :param pulumi.Input[_builtins.str] platform: The operating system type of the image used by the instance. Optional values: `Windows`, `Linux`. Default is `Linux`.
        :param pulumi.Input[_builtins.str] renewal_status: Automatic renewal status. Valid values: `AutoRenewal`,`Normal`.
        :param pulumi.Input[_builtins.str] reserved_instance_name: Name of the RI. The name must be a string of 2 to 128 characters in length and can contain letters, numbers, colons (:), underscores (_), and hyphens. It must start with a letter. It cannot start with http:// or https://.
        :param pulumi.Input[_builtins.str] resource_group_id: Resource group ID.
        :param pulumi.Input[_builtins.str] scope: Scope of the RI. Optional values: `Region`: region-level, `Zone`: zone-level. Default is `Region`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.str] zone_id: ID of the zone to which the RI belongs. When Scope is set to Zone, this parameter is required. For information about the zone list, see [DescribeZones](https://www.alibabacloud.com/help/doc-detail/25610.html).
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ReservedInstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an Reserved Instance resource.

        > **NOTE:** Available since v1.65.0.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default = alicloud.ecs.get_instance_types(instance_type_family="ecs.g6")
        default_reserved_instance = alicloud.ecs.ReservedInstance("default",
            instance_type=default.instance_types[0].id,
            instance_amount=1,
            period_unit="Month",
            offering_type="All Upfront",
            reserved_instance_name="terraform-example",
            description="ReservedInstance",
            zone_id=default.instance_types[0].availability_zones[0],
            scope="Zone")
        ```

        ## Import

        reservedInstance can be imported using id, e.g.

        ```sh
        $ pulumi import alicloud:ecs/reservedInstance:ReservedInstance default ecsri-uf6df4xm0h3licit****
        ```

        :param str resource_name: The name of the resource.
        :param ReservedInstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ReservedInstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_renew_period: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_amount: Optional[pulumi.Input[_builtins.int]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 offering_type: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 platform: Optional[pulumi.Input[_builtins.str]] = None,
                 renewal_status: Optional[pulumi.Input[_builtins.str]] = None,
                 reserved_instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 scope: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ReservedInstanceArgs.__new__(ReservedInstanceArgs)

            __props__.__dict__["auto_renew_period"] = auto_renew_period
            __props__.__dict__["description"] = description
            __props__.__dict__["instance_amount"] = instance_amount
            if instance_type is None and not opts.urn:
                raise TypeError("Missing required property 'instance_type'")
            __props__.__dict__["instance_type"] = instance_type
            __props__.__dict__["name"] = name
            __props__.__dict__["offering_type"] = offering_type
            __props__.__dict__["period"] = period
            __props__.__dict__["period_unit"] = period_unit
            __props__.__dict__["platform"] = platform
            __props__.__dict__["renewal_status"] = renewal_status
            __props__.__dict__["reserved_instance_name"] = reserved_instance_name
            __props__.__dict__["resource_group_id"] = resource_group_id
            __props__.__dict__["scope"] = scope
            __props__.__dict__["tags"] = tags
            __props__.__dict__["zone_id"] = zone_id
            __props__.__dict__["allocation_status"] = None
            __props__.__dict__["create_time"] = None
            __props__.__dict__["expired_time"] = None
            __props__.__dict__["operation_locks"] = None
            __props__.__dict__["start_time"] = None
            __props__.__dict__["status"] = None
        super(ReservedInstance, __self__).__init__(
            'alicloud:ecs/reservedInstance:ReservedInstance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allocation_status: Optional[pulumi.Input[_builtins.str]] = None,
            auto_renew_period: Optional[pulumi.Input[_builtins.int]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            expired_time: Optional[pulumi.Input[_builtins.str]] = None,
            instance_amount: Optional[pulumi.Input[_builtins.int]] = None,
            instance_type: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            offering_type: Optional[pulumi.Input[_builtins.str]] = None,
            operation_locks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ReservedInstanceOperationLockArgs', 'ReservedInstanceOperationLockArgsDict']]]]] = None,
            period: Optional[pulumi.Input[_builtins.int]] = None,
            period_unit: Optional[pulumi.Input[_builtins.str]] = None,
            platform: Optional[pulumi.Input[_builtins.str]] = None,
            renewal_status: Optional[pulumi.Input[_builtins.str]] = None,
            reserved_instance_name: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            scope: Optional[pulumi.Input[_builtins.str]] = None,
            start_time: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            zone_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'ReservedInstance':
        """
        Get an existing ReservedInstance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] allocation_status: Indicates the sharing status of the reserved instance when the AllocationType parameter is set to Shared. Valid values: `allocated`: The reserved instance is allocated to another account. `beAllocated`: The reserved instance is allocated by another account.
        :param pulumi.Input[_builtins.int] auto_renew_period: The auto-renewal term of the reserved instance. This parameter takes effect only when AutoRenew is set to true. Valid values: 1, 12, 36, and 60. Default value when `period_unit` is set to Month: 1 Default value when `period_unit` is set to Year: 12
        :param pulumi.Input[_builtins.str] create_time: The time when the reserved instance was created.
        :param pulumi.Input[_builtins.str] description: Description of the RI. 2 to 256 English or Chinese characters. It cannot start with `http://` or `https://`.
        :param pulumi.Input[_builtins.str] expired_time: The time when the reserved instance expires.
        :param pulumi.Input[_builtins.int] instance_amount: Number of instances allocated to an RI (An RI is a coupon that includes one or more allocated instances.).
        :param pulumi.Input[_builtins.str] instance_type: Instance type of the RI. For more information, see [Instance type families](https://www.alibabacloud.com/help/doc-detail/25378.html).
        :param pulumi.Input[_builtins.str] name: Field `name` has been deprecated from provider version 1.194.0. New field `reserved_instance_name` instead.
        :param pulumi.Input[_builtins.str] offering_type: Payment type of the RI. Default value: `All Upfront`. Valid values:
               - `No Upfront`: No upfront payment.
               - `Partial Upfront`: A portion of upfront payment.
               - `All Upfront`: Full upfront payment.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ReservedInstanceOperationLockArgs', 'ReservedInstanceOperationLockArgsDict']]]] operation_locks: Details about the lock status of the reserved instance.
        :param pulumi.Input[_builtins.int] period: The validity period of the reserved instance. Default value: `1`. **NOTE:** From version 1.183.0, `period` can be set to `5`, when `period_unit` is `Year`.
               - When `period_unit` is `Year`, Valid values: `1`, `3`, `5`.
               - When `period_unit` is `Month`, Valid values: `1`.
        :param pulumi.Input[_builtins.str] period_unit: The unit of the validity period of the reserved instance. Valid value: `Month`, `Year`. Default value: `Year`. **NOTE:** From version 1.183.0, `period_unit` can be set to `Month`.
        :param pulumi.Input[_builtins.str] platform: The operating system type of the image used by the instance. Optional values: `Windows`, `Linux`. Default is `Linux`.
        :param pulumi.Input[_builtins.str] renewal_status: Automatic renewal status. Valid values: `AutoRenewal`,`Normal`.
        :param pulumi.Input[_builtins.str] reserved_instance_name: Name of the RI. The name must be a string of 2 to 128 characters in length and can contain letters, numbers, colons (:), underscores (_), and hyphens. It must start with a letter. It cannot start with http:// or https://.
        :param pulumi.Input[_builtins.str] resource_group_id: Resource group ID.
        :param pulumi.Input[_builtins.str] scope: Scope of the RI. Optional values: `Region`: region-level, `Zone`: zone-level. Default is `Region`.
        :param pulumi.Input[_builtins.str] start_time: The time when the reserved instance took effect.
        :param pulumi.Input[_builtins.str] status: The status of the reserved instance.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.str] zone_id: ID of the zone to which the RI belongs. When Scope is set to Zone, this parameter is required. For information about the zone list, see [DescribeZones](https://www.alibabacloud.com/help/doc-detail/25610.html).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ReservedInstanceState.__new__(_ReservedInstanceState)

        __props__.__dict__["allocation_status"] = allocation_status
        __props__.__dict__["auto_renew_period"] = auto_renew_period
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["expired_time"] = expired_time
        __props__.__dict__["instance_amount"] = instance_amount
        __props__.__dict__["instance_type"] = instance_type
        __props__.__dict__["name"] = name
        __props__.__dict__["offering_type"] = offering_type
        __props__.__dict__["operation_locks"] = operation_locks
        __props__.__dict__["period"] = period
        __props__.__dict__["period_unit"] = period_unit
        __props__.__dict__["platform"] = platform
        __props__.__dict__["renewal_status"] = renewal_status
        __props__.__dict__["reserved_instance_name"] = reserved_instance_name
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["scope"] = scope
        __props__.__dict__["start_time"] = start_time
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["zone_id"] = zone_id
        return ReservedInstance(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="allocationStatus")
    def allocation_status(self) -> pulumi.Output[_builtins.str]:
        """
        Indicates the sharing status of the reserved instance when the AllocationType parameter is set to Shared. Valid values: `allocated`: The reserved instance is allocated to another account. `beAllocated`: The reserved instance is allocated by another account.
        """
        return pulumi.get(self, "allocation_status")

    @_builtins.property
    @pulumi.getter(name="autoRenewPeriod")
    def auto_renew_period(self) -> pulumi.Output[_builtins.int]:
        """
        The auto-renewal term of the reserved instance. This parameter takes effect only when AutoRenew is set to true. Valid values: 1, 12, 36, and 60. Default value when `period_unit` is set to Month: 1 Default value when `period_unit` is set to Year: 12
        """
        return pulumi.get(self, "auto_renew_period")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The time when the reserved instance was created.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Description of the RI. 2 to 256 English or Chinese characters. It cannot start with `http://` or `https://`.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="expiredTime")
    def expired_time(self) -> pulumi.Output[_builtins.str]:
        """
        The time when the reserved instance expires.
        """
        return pulumi.get(self, "expired_time")

    @_builtins.property
    @pulumi.getter(name="instanceAmount")
    def instance_amount(self) -> pulumi.Output[_builtins.int]:
        """
        Number of instances allocated to an RI (An RI is a coupon that includes one or more allocated instances.).
        """
        return pulumi.get(self, "instance_amount")

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Output[_builtins.str]:
        """
        Instance type of the RI. For more information, see [Instance type families](https://www.alibabacloud.com/help/doc-detail/25378.html).
        """
        return pulumi.get(self, "instance_type")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'name' has been deprecated from provider version 1.194.0. New field 'reserved_instance_name' instead.""")
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Field `name` has been deprecated from provider version 1.194.0. New field `reserved_instance_name` instead.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="offeringType")
    def offering_type(self) -> pulumi.Output[_builtins.str]:
        """
        Payment type of the RI. Default value: `All Upfront`. Valid values:
        - `No Upfront`: No upfront payment.
        - `Partial Upfront`: A portion of upfront payment.
        - `All Upfront`: Full upfront payment.
        """
        return pulumi.get(self, "offering_type")

    @_builtins.property
    @pulumi.getter(name="operationLocks")
    def operation_locks(self) -> pulumi.Output[Sequence['outputs.ReservedInstanceOperationLock']]:
        """
        Details about the lock status of the reserved instance.
        """
        return pulumi.get(self, "operation_locks")

    @_builtins.property
    @pulumi.getter
    def period(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The validity period of the reserved instance. Default value: `1`. **NOTE:** From version 1.183.0, `period` can be set to `5`, when `period_unit` is `Year`.
        - When `period_unit` is `Year`, Valid values: `1`, `3`, `5`.
        - When `period_unit` is `Month`, Valid values: `1`.
        """
        return pulumi.get(self, "period")

    @_builtins.property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The unit of the validity period of the reserved instance. Valid value: `Month`, `Year`. Default value: `Year`. **NOTE:** From version 1.183.0, `period_unit` can be set to `Month`.
        """
        return pulumi.get(self, "period_unit")

    @_builtins.property
    @pulumi.getter
    def platform(self) -> pulumi.Output[_builtins.str]:
        """
        The operating system type of the image used by the instance. Optional values: `Windows`, `Linux`. Default is `Linux`.
        """
        return pulumi.get(self, "platform")

    @_builtins.property
    @pulumi.getter(name="renewalStatus")
    def renewal_status(self) -> pulumi.Output[_builtins.str]:
        """
        Automatic renewal status. Valid values: `AutoRenewal`,`Normal`.
        """
        return pulumi.get(self, "renewal_status")

    @_builtins.property
    @pulumi.getter(name="reservedInstanceName")
    def reserved_instance_name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the RI. The name must be a string of 2 to 128 characters in length and can contain letters, numbers, colons (:), underscores (_), and hyphens. It must start with a letter. It cannot start with http:// or https://.
        """
        return pulumi.get(self, "reserved_instance_name")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        Resource group ID.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter
    def scope(self) -> pulumi.Output[_builtins.str]:
        """
        Scope of the RI. Optional values: `Region`: region-level, `Zone`: zone-level. Default is `Region`.
        """
        return pulumi.get(self, "scope")

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> pulumi.Output[_builtins.str]:
        """
        The time when the reserved instance took effect.
        """
        return pulumi.get(self, "start_time")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the reserved instance.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        ID of the zone to which the RI belongs. When Scope is set to Zone, this parameter is required. For information about the zone list, see [DescribeZones](https://www.alibabacloud.com/help/doc-detail/25610.html).
        """
        return pulumi.get(self, "zone_id")

