# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['DiskInstanceAttachmentArgs', 'DiskInstanceAttachment']

@pulumi.input_type
class DiskInstanceAttachmentArgs:
    def __init__(__self__, *,
                 disk_id: pulumi.Input[_builtins.str],
                 instance_id: pulumi.Input[_builtins.str],
                 delete_with_instance: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a DiskInstanceAttachment resource.
        :param pulumi.Input[_builtins.str] disk_id: The ID of the cloud disk to be mounted. The Cloud Disk (DiskId) and the instance (InstanceId) must be on the same node.
        :param pulumi.Input[_builtins.str] instance_id: Instance ID.
        :param pulumi.Input[_builtins.str] delete_with_instance: Whether the cloud disk to be mounted is released with the instance  Value: true: When the instance is released, the cloud disk is released together with the instance. false: When the instance is released, the cloud disk is retained and is not released together with the instance. Empty means false by default.
        """
        pulumi.set(__self__, "disk_id", disk_id)
        pulumi.set(__self__, "instance_id", instance_id)
        if delete_with_instance is not None:
            pulumi.set(__self__, "delete_with_instance", delete_with_instance)

    @_builtins.property
    @pulumi.getter(name="diskId")
    def disk_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the cloud disk to be mounted. The Cloud Disk (DiskId) and the instance (InstanceId) must be on the same node.
        """
        return pulumi.get(self, "disk_id")

    @disk_id.setter
    def disk_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "disk_id", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        Instance ID.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="deleteWithInstance")
    def delete_with_instance(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether the cloud disk to be mounted is released with the instance  Value: true: When the instance is released, the cloud disk is released together with the instance. false: When the instance is released, the cloud disk is retained and is not released together with the instance. Empty means false by default.
        """
        return pulumi.get(self, "delete_with_instance")

    @delete_with_instance.setter
    def delete_with_instance(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "delete_with_instance", value)


@pulumi.input_type
class _DiskInstanceAttachmentState:
    def __init__(__self__, *,
                 delete_with_instance: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering DiskInstanceAttachment resources.
        :param pulumi.Input[_builtins.str] delete_with_instance: Whether the cloud disk to be mounted is released with the instance  Value: true: When the instance is released, the cloud disk is released together with the instance. false: When the instance is released, the cloud disk is retained and is not released together with the instance. Empty means false by default.
        :param pulumi.Input[_builtins.str] disk_id: The ID of the cloud disk to be mounted. The Cloud Disk (DiskId) and the instance (InstanceId) must be on the same node.
        :param pulumi.Input[_builtins.str] instance_id: Instance ID.
        """
        if delete_with_instance is not None:
            pulumi.set(__self__, "delete_with_instance", delete_with_instance)
        if disk_id is not None:
            pulumi.set(__self__, "disk_id", disk_id)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)

    @_builtins.property
    @pulumi.getter(name="deleteWithInstance")
    def delete_with_instance(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether the cloud disk to be mounted is released with the instance  Value: true: When the instance is released, the cloud disk is released together with the instance. false: When the instance is released, the cloud disk is retained and is not released together with the instance. Empty means false by default.
        """
        return pulumi.get(self, "delete_with_instance")

    @delete_with_instance.setter
    def delete_with_instance(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "delete_with_instance", value)

    @_builtins.property
    @pulumi.getter(name="diskId")
    def disk_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the cloud disk to be mounted. The Cloud Disk (DiskId) and the instance (InstanceId) must be on the same node.
        """
        return pulumi.get(self, "disk_id")

    @disk_id.setter
    def disk_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "disk_id", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Instance ID.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)


@pulumi.type_token("alicloud:ens/diskInstanceAttachment:DiskInstanceAttachment")
class DiskInstanceAttachment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 delete_with_instance: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a ENS Disk Instance Attachment resource. Disk instance mount.

        For information about ENS Disk Instance Attachment and how to use it, see [What is Disk Instance Attachment](https://www.alibabacloud.com/help/en/ens/developer-reference/api-ens-2017-11-10-attachdisk).

        > **NOTE:** Available since v1.216.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.ens.Disk("default",
            size=20,
            ens_region_id="cn-chenzhou-telecom_unicom_cmcc",
            payment_type="PayAsYouGo",
            category="cloud_efficiency")
        default_instance = alicloud.ens.Instance("default",
            system_disk={
                "size": 20,
            },
            image_id="centos_6_08_64_20G_alibase_20171208",
            payment_type="Subscription",
            instance_type="ens.sn1.stiny",
            password="12345678ABCabc",
            amount=1,
            internet_max_bandwidth_out=10,
            unique_suffix=True,
            public_ip_identification=True,
            ens_region_id="cn-chenzhou-telecom_unicom_cmcc",
            schedule_area_level="Region",
            period_unit="Month",
            period=1)
        default_disk_instance_attachment = alicloud.ens.DiskInstanceAttachment("default",
            instance_id=default_instance.id,
            delete_with_instance="false",
            disk_id=default.id)
        ```

        ## Import

        ENS Disk Instance Attachment can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ens/diskInstanceAttachment:DiskInstanceAttachment example <disk_id>:<instance_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] delete_with_instance: Whether the cloud disk to be mounted is released with the instance  Value: true: When the instance is released, the cloud disk is released together with the instance. false: When the instance is released, the cloud disk is retained and is not released together with the instance. Empty means false by default.
        :param pulumi.Input[_builtins.str] disk_id: The ID of the cloud disk to be mounted. The Cloud Disk (DiskId) and the instance (InstanceId) must be on the same node.
        :param pulumi.Input[_builtins.str] instance_id: Instance ID.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DiskInstanceAttachmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a ENS Disk Instance Attachment resource. Disk instance mount.

        For information about ENS Disk Instance Attachment and how to use it, see [What is Disk Instance Attachment](https://www.alibabacloud.com/help/en/ens/developer-reference/api-ens-2017-11-10-attachdisk).

        > **NOTE:** Available since v1.216.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.ens.Disk("default",
            size=20,
            ens_region_id="cn-chenzhou-telecom_unicom_cmcc",
            payment_type="PayAsYouGo",
            category="cloud_efficiency")
        default_instance = alicloud.ens.Instance("default",
            system_disk={
                "size": 20,
            },
            image_id="centos_6_08_64_20G_alibase_20171208",
            payment_type="Subscription",
            instance_type="ens.sn1.stiny",
            password="12345678ABCabc",
            amount=1,
            internet_max_bandwidth_out=10,
            unique_suffix=True,
            public_ip_identification=True,
            ens_region_id="cn-chenzhou-telecom_unicom_cmcc",
            schedule_area_level="Region",
            period_unit="Month",
            period=1)
        default_disk_instance_attachment = alicloud.ens.DiskInstanceAttachment("default",
            instance_id=default_instance.id,
            delete_with_instance="false",
            disk_id=default.id)
        ```

        ## Import

        ENS Disk Instance Attachment can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ens/diskInstanceAttachment:DiskInstanceAttachment example <disk_id>:<instance_id>
        ```

        :param str resource_name: The name of the resource.
        :param DiskInstanceAttachmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DiskInstanceAttachmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 delete_with_instance: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DiskInstanceAttachmentArgs.__new__(DiskInstanceAttachmentArgs)

            __props__.__dict__["delete_with_instance"] = delete_with_instance
            if disk_id is None and not opts.urn:
                raise TypeError("Missing required property 'disk_id'")
            __props__.__dict__["disk_id"] = disk_id
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
        super(DiskInstanceAttachment, __self__).__init__(
            'alicloud:ens/diskInstanceAttachment:DiskInstanceAttachment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            delete_with_instance: Optional[pulumi.Input[_builtins.str]] = None,
            disk_id: Optional[pulumi.Input[_builtins.str]] = None,
            instance_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'DiskInstanceAttachment':
        """
        Get an existing DiskInstanceAttachment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] delete_with_instance: Whether the cloud disk to be mounted is released with the instance  Value: true: When the instance is released, the cloud disk is released together with the instance. false: When the instance is released, the cloud disk is retained and is not released together with the instance. Empty means false by default.
        :param pulumi.Input[_builtins.str] disk_id: The ID of the cloud disk to be mounted. The Cloud Disk (DiskId) and the instance (InstanceId) must be on the same node.
        :param pulumi.Input[_builtins.str] instance_id: Instance ID.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DiskInstanceAttachmentState.__new__(_DiskInstanceAttachmentState)

        __props__.__dict__["delete_with_instance"] = delete_with_instance
        __props__.__dict__["disk_id"] = disk_id
        __props__.__dict__["instance_id"] = instance_id
        return DiskInstanceAttachment(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="deleteWithInstance")
    def delete_with_instance(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Whether the cloud disk to be mounted is released with the instance  Value: true: When the instance is released, the cloud disk is released together with the instance. false: When the instance is released, the cloud disk is retained and is not released together with the instance. Empty means false by default.
        """
        return pulumi.get(self, "delete_with_instance")

    @_builtins.property
    @pulumi.getter(name="diskId")
    def disk_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the cloud disk to be mounted. The Cloud Disk (DiskId) and the instance (InstanceId) must be on the same node.
        """
        return pulumi.get(self, "disk_id")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        Instance ID.
        """
        return pulumi.get(self, "instance_id")

