# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['InstanceSecurityGroupAttachmentArgs', 'InstanceSecurityGroupAttachment']

@pulumi.input_type
class InstanceSecurityGroupAttachmentArgs:
    def __init__(__self__, *,
                 security_group_id: pulumi.Input[_builtins.str],
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a InstanceSecurityGroupAttachment resource.
        :param pulumi.Input[_builtins.str] security_group_id: Security group ID.
        :param pulumi.Input[_builtins.str] instance_id: Instance ID.
        """
        pulumi.set(__self__, "security_group_id", security_group_id)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> pulumi.Input[_builtins.str]:
        """
        Security group ID.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "security_group_id", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Instance ID.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)


@pulumi.input_type
class _InstanceSecurityGroupAttachmentState:
    def __init__(__self__, *,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering InstanceSecurityGroupAttachment resources.
        :param pulumi.Input[_builtins.str] instance_id: Instance ID.
        :param pulumi.Input[_builtins.str] security_group_id: Security group ID.
        """
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Instance ID.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Security group ID.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_group_id", value)


@pulumi.type_token("alicloud:ens/instanceSecurityGroupAttachment:InstanceSecurityGroupAttachment")
class InstanceSecurityGroupAttachment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a ENS Instance Security Group Attachment resource.

        Bind instance and security group.

        For information about ENS Instance Security Group Attachment and how to use it, see [What is Instance Security Group Attachment](https://next.api.alibabacloud.com/document/Ens/2017-11-10/JoinSecurityGroup).

        > **NOTE:** Available since v1.216.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.ens.Instance("default",
            system_disk={
                "size": 20,
            },
            schedule_area_level="Region",
            image_id="centos_6_08_64_20G_alibase_20171208",
            payment_type="Subscription",
            instance_type="ens.sn1.stiny",
            password="12345678ABCabc",
            amount=1,
            period=1,
            internet_max_bandwidth_out=10,
            public_ip_identification=True,
            ens_region_id="cn-chenzhou-telecom_unicom_cmcc",
            period_unit="Month")
        default_security_group = alicloud.ens.SecurityGroup("default",
            description="InstanceSecurityGroupAttachment_Description",
            security_group_name=name)
        default_instance_security_group_attachment = alicloud.ens.InstanceSecurityGroupAttachment("default",
            instance_id=default.id,
            security_group_id=default_security_group.id)
        ```

        ## Import

        ENS Instance Security Group Attachment can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ens/instanceSecurityGroupAttachment:InstanceSecurityGroupAttachment example <instance_id>:<security_group_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] instance_id: Instance ID.
        :param pulumi.Input[_builtins.str] security_group_id: Security group ID.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InstanceSecurityGroupAttachmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a ENS Instance Security Group Attachment resource.

        Bind instance and security group.

        For information about ENS Instance Security Group Attachment and how to use it, see [What is Instance Security Group Attachment](https://next.api.alibabacloud.com/document/Ens/2017-11-10/JoinSecurityGroup).

        > **NOTE:** Available since v1.216.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.ens.Instance("default",
            system_disk={
                "size": 20,
            },
            schedule_area_level="Region",
            image_id="centos_6_08_64_20G_alibase_20171208",
            payment_type="Subscription",
            instance_type="ens.sn1.stiny",
            password="12345678ABCabc",
            amount=1,
            period=1,
            internet_max_bandwidth_out=10,
            public_ip_identification=True,
            ens_region_id="cn-chenzhou-telecom_unicom_cmcc",
            period_unit="Month")
        default_security_group = alicloud.ens.SecurityGroup("default",
            description="InstanceSecurityGroupAttachment_Description",
            security_group_name=name)
        default_instance_security_group_attachment = alicloud.ens.InstanceSecurityGroupAttachment("default",
            instance_id=default.id,
            security_group_id=default_security_group.id)
        ```

        ## Import

        ENS Instance Security Group Attachment can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ens/instanceSecurityGroupAttachment:InstanceSecurityGroupAttachment example <instance_id>:<security_group_id>
        ```

        :param str resource_name: The name of the resource.
        :param InstanceSecurityGroupAttachmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceSecurityGroupAttachmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceSecurityGroupAttachmentArgs.__new__(InstanceSecurityGroupAttachmentArgs)

            __props__.__dict__["instance_id"] = instance_id
            if security_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'security_group_id'")
            __props__.__dict__["security_group_id"] = security_group_id
        super(InstanceSecurityGroupAttachment, __self__).__init__(
            'alicloud:ens/instanceSecurityGroupAttachment:InstanceSecurityGroupAttachment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            security_group_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'InstanceSecurityGroupAttachment':
        """
        Get an existing InstanceSecurityGroupAttachment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] instance_id: Instance ID.
        :param pulumi.Input[_builtins.str] security_group_id: Security group ID.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstanceSecurityGroupAttachmentState.__new__(_InstanceSecurityGroupAttachmentState)

        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["security_group_id"] = security_group_id
        return InstanceSecurityGroupAttachment(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        Instance ID.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        Security group ID.
        """
        return pulumi.get(self, "security_group_id")

