# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['CustomScenePolicyArgs', 'CustomScenePolicy']

@pulumi.input_type
class CustomScenePolicyArgs:
    def __init__(__self__, *,
                 create_time: pulumi.Input[_builtins.str],
                 custom_scene_policy_name: pulumi.Input[_builtins.str],
                 end_time: pulumi.Input[_builtins.str],
                 site_ids: pulumi.Input[_builtins.str],
                 template: pulumi.Input[_builtins.str],
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a CustomScenePolicy resource.
        :param pulumi.Input[_builtins.str] create_time: The time when the policy takes effect.
               The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
        :param pulumi.Input[_builtins.str] custom_scene_policy_name: The policy name.
        :param pulumi.Input[_builtins.str] end_time: The time when the policy expires.
               The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
        :param pulumi.Input[_builtins.str] site_ids: The IDs of websites associated.
        :param pulumi.Input[_builtins.str] template: The name of the policy template. Valid value:
        :param pulumi.Input[_builtins.str] status: Policy effective status. Valid values: `Disabled`, `Running`.
        """
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "custom_scene_policy_name", custom_scene_policy_name)
        pulumi.set(__self__, "end_time", end_time)
        pulumi.set(__self__, "site_ids", site_ids)
        pulumi.set(__self__, "template", template)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Input[_builtins.str]:
        """
        The time when the policy takes effect.
        The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="customScenePolicyName")
    def custom_scene_policy_name(self) -> pulumi.Input[_builtins.str]:
        """
        The policy name.
        """
        return pulumi.get(self, "custom_scene_policy_name")

    @custom_scene_policy_name.setter
    def custom_scene_policy_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "custom_scene_policy_name", value)

    @_builtins.property
    @pulumi.getter(name="endTime")
    def end_time(self) -> pulumi.Input[_builtins.str]:
        """
        The time when the policy expires.
        The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
        """
        return pulumi.get(self, "end_time")

    @end_time.setter
    def end_time(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "end_time", value)

    @_builtins.property
    @pulumi.getter(name="siteIds")
    def site_ids(self) -> pulumi.Input[_builtins.str]:
        """
        The IDs of websites associated.
        """
        return pulumi.get(self, "site_ids")

    @site_ids.setter
    def site_ids(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "site_ids", value)

    @_builtins.property
    @pulumi.getter
    def template(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the policy template. Valid value:
        """
        return pulumi.get(self, "template")

    @template.setter
    def template(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "template", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Policy effective status. Valid values: `Disabled`, `Running`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class _CustomScenePolicyState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_scene_policy_name: Optional[pulumi.Input[_builtins.str]] = None,
                 end_time: Optional[pulumi.Input[_builtins.str]] = None,
                 site_ids: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 template: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering CustomScenePolicy resources.
        :param pulumi.Input[_builtins.str] create_time: The time when the policy takes effect.
               The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
        :param pulumi.Input[_builtins.str] custom_scene_policy_name: The policy name.
        :param pulumi.Input[_builtins.str] end_time: The time when the policy expires.
               The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
        :param pulumi.Input[_builtins.str] site_ids: The IDs of websites associated.
        :param pulumi.Input[_builtins.str] status: Policy effective status. Valid values: `Disabled`, `Running`.
        :param pulumi.Input[_builtins.str] template: The name of the policy template. Valid value:
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if custom_scene_policy_name is not None:
            pulumi.set(__self__, "custom_scene_policy_name", custom_scene_policy_name)
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if site_ids is not None:
            pulumi.set(__self__, "site_ids", site_ids)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if template is not None:
            pulumi.set(__self__, "template", template)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time when the policy takes effect.
        The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="customScenePolicyName")
    def custom_scene_policy_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The policy name.
        """
        return pulumi.get(self, "custom_scene_policy_name")

    @custom_scene_policy_name.setter
    def custom_scene_policy_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "custom_scene_policy_name", value)

    @_builtins.property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time when the policy expires.
        The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
        """
        return pulumi.get(self, "end_time")

    @end_time.setter
    def end_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "end_time", value)

    @_builtins.property
    @pulumi.getter(name="siteIds")
    def site_ids(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IDs of websites associated.
        """
        return pulumi.get(self, "site_ids")

    @site_ids.setter
    def site_ids(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "site_ids", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Policy effective status. Valid values: `Disabled`, `Running`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def template(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the policy template. Valid value:
        """
        return pulumi.get(self, "template")

    @template.setter
    def template(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "template", value)


@pulumi.type_token("alicloud:esa/customScenePolicy:CustomScenePolicy")
class CustomScenePolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_scene_policy_name: Optional[pulumi.Input[_builtins.str]] = None,
                 end_time: Optional[pulumi.Input[_builtins.str]] = None,
                 site_ids: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 template: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a ESA Custom Scene Policy resource.

        For information about ESA Custom Scene Policy and how to use it, see [What is Custom Scene Policy](https://next.api.alibabacloud.com/document/ESA/2024-09-10/CreateCustomScenePolicy).

        > **NOTE:** Available since v1.253.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "bcd58610.com"
        default = alicloud.esa.get_sites(plan_subscribe_type="enterpriseplan")
        default_site = alicloud.esa.Site("default",
            site_name=name,
            instance_id=default.sites[0].instance_id,
            coverage="overseas",
            access_type="NS",
            version_management=True)
        default_custom_scene_policy = alicloud.esa.CustomScenePolicy("default",
            end_time="2025-08-07T17:00:00Z",
            create_time="2025-07-07T17:00:00Z",
            site_ids=default_site.id,
            template="promotion",
            custom_scene_policy_name="example-policy")
        ```

        ## Import

        ESA Custom Scene Policy can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:esa/customScenePolicy:CustomScenePolicy example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] create_time: The time when the policy takes effect.
               The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
        :param pulumi.Input[_builtins.str] custom_scene_policy_name: The policy name.
        :param pulumi.Input[_builtins.str] end_time: The time when the policy expires.
               The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
        :param pulumi.Input[_builtins.str] site_ids: The IDs of websites associated.
        :param pulumi.Input[_builtins.str] status: Policy effective status. Valid values: `Disabled`, `Running`.
        :param pulumi.Input[_builtins.str] template: The name of the policy template. Valid value:
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CustomScenePolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a ESA Custom Scene Policy resource.

        For information about ESA Custom Scene Policy and how to use it, see [What is Custom Scene Policy](https://next.api.alibabacloud.com/document/ESA/2024-09-10/CreateCustomScenePolicy).

        > **NOTE:** Available since v1.253.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "bcd58610.com"
        default = alicloud.esa.get_sites(plan_subscribe_type="enterpriseplan")
        default_site = alicloud.esa.Site("default",
            site_name=name,
            instance_id=default.sites[0].instance_id,
            coverage="overseas",
            access_type="NS",
            version_management=True)
        default_custom_scene_policy = alicloud.esa.CustomScenePolicy("default",
            end_time="2025-08-07T17:00:00Z",
            create_time="2025-07-07T17:00:00Z",
            site_ids=default_site.id,
            template="promotion",
            custom_scene_policy_name="example-policy")
        ```

        ## Import

        ESA Custom Scene Policy can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:esa/customScenePolicy:CustomScenePolicy example <id>
        ```

        :param str resource_name: The name of the resource.
        :param CustomScenePolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CustomScenePolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_scene_policy_name: Optional[pulumi.Input[_builtins.str]] = None,
                 end_time: Optional[pulumi.Input[_builtins.str]] = None,
                 site_ids: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 template: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CustomScenePolicyArgs.__new__(CustomScenePolicyArgs)

            if create_time is None and not opts.urn:
                raise TypeError("Missing required property 'create_time'")
            __props__.__dict__["create_time"] = create_time
            if custom_scene_policy_name is None and not opts.urn:
                raise TypeError("Missing required property 'custom_scene_policy_name'")
            __props__.__dict__["custom_scene_policy_name"] = custom_scene_policy_name
            if end_time is None and not opts.urn:
                raise TypeError("Missing required property 'end_time'")
            __props__.__dict__["end_time"] = end_time
            if site_ids is None and not opts.urn:
                raise TypeError("Missing required property 'site_ids'")
            __props__.__dict__["site_ids"] = site_ids
            __props__.__dict__["status"] = status
            if template is None and not opts.urn:
                raise TypeError("Missing required property 'template'")
            __props__.__dict__["template"] = template
        super(CustomScenePolicy, __self__).__init__(
            'alicloud:esa/customScenePolicy:CustomScenePolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            custom_scene_policy_name: Optional[pulumi.Input[_builtins.str]] = None,
            end_time: Optional[pulumi.Input[_builtins.str]] = None,
            site_ids: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            template: Optional[pulumi.Input[_builtins.str]] = None) -> 'CustomScenePolicy':
        """
        Get an existing CustomScenePolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] create_time: The time when the policy takes effect.
               The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
        :param pulumi.Input[_builtins.str] custom_scene_policy_name: The policy name.
        :param pulumi.Input[_builtins.str] end_time: The time when the policy expires.
               The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
        :param pulumi.Input[_builtins.str] site_ids: The IDs of websites associated.
        :param pulumi.Input[_builtins.str] status: Policy effective status. Valid values: `Disabled`, `Running`.
        :param pulumi.Input[_builtins.str] template: The name of the policy template. Valid value:
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CustomScenePolicyState.__new__(_CustomScenePolicyState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["custom_scene_policy_name"] = custom_scene_policy_name
        __props__.__dict__["end_time"] = end_time
        __props__.__dict__["site_ids"] = site_ids
        __props__.__dict__["status"] = status
        __props__.__dict__["template"] = template
        return CustomScenePolicy(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The time when the policy takes effect.
        The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="customScenePolicyName")
    def custom_scene_policy_name(self) -> pulumi.Output[_builtins.str]:
        """
        The policy name.
        """
        return pulumi.get(self, "custom_scene_policy_name")

    @_builtins.property
    @pulumi.getter(name="endTime")
    def end_time(self) -> pulumi.Output[_builtins.str]:
        """
        The time when the policy expires.
        The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
        """
        return pulumi.get(self, "end_time")

    @_builtins.property
    @pulumi.getter(name="siteIds")
    def site_ids(self) -> pulumi.Output[_builtins.str]:
        """
        The IDs of websites associated.
        """
        return pulumi.get(self, "site_ids")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Policy effective status. Valid values: `Disabled`, `Running`.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def template(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the policy template. Valid value:
        """
        return pulumi.get(self, "template")

