# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetSitesResult',
    'AwaitableGetSitesResult',
    'get_sites',
    'get_sites_output',
]

@pulumi.output_type
class GetSitesResult:
    """
    A collection of values returned by getSites.
    """
    def __init__(__self__, access_type=None, coverage=None, id=None, ids=None, name_regex=None, names=None, only_enterprise=None, output_file=None, page_number=None, page_size=None, plan_subscribe_type=None, resource_group_id=None, site_name=None, site_search_type=None, sites=None, status=None, tags=None):
        if access_type and not isinstance(access_type, str):
            raise TypeError("Expected argument 'access_type' to be a str")
        pulumi.set(__self__, "access_type", access_type)
        if coverage and not isinstance(coverage, str):
            raise TypeError("Expected argument 'coverage' to be a str")
        pulumi.set(__self__, "coverage", coverage)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if only_enterprise and not isinstance(only_enterprise, bool):
            raise TypeError("Expected argument 'only_enterprise' to be a bool")
        pulumi.set(__self__, "only_enterprise", only_enterprise)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if page_number and not isinstance(page_number, int):
            raise TypeError("Expected argument 'page_number' to be a int")
        pulumi.set(__self__, "page_number", page_number)
        if page_size and not isinstance(page_size, int):
            raise TypeError("Expected argument 'page_size' to be a int")
        pulumi.set(__self__, "page_size", page_size)
        if plan_subscribe_type and not isinstance(plan_subscribe_type, str):
            raise TypeError("Expected argument 'plan_subscribe_type' to be a str")
        pulumi.set(__self__, "plan_subscribe_type", plan_subscribe_type)
        if resource_group_id and not isinstance(resource_group_id, str):
            raise TypeError("Expected argument 'resource_group_id' to be a str")
        pulumi.set(__self__, "resource_group_id", resource_group_id)
        if site_name and not isinstance(site_name, str):
            raise TypeError("Expected argument 'site_name' to be a str")
        pulumi.set(__self__, "site_name", site_name)
        if site_search_type and not isinstance(site_search_type, str):
            raise TypeError("Expected argument 'site_search_type' to be a str")
        pulumi.set(__self__, "site_search_type", site_search_type)
        if sites and not isinstance(sites, list):
            raise TypeError("Expected argument 'sites' to be a list")
        pulumi.set(__self__, "sites", sites)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="accessType")
    def access_type(self) -> Optional[_builtins.str]:
        """
        Access type. Value:-**NS**: Managed access via NS.-**CNAME**: access through CNAME.
        """
        return pulumi.get(self, "access_type")

    @_builtins.property
    @pulumi.getter
    def coverage(self) -> Optional[_builtins.str]:
        """
        Acceleration area
        """
        return pulumi.get(self, "coverage")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        """
        A list of Site IDs.
        """
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name_regex")

    @_builtins.property
    @pulumi.getter
    def names(self) -> Sequence[_builtins.str]:
        """
        A list of name of Sites.
        """
        return pulumi.get(self, "names")

    @_builtins.property
    @pulumi.getter(name="onlyEnterprise")
    def only_enterprise(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "only_enterprise")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")

    @_builtins.property
    @pulumi.getter(name="pageNumber")
    def page_number(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "page_number")

    @_builtins.property
    @pulumi.getter(name="pageSize")
    def page_size(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "page_size")

    @_builtins.property
    @pulumi.getter(name="planSubscribeType")
    def plan_subscribe_type(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "plan_subscribe_type")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[_builtins.str]:
        """
        The ID of the resource group
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter(name="siteName")
    def site_name(self) -> Optional[_builtins.str]:
        """
        Site Name
        """
        return pulumi.get(self, "site_name")

    @_builtins.property
    @pulumi.getter(name="siteSearchType")
    def site_search_type(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "site_search_type")

    @_builtins.property
    @pulumi.getter
    def sites(self) -> Sequence['outputs.GetSitesSiteResult']:
        """
        A list of Site Entries. Each element contains the following attributes:
        """
        return pulumi.get(self, "sites")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        The status of the resource
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, _builtins.str]]:
        return pulumi.get(self, "tags")


class AwaitableGetSitesResult(GetSitesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSitesResult(
            access_type=self.access_type,
            coverage=self.coverage,
            id=self.id,
            ids=self.ids,
            name_regex=self.name_regex,
            names=self.names,
            only_enterprise=self.only_enterprise,
            output_file=self.output_file,
            page_number=self.page_number,
            page_size=self.page_size,
            plan_subscribe_type=self.plan_subscribe_type,
            resource_group_id=self.resource_group_id,
            site_name=self.site_name,
            site_search_type=self.site_search_type,
            sites=self.sites,
            status=self.status,
            tags=self.tags)


def get_sites(access_type: Optional[_builtins.str] = None,
              coverage: Optional[_builtins.str] = None,
              ids: Optional[Sequence[_builtins.str]] = None,
              name_regex: Optional[_builtins.str] = None,
              only_enterprise: Optional[_builtins.bool] = None,
              output_file: Optional[_builtins.str] = None,
              page_number: Optional[_builtins.int] = None,
              page_size: Optional[_builtins.int] = None,
              plan_subscribe_type: Optional[_builtins.str] = None,
              resource_group_id: Optional[_builtins.str] = None,
              site_name: Optional[_builtins.str] = None,
              site_search_type: Optional[_builtins.str] = None,
              status: Optional[_builtins.str] = None,
              tags: Optional[Mapping[str, _builtins.str]] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSitesResult:
    """
    This data source provides Esa Site available to the user.[What is Site](https://next.api.alibabacloud.com/document/ESA/2024-09-10/CreateSite)

    > **NOTE:** Available since v1.244.0.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    config = pulumi.Config()
    name = config.get("name")
    if name is None:
        name = "terraform-example"
    default_i_eo_df_u = alicloud.esa.RatePlanInstance("defaultIEoDfU",
        type="NS",
        auto_renew=True,
        period=1,
        payment_type="Subscription",
        coverage="overseas",
        auto_pay=True,
        plan_name="basic")
    default_site = alicloud.esa.Site("default",
        site_name="bcd.com",
        coverage="overseas",
        access_type="NS",
        instance_id=default_i_eo_df_u.id)
    default = alicloud.esa.get_sites_output(ids=[default_site.id],
        name_regex=default_site.site_name,
        site_name="bcd.com")
    pulumi.export("alicloudEsaSiteExampleId", default.sites[0].id)
    ```


    :param _builtins.str access_type: Access type. Value:-**NS**: Managed access via NS.-**CNAME**: access through CNAME.
    :param _builtins.str coverage: Acceleration area
    :param Sequence[_builtins.str] ids: A list of Site IDs.
    :param _builtins.str name_regex: A regex string to filter results by Group Metric Rule name.
    :param _builtins.bool only_enterprise: Only the Enterprise version, pass **true** when the table only queries the enterprise version of the site.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.int page_number: Current page number.
    :param _builtins.int page_size: Number of records per page.
    :param _builtins.str plan_subscribe_type: Package subscription type. Value:-**basicplan**: Basic version.-**standardplan**: Standard version.-**advancedplan**: Advanced version.-**enterpriseplan**: Enterprise Edition.
    :param _builtins.str resource_group_id: The ID of the resource group
    :param _builtins.str site_name: Site Name
    :param _builtins.str site_search_type: The search match pattern for the site name. The default value is exact match. Valid values:-**prefix**: matches the prefix.-**suffix**: The suffix matches.-**exact**: exact match.-**fuzzy**: fuzzy match.
    :param _builtins.str status: The status of the resource
    :param Mapping[str, _builtins.str] tags: Resource tags
    """
    __args__ = dict()
    __args__['accessType'] = access_type
    __args__['coverage'] = coverage
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['onlyEnterprise'] = only_enterprise
    __args__['outputFile'] = output_file
    __args__['pageNumber'] = page_number
    __args__['pageSize'] = page_size
    __args__['planSubscribeType'] = plan_subscribe_type
    __args__['resourceGroupId'] = resource_group_id
    __args__['siteName'] = site_name
    __args__['siteSearchType'] = site_search_type
    __args__['status'] = status
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:esa/getSites:getSites', __args__, opts=opts, typ=GetSitesResult).value

    return AwaitableGetSitesResult(
        access_type=pulumi.get(__ret__, 'access_type'),
        coverage=pulumi.get(__ret__, 'coverage'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        names=pulumi.get(__ret__, 'names'),
        only_enterprise=pulumi.get(__ret__, 'only_enterprise'),
        output_file=pulumi.get(__ret__, 'output_file'),
        page_number=pulumi.get(__ret__, 'page_number'),
        page_size=pulumi.get(__ret__, 'page_size'),
        plan_subscribe_type=pulumi.get(__ret__, 'plan_subscribe_type'),
        resource_group_id=pulumi.get(__ret__, 'resource_group_id'),
        site_name=pulumi.get(__ret__, 'site_name'),
        site_search_type=pulumi.get(__ret__, 'site_search_type'),
        sites=pulumi.get(__ret__, 'sites'),
        status=pulumi.get(__ret__, 'status'),
        tags=pulumi.get(__ret__, 'tags'))
def get_sites_output(access_type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                     coverage: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                     ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                     name_regex: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                     only_enterprise: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                     output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                     page_number: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                     page_size: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                     plan_subscribe_type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                     resource_group_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                     site_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                     site_search_type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                     status: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                     tags: Optional[pulumi.Input[Optional[Mapping[str, _builtins.str]]]] = None,
                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSitesResult]:
    """
    This data source provides Esa Site available to the user.[What is Site](https://next.api.alibabacloud.com/document/ESA/2024-09-10/CreateSite)

    > **NOTE:** Available since v1.244.0.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    config = pulumi.Config()
    name = config.get("name")
    if name is None:
        name = "terraform-example"
    default_i_eo_df_u = alicloud.esa.RatePlanInstance("defaultIEoDfU",
        type="NS",
        auto_renew=True,
        period=1,
        payment_type="Subscription",
        coverage="overseas",
        auto_pay=True,
        plan_name="basic")
    default_site = alicloud.esa.Site("default",
        site_name="bcd.com",
        coverage="overseas",
        access_type="NS",
        instance_id=default_i_eo_df_u.id)
    default = alicloud.esa.get_sites_output(ids=[default_site.id],
        name_regex=default_site.site_name,
        site_name="bcd.com")
    pulumi.export("alicloudEsaSiteExampleId", default.sites[0].id)
    ```


    :param _builtins.str access_type: Access type. Value:-**NS**: Managed access via NS.-**CNAME**: access through CNAME.
    :param _builtins.str coverage: Acceleration area
    :param Sequence[_builtins.str] ids: A list of Site IDs.
    :param _builtins.str name_regex: A regex string to filter results by Group Metric Rule name.
    :param _builtins.bool only_enterprise: Only the Enterprise version, pass **true** when the table only queries the enterprise version of the site.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.int page_number: Current page number.
    :param _builtins.int page_size: Number of records per page.
    :param _builtins.str plan_subscribe_type: Package subscription type. Value:-**basicplan**: Basic version.-**standardplan**: Standard version.-**advancedplan**: Advanced version.-**enterpriseplan**: Enterprise Edition.
    :param _builtins.str resource_group_id: The ID of the resource group
    :param _builtins.str site_name: Site Name
    :param _builtins.str site_search_type: The search match pattern for the site name. The default value is exact match. Valid values:-**prefix**: matches the prefix.-**suffix**: The suffix matches.-**exact**: exact match.-**fuzzy**: fuzzy match.
    :param _builtins.str status: The status of the resource
    :param Mapping[str, _builtins.str] tags: Resource tags
    """
    __args__ = dict()
    __args__['accessType'] = access_type
    __args__['coverage'] = coverage
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['onlyEnterprise'] = only_enterprise
    __args__['outputFile'] = output_file
    __args__['pageNumber'] = page_number
    __args__['pageSize'] = page_size
    __args__['planSubscribeType'] = plan_subscribe_type
    __args__['resourceGroupId'] = resource_group_id
    __args__['siteName'] = site_name
    __args__['siteSearchType'] = site_search_type
    __args__['status'] = status
    __args__['tags'] = tags
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:esa/getSites:getSites', __args__, opts=opts, typ=GetSitesResult)
    return __ret__.apply(lambda __response__: GetSitesResult(
        access_type=pulumi.get(__response__, 'access_type'),
        coverage=pulumi.get(__response__, 'coverage'),
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        name_regex=pulumi.get(__response__, 'name_regex'),
        names=pulumi.get(__response__, 'names'),
        only_enterprise=pulumi.get(__response__, 'only_enterprise'),
        output_file=pulumi.get(__response__, 'output_file'),
        page_number=pulumi.get(__response__, 'page_number'),
        page_size=pulumi.get(__response__, 'page_size'),
        plan_subscribe_type=pulumi.get(__response__, 'plan_subscribe_type'),
        resource_group_id=pulumi.get(__response__, 'resource_group_id'),
        site_name=pulumi.get(__response__, 'site_name'),
        site_search_type=pulumi.get(__response__, 'site_search_type'),
        sites=pulumi.get(__response__, 'sites'),
        status=pulumi.get(__response__, 'status'),
        tags=pulumi.get(__response__, 'tags')))
