# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['RatePlanInstanceArgs', 'RatePlanInstance']

@pulumi.input_type
class RatePlanInstanceArgs:
    def __init__(__self__, *,
                 auto_pay: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
                 coverage: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 plan_name: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a RatePlanInstance resource.
        :param pulumi.Input[_builtins.bool] auto_pay: Specifies whether to enable auto payment.
        :param pulumi.Input[_builtins.bool] auto_renew: Auto-renewal:
        :param pulumi.Input[_builtins.str] coverage: The service locations for the websites that can be associated with the plan. Multiple values are separated by commas (,). Valid values:
        :param pulumi.Input[_builtins.str] payment_type: The payment type of the resource. Valid values:
               - `Subscription`: subscription.
        :param pulumi.Input[_builtins.int] period: Subscription period (in months).
        :param pulumi.Input[_builtins.str] plan_name: Package name.Value range:
        :param pulumi.Input[_builtins.str] type: The DNS setup option for the website. Valid values:
               - `NS`
               - `CNAME`
        """
        if auto_pay is not None:
            pulumi.set(__self__, "auto_pay", auto_pay)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if coverage is not None:
            pulumi.set(__self__, "coverage", coverage)
        if payment_type is not None:
            pulumi.set(__self__, "payment_type", payment_type)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if plan_name is not None:
            pulumi.set(__self__, "plan_name", plan_name)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="autoPay")
    def auto_pay(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable auto payment.
        """
        return pulumi.get(self, "auto_pay")

    @auto_pay.setter
    def auto_pay(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_pay", value)

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Auto-renewal:
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_renew", value)

    @_builtins.property
    @pulumi.getter
    def coverage(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The service locations for the websites that can be associated with the plan. Multiple values are separated by commas (,). Valid values:
        """
        return pulumi.get(self, "coverage")

    @coverage.setter
    def coverage(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "coverage", value)

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The payment type of the resource. Valid values:
        - `Subscription`: subscription.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "payment_type", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Subscription period (in months).
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="planName")
    def plan_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Package name.Value range:
        """
        return pulumi.get(self, "plan_name")

    @plan_name.setter
    def plan_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "plan_name", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The DNS setup option for the website. Valid values:
        - `NS`
        - `CNAME`
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class _RatePlanInstanceState:
    def __init__(__self__, *,
                 auto_pay: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
                 coverage: Optional[pulumi.Input[_builtins.str]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_status: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 plan_name: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering RatePlanInstance resources.
        :param pulumi.Input[_builtins.bool] auto_pay: Specifies whether to enable auto payment.
        :param pulumi.Input[_builtins.bool] auto_renew: Auto-renewal:
        :param pulumi.Input[_builtins.str] coverage: The service locations for the websites that can be associated with the plan. Multiple values are separated by commas (,). Valid values:
        :param pulumi.Input[_builtins.str] create_time: The time when the plan was purchased.
        :param pulumi.Input[_builtins.str] instance_status: The plan instance status.
               - `Renewing`: renewing
        :param pulumi.Input[_builtins.str] payment_type: The payment type of the resource. Valid values:
               - `Subscription`: subscription.
        :param pulumi.Input[_builtins.int] period: Subscription period (in months).
        :param pulumi.Input[_builtins.str] plan_name: Package name.Value range:
        :param pulumi.Input[_builtins.str] status: The status of the resource.
        :param pulumi.Input[_builtins.str] type: The DNS setup option for the website. Valid values:
               - `NS`
               - `CNAME`
        """
        if auto_pay is not None:
            pulumi.set(__self__, "auto_pay", auto_pay)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if coverage is not None:
            pulumi.set(__self__, "coverage", coverage)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if instance_status is not None:
            pulumi.set(__self__, "instance_status", instance_status)
        if payment_type is not None:
            pulumi.set(__self__, "payment_type", payment_type)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if plan_name is not None:
            pulumi.set(__self__, "plan_name", plan_name)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="autoPay")
    def auto_pay(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable auto payment.
        """
        return pulumi.get(self, "auto_pay")

    @auto_pay.setter
    def auto_pay(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_pay", value)

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Auto-renewal:
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_renew", value)

    @_builtins.property
    @pulumi.getter
    def coverage(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The service locations for the websites that can be associated with the plan. Multiple values are separated by commas (,). Valid values:
        """
        return pulumi.get(self, "coverage")

    @coverage.setter
    def coverage(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "coverage", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time when the plan was purchased.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="instanceStatus")
    def instance_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The plan instance status.
        - `Renewing`: renewing
        """
        return pulumi.get(self, "instance_status")

    @instance_status.setter
    def instance_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_status", value)

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The payment type of the resource. Valid values:
        - `Subscription`: subscription.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "payment_type", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Subscription period (in months).
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="planName")
    def plan_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Package name.Value range:
        """
        return pulumi.get(self, "plan_name")

    @plan_name.setter
    def plan_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "plan_name", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the resource.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The DNS setup option for the website. Valid values:
        - `NS`
        - `CNAME`
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("alicloud:esa/ratePlanInstance:RatePlanInstance")
class RatePlanInstance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_pay: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
                 coverage: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 plan_name: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a ESA Rate Plan Instance resource.

        For information about ESA Rate Plan Instance and how to use it, see [What is Rate Plan Instance](https://www.alibabacloud.com/help/en/edge-security-acceleration/esa/product-overview/query-package-information).

        > **NOTE:** Available since v1.234.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.esa.RatePlanInstance("default",
            type="NS",
            auto_renew=True,
            period=1,
            payment_type="Subscription",
            coverage="overseas",
            plan_name="basic",
            auto_pay=True)
        ```

        ## Import

        ESA Rate Plan Instance can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:esa/ratePlanInstance:RatePlanInstance example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] auto_pay: Specifies whether to enable auto payment.
        :param pulumi.Input[_builtins.bool] auto_renew: Auto-renewal:
        :param pulumi.Input[_builtins.str] coverage: The service locations for the websites that can be associated with the plan. Multiple values are separated by commas (,). Valid values:
        :param pulumi.Input[_builtins.str] payment_type: The payment type of the resource. Valid values:
               - `Subscription`: subscription.
        :param pulumi.Input[_builtins.int] period: Subscription period (in months).
        :param pulumi.Input[_builtins.str] plan_name: Package name.Value range:
        :param pulumi.Input[_builtins.str] type: The DNS setup option for the website. Valid values:
               - `NS`
               - `CNAME`
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[RatePlanInstanceArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a ESA Rate Plan Instance resource.

        For information about ESA Rate Plan Instance and how to use it, see [What is Rate Plan Instance](https://www.alibabacloud.com/help/en/edge-security-acceleration/esa/product-overview/query-package-information).

        > **NOTE:** Available since v1.234.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.esa.RatePlanInstance("default",
            type="NS",
            auto_renew=True,
            period=1,
            payment_type="Subscription",
            coverage="overseas",
            plan_name="basic",
            auto_pay=True)
        ```

        ## Import

        ESA Rate Plan Instance can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:esa/ratePlanInstance:RatePlanInstance example <id>
        ```

        :param str resource_name: The name of the resource.
        :param RatePlanInstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RatePlanInstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_pay: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
                 coverage: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 plan_name: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RatePlanInstanceArgs.__new__(RatePlanInstanceArgs)

            __props__.__dict__["auto_pay"] = auto_pay
            __props__.__dict__["auto_renew"] = auto_renew
            __props__.__dict__["coverage"] = coverage
            __props__.__dict__["payment_type"] = payment_type
            __props__.__dict__["period"] = period
            __props__.__dict__["plan_name"] = plan_name
            __props__.__dict__["type"] = type
            __props__.__dict__["create_time"] = None
            __props__.__dict__["instance_status"] = None
            __props__.__dict__["status"] = None
        super(RatePlanInstance, __self__).__init__(
            'alicloud:esa/ratePlanInstance:RatePlanInstance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_pay: Optional[pulumi.Input[_builtins.bool]] = None,
            auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
            coverage: Optional[pulumi.Input[_builtins.str]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            instance_status: Optional[pulumi.Input[_builtins.str]] = None,
            payment_type: Optional[pulumi.Input[_builtins.str]] = None,
            period: Optional[pulumi.Input[_builtins.int]] = None,
            plan_name: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None) -> 'RatePlanInstance':
        """
        Get an existing RatePlanInstance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] auto_pay: Specifies whether to enable auto payment.
        :param pulumi.Input[_builtins.bool] auto_renew: Auto-renewal:
        :param pulumi.Input[_builtins.str] coverage: The service locations for the websites that can be associated with the plan. Multiple values are separated by commas (,). Valid values:
        :param pulumi.Input[_builtins.str] create_time: The time when the plan was purchased.
        :param pulumi.Input[_builtins.str] instance_status: The plan instance status.
               - `Renewing`: renewing
        :param pulumi.Input[_builtins.str] payment_type: The payment type of the resource. Valid values:
               - `Subscription`: subscription.
        :param pulumi.Input[_builtins.int] period: Subscription period (in months).
        :param pulumi.Input[_builtins.str] plan_name: Package name.Value range:
        :param pulumi.Input[_builtins.str] status: The status of the resource.
        :param pulumi.Input[_builtins.str] type: The DNS setup option for the website. Valid values:
               - `NS`
               - `CNAME`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RatePlanInstanceState.__new__(_RatePlanInstanceState)

        __props__.__dict__["auto_pay"] = auto_pay
        __props__.__dict__["auto_renew"] = auto_renew
        __props__.__dict__["coverage"] = coverage
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["instance_status"] = instance_status
        __props__.__dict__["payment_type"] = payment_type
        __props__.__dict__["period"] = period
        __props__.__dict__["plan_name"] = plan_name
        __props__.__dict__["status"] = status
        __props__.__dict__["type"] = type
        return RatePlanInstance(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="autoPay")
    def auto_pay(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether to enable auto payment.
        """
        return pulumi.get(self, "auto_pay")

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Auto-renewal:
        """
        return pulumi.get(self, "auto_renew")

    @_builtins.property
    @pulumi.getter
    def coverage(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The service locations for the websites that can be associated with the plan. Multiple values are separated by commas (,). Valid values:
        """
        return pulumi.get(self, "coverage")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The time when the plan was purchased.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="instanceStatus")
    def instance_status(self) -> pulumi.Output[_builtins.str]:
        """
        The plan instance status.
        - `Renewing`: renewing
        """
        return pulumi.get(self, "instance_status")

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> pulumi.Output[_builtins.str]:
        """
        The payment type of the resource. Valid values:
        - `Subscription`: subscription.
        """
        return pulumi.get(self, "payment_type")

    @_builtins.property
    @pulumi.getter
    def period(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Subscription period (in months).
        """
        return pulumi.get(self, "period")

    @_builtins.property
    @pulumi.getter(name="planName")
    def plan_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Package name.Value range:
        """
        return pulumi.get(self, "plan_name")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the resource.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The DNS setup option for the website. Valid values:
        - `NS`
        - `CNAME`
        """
        return pulumi.get(self, "type")

