# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['VersionArgs', 'Version']

@pulumi.input_type
class VersionArgs:
    def __init__(__self__, *,
                 origin_version: pulumi.Input[_builtins.int],
                 site_id: pulumi.Input[_builtins.int],
                 description: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Version resource.
        :param pulumi.Input[_builtins.int] origin_version: The version number of the site configuration. For sites that have enabled configuration version management, this parameter can be used to specify the effective version of the configuration site, which defaults to version 0.
        :param pulumi.Input[_builtins.int] site_id: The site ID, which can be obtained by calling the ListSites API.
        :param pulumi.Input[_builtins.str] description: The Site version's description.
        """
        pulumi.set(__self__, "origin_version", origin_version)
        pulumi.set(__self__, "site_id", site_id)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter(name="originVersion")
    def origin_version(self) -> pulumi.Input[_builtins.int]:
        """
        The version number of the site configuration. For sites that have enabled configuration version management, this parameter can be used to specify the effective version of the configuration site, which defaults to version 0.
        """
        return pulumi.get(self, "origin_version")

    @origin_version.setter
    def origin_version(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "origin_version", value)

    @_builtins.property
    @pulumi.getter(name="siteId")
    def site_id(self) -> pulumi.Input[_builtins.int]:
        """
        The site ID, which can be obtained by calling the ListSites API.
        """
        return pulumi.get(self, "site_id")

    @site_id.setter
    def site_id(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "site_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Site version's description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)


@pulumi.input_type
class _VersionState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 origin_version: Optional[pulumi.Input[_builtins.int]] = None,
                 site_id: Optional[pulumi.Input[_builtins.int]] = None,
                 site_version: Optional[pulumi.Input[_builtins.int]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Version resources.
        :param pulumi.Input[_builtins.str] create_time: The creation time. The date format follows ISO8601 notation and uses UTC time. The format is yyyy-MM-ddTHH:mm:ssZ.
        :param pulumi.Input[_builtins.str] description: The Site version's description.
        :param pulumi.Input[_builtins.int] origin_version: The version number of the site configuration. For sites that have enabled configuration version management, this parameter can be used to specify the effective version of the configuration site, which defaults to version 0.
        :param pulumi.Input[_builtins.int] site_id: The site ID, which can be obtained by calling the ListSites API.
        :param pulumi.Input[_builtins.int] site_version: The version number of the site configuration.
        :param pulumi.Input[_builtins.str] status: Site version status:：`online`.：`configuring`._faild`：`configure_faild`.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if origin_version is not None:
            pulumi.set(__self__, "origin_version", origin_version)
        if site_id is not None:
            pulumi.set(__self__, "site_id", site_id)
        if site_version is not None:
            pulumi.set(__self__, "site_version", site_version)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation time. The date format follows ISO8601 notation and uses UTC time. The format is yyyy-MM-ddTHH:mm:ssZ.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Site version's description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="originVersion")
    def origin_version(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The version number of the site configuration. For sites that have enabled configuration version management, this parameter can be used to specify the effective version of the configuration site, which defaults to version 0.
        """
        return pulumi.get(self, "origin_version")

    @origin_version.setter
    def origin_version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "origin_version", value)

    @_builtins.property
    @pulumi.getter(name="siteId")
    def site_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The site ID, which can be obtained by calling the ListSites API.
        """
        return pulumi.get(self, "site_id")

    @site_id.setter
    def site_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "site_id", value)

    @_builtins.property
    @pulumi.getter(name="siteVersion")
    def site_version(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The version number of the site configuration.
        """
        return pulumi.get(self, "site_version")

    @site_version.setter
    def site_version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "site_version", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Site version status:：`online`.：`configuring`._faild`：`configure_faild`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.type_token("alicloud:esa/version:Version")
class Version(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 origin_version: Optional[pulumi.Input[_builtins.int]] = None,
                 site_id: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Provides a ESA Site Version resource.

        For information about ESA Site Version and how to use it, see [What is Site Version](https://next.api.alibabacloud.com/document/ESA/2024-09-10/CloneVersion).

        > **NOTE:** Available since v1.251.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "bcd72239.com"
        default = alicloud.esa.get_sites(plan_subscribe_type="enterpriseplan")
        default_site = alicloud.esa.Site("default",
            site_name=name,
            instance_id=default.sites[0].instance_id,
            coverage="overseas",
            access_type="NS",
            version_management=True)
        default_version = alicloud.esa.Version("default",
            site_id=default_site.id,
            description="example",
            origin_version=0)
        ```

        ## Import

        ESA Site Version can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:esa/version:Version example <site_id>:<site_version>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: The Site version's description.
        :param pulumi.Input[_builtins.int] origin_version: The version number of the site configuration. For sites that have enabled configuration version management, this parameter can be used to specify the effective version of the configuration site, which defaults to version 0.
        :param pulumi.Input[_builtins.int] site_id: The site ID, which can be obtained by calling the ListSites API.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VersionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a ESA Site Version resource.

        For information about ESA Site Version and how to use it, see [What is Site Version](https://next.api.alibabacloud.com/document/ESA/2024-09-10/CloneVersion).

        > **NOTE:** Available since v1.251.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "bcd72239.com"
        default = alicloud.esa.get_sites(plan_subscribe_type="enterpriseplan")
        default_site = alicloud.esa.Site("default",
            site_name=name,
            instance_id=default.sites[0].instance_id,
            coverage="overseas",
            access_type="NS",
            version_management=True)
        default_version = alicloud.esa.Version("default",
            site_id=default_site.id,
            description="example",
            origin_version=0)
        ```

        ## Import

        ESA Site Version can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:esa/version:Version example <site_id>:<site_version>
        ```

        :param str resource_name: The name of the resource.
        :param VersionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VersionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 origin_version: Optional[pulumi.Input[_builtins.int]] = None,
                 site_id: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VersionArgs.__new__(VersionArgs)

            __props__.__dict__["description"] = description
            if origin_version is None and not opts.urn:
                raise TypeError("Missing required property 'origin_version'")
            __props__.__dict__["origin_version"] = origin_version
            if site_id is None and not opts.urn:
                raise TypeError("Missing required property 'site_id'")
            __props__.__dict__["site_id"] = site_id
            __props__.__dict__["create_time"] = None
            __props__.__dict__["site_version"] = None
            __props__.__dict__["status"] = None
        super(Version, __self__).__init__(
            'alicloud:esa/version:Version',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            origin_version: Optional[pulumi.Input[_builtins.int]] = None,
            site_id: Optional[pulumi.Input[_builtins.int]] = None,
            site_version: Optional[pulumi.Input[_builtins.int]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None) -> 'Version':
        """
        Get an existing Version resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] create_time: The creation time. The date format follows ISO8601 notation and uses UTC time. The format is yyyy-MM-ddTHH:mm:ssZ.
        :param pulumi.Input[_builtins.str] description: The Site version's description.
        :param pulumi.Input[_builtins.int] origin_version: The version number of the site configuration. For sites that have enabled configuration version management, this parameter can be used to specify the effective version of the configuration site, which defaults to version 0.
        :param pulumi.Input[_builtins.int] site_id: The site ID, which can be obtained by calling the ListSites API.
        :param pulumi.Input[_builtins.int] site_version: The version number of the site configuration.
        :param pulumi.Input[_builtins.str] status: Site version status:：`online`.：`configuring`._faild`：`configure_faild`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VersionState.__new__(_VersionState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["origin_version"] = origin_version
        __props__.__dict__["site_id"] = site_id
        __props__.__dict__["site_version"] = site_version
        __props__.__dict__["status"] = status
        return Version(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The creation time. The date format follows ISO8601 notation and uses UTC time. The format is yyyy-MM-ddTHH:mm:ssZ.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Site version's description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="originVersion")
    def origin_version(self) -> pulumi.Output[_builtins.int]:
        """
        The version number of the site configuration. For sites that have enabled configuration version management, this parameter can be used to specify the effective version of the configuration site, which defaults to version 0.
        """
        return pulumi.get(self, "origin_version")

    @_builtins.property
    @pulumi.getter(name="siteId")
    def site_id(self) -> pulumi.Output[_builtins.int]:
        """
        The site ID, which can be obtained by calling the ListSites API.
        """
        return pulumi.get(self, "site_id")

    @_builtins.property
    @pulumi.getter(name="siteVersion")
    def site_version(self) -> pulumi.Output[_builtins.int]:
        """
        The version number of the site configuration.
        """
        return pulumi.get(self, "site_version")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Site version status:：`online`.：`configuring`._faild`：`configure_faild`.
        """
        return pulumi.get(self, "status")

